/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentCheckFacadeFactory;
import com.kingdee.eas.fi.gl.IAcctCussentCheckFacade;
import com.kingdee.eas.fi.gl.client.AbstractAuditCancelFilterPanel;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.UIUtil;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.gl.rpt.client.GeneralBizPromptBox;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;

public class AuditCancelFilterPanel
extends AbstractAuditCancelFilterPanel {
    private static final long serialVersionUID = -4596908233852466210L;
    private CurrencyInfo localCur;
    private CompanyOrgUnitInfo curCompany;
    String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.AcctCussentCheck";
    public static final String COLUMN_SELECTED = "selected";
    public static final String COLUMN_TYPE = "type";
    public static final String COLUMN_FROM = "from";
    public static final String COLUMN_TO = "to";
    public static final String COLUMN_DIST = "dist";
    public static final String COLUMN_PROPERTYNAME = "propertyName";
    public static final String ITEM_VALUEINFOFROM = "valueInfoFrom";
    public static final String ITEM_VALUEINFOTO = "valueInfoTo";
    public static final String ITEM_NUMBERFROM = "numberfrom";
    public static final String ITEM_NUMBERTO = "numberto";
    public static final String RESULT_ITEMS = "items";
    public static final String RESULT_CURRENCY = "currency";
    public static final String RESULT_BIZDATEFROM = "bizDateFrom";
    public static final String RESULT_BIZDATETO = "bizDateTo";
    public static final String RESULT_ACCOUNT = "account";
    private DataChangeListener myDataChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            AuditCancelFilterPanel.this.accountChanged(eventObj.getOldValue(), eventObj.getNewValue());
        }
    };
    AccountViewInfo currentAccount = null;
    ArrayList currentItems = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.refreshItem(true);
        this.afterOnLoad();
    }

    protected void afterOnLoad() {
        if (this.tblAsstItem.getRowCount() > 0) {
            this.tblAsstItem.getColumn("COLUMN_SELECTED");
        }
    }

    public void initData(boolean isFromVoucher) throws Exception {
        this.tblAsstItem.checkParsed();
        if (this.getCurCompany() == null) {
            this.setCurCompany(InitClientHelp.getCurrentCompany());
        }
        ICurrency curCtrl = CurrencyFactory.getRemoteInstance();
        CurrencyCollection col = curCtrl.getCurrencyCollection(true);
        for (int i = 0; i < col.size(); ++i) {
            CurrencyInfo temp = col.get(i);
            if (temp.isGeneralLocalCurrency() || temp.isGeneralReportCurrency()) continue;
            this.comboCurrency.addItem((Object)temp);
            if (!temp.getId().toString().equals(this.getCurCompany().getBaseCurrency().getId().toString())) continue;
            this.localCur = temp;
        }
        if (this.localCur != null) {
            this.comboCurrency.setSelectedItem((Object)this.localCur);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.getCurCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("AccountTableID.id", (Object)this.getCurCompany().getAccountTable().getId().toString()));
        filter.setMaskString("#0 and #1 and #2 and #3");
        this.pbAccount.setEditable(true);
        this.pbAccount.setEditFormat("$number$");
        this.pbAccount.setCommitFormat("$number$");
        this.pbAccount.setDisplayFormat("$number$ - $name$");
        this.pbAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbAccount.setEntityViewInfo(view);
        this.pbAccount.addDataChangeListener(this.myDataChangeListener);
        this.pbAccount.setEnabledMultiSelection(true);
        this.pbAccount.setCommitParser((IParser)new AccountViewParser(this.pbAccount));
        AccountPromptBox acctF7 = new AccountPromptBox((IUIObject)this, this.getCurCompany(), this.getCurCompany().getAccountTable(), filter, false, true);
        this.pbAccount.setSelector((KDPromptSelector)acctF7);
        this.pbAccount.setValue((Object)this.currentAccount);
        this.tblAsstItem.getSelectManager().setSelectMode(2);
        InitClientHelp.setTableKeyBoardManager(this.tblAsstItem);
        KDCheckBox cb = new KDCheckBox();
        KDTDefaultCellEditor cbEditor = new KDTDefaultCellEditor((JCheckBox)cb);
        this.tblAsstItem.getColumn(COLUMN_SELECTED).setEditor((ICellEditor)cbEditor);
        this.tblAsstItem.getColumn(COLUMN_TYPE).getStyleAttributes().setLocked(true);
        ObjectValueRender asstRender = new ObjectValueRender();
        asstRender.setFormat(new IDataFormat(){

            public String format(Object object) {
                StringBuffer ret = new StringBuffer();
                if (object.getClass().isArray()) {
                    Object[] os = (Object[])object;
                    for (int i = 0; i < os.length; ++i) {
                        if (i > 0) {
                            ret.append("; ");
                        }
                        ret.append(((IObjectValue)os[i]).toString());
                    }
                    return ret.toString();
                }
                return object.toString();
            }
        });
        this.tblAsstItem.getColumn(COLUMN_FROM).setRenderer((IBasicRender)asstRender);
        if (!isFromVoucher) {
            this.dpBusiDateTo.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    Date date = (Date)AuditCancelFilterPanel.this.dpBusiDateTo.getValue();
                    if (date == null) {
                        return;
                    }
                    int yearEnd = date.getYear() + 1900;
                    int numberEnd = date.getMonth() + 1;
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("AC", (Object)Boolean.TRUE));
                    RptClientUtil.periodChanged((IUIObject)AuditCancelFilterPanel.this, AuditCancelFilterPanel.this.getCurCompany(), filter, yearEnd, numberEnd, AuditCancelFilterPanel.this.pbAccount, AuditCancelFilterPanel.this.pbAccount);
                }
            });
        }
    }

    private void accountChanged(Object oldValue, Object newValue) {
        try {
            this.refreshItem(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void refreshItem(boolean isfirst) throws Exception {
        IAcctCussentCheckFacade facade = AcctCussentCheckFacadeFactory.getRemoteInstance();
        ArrayList acctItems = null;
        if (isfirst) {
            this.tblAsstItem.removeRows();
            this.currentItems = facade.getAsstItemType(null, this.getCurCompany().getId().toString());
            for (Object item : this.currentItems) {
                IRow row = this.tblAsstItem.addRow();
                row.getCell(COLUMN_SELECTED).setValue((Object)Boolean.FALSE);
                row.getCell(COLUMN_TYPE).setValue(((HashMap)item).get("name"));
                KDBizPromptBox bizPromptBoxFrom = new KDBizPromptBox();
                bizPromptBoxFrom.setEditable(true);
                bizPromptBoxFrom.setEditFormat("$number$");
                bizPromptBoxFrom.setDisplayFormat("$number$ - $name$");
                bizPromptBoxFrom.setQueryInfo((String)((HashMap)item).get("queryname"));
                KDBizPromptBox bizPromptBoxTo = new KDBizPromptBox();
                bizPromptBoxTo.setEditable(true);
                bizPromptBoxTo.setEditFormat("$number$");
                bizPromptBoxTo.setDisplayFormat("$number$ - $name$");
                bizPromptBoxTo.setQueryInfo((String)((HashMap)item).get("queryname"));
                AsstActTypeInfo atInfo = new AsstActTypeInfo();
                atInfo.setAsstHGAttribute(((HashMap)item).get("propname").toString());
                atInfo.setIsForCompany(((Boolean)((HashMap)item).get("isforcompany")).booleanValue());
                atInfo.setUseLongNumber(((Boolean)((HashMap)item).get("useLongNUmber")).booleanValue());
                GLF7Parameter f7Param = new GLF7Parameter();
                f7Param.setUnUse(true);
                f7Param.setOnlyLeaf(true);
                f7Param.setRow(row);
                f7Param.setTable(this.tblAsstItem);
                if (((HashMap)item).get("glgroup") != null) {
                    GeneralAsstActTypeGroupInfo groupInfo = new GeneralAsstActTypeGroupInfo();
                    groupInfo.setId(BOSUuid.read((String)((HashMap)item).get("glgroup").toString()));
                    atInfo.setGlAsstActTypeGrp(groupInfo);
                    f7Param.setGeneralShowLongNumber(((Boolean)((HashMap)item).get("useLongNUmber")).booleanValue());
                }
                this.getUIContext().put("COMPANY", this.getCurCompany());
                GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBoxFrom, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.getCurCompany(), (GLF7Parameter)f7Param);
                GLF7handler.assignSelector((CoreUIObject)this, (KDBizPromptBox)bizPromptBoxTo, (AsstActTypeInfo)atInfo, (CompanyOrgUnitInfo)this.getCurCompany(), (GLF7Parameter)f7Param);
                bizPromptBoxFrom.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent e) {
                        try {
                            int beginRow = AuditCancelFilterPanel.this.tblAsstItem.getSelectManager().get().getBeginRow();
                            IRow row = AuditCancelFilterPanel.this.tblAsstItem.getRow(beginRow);
                            UIUtil.fireFromChange(e, AuditCancelFilterPanel.this.tblAsstItem, row);
                        }
                        catch (Exception exc) {
                            AuditCancelFilterPanel.this.handUIException(exc);
                        }
                    }
                });
                bizPromptBoxTo.addDataChangeListener(new DataChangeListener(){

                    public void dataChanged(DataChangeEvent e) {
                        try {
                            int beginRow = AuditCancelFilterPanel.this.tblAsstItem.getSelectManager().get().getBeginRow();
                            IRow row = AuditCancelFilterPanel.this.tblAsstItem.getRow(beginRow);
                            UIUtil.fireToChange(e, AuditCancelFilterPanel.this.tblAsstItem, row);
                        }
                        catch (Exception exc) {
                            AuditCancelFilterPanel.this.handUIException(exc);
                        }
                    }
                });
                KDTDefaultCellEditor editorFrom = new KDTDefaultCellEditor((IKDEditor)bizPromptBoxFrom);
                KDTDefaultCellEditor editorTo = new KDTDefaultCellEditor((IKDEditor)bizPromptBoxTo);
                row.getCell(COLUMN_FROM).setEditor((ICellEditor)editorFrom);
                row.getCell(COLUMN_TO).setEditor((ICellEditor)editorTo);
                row.getCell(COLUMN_PROPERTYNAME).setValue(((HashMap)item).get("propname"));
                this.loadDistBox(row, bizPromptBoxFrom, null);
                row.setUserObject(item);
            }
        } else {
            Object o = this.pbAccount.getValue();
            Object acctViews = null;
            HashSet accitemnames = new HashSet();
            String caas = "!_";
            HashSet<String> actIds = new HashSet<String>();
            if (o instanceof Object[]) {
                Object[] accts = (Object[])o;
                if (accts.length > 0) {
                    for (int i = 0; i < accts.length; ++i) {
                        if (accts[i] == null) {
                            return;
                        }
                        AccountViewInfo act = (AccountViewInfo)accts[i];
                        String temp = act.getCAA().getId().toString();
                        actIds.add(temp);
                    }
                }
                String acts = ((Object)actIds).toString().replace("[", "").replace("]", "");
                acctItems = facade.getAsstItemType(caas + acts, this.getCurCompany().getId().toString());
            }
        }
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            row.getCell(COLUMN_SELECTED).setValue((Object)false);
        }
        if (acctItems != null && acctItems.size() > 0) {
            for (Object item : acctItems) {
                for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
                    IRow row = this.tblAsstItem.getRow(i);
                    if (!((String)item).equals(row.getCell(COLUMN_PROPERTYNAME).getValue())) continue;
                    row.getCell(COLUMN_SELECTED).setValue((Object)true);
                }
            }
        }
    }

    public KDBizPromptBox loadDistBox(IRow row, KDBizPromptBox bizBox, EntityViewInfo view) {
        KDBizPromptBox disBox = new KDBizPromptBox();
        disBox.setEditFormat("$number$");
        disBox.setDisplayFormat("$name$");
        disBox.setCommitFormat("$number$");
        disBox.setEditable(false);
        disBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    int beginRow = AuditCancelFilterPanel.this.tblAsstItem.getSelectManager().get().getBeginRow();
                    IRow row = AuditCancelFilterPanel.this.tblAsstItem.getRow(beginRow);
                    Object dist = e.getNewValue();
                    if (dist == null) {
                        Map entry = (Map)row.getUserObject();
                        entry.put(AuditCancelFilterPanel.COLUMN_DIST, null);
                        row.getCell(AuditCancelFilterPanel.COLUMN_DIST).setUserObject(null);
                    }
                }
                catch (Exception exc) {
                    AuditCancelFilterPanel.this.handUIException(exc);
                }
            }
        });
        if (view == null && (view = bizBox.getEntityViewInfo()) != null) {
            view = (EntityViewInfo)view.clone();
            view = this.getDefaultView(row, view);
        }
        disBox.setEntityViewInfo(view);
        disBox.setSelector((KDPromptSelector)new GeneralBizPromptBox(view, bizBox.getQueryInfo(), this.tblAsstItem, "com.kingdee.eas.fi.gl.rpt.client.FilterForAssistF7UI"));
        row.getCell(COLUMN_DIST).setValue(null);
        row.getCell(COLUMN_DIST).setUserObject(null);
        row.getCell(COLUMN_DIST).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)disBox));
        return disBox;
    }

    private EntityViewInfo getDefaultView(IRow row, EntityViewInfo view) {
        Object to;
        if (view == null || view.getFilter() == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = view.getFilter();
        FilterInfo newFilter = new FilterInfo();
        Object from = row.getCell(COLUMN_FROM).getValue();
        if (from != null && from instanceof IObjectValue) {
            if (from instanceof GeneralAsstActTypeInfo) {
                newFilter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)((IObjectValue)from).get("longnumber").toString().replace("!", "."), CompareType.GREATER_EQUALS));
            } else {
                newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)from).get("number"), CompareType.GREATER_EQUALS));
            }
        }
        if ((to = row.getCell(COLUMN_TO).getValue()) != null && to instanceof IObjectValue) {
            if (to instanceof GeneralAsstActTypeInfo) {
                newFilter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)((IObjectValue)to).get("longnumber").toString().replace("!", "."), CompareType.LESS_EQUALS));
            } else {
                newFilter.getFilterItems().add(new FilterItemInfo("number", ((IObjectValue)to).get("number"), CompareType.LESS_EQUALS));
            }
        }
        try {
            newFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        view.setFilter(newFilter);
        return view;
    }

    @Override
    protected void tblAsstItem_editStopped(KDTEditEvent e) throws Exception {
    }

    public boolean verify() {
        Date dateFrom = null;
        if (this.dpBusiDateFrom.getValue() != null) {
            dateFrom = InitClientHelp.convertToSimpleDate((Date)this.dpBusiDateFrom.getValue());
        }
        Date dateTo = null;
        if (this.dpBusiDateTo.getValue() != null) {
            dateTo = InitClientHelp.convertToSimpleDate((Date)this.dpBusiDateTo.getValue());
        }
        if (dateFrom != null && dateTo != null && dateFrom.after(dateTo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_PATH, (String)"bizdatereverse"));
            return false;
        }
        boolean hasSelected = false;
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(COLUMN_SELECTED).getValue())) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_PATH, (String)"noitem"));
            return false;
        }
        return true;
    }

    public HashMap getResult() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<HashMap> items = new ArrayList<HashMap>();
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            Object dist;
            int j;
            String ids;
            String nums;
            Object obj;
            IRow row = this.tblAsstItem.getRow(i);
            HashMap item = (HashMap)row.getUserObject();
            if (row.getCell(COLUMN_SELECTED).getValue().equals(Boolean.FALSE)) continue;
            String[] numbers = new String[3];
            Object from = row.getCell(COLUMN_FROM).getValue();
            Object to = row.getCell(COLUMN_TO).getValue();
            String itemFromId = null;
            String itemToId = null;
            String numberField = "number";
            if (item.get("propname").toString().startsWith("generalAssActType")) {
                numberField = "longnumber";
                item.put("useLongNumber", true);
            }
            Object[] objs = null;
            if (from != null) {
                if (from instanceof Object[]) {
                    objs = (Object[])from;
                    obj = null;
                    nums = "";
                    ids = "";
                    for (j = 0; j < objs.length; ++j) {
                        obj = objs[j];
                        if (obj != null && obj instanceof IObjectValue) {
                            nums = nums + (String)((IObjectValue)obj).get(numberField) + ",";
                            ids = ids + ((IObjectValue)obj).get("id").toString() + "','";
                            continue;
                        }
                        nums = nums + (String)obj + ",";
                    }
                    nums = nums.substring(0, nums.length() - 1);
                    ids = ids.substring(0, ids.length() - 3);
                    numbers[0] = nums;
                    itemFromId = ids;
                } else if (from instanceof IObjectValue) {
                    numbers[0] = (String)((IObjectValue)from).get(numberField);
                    itemFromId = ((IObjectValue)from).get("id").toString();
                } else {
                    numbers[0] = (String)from;
                }
            }
            if (to != null) {
                if (to instanceof Object[]) {
                    objs = (Object[])to;
                    obj = null;
                    nums = "";
                    ids = "";
                    for (j = 0; j < objs.length; ++j) {
                        obj = objs[j];
                        if (obj != null && obj instanceof IObjectValue) {
                            nums = nums + (String)((IObjectValue)obj).get(numberField) + ",";
                            ids = ids + ((IObjectValue)obj).get("id").toString() + "','";
                            continue;
                        }
                        nums = nums + (String)obj + ",";
                    }
                    nums = nums.substring(0, nums.length() - 1);
                    ids = ids.substring(0, ids.length() - 3);
                    numbers[0] = nums;
                    itemToId = ids;
                } else if (to instanceof IObjectValue) {
                    numbers[1] = (String)((IObjectValue)to).get(numberField);
                    itemToId = ((IObjectValue)to).get("id").toString();
                } else {
                    numbers[1] = (String)to;
                }
            }
            if ((dist = row.getCell(COLUMN_DIST).getUserObject()) instanceof HashSet) {
                Iterator it = ((HashSet)dist).iterator();
                AssistViewFilterInfo avf = null;
                StringBuilder distNumbers = new StringBuilder();
                while (it.hasNext()) {
                    avf = (AssistViewFilterInfo)it.next();
                    distNumbers.append(avf.getNumber()).append(",");
                }
                numbers[2] = distNumbers.toString();
            }
            if (itemFromId != null && itemFromId.equals(itemToId)) {
                item.put("itemId", itemFromId);
            } else {
                item.put("itemId", null);
            }
            item.put(ITEM_VALUEINFOFROM, from);
            item.put(ITEM_VALUEINFOTO, to);
            item.put(ITEM_NUMBERFROM, numbers[0]);
            item.put(ITEM_NUMBERTO, numbers[1]);
            item.put("distNumber", numbers[2]);
            item.put(COLUMN_DIST, dist);
            items.add(item);
        }
        result.put("COMPANY", this.getCurCompany());
        result.put(RESULT_ITEMS, items);
        result.put(RESULT_CURRENCY, this.comboCurrency.getSelectedItem());
        result.put(RESULT_BIZDATEFROM, (Date)this.dpBusiDateFrom.getValue());
        result.put(RESULT_BIZDATETO, (Date)this.dpBusiDateTo.getValue());
        result.put(RESULT_ACCOUNT, this.pbAccount.getValue());
        result.put("isNumDateOrder", this.radioNumDateSeq.isSelected());
        if (this.txtBizNumber.getText() != null && !"".equals(this.txtBizNumber.getText())) {
            result.put("bizNumber", "%" + this.txtBizNumber.getText() + "%");
        }
        result.put(ParamKey.EXCLUDEUNPOSTVCH, this.chkNotIncludeUnpostVch.isSelected());
        return result;
    }

    public Object getParam() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put(ParamKey.CURRENCYID, ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        Date dateFrom = (Date)this.dpBusiDateFrom.getValue();
        result.put(ParamKey.BIZDATEFROM, dateFrom);
        Date dateTo = (Date)this.dpBusiDateTo.getValue();
        result.put(ParamKey.BIZDATETO, dateTo);
        result.put(ParamKey.ACCOUNT, this.pbAccount.getValue());
        result.put(ParamKey.BIZNUMBER, this.txtBizNumber.getText());
        result.put(ParamKey.ISNUMDATEORDER, this.radioNumDateSeq.isSelected());
        result.put(ParamKey.EXCLUDEUNPOSTVCH, this.chkNotIncludeUnpostVch.isSelected());
        HashMap items = new HashMap();
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            HashMap item = (HashMap)row.getUserObject();
            if (row.getCell(COLUMN_SELECTED).getValue().equals(Boolean.FALSE)) continue;
            Object[] numbers = new Object[3];
            Object from = row.getCell(COLUMN_FROM).getValue();
            Object to = row.getCell(COLUMN_TO).getValue();
            Object distStr = row.getCell(COLUMN_DIST).getValue();
            Object dist = row.getCell(COLUMN_DIST).getUserObject();
            if (from != null) {
                numbers[0] = from;
            }
            if (to != null) {
                numbers[1] = to;
            }
            if (distStr != null) {
                numbers[2] = distStr;
            }
            items.put(item.get("id"), numbers);
            items.put(item.get("id") + "_dist", dist);
        }
        result.put(ParamKey.ITEMS, items);
        return result;
    }

    public void setParam(Object param) {
        Object exclueUnpostVch;
        Map result = (Map)param;
        if (result == null) {
            return;
        }
        String currencyId = (String)result.get(ParamKey.CURRENCYID);
        for (int i = 0; i < this.comboCurrency.getItemCount(); ++i) {
            CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getItemAt(i);
            if (!info.getId().toString().equals(currencyId)) continue;
            this.comboCurrency.setSelectedIndex(i);
            break;
        }
        Date beginDate = (Date)result.get(ParamKey.BIZDATEFROM);
        this.dpBusiDateFrom.setValue((Object)beginDate);
        Date endDate = (Date)result.get(ParamKey.BIZDATETO);
        this.dpBusiDateTo.setValue((Object)endDate);
        this.pbAccount.setValue(result.get(ParamKey.ACCOUNT));
        Object objBizNumber = result.get(ParamKey.BIZNUMBER);
        if (objBizNumber != null) {
            this.txtBizNumber.setText(objBizNumber.toString());
        }
        if (Boolean.TRUE.equals(exclueUnpostVch = result.get(ParamKey.EXCLUDEUNPOSTVCH))) {
            this.chkNotIncludeUnpostVch.setSelected(true);
        } else {
            this.chkNotIncludeUnpostVch.setSelected(false);
        }
        Map items = (Map)result.get(ParamKey.ITEMS);
        if (items != null) {
            for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
                IRow row = this.tblAsstItem.getRow(i);
                HashMap userObject = (HashMap)row.getUserObject();
                Iterator iter = items.keySet().iterator();
                boolean isSelect = false;
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    if (!id.equals(userObject.get("id"))) continue;
                    isSelect = true;
                    Object[] numbers = (Object[])items.get(id);
                    row.getCell(COLUMN_FROM).setValue(numbers[0]);
                    row.getCell(COLUMN_TO).setValue(numbers[1]);
                    if (numbers.length == 3) {
                        row.getCell(COLUMN_DIST).setValue(numbers[2]);
                    }
                    Object dist = items.get(id + "_dist");
                    row.getCell(COLUMN_DIST).setUserObject(dist);
                }
                row.getCell(COLUMN_SELECTED).setValue((Object)isSelect);
                row.getCell(COLUMN_PROPERTYNAME).setValue(userObject.get("propname"));
            }
        }
        if (result.get(ParamKey.ISNUMDATEORDER) != null) {
            Boolean isNumDateOrder = (Boolean)result.get(ParamKey.ISNUMDATEORDER);
            if (isNumDateOrder.booleanValue()) {
                this.radioNumDateSeq.setSelected(true);
            } else {
                this.radioDateNumSeq.setSelected(true);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (cp == null) {
            return;
        }
    }

    public void clear() {
        this.pbAccount.setValue(null);
        this.comboCurrency.setSelectedItem((Object)this.localCur);
        this.radioNumDateSeq.setSelected(true);
        this.txtBizNumber.setText("");
        this.clearAsst();
    }

    private void clearAsst() {
        for (int i = 0; i < this.tblAsstItem.getRowCount(); ++i) {
            IRow row = this.tblAsstItem.getRow(i);
            Boolean selected = (Boolean)row.getCell(COLUMN_SELECTED).getValue();
            if (selected == null || !selected.booleanValue()) continue;
            row.getCell(COLUMN_SELECTED).setValue((Object)Boolean.FALSE);
            row.getCell(COLUMN_FROM).setValue(null);
            row.getCell(COLUMN_TO).setValue(null);
            row.getCell(COLUMN_DIST).setValue(null);
            row.getCell(COLUMN_DIST).setUserObject(null);
        }
    }

    private void lockAsstCell(IRow row) {
        row.getCell(COLUMN_FROM).getStyleAttributes().setLocked(true);
        row.getCell(COLUMN_FROM).setEditor(null);
        row.getCell(COLUMN_TO).getStyleAttributes().setLocked(true);
        row.getCell(COLUMN_TO).setEditor(null);
        row.getCell(COLUMN_DIST).getStyleAttributes().setLocked(true);
        row.getCell(COLUMN_DIST).setEditor(null);
    }

    public void setCurCompany(CompanyOrgUnitInfo company) {
        this.curCompany = company;
    }

    public CompanyOrgUnitInfo getCurCompany() {
        return this.curCompany;
    }

    private static final class ParamKey {
        static String CURRENCYID = "currencyId";
        static String ACCOUNT = "account";
        static String ITEMS = "items";
        static String BIZDATEFROM = "bizDateFrom";
        static String BIZDATETO = "bizDateTo";
        static Boolean ISNUMDATEORDER = Boolean.TRUE;
        static String EXCLUDEUNPOSTVCH = "notIncludeUnpostVch";
        static String BIZNUMBER = "bizNumber";

        private ParamKey() {
        }
    }
}

