/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.LocaleUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.AuditOpinionCollection;
import com.kingdee.eas.fi.gl.AuditOpinionFactory;
import com.kingdee.eas.fi.gl.AuditOpinionInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAuditOpinion;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractAuditOpinionUI;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AuditOpinionUI
extends AbstractAuditOpinionUI {
    private static final Logger logger = CoreUIObject.getLogger(AuditOpinionUI.class);
    public static final String VOUCHER = "VOUCHER";
    protected VoucherInfo vch;
    private String vchID;
    boolean isView;
    String type;
    String auditOpinionID = "";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void fetchInitData() throws GLException {
        Map ctx = this.getUIContext();
        this.vchID = (String)ctx.get(VOUCHER);
        this.isView = (Boolean)ctx.get("ISVIEW");
        this.type = (String)ctx.get("TYPE");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.fetchInitData();
        this.txtAuditorname.setEditable(false);
        this.pkAuditBackTime.setEditable(false);
        this.pkAuditBackTime.setEnabled(false);
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.txtAuditorname.setStringValue(SysContext.getSysContext().getCurrentUserInfo().getName());
        AuditOpinionInfo aoinfo = new AuditOpinionInfo();
        this.auditOpinionID = "";
        if (this.vchID != null) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("auditorName"));
            view.getSelector().add(new SelectorItemInfo("content"));
            view.getSelector().add(new SelectorItemInfo("auditBackTime"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucherid", (Object)this.vchID));
            view.setFilter(filter);
            AuditOpinionCollection auditOpinionCollection = AuditOpinionFactory.getRemoteInstance().getAuditOpinionCollection(view);
            if (auditOpinionCollection.size() > 0) {
                aoinfo = auditOpinionCollection.get(0);
                this.auditOpinionID = aoinfo.getId().toString();
            }
        }
        this.loadAuditOpinion(aoinfo);
        if (this.isView) {
            this.txtContent.setEditable(false);
            this.btnUnAuditBack.setVisible(this.type.equals("AUDITBACK"));
            this.btnUnAuditBack.setEnabled(this.type.equals("AUDITBACK"));
        }
    }

    private void loadAuditOpinion(AuditOpinionInfo aoinfo) {
        if (aoinfo.getAuditorname() != null) {
            this.txtAuditorname.setStringValue(aoinfo.getAuditorname());
            this.pkAuditBackTime.setValue((Object)aoinfo.getAuditBackTime());
        }
        Locale thisLocal = this.getLocale() == null ? null : LocaleUtil.getEasLocale((Locale)this.getLocale());
        int i = 0;
        while (true) {
            AuditOpinionUI auditOpinionUI = this;
            if (i >= auditOpinionUI.txtContent.getLanguageList().size()) break;
            AuditOpinionUI auditOpinionUI2 = this;
            LanguageInfo lan = (LanguageInfo)auditOpinionUI2.txtContent.getLanguageList().get(i);
            this.txtContent.setItemData(lan, (Object)aoinfo.getContent(lan.getLocale()));
            if (thisLocal != null && lan != null && thisLocal.equals(lan.getLocale())) {
                this.txtContent.setSelectedLanguage(lan);
            }
            ++i;
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isView) {
            super.destroyWindow();
            return;
        }
        IAuditOpinion ctrl = AuditOpinionFactory.getRemoteInstance();
        AuditOpinionInfo auditOpinion = new AuditOpinionInfo();
        auditOpinion.setAuditBackTime(GlUtils.getServerDate());
        int i = 0;
        while (true) {
            AuditOpinionUI auditOpinionUI = this;
            if (i >= auditOpinionUI.txtContent.getLanguageList().size()) break;
            AuditOpinionUI auditOpinionUI2 = this;
            LanguageInfo lan = (LanguageInfo)auditOpinionUI2.txtContent.getLanguageList().get(i);
            UserInfo currentUserInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
            String auditor = currentUserInfo.getName(lan.getLocale());
            auditOpinion.setAuditorname(auditor, lan.getLocale());
            String content = this.txtContent.getItemDataByLang(lan).toString();
            auditOpinion.setContent(content, lan.getLocale());
            ++i;
        }
        auditOpinion.setVoucherid(this.vchID);
        if (this.vchID != null) {
            VoucherFactory.getRemoteInstance().auditBackVoucher((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.vchID)));
        }
        this.verifyInput(e);
        if (this.auditOpinionID.trim().length() == 0) {
            ctrl.addnew(auditOpinion);
        } else {
            auditOpinion.setId(BOSUuid.read((String)this.auditOpinionID));
            ctrl.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.auditOpinionID)), auditOpinion);
        }
        super.destroyWindow();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        List languageList = KDBizMultiLangArea.getLanguageList();
        for (int i = 0; languageList != null && i < languageList.size(); ++i) {
            LanguageInfo lang = (LanguageInfo)languageList.get(i);
            String content = this.txtContent.getItemDataByLang(lang).toString();
            if (content.length() <= 255) continue;
            this.txtContent.requestFocus(true);
            throw new VoucherException(VoucherException.CONTENT_TOO_LONG);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.destroyWindow();
    }

    @Override
    public void actionUnAuditBack_actionPerformed(ActionEvent e) throws Exception {
        VoucherFactory.getRemoteInstance().auditBackVoucher((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.vchID)));
        super.destroyWindow();
    }
}

