/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLACAuditCacelFacadeFactory;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.IGLACAuditCacelFacade;
import com.kingdee.eas.fi.gl.IGLFlag;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.ITransPLFacade;
import com.kingdee.eas.fi.gl.TransPLFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractAutoAuditCancelFilterUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.ACAuditCancelFilterHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AutoAuditCancelFilterUI
extends AbstractAutoAuditCancelFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoAuditCancelFilterUI.class);
    protected CompanyOrgUnitInfo curCompany;
    protected String curCompanyId;
    protected UserInfo curUser;
    protected PeriodInfo curPeriod;
    protected PeriodInfo acStratPeriod;
    protected PeriodInfo maxPeriod;
    private IGLPeriodEndFacade periodEndCtrl;
    private IGLACAuditCacelFacade acAuditCtrl;
    private GLPeriodEndFilter filterPeriodEnd;
    protected String acctTableId;
    private CurrencyInfo localCur;
    private static final String COLUMN_INDEX = "Index";
    private static final String COLUMN_ACCTID = "AcctID";
    private static final String COLUMN_ACCTNUMBER = "AcctNumber";
    private static final String COLUMN_ACCTNAME = "AcctName";
    private static final String COLUMN_YEARPROFITACCT = "YearProfitAcct";
    private static final String COLUMN_ISSELECT = "IsSelected";
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";
    private static final String VERIFY_RESOURCE = "com.kingdee.eas.fi.gl.VerifyResource";
    private static final String ACRESOURCE_PATH = "com.kingdee.eas.fi.gl.client.AcctCussentCheck";
    private static boolean isInTimeVerify = false;

    private void dpBusiDateTo_stateChanged(DataChangeEvent e) {
        Date bizDate = (Date)this.dpBusiDateTo.getValue();
        try {
            PeriodInfo _period = PeriodUtils.getPeriodInfo(null, (Date)bizDate, (CompanyOrgUnitInfo)this.curCompany);
            int _periodYear = _period == null ? bizDate.getYear() + 1900 : _period.getPeriodYear();
            int _periodNumber = _period == null ? (bizDate.getMonth() + 3) / 3 : _period.getPeriodNumber();
            this.acctTableId = AccountTools.getCurrentAcctTable(null, (String)this.curCompany.getId().toString(), (String)this.curCompany.getAccountTable().getId().toString(), (int)_periodYear, (int)_periodNumber);
            this.tblAccount.checkParsed();
            this.tblAccount.removeRows();
            Vector vec = new Vector();
            vec = this.acAuditCtrl.getAllACAcct(this.curCompanyId, this.acctTableId);
            int vecSize = vec.size();
            for (int i = 0; i < vecSize; ++i) {
                AccountViewInfo acct = (AccountViewInfo)vec.elementAt(i);
                IRow row = this.tblAccount.addRow();
                row.setUserObject((Object)acct);
                row.getCell(COLUMN_INDEX).setValue((Object)new Integer(i + 1));
                row.getCell(COLUMN_ACCTID).setValue((Object)acct.getId().toString());
                row.getCell(COLUMN_ACCTNUMBER).setValue((Object)acct.getNumber().toString());
                row.getCell(COLUMN_ACCTNAME).setValue((Object)acct.getName().toString());
                row.getCell(COLUMN_ISSELECT).setValue((Object)true);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            this.handleException((Exception)((Object)e1));
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getBizInterface();
        this.fetchInitData();
        this.afterOnLoad();
        this.chkAmtMustSame.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AutoAuditCancelFilterUI.this.chkAmtMustSame.isSelected()) {
                    AutoAuditCancelFilterUI.this.chkVerifySameByAmt.setEnabled(false);
                    AutoAuditCancelFilterUI.this.chkVerifySameByAmt.setSelected(false);
                } else {
                    AutoAuditCancelFilterUI.this.chkVerifySameByAmt.setEnabled(true);
                }
            }
        });
        this.chkVerifySameByAmt.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AutoAuditCancelFilterUI.this.chkVerifySameByAmt.isSelected()) {
                    AutoAuditCancelFilterUI.this.chkAmtMustSame.setEnabled(false);
                    AutoAuditCancelFilterUI.this.chkAmtMustSame.setSelected(false);
                } else {
                    AutoAuditCancelFilterUI.this.chkAmtMustSame.setEnabled(true);
                }
            }
        });
        this.dpBusiDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AutoAuditCancelFilterUI.this.dpBusiDateTo_stateChanged(eventObj);
            }
        });
        this.dpBusiDateTo_stateChanged(null);
    }

    protected void afterOnLoad() {
        this.loadFields();
    }

    public void initData() throws Exception {
        this.curCompany = InitClientHelp.getCurrentCompany();
        this.fillCurrency();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        Date beginDate = this.curPeriod.getBeginDate();
        this.dpBusiDateFrom.setValue((Object)beginDate);
        this.dpBusiDateFrom.setSupportedEmpty(false);
        Timestamp endDate = this.curPeriod.getEndDate();
        this.dpBusiDateTo.setValue((Object)endDate);
        this.dpBusiDateTo.setSupportedEmpty(false);
        this.dpBusiDateFrom.setMaximumDate((Date)this.maxPeriod.getEndDate());
        this.dpBusiDateTo.setMaximumDate((Date)this.maxPeriod.getEndDate());
        try {
            this.initData();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Override
    protected void chkUncheckBizNumber_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkUncheckBizNumber.isSelected()) {
            this.chkNullBizNumIsNotSame.setEnabled(false);
            this.chkNullBizNumIsNotSame.setSelected(false);
        } else {
            this.chkNullBizNumIsNotSame.setEnabled(true);
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.autoVerify();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
        SysUtil.abort();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblAccount.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblAccount.getRow(i).getCell(COLUMN_ISSELECT).setValue((Object)true);
        }
    }

    @Override
    protected void btnUnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblAccount.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblAccount.getRow(i).getCell(COLUMN_ISSELECT).setValue((Object)false);
        }
    }

    public boolean verify() {
        boolean hasSelected = false;
        for (int i = 0; i < this.tblAccount.getRowCount(); ++i) {
            IRow row = this.tblAccount.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(COLUMN_ISSELECT).getValue())) continue;
            hasSelected = true;
            break;
        }
        if (!hasSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)VERIFY_RESOURCE, (String)"Not_Select_Account"));
            return false;
        }
        return true;
    }

    private List getAccounts() throws Exception {
        ArrayList<Object> items = new ArrayList<Object>();
        for (int i = 0; i < this.tblAccount.getRowCount(); ++i) {
            Object o;
            IRow row = this.tblAccount.getRow(i);
            if (row.getCell(COLUMN_ISSELECT).getValue().equals(Boolean.FALSE) || (o = row.getUserObject()) == null || !(o instanceof AccountViewInfo)) continue;
            items.add(o);
        }
        return items;
    }

    public HashMap getResult() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List items = this.getAccounts();
        this.curCompany = InitClientHelp.getCurrentCompany();
        result.put("COMPANY", this.curCompany);
        result.put("LOCALCURRENCY", this.curCompany.getBaseCurrency());
        result.put("accts", items);
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.CURRENCY, this.comboCurrency.getSelectedItem());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.BIZDATETO, (Date)this.dpBusiDateTo.getValue());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.ISNUMDATEORDER, this.radioNumDateSeq.isSelected());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.UNCHECKBIZNUM, this.chkUncheckBizNumber.isSelected());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NULLBIZNUMISNOTSAME, this.chkNullBizNumIsNotSame.isSelected());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.EXCLUDEUNPOSTVCH, this.chkNotIncludeUnpostVch.isSelected());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYSAMEBYAMT, this.chkVerifySameByAmt.isSelected());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.VERIFYAMTMUSTSAME, this.chkAmtMustSame.isSelected());
        result.put(ACAuditCancelFilterHelper.ACAuditCancelParamKey.NEGATIVEVERIFY, this.negativeVerify.isSelected());
        return result;
    }

    protected IGLPeriodEndFacade getBizInterface() throws Exception {
        this.periodEndCtrl = GLPeriodEndFacadeFactory.getRemoteInstance();
        this.acAuditCtrl = GLACAuditCacelFacadeFactory.getRemoteInstance();
        return this.periodEndCtrl;
    }

    protected ITransPLFacade getTransPLFacade() throws Exception {
        return TransPLFacadeFactory.getRemoteInstance();
    }

    private void fetchInitData() throws EASBizException, Exception {
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.filterPeriodEnd = new GLPeriodEndFilter();
        this.filterPeriodEnd = this.periodEndCtrl.fetchInitData();
        this.curUser = this.filterPeriodEnd.getCurUser();
        this.curCompany = this.filterPeriodEnd.getCurCompany();
        this.curCompanyId = this.curCompany.getId().toString();
        if (this.acctTableId == null) {
            this.acctTableId = this.curCompany.getAccountTable().getId().toString();
        }
        this.curPeriod = this.filterPeriodEnd.getCurPeriod();
        HashMap hmGLParam = new HashMap();
        hmGLParam = this.filterPeriodEnd.getHmGLParam();
        if (!new Boolean((String)hmGLParam.get("GL_028")).booleanValue()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)VERIFY_RESOURCE, (String)"AcctCussent_Not_Start"));
            this.disposeUIWindow();
            SysUtil.abort();
        }
        int ctype = 0;
        if (hmGLParam.get("GL_052") != null) {
            ctype = Integer.parseInt(hmGLParam.get("GL_052").toString());
        }
        boolean bl = isInTimeVerify = ctype == 0;
        if (isInTimeVerify) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)VERIFY_RESOURCE, (String)"AutoVerify_Not_For_InTime"));
            this.disposeUIWindow();
            SysUtil.abort();
        }
        IGLFlag iGLFlag = GLFlagFactory.getRemoteInstance();
        iGLFlag.checkIfAllCussentInitClosed(this.curCompanyId, this.acctTableId);
        this.acStratPeriod = (PeriodInfo)hmGLParam.get("ACCTCUSSENT_STARTPERIOD");
        this.maxPeriod = (PeriodInfo)hmGLParam.get("MAX_PERIOD");
    }

    private void autoVerify() throws Exception {
        if (!this.verify()) {
            SysUtil.abort();
        }
        HashMap param = this.getResult();
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)VERIFY_RESOURCE, (String)"CONFIRM_AUTO_VERIFY")))) {
            SysUtil.abort();
        }
        this.acAuditCtrl.autoVerify(param);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)VERIFY_RESOURCE, (String)"VerifyOKCheckLog"));
        this.disposeUIWindow();
    }

    private void fillCurrency() throws Exception {
        ICurrency curCtrl = CurrencyFactory.getRemoteInstance();
        CurrencyCollection col = curCtrl.getCurrencyCollection(true);
        for (int i = 0; i < col.size(); ++i) {
            CurrencyInfo temp = col.get(i);
            if (temp.isGeneralLocalCurrency() || temp.isGeneralReportCurrency()) continue;
            this.comboCurrency.addItem((Object)temp);
            if (!temp.getId().toString().equals(this.curCompany.getBaseCurrency().getId().toString())) continue;
            this.localCur = temp;
        }
        if (this.localCur != null) {
            this.comboCurrency.setSelectedItem((Object)this.localCur);
        }
        int precision = 2;
        CurrencyInfo allCurr = new CurrencyInfo();
        allCurr.setId(BOSUuid.create((BOSObjectType)new CurrencyInfo().getBOSType()));
        allCurr.setNumber("all");
        allCurr.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource.ALLCURRENCY"));
        allCurr.setPrecision(precision);
        this.comboCurrency.addItem((Object)allCurr);
    }
}

