/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.VoucherAbstractInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.gl.AssistTransTypeEnum;
import com.kingdee.eas.fi.gl.AutoTransDataSource;
import com.kingdee.eas.fi.gl.AutoTransEntryInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AutoTransEditUI;
import com.kingdee.eas.fi.gl.client.BatchAccountAndAssist;
import com.kingdee.eas.fi.gl.utils.AutoTransUtils;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

class AutoTransAssistRecordEditAdapter
extends KDTEditAdapter {
    private AutoTransEditUI ui;
    private Object oldValue;
    protected static final Logger logger = CoreUIObject.getLogger(AutoTransAssistRecordEditAdapter.class);

    AutoTransAssistRecordEditAdapter(AutoTransEditUI ui) {
        this.ui = ui;
    }

    public void editStarting(KDTEditEvent evt) {
        String colKey;
        this.ui.illegalAssistRecordIndex = evt.getRowIndex();
        this.oldValue = evt.getValue();
        IRow assRow = this.ui.tblAssistRecord.getRow(evt.getRowIndex());
        if (!this.ui.isAssistRecordCellEditable(assRow, colKey = this.ui.tblAssistRecord.getColumnKey(evt.getColIndex()))) {
            evt.setCancel(true);
            return;
        }
        super.editStarting(evt);
    }

    public void editStopped(KDTEditEvent evt) {
        int colIndex = evt.getColIndex();
        int rowIndex = evt.getRowIndex();
        Object newValue = evt.getValue();
        if (GlUtils.isEqual(newValue, this.oldValue)) {
            return;
        }
        this.ui.isModify = true;
        if (newValue instanceof Object[]) {
            int curEntryIndex = this.ui.tblEntry.getSelectManager().getActiveRowIndex();
            IRow curEntryRow = this.ui.tblEntry.getRow(curEntryIndex);
            AutoTransEntryInfo data = (AutoTransEntryInfo)curEntryRow.getUserObject();
            AccountViewInfo acc = data.getAccount();
            if (acc != null && acc.getCAA() != null || acc.isHasUserProperty()) {
                Object assistTransType = curEntryRow.getCell("e.assistTransType").getValue();
                Object ds = curEntryRow.getCell("e.dataSourceType").getValue();
                if (assistTransType == AssistTransTypeEnum.TRANS_AUTO && AutoTransDataSource.TRANS_INTO != ds) {
                    this.afterAddAssistEvent(rowIndex, colIndex, newValue);
                } else {
                    this.loadAssist(rowIndex, colIndex, newValue);
                }
            }
        } else {
            this.afterAddAssistEvent(rowIndex, colIndex, newValue);
        }
    }

    protected void afterAddAssistEvent(int rowIndex, int colIndex, Object newValue) {
        Object formula;
        String colKey = this.ui.tblAssistRecord.getColumnKey(colIndex);
        CompanyOrgUnitInfo currCompany = this.ui.getCompanyOrgInfo();
        if (GlUtils.isEqual(newValue, this.oldValue)) {
            return;
        }
        if (colKey.startsWith("#")) {
            this.ui.storeTableDataToAssistRecord();
        }
        if (colIndex == this.ui.tblAssistRecord.getColumnIndex("r.description")) {
            String temp;
            if (newValue instanceof VoucherAbstractInfo) {
                temp = ((VoucherAbstractInfo)newValue).getDescription();
                if (temp == null || temp.trim().length() == 0) {
                    temp = ((VoucherAbstractInfo)newValue).getName();
                }
                newValue = temp;
                this.ui.tblAssistRecord.getCell(rowIndex, colIndex).setValue(newValue);
            }
            if (newValue != null) {
                temp = newValue.toString().trim();
                if (temp.length() > 80) {
                    temp = temp.substring(0, 80);
                }
                newValue = temp;
                this.ui.tblAssistRecord.getCell(rowIndex, colIndex).setValue(newValue);
            }
        }
        if (("r.originalFormula".equals(this.ui.tblAssistRecord.getColumn(colIndex).getKey()) || "r.localFormula".equals(this.ui.tblAssistRecord.getColumn(colIndex).getKey()) || "r.reportingFormula".equals(this.ui.tblAssistRecord.getColumn(colIndex).getKey())) && (formula = this.ui.tblAssistRecord.getCell(rowIndex, colIndex).getValue()) != null) {
            try {
                String localFormulaStr = formula.toString();
                String reportFormulaStr = formula.toString();
                Object localFormula = formula;
                Object reportFormula = formula;
                String formulaCompanyNum = AutoTransUtils.findFormalCompanyNum(formula.toString());
                if (currCompany.getNumber().equals(formulaCompanyNum) && this.ui.tblEntry.getCell(rowIndex, "e.currency").getValue() != null) {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.ui.tblEntry.getCell(rowIndex, "e.currency").getValue();
                    CurrencyInfo localCurrency = this.ui.getBaseCurrency(currCompany);
                    CurrencyInfo reportCurrency = this.ui.getReportCurrency(currCompany);
                    String endDate = this.ui.getPeriodInfo().getEndDate().toString();
                    ObjectUuidPK pk = new ObjectUuidPK(currCompany.getBaseExchangeTable().getId());
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("number"));
                    ExchangeTableInfo rateTable = ExchangeTableFactory.getRemoteInstance().getExchangeTableInfo((IObjectPK)pk, selector);
                    StringBuffer rateFormula = new StringBuffer("*ExchangeRate(\"");
                    if (!currencyInfo.getId().equals((Object)localCurrency.getId())) {
                        rateFormula = rateFormula.append(currencyInfo.getNumber()).append("\",\"" + localCurrency.getNumber()).append("\", \"" + endDate).append("\", \"" + rateTable.getNumber() + "\")");
                        localFormula = localFormulaStr;
                    }
                    if (!currencyInfo.getId().equals((Object)reportCurrency.getId())) {
                        rateFormula = rateFormula.append(currencyInfo.getNumber()).append("\",\"" + reportCurrency.getNumber()).append("\", \"" + endDate).append("\", \"" + rateTable.getNumber() + "\")");
                        reportFormula = reportFormulaStr;
                    }
                }
                if (this.ui.tblAssistRecord.getCell(rowIndex, "r.originalFormula").getValue() == null) {
                    this.ui.tblAssistRecord.getCell(rowIndex, "r.originalFormula").setValue(formula);
                }
                if (this.ui.tblAssistRecord.getCell(rowIndex, "r.localFormula").getValue() == null) {
                    this.ui.tblAssistRecord.getCell(rowIndex, "r.localFormula").setValue(localFormula);
                }
                if (this.ui.tblAssistRecord.getCell(rowIndex, "r.reportingFormula").getValue() == null) {
                    this.ui.tblAssistRecord.getCell(rowIndex, "r.reportingFormula").setValue(reportFormula);
                }
            }
            catch (Exception ignore) {
                logger.error((Object)("yejk AutoTransAssistRecordEditAdapter Exception:" + ignore.getMessage()));
            }
        }
        if (colIndex == this.ui.tblAssistRecord.getColumnIndex("r.percent") && newValue != null && (((BigDecimal)newValue).doubleValue() <= 0.0 || ((BigDecimal)newValue).doubleValue() > 100.0)) {
            this.ui.tblAssistRecord.getCell(rowIndex, "r.percent").setValue(this.oldValue);
        }
    }

    protected void loadAssist(int rIndex, int cIndex, Object newValue) {
        if (newValue instanceof Object[]) {
            Object[] assists = (Object[])newValue;
            newValue = assists[0];
            try {
                int curEntryIndex = this.ui.tblEntry.getSelectManager().getActiveRowIndex();
                IRow curEntryRow = this.ui.tblEntry.getRow(curEntryIndex);
                int assistRecordIndex = rIndex;
                AutoTransEntryInfo data = (AutoTransEntryInfo)curEntryRow.getUserObject();
                AccountViewInfo acc = data.getAccount();
                Object[] info = BatchAccountAndAssist.getCachedColumnInfo(acc, null);
                Map map = new HashMap();
                VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
                if (assItemCols.length > 1) {
                    int i;
                    HashSet<String> ids = new HashSet<String>();
                    if (newValue instanceof CustomerInfo) {
                        for (i = 0; i < assists.length; ++i) {
                            ids.add(((CustomerInfo)assists[i]).getId().toString());
                        }
                        map = BatchAccountAndAssist.loadCustomerInfo(ids);
                    } else if (newValue instanceof PersonInfo) {
                        for (i = 0; i < assists.length; ++i) {
                            ids.add(((PersonInfo)assists[i]).getId().toString());
                        }
                        map = BatchAccountAndAssist.loadPersonInfo(ids, assItemCols);
                    }
                }
                ObjectBaseInfo asst = null;
                IRow row = this.ui.tblAssistRecord.getRow(rIndex);
                int top = this.ui.illegalAssistRecordIndex;
                int count = this.ui.tblAssistRecord.getRowCount();
                for (int i = 0; i < assists.length; ++i) {
                    if (i > 0) {
                        if (top >= 0) {
                            if (assistRecordIndex >= count || row.getCell(cIndex) != null) {
                                row = this.ui.tblAssistRecord.addRow(assistRecordIndex);
                            }
                            row = this.ui.tblAssistRecord.getRow(assistRecordIndex);
                        } else {
                            top = this.ui.tblAssistRecord.getRowCount();
                            row = this.ui.tblAssistRecord.addRow();
                        }
                        this.ui.loadAssistRecordDataToTable(curEntryRow, row, this.ui.createNewAssData(curEntryRow));
                    }
                    asst = (ObjectBaseInfo)assists[i];
                    if (assists[i] instanceof ObjectBaseInfo && asst.getString("displayName") == null) {
                        if (asst instanceof CustomerInfo && ((CustomerInfo)asst).getBrowseGroup() != null) {
                            asst.put("displayName", (Object)(((CustomerInfo)asst).getBrowseGroup().getDisplayName() + "_" + ((CustomerInfo)asst).getName()));
                        } else if (asst instanceof MaterialInfo && ((MaterialInfo)asst).getMaterialGroup() != null) {
                            asst.put("displayName", (Object)(((MaterialInfo)asst).getMaterialGroup().getDisplayName() + "_" + ((MaterialInfo)asst).getName()));
                        } else if (asst instanceof SupplierInfo && ((SupplierInfo)asst).getBrowseGroup() != null) {
                            asst.put("displayName", (Object)(((SupplierInfo)asst).getBrowseGroup().getDisplayName() + "_" + ((SupplierInfo)asst).getName()));
                        } else {
                            asst.setString("displayName", (String)asst.get("name"));
                        }
                    }
                    row = this.ui.tblAssistRecord.getRow(assistRecordIndex);
                    ICell cell = row.getCell(cIndex);
                    cell.setValue((Object)asst);
                    BatchAccountAndAssist.carryAssist(assItemCols, row, asst, map, null, null);
                    this.afterAddAssistEvent(assistRecordIndex, cIndex, asst);
                    if (assistRecordIndex < 0) continue;
                    ++assistRecordIndex;
                }
                this.ui.illegalAssistRecordIndex = assistRecordIndex - 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                SysUtil.abort();
            }
        }
    }
}

