/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.VoucherAbstractInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyFactory;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.AssistRepordEntryInfo;
import com.kingdee.eas.fi.gl.AssistTransTypeEnum;
import com.kingdee.eas.fi.gl.AutoTransAssistRecordCollection;
import com.kingdee.eas.fi.gl.AutoTransAssistRecordInfo;
import com.kingdee.eas.fi.gl.AutoTransDataSource;
import com.kingdee.eas.fi.gl.AutoTransEntryInfo;
import com.kingdee.eas.fi.gl.AutoTransInfo;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AsstistTypePromptBox;
import com.kingdee.eas.fi.gl.client.AutoTransEditUI;
import com.kingdee.eas.fi.gl.utils.AutoTransUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

class AutoTransEntryEditAdapter
extends KDTEditAdapter {
    private AutoTransEditUI ui;
    private Object oldValue;

    AutoTransEntryEditAdapter(AutoTransEditUI ui) {
        this.ui = ui;
    }

    public void editStarting(KDTEditEvent evt) {
        String colKey;
        this.oldValue = evt.getOldValue();
        this.ui.illegalEntryIndex = evt.getRowIndex();
        IRow entryRow = this.ui.tblEntry.getRow(evt.getRowIndex());
        if (!this.isEntryCellEditable(entryRow, colKey = this.ui.tblEntry.getColumnKey(evt.getColIndex()))) {
            evt.setCancel(true);
            return;
        }
        super.editStarting(evt);
        KDTable table = (KDTable)evt.getSource();
        CompanyOrgUnitInfo currCompany = this.ui.getCompanyOrgInfo();
        if (evt.getColIndex() == table.getColumnIndex("e.account")) {
            String accouttableID = currCompany.getAccountTable().getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)currCompany.getId().toString()));
            fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("accountTableID.id", (Object)accouttableID));
            fic.add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            fic.add(new FilterItemInfo("category", (Object)(this.ui.getTemplateType() + 1)));
            filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 and #5");
            this.ui.bizAccountPromptBox.setEntityViewInfo(view);
            this.ui.bizAccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this.ui, currCompany, filter, false, false));
        } else if (evt.getColIndex() == table.getColumnIndex("e.currency")) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID, CompareType.NOTEQUALS));
            fic.add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID, CompareType.NOTEQUALS));
            AccountViewInfo acc = (AccountViewInfo)table.getCell(evt.getRowIndex(), "e.account").getValue();
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("accountingcurrency"));
                selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
                acc = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(acc.getId().toString()), selector);
            }
            catch (Exception ex) {
                this.ui.handUIException(ex);
            }
            if (acc.getAccountingcurrency().getValue() == 0) {
                fic.add(new FilterItemInfo("id", (Object)this.ui.getBaseCurrency(currCompany).getId()));
                filter.setMaskString("#0 AND #1 AND #2");
            } else if (acc.getAccountingcurrency().getValue() == 1) {
                AccountCurrencyCollection cc = acc.getAccountCurrency();
                Iterator iter = cc.iterator();
                StringBuffer mask = new StringBuffer("#0 AND #1 AND (#2");
                fic.add(new FilterItemInfo("id", (Object)"1"));
                int i = 3;
                while (iter.hasNext()) {
                    fic.add(new FilterItemInfo("id", (Object)((AccountCurrencyInfo)iter.next()).getCurrency().getId()));
                    mask.append(" OR #").append(i++);
                }
                mask.append(")");
                filter.setMaskString(mask.toString());
            }
            this.ui.bizPromptBoxCurForCell.setEntityViewInfo(view);
        }
    }

    public void editStopped(KDTEditEvent evt) {
        KDTable table = (KDTable)evt.getSource();
        int rowIndex = evt.getRowIndex();
        int colIndex = evt.getColIndex();
        Object newValue = evt.getValue();
        if (GlUtils.isEqual(newValue, this.oldValue)) {
            return;
        }
        this.ui.isModify = true;
        this.fixAsstAccount(newValue);
        if (newValue instanceof Object[]) {
            this.addNewEntry(evt, newValue);
        } else {
            if (GlUtils.isEqual(newValue, this.oldValue)) {
                return;
            }
            IRow entryRow = table.getRow(rowIndex);
            entryRow.getCell(colIndex).setValue(newValue);
            this.afterEditStop(table, rowIndex, colIndex, newValue);
        }
    }

    protected void addNewEntry(KDTEditEvent evt, Object obj) {
        int curEntryIndex;
        AccountViewInfo[] accounts = null;
        if (obj instanceof AccountViewInfo[]) {
            accounts = (AccountViewInfo[])obj;
        } else {
            Object[] objects;
            ArrayList<AccountViewInfo> list = new ArrayList<AccountViewInfo>();
            for (Object o : objects = (Object[])obj) {
                if (!(o instanceof AccountViewInfo)) continue;
                list.add((AccountViewInfo)o);
            }
            if (list.size() > 0) {
                accounts = list.toArray(new AccountViewInfo[list.size()]);
            }
        }
        if (accounts == null) {
            return;
        }
        AutoTransEntryInfo entryInfo = null;
        int top = curEntryIndex = evt.getRowIndex();
        int len = accounts.length;
        IRow row = this.ui.tblEntry.getRow(curEntryIndex);
        int count = this.ui.tblEntry.getRowCount();
        int acIndex = row.getCell("e.account").getColumnIndex();
        AutoTransEntryInfo entry = (AutoTransEntryInfo)row.getUserObject();
        if (entry.getId() != null) {
            entry.setOprStatus(3);
            this.ui.entriesRemoved.add(entry);
        }
        for (int i = 0; i < len; ++i) {
            block10: {
                block11: {
                    block13: {
                        block12: {
                            entryInfo = i == 0 ? this.ui.fromTableRow(curEntryIndex, this.ui.editData) : this.ui.createNewEntryData(this.ui.editData);
                            entryInfo.setAccount(accounts[i]);
                            if (i <= 0) break block10;
                            if (top < 0) break block11;
                            if (curEntryIndex >= count) break block12;
                            if (row.getCell("e.account") == null) break block13;
                        }
                        row = this.ui.tblEntry.addRow(curEntryIndex);
                    }
                    row = this.ui.tblEntry.getRow(curEntryIndex);
                    break block10;
                }
                top = this.ui.tblEntry.getRowCount();
                row = this.ui.tblEntry.addRow();
            }
            row.getCell(acIndex).setValue((Object)accounts[i]);
            this.ui.loadLineDataToTable(entryInfo, row);
            this.ui.setAssistTransType(row);
            this.afterEditStop((KDTable)evt.getSource(), curEntryIndex, evt.getColIndex(), accounts[i]);
            if (curEntryIndex < 0) continue;
            ++curEntryIndex;
        }
    }

    protected void afterEditStop(KDTable table, int rowIndex, int colIndex, Object newValue) {
        Object formula;
        AutoTransInfo.DynamicColumnInfo[] assItemCols;
        Object[] info;
        IRow entryRow = table.getRow(rowIndex);
        AccountViewInfo account = (AccountViewInfo)entryRow.getCell("e.account").getValue();
        Object dataSourceType = entryRow.getCell("e.dataSourceType").getValue();
        CompanyOrgUnitInfo currCompany = this.ui.getCompanyOrgInfo();
        if (colIndex == this.ui.tblEntry.getColumnIndex("e.account")) {
            if (newValue != null && newValue instanceof AccountViewInfo) {
                entryRow.getCell(colIndex).setValue(newValue);
                if (dataSourceType == AutoTransDataSource.TRANS_IN_REMAIN) {
                    entryRow.getCell("e.assistTransType").getStyleAttributes().setLocked(true);
                } else {
                    entryRow.getCell("e.assistTransType").getStyleAttributes().setLocked(false);
                }
                ICell curCell = entryRow.getCell("e.currency");
                if (account == null) {
                    curCell.setValue(null);
                } else {
                    CurrencyInfo cur = null;
                    if (account.getAccountingcurrency().getValue() == 1) {
                        try {
                            EntityViewInfo view = new EntityViewInfo();
                            SelectorItemCollection selector = view.getSelector();
                            selector.add(new SelectorItemInfo("currency.id"));
                            selector.add(new SelectorItemInfo("currency.name"));
                            FilterInfo filter = new FilterInfo();
                            view.setFilter(filter);
                            FilterItemCollection fic = filter.getFilterItems();
                            fic.add(new FilterItemInfo("accountView.id", (Object)account.getId().toString()));
                            filter.setMaskString("#0 ");
                            AccountCurrencyCollection accol = AccountCurrencyFactory.getRemoteInstance().getAccountCurrencyCollection(view);
                            if (accol != null && accol.size() > 0) {
                                AccountCurrencyInfo acccur = accol.get(0);
                                cur = acccur.getCurrency();
                                curCell.setValue((Object)cur);
                            }
                        }
                        catch (BOSException view) {
                            // empty catch block
                        }
                    }
                    if (cur == null) {
                        cur = this.ui.getBaseCurrency(this.ui.getCompanyOrgInfo());
                    }
                    curCell.setValue(cur);
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                KDBizPromptBox bizMUPromptBox = new KDBizPromptBox();
                bizMUPromptBox.setEditable(true);
                bizMUPromptBox.setEditFormat("$number$");
                bizMUPromptBox.setDisplayFormat("$name$");
                bizMUPromptBox.setCommitFormat("$number$");
                bizMUPromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
                bizMUPromptBox.setSelectorCollection(sic);
                if (account.getMeasureUnitGroupID() != null) {
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("measureUnitGroup.id", (Object)account.getMeasureUnitGroupID().getId().toString()));
                    viewInfo.setFilter(filterInfo);
                    bizMUPromptBox.setEntityViewInfo(viewInfo);
                }
                entryRow.getCell("e.measureUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMUPromptBox));
                entryRow.getCell("e.measureUnit").setValue(null);
                this.ui.createNewAssData(entryRow);
                this.ui.afterSelectLine(entryRow);
            } else {
                this.ui.afterSelectLine(null);
            }
        }
        if (colIndex == this.ui.tblEntry.getColumnIndex("e.description")) {
            String temp;
            if (newValue instanceof VoucherAbstractInfo) {
                temp = ((VoucherAbstractInfo)newValue).getDescription();
                if (temp == null || temp.trim().length() == 0) {
                    temp = ((VoucherAbstractInfo)newValue).getName();
                }
                newValue = temp;
                entryRow.getCell(colIndex).setValue(newValue);
            }
            if (newValue != null) {
                temp = newValue.toString().trim();
                if (temp.length() > 80) {
                    temp = temp.substring(0, 80);
                }
                newValue = temp;
                entryRow.getCell(colIndex).setValue(newValue);
            }
        }
        if (newValue != null && newValue instanceof AutoTransDataSource) {
            if (account != null && !account.isIsLeaf()) {
                if (AutoTransDataSource.TRANS_OUT_FORMULA.equals(newValue) || AutoTransDataSource.TRANS_IN_FORMULA.equals(newValue)) {
                    MsgBox.showInfo((Component)((Object)this.ui), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.AutoTransResource", (String)"autotrans_res12"));
                    entryRow.getCell(colIndex).setValue(this.oldValue);
                    entryRow.getCell("e.assistTransType").setValue((Object)AssistTransTypeEnum.TRANS_AUTO);
                    return;
                }
                if (AutoTransDataSource.TRANS_INTO.equals(newValue)) {
                    MsgBox.showInfo((Component)((Object)this.ui), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.AutoTransResource", (String)"autotrans_res13"));
                    entryRow.getCell(colIndex).setValue(this.oldValue);
                    return;
                }
                entryRow.getCell("e.assistTransType").getStyleAttributes().setLocked(false);
            } else if (AutoTransDataSource.TRANS_OUT_FORMULA.equals(newValue) || AutoTransDataSource.TRANS_IN_FORMULA.equals(newValue) || AutoTransDataSource.TRANS_IN_REMAIN.equals(newValue)) {
                entryRow.getCell("e.assistTransType").setValue((Object)AssistTransTypeEnum.TRANS_SELFDINFINE);
                entryRow.getCell("e.assistTransType").getStyleAttributes().setLocked(true);
                if (account != null) {
                    int i;
                    info = this.ui.getCachedColumnInfo(account, null);
                    assItemCols = (AutoTransInfo.DynamicColumnInfo[])info[0];
                    for (i = 0; i < assItemCols.length; ++i) {
                        AutoTransInfo.DynamicColumnInfo colInfo = assItemCols[i];
                        String colKey = "#" + colInfo.getMappingPropName();
                        IColumn col = this.ui.tblAssistRecord.getColumn(colKey);
                        col.setEditor(this.ui.getCellEditor(colInfo, account));
                    }
                    for (i = 0; i < this.ui.tblAssistRecord.getRowCount(); ++i) {
                        IRow iRow = this.ui.tblAssistRecord.getRow(i);
                        AutoTransAssistRecordInfo assistInfo = (AutoTransAssistRecordInfo)iRow.getUserObject();
                        for (int j = 0; j < assistInfo.getEntry().size(); ++j) {
                            AssistRepordEntryInfo reportInfo = assistInfo.getEntry().get(j);
                            reportInfo.put("asstObject", null);
                        }
                        this.ui.loadAssistRecordDataToTable(entryRow, iRow, assistInfo);
                    }
                }
                if (AutoTransDataSource.TRANS_OUT_FORMULA.equals(newValue) || AutoTransDataSource.TRANS_IN_FORMULA.equals(newValue)) {
                    entryRow.getCell("e.assistTransType").getStyleAttributes().setLocked(false);
                }
            } else {
                entryRow.getCell("e.assistTransType").getStyleAttributes().setLocked(false);
            }
        }
        if (newValue instanceof AssistTransTypeEnum || newValue instanceof AutoTransDataSource) {
            if (account == null) {
                return;
            }
            info = this.ui.getCachedColumnInfo(account, null);
            assItemCols = (AutoTransInfo.DynamicColumnInfo[])info[0];
            Object asstTransType = entryRow.getCell("e.assistTransType").getValue();
            if (AssistTransTypeEnum.TRANS_SELFDINFINE == asstTransType || AssistTransTypeEnum.TRANS_AUTO == asstTransType && AutoTransDataSource.TRANS_INTO == dataSourceType) {
                int i;
                for (i = 0; i < assItemCols.length; ++i) {
                    AutoTransInfo.DynamicColumnInfo colInfo = assItemCols[i];
                    String colKey = "#" + colInfo.getMappingPropName();
                    IColumn col = this.ui.tblAssistRecord.getColumn(colKey);
                    col.setEditor(this.ui.getCellEditor(colInfo, account));
                }
                for (i = 0; i < this.ui.tblAssistRecord.getRowCount(); ++i) {
                    IRow iRow = this.ui.tblAssistRecord.getRow(i);
                    AutoTransAssistRecordInfo assistInfo = (AutoTransAssistRecordInfo)iRow.getUserObject();
                    for (int j = 0; j < assistInfo.getEntry().size(); ++j) {
                        AssistRepordEntryInfo reportInfo = assistInfo.getEntry().get(j);
                        reportInfo.put("asstObject", null);
                    }
                    this.ui.loadAssistRecordDataToTable(entryRow, iRow, assistInfo);
                }
            } else {
                boolean isAsstEnable = true;
                if ((AutoTransDataSource.TRANS_OUT_FORMULA.equals(dataSourceType) || AutoTransDataSource.TRANS_IN_FORMULA.equals(dataSourceType)) && asstTransType.equals((Object)AssistTransTypeEnum.TRANS_AUTO)) {
                    isAsstEnable = false;
                }
                Color colBackgroupColor = isAsstEnable ? Color.WHITE : Color.LIGHT_GRAY;
                for (int i = 0; i < assItemCols.length; ++i) {
                    AutoTransInfo.DynamicColumnInfo colInfo = assItemCols[i];
                    String colKey = "#" + colInfo.getMappingPropName();
                    IColumn col = this.ui.tblAssistRecord.getColumn(colKey);
                    KDBizPromptBox bizAsstistTypePromptBox = new KDBizPromptBox();
                    AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
                    asstActTypeInfo.setDefaultQueryName(colInfo.getDefaultQueryName());
                    asstActTypeInfo.setGlAsstActTypeGrp(colInfo.getGrp());
                    asstActTypeInfo.setIsForCompany(colInfo.getIsForCompany());
                    asstActTypeInfo.setAsstHGAttribute(colInfo.getMappingPropName());
                    asstActTypeInfo.setName(colInfo.getColName());
                    bizAsstistTypePromptBox.setSelector((KDPromptSelector)new AsstistTypePromptBox((IUIObject)this.ui, this.ui.getCompanyOrgInfo(), this.ui.tblAssistRecord, asstActTypeInfo));
                    col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAsstistTypePromptBox));
                    col.getStyleAttributes().setLocked(!isAsstEnable);
                    col.getStyleAttributes().setBackground(colBackgroupColor);
                }
                if (!isAsstEnable) {
                    this.ui.tblAssistRecord.removeRows();
                    AutoTransEntryInfo autoTransInfo = (AutoTransEntryInfo)entryRow.getUserObject();
                    AutoTransAssistRecordCollection autoTransAssistRecords = autoTransInfo.getAutoTransAssistRecords();
                    if (autoTransAssistRecords.size() > 1) {
                        AutoTransAssistRecordInfo assistInfo = autoTransAssistRecords.get(0);
                        autoTransAssistRecords.clear();
                        autoTransAssistRecords.add(assistInfo);
                    } else if (autoTransAssistRecords.size() == 0) {
                        ActionEvent e = new ActionEvent(this.ui.btnAddNewAssist, 1001, this.ui.btnAddNewAssist.getActionCommand());
                        try {
                            this.ui.btnAddNewAssistLine_actionPerformed(e);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }
        if ((AutoTransDataSource.TRANS_OUT_FORMULA == this.oldValue || AutoTransDataSource.TRANS_IN_FORMULA == this.oldValue) && AutoTransDataSource.TRANS_OUT_FORMULA != newValue && AutoTransDataSource.TRANS_IN_FORMULA != newValue) {
            if (account == null || account.getCAA() == null) {
                entryRow.getCell("e.measureUnit").setValue(null);
                entryRow.getCell("e.originalFormula").setValue(null);
                entryRow.getCell("e.localFormula").setValue(null);
                entryRow.getCell("e.reportingFormula").setValue(null);
                entryRow.getCell("e.quantityFormula").setValue(null);
            } else {
                for (int i = 0; i < this.ui.tblAssistRecord.getRowCount(); ++i) {
                    this.ui.tblAssistRecord.getCell(i, "r.measureUnit").setValue(null);
                    this.ui.tblAssistRecord.getCell(i, "r.originalFormula").setValue(null);
                    this.ui.tblAssistRecord.getCell(i, "r.localFormula").setValue(null);
                    this.ui.tblAssistRecord.getCell(i, "r.reportingFormula").setValue(null);
                    this.ui.tblAssistRecord.getCell(i, "r.quantityFormula").setValue(null);
                }
            }
        }
        if (colIndex == this.ui.tblEntry.getColumnIndex("e.account") || colIndex == this.ui.tblEntry.getColumnIndex("e.dataSourceType")) {
            this.ui.setTableLocked(entryRow);
        }
        if ((colIndex == this.ui.tblEntry.getColumnIndex("e.originalFormula") || colIndex == this.ui.tblEntry.getColumnIndex("e.localFormula") || colIndex == this.ui.tblEntry.getColumnIndex("e.reportingFormula")) && (formula = this.ui.tblEntry.getCell(rowIndex, colIndex).getValue()) != null) {
            String localFormulaStr = formula.toString();
            String reportFormulaStr = formula.toString();
            Object localFormula = formula;
            Object reportFormula = formula;
            String formulaCompanyNum = AutoTransUtils.findFormalCompanyNum(formula.toString());
            if (currCompany.getNumber().equals(formulaCompanyNum) && this.ui.tblEntry.getCell(rowIndex, "e.currency").getValue() != null) {
                try {
                    CurrencyInfo currencyInfo = (CurrencyInfo)this.ui.tblEntry.getCell(rowIndex, "e.currency").getValue();
                    CurrencyInfo localCurrency = this.ui.getBaseCurrency(currCompany);
                    CurrencyInfo reportCurrency = this.ui.getReportCurrency(currCompany);
                    String endDate = this.ui.getPeriodInfo().getEndDate().toString();
                    ObjectUuidPK pk = new ObjectUuidPK(currCompany.getBaseExchangeTable().getId());
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("number"));
                    ExchangeTableInfo rateTable = ExchangeTableFactory.getRemoteInstance().getExchangeTableInfo((IObjectPK)pk, selector);
                    StringBuffer rateFormula = new StringBuffer("*ExchangeRate(\"");
                    if (localCurrency.getId() != currencyInfo.getId()) {
                        rateFormula = rateFormula.append(currencyInfo.getNumber()).append("\",\"" + localCurrency.getNumber()).append("\", \"" + endDate).append("\", \"" + rateTable.getNumber() + "\")");
                        localFormula = localFormulaStr;
                    }
                    if (reportCurrency.getId() != currencyInfo.getId()) {
                        rateFormula = rateFormula.append(currencyInfo.getNumber()).append("\",\"" + reportCurrency.getNumber()).append("\", \"" + endDate).append("\", \"" + rateTable.getNumber() + "\")");
                        reportFormula = reportFormulaStr;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.ui.tblEntry.getCell(rowIndex, "e.originalFormula").getValue() == null) {
                this.ui.tblEntry.getCell(rowIndex, "e.originalFormula").setValue(formula);
            }
            if (this.ui.tblEntry.getCell(rowIndex, "e.localFormula").getValue() == null) {
                this.ui.tblEntry.getCell(rowIndex, "e.localFormula").setValue(localFormula);
            }
            if (this.ui.tblEntry.getCell(rowIndex, "e.reportingFormula").getValue() == null) {
                this.ui.tblEntry.getCell(rowIndex, "e.reportingFormula").setValue(reportFormula);
            }
        }
        if (colIndex == this.ui.tblEntry.getColumnIndex("e.percent") && newValue != null && (((BigDecimal)newValue).doubleValue() <= 0.0 || ((BigDecimal)newValue).doubleValue() > 100.0)) {
            this.ui.tblEntry.getCell(rowIndex, "e.percent").setValue(this.oldValue);
        }
        this.ui.setTableLocked(entryRow);
    }

    protected boolean isEntryCellEditable(IRow row, String colKey) {
        if ("e.currency".equals(colKey)) {
            AccountViewInfo acc = null;
            Object accounts = row.getCell("e.account").getValue();
            if (accounts instanceof Object[]) {
                Object[] objs = (Object[])accounts;
                acc = (AccountViewInfo)objs[0];
            } else if (accounts instanceof AccountViewInfo[]) {
                acc = ((AccountViewInfo[])accounts)[0];
            } else if (accounts instanceof AccountViewInfo) {
                acc = (AccountViewInfo)accounts;
            }
            return acc != null && acc.getCurrencyID() == null;
        }
        return true;
    }

    private void fixAsstAccount(Object value) {
        try {
            Map<String, AsstAccountInfo> caas = this.ui.getCAAs();
            if (value instanceof AccountViewInfo) {
                AccountViewInfo account = (AccountViewInfo)value;
                if (account.isIsLeaf()) {
                    account.setCAA(GLAsstAccountUtils.getCAA(null, account.getId().toString(), this.ui.getPeriodInfo().getId().toString(), caas));
                }
            } else if (value instanceof AccountViewInfo[]) {
                AccountViewInfo[] accounts = (AccountViewInfo[])value;
                HashSet<String> accountIds = new HashSet<String>();
                for (AccountViewInfo account : accounts) {
                    if (!account.isIsLeaf()) continue;
                    accountIds.add(account.getId().toString());
                }
                GLAsstAccountUtils.getCAAs(null, accountIds, this.ui.getPeriodInfo().getId().toString(), caas);
                for (AccountViewInfo account : accounts) {
                    if (!account.isIsLeaf()) continue;
                    account.setCAA(caas.get(account.getId().toString()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

