/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractAutoTransFilterUI;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoTransFilterUI
extends AbstractAutoTransFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoTransFilterUI.class);
    private String uiParam = null;

    public AutoTransFilterUI(String uiparam) throws Exception {
        this.uiParam = uiparam;
    }

    public void onLoad() throws Exception {
        this.promptBoxCompany.setEnabledMultiSelection(true);
        super.onLoad();
        this.initCompanyF7();
        this.initCreatorF7();
        if (this.promptBoxCompany.getText() == null || "".equals(this.promptBoxCompany.getText())) {
            this.clear();
        }
    }

    private void initCreatorF7() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        StringBuffer maskStr = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isLocked", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)"20"));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)"50"));
        maskStr.append("#0 and #1 and #2 and (#3 or #4)");
        filter.setMaskString(maskStr.toString());
        this.promptBoxCreator.setEntityViewInfo(view);
    }

    private void initCompanyF7() throws Exception {
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.promptBoxCompany.setEntityViewInfo(companyView);
        this.promptBoxCompany.setSelector(this.getCompanySelector());
    }

    public FilterInfo getFilterInfo() {
        UserInfo user;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int index = 0;
        fic.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        StringBuffer maskString = new StringBuffer("#").append(index++);
        String autoTrans = this.txtAutoTrans.getText();
        if (autoTrans != null && autoTrans.trim().length() > 0) {
            fic.add(new FilterItemInfo("number", (Object)("%" + autoTrans.trim() + "%"), CompareType.LIKE));
            fic.add(new FilterItemInfo("name", (Object)("%" + autoTrans.trim() + "%"), CompareType.LIKE));
            maskString.append(" AND (#").append(index++).append(" OR #").append(index++).append(")");
        }
        if ((user = (UserInfo)this.promptBoxCreator.getValue()) != null) {
            fic.add(new FilterItemInfo("creator.id", (Object)user.getId().toString()));
            maskString.append(" AND #").append(index++);
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public void loadData(EntityViewInfo view) {
        if (view == null || view.getFilter() == null) {
            return;
        }
        this.txtAutoTrans.setText(null);
        if (view.getFilter().getFilterItems() != null) {
            for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
                FilterItemInfo filterItemInfo = view.getFilter().getFilterItems().get(i);
                if (filterItemInfo.getPropertyName().equals("company.id")) {
                    this.setCompany(filterItemInfo);
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("number") || filterItemInfo.getPropertyName().equals("name")) {
                    String numberName = (String)filterItemInfo.getCompareValue();
                    this.txtAutoTrans.setText(numberName.substring(1, numberName.length() - 1));
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equals("creator.id")) continue;
                try {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("name"));
                    selector.add(new SelectorItemInfo("number"));
                    UserInfo creator = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK((String)filterItemInfo.getCompareValue()), selector);
                    this.promptBoxCreator.setValue((Object)creator);
                    continue;
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        if (this.promptBoxCompany.getValue() == null) {
            this.promptBoxCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        }
    }

    public void clear() {
        CompanyOrgUnitInfo firstCompany = this.getFirstCompany();
        if (firstCompany != null) {
            this.promptBoxCompany.setValue((Object)new CompanyOrgUnitInfo[]{firstCompany});
        } else {
            this.promptBoxCompany.setValue(null);
        }
        this.txtAutoTrans.setText(null);
        this.promptBoxCreator.setValue(null);
    }

    private CompanyOrgUnitInfo getFirstCompany() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem());
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private void setCompany(FilterItemInfo filterItemInfo) {
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        Object companyId = filterItemInfo.getCompareValue();
        Set<Object> companyIdSet = null;
        if (companyId instanceof String) {
            companyIdSet = new HashSet();
            companyIdSet.add(companyId);
        } else {
            companyIdSet = (Set)filterItemInfo.getCompareValue();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
        companyView.setFilter(filter);
        CompanyOrgUnitInfo[] companys = null;
        try {
            CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(companyView);
            companys = new CompanyOrgUnitInfo[companyColl.size()];
            for (int j = 0; j < companys.length; ++j) {
                companys[j] = companyColl.get(j);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (companys != null) {
            this.promptBoxCompany.setValue((Object)companys);
        } else {
            this.promptBoxCompany.setValue(null);
        }
    }

    private String getPermissionItem() {
        return "gl_autoTrans_view";
    }

    protected KDPromptSelector getCompanySelector() {
        if (!GlUtils.isEmpty(this.uiParam) && "FSSC".equalsIgnoreCase(this.uiParam)) {
            return new CompanyTreePromptBox((CoreUIObject)this, null, this.promptBoxCompany, this.getPermissionItem(), true);
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        return companySelector;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    private String getCompanyIdFilter() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.promptBoxCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.promptBoxCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.promptBoxCompany.getValue();
        }
        if (this.promptBoxCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.promptBoxCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    public boolean verify() {
        if (this.getCompanys() == null) {
            this.promptBoxCompany.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"104_HGReplaceToolUI"));
            return false;
        }
        return this.verifyViewPermission();
    }

    private boolean verifyViewPermission() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        StringBuffer errOrg = new StringBuffer();
        try {
            Map mapOrgWithPerm = GLGeneralFacadeFactory.getRemoteInstance().getOrgWithPerm(this.getPermissionItem(), companys);
            for (int i = 0; i < companys.length; ++i) {
                CompanyOrgUnitInfo company = companys[i];
                if (mapOrgWithPerm.containsKey(company.getId().toString())) continue;
                if (errOrg.length() > 0) {
                    errOrg.append(",");
                }
                errOrg.append(company.getName());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (errOrg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CWGXResource", (String)"notPermAutoTransQuery"), errOrg.toString()));
            return false;
        }
        return true;
    }
}

