/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.AutoTransException;
import com.kingdee.eas.fi.gl.AutoTransFactory;
import com.kingdee.eas.fi.gl.AutoTransInfo;
import com.kingdee.eas.fi.gl.AutoTransType;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ProduceInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractAutoTransListUI;
import com.kingdee.eas.fi.gl.client.AutoTransEditUI;
import com.kingdee.eas.fi.gl.client.AutoTransFilterUI;
import com.kingdee.eas.fi.gl.client.AutoTransQueryProcessor;
import com.kingdee.eas.fi.gl.client.GLLicenseUtils;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.utils.AutoTransUtils;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class AutoTransListUI
extends AbstractAutoTransListUI {
    private static final long serialVersionUID = 8978089729026258342L;
    private static final Logger logger = CoreUIObject.getLogger(AutoTransListUI.class);
    private static final String AUTOTRANS_RESOURCE_PATH = "com.kingdee.eas.fi.gl.AutoTransResource";
    private PeriodChangeListener periodChangeListener = new PeriodChangeListener();
    private Set lastCompanyIdSet;

    public void onLoad() throws Exception {
        try {
            GLLicenseUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, (CoreUI)this);
        }
        catch (LicenseException e) {
            logger.error((Object)"release license error", (Throwable)e);
        }
        this.setMergeColumn();
        super.onLoad();
        this.menuItemExportSelectedData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.initTableStyle();
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.menuItemExportData.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.getMainStatusBar().setPerTitle(GlUtils.getSysStatusBarTitle(SysContext.getSysContext().getCurrentFIUnit()));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemCreateVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.btnCreateVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.menuItemJoinVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnJoinVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        queryDlg.setHeight(250);
        queryDlg.setWidth(380);
        try {
            queryDlg.addUserPanel((KDPanel)new AutoTransFilterUI((String)this.getUIContext().get("UIClassParam")));
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        queryDlg.setProcessor((IProcessor)new AutoTransQueryProcessor());
        return queryDlg;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        try {
            IQueryExecutor exec = this.getQueryExecutorInstance(queryPK);
            this.setCurCompanyFilter(viewInfo);
            this.setSorter(viewInfo);
            exec.setEntityView("AutoTrans", viewInfo);
            FilterInfo filter = viewInfo.getFilter();
            EntityViewInfo sscQueryView = new EntityViewInfo();
            FilterInfo sscFilterInfo = new FilterInfo();
            sscFilterInfo.getFilterItems().add(this.getCompanyFilter(filter));
            sscQueryView.setFilter(sscFilterInfo);
            exec.setEntityView("sysStatusCtrl", sscQueryView);
            EntityViewInfo vchQueryView = new EntityViewInfo();
            FilterInfo filterInfov = new FilterInfo();
            filterInfov.getFilterItems().add(this.getCompanyFilter(filter));
            FilterItemInfo periodItem = this.getPeriodFilter(filter);
            if (periodItem != null) {
                filterInfov.getFilterItems().add(this.getPeriodFilter(filter));
            }
            vchQueryView.setFilter(filterInfov);
            exec.setEntityView("transVchRef", vchQueryView);
            exec.option().isAutoTranslateEnum = true;
            return exec;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private IQueryExecutor getQueryExecutorInstance(IMetaDataPK queryPK) {
        if (this.getMainOrgContext() != null && FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext()) != null) {
            return QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)queryPK, (Context)this.getMainOrgContext());
        }
        return QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
    }

    private void setSorter(EntityViewInfo viewInfo) {
        if (viewInfo.getSorter().isEmpty()) {
            viewInfo.getSorter().add(new SorterItemInfo("company.number"));
            viewInfo.getSorter().add(new SorterItemInfo("number"));
            viewInfo.getSorter().add(new SorterItemInfo("id"));
            viewInfo.getSorter().add(new SorterItemInfo("voucher.createTime"));
        } else {
            boolean existIdSorter = false;
            for (int i = 0; i < viewInfo.getSorter().size(); ++i) {
                SorterItemInfo item = viewInfo.getSorter().get(i);
                if (!"id".equals(item.getPropertyName())) continue;
                existIdSorter = true;
                break;
            }
            if (!existIdSorter) {
                SorterItemCollection sorter = new SorterItemCollection();
                boolean existVoucherNumberSorter = false;
                for (int i = 0; i < viewInfo.getSorter().size(); ++i) {
                    SorterItemInfo item = viewInfo.getSorter().get(i);
                    if ("voucherNumber".equals(item.getPropertyName())) {
                        existVoucherNumberSorter = true;
                        sorter.add(new SorterItemInfo("id"));
                    }
                    sorter.add(item);
                }
                if (!existVoucherNumberSorter) {
                    sorter.add(new SorterItemInfo("id"));
                }
                viewInfo.setSorter(sorter);
            }
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.getSelectedRow();
        if (row == null) {
            return;
        }
        String companyId = (String)row.getCell("company.id").getValue();
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(companyId), (String)"gl_autoTrans_edit");
        super.actionEdit_actionPerformed(e);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
        this.tblMain.getColumn("AutoTrans.voucherStatus").setGroup(true);
        this.tblMain.getColumn("AutoTrans.voucherStatus").setMergeable(true);
    }

    public String[] getMergeColumnKeys() {
        String[] columnKeys = new String[]{"id", "company.name", "currPeriod", "number", "AutoTrans.name", "AutoTrans.transferType", "voucherType.name", "AutoTrans.description", "AutoTrans.attachments", "creator.name"};
        return columnKeys;
    }

    private void setCurCompanyFilter(EntityViewInfo viewInfo) throws BOSException {
        if (viewInfo.getFilter() != null) {
            FilterItemCollection filters = viewInfo.getFilter().getFilterItems();
            boolean existCompanyFilter = false;
            for (int i = 0; i < filters.size(); ++i) {
                if (!"company.id".equals(filters.get(i).getPropertyName())) continue;
                existCompanyFilter = true;
                break;
            }
            if (existCompanyFilter) {
                return;
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        HashSet<BOSUuid> companyIdSet = new HashSet<BOSUuid>();
        CompanyOrgUnitInfo company = this.getFirstCompany();
        if (company != null) {
            companyIdSet.add(this.getFirstCompany().getId());
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)""));
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(filterInfo);
        } else {
            viewInfo.getFilter().mergeFilter(filterInfo, "and");
        }
    }

    private CompanyOrgUnitInfo getFirstCompany() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany("gl_autoTrans_view");
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    private String getPermissionItemID() {
        return "793674cd-00fd-1000-e000-0006c0a81277PERMITEM";
    }

    private FilterItemInfo getPeriodFilter(FilterInfo filterInfo) throws EASBizException, BOSException {
        FilterItemInfo companyFilteritem = this.getCompanyFilter(filterInfo);
        PeriodInfo period = (PeriodInfo)this.bizPromptVoucherPeriod.getValue();
        if (this.lastCompanyIdSet == null || !this.lastCompanyIdSet.equals(companyFilteritem.getCompareValue())) {
            if (companyFilteritem.getCompareValue() instanceof Set) {
                SystemStatusCtrolCollection sscColl;
                this.lastCompanyIdSet = (Set)companyFilteritem.getCompareValue();
                if (this.lastCompanyIdSet.size() > 0) {
                    this.initMainBizOrg(new ArrayList(this.lastCompanyIdSet));
                }
                if (!(sscColl = this.getSystemStatusCtrolCollection(companyFilteritem)).isEmpty()) {
                    this.setPeirodFilter(sscColl);
                } else {
                    this.bizPromptVoucherPeriod.setEnabled(false);
                }
                if (!sscColl.isEmpty()) {
                    period = sscColl.get(0).getCurrentPeriod();
                }
            }
            this.bizPromptVoucherPeriod.removeDataChangeListener((DataChangeListener)this.periodChangeListener);
            this.bizPromptVoucherPeriod.setValue((Object)period);
            this.bizPromptVoucherPeriod.addDataChangeListener((DataChangeListener)this.periodChangeListener);
        }
        if (period == null) {
            this.bizPromptVoucherPeriod.setEnabled(false);
            return null;
        }
        return new FilterItemInfo("voucher.period.number", (Object)period.getNumber());
    }

    private SystemStatusCtrolCollection getSystemStatusCtrolCollection(FilterItemInfo companyFilteritem) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("currentPeriod.id"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.number"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.periodYear"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.periodNumber"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.isAdjustPeriod"));
        view.getSelector().add(new SelectorItemInfo("startPeriod.number"));
        view.getSelector().add(new SelectorItemInfo("startPeriod.periodType.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(companyFilteritem);
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)6));
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("currentPeriod.number");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        return SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection(view);
    }

    private void setPeirodFilter(SystemStatusCtrolCollection sscColl) {
        int minPeriodNumber = this.getMinPeriodNumber(sscColl);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)minPeriodNumber, CompareType.GREATER_EQUALS));
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < sscColl.size(); ++i) {
            if (sscColl.get(i).getStartPeriod() == null) continue;
            idSet.add(sscColl.get(i).getStartPeriod().getPeriodType().getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodType.number"));
        evi.getSorter().add(new SorterItemInfo("number"));
        this.bizPromptVoucherPeriod.setEntityViewInfo(evi);
        if (sscColl == null || sscColl.size() == 0) {
            this.bizPromptVoucherPeriod.setEnabled(false);
        }
    }

    private int getMinPeriodNumber(SystemStatusCtrolCollection sscColl) {
        int minPeriodNumber = -1;
        for (int i = 0; i < sscColl.size(); ++i) {
            PeriodInfo period = sscColl.get(i).getStartPeriod();
            if (period == null || minPeriodNumber != -1 && period.getNumber() >= minPeriodNumber) continue;
            minPeriodNumber = period.getNumber();
        }
        return minPeriodNumber;
    }

    private FilterItemInfo getCompanyFilter(FilterInfo filterInfo) {
        if (filterInfo != null) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo item = filterInfo.getFilterItems().get(i);
                if (!"company.id".equals(item.getPropertyName())) continue;
                return item;
            }
        }
        return new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void initTableStyle() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionCreateVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList;
        KDTEditManager em = this.tblMain.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
        }
        if ((idList = this.getSelectedIdValues()).size() == 0) {
            String missingSelectProduceLine = EASResource.getString((String)AUTOTRANS_RESOURCE_PATH, (String)"missingSelectProduceLine");
            MsgBox.showWarning((String)missingSelectProduceLine);
            return;
        }
        GlUtils.updateBalance(this.getSelectedCompanyIdSet());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(AutoTransUtils.IS_AUTO_TRANSUTILS_CV, AutoTransUtils.IS_AUTO_TRANSUTILS_CV);
        Map result = AutoTransFactory.getRemoteInstance().generalVoucherCollectionParams(this.getSelectedIdValues(), params);
        ArrayList produceInfos = (ArrayList)result.get("error");
        VoucherCollection vchColl = (VoucherCollection)result.get("voucher");
        if (idList.size() > 1) {
            UIContext uiContext = new UIContext();
            uiContext.put((Object)"MAKEINFO", (Object)produceInfos);
            uiContext.put((Object)"Owner", (Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getShowInfoUIMode()).create(this.getShowInfoUI(), (Map)uiContext);
            uiWindow.show();
            this.refreshList();
        } else {
            ProduceInfo produceInfo;
            if (produceInfos.size() > 0 && !(produceInfo = (ProduceInfo)produceInfos.get(0)).isSuccess()) {
                MsgBox.showInfo((Component)((Object)this), (String)produceInfo.getErrInfo());
                SysUtil.abort();
            }
            if (vchColl.size() > 0) {
                try {
                    UIContext uiContext = new UIContext((Object)this);
                    uiContext.put((Object)"InitDataObject", (Object)vchColl.get(0));
                    uiContext.put((Object)"ISFromAutoTrans", (Object)"ISFromAutoTrans");
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)AutoTransListUI.getVoucherEditUIMode()).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
                    uiWindow.show();
                    UILifeCycleImp lifeCycleListener = new UILifeCycleImp(){

                        public void onDestroyWindow(UILifeCycleEvent event) {
                            try {
                                if (SysContext.getSysContext().getSessionID() != null) {
                                    AutoTransListUI.this.refreshList();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    ((CoreUI)uiWindow.getUIObject()).getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)lifeCycleListener);
                }
                catch (Exception ex) {
                    throw new AutoTransException(AutoTransException.FAIL_CREATE_UI, ex);
                }
            }
        }
    }

    protected String[] getSelectedCompanyIdSet() {
        HashSet<String> companyIdSet = new HashSet<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            if (row == null) continue;
            String companyId = (String)row.getCell("company.id").getValue();
            companyIdSet.add(companyId);
        }
        return companyIdSet.toArray(new String[companyIdSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionJoinVoucher_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.getSelectedRow();
        if (row == null) {
            return;
        }
        String voucherId = (String)row.getCell("voucherId").getValue();
        if (voucherId != null) {
            try {
                this.setCursorOfWair();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)voucherId);
                uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
                uiContext.put((Object)"FINDVIEW", (Object)Boolean.TRUE);
                IIDList voucherIdList = this.getVoucherIDList(this.tblMain, "voucherId");
                voucherIdList.setCurrentID(voucherId);
                uiContext.put((Object)"IDList", (Object)voucherIdList);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)this)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            finally {
                this.setCursorOfDefault();
            }
        }
    }

    private IRow getSelectedRow() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return null;
        }
        return this.tblMain.getRow(rowIndex);
    }

    private IIDList getVoucherIDList(KDTable tblMain, String voucherColKey) {
        RealModeIDList idList = new RealModeIDList(){

            public void setCurrentID(String id) {
                if (this.newIdList.contains(id)) {
                    this.setCurrentIndex(this.newIdList.indexOf(id));
                }
            }
        };
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            String voucherId = (String)tblMain.getRow(i).getCell(voucherColKey).getValue();
            if (voucherId == null || voucherId.trim().length() <= 0 || idList.contains(voucherId)) continue;
            idList.add(voucherId);
        }
        return idList;
    }

    public static String getVoucherEditUIMode() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    protected String getQueryName() {
        return "com.kingdee.eas.fi.gl.app.AutoTransQuery";
    }

    protected String getEditUIName() {
        return AutoTransInfo.getEditUIName();
    }

    protected String getEditUIModal() {
        return AutoTransEditUI.getEditUIMode((CoreUIObject)this);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AutoTransFactory.getRemoteInstance();
    }

    protected String getShowInfoUI() {
        return "com.kingdee.eas.fi.gl.client.AutoTransMakeVhInfoUI";
    }

    protected String getShowInfoUIMode() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void initMainBizOrg(List l) {
        super.initMainBizOrg(l);
        if (this.getMainOrgContext() != null) {
            MutiOrgPermParam mutiOrgParam = new MutiOrgPermParam();
            mutiOrgParam.setOrgType(this.getMainBizOrgType());
            mutiOrgParam.setOrgIdList(l);
            this.getMainOrgContext().put((Object)"MUTI_ORG_INFO", (Object)mutiOrgParam);
        }
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.actionRefresh_actionPerformed(null);
    }

    protected ArrayList getImportParam() {
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.datataskMode = 0;
        param.solutionName = "eas.fi.gl.autotrans";
        param.alias = EASResource.getString((String)AUTOTRANS_RESOURCE_PATH, (String)"title");
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(this.getExportParam(false), 1);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ObjectUuidPK userId = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK companyId = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId());
        IPermission perCtrl = PermissionFactory.getRemoteInstance();
        perCtrl.checkFunctionPermission((IObjectPK)userId, (IObjectPK)companyId, "gl_autoTrans_remove");
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionExportSelectedData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(this.getExportParam(true), 1);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        Locale l = SysContext.getSysContext().getLocale();
        String periodFormat = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"periodFormat");
        Object[] params = null;
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        for (int r = firstIndex; r <= lastIndex; ++r) {
            ICell transTypeCell = this.tblMain.getCell(r, "AutoTrans.transferType");
            if (!(transTypeCell.getValue() instanceof AutoTransType)) {
                // empty if block
            }
            if ("l2".equals(l.getLanguage())) continue;
            params = new Object[]{String.valueOf(this.tblMain.getCell(r, "periodYear").getValue()), String.valueOf(this.tblMain.getCell(r, "periodNumber").getValue())};
            this.tblMain.getCell(r, "currPeriod").setValue((Object)MessageFormat.format(periodFormat, params));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected ArrayList getExportParam(boolean isSelected) {
        SorterItemCollection sic;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        EntityViewInfo ev = this.getMainQuery();
        if (isSelected) {
            ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet set = new HashSet();
            set.addAll(this.getSelectedIdValues());
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            ev.setFilter(filter);
        }
        if ((sic = ev.getSorter()) != null) {
            for (int index = 0; index < sic.size(); ++index) {
                if (!"voucher.createTime".equalsIgnoreCase(sic.get(index).getPropertyName())) continue;
                sic.removeObject(index);
            }
        }
        param.putContextParam((Object)"mainQuery", (Object)ev);
        param.datataskMode = 1;
        param.solutionName = "eas.fi.gl.autotrans";
        param.alias = EASResource.getString((String)AUTOTRANS_RESOURCE_PATH, (String)"title");
        paramList.add(param);
        return paramList;
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    private class PeriodChangeListener
    implements DataChangeListener {
        private PeriodChangeListener() {
        }

        public void dataChanged(DataChangeEvent eventObj) {
            if (eventObj.getNewValue() == null) {
                AutoTransListUI.this.bizPromptVoucherPeriod.setValue(eventObj.getOldValue());
                SysUtil.abort();
            } else {
                AutoTransListUI.this.execQuery();
            }
        }
    }
}

