/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.eas.fi.gl.client.AutoTransEditUI;
import java.awt.event.ActionEvent;

class AutoTrasFocusListener
extends KDTFocusChangeAction {
    private static final long serialVersionUID = 5925827948165253156L;
    private AutoTransEditUI ui;

    public AutoTrasFocusListener(AutoTransEditUI ui, KDTable table) {
        super(table, (short)0, false);
        this.ui = ui;
    }

    public void actionPerformed(ActionEvent evt) {
        KDTEditManager em = this.table.getEditManager();
        int result = em.stopEditing();
        if (0 != result) {
            return;
        }
        KDTSelectManager sm = this.table.getSelectManager();
        int rowIndex = sm.getActiveRowIndex();
        int colIndex = sm.getActiveColumnIndex();
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        int nextRowIndex = rowIndex;
        if (nextRowIndex < 0) {
            return;
        }
        while (nextRowIndex < rowCount) {
            IRow row = this.table.getRow(nextRowIndex);
            for (int i = colIndex + 1; i < colCount; ++i) {
                StyleAttributes sa = row.getCell(i).getStyleAttributes();
                if (sa.isHided() || sa.isLocked()) continue;
                em.editCellAt(nextRowIndex, i);
                return;
            }
            colIndex = -1;
            if (this.reverse || ++nextRowIndex != rowCount) continue;
            try {
                if (this.table == this.ui.tblEntry) {
                    this.ui.btnAddNewEntryLine_actionPerformed(null);
                } else if (this.table == this.ui.tblAssistRecord) {
                    this.ui.btnAddNewAssistLine_actionPerformed(null);
                }
                ++rowCount;
            }
            catch (Exception ex) {
                this.ui.handUIException(ex);
            }
        }
    }
}

