/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLBalanceAnaFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceRepairFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractBalanceAnalysisUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BalanceAnalysisUI
extends AbstractBalanceAnalysisUI {
    private static final String RES = "com.kingdee.eas.fi.gl.BalanceAnalysisResource";
    private static final Logger logger = CoreUIObject.getLogger(BalanceAnalysisUI.class);
    private int maxHistory = 120;
    private int maxFuture = 13;
    private boolean stop = false;
    private static final Color bgColor = new Color(240, 240, 240);
    private static final Color successColor = new Color(0, 130, 0);
    private static final Color curColor = new Color(50, 205, 50);
    private static final Color futColor = new Color(30, 144, 255);
    private KDButtonGroup bgCompare = new KDButtonGroup();
    DataChangeListener companyListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                BalanceAnalysisUI.this.initPeriod();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                BalanceAnalysisUI.this.handUIException(ex);
            }
            try {
                BalanceAnalysisUI.this.initTable();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                BalanceAnalysisUI.this.handUIException(ex);
            }
        }
    };
    ItemListener tableListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                BalanceAnalysisUI.this.initAccount();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                BalanceAnalysisUI.this.handUIException(ex);
            }
        }
    };

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        OrgUnitInfo ou = SysContext.getSysContext().getCurrentOrgUnit();
        if (ou != null) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(ou.getId()), (String)"gl_tool");
        } else {
            SysUtil.abort();
        }
        this.miARCPVoucher.setEnabled(true);
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)"select FKey, FValue from T_GL_AnaConfig where FKey in ('AnaBal_MaxHistory','AnaBal_MaxFuture') ").executeSQL();
            while (rs.next()) {
                String key = rs.getString("FKey");
                String value = rs.getString("FValue");
                if ("AnaBal_MaxHistory".equals(key)) {
                    if (value == null) continue;
                    try {
                        this.maxHistory = Integer.parseInt(value);
                        if (this.maxHistory > 0) continue;
                        this.maxHistory = 120;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!"AnaBal_MaxFuture".equals(key) || value == null) continue;
                try {
                    this.maxFuture = Integer.parseInt(value);
                    if (this.maxFuture > 0) continue;
                    this.maxFuture = 13;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onLoad();
        this.initMyIcon();
        this.initTableStyle();
        this.initCompany();
    }

    private void initMyIcon() throws Exception {
        this.periodFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodFrom.setEditable(true);
        this.periodFrom.setEditFormat("$number$");
        this.periodFrom.setCommitFormat("$number$");
        this.periodTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodTo.setEditable(true);
        this.periodTo.setEditFormat("$number$");
        this.periodTo.setCommitFormat("$number$");
        this.spHistorys.setModel((SpinnerModel)new SpinnerNumberModel(0, -1, this.maxHistory, 1));
        this.spFutures.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, this.maxFuture, 1));
        this.spMaxRecord.setModel((SpinnerModel)new SpinnerNumberModel(500, 1, 100000, 500));
        this.cbPosted.setSelected(true);
        this.cbUnPost.setSelected(true);
        this.cbBein.setSelected(true);
        this.cbCurrent.setSelected(true);
        this.cbOrigin.setSelected(true);
        this.cbAccount.setSelected(true);
        this.cbAssist.setSelected(true);
        this.cbCompareAmt.setSelected(true);
        this.cbCompareAmt.setEnabled(false);
        this.rbCompareDou.setSelected(true);
        this.bgCompare.add((AbstractButton)this.rbCompareFwd);
        this.bgCompare.add((AbstractButton)this.rbCompareRev);
        this.bgCompare.add((AbstractButton)this.rbCompareDou);
        this.kDTable1.checkParsed();
        this.btnOk.setEnabled(true);
        this.miSmartGenerateBooks.setVisible(false);
        this.cbPosted.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BalanceAnalysisUI.this.cbPosted.isSelected() && !BalanceAnalysisUI.this.cbUnPost.isSelected()) {
                    BalanceAnalysisUI.this.cbUnPost.setSelected(true);
                }
            }
        });
        this.cbUnPost.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BalanceAnalysisUI.this.cbPosted.isSelected() && !BalanceAnalysisUI.this.cbUnPost.isSelected()) {
                    BalanceAnalysisUI.this.cbPosted.setSelected(true);
                }
            }
        });
        this.cbBein.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BalanceAnalysisUI.this.cbBein.isSelected() && !BalanceAnalysisUI.this.cbCurrent.isSelected()) {
                    BalanceAnalysisUI.this.cbCurrent.setSelected(true);
                }
            }
        });
        this.cbCurrent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BalanceAnalysisUI.this.cbBein.isSelected() && !BalanceAnalysisUI.this.cbCurrent.isSelected()) {
                    BalanceAnalysisUI.this.cbBein.setSelected(true);
                }
            }
        });
        this.cbOrigin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!(BalanceAnalysisUI.this.cbOrigin.isSelected() || BalanceAnalysisUI.this.cbLocal.isSelected() || BalanceAnalysisUI.this.cbReport.isSelected())) {
                    BalanceAnalysisUI.this.cbLocal.setSelected(true);
                }
            }
        });
        this.cbLocal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!(BalanceAnalysisUI.this.cbOrigin.isSelected() || BalanceAnalysisUI.this.cbLocal.isSelected() || BalanceAnalysisUI.this.cbReport.isSelected())) {
                    BalanceAnalysisUI.this.cbReport.setSelected(true);
                }
            }
        });
        this.cbReport.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!(BalanceAnalysisUI.this.cbOrigin.isSelected() || BalanceAnalysisUI.this.cbLocal.isSelected() || BalanceAnalysisUI.this.cbReport.isSelected())) {
                    BalanceAnalysisUI.this.cbOrigin.setSelected(true);
                }
            }
        });
        this.cbAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BalanceAnalysisUI.this.cbAccount.isSelected() && !BalanceAnalysisUI.this.cbAssist.isSelected()) {
                    BalanceAnalysisUI.this.cbAssist.setSelected(true);
                }
            }
        });
        this.cbAssist.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BalanceAnalysisUI.this.cbAccount.isSelected() && !BalanceAnalysisUI.this.cbAssist.isSelected()) {
                    BalanceAnalysisUI.this.cbAccount.setSelected(true);
                }
            }
        });
    }

    private void initCompany() throws Exception {
        this.promptCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.CompanyOrgUnitQuery");
        this.promptCompany.setEditable(true);
        this.promptCompany.setEditFormat("$number$");
        this.promptCompany.setCommitFormat("$name$;$number$");
        this.promptCompany.setDisplayFormat("$number$-$name$");
        this.promptCompany.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Integer(0)));
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        sql.append("    and sc.FCurrentPeriodID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        this.promptCompany.setEntityViewInfo(view);
        CompanyOrgUnitInfo company = this.getFirstOrg();
        if (company != null) {
            this.promptCompany.setValue((Object)new Object[]{company});
        } else {
            this.promptCompany.setValue((Object)new Object[0]);
        }
        this.promptCompany.addDataChangeListener(this.companyListener);
        this.initPeriod();
        this.initTable();
    }

    private CompanyOrgUnitInfo getFirstOrg() {
        IRowSet rs;
        StringBuffer sql;
        Map context = this.getUIContext();
        if (context.get("company") != null) {
            return (CompanyOrgUnitInfo)context.get("company");
        }
        String companyId = null;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company != null && company.isIsBizUnit() && !company.isIsSealUp()) {
            sql = new StringBuffer();
            sql.append("select c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            sql.append("    and c.FID = '" + company.getId().toString() + "' \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = company.getId().toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId == null) {
            sql = new StringBuffer();
            sql.append("select top 1 c.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
            sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
            sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    companyId = rs.getString("FID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyId != null) {
            try {
                return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void initTable() throws Exception {
        this.cbTable.removeItemListener(this.tableListener);
        this.cbTable.setEnabled(false);
        this.prmptAccount.setEnabled(false);
        this.cbTable.removeAllItems();
        this.prmptAccount.setValue(null);
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects != null && objects.length > 0) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)objects[0];
            this.cbTable.addItems(this.getAccountTables(company).toArray());
            GlUtils.setSelectedItem(this.cbTable, (CoreBaseInfo)company.getAccountTable());
            this.cbTable.setEnabled(true);
            this.prmptAccount.setEnabled(true);
            this.cbTable.addItemListener(this.tableListener);
            this.initAccount();
        }
    }

    private AccountTableCollection getAccountTables(CompanyOrgUnitInfo company) throws BOSException {
        try {
            HashSet<String> ids = new HashSet<String>();
            ids.add(company.getAccountTable().getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("refType", (Object)1));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("disabledAcctTable.id"));
            sic.add(new SelectorItemInfo("enabledAcctTable.id"));
            view.setSelector(sic);
            AccountRefContrastCollection col = AccountRefContrastFactory.getRemoteInstance().getAccountRefContrastCollection(view);
            if (col.size() > 0) {
                for (int i = 0; i < col.size(); ++i) {
                    AccountRefContrastInfo info = col.get(i);
                    if (info.getDisabledAcctTable() != null && info.getDisabledAcctTable().getId() != null) {
                        ids.add(info.getDisabledAcctTable().getId().toString());
                    }
                    if (info.getEnabledAcctTable() == null || info.getEnabledAcctTable().getId() == null) continue;
                    ids.add(info.getEnabledAcctTable().getId().toString());
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            evi.setFilter(filter2);
            return AccountTableFactory.getRemoteInstance().getAccountTableCollection(evi);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new AccountTableCollection();
        }
    }

    protected void initAccount() throws Exception {
        this.prmptAccount.setEnabled(false);
        this.prmptAccount.setValue(null);
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects != null && objects.length > 0) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)objects[0];
            AccountTableInfo table = (AccountTableInfo)this.cbTable.getSelectedItem();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            if (table != null) {
                fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
            } else {
                fic.add(new FilterItemInfo("accountTableID.id", (Object)"emptyid"));
            }
            filter.setMaskString("#0 and #1");
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, table, filter, false, false);
            this.prmptAccount.setValue(null);
            this.prmptAccount.setEditable(false);
            this.prmptAccount.setEditFormat("$number$");
            this.prmptAccount.setCommitFormat("$helpCode$;$name$;$number$");
            this.prmptAccount.setDisplayFormat("$number$ - $name$");
            this.prmptAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            this.prmptAccount.setEnabledMultiSelection(true);
            this.prmptAccount.setSelector((KDPromptSelector)apb);
            this.prmptAccount.setEnabled(true);
        }
    }

    private void initPeriod() throws Exception {
        this.periodFrom.setEnabled(false);
        this.periodTo.setEnabled(false);
        this.spHistorys.setEnabled(false);
        this.spFutures.setEnabled(false);
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects == null || objects.length == 0) {
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
            this.spHistorys.setValue((Object)0);
            this.spFutures.setValue((Object)0);
            return;
        }
        if (objects.length == 1) {
            CompanyOrgUnitInfo company = this.queryCompany((CompanyOrgUnitInfo)objects[0]);
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            EntityViewInfo tView = new EntityViewInfo();
            FilterInfo tFilter = new FilterInfo();
            tView.setFilter(tFilter);
            tFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            tFilter.getFilterItems().add(new FilterItemInfo("number", (Object)curPeriod.getNumber(), CompareType.GREATER));
            SelectorItemCollection tSelector = new SelectorItemCollection();
            tSelector.add("number");
            tView.setSelector(tSelector);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo si = new SorterItemInfo("number");
            si.setSortType(SortType.ASCEND);
            sorter.add(si);
            tView.setSorter(sorter);
            PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(tView);
            int maxPeriod = curPeriod.getNumber();
            if (coll.size() >= this.maxFuture) {
                maxPeriod = coll.get(this.maxFuture - 1).getNumber();
            } else if (coll.size() > 0) {
                maxPeriod = coll.get(coll.size() - 1).getNumber();
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod.getNumber(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)maxPeriod, CompareType.LESS_EQUALS));
            this.periodFrom.setEntityViewInfo(view);
            this.periodTo.setEntityViewInfo(view);
            this.periodFrom.setValue((Object)curPeriod);
            this.periodTo.setValue((Object)curPeriod);
            this.periodFrom.setEnabled(true);
            this.periodTo.setEnabled(true);
            this.spHistorys.setValue((Object)0);
            this.spFutures.setValue((Object)0);
        } else {
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
            this.spHistorys.setEnabled(true);
            this.spFutures.setEnabled(true);
        }
    }

    private CompanyOrgUnitInfo queryCompany(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getAccountPeriodType() != null) {
            return company;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountPeriodType.id");
        CompanyOrgUnitInfo c = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
        company.setAccountPeriodType(c.getAccountPeriodType());
        return company;
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionComfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        final ArrayList<CompanyOrgUnitInfo> companys = new ArrayList<CompanyOrgUnitInfo>();
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects == null || objects.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SelectOrg"));
            return;
        }
        final int mode = objects.length == 1 ? 1 : 2;
        final HashMap<String, Object> params = new HashMap<String, Object>();
        String strExtends = this.txtExtends.getText();
        if (strExtends != null && strExtends.trim().length() > 0 && (strExtends = strExtends.trim()).length() > 0) {
            if (strExtends.startsWith("{") && strExtends.endsWith("}")) {
                Map exs = (Map)JSON.parseObject((String)strExtends, Map.class);
                params.putAll(exs);
            } else {
                String[] strs;
                for (String str : strs = strExtends.trim().split(";")) {
                    int index = str.indexOf("=");
                    if (index <= 0) continue;
                    String key = str.substring(0, index).trim();
                    String value = str.substring(index + 1).trim();
                    if (key.length() <= 0 || value.length() <= 0) continue;
                    params.put(key, value);
                }
            }
        }
        if (mode == 1) {
            companys.add((CompanyOrgUnitInfo)objects[0]);
            PeriodInfo periodfrom = null;
            PeriodInfo periodto = null;
            Object ofrom = this.periodFrom.getValue();
            Object oto = this.periodTo.getValue();
            if (ofrom instanceof PeriodInfo) {
                periodfrom = (PeriodInfo)ofrom;
            } else {
                this.periodFrom.setValue(null);
            }
            if (oto instanceof PeriodInfo) {
                periodto = (PeriodInfo)oto;
            } else {
                this.periodTo.setValue(null);
            }
            if (periodfrom == null || periodto == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"selectPeriod"));
                return;
            }
            if (periodfrom.getPeriodYear() > periodto.getPeriodYear() || periodfrom.getPeriodYear() == periodto.getPeriodYear() && periodfrom.getPeriodNumber() > periodto.getPeriodNumber()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartPeriodMoreThanEndPeriod"));
                return;
            }
            params.put("periodFrom", periodfrom);
            params.put("periodTo", periodto);
        } else {
            params.put("AnaBal_Historys", (Integer)this.spHistorys.getValue());
            params.put("AnaBal_Futures", (Integer)this.spFutures.getValue());
            HashSet<String> companyNumbers = new HashSet<String>();
            String strCompany = this.txtCompany.getText();
            if (strCompany != null && strCompany.trim().length() > 0) {
                String[] strs;
                for (String str : strs = strCompany.trim().split(";")) {
                    String[] ss;
                    for (String s : ss = str.trim().split(" ")) {
                        if (s.trim().length() <= 0) continue;
                        companyNumbers.add(s.trim());
                    }
                }
            }
            HashSet<String> exCompanyNumbers = new HashSet<String>();
            Object[] strExCompany = this.txtExCompany.getText();
            if (strExCompany != null && strExCompany.trim().length() > 0) {
                String[] strs;
                for (String str : strs = strExCompany.trim().split(";")) {
                    String[] ss;
                    for (String s : ss = str.trim().split(" ")) {
                        if (s.trim().length() <= 0) continue;
                        exCompanyNumbers.add(s.trim());
                    }
                }
            }
            for (Object object : objects) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)object;
                boolean ok = true;
                if (companyNumbers.size() > 0 && !companyNumbers.contains(company.getNumber())) {
                    ok = false;
                }
                if (ok && exCompanyNumbers.size() > 0 && exCompanyNumbers.contains(company.getNumber())) {
                    ok = false;
                }
                if (!ok) continue;
                companys.add(company);
            }
            if (companys.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SelectOrg"));
                return;
            }
        }
        HashSet<String> accountNumbers = new HashSet<String>();
        Object objAccount = this.prmptAccount.getValue();
        if (objAccount instanceof AccountViewInfo) {
            accountNumbers.add(((AccountViewInfo)objAccount).getNumber());
        } else if (objAccount instanceof Object[]) {
            Object[] objAccounts;
            for (Object obj : objAccounts = (Object[])objAccount) {
                if (!(obj instanceof AccountViewInfo)) continue;
                accountNumbers.add(((AccountViewInfo)obj).getNumber());
            }
        }
        String strAccount = this.txtAccount.getText();
        if (strAccount != null) {
            String[] strAccounts;
            strAccount = strAccount.trim();
            for (String str : strAccounts = strAccount.split(";")) {
                if ((str = str.trim()).length() <= 0) continue;
                accountNumbers.add(str);
            }
        }
        params.put("accountNumbers", accountNumbers);
        int r = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"AnalysisWarn"));
        if (r != 0) {
            return;
        }
        params.put("AnaBal_Posted", this.cbPosted.isSelected());
        params.put("AnaBal_UnPost", this.cbUnPost.isSelected());
        params.put("AnaBal_Begin", this.cbBein.isSelected());
        params.put("AnaBal_Current", this.cbCurrent.isSelected());
        int cyType = 0;
        if (this.cbOrigin.isSelected()) {
            cyType |= 1;
        }
        if (this.cbLocal.isSelected()) {
            cyType |= 2;
        }
        if (this.cbReport.isSelected()) {
            cyType |= 4;
        }
        params.put("AnaBal_Currency", cyType);
        params.put("AnaBal_ShowName", this.cbShowName.isSelected());
        params.put("AnaBal_CompareFwd", this.rbCompareFwd.isSelected());
        params.put("AnaBal_CompareRev", this.rbCompareRev.isSelected());
        params.put("AnaBal_CompareDou", this.rbCompareDou.isSelected());
        params.put("AnaBal_Account", this.cbAccount.isSelected());
        params.put("AnaBal_Assist", this.cbAssist.isSelected());
        params.put("AnaBal_CompareAmt", this.cbCompareAmt.isSelected());
        params.put("AnaBal_CompareQty", this.cbCompareQty.isSelected());
        params.put("AnaBal_ComparePNL", this.cbComparePNL.isSelected());
        int maxSize = (Integer)this.spMaxRecord.getValue();
        if (maxSize == 0) {
            maxSize = Integer.MAX_VALUE;
        }
        params.put("AnaBal_MaxSize", maxSize);
        final boolean repair = this.cbRepair.isSelected();
        params.put("AnaBal_Repair", repair);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BalanceAnalysisUI.this.tfInfo.setText("");
                    BalanceAnalysisUI.this.kDTable1.removeRows();
                    int ocount = 0;
                    int rcount = 0;
                    if (mode == 1) {
                        BalanceAnalysisUI.this.actionComfirm.setEnabled(false);
                        BalanceAnalysisUI.this.btnOk.setEnabled(false);
                    } else {
                        BalanceAnalysisUI.this.btnOk.putClientProperty((Object)"canStop", (Object)true);
                        BalanceAnalysisUI.this.btnOk.setText(EASResource.getString((String)BalanceAnalysisUI.RES, (String)"Stop"));
                    }
                    BalanceAnalysisUI.this.enableComponent(mode, false);
                    for (int i = 0; i < companys.size(); ++i) {
                        CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)companys.get(i);
                        try {
                            BalanceAnalysisUI.this.tfInfo.setText(EASResource.getString((String)BalanceAnalysisUI.RES, (String)"Analysis") + " (" + (i + 1) + "/" + companys.size() + ") " + c.getName() + "[" + c.getNumber() + "] ...");
                            Map result = (Map)GLBalanceAnaFacadeFactory.getRemoteInstance().analysis(c.getId().toString(), params);
                            String message = (String)result.get("message");
                            if (message != null) {
                                BalanceAnalysisUI.this.showCompany(c, null, message, i % 2 != 0 ? bgColor : null, Color.RED);
                            } else if (repair) {
                                if (result.get("isNeedRepair") != null) {
                                    String periodMsg = ((PeriodInfo)result.get("periodfrom")).getNumber() + "-" + ((PeriodInfo)result.get("periodto")).getNumber();
                                    Map rresult = BalanceAnalysisUI.this.repair(c, result);
                                    String status = (String)rresult.get("status");
                                    if ("Success".equals(status)) {
                                        BalanceAnalysisUI.this.showCompany(c, periodMsg, EASResource.getString((String)BalanceAnalysisUI.RES, (String)"RepairSuccess"), i % 2 != 0 ? bgColor : null, successColor);
                                        ++ocount;
                                    } else {
                                        BalanceAnalysisUI.this.showCompany(c, periodMsg, (String)rresult.get("message"), i % 2 != 0 ? bgColor : null, Color.RED);
                                    }
                                } else {
                                    BalanceAnalysisUI.this.showCompany(c, null, EASResource.getString((String)BalanceAnalysisUI.RES, (String)"NoNeedRepair"), i % 2 != 0 ? bgColor : null, null);
                                }
                            } else {
                                List list = (List)result.get("errors");
                                rcount += list.size();
                                BalanceAnalysisUI.this.showRecords(result, list, ocount % 2 != 0 ? bgColor : null);
                                if (list.size() > 0) {
                                    ++ocount;
                                }
                            }
                        }
                        catch (Exception e) {
                            String balMsg = repair ? EASResource.getString((String)BalanceAnalysisUI.RES, (String)"RepairError") : EASResource.getString((String)BalanceAnalysisUI.RES, (String)"AnalysisError");
                            BalanceAnalysisUI.this.showCompany(c, null, balMsg, i % 2 != 0 ? bgColor : null, Color.RED);
                            logger.error((Object)balMsg, (Throwable)e);
                        }
                        if (BalanceAnalysisUI.this.stop) break;
                    }
                    if (repair) {
                        BalanceAnalysisUI.this.tfInfo.setText(EASResource.getString((String)BalanceAnalysisUI.RES, (String)"RepairResult", (Object[])new Object[]{companys.size(), ocount}));
                    } else {
                        BalanceAnalysisUI.this.tfInfo.setText(EASResource.getString((String)BalanceAnalysisUI.RES, (String)"AnalysisResult", (Object[])new Object[]{companys.size(), rcount}));
                    }
                }
                finally {
                    BalanceAnalysisUI.this.btnOk.setText(EASResource.getString((String)BalanceAnalysisUI.RES, (String)"Execute"));
                    BalanceAnalysisUI.this.enableComponent(mode, true);
                    BalanceAnalysisUI.this.actionComfirm.setEnabled(true);
                    BalanceAnalysisUI.this.btnOk.setEnabled(true);
                    BalanceAnalysisUI.this.btnOk.putClientProperty((Object)"canStop", null);
                    BalanceAnalysisUI.this.stop = false;
                }
            }
        }).start();
    }

    private void enableComponent(int mode, boolean enable) {
        this.promptCompany.setEnabled(enable);
        this.txtCompany.setEnabled(enable);
        this.txtExCompany.setEnabled(enable);
        if (mode == 1) {
            this.periodFrom.setEnabled(enable);
            this.periodTo.setEnabled(enable);
        } else {
            this.spHistorys.setEnabled(enable);
            this.spFutures.setEnabled(enable);
        }
        this.spMaxRecord.setEnabled(enable);
        this.cbPosted.setEnabled(enable);
        this.cbUnPost.setEnabled(enable);
        this.cbBein.setEnabled(enable);
        this.cbCurrent.setEnabled(enable);
        this.cbOrigin.setEnabled(enable);
        this.cbLocal.setEnabled(enable);
        this.cbReport.setEnabled(enable);
        this.cbShowName.setEnabled(enable);
        this.rbCompareFwd.setEnabled(enable);
        this.rbCompareRev.setEnabled(enable);
        this.rbCompareDou.setEnabled(enable);
        this.cbAccount.setEnabled(enable);
        this.cbAssist.setEnabled(enable);
        this.cbCompareQty.setEnabled(enable);
        this.cbComparePNL.setEnabled(enable);
        this.cbRepair.setEnabled(enable);
        this.cbTable.setEnabled(enable);
        this.prmptAccount.setEnabled(enable);
        this.txtAccount.setEnabled(enable);
        this.txtExtends.setEnabled(enable);
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    private Map repair(CompanyOrgUnitInfo company, Map param) throws Exception {
        return GLBalanceRepairFacadeFactory.getRemoteInstance().repairCompany(param);
    }

    private void showRecords(final Map result, final List<Map<String, Object>> list, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Map data : list) {
                    BalanceAnalysisUI.this.showRecord(result, data, BalanceAnalysisUI.this.isPnlNotEqual(data), color);
                }
            }
        });
    }

    private void showRecord(Map result, Map<String, Object> data, boolean isPnl, Color color) {
        Integer balType;
        IRow row = this.kDTable1.addRow();
        Integer anaPt = (Integer)data.get("anaPt");
        if (anaPt == null) {
            anaPt = 1;
        }
        row.getCell("company").setValue(result.get("company"));
        row.getCell("startPeriod").setValue(result.get("startPeriod"));
        row.getCell("currentPeriod").setValue(result.get("currentPeriod"));
        row.getCell("period").setValue(data.get("period"));
        if (anaPt == 1 || anaPt == 11) {
            if (anaPt == 11) {
                row.getCell("period").getStyleAttributes().setItalic(true);
            }
        } else if (anaPt == 2 || anaPt == 21) {
            row.getCell("period").getStyleAttributes().setFontColor(curColor);
            if (anaPt == 21) {
                row.getCell("period").getStyleAttributes().setItalic(true);
            }
        } else {
            row.getCell("period").getStyleAttributes().setFontColor(futColor);
        }
        if ((balType = (Integer)data.get("balType")) == 5) {
            row.getCell("balType").setValue((Object)EASResource.getString((String)RES, (String)"Posted"));
        } else {
            row.getCell("balType").setValue((Object)EASResource.getString((String)RES, (String)"UnPost"));
        }
        Integer sourceType = (Integer)data.get("sourceType");
        if (sourceType == 2) {
            row.getCell("sourceType").setValue((Object)EASResource.getString((String)RES, (String)"Current"));
        } else {
            row.getCell("sourceType").setValue((Object)EASResource.getString((String)RES, (String)"Begin"));
        }
        row.getCell("currency").setValue(data.get("currency"));
        row.getCell("account").setValue(data.get("account"));
        row.getCell("accountTable").setValue(data.get("accountTable"));
        row.getCell("currentAccountTable").setValue(result.get("currentAccountTable"));
        row.getCell("assist").setValue(data.get("assist"));
        row.getCell("curBegAmount").setValue(data.get("curBegAmount"));
        row.getCell("preEndAmount").setValue(data.get("preEndAmount"));
        row.getCell("curBegQty").setValue(data.get("curBegQty"));
        row.getCell("preEndQty").setValue(data.get("preEndQty"));
        if (isPnl) {
            row.getCell("balDebitAmount").setValue(data.get("balMonthPnlAmount"));
            row.getCell("vchDebitAmount").setValue(data.get("vchMonthPnlAmount"));
            row.getCell("balDebitQty").setValue(data.get("balMonthPnlQty"));
            row.getCell("vchDebitQty").setValue(data.get("vchMonthPnlQty"));
            row.getCell("balCreditAmount").setValue((Object)"PNL");
            row.getCell("vchCreditAmount").setValue((Object)"PNL");
            row.getCell("balCreditQty").setValue((Object)"PNL");
            row.getCell("vchCreditQty").setValue((Object)"PNL");
        } else {
            row.getCell("balDebitAmount").setValue(data.get("balDebitAmount"));
            row.getCell("vchDebitAmount").setValue(data.get("vchDebitAmount"));
            row.getCell("balDebitQty").setValue(data.get("balDebitQty"));
            row.getCell("vchDebitQty").setValue(data.get("vchDebitQty"));
            row.getCell("balCreditAmount").setValue(data.get("balCreditAmount"));
            row.getCell("vchCreditAmount").setValue(data.get("vchCreditAmount"));
            row.getCell("balCreditQty").setValue(data.get("balCreditQty"));
            row.getCell("vchCreditQty").setValue(data.get("vchCreditQty"));
        }
        if (color != null) {
            row.getStyleAttributes().setBackground(color);
        }
    }

    private boolean isPnlNotEqual(Map<String, Object> data) {
        Integer sourceType = (Integer)data.get("sourceType");
        if (sourceType != 2) {
            return false;
        }
        BigDecimal balDebitAmount = (BigDecimal)data.get("balDebitAmount");
        BigDecimal vchDebitAmount = (BigDecimal)data.get("vchDebitAmount");
        BigDecimal balDebitQty = (BigDecimal)data.get("balDebitQty");
        BigDecimal vchDebitQty = (BigDecimal)data.get("vchDebitQty");
        BigDecimal balCreditAmount = (BigDecimal)data.get("balCreditAmount");
        BigDecimal vchCreditAmount = (BigDecimal)data.get("vchCreditAmount");
        BigDecimal balCreditQty = (BigDecimal)data.get("balCreditQty");
        BigDecimal vchCreditQty = (BigDecimal)data.get("vchCreditQty");
        if (balDebitAmount.compareTo(vchDebitAmount) != 0 || balDebitQty.compareTo(vchDebitQty) != 0 || balCreditAmount.compareTo(vchCreditAmount) != 0 || balCreditQty.compareTo(vchCreditQty) != 0) {
            return false;
        }
        if (this.cbComparePNL.isSelected()) {
            BigDecimal balMonthPnlAmount = (BigDecimal)data.get("balMonthPnlAmount");
            BigDecimal vchMonthPnlAmount = (BigDecimal)data.get("vchMonthPnlAmount");
            BigDecimal balMonthPnlQty = (BigDecimal)data.get("balMonthPnlQty");
            BigDecimal vchMonthPnlQty = (BigDecimal)data.get("vchMonthPnlQty");
            if (balMonthPnlAmount != null && balMonthPnlAmount.compareTo(vchMonthPnlAmount) != 0 || balMonthPnlQty != null && balMonthPnlQty.compareTo(vchMonthPnlQty) != 0) {
                return true;
            }
        }
        return false;
    }

    private void showCompany(final CompanyOrgUnitInfo company, final String periodMsg, final String balMsg, final Color bgColor, final Color fontColor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IRow row = BalanceAnalysisUI.this.kDTable1.addRow();
                row.getCell("company").setValue((Object)company.getNumber());
                if (periodMsg != null) {
                    row.getCell("period").setValue((Object)periodMsg);
                }
                if (balMsg != null) {
                    row.getCell("balType").setValue((Object)balMsg);
                }
                if (bgColor != null) {
                    row.getStyleAttributes().setBackground(bgColor);
                }
                if (fontColor != null) {
                    row.getStyleAttributes().setFontColor(fontColor);
                }
            }
        });
    }

    protected void initTableStyle() {
    }

    @Override
    public void actionServerConfig_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)"GLServerConfig");
        uiContext.put((Object)"name", (Object)this.miServerConfig.getText());
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.GLConfigUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionBalanceRepair_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects != null && objects.length > 0) {
            uiContext.put((Object)"company", objects[0]);
            if (objects.length == 1) {
                Object ofrom = this.periodFrom.getValue();
                Object oto = this.periodTo.getValue();
                if (ofrom instanceof PeriodInfo) {
                    uiContext.put((Object)"periodfrom", ofrom);
                }
                if (oto instanceof PeriodInfo) {
                    uiContext.put((Object)"periodto", oto);
                }
            }
            AccountTableInfo table = (AccountTableInfo)this.cbTable.getSelectedItem();
            uiContext.put((Object)"table", (Object)table);
            Object objAccount = this.prmptAccount.getValue();
            uiContext.put((Object)"accounts", objAccount);
            String strAccount = this.txtAccount.getText();
            uiContext.put((Object)"strAccounts", (Object)strAccount);
        }
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.BalanceRepairUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionBalanceRepairOld_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.BalanceModifyUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionPcaBalanceAnalysis_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.ma.pca.client.PcaBalanceAnalysisUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionPcaBalanceRepair_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.pca.client.PcaBalanceRepairUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionBalanceClear_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.BalanceClearUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionHG_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.AssistantHgListUI", this.getUIContext(), null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionARCPVoucher_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.AccountRefContrastProcessVchMgrUI", this.getUIContext(), null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionSmartGenerateBooks_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.SmartGenerateBooksUI", this.getUIContext(), null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionAACVoucher_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.AsstAccountChangeVchMgrUI", this.getUIContext(), null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionHGChange_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.AssistantHGChangeUI", this.getUIContext(), null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionAsstActUnite_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.AsstActUniteUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }
}

