/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.IPeriodTransFacade;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractBalanceClearUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class BalanceClearUI
extends AbstractBalanceClearUI {
    private static final long serialVersionUID = -5060903161596126052L;
    private static final Logger logger = CoreUIObject.getLogger(BalanceClearUI.class);
    private boolean isCancel = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.bizPromCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.CompanyOrgUnitQuery");
        this.bizPromCompany.setEditable(true);
        this.bizPromCompany.setEditFormat("$number$");
        this.bizPromCompany.setCommitFormat("$helpCode$;$name$;$number$");
        this.bizPromCompany.setDisplayFormat("$number$ - $name$");
        this.bizPromCompany.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        view.setFilter(filter);
        this.bizPromCompany.setEntityViewInfo(view);
        this.bizPromCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object[] companys = (Object[])BalanceClearUI.this.bizPromCompany.getValue();
                HashSet<String> periodTypeSet = new HashSet<String>();
                for (int i = 0; i < companys.length; ++i) {
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys[i];
                    if (company.getAccountPeriodType() == null) continue;
                    periodTypeSet.add(company.getAccountPeriodType().getId().toString());
                }
                if (periodTypeSet.size() > 0) {
                    FilterInfo pfilter = new FilterInfo();
                    pfilter.getFilterItems().add(new FilterItemInfo("periodType.id", periodTypeSet, CompareType.INCLUDE));
                    EntityViewInfo periodView = new EntityViewInfo();
                    periodView.setFilter(pfilter);
                    BalanceClearUI.this.bizPromStartPeriod.setEntityViewInfo(periodView);
                    BalanceClearUI.this.bizPromEndPeriod.setEntityViewInfo(periodView);
                }
            }
        });
        this.bizPromStartPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.bizPromStartPeriod.setEditable(true);
        this.bizPromStartPeriod.setEditFormat("$number$");
        this.bizPromStartPeriod.setCommitFormat("$number$");
        this.bizPromEndPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.bizPromEndPeriod.setEditable(true);
        this.bizPromEndPeriod.setEditFormat("$number$");
        this.bizPromEndPeriod.setCommitFormat("$number$");
        this.btnClear.setAction((Action)((Object)this.actionClear));
        this.btnCancel.setAction((Action)((Object)this.actionCancel));
        this.progressBar.setVisible(false);
        this.progressBar.updateUI();
        this.progressBar.setStringPainted(false);
        this.progressBar.setString("");
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(1000);
        this.progressBar.setIndeterminate(true);
        this.txtMsg.setAutoscrolls(true);
        this.txtMsg.setEditable(false);
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        Object[] companys = (Object[])this.bizPromCompany.getValue();
        if (companys == null) {
            return;
        }
        PeriodInfo startPeriod = (PeriodInfo)this.bizPromStartPeriod.getValue();
        if (startPeriod == null) {
            return;
        }
        PeriodInfo endPeriod = (PeriodInfo)this.bizPromEndPeriod.getValue();
        if (endPeriod == null) {
            return;
        }
        final HashMap<CompanyOrgUnitInfo, PeriodCollection> periodColls = new HashMap<CompanyOrgUnitInfo, PeriodCollection>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("periodYear");
        view.getSelector().add("periodNumber");
        view.getSelector().add("number");
        view.getSorter().add(new SorterItemInfo("number"));
        for (int i = 0; i < companys.length; ++i) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys[i];
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(startPeriod.getNumber()), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)new Integer(endPeriod.getNumber()), CompareType.LESS_EQUALS));
            view.setFilter(filter);
            PeriodCollection periodColl = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
            periodColls.put(company, periodColl);
        }
        Thread worker = new Thread(new Runnable(){

            @Override
            public void run() {
                BalanceClearUI.this.setActionClearStatus(false);
                BalanceClearUI.this.txtMsg.setText(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"356_BalanceClearUI"));
                try {
                    BalanceClearUI.this.clearEnptyBalance(periodColls);
                }
                catch (BOSException ex) {
                    BalanceClearUI.this.addMsg(ex.getMessage());
                }
                finally {
                    BalanceClearUI.this.setActionClearStatus(true);
                    BalanceClearUI.this.addMsg(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"357_BalanceClearUI"));
                }
            }
        });
        worker.start();
    }

    private synchronized void setActionClearStatus(boolean enable) {
        this.actionClear.setEnabled(enable);
        this.progressBar.setVisible(!enable);
    }

    private void clearEnptyBalance(Map<CompanyOrgUnitInfo, PeriodCollection> periodColls) throws BOSException {
        IPeriodTransFacade facade = PeriodTransFacadeFactory.getRemoteInstance();
        int total = 0;
        for (CompanyOrgUnitInfo company : periodColls.keySet()) {
            String companyId = company.getId().toString();
            Iterator it = periodColls.get(company).iterator();
            while (it.hasNext()) {
                if (this.isCancel) {
                    return;
                }
                PeriodInfo period = (PeriodInfo)it.next();
                int num = facade.clearEmptyBalance(companyId, period.getId().toString());
                if (num <= 0) continue;
                total += num;
                StringBuffer sb = new StringBuffer(company.getName());
                sb.append("-").append(period.toString());
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"358_BalanceClearUI"));
                sb.append(num);
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"359_BalanceClearUI"));
                this.addMsg(sb.toString());
            }
        }
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"360_BalanceClearUI"));
        sb.append(total).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"359_BalanceClearUI"));
        this.addMsg(sb.toString());
    }

    private void addMsg(String msg) {
        this.txtMsg.append("\r\n");
        this.txtMsg.append(msg);
        this.txtMsg.setCaretPosition(this.txtMsg.getDocument().getLength());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.destroyWindow();
    }
}

