/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.BalanceFunEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IPeriodTransFacade;
import com.kingdee.eas.fi.gl.PeriodTransFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractBalanceModifyUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BalanceModifyUI
extends AbstractBalanceModifyUI {
    private static final Logger logger = CoreUIObject.getLogger(BalanceModifyUI.class);
    CompanyOrgUnitInfo company = null;
    private PeriodInfo curPeriod = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        OrgUnitInfo ou = SysContext.getSysContext().getCurrentOrgUnit();
        if (ou != null) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(ou.getId()), (String)"gl_tool");
        } else {
            SysUtil.abort();
        }
        RptClientUtil.checkFIUnit(false);
        super.onLoad();
        this.initData();
        this.initMyIcon();
    }

    private void initData() throws Exception {
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.txtCompany.setText(this.company.getNumber() + " " + this.company.getName());
        this.cbTable.addItems(InitClientHelp.getAccountTableCollection().toArray());
        this.cbFun.addItems(BalanceFunEnum.getEnumList().toArray());
        this.curPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
        this.periodFrom.setValue((Object)this.curPeriod);
        this.periodTo.setValue((Object)this.curPeriod);
        this.cbFun.setSelectedIndex(1);
    }

    private void initMyIcon() throws Exception {
        GlUtils.setSelectedItem(this.cbTable, (CoreBaseInfo)this.company.getAccountTable());
        this.cbTable.setEnabled(false);
        this.txtCompany.setEditable(false);
        this.periodFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodFrom.setEditable(true);
        this.periodFrom.setEditFormat("$number$");
        this.periodFrom.setCommitFormat("$number$");
        this.periodTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodTo.setEditable(true);
        this.periodTo.setEditFormat("$number$");
        this.periodTo.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString()));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
        if (startPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod.getNumber(), CompareType.GREATER_EQUALS));
        }
        view.setFilter(filter);
        this.periodFrom.setEntityViewInfo(view);
        this.periodTo.setEntityViewInfo(view);
        this.kDTable1.checkParsed();
        this.btnOk.setEnabled(true);
        this.kcbPost.setEnabled(false);
        this.kcbPost.setSelected(true);
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        Object[] objectArray;
        Object[] object;
        HashMap<String, Object> param = new HashMap<String, Object>();
        AccountTableInfo table = (AccountTableInfo)this.cbTable.getSelectedItem();
        BalanceFunEnum balenum = (BalanceFunEnum)((Object)this.cbFun.getSelectedItem());
        PeriodInfo periodfrom = (PeriodInfo)this.periodFrom.getValue();
        PeriodInfo periodto = (PeriodInfo)this.periodTo.getValue();
        Boolean isPost = this.kcbPost.isSelected();
        if (periodfrom == null || periodto == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"260_BalanceModifyUI"));
            return;
        }
        if (periodfrom.getPeriodYear() > periodto.getPeriodYear() || periodfrom.getPeriodYear() == periodto.getPeriodYear() && periodfrom.getPeriodNumber() > periodto.getPeriodNumber()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"261_BalanceModifyUI"));
            return;
        }
        param.put("table", table.getId().toString());
        param.put("company", this.company.getId().toString());
        param.put("companyNumber", this.company.getNumber());
        param.put("function", (Object)balenum);
        param.put("periodfrom", periodfrom);
        param.put("post", isPost);
        String period = periodfrom.getPeriodYear() + "." + periodfrom.getPeriodNumber();
        if (periodto != null) {
            param.put("periodto", periodto);
            period = period + "-" + periodto.getPeriodYear() + "." + periodto.getPeriodNumber();
        }
        if ((object = this.prmptAccount.getValue()) == null) {
            object = new Object[]{};
        }
        if (object instanceof Object[]) {
            objectArray = object;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        Object[] selectedAV = objectArray;
        ArrayList<String> avIDs = new ArrayList<String>();
        for (int i = 0; i < selectedAV.length; ++i) {
            if (!(selectedAV[i] instanceof AccountViewInfo)) continue;
            AccountViewInfo account = (AccountViewInfo)selectedAV[i];
            avIDs.add(account.getId().toString());
        }
        param.put("selectedAV", avIDs);
        StringBuffer numbers = new StringBuffer();
        if (selectedAV.length > 0) {
            int count = 0;
            for (int i = 0; i < selectedAV.length; ++i) {
                String accountNumber;
                if (!(selectedAV[i] instanceof AccountViewInfo) || (accountNumber = ((AccountViewInfo)selectedAV[i]).getNumber()) == null) continue;
                if (numbers.length() + accountNumber.length() > 1000) break;
                if (++count > 1) {
                    numbers.append(",");
                }
                numbers.append(accountNumber);
            }
            if (selectedAV.length > count) {
                numbers.append(",...");
            }
        } else {
            numbers.append("all");
        }
        param.put("selectedAVNumbers", numbers.toString());
        String result = this.check(param);
        if (result == null) {
            result = this.doOk(param);
        }
        if (result != null) {
            IRow row = this.kDTable1.addRow();
            row.getCell("table").setValue((Object)table.getName());
            row.getCell("function").setValue((Object)balenum.getAlias());
            row.getCell("period").setValue((Object)period);
            row.getCell("post").setValue((Object)isPost);
            row.getCell("result").setValue((Object)result);
        }
    }

    private String check(Map param) throws Exception {
        return this.getFacade().check(param);
    }

    private String doOk(Map param) throws Exception {
        return this.getFacade().doOK(param);
    }

    private IPeriodTransFacade getFacade() throws Exception {
        return PeriodTransFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void cbTable_itemStateChanged(ItemEvent e) throws Exception {
        AccountTableInfo table = (AccountTableInfo)this.cbTable.getSelectedItem();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
        fic.add(new FilterItemInfo("level", (Object)new Integer(1)));
        filter.setMaskString("#0 and #1 and #2");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.company, filter, false, false);
        this.prmptAccount.setValue(null);
        this.prmptAccount.setEditable(false);
        this.prmptAccount.setEditFormat("$number$");
        this.prmptAccount.setCommitFormat("$helpCode$;$name$;$number$");
        this.prmptAccount.setDisplayFormat("$number$ - $name$");
        this.prmptAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prmptAccount.setEnabledMultiSelection(true);
        this.prmptAccount.setSelector((KDPromptSelector)apb);
    }
}

