/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.RequisitionStatusEnum;
import com.kingdee.eas.fi.gl.client.AbstractCFRequisitionCorrelationFilterUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.cslacct.util.Constant;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CFRequisitionCorrelationFilterUI
extends AbstractCFRequisitionCorrelationFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CFRequisitionCorrelationFilterUI.class);
    public static final String PARAM_CURRENT_COMPANY_ID = "currentCompanyId";
    public static final String PARAM_CURRENT_COMPANY = "currentCompany";
    public static final String PARAM_STATUS = "status";
    public static final String PARAM_CURRENCY = "currency";
    public static final String PARAM_PRIMARY_ITEM = "primaryItem";
    public static final String PARAM_OPP_COMPANY = "oppCompany";
    public static final String PARAM_END_DATE = "endDate";
    public static final String PARAM_START_DATE = "startDate";
    public static final String PARAM_PERIODNUMBER_TO = "periodnumberto";
    public static final String PARAM_PERIODYEAR_TO = "periodyearto";
    public static final String PARAM_PERIODNUMBER_FROM = "periodnumberfrom";
    public static final String PARAM_PERIODYEAR_FROM = "periodyearfrom";
    public static final String QUERY_BY_COLLECT = "collect";
    public static final String QUERY_BY_DETAIL = "detail";
    public static final String QUERY_FASHION = "query_fashion";
    public static final String QUERY_DisplayCanCheck = "query_DisplayCanCheck";
    public static final String BY_PERIOD = "byPeriod";
    public static final String QUERY_BY_DATE = "byDate";
    public static final String DATE_FASHION = "date_fashion";
    public static final String START_BEFORE_END = "StartBeforeEnd";
    public static final String DATE_MANDATORY = "DateMandatory";
    public static final String GET_PARAM_ERROR = "GetParamError";
    public static final String PARAM_NOT_ENABLE = "ParamNotEnable";
    public static final String CFREQ_RES = "com.kingdee.eas.fi.gl.CFRequisitionResource";
    private CompanyOrgUnitInfo company = null;
    public PeriodInfo curPeriod = null;
    private CurrencyCollection currencys = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.pnlByPeriod.setVisible(true);
        this.pnlByDate.setVisible(false);
        this.company = InitClientHelp.getCurrentCompany();
        this.checkOut();
        ICFRequisition icf = CFRequisitionFactory.getRemoteInstance();
        boolean isEnable = false;
        try {
            isEnable = icf.isEnableCFRequisition(this.company.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getResource(GET_PARAM_ERROR, null), (String)e.getMessage(), (int)0);
            SysUtil.abort();
        }
        if (!isEnable) {
            MsgBox.showInfo((String)this.getResource(PARAM_NOT_ENABLE, null));
            SysUtil.abort();
        }
        IGLPeriodEndFacade ctrl = GLPeriodEndFacadeFactory.getRemoteInstance();
        GlUtils.AccountPeriodInfo pi = ctrl.getAccountPeriod(this.company.getId().toString(), this.company.getAccountPeriodType().getId().toString());
        this.curPeriod = pi.curPeriod;
        this.chkCollect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CFRequisitionCorrelationFilterUI.this.chkCollect.getSelected() == 32) {
                    try {
                        CFRequisitionCorrelationFilterUI.this.showQueryItems(false);
                    }
                    catch (BOSException e1) {
                        CFRequisitionCorrelationFilterUI.this.handUIException(e1);
                    }
                } else {
                    try {
                        CFRequisitionCorrelationFilterUI.this.showQueryItems(true);
                    }
                    catch (BOSException e1) {
                        CFRequisitionCorrelationFilterUI.this.handUIException(e1);
                    }
                }
            }
        });
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false, (boolean)false);
        this.refresh();
    }

    protected void checkOut() throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ssc.fid FROM T_BD_SystemStatusCtrol ssc inner join T_BD_SystemStatus ss on ssc.FSYSTEMSTATUSID  = ss.FID \r\n");
        sql.append("where ssc.FCOMPANYID ='").append(this.company.getId().toString()).append("' and ssc.FISSTART = 1 and ss.FNAME =6");
        IRowSet result = SQLDataAccessFactory.getRemoteInstance().getRowSet(sql.toString());
        if (!result.next()) {
            MsgBox.showInfo((String)ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLClosePeriodResource", (String)"GL_SYSTEM_STATUS_ERROR", (Locale)SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void clear() {
        super.clear();
        try {
            this.showQueryItems(true);
            this.refresh();
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
            SysUtil.abort();
        }
    }

    private void refresh() throws EASBizException, BOSException {
        this.refreshPeriod();
        this.refreshDate();
        this.refreshF7();
        CFRequisitionCorrelationFilterUI.refreshList(this.cmbCurrecny, (IObjectCollection)this.getDefaultCurrencys());
        CFRequisitionCorrelationFilterUI.refreshEnumList(this.cmbStatus, RequisitionStatusEnum.iterator());
        this.prmptOppCompany.setValue(null);
        this.prmptMainItem.setValue(null);
        this.chkCollect.setSelected(false);
        this.chkDisplayCanCheck.setSelected(false);
        this.radByPeriod.setSelected(true);
    }

    private void refreshF7() {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this){

            protected FilterInfo handleRuntimeOuterFilterInfo() throws BOSException {
                FilterInfo filter = super.handleRuntimeOuterFilterInfo();
                FilterInfo leafFilter = new FilterInfo();
                leafFilter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)"select fid from t_org_company org where org.fisbizunit = 1 and org.fid = \"ORGSTRUCTURE\".funitid", CompareType.EXISTS));
                if (filter == null) {
                    filter = leafFilter;
                } else {
                    filter.mergeFilter(leafFilter, "AND");
                }
                this.setNeedAddOrgRange(false);
                return filter;
            }
        };
        f7.setCurrentCUID("00000000-0000-0000-0000-000000000000CCE7AED4");
        f7.setNeedAddOrgRange(false);
        this.prmptOppCompany.setSelector((KDPromptSelector)f7);
        this.prmptOppCompany.setValue(null);
        this.prmptOppCompany.setEditable(true);
        this.prmptOppCompany.setEditFormat("$number$");
        this.prmptOppCompany.setDisplayFormat("$number$;$name$");
        this.prmptOppCompany.setCommitFormat("$number$;$name$");
        this.prmptOppCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery4AsstAcct");
        ExtendParser parserPItemTo = new ExtendParser(this.prmptMainItem);
        this.prmptMainItem.setCommitParser((IParser)parserPItemTo);
        this.prmptMainItem.setEditable(true);
        this.prmptMainItem.setEditFormat("$number$");
        this.prmptMainItem.setDisplayFormat("$number$;$name$");
        this.prmptMainItem.setCommitFormat("$number$;$name$");
        this.prmptMainItem.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherCashflowItemQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("type", (Object)new Integer(CashFlowItemType.MASTER_TABLE_ITEM.getValue())));
        fic.add(new FilterItemInfo("isleaf", (Object)new Integer(1)));
        filter.setMaskString("#0 and #1");
        this.prmptMainItem.setEntityViewInfo(view);
    }

    private void refreshDate() throws EASBizException, BOSException {
        if (this.curPeriod != null) {
            Date d = new Date();
            if (d.after(this.curPeriod.getBeginDate())) {
                this.startDate.setValue((Object)this.curPeriod.getBeginDate());
                this.endDate.setValue((Object)d);
            } else {
                this.startDate.setValue((Object)d);
                this.endDate.setValue((Object)this.curPeriod.getEndDate());
            }
        }
    }

    private void refreshPeriod() throws EASBizException, BOSException {
        this.spnYearFrom.setValue((Object)new Integer(this.curPeriod.getPeriodYear()));
        this.spnPeriodFrom.setValue((Object)new Integer(this.curPeriod.getPeriodNumber()));
        this.spnYearTo.setValue((Object)new Integer(this.curPeriod.getPeriodYear()));
        this.spnPeriodTo.setValue((Object)new Integer(this.curPeriod.getPeriodNumber()));
    }

    public Map getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!this.radByDate.isSelected()) {
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            params.put(PARAM_PERIODYEAR_FROM, yearFrom);
            params.put(PARAM_PERIODNUMBER_FROM, periodFrom);
            params.put(PARAM_PERIODYEAR_TO, yearTo);
            params.put(PARAM_PERIODNUMBER_TO, periodTo);
            params.put(DATE_FASHION, BY_PERIOD);
        } else {
            Date startDate = (Date)this.startDate.getValue();
            Date endDate = (Date)this.endDate.getValue();
            if (startDate == null || endDate == null) {
                MsgBox.showWarning((String)this.getResource(DATE_MANDATORY, null));
                SysUtil.abort();
            }
            if (startDate.after(endDate)) {
                MsgBox.showWarning((String)this.getResource(START_BEFORE_END, null));
                SysUtil.abort();
            }
            params.put(DATE_FASHION, QUERY_BY_DATE);
            params.put(PARAM_START_DATE, CFRequisitionCorrelationFilterUI.getFilterDate(startDate, PARAM_START_DATE));
            params.put(PARAM_END_DATE, CFRequisitionCorrelationFilterUI.getFilterDate(endDate, PARAM_END_DATE));
        }
        if (this.prmptOppCompany.getValue() != null) {
            CompanyOrgUnitInfo oppCompany = (CompanyOrgUnitInfo)this.prmptOppCompany.getValue();
            params.put(PARAM_OPP_COMPANY, oppCompany);
        }
        if (this.prmptMainItem.getValue() != null) {
            CashFlowItemInfo primaryItem = (CashFlowItemInfo)this.prmptMainItem.getValue();
            params.put(PARAM_PRIMARY_ITEM, primaryItem);
        }
        if (this.cmbCurrecny.getSelectedItem() != null) {
            params.put(PARAM_CURRENCY, this.cmbCurrecny.getSelectedItem());
        }
        RequisitionStatusEnum status = (RequisitionStatusEnum)((Object)this.cmbStatus.getSelectedItem());
        params.put(PARAM_STATUS, (Object)status);
        if (!this.chkCollect.isSelected()) {
            params.put(QUERY_FASHION, QUERY_BY_DETAIL);
        } else {
            params.put(QUERY_FASHION, QUERY_BY_COLLECT);
        }
        if (this.chkDisplayCanCheck.isSelected()) {
            params.put(QUERY_DisplayCanCheck, Boolean.TRUE);
        } else {
            params.put(QUERY_DisplayCanCheck, Boolean.FALSE);
        }
        params.put(PARAM_CURRENT_COMPANY, this.company);
        params.put(PARAM_CURRENT_COMPANY_ID, this.company.getId().toString());
        return params;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        Map params = (Map)param;
        this.prmptOppCompany.setValue(params.get(PARAM_OPP_COMPANY));
        this.prmptMainItem.setValue(params.get(PARAM_PRIMARY_ITEM));
        this.cmbCurrecny.setSelectedItem(params.get(PARAM_CURRENCY));
        if (params.containsKey(QUERY_FASHION)) {
            String queryFashion = (String)params.get(QUERY_FASHION);
            if (QUERY_BY_DETAIL.equals(queryFashion)) {
                this.chkCollect.setSelected(false);
                try {
                    this.showQueryItems(true);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            } else {
                this.chkCollect.setSelected(true);
                try {
                    this.showQueryItems(false);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            }
        } else {
            this.chkCollect.setSelected(true);
            try {
                this.showQueryItems(false);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
        if (params.containsKey(QUERY_DisplayCanCheck)) {
            Boolean isDisplayCanCheck = (Boolean)params.get(QUERY_DisplayCanCheck);
            if (isDisplayCanCheck.booleanValue()) {
                this.chkDisplayCanCheck.setSelected(true);
            } else {
                this.chkDisplayCanCheck.setSelected(false);
            }
        } else {
            this.chkDisplayCanCheck.setSelected(false);
        }
        if (params.containsKey(PARAM_STATUS)) {
            this.cmbStatus.setSelectedItem(params.get(PARAM_STATUS));
            if (this.cmbStatus.getSelectedItem() == null || this.cmbStatus.getSelectedItem().equals((Object)RequisitionStatusEnum.CHECKED)) {
                this.chkDisplayCanCheck.setSelected(false);
                this.chkDisplayCanCheck.setEnabled(false);
            } else {
                this.chkDisplayCanCheck.setEnabled(true);
            }
        }
        if (params.containsKey(DATE_FASHION)) {
            String dateFashion = (String)params.get(DATE_FASHION);
            if (QUERY_BY_DATE.equals(dateFashion)) {
                this.radByDate.setSelected(true);
                this.radByPeriod.setSelected(false);
                this.pnlByPeriod.setVisible(false);
                this.pnlByDate.setVisible(true);
                if (params.containsKey(PARAM_START_DATE)) {
                    this.startDate.setValue(params.get(PARAM_START_DATE));
                }
                if (params.containsKey(PARAM_END_DATE)) {
                    this.endDate.setValue(params.get(PARAM_END_DATE));
                }
                try {
                    this.refreshPeriod();
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            } else {
                this.radByDate.setSelected(false);
                this.radByPeriod.setSelected(true);
                this.pnlByPeriod.setVisible(true);
                this.pnlByDate.setVisible(false);
                if (params.containsKey(PARAM_PERIODYEAR_FROM)) {
                    this.spnYearFrom.setValue(params.get(PARAM_PERIODYEAR_FROM));
                }
                if (params.containsKey(PARAM_PERIODYEAR_TO)) {
                    this.spnYearTo.setValue(params.get(PARAM_PERIODYEAR_TO));
                }
                if (params.containsKey(PARAM_PERIODNUMBER_FROM)) {
                    this.spnPeriodFrom.setValue(params.get(PARAM_PERIODNUMBER_FROM));
                }
                if (params.containsKey(PARAM_PERIODNUMBER_TO)) {
                    this.spnPeriodTo.setValue(params.get(PARAM_PERIODNUMBER_TO));
                }
                try {
                    this.refreshDate();
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public static Timestamp getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equalsIgnoreCase(PARAM_START_DATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase(PARAM_END_DATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void chkCollect_stateChanged(ChangeEvent e) throws Exception {
        super.chkCollect_stateChanged(e);
    }

    @Override
    protected void radByPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.radByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
            this.pnlByDate.setVisible(false);
        }
    }

    @Override
    protected void cmbStatus_actionPerformed(ActionEvent e) throws Exception {
        if (this.cmbStatus.getSelectedItem() == null || this.cmbStatus.getSelectedItem().equals((Object)RequisitionStatusEnum.CHECKED)) {
            this.chkDisplayCanCheck.setSelected(false);
            this.chkDisplayCanCheck.setEnabled(false);
        } else {
            this.chkDisplayCanCheck.setEnabled(true);
        }
    }

    @Override
    protected void radByDate_stateChanged(ChangeEvent e) throws Exception {
        if (this.radByDate.isSelected()) {
            this.pnlByPeriod.setVisible(false);
            this.pnlByDate.setVisible(true);
        }
    }

    public static void refreshList(KDComboBox list, IObjectCollection datas) {
        list.removeAllItems();
        list.addItem((Object)Constant.SELECTALLITEM);
        if (datas != null) {
            Iterator itor = datas.iterator();
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public CurrencyCollection getDefaultCurrencys() throws EASBizException, BOSException {
        if (this.currencys == null) {
            ICurrency ie = null;
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("precision"));
            ie = CurrencyFactory.getRemoteInstance();
            this.currencys = ie.getCurrencyCollection(view, true);
        }
        return this.currencys;
    }

    public static void refreshEnumList(KDComboBox list, Iterator itor) {
        list.removeAllItems();
        if (itor != null) {
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)this.getParams());
        return cp;
    }

    private String getResource(String key, Object[] params) {
        String message = ResourceBase.getString((String)CFREQ_RES, (String)key, (Locale)SysContext.getSysContext().getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }

    private void showQueryItems(boolean isShowItem) throws BOSException {
        String[] QueryItemsForRemove = new String[]{"fvouchertype", "fvouchernumber", "fvoucherCreator"};
        RptClientUtil.showCommonQueryItems(this.getCommonQueryPanel(), QueryItemsForRemove, isShowItem);
    }
}

