/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.client.AbstractCFRequisitionLinkQueryUI;
import com.kingdee.eas.fi.gl.client.CFRequisitionCorrelationUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CFRequisitionLinkQueryUI
extends AbstractCFRequisitionLinkQueryUI {
    private static final String DATA_NOT_AVAILABLE = "DataNotAvailable";
    private static final Logger logger = CoreUIObject.getLogger(CFRequisitionLinkQueryUI.class);
    public static final String CFREQ_RES = "com.kingdee.eas.fi.gl.CFRequisitionResource";
    private Map params = new HashMap();
    private boolean isCollect = false;

    public CFRequisitionLinkQueryUI() throws Exception {
        this.tblRequisition.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    ICFRequisition cfReq = CFRequisitionLinkQueryUI.this.getBizInterface();
                    IRowSet rs = cfReq.queryCFRequisition(CFRequisitionLinkQueryUI.this.params, CFRequisitionLinkQueryUI.this.isCollect);
                    e.setRowSet(rs);
                }
                catch (BOSException e1) {
                    CFRequisitionLinkQueryUI.this.handUIExceptionAndAbort((Exception)((Object)e1));
                }
                catch (EASBizException e2) {
                    CFRequisitionLinkQueryUI.this.handUIExceptionAndAbort((Exception)((Object)e2));
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map ctx = this.getUIContext();
        Object initData = ctx.get("InitDataObject");
        if (initData != null && initData instanceof Map) {
            this.params.clear();
            this.params.putAll((Map)initData);
            String queryFashion = (String)this.params.get("query_fashion");
            this.isCollect = "detail".equals(queryFashion);
        } else {
            MsgBox.showError((String)this.getResource(DATA_NOT_AVAILABLE, null));
            SysUtil.abort();
        }
        this.tblRequisition.getDataRequestManager().setDataRequestMode(0);
        this.initListener();
        this.btnCancel.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.uiWindow.close();
    }

    public ICFRequisition getBizInterface() throws BOSException {
        return CFRequisitionFactory.getRemoteInstance();
    }

    public void initListener() {
        this.tblRequisition.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (CFRequisitionLinkQueryUI.this.isCollect) {
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fdescription").getStyleAttributes().setHided(true);
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fvouchernumber").getStyleAttributes().setHided(true);
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fcorrelationNum").getStyleAttributes().setHided(true);
                } else {
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fdescription").getStyleAttributes().setHided(false);
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fvouchernumber").getStyleAttributes().setHided(false);
                    String status = String.valueOf(CFRequisitionLinkQueryUI.this.params.get("status"));
                    if ("2".equals(status)) {
                        CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fcorrelationNum").getStyleAttributes().setHided(false);
                    } else {
                        CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fcorrelationNum").getStyleAttributes().setHided(true);
                    }
                }
                String receive = (String)CFRequisitionLinkQueryUI.this.params.get("isReceive");
                if ("true".equals(receive)) {
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("freceivername").getStyleAttributes().setHided(true);
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fsendername").getStyleAttributes().setHided(false);
                } else {
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("freceivername").getStyleAttributes().setHided(false);
                    CFRequisitionLinkQueryUI.this.tblRequisition.getColumn("fsendername").getStyleAttributes().setHided(true);
                }
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                for (int i = firstRow; i <= lastRow; ++i) {
                    IRow row = CFRequisitionLinkQueryUI.this.tblRequisition.getRow(i);
                    Object value = row.getCell("fprimaryItemDirection").getValue();
                    String transValue = CFRequisitionCorrelationUI.translateCashlowDirection(String.valueOf(value));
                    row.getCell("fprimaryItemDirectionName").setValue((Object)transValue);
                    Object curpreObj = row.getCell("fprecision").getValue();
                    int curPrecision = curpreObj == null ? 0 : Integer.parseInt(String.valueOf(curpreObj));
                    row.getCell("foriginalAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(curPrecision));
                }
            }
        });
    }

    private String getResource(String key, Object[] params) {
        String message = ResourceBase.getString((String)CFREQ_RES, (String)key, (Locale)SysContext.getSysContext().getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }
}

