/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowAdjustConditionUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CashFlowAdjustConditionUI
extends AbstractCashFlowAdjustConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(CashFlowAdjustConditionUI.class);
    CashflowQueryParam param;
    private CompanyOrgUnitInfo company = null;
    private PeriodInfo currentPeriod = null;

    public CashFlowAdjustConditionUI() throws Exception {
        this.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        this.onInit();
    }

    public void onInit() throws EASBizException, BOSException {
        this.kdpStartDate.setSupportedEmpty(false);
        this.kdpEndDate.setSupportedEmpty(false);
        String curComId = this.company.getId().toString();
        Object[] initData = VoucherFacadeFactory.getRemoteInstance().fetchInitFilterData(curComId);
        GlUtils.AccountPeriodInfo pi = (GlUtils.AccountPeriodInfo)initData[1];
        this.setCurrentPeriod(pi.curPeriod);
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.kspStartYear, (KDSpinner)this.kspStartPeriod, (KDSpinner)this.kspEndYear, (KDSpinner)this.kspEndPeriod, (boolean)false, (boolean)false);
        ICurrency curCtrl = CurrencyFactory.getRemoteInstance();
        CurrencyCollection cc = curCtrl.getCurrencyCollection(false);
        if (cc.size() == 0) {
            throw new GLException(GLException.NOCURRENCY);
        }
        for (int i = 0; i < cc.size(); ++i) {
            if (cc.get(i).isGeneralLocalCurrency() || cc.get(i).isGeneralReportCurrency()) continue;
            this.kcbCurrency.addItem((Object)cc.get(i));
        }
        EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.kcbCurrency, (ObjectBaseInfo)SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
    }

    @Override
    protected void krbDate_stateChanged(ChangeEvent e) throws Exception {
        if (this.krbDate.isSelected()) {
            this.kdpDate.setVisible(true);
            this.kdpPeriod.setVisible(false);
            this.kdpEndDate.setEnabled(true);
            this.kdpStartDate.setEnabled(true);
            this.kspEndPeriod.setEnabled(false);
            this.kspEndYear.setEnabled(false);
            this.kspStartPeriod.setEnabled(false);
            this.kspStartYear.setEnabled(false);
        }
    }

    @Override
    protected void krbPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.krbPeriod.isSelected()) {
            this.kdpDate.setVisible(false);
            this.kdpPeriod.setVisible(true);
            this.kdpEndDate.setEnabled(false);
            this.kdpStartDate.setEnabled(false);
            this.kspEndPeriod.setEnabled(true);
            this.kspEndYear.setEnabled(true);
            this.kspStartPeriod.setEnabled(true);
            this.kspStartYear.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kspEndYear_stateChanged(ChangeEvent e) throws Exception {
        super.kspEndYear_stateChanged(e);
    }

    @Override
    protected void kspStartPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.kspStartPeriod_stateChanged(e);
    }

    @Override
    protected void kspEndPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.kspEndPeriod_stateChanged(e);
    }

    @Override
    protected void kspStartYear_stateChanged(ChangeEvent e) throws Exception {
        super.kspStartYear_stateChanged(e);
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void syschronizeParam() {
        this.param = (CashflowQueryParam)this.getParam();
    }

    public void setParam(Object p) {
        this.param = (CashflowQueryParam)p;
        this.setUIElementValue();
    }

    public void loadData(EntityViewInfo view) {
        this.setUIElementValue();
    }

    private void setUIElementValue() {
        EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.kcbCurrency, (ObjectBaseInfo)this.param.getCurrency());
        this.kdpStartDate.setValue((Object)this.param.getStartDate());
        this.kdpEndDate.setValue((Object)this.param.getEndDate());
        this.kspEndPeriod.setValue((Object)new Integer(this.param.getEndPeriod()));
        this.kspStartYear.setValue((Object)new Integer(this.param.getStartYear()));
        this.kspStartPeriod.setValue((Object)new Integer(this.param.getStartPeriod()));
        this.kspEndYear.setValue((Object)new Integer(this.param.getEndYear()));
        if (this.param.isPeriod()) {
            this.krbPeriod.setSelected(true);
        } else {
            this.krbDate.setSelected(true);
        }
        this.kcbIncludeNoPosted.setSelected(this.param.isIndcludeNoPosted());
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public Object getParam() {
        if (this.param == null) {
            this.param = new CashflowQueryParam();
        }
        return this.getCondition();
    }

    public CashflowQueryParam getCondition() {
        if (this.param == null) {
            this.param = new CashflowQueryParam();
        }
        this.param.setCompanyId(this.getCompany().getId().toString());
        boolean includeNotPosting = this.kcbIncludeNoPosted.isSelected();
        this.param.setIndcludeNoPosted(includeNotPosting);
        boolean optionAmountZero = this.krbPeriod.isSelected();
        this.param.setPeriod(optionAmountZero);
        int yearBegin = (Integer)this.kspStartYear.getValue();
        this.param.setStartYear(yearBegin);
        int yearEnd = (Integer)this.kspEndYear.getValue();
        this.param.setEndYear(yearEnd);
        Integer periodBegin = (Integer)this.kspStartPeriod.getValue();
        this.param.setStartPeriod(periodBegin);
        Integer periodEND = (Integer)this.kspEndPeriod.getValue();
        this.param.setEndPeriod(periodEND);
        Date start = this.kdpStartDate.getSqlDate();
        Date end = this.kdpEndDate.getSqlDate();
        this.param.setStartDate(start);
        this.param.setEndDate(end);
        this.param.setCurrency((CurrencyInfo)this.kcbCurrency.getSelectedItem());
        return this.param;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public PeriodInfo getCurrentPeriod() {
        return this.currentPeriod;
    }

    public void setCurrentPeriod(PeriodInfo currentPeriod) {
        this.currentPeriod = currentPeriod;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    public boolean verify() {
        if (this.krbDate.isSelected()) {
            Date from = this.kdpStartDate.getSqlDate();
            Date to = this.kdpEndDate.getSqlDate();
            if (to.before(from)) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("InputDateStart"));
                this.kdpStartDate.requestFocus();
                return false;
            }
        }
        return true;
    }

    public String getResource(String resKey) {
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)resKey);
        return res;
    }

    public void clear() {
        this.krbPeriod.setSelected(true);
        this.kcbIncludeNoPosted.setSelected(false);
        this.kcbCurrency.removeAllItems();
        try {
            this.onInit();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }
}

