/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashflowAdjustFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowAdjustInfo;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowAdjustFacade;
import com.kingdee.eas.fi.gl.ReportConditionCashflowAdjust;
import com.kingdee.eas.fi.gl.ReportResultInfo;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowAdjustListUI;
import com.kingdee.eas.fi.gl.client.CashFlowAdjustConditionUI;
import com.kingdee.eas.fi.gl.client.CashflowAdjustEditUI;
import com.kingdee.eas.fi.gl.client.UserQueryFilter;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class CashFlowAdjustListUI
extends AbstractCashFlowAdjustListUI {
    private static final long serialVersionUID = 2677042670943916381L;
    private CashFlowAdjustConditionUI conditionPanel = null;
    private boolean isFirstDefaultQuery = true;
    private String tempTableName = null;
    protected CommonQueryDialog queryDlg = null;
    protected boolean useReportingCurrency = false;
    private boolean needCheckCashflow = true;
    private CompanyOrgUnitInfo curCompany = null;
    private PeriodInfo curPeriod = null;
    private boolean isModifyCashFlow = false;
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.CashflowEditResource";

    public void onLoad() throws Exception {
        RptClientUtil.checkFIUnit(false);
        this.initData();
        Icon imgTbtn = EASResource.getIcon((String)"imgTbtn_subjectsetting");
        this.btnAccountSet.setIcon(imgTbtn);
        imgTbtn = EASResource.getIcon((String)"imgTbtn_input");
        this.btnApply.setIcon(imgTbtn);
        this.initCommonQueryDialog();
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("bookedDate").setGroup(true);
        this.tblMain.getColumn("bookedDate").setMergeable(true);
        this.tblMain.getDataRequestManager().setPageRowCount(100);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        super.onLoad();
        this.menuItemAddNew.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemRemove.setEnabled(false);
        this.menuItemRemove.setVisible(false);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.initTable();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        this.queryDlg = new CommonQueryDialog();
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setWidth(350);
        this.queryDlg.setHeight(330);
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setShowFilter(true);
        this.queryDlg.setShowSorter(true);
        this.queryDlg.setShowToolbar(true);
        try {
            this.queryDlg.setTitle(this.getConditionPanel().getUITitle());
            this.queryDlg.addUserPanel((KDPanel)this.getConditionPanel());
            UserQueryFilter userFilter = new UserQueryFilter();
            userFilter.setOwner((IUIObject)this.getConditionPanel());
            this.queryDlg.setProcessor((IProcessor)userFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.queryDlg;
    }

    public CashFlowAdjustConditionUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CashFlowAdjustConditionUI();
        }
        Dimension dd = new Dimension(340, 280);
        this.conditionPanel.setSize(dd);
        return this.conditionPanel;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.showWin(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean isDataChanged = this.showWin(false);
        if (isDataChanged) {
            int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            this.refresh(e);
            this.tblMain.getSelectManager().select(activeRowIndex, 0);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.showQueryDlg(e)) {
            SysUtil.abort();
        }
    }

    public boolean showQueryDlg(ActionEvent evt) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = "";
        queryName = this.mainQueryPK == null ? "com.kingdee.eas.fi.gl.app.CashFlowAdjustQuery" : (CashFlowAdjustListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK) == null ? "com.kingdee.eas.fi.gl.app.CashFlowAdjustQuery" : CashFlowAdjustListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName());
        String curUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String curCompanyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID)) {
            this.isFirstDefaultQuery = false;
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID);
            if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)solution.getSolutionType())) {
                this.mainQuery = new EntityViewInfo();
                FilterInfo filter = this.getConditionPanel().getFilterInfo();
                this.mainQuery.setFilter(filter);
            } else {
                QueryPanelCollection panels = solution.getQueryPanelInfo();
                QueryPanelInfo panel = null;
                int size = panels.size();
                for (int i = 0; i < size; ++i) {
                    panel = panels.get(i);
                    if (panel == null || panel.getCustomerParams() == null || !panel.getPanelClassName().equals(this.getConditionPanel().getMetaDataPK().getFullName())) continue;
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)panel.getCustomerParams());
                    this.getConditionPanel().setCustomerParams(cp);
                }
                this.mainQuery = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            }
            this.doDefaultSolution(iQuery, queryName);
            this.applyPreference();
        } else {
            this.isFirstDefaultQuery = false;
            if (this.queryDlg.show()) {
                this.tHelper.setDialog(this.queryDlg);
                this.mainQuery = (EntityViewInfo)this.queryDlg.getEntityViewInfoResult().clone();
                this.doQuery(this.queryDlg);
            } else {
                this.tHelper.setDialog(this.queryDlg);
                return false;
            }
        }
        this.getConditionPanel().syschronizeParam();
        this.refresh(evt);
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return CashFlowAdjustListUI.class.getName();
    }

    @Override
    public void actionAccountSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionAccountSet_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.CashFlowDefAccountUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionApply_actionPerformed(ActionEvent e) throws Exception {
        int choise = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"CFA_APPLY"));
        if (choise != 0) {
            return;
        }
        CashflowQueryParam param = this.getConditionPanel().getCondition();
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("param", param);
        mapParam.put("ECP", this.mainQuery.get("ECP"));
        ICashflowAdjustFacade facade = CashflowAdjustFacadeFactory.getRemoteInstance();
        facade.adjustApply(mapParam);
        this.needCheckCashflow = false;
        try {
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            this.needCheckCashflow = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        this.setCursorOfWair();
        try {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            ReportConditionCashflowAdjust customCondition = new ReportConditionCashflowAdjust();
            customCondition.setNewQuery(start == 0);
            CashflowQueryParam param = this.getConditionPanel().getCondition();
            customCondition.setParam(param);
            this.mainQuery.put("GLFixCondition", (Object)customCondition);
            ICashflowAdjustFacade adjustFacade = CashflowAdjustFacadeFactory.getRemoteInstance();
            ReportResultInfo result = adjustFacade.findData(this.mainQuery, start, length, this.getTempTableName(), SysContext.getSysContext().getCurrentFIUnit(), false);
            this.setTempTableName(result.getTempTableName());
            if (start == 0) {
                this.tblMain.setRowCount(result.getRowCount());
            }
            this.showResult(result, this.tblMain, start);
        }
        catch (Exception err) {
            this.tblMain.setRowCount(0);
            this.handUIException(err);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    protected void refresh() {
    }

    protected void execQuery() {
        try {
            this.dropTempTable();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        if (this.needCheckCashflow) {
            Map result = null;
            boolean isException = false;
            try {
                ICashflowAdjustFacade adjustFacade = CashflowAdjustFacadeFactory.getRemoteInstance();
                CashflowQueryParam param = this.getConditionPanel().getCondition();
                HashMap<String, CashflowQueryParam> queryParam = new HashMap<String, CashflowQueryParam>();
                queryParam.put("Param", param);
                result = adjustFacade.judgePrimaryAndSupAssignComplete(queryParam);
            }
            catch (BOSException e) {
                isException = true;
                this.handleException((Exception)((Object)e));
            }
            catch (Exception e) {
                isException = true;
                this.handleException(e);
            }
            if (isException) {
                SysUtil.abort();
            }
            StringBuffer msg = new StringBuffer();
            if (result != null) {
                if (result.get("PI") != null && result.get("SI") != null) {
                    msg.append(EASResource.getString((String)RESOURCE_PATH, (String)"CFA_PS_NOT_COMPLETE"));
                } else if (result.get("PI") != null) {
                    msg.append(EASResource.getString((String)RESOURCE_PATH, (String)"CFA_P_NOT_COMPLETE"));
                } else if (result.get("SI") != null) {
                    msg.append(EASResource.getString((String)RESOURCE_PATH, (String)"CFA_S_NOT_COMPLETE"));
                }
            }
            this.mainQuery.put("ECP", (Object)"false");
            if (msg.length() > 0) {
                int choise = MsgBox.showConfirm2New((Component)((Object)this), (String)msg.toString());
                if (choise != 0) {
                    SysUtil.abort();
                }
                this.mainQuery.put("ECP", (Object)"true");
            }
        }
        this.tblMain.removeRows();
        try {
            CashflowQueryParam condition = this.getConditionPanel().getCondition();
            PeriodInfo sourceperiodInfo = new PeriodInfo();
            if (condition.isPeriod()) {
                sourceperiodInfo.setPeriodYear(condition.getStartYear());
                sourceperiodInfo.setPeriodNumber(condition.getStartPeriod());
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(condition.getStartDate());
                sourceperiodInfo.setPeriodYear(calendar.get(1));
                sourceperiodInfo.setPeriodNumber(calendar.get(2) + 1);
            }
            if (this.isModifyCashFlow) {
                if (!PeriodUtils.PeriodCompare((PeriodInfo)sourceperiodInfo, (PeriodInfo)this.curPeriod)) {
                    this.setCtrlEnabled(false);
                } else {
                    this.setCtrlEnabled(true);
                }
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setCtrlEnabled(boolean flag) {
        this.menuItemEdit.setEnabled(flag);
        this.actionEdit.setEnabled(flag);
        this.btnEdit.setEnabled(flag);
        this.actionEdit.setEnabled(flag);
        this.btnApply.setEnabled(flag);
        this.actionApply.setEnabled(flag);
    }

    public String getTempTableName() {
        return this.tempTableName;
    }

    public void setTempTableName(String tempTableName) {
        this.tempTableName = tempTableName;
    }

    protected void dropTempTable() throws BOSException, EASBizException {
        if (this.getTempTableName() != null) {
            ICashflowAdjustFacade adjustFacade = CashflowAdjustFacadeFactory.getRemoteInstance();
            adjustFacade.releaseTempTable(this.getTempTableName());
        }
    }

    protected void disposeUIWindow() {
        try {
            this.dropTempTable();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        super.disposeUIWindow();
    }

    protected void showResult(ReportResultInfo result, KDTable tableForShowResult, int startRow) {
        if (result == null || tableForShowResult == null) {
            return;
        }
        tableForShowResult.setRefresh(false);
        this.showData(result.getData(), tableForShowResult, startRow);
        tableForShowResult.setRefresh(true);
        tableForShowResult.reLayoutAndPaint();
    }

    protected void showData(Collection data, KDTable tableForShowData, int startRow) {
        if (data == null || tableForShowData == null) {
            return;
        }
        int index = startRow;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            IRow row = tableForShowData.addRow(index++);
            Object[] lineObjects = (Object[])iterator.next();
            if (lineObjects == null) continue;
            CashflowAdjustInfo info = (CashflowAdjustInfo)lineObjects[0];
            row.getCell("id").setValue((Object)info.getVchID());
            row.getCell("bookedDate").setValue((Object)info.getVchBookedDate());
            row.getCell("number").setValue((Object)(info.getVchTypeName() + info.getVchNumber()));
            row.getCell("account.number").setValue((Object)info.getAcctNumber());
            row.getCell("account.name").setValue((Object)info.getAcctLongName());
            row.getCell("entries.entryDC").setValue((Object)info.getVeDC());
            int precisionL = this.curCompany.getBaseCurrency().getPrecision();
            row.getCell("entries.amount").setValue((Object)GlUtils.formatNumber(info.getVeOrignalAmount(), info.getCurrencyPrecision()));
            row.getCell("entries.localAmount").setValue((Object)GlUtils.formatNumber(info.getVeLocalAmount(), precisionL));
            row.getCell("cashflowEntry.originalAmount").setValue((Object)GlUtils.formatNumber(info.getCfOrignalAmount(), info.getCurrencyPrecision()));
            row.getCell("cashflowEntry.localAmount").setValue((Object)GlUtils.formatNumber(info.getCfLocalAmount(), precisionL));
            if (this.useReportingCurrency) {
                int precisionR = this.curCompany.getReportCurrency().getPrecision();
                row.getCell("entries.reportAmount").setValue((Object)GlUtils.formatNumber(info.getVeReportingAmount(), precisionR));
                row.getCell("cashflowEntry.reportingAmount").setValue((Object)GlUtils.formatNumber(info.getCfReportingAmount(), precisionR));
            }
            row.getCell("supplementaryItem.number").setValue((Object)info.getSupItemNumber());
            row.getCell("supplementaryItem.name").setValue((Object)info.getSupItemName());
            row.getCell("creator").setValue((Object)info.getVchCreatorName());
            row.setUserObject((Object)info);
        }
    }

    private boolean showWin(boolean isView) {
        String selectKeyValue = this.getSelectedKeyValue();
        if (selectKeyValue != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"VOUCHER", (Object)selectKeyValue);
            uiContext.put((Object)"ISVIEW", (Object)isView);
            uiContext.put((Object)"USERREPORT", (Object)this.useReportingCurrency);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CashflowAdjustEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
                uiWindow.show();
                CashflowAdjustEditUI ui = (CashflowAdjustEditUI)uiWindow.getUIObject();
                return ui.isOK;
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        return false;
    }

    private void initData() throws BOSException, EASBizException {
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("G001");
        keys.add("GL_014_1");
        Map map = GlUtils.getParamsByKeys(null, companyID, keys);
        this.useReportingCurrency = Boolean.valueOf(String.valueOf(map.get("G001")));
        this.curCompany = GlUtils.getCompanyById(null, companyID);
        this.curPeriod = GlUtils.getCurrentPeriod(null, companyID);
        this.isModifyCashFlow = Boolean.valueOf(String.valueOf(map.get("GL_014_1")));
    }

    private void initTable() {
        if (!this.useReportingCurrency) {
            this.tblMain.getColumn("entries.reportAmount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("cashflowEntry.reportingAmount").getStyleAttributes().setHided(true);
        }
    }

    protected boolean isOrderPre() {
        return false;
    }
}

