/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemViewFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowAttachedListFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowAttachedListInfo;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashFlowAttachedListFacade;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowAttachedListUI;
import com.kingdee.eas.fi.gl.client.CashFlowIndirectConditionUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CashFlowAttachedListUI
extends AbstractCashFlowAttachedListUI {
    private static final long serialVersionUID = -2460651824451985199L;
    private static final Logger logger = CoreUIObject.getLogger(CashFlowAttachedListUI.class);
    private static final String ACCOUNT_NAME = "accountName";
    private static final String ACCOUNT_AMOUNT = "accountAmount";
    private CashflowQueryParam condition = null;
    private CashFlowIndirectConditionUI conditionPanel = null;
    private JMenuItem expandAccountItem = new JMenuItem();
    private JMenuItem expandOppAccountItem = new JMenuItem();
    private JMenuItem expandCFItemItem = new JMenuItem();
    private JMenuItem showVoucherItem = new JMenuItem();
    private JMenuItem selectCFItem = new JMenuItem();
    private JMenuItem cancelCFItem = new JMenuItem();
    private JMenuItem closeExpandItem = new JMenuItem();
    private PeriodInfo curPeriod = null;
    private boolean isModifyCashFlow = false;

    public CashFlowAttachedListUI() throws Exception {
        RptClientUtil.checkFIUnit(false);
        this.jbInit();
        Object object = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_014_1");
        this.isModifyCashFlow = Boolean.valueOf(object.toString());
        this.curPeriod = GlUtils.getCurrentPeriod(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
    }

    private void jbInit() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = this.getConditionPanel();
        }
        this.setUITitle(this.getResource("CashFlowIndirectUIName"));
        this.kdbTitle.setText(this.getResource("CashFlowIndirectUIName"));
        this.ktbCashflow.checkParsed();
        this.ktbCashflow.setEditable(false);
        this.ktbCashflow.getSelectManager().setSelectMode(2);
        this.setCanCopyPaste(false);
        this.addMyMenu();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemQuery.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.initMyListener();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAppDefCashItem.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemAppDefCashItem.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
    }

    protected void initMyListener() {
        this.ktbCashflow.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                CashFlowAttachedListUI.this.setPopMenuStatus();
            }
        });
    }

    private void setPopMenuStatus() {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowAttachedListInfo info = this.getSelectedCFAttListInfo(rowIndex);
        if (info == null) {
            return;
        }
        this.actionExpandOppAccount.setEnabled(info.getOppAccount() == null);
        this.actionExpandCFItem.setEnabled(info.getCfItem() == null);
        AccountViewInfo account = null;
        account = info.isLastExtendOppAccount() ? info.getOppAccount() : info.getAccount();
        this.actionExpandAccount.setEnabled(account == null || !account.isIsLeaf());
    }

    protected RptParams getParamsForInit() {
        RptParams pp = new RptParams();
        pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return pp;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new CashFlowIndirectConditionUI();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return CashFlowAttachedListFacadeFactory.getRemoteInstance();
    }

    protected ICashFlowAttachedListFacade getBizInterface() throws BOSException {
        return CashFlowAttachedListFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.ktbCashflow;
    }

    protected void query() {
        this.initQueryParam();
        this.initTiTle();
        List data = null;
        try {
            this.initTable();
            ICashFlowAttachedListFacade iIndirect = this.getBizInterface();
            iIndirect.splitPLVoucher(this.condition);
            data = iIndirect.queryCashflowAttachedList(this.condition, null, 0);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        this.fillTableData(-1, null, data);
        PeriodInfo sourceperiodInfo = new PeriodInfo();
        sourceperiodInfo.setPeriodYear(this.condition.getStartYear());
        sourceperiodInfo.setPeriodNumber(this.condition.getStartPeriod());
        if (this.isModifyCashFlow) {
            if (!PeriodUtils.PeriodCompare((PeriodInfo)sourceperiodInfo, (PeriodInfo)this.curPeriod)) {
                this.setCtrlEnabled(false);
            } else {
                this.setCtrlEnabled(true);
            }
        }
        this.setTableConfig();
    }

    protected void setTableConfig() {
        this.tHelper.setCanMoveColumn(true);
    }

    private void setCtrlEnabled(boolean flag) {
        this.menuItemAppDefCashItem.setEnabled(flag);
        this.actionAppDefCashItem.setEnabled(flag);
        this.btnAppDefCashItem.setEnabled(flag);
        this.actionAppDefCashItem.setEnabled(flag);
        this.selectCFItem.setEnabled(flag);
        this.actionSelectCFItem.setEnabled(flag);
        this.cancelCFItem.setEnabled(flag);
        this.actionCancelCFItem.setEnabled(flag);
    }

    private void initTable() throws EASBizException, BOSException {
        this.ktbCashflow.removeRows();
        int pre = 2;
        if (this.condition.getCurrency() != null) {
            CurrencyInfo cy = this.condition.getCurrency();
            if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cy.getId().toString())) {
                BOSUuid currencyID = SysContext.getSysContext().getCurrentFIUnit().getReportCurrency().getId();
                pre = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID)).getPrecision();
            } else if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cy.getId().toString())) {
                BOSUuid currencyID = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId();
                pre = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID)).getPrecision();
            } else {
                pre = cy.getPrecision();
            }
        }
        this.ktbCashflow.getColumn(ACCOUNT_AMOUNT).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(pre));
        this.ktbCashflow.getColumn(ACCOUNT_AMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.ktbCashflow.getTreeColumn().setOrientation(0);
        this.ktbCashflow.getTreeColumn().setLevelWidth(13);
        this.ktbCashflow.getTreeColumn().setDepth(0);
    }

    private void fillTableData(int rowIndex, CashflowAttachedListInfo parent, List data) {
        if (data == null) {
            return;
        }
        this.setTableDepth(parent);
        int currRowIndex = rowIndex;
        Iterator it = data.iterator();
        while (it.hasNext()) {
            ++currRowIndex;
            CashflowAttachedListInfo info = (CashflowAttachedListInfo)it.next();
            if (parent != null) {
                info.setLevel(parent.getLevel() + 1);
            }
            IRow row = this.ktbCashflow.addRow(currRowIndex);
            row.setTreeLevel(info.getLevel());
            row.getCell(ACCOUNT_NAME).setValue((Object)info);
            row.getCell(ACCOUNT_AMOUNT).setValue((Object)info.getAmount());
        }
    }

    private void setTableDepth(CashflowAttachedListInfo parent) {
        int depth = 0;
        if (parent != null) {
            depth = parent.getLevel() + 1;
        }
        this.ktbCashflow.getTreeColumn().setDepth(depth);
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    public CashFlowIndirectConditionUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CashFlowIndirectConditionUI();
        }
        this.conditionPanel.setSize(new Dimension(340, 280));
        return this.conditionPanel;
    }

    private void addMyMenu() throws Exception {
        this.enableExportExcel(this.ktbCashflow);
        KDPopupMenu kdmenu = new KDPopupMenu();
        this.bindMenuItemAction();
        kdmenu.add(this.expandAccountItem);
        kdmenu.add(this.expandOppAccountItem);
        kdmenu.add(this.expandCFItemItem);
        kdmenu.add(this.showVoucherItem);
        kdmenu.add(this.selectCFItem);
        kdmenu.add(this.cancelCFItem);
        kdmenu.add(this.closeExpandItem);
        kdmenu.add((Component)new KDSeparator());
        KDPopupMenu menu = this.getMenuManager(this.ktbCashflow).getMenu();
        int count = menu.getComponentCount();
        for (int i = 0; i < count; ++i) {
            kdmenu.add(menu.getComponent(0));
        }
        this.getMenuManager(this.ktbCashflow).setMenu(kdmenu);
    }

    private void bindMenuItemAction() {
        this.expandAccountItem.setAction((Action)((Object)this.actionExpandAccount));
        this.expandOppAccountItem.setAction((Action)((Object)this.actionExpandOppAccount));
        this.expandCFItemItem.setAction((Action)((Object)this.actionExpandCFItem));
        this.showVoucherItem.setAction((Action)((Object)this.actionShowVoucher));
        this.selectCFItem.setAction((Action)((Object)this.actionSelectCFItem));
        this.cancelCFItem.setAction((Action)((Object)this.actionCancelCFItem));
        this.closeExpandItem.setAction((Action)((Object)this.actionCloseExpand));
    }

    private void initTiTle() {
        if (this.condition.isPeriod()) {
            this.kdTxtPeriod.setText(InitClientHelp.getPeriodTitle(this.condition.getStartYear(), this.condition.getStartPeriod(), this.condition.getEndYear(), this.condition.getEndPeriod()));
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"period"));
        } else {
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"date"));
            this.kdTxtPeriod.setText(InitClientHelp.getDateTitle(this.condition.getStartDate(), this.condition.getEndDate()));
        }
        this.kdTxtCurrency.setText(this.condition.getCurrency().getName());
    }

    public String getResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI", (String)resKey);
    }

    protected Map preparePrintVariantMap() {
        Map map = super.preparePrintVariantMap();
        map.put("Currency", this.kdTxtCurrency.getText());
        map.put("Period", this.kdLabelPeriod.getBoundLabelText() + ":" + this.kdTxtPeriod.getText());
        return map;
    }

    private void showVoucher() throws EASBizException, BOSException {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        CashflowAttachedListInfo listInfo = this.getSelectedCFAttListInfo(rowIndex);
        List voucherIdList = this.getBizInterface().getVoucherIdList(this.condition, listInfo);
        if (voucherIdList == null || voucherIdList.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NoVoucher"));
            SysUtil.abort();
        } else {
            uiContext.put((Object)"IDList", (Object)voucherIdList);
            uiContext.put((Object)"change", (Object)voucherIdList.toString());
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherListUI", (Map)uiContext);
            window.show();
        }
    }

    private void selectCashflowItem() throws EASBizException, BOSException {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("CashFlowItemSelect")) != 0) {
            return;
        }
        F7CashFlowItemMainUI ui = this.showCashflowItemSelectUI();
        CashFlowItemInfo cfItem = (CashFlowItemInfo)ui.getData();
        if (ui.isCanceled() || cfItem == null) {
            return;
        }
        CashflowAttachedListInfo info = this.getSelectedCFAttListInfo(rowIndex);
        this.getBizInterface().applyCashflowItem(this.condition, info, cfItem);
        this.refreshCashflow(info, rowIndex);
        this.setStatusBarMessageText(this.getResource("CashflowSaveSuccess"));
    }

    private void expand(int rowIndex, int type) throws EASBizException, BOSException {
        CashflowAttachedListInfo parent = this.getSelectedCFAttListInfo(rowIndex);
        if (parent == null) {
            return;
        }
        parent.setExtended(true);
        List infoList = this.getBizInterface().queryCashflowAttachedList(this.condition, parent, type);
        this.fillTableData(rowIndex, parent, infoList);
    }

    private void backItem(int rowIndex) {
        CashflowAttachedListInfo parent = this.getSelectedCFAttListInfo(rowIndex);
        if (parent == null || !parent.isExtended()) {
            return;
        }
        parent.setExtended(false);
        CashflowAttachedListInfo info = this.getSelectedCFAttListInfo(++rowIndex);
        while (info != null && info.getLevel() > parent.getLevel()) {
            this.ktbCashflow.removeRow(rowIndex);
            info = this.getSelectedCFAttListInfo(rowIndex);
            if (info != null) continue;
            break;
        }
    }

    private int getParentRowIndex(int rowIndex) {
        CashflowAttachedListInfo info = this.getSelectedCFAttListInfo(rowIndex);
        if (info == null) {
            return -1;
        }
        for (int i = rowIndex - 1; i >= 0; --i) {
            CashflowAttachedListInfo parent = this.getSelectedCFAttListInfo(i);
            if (parent == null || parent.getLevel() >= info.getLevel()) continue;
            return i;
        }
        return -1;
    }

    private F7CashFlowItemMainUI showCashflowItemSelectUI() {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        FilterInfo filter = this.getAttCashFlowItemFilter();
        uiContext.put((Object)"Filter", (Object)filter);
        FilterInfo filter4Tree = new FilterInfo();
        FilterItemCollection fic4tree = filter4Tree.getFilterItems();
        fic4tree.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        if (filter != null) {
            try {
                filter4Tree.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        uiContext.put((Object)"filter4Tree", (Object)filter4Tree);
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI", (Map)uiContext);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        F7CashFlowItemMainUI ui = (F7CashFlowItemMainUI)uiWindow.getUIObject();
        ui.loadFields();
        uiWindow.show();
        return ui;
    }

    private void cancelCashflowItem() throws EASBizException, BOSException {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("CashFlowItemRemove")) != 0) {
            return;
        }
        CashflowAttachedListInfo info = this.getSelectedCFAttListInfo(rowIndex);
        this.getBizInterface().removeCashflowItem(this.condition, info);
        this.refreshCashflow(info, rowIndex);
        this.setStatusBarMessageText(this.getResource("CashflowRemoveSuccess"));
    }

    private void refreshCashflow(CashflowAttachedListInfo info, int rowIndex) throws EASBizException, BOSException {
        int expandRowIndex = rowIndex;
        if (info.getType() == 3) {
            expandRowIndex = this.getParentRowIndex(rowIndex);
        }
        this.backItem(expandRowIndex);
        this.expand(expandRowIndex, 3);
    }

    private CashflowAttachedListInfo getSelectedCFAttListInfo(int rowIndex) {
        ICell cell = this.ktbCashflow.getCell(rowIndex, ACCOUNT_NAME);
        if (cell == null) {
            return null;
        }
        return (CashflowAttachedListInfo)cell.getValue();
    }

    private void setStatusBarMessageText(String msg) {
        this.setMessageText(msg);
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    @Override
    public void actionAppDefCashItem_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appDefCashItem"));
        if (result == 2) {
            return;
        }
        boolean isCover = false;
        if (result == 0) {
            isCover = true;
        }
        this.getBizInterface().applyDefaultCashflowItem(this.condition, isCover);
        this.actionRefresh_actionPerformed(null);
        this.setStatusBarMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appAddCashSuccess"));
    }

    private FilterInfo getAttCashFlowItemFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isProfit", (Object)new Integer(1), CompareType.NOTEQUALS));
        FilterInfo viewFilter = null;
        String ctrlUnitId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        try {
            viewFilter = CashFlowItemViewFactory.getRemoteInstance().getCashFlowItemViewFilter(ctrlUnitId);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (viewFilter != null) {
            try {
                filter.mergeFilter(viewFilter, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    private void initQueryParam() {
        this.condition = (CashflowQueryParam)this.params.getObject("CashflowQueryParam");
    }

    @Override
    public void actionExpandAccount_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
        this.expand(rowIndex, 1);
    }

    @Override
    public void actionExpandOppAccount_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
        this.expand(rowIndex, 2);
    }

    @Override
    public void actionExpandCFItem_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
        this.expand(rowIndex, 3);
    }

    @Override
    public void actionShowVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.showVoucher();
    }

    @Override
    public void actionSelectCFItem_actionPerformed(ActionEvent e) throws Exception {
        this.selectCashflowItem();
    }

    @Override
    public void actionCancelCFItem_actionPerformed(ActionEvent e) throws Exception {
        this.cancelCashflowItem();
    }

    @Override
    public void actionCloseExpand_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
    }
}

