/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowDirectConditionUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;

public class CashFlowDirectConditionUI
extends AbstractCashFlowDirectConditionUI {
    private static final long serialVersionUID = 4013639557412739058L;
    private PeriodInfo currentPeriod = null;
    private CompanyOrgUnitInfo company = null;
    private CashflowQueryParam customCondition;
    private GlUtils.AccountPeriodInfo pi;
    private boolean isUseReportCurrency = false;
    private boolean isUnitForeignCurrency = false;

    public CashFlowDirectConditionUI() throws Exception {
        this.jbInit();
        this.initTiTle();
        this.setSize(350, 295);
    }

    @Override
    protected void kspEndYear_stateChanged(ChangeEvent e) {
        if (this.krbOneCash.isSelected()) {
            int yearEnd = (Integer)this.kspEndYear.getValue();
            int numberEnd = (Integer)this.kspEndPeriod.getValue();
            RptClientUtil.periodChanged((IUIObject)this, this.company, yearEnd, numberEnd, this.kbpAccount, this.kbpAccount);
        }
    }

    private void jbInit() throws Exception {
        this.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        if (this.company.getAccountTable() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.company.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("category", (Object)2, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.company);
        HashSet<Integer> budgets = new HashSet<Integer>();
        budgets.add(12);
        budgets.add(13);
        budgets.add(14);
        FilterInfo treeNodefilter = new FilterInfo();
        treeNodefilter.getFilterItems().add(new FilterItemInfo("property", budgets, CompareType.NOTINCLUDE));
        apb.setTreeNodefilter(treeNodefilter);
        this.kbpAccount.setEditable(true);
        this.kbpAccount.setEditFormat("$number$");
        this.kbpAccount.setCommitFormat("$number$");
        this.kbpAccount.setDisplayFormat("$number$ - $name$");
        this.kbpAccount.setCommitParser((IParser)new AccountViewParser(this.kbpAccount));
        this.kbpAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.kbpAccount.setSelector((KDPromptSelector)apb);
        EntityViewInfo myevi = new EntityViewInfo();
        myevi.setFilter(filter);
        this.kbpAccount.setEntityViewInfo(myevi);
        this.kbpAccount.setEnabled(false);
        this.kdpStartDate.setSupportedEmpty(false);
        this.kdpEndDate.setSupportedEmpty(false);
    }

    private void initTiTle() throws Exception {
        this.setUITitle(this.getResource("CashFlowTAccountUI") + this.getResource("CashType"));
    }

    public void onInit(RptParams initParams) throws Exception {
        int i;
        String curComId = this.company.getId().toString();
        Object[] initData = VoucherFacadeFactory.getRemoteInstance().fetchInitFilterData(curComId);
        this.pi = (GlUtils.AccountPeriodInfo)initData[1];
        this.setCurrentPeriod(this.pi.curPeriod);
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.kspStartYear, (KDSpinner)this.kspStartPeriod, (KDSpinner)this.kspEndYear, (KDSpinner)this.kspEndPeriod, (boolean)false, (boolean)false);
        this.loadSystemParams();
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("getAllCurrency");
        for (i = 0; i < cc.size(); ++i) {
            if (cc.get(i).isGeneralLocalCurrency() || cc.get(i).isGeneralReportCurrency()) continue;
            this.kcbCurrency.addItem((Object)cc.get(i));
        }
        if (!this.isUnitForeignCurrency) {
            for (i = 0; i < cc.size(); ++i) {
                if (cc.get(i).isGeneralLocalCurrency()) {
                    this.kcbCurrency.addItem((Object)cc.get(i));
                    continue;
                }
                if (!cc.get(i).isGeneralReportCurrency() || !this.isUseReportCurrency) continue;
                this.kcbCurrency.addItem((Object)cc.get(i));
            }
        }
        this.kdpEndDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CashFlowDirectConditionUI.this.dateDateEnd_dataChanged(e);
                }
                catch (Exception exc) {
                    CashFlowDirectConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    private void loadSystemParams() throws EASBizException, BOSException, GLException {
        String[] paramList = new String[]{"GL_008", "G001"};
        GlParam glParam = GlParam.getGlParams(null, (String[])paramList, (String)this.company.getId().toString());
        this.isUnitForeignCurrency = glParam.getBoolean("GL_008");
        this.isUseReportCurrency = glParam.getBoolean("G001");
    }

    public CashflowQueryParam getCondition() {
        Object object;
        if (this.customCondition == null) {
            this.customCondition = new CashflowQueryParam();
        }
        this.customCondition.setCompanyId(this.getCompany().getId().toString());
        boolean includeNotPosting = this.kcbIncludeNoPosted.isSelected();
        this.customCondition.setIndcludeNoPosted(includeNotPosting);
        boolean optionAmountZero = this.krbPeriod.isSelected();
        this.customCondition.setPeriod(optionAmountZero);
        if (optionAmountZero) {
            int yearBegin = (Integer)this.kspStartYear.getValue();
            this.customCondition.setStartYear(yearBegin);
            int yearEnd = (Integer)this.kspEndYear.getValue();
            this.customCondition.setEndYear(yearEnd);
            Integer periodBegin = (Integer)this.kspStartPeriod.getValue();
            this.customCondition.setStartPeriod(periodBegin);
            Integer periodEND = (Integer)this.kspEndPeriod.getValue();
            this.customCondition.setEndPeriod(periodEND);
        } else {
            Date start = this.kdpStartDate.getSqlDate();
            Date end = this.kdpEndDate.getSqlDate();
            this.customCondition.setStartDate(start);
            this.customCondition.setEndDate(end);
        }
        boolean optionBalanceZero = this.krbAllCash.isSelected();
        this.customCondition.setCashFilt(optionBalanceZero);
        boolean optionNotUsed = this.krbCashTotal.isSelected();
        this.customCondition.setCashColl(optionNotUsed);
        if (!optionBalanceZero && (object = this.kbpAccount.getValue()) instanceof AccountViewInfo) {
            AccountViewInfo account = (AccountViewInfo)object;
            this.customCondition.setAccount(account);
        }
        this.customCondition.setCurrency((CurrencyInfo)this.kcbCurrency.getSelectedItem());
        return this.customCondition;
    }

    @Override
    protected void krbDate_itemStateChanged(ItemEvent e) throws Exception {
        this.kdpDate.setVisible(true);
        this.kdpPeriod.setVisible(false);
        this.kdpEndDate.setEnabled(true);
        this.kdpStartDate.setEnabled(true);
        this.kspEndPeriod.setEnabled(false);
        this.kspEndYear.setEnabled(false);
        this.kspStartPeriod.setEnabled(false);
        this.kspStartYear.setEnabled(false);
    }

    @Override
    protected void krbPeriod_itemStateChanged(ItemEvent e) throws Exception {
        this.kdpDate.setVisible(false);
        this.kdpPeriod.setVisible(true);
        this.kdpEndDate.setEnabled(false);
        this.kdpStartDate.setEnabled(false);
        this.kspEndPeriod.setEnabled(true);
        this.kspEndYear.setEnabled(true);
        this.kspStartPeriod.setEnabled(true);
        this.kspStartYear.setEnabled(true);
    }

    @Override
    protected void krbAllCash_actionPerformed(ActionEvent e) throws Exception {
        this.kbpAccount.setEditable(false);
        this.kbpAccount.setEnabled(false);
        this.kbpAccount.setValue(null);
    }

    @Override
    protected void krbOneCash_actionPerformed(ActionEvent e) throws Exception {
        this.kbpAccount.setEditable(true);
        this.kbpAccount.setEnabled(true);
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public PeriodInfo getCurrentPeriod() {
        return this.currentPeriod;
    }

    public void setCurrentPeriod(PeriodInfo currentPeriod) {
        this.currentPeriod = currentPeriod;
    }

    public String getResource(String resKey) {
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)resKey);
        return res;
    }

    public boolean verify() {
        Object object;
        boolean optionBalanceZero;
        if (this.krbDate.isSelected()) {
            Date from = this.kdpStartDate.getSqlDate();
            Date to = this.kdpEndDate.getSqlDate();
            if (to.before(from)) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("InputDateStart"));
                this.kdpStartDate.requestFocus();
                return false;
            }
        }
        if (!(optionBalanceZero = this.krbAllCash.isSelected()) && (object = this.kbpAccount.getValue()) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NotSelectAccount"));
            return false;
        }
        if (this.krbPeriod.isSelected()) {
            int numberBegin;
            int yearBegin;
            int yearEnd = (Integer)this.kspEndYear.getValue();
            if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.kspStartYear.getValue()).intValue(), numberBegin = ((Integer)this.kspStartPeriod.getValue()).intValue())) {
                return false;
            }
        } else {
            SimpleDateFormat format;
            Date start = this.kdpStartDate.getSqlDate();
            Date end = this.kdpEndDate.getSqlDate();
            PeriodInfo startPeriod = null;
            PeriodInfo endPeriod = null;
            try {
                startPeriod = PeriodUtils.getPeriodInfo((java.util.Date)start, (CompanyOrgUnitInfo)this.getCompany());
                endPeriod = PeriodUtils.getPeriodInfo((java.util.Date)end, (CompanyOrgUnitInfo)this.getCompany());
            }
            catch (EASBizException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            if (startPeriod == null) {
                format = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI"));
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(this.getResource("PeriodNotExist"), format.format(start)));
                return false;
            }
            if (endPeriod == null) {
                format = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI"));
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(this.getResource("PeriodNotExist"), format.format(end)));
                return false;
            }
            if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), endPeriod.getPeriodYear(), startPeriod.getPeriodYear(), startPeriod.getPeriodNumber())) {
                return false;
            }
            if (this.customCondition == null) {
                this.customCondition = new CashflowQueryParam();
            }
            this.customCondition.setStartYear(startPeriod.getPeriodYear());
            this.customCondition.setEndYear(endPeriod.getPeriodYear());
            this.customCondition.setStartPeriod(startPeriod.getPeriodNumber());
            this.customCondition.setEndPeriod(endPeriod.getPeriodNumber());
        }
        return true;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("CashflowQueryParam", (Object)this.getCondition());
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params);
        this.customCondition = (CashflowQueryParam)rcm.getProperty("CashflowQueryParam");
        rcm.restoreAllStatus((Container)((Object)this));
    }

    public void clear() {
        this.krbPeriod.setSelected(true);
        this.kspStartYear.setValue((Object)new Integer(this.currentPeriod.getPeriodYear()));
        this.kspStartPeriod.setValue((Object)new Integer(this.currentPeriod.getPeriodNumber()));
        this.kspEndYear.setValue((Object)new Integer(this.currentPeriod.getPeriodYear()));
        this.kspEndPeriod.setValue((Object)new Integer(this.currentPeriod.getPeriodNumber()));
        this.kcbIncludeNoPosted.setSelected(true);
        this.krbAllCash.setSelected(true);
        this.kbpAccount.setValue(null);
        this.kbpAccount.setEnabled(false);
        this.krbCashTotal.setSelected(true);
        CurrencyInfo curCurrency = this.company.getBaseCurrency();
        EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.kcbCurrency, (ObjectBaseInfo)curCurrency);
    }

    protected void dateDateEnd_dataChanged(DataChangeEvent e) throws Exception {
        Date dateBegin = this.kdpStartDate.getSqlDate();
        Date dateEnd = this.kdpEndDate.getSqlDate();
        if (dateEnd.before(dateBegin)) {
            this.kdpStartDate.setValue((Object)dateEnd);
        }
        if (!this.krbOneCash.isSelected()) {
            return;
        }
        if (e != null && e.getOldValue() instanceof java.util.Date && e.getNewValue() instanceof java.util.Date) {
            java.util.Date oldDate = (java.util.Date)e.getOldValue();
            java.util.Date newDate = (java.util.Date)e.getNewValue();
            if (oldDate.getYear() != newDate.getYear()) {
                try {
                    PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((java.util.Date)dateEnd, (CompanyOrgUnitInfo)this.getCompany());
                    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                    if (endPeriod == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(this.getResource("PeriodNotExist"), dateEnd));
                    } else {
                        RptClientUtil.periodChanged((IUIObject)this, company, endPeriod.getPeriodYear(), endPeriod.getPeriodNumber(), this.kbpAccount, this.kbpAccount);
                    }
                }
                catch (EASBizException e1) {
                    this.handUIException(e1);
                    SysUtil.abort();
                }
                catch (BOSException e2) {
                    this.handUIException(e2);
                    SysUtil.abort();
                }
            }
        }
    }
}

