/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.util.CashflowF7Util;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashFlowDirectUtil;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowDirectSelectUI;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CashFlowDirectSelectUI
extends AbstractCashFlowDirectSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(CashFlowDirectSelectUI.class);
    protected int returnValue = 1;
    protected CashflowRecordCollection cfCol;
    protected Map colRecord;
    protected Vector oppEntries;
    protected boolean foreignCurrencySU;
    protected boolean useReportingCurrency;
    protected CurrencyInfo localCurrency;
    protected CurrencyInfo reportingCurrency;
    private Integer precision = new Integer(2);
    protected boolean isSettleByLocal = true;
    protected VoucherInfo.ExchangeRateWithValue localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
    protected KDTDefaultCellEditor comboBoxEditor;
    protected KDTDefaultCellEditor numberEditor;
    protected HashMap hmDynamicColumnInfo = new HashMap();
    protected int curCfOppEntryIndex = -1;
    protected HashMap hmDynamicPromptBox = new HashMap();
    private static final String CF_OPP_ASSGRP = "o.assGrp";
    CfOppEntryEditAdapter cfOppEntryEditLs = new CfOppEntryEditAdapter();
    CfOppEntrySwitchListener cfOppEntrySwitchLs = new CfOppEntrySwitchListener();

    public CashFlowDirectSelectUI() throws Exception {
        this.btnRecalc.setText(null);
        this.btnRecalc.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnAddLine.setText(null);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        IRow erow = this.tblOppEntries.getRow(this.curCfOppEntryIndex);
        if (erow == null) {
            return;
        }
        CfOppVoucherEntryWrapper wrap = null;
        int size = this.oppEntries.size();
        for (int i = 0; i < size; ++i) {
            CfOppVoucherEntryWrapper wrap1 = (CfOppVoucherEntryWrapper)this.oppEntries.get(i);
            if (wrap1 == null || wrap1.getAsstRecord() != null) continue;
            wrap = wrap1;
            break;
        }
        if (wrap == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"168_CashFlowDirectSelectUI"));
            return;
        }
        IRow row = this.tblOppEntries.addRow();
        CashflowRecordInfo r = (CashflowRecordInfo)this.colRecord.get(wrap.getCashflowRecordid());
        CfOppEntryData oe = new CfOppEntryData(wrap.getEntry(), wrap.getOppEntry(), r.getPrimaryItem(), r.getPrimaryCoefficient(), r.getOppVoucherAssistRecord());
        this.loadCfOppEntry(oe, wrap, row);
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(this.tblOppEntries.getRowCount() - 1, -1);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        IRow erow = this.tblOppEntries.getRow(this.curCfOppEntryIndex);
        if (erow == null) {
            return;
        }
        CfOppVoucherEntryWrapper wrap = null;
        int size = this.oppEntries.size();
        for (int i = 0; i < size; ++i) {
            CfOppVoucherEntryWrapper wrap1 = (CfOppVoucherEntryWrapper)this.oppEntries.get(i);
            if (wrap1 == null || wrap1.getAsstRecord() != null) continue;
            wrap = wrap1;
            break;
        }
        if (wrap == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"168_CashFlowDirectSelectUI"));
            return;
        }
        IRow row = null;
        int top = this.curCfOppEntryIndex;
        row = top >= 0 ? this.tblOppEntries.addRow(top) : this.tblOppEntries.addRow();
        CashflowRecordInfo r = (CashflowRecordInfo)this.colRecord.get(wrap.getCashflowRecordid());
        CfOppEntryData oe = new CfOppEntryData(wrap.getEntry(), wrap.getOppEntry(), r.getPrimaryItem(), r.getPrimaryCoefficient(), r.getOppVoucherAssistRecord());
        this.loadCfOppEntry(oe, wrap, row);
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(this.tblOppEntries.getRowCount() - 1, -1);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int top = this.curCfOppEntryIndex;
        IRow curRow = this.tblOppEntries.getRow(top);
        if (curRow == null) {
            return;
        }
        CfOppEntryData oe = (CfOppEntryData)curRow.getUserObject();
        this.storeCfOppEntry(oe, curRow);
        this.tblOppEntries.removeRow(top);
        if (this.curCfOppEntryIndex >= 0) {
            this.curCfOppEntryIndex = -1;
        }
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        int rowCount = this.tblOppEntries.getRowCount();
        if (rowCount == 0) {
            sm.removeAll(false);
            this.actionAddLine_actionPerformed(null);
        } else if (top < rowCount) {
            sm.removeAll(false);
            sm.select(top, -1);
        } else {
            sm.removeAll();
            this.afterSelectCfOppEntry(null);
            sm.select(0, -1);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.storeFields();
        if (!this.checkDataObject()) {
            return;
        }
        if (this.cfCol == null) {
            this.cfCol = new CashflowRecordCollection();
        }
        this.cfCol = this.buildResult();
        this.setReturnValue(0);
        this.destroyWindow();
    }

    protected CashflowRecordCollection buildResult() {
        CashflowRecordCollection result = new CashflowRecordCollection();
        KDTable table = this.tblOppEntries;
        int rowCount = table.getRowCount();
        int seq = 1;
        for (int i = 0; i < rowCount; ++i) {
            CfOppEntryData oe = (CfOppEntryData)table.getRow(i).getUserObject();
            if (oe.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            CashflowRecordInfo rec = new CashflowRecordInfo();
            result.add(rec);
            rec.setSeq(seq++);
            rec.setVoucher(oe.getOppEntry().getBill());
            rec.setEntry(oe.getEntry());
            rec.setOpposingAccountEntry(oe.getOppEntry());
            rec.setAccount(oe.getEntry().getAccount());
            rec.setCurrency(oe.getEntry().getCurrency());
            rec.setEntryDC(oe.getEntry().getEntryDC());
            rec.setOpposingAccountEntry(oe.getOppEntry());
            rec.setOppAccount(oe.getOppEntry().getAccount());
            rec.setOppEntryDC(oe.getEntry().getEntryDC());
            if (oe.getAssrecord() != null) {
                rec.setOppVoucherAssistRecord(oe.getAssrecord());
                rec.setOppAssGrp(oe.getAssrecord().getAssGrp());
            }
            CashFlowItemInfo pi = oe.getPrimaryItem();
            rec.setPrimaryItem(pi);
            rec.setOriginalAmount(oe.getAmount());
            rec.setLocalAmount(oe.getLocalAmount());
            rec.setReportingAmount(oe.getReportingAmount());
            rec.setItemFlag(ItemFlag.PRIMARY);
            if (oe.getHgInfo() != null) {
                rec.setType(CashflowTypeEnum.IN);
            } else {
                rec.setType(CashflowTypeEnum.OUT);
            }
            rec.setIsSupItem(false);
            rec.setAssGrp(oe.getHgInfo());
            rec.setPrimaryCoefficient(oe.coefficient);
        }
        return result;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setReturnValue(1);
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionRecalc_actionPerformed(ActionEvent e) throws Exception {
        this.autoBalance(this.tblOppEntries);
    }

    protected void autoBalance(KDTable table) {
        BigDecimal[] alocal;
        IRow row = table.getRow(this.curCfOppEntryIndex);
        int rowCount = this.tblOppEntries.getRowCount();
        HashMap<String, BigDecimal[]> localamount = new HashMap<String, BigDecimal[]>();
        for (int i = 0; i < rowCount; ++i) {
            CfOppEntryData ed = (CfOppEntryData)this.tblOppEntries.getRow(i).getUserObject();
            if (this.curCfOppEntryIndex == i || ed.getLocalAmount() == null || ed.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            CfOppVoucherEntryWrapper wrapper = (CfOppVoucherEntryWrapper)this.tblOppEntries.getRow(i).getCell("o.Entry").getValue();
            String key = wrapper.getCashflowRecordid();
            BigDecimal amt = ed.getLocalAmount().multiply(ed.getCoefficient() == 1 ? GlUtils.one : GlUtils.negone);
            BigDecimal local = ed.getLocalAmount().multiply(ed.getCoefficient() == 1 ? GlUtils.one : GlUtils.negone);
            if (localamount.containsKey(key)) {
                alocal = (BigDecimal[])localamount.get(key);
                amt = alocal[1].add(amt);
                local = alocal[1].add(local);
            }
            BigDecimal[] blocal = new BigDecimal[]{amt, local};
            localamount.put(key, blocal);
        }
        CfOppVoucherEntryWrapper wrapper = (CfOppVoucherEntryWrapper)row.getCell("o.Entry").getValue();
        String key = wrapper.getCashflowRecordid();
        if (localamount.containsKey(key)) {
            CashflowRecordInfo r = (CashflowRecordInfo)this.colRecord.get(key);
            BigDecimal ramt = r.getOriginalAmount().multiply(r.getPrimaryCoefficient() == 1 ? GlUtils.one : GlUtils.negone);
            BigDecimal rlocal = r.getLocalAmount().multiply(r.getPrimaryCoefficient() == 1 ? GlUtils.one : GlUtils.negone);
            CfOppEntryData ed = (CfOppEntryData)row.getUserObject();
            alocal = (BigDecimal[])localamount.get(key);
            ed.setAmount(ramt.subtract(alocal[0]));
            ed.setLocalAmount(rlocal.subtract(alocal[1]));
            this.loadCfOppEntry(ed, wrapper, row);
        }
    }

    protected void fetchInitData() throws Exception {
        Map ctx = this.getUIContext();
        this.cfCol = (CashflowRecordCollection)ctx.get("CashFlowDirectSelectUI.CashflowRecordCollection");
        CompanyOrgUnitInfo info = GlUtils.getCompanyById(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        Map param = (Map)ctx.get("CashFlowDirectSelectUI.saveParam");
        this.localCurrency = info.getBaseCurrency();
        this.reportingCurrency = info.getReportCurrency();
        this.precision = (Integer)param.get("precision");
    }

    public void onLoad() throws Exception {
        this.fetchInitData();
        this.initTableStyle();
        super.onLoad();
        this.loadFields();
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.detachListeners();
        this.tblOppEntries.removeRows();
        this.colRecord = new HashMap();
        this.oppEntries = new Vector();
        if (this.cfCol != null && this.cfCol.size() > 0) {
            for (CashflowRecordInfo r : this.cfCol) {
                IRow row = this.tblOppEntries.addRow();
                String cashflowId = r.getId().toString();
                CfOppEntryData oe = new CfOppEntryData(r.getEntry(), r.getOpposingAccountEntry(), r.getPrimaryItem(), r.getPrimaryCoefficient(), r.getOriginalAmount(), r.getLocalAmount(), r.getReportingAmount(), r.getOppVoucherAssistRecord(), r.getAssGrp());
                CfOppVoucherEntryWrapper cfE = new CfOppVoucherEntryWrapper(oe.getEntry(), oe.getOppEntry(), r.getSeq(), cashflowId, r.getOppVoucherAssistRecord());
                this.loadCfOppEntry(oe, cfE, row);
                this.oppEntries.add(cfE);
                this.colRecord.put(cashflowId, r);
            }
            this.comboBoxEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox(this.oppEntries));
            this.tblOppEntries.getColumn("o.Entry").setEditor((ICellEditor)this.comboBoxEditor);
        }
        this.attachListeners();
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(0, -1);
    }

    protected void initTableStyle() {
        this.remove((Component)this.btnRecalc);
        this.remove((Component)this.btnAddLine);
        this.remove((Component)this.btnInsertLine);
        this.remove((Component)this.btnRemoveLine);
        this.kDContainer1.addButton((JButton)this.btnRecalc);
        this.kDContainer1.addButton((JButton)this.btnAddLine);
        this.kDContainer1.addButton((JButton)this.btnInsertLine);
        this.kDContainer1.addButton((JButton)this.btnRemoveLine);
        this.tblOppEntries.checkParsed();
        this.tblOppEntries.getSelectManager().setSelectMode(1);
        this.tblOppEntries.getStyleAttributes().setWrapText(true);
        this.tblOppEntries.setDefaultRowHeight(39);
        IColumn oppPiCol = this.tblOppEntries.getColumn("o.primaryItem");
        IColumn oppAssGrpCol = this.tblOppEntries.getColumn("o.assGrp1");
        IColumn oppAmntCol = this.tblOppEntries.getColumn("o.amount");
        IColumn oppLaCol = this.tblOppEntries.getColumn("o.localAmount");
        IColumn oppRaCol = this.tblOppEntries.getColumn("o.reportingAmount");
        oppAmntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppLaCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppRaCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (this.foreignCurrencySU) {
            String amount = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"amount");
            oppAmntCol.getStyleAttributes().setHided(true);
            oppRaCol.getStyleAttributes().setHided(true);
            IRow oppHeader = this.tblOppEntries.getHeadRow(0);
            oppHeader.getCell("o.localAmount").setValue((Object)amount);
        } else if (!this.useReportingCurrency) {
            oppRaCol.getStyleAttributes().setHided(true);
        }
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setDataVerifierType(-1);
        formattedTextField.setSupportedEmpty(true);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.numberEditor.setClickCountToStart(1);
        oppAmntCol.setEditor((ICellEditor)this.numberEditor);
        oppLaCol.setEditor((ICellEditor)this.numberEditor);
        oppRaCol.setEditor((ICellEditor)this.numberEditor);
        oppAmntCol.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(this.precision));
        oppLaCol.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(this.localCurrency.getPrecision()));
        if (this.useReportingCurrency) {
            oppRaCol.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(this.reportingCurrency.getPrecision()));
        }
        KDBizPromptBox bizPiPromptBox = new KDBizPromptBox();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("type", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
        CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizPiPromptBox, (FilterInfo)filter, (CoreUIObject)this);
        oppPiCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPiPromptBox));
        ObjectValueRender normalObjectRender = new ObjectValueRender();
        normalObjectRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        oppPiCol.setRenderer((IBasicRender)normalObjectRender);
        KDBizPromptBox assGrp = new KDBizPromptBox();
        oppAssGrpCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)assGrp));
    }

    protected void storeCfOppEntry(CfOppEntryData oe, IRow row) {
        CfOppVoucherEntryWrapper wrapper = (CfOppVoucherEntryWrapper)row.getCell("o.Entry").getValue();
        oe.setOppEntry(wrapper.getOppEntry());
        VoucherEntryInfo entry = wrapper.getEntry();
        Object value = null;
        value = row.getCell("o.primaryItem").getValue();
        if (value instanceof Object[]) {
            value = ((Object[])value)[0];
        }
        oe.setPrimaryItem((CashFlowItemInfo)value);
        value = row.getCell("o.assGrp1").getUserObject();
        oe.setHgInfo((AssistantHGInfo)value);
        ICell amntCell = row.getCell("o.amount");
        ICell raCell = row.getCell("o.reportingAmount");
        BigDecimal amnt = (BigDecimal)amntCell.getValue();
        BigDecimal la = (BigDecimal)row.getCell("o.localAmount").getValue();
        BigDecimal ra = (BigDecimal)raCell.getValue();
        BigDecimal coefficient = GlUtils.one;
        BigDecimal bigDecimal = coefficient = entry.getEntryDC().getValue() == 1 ? GlUtils.one : GlUtils.negone;
        if (oe.getPrimaryItem() != null && oe.getPrimaryItem().getDirection().equals((Object)CashFlowDirection.OUT)) {
            coefficient = GlUtils.negone.multiply(coefficient);
        }
        oe.setCoefficient(coefficient.intValue());
        if (amnt != null) {
            oe.setAmount(amnt.multiply(coefficient));
            oe.setLocalAmount(la.multiply(coefficient));
            if (this.useReportingCurrency) {
                oe.setReportingAmount(ra.multiply(coefficient));
            } else {
                oe.setReportingAmount(la.multiply(coefficient));
            }
        }
    }

    protected void CfOppEntrySwitchListenerActiveCellChanged(KDTActiveCellEvent evt, KDTable opptable, int preLine) {
        int line = evt.getRowIndex();
        if (preLine != line) {
            CfOppEntryData oe;
            IRow row;
            int rowCount = opptable.getRowCount();
            if (preLine >= rowCount) {
                preLine = -1;
            }
            if (line >= rowCount) {
                line = -1;
            }
            if (preLine >= 0) {
                row = opptable.getRow(preLine);
                oe = (CfOppEntryData)row.getUserObject();
                this.storeCfOppEntry(oe, row);
            }
            if (line >= 0) {
                row = opptable.getRow(line);
                oe = (CfOppEntryData)row.getUserObject();
                this.afterSelectCfOppEntry(oe);
            } else {
                this.afterSelectCfOppEntry(null);
            }
        }
    }

    protected void afterSelectCfOppEntry(CfOppEntryData oe) {
        if (this.tblOppEntries.getRowCount() > 1) {
            this.btnRemoveLine.setEnabled(true);
        } else {
            this.btnRemoveLine.setEnabled(false);
        }
    }

    protected void detachListeners() {
        this.tblOppEntries.removeKDTEditListener((KDTEditListener)this.cfOppEntryEditLs);
        this.tblOppEntries.removeKDTActiveCellListener((KDTActiveCellListener)this.cfOppEntrySwitchLs);
    }

    protected void attachListeners() {
        this.tblOppEntries.addKDTActiveCellListener((KDTActiveCellListener)this.cfOppEntrySwitchLs);
        this.tblOppEntries.addKDTEditListener((KDTEditListener)this.cfOppEntryEditLs);
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }

    public CashflowRecordCollection getCfCol() {
        return this.cfCol;
    }

    public void setCfCol(CashflowRecordCollection cfCol) {
        this.cfCol = cfCol;
    }

    protected void loadCfOppEntry(CfOppEntryData oe, CfOppVoucherEntryWrapper cfE, IRow row) {
        BigDecimal coefficient;
        AssistantHGInfo assGrp;
        CurrencyInfo cur = oe.getEntry().getCurrency();
        CashFlowItemInfo newitem = oe.getPrimaryItem();
        row.getCell("o.Entry").setValue((Object)cfE);
        row.getCell("o.primaryItem").setValue((Object)newitem);
        Object[] info = null;
        if (newitem != null && newitem.isIsEnable()) {
            info = CashFlowDirectUtil.getCachedColumnInfo(this.hmDynamicColumnInfo, newitem.getAsstAccount());
            CashFlowDirectUtil.setDynamicColumnInfo(this.tblOppEntries, row, "o.assGrp1", info, this.hmDynamicPromptBox, (CoreUIObject)this);
        }
        if (oe.getHgInfo() != null) {
            assGrp = oe.getHgInfo();
            if (this.set(info, assGrp, row)) {
                row.getCell("o.assGrp1").setUserObject((Object)assGrp);
            }
        } else if (oe.getAssrecord() != null && oe.getAssrecord().getAssGrp() != null && this.set(info, assGrp = oe.getAssrecord().getAssGrp(), row)) {
            row.getCell("o.assGrp1").setUserObject((Object)assGrp);
            oe.setHgInfo(assGrp);
        }
        BigDecimal bigDecimal = coefficient = oe.getCoefficient() == 1 ? GlUtils.one : GlUtils.negone;
        if (oe.getOppEntry() != null) {
            row.getCell("o.amount").setValue((Object)GlUtils.setScale(oe.getAmount().multiply(coefficient), cur.getPrecision()));
            row.getCell("o.localAmount").setValue((Object)GlUtils.setScale(oe.getLocalAmount().multiply(coefficient), this.localCurrency.getPrecision()));
            if (this.useReportingCurrency) {
                row.getCell("o.reportingAmount").setValue((Object)GlUtils.setScale(oe.getReportingAmount().multiply(coefficient), this.reportingCurrency.getPrecision()));
            } else if (row.getCell("o.reportingAmount") != null) {
                row.getCell("o.reportingAmount").getStyleAttributes().setHided(true);
            }
        }
        row.setUserObject((Object)oe);
    }

    private boolean set(Object[] info, AssistantHGInfo assGrp, IRow row) {
        boolean isOk = false;
        if (info != null) {
            VoucherInfo.DynamicColumnInfo[] itemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
            for (int i = 0; i < itemCols.length; ++i) {
                String key = itemCols[i].getMappingPropName();
                String colKey = CF_OPP_ASSGRP + (i + 1);
                if (assGrp.getId() != null) {
                    try {
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("asstribute", key);
                        param.put("id", assGrp.getId().toString());
                        Map result = GLGeneralFacadeFactory.getRemoteInstance().dealTask("GetDataBaseInfo", param);
                        if (result == null) continue;
                        ObjectBaseInfo dbInfo = (ObjectBaseInfo)result.get("DataBaseInfo");
                        assGrp.put(key, (Object)dbInfo);
                        row.getCell(colKey).setValue((Object)dbInfo);
                        isOk = true;
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    continue;
                }
                if (assGrp.get(key) == null) continue;
                ObjectBaseInfo dbInfo = (ObjectBaseInfo)assGrp.get(key);
                row.getCell(colKey).setValue((Object)dbInfo);
                isOk = true;
            }
        }
        return isOk;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        KDTEditManager em = this.tblOppEntries.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
            if (em.isEditing()) {
                SysUtil.abort();
            }
        }
    }

    protected boolean checkDataObject() {
        BigDecimal local;
        int rowCount = this.tblOppEntries.getRowCount();
        HashMap<String, BigDecimal> localamount = new HashMap<String, BigDecimal>();
        for (int i = 0; i < rowCount; ++i) {
            CfOppEntryData ed = (CfOppEntryData)this.tblOppEntries.getRow(i).getUserObject();
            if (ed.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            String prop = this.getCfOppEntryIllegalProp(ed);
            if (prop != null) {
                KDTSelectManager sm = this.tblOppEntries.getSelectManager();
                sm.removeAll(false);
                sm.select(i, -1);
                return false;
            }
            CfOppVoucherEntryWrapper wrapper = (CfOppVoucherEntryWrapper)this.tblOppEntries.getRow(i).getCell("o.Entry").getValue();
            String key = wrapper.getCashflowRecordid();
            local = ed.getLocalAmount().multiply(ed.getCoefficient() == 1 ? GlUtils.one : GlUtils.negone);
            if (localamount.containsKey(key)) {
                BigDecimal alocal = (BigDecimal)localamount.get(key);
                local = alocal.add(local);
            }
            localamount.put(key, local);
        }
        Set set = this.colRecord.keySet();
        for (String key : set) {
            CashflowRecordInfo r = (CashflowRecordInfo)this.colRecord.get(key);
            BigDecimal rlocal = r.getLocalAmount().multiply(r.getPrimaryCoefficient() == 1 ? GlUtils.one : GlUtils.negone);
            if (localamount.containsKey(key)) {
                local = (BigDecimal)localamount.get(key);
                if (rlocal.compareTo(local) == 0) continue;
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"169_CashFlowDirectSelectUI"));
                sb.append(r.getSeq()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"170_CashFlowDirectSelectUI"));
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"171_CashFlowDirectSelectUI"));
                sb.append(rlocal);
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"172_CashFlowDirectSelectUI"));
                sb.append(local);
                MsgBox.showWarning((Component)((Object)this), (String)sb.toString());
                return false;
            }
            StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"169_CashFlowDirectSelectUI"));
            sb.append(r.getSeq()).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"170_CashFlowDirectSelectUI"));
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"171_CashFlowDirectSelectUI"));
            sb.append(rlocal).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"173_CashFlowDirectSelectUI"));
            MsgBox.showWarning((Component)((Object)this), (String)sb.toString());
            return false;
        }
        return true;
    }

    protected String getCfOppEntryIllegalProp(CfOppEntryData oe) {
        CashFlowItemInfo pi = oe.getPrimaryItem();
        if (pi == null) {
            String missingPI = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingPI");
            MsgBox.showWarning((Component)((Object)this), (String)missingPI);
            return "o.primaryItem";
        }
        if (pi.isIsEnable() && pi.getAsstAccount() != null && oe.getHgInfo() == null) {
            String missingPI = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingASSGRP");
            MsgBox.showWarning((Component)((Object)this), (String)missingPI);
            return "o.assGrp1";
        }
        if (oe.getAmount() == null) {
            String missingAmount = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingAmount");
            MsgBox.showWarning((Component)((Object)this), (String)missingAmount);
            if (!this.foreignCurrencySU) {
                return "o.amount";
            }
            return "o.localAmount";
        }
        if (oe.getLocalAmount() == null) {
            String missingLocal = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingLocal");
            MsgBox.showWarning((Component)((Object)this), (String)missingLocal);
            return "o.localAmount";
        }
        if (!this.foreignCurrencySU && this.useReportingCurrency && oe.getReportingAmount() == null) {
            String missingReporting = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingReporting");
            MsgBox.showWarning((Component)((Object)this), (String)missingReporting);
            return "o.reportingAmount";
        }
        return null;
    }

    static class CfOppVoucherEntryWrapper {
        private VoucherEntryInfo entry;
        private VoucherEntryInfo oppEntry;
        private VoucherAssistRecordInfo asstRecord;
        private int seq;
        private String cashflowRecordid;

        public CfOppVoucherEntryWrapper(VoucherEntryInfo ent, VoucherEntryInfo opp, int seq, String id, VoucherAssistRecordInfo asstRecord) {
            this.entry = ent;
            this.oppEntry = opp;
            this.seq = seq;
            this.cashflowRecordid = id;
            this.asstRecord = asstRecord;
        }

        public VoucherEntryInfo getEntry() {
            return this.entry;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            if (this.oppEntry != null) {
                sb.append("(");
                sb.append(this.seq);
                sb.append(")");
                AccountViewInfo acc = this.oppEntry.getAccount();
                sb.append(acc.getNumber());
                sb.append(" - ");
                sb.append(acc.getLongName());
                if (this.asstRecord != null) {
                    sb.append("(");
                    sb.append(this.asstRecord.getAssGrp().getLongNameGroup());
                    sb.append(")");
                }
            }
            return sb.toString();
        }

        public String getCashflowRecordid() {
            return this.cashflowRecordid;
        }

        public VoucherEntryInfo getOppEntry() {
            return this.oppEntry;
        }

        public VoucherAssistRecordInfo getAsstRecord() {
            return this.asstRecord;
        }
    }

    static class CfOppEntryData {
        private VoucherEntryInfo entry;
        private VoucherEntryInfo oppEntry;
        private CashFlowItemInfo primaryItem;
        private int coefficient;
        private BigDecimal amount;
        private BigDecimal localAmount;
        private BigDecimal reportingAmount;
        private VoucherAssistRecordInfo assrecord;
        private AssistantHGInfo hgInfo;

        public CfOppEntryData(VoucherEntryInfo ent, VoucherEntryInfo opp, CashFlowItemInfo pi, int coef, BigDecimal amnt, BigDecimal la, BigDecimal ra, VoucherAssistRecordInfo ass, AssistantHGInfo hg) {
            this.entry = ent;
            this.oppEntry = opp;
            this.primaryItem = pi;
            this.coefficient = coef;
            this.amount = amnt;
            this.localAmount = la;
            this.reportingAmount = ra;
            this.assrecord = ass;
        }

        public CfOppEntryData(VoucherEntryInfo ent, VoucherEntryInfo opp, CashFlowItemInfo pi, int coef, VoucherAssistRecordInfo ass) {
            this.entry = ent;
            this.oppEntry = opp;
            this.primaryItem = pi;
            this.coefficient = coef;
            this.amount = GlUtils.zero;
            this.localAmount = GlUtils.zero;
            this.reportingAmount = GlUtils.zero;
            this.assrecord = ass;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public VoucherEntryInfo getEntry() {
            return this.entry;
        }

        public void setEntry(VoucherEntryInfo entry) {
            this.entry = entry;
        }

        public AssistantHGInfo getHgInfo() {
            return this.hgInfo;
        }

        public void setHgInfo(AssistantHGInfo hgInfo) {
            this.hgInfo = hgInfo;
        }

        public BigDecimal getLocalAmount() {
            return this.localAmount;
        }

        public void setLocalAmount(BigDecimal localAmount) {
            this.localAmount = localAmount;
        }

        public VoucherEntryInfo getOppEntry() {
            return this.oppEntry;
        }

        public void setOppEntry(VoucherEntryInfo oppEntry) {
            this.oppEntry = oppEntry;
        }

        public CashFlowItemInfo getPrimaryItem() {
            return this.primaryItem;
        }

        public void setPrimaryItem(CashFlowItemInfo primaryItem) {
            this.primaryItem = primaryItem;
        }

        public BigDecimal getReportingAmount() {
            return this.reportingAmount;
        }

        public void setReportingAmount(BigDecimal reportingAmount) {
            this.reportingAmount = reportingAmount;
        }

        public VoucherAssistRecordInfo getAssrecord() {
            return this.assrecord;
        }

        public void setAssrecord(VoucherAssistRecordInfo assrecord) {
            this.assrecord = assrecord;
        }

        public int getCoefficient() {
            return this.coefficient;
        }

        public void setCoefficient(int coefficient) {
            this.coefficient = coefficient;
        }
    }

    class CfOppEntrySwitchListener
    implements KDTActiveCellListener {
        CfOppEntrySwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            int line = e.getRowIndex();
            int preLine = CashFlowDirectSelectUI.this.curCfOppEntryIndex;
            CashFlowDirectSelectUI.this.curCfOppEntryIndex = line;
            CashFlowDirectSelectUI.this.CfOppEntrySwitchListenerActiveCellChanged(e, CashFlowDirectSelectUI.this.tblOppEntries, preLine);
        }
    }

    class CfOppEntryEditAdapter
    extends KDTEditAdapter {
        private Object oldValue;

        CfOppEntryEditAdapter() {
        }

        public void editStarting(KDTEditEvent e) {
            KDTable table = (KDTable)e.getSource();
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            this.oldValue = table.getRow(rowIndex).getCell(colIndex).getValue();
            String colKey = table.getColumnKey(colIndex);
            ICellEditor editor = table.getEditManager().getEditor();
            Component component = editor.getComponent();
            IRow curRow = CashFlowDirectSelectUI.this.tblOppEntries.getRow(e.getRowIndex());
            CfOppEntryData oe = (CfOppEntryData)curRow.getUserObject();
            CurrencyInfo cur = oe.getEntry().getCurrency();
            if (editor == CashFlowDirectSelectUI.this.numberEditor) {
                KDFormattedTextField numberField = (KDFormattedTextField)CashFlowDirectSelectUI.this.numberEditor.getComponent();
                if ("o.amount".equals(colKey)) {
                    int prec = cur.getPrecision();
                    numberField.setPrecision(prec);
                } else if ("o.localAmount".equals(colKey)) {
                    numberField.setPrecision(CashFlowDirectSelectUI.this.localCurrency.getPrecision());
                } else if ("o.reportingAmount".equals(colKey)) {
                    numberField.setPrecision(CashFlowDirectSelectUI.this.reportingCurrency.getPrecision());
                }
            } else if (component instanceof KDBizPromptBox) {
                KDBizPromptBox bizPromptBox = (KDBizPromptBox)component;
                if ("o.primaryItem".equals(colKey)) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    FilterItemCollection fic = filter.getFilterItems();
                    fic.add(new FilterItemInfo("type", (Object)new Integer(CashFlowItemType.MASTER_TABLE_ITEM.getValue())));
                    fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
                    fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
                    fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    fic.add(new FilterItemInfo("direction", (Object)new Integer(0), CompareType.NOTEQUALS));
                    bizPromptBox.setEntityViewInfo(view);
                    CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizPromptBox, (FilterInfo)filter, (CoreUIObject)CashFlowDirectSelectUI.this);
                }
            }
        }

        public void editStopped(KDTEditEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getValue();
            IRow curRow = CashFlowDirectSelectUI.this.tblOppEntries.getRow(evt.getRowIndex());
            CfOppEntryData oe = (CfOppEntryData)curRow.getUserObject();
            if (!GlUtils.isEqual(newValue, oldValue)) {
                CfOppVoucherEntryWrapper wrap;
                CashFlowItemInfo newitem;
                int col;
                KDTable table = (KDTable)evt.getSource();
                String colKey = table.getColumnKey(col = evt.getColIndex());
                if ("o.primaryItem".equals(colKey) && newValue != null) {
                    CashFlowItemInfo olditem = (CashFlowItemInfo)oldValue;
                    CashFlowItemInfo newitem2 = (CashFlowItemInfo)newValue;
                    boolean isEnable = newitem2.isIsEnable();
                    if (isEnable) {
                        Object[] info = CashFlowDirectUtil.getCachedColumnInfo(CashFlowDirectSelectUI.this.hmDynamicColumnInfo, newitem2.getAsstAccount());
                        CashFlowDirectUtil.setDynamicColumnInfo(table, curRow, "o.assGrp1", info, CashFlowDirectSelectUI.this.hmDynamicPromptBox, (CoreUIObject)CashFlowDirectSelectUI.this);
                    }
                } else if ("o.primaryItem".equals(colKey) && newValue == null) {
                    int beginIndexOfAssItem = CashFlowDirectSelectUI.this.tblOppEntries.getColumnIndex("o.assGrp1");
                    ICell cell = curRow.getCell(beginIndexOfAssItem);
                    cell.setValue(null);
                    cell.getStyleAttributes().setLocked(true);
                    curRow.getCell("o.assGrp1").setUserObject(null);
                }
                if ("o.assGrp1".equals(colKey) && newValue != null && (newitem = (CashFlowItemInfo)curRow.getCell("o.primaryItem").getValue()) != null) {
                    try {
                        AssistantHGInfo group = CashFlowDirectUtil.confirmAssGrp(newitem.getAsstAccount(), curRow, CashFlowDirectSelectUI.this.hmDynamicColumnInfo, colKey);
                        curRow.getCell("o.assGrp1").setUserObject((Object)group);
                    }
                    catch (Exception e) {
                        CashFlowDirectSelectUI.this.handleException(e);
                    }
                }
                if ("o.amount".equals(colKey)) {
                    if (newValue == null) {
                        curRow.getCell("o.localAmount").setValue(null);
                        curRow.getCell("o.reportingAmount").setValue(null);
                    } else {
                        VoucherInfo.ExchangeRateWithValue lexObj = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
                        BigDecimal la = null;
                        Object ra = null;
                        BigDecimal amnt = (BigDecimal)newValue;
                        if (lexObj != null) {
                            BigDecimal lex = lexObj.getValue();
                            la = ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)lexObj.getConvertMode()) ? amnt.multiply(lex).setScale(CashFlowDirectSelectUI.this.localCurrency.getPrecision(), 5) : amnt.divide(lex, CashFlowDirectSelectUI.this.localCurrency.getPrecision(), 5);
                        } else {
                            la = amnt;
                        }
                        curRow.getCell("o.localAmount").setValue((Object)la);
                        curRow.getCell("o.reportingAmount").setValue(ra);
                    }
                } else if ("o.Entry".equals(colKey) && (wrap = (CfOppVoucherEntryWrapper)newValue) != null && wrap.getAsstRecord() != null) {
                    MsgBox.showWarning((Component)((Object)CashFlowDirectSelectUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"168_CashFlowDirectSelectUI"));
                    curRow.getCell("o.Entry").setValue(oldValue);
                    return;
                }
                CashFlowDirectSelectUI.this.storeCfOppEntry(oe, curRow);
            }
        }
    }
}

