/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowDirectFactory;
import com.kingdee.eas.fi.gl.CashFlowDirectUtil;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.ICashFlowDirect;
import com.kingdee.eas.fi.gl.TAccountCashflowInfo;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowDirectUI;
import com.kingdee.eas.fi.gl.client.AsstSelectUI;
import com.kingdee.eas.fi.gl.client.CashFlowDirectConditionUI;
import com.kingdee.eas.fi.gl.client.CashFlowListUI;
import com.kingdee.eas.fi.gl.client.ContentComparator;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.TreeTAccount;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CashFlowDirectUI
extends AbstractCashFlowDirectUI {
    private static final long serialVersionUID = 5152675720765856742L;
    private static final Logger logger = CoreUIObject.getLogger(CashFlowDirectUI.class);
    private static final String INIT_DATA_CFITEMS = "cfItems";
    private static final String INIT_DATA_ACCOUNT = "account";
    private static final String DEBIT_ACCOUNT = "debitAccount";
    private static final String DEBIT_AMOUNT = "debitAmount";
    private static final String CREDIT_ACCOUNT = "creditAccount";
    private static final String CREDIT_AMOUNT = "creditAmount";
    private static String GL_MUTEX_LOCK = "FI_GL_Mutex_Lock";
    private CashFlowDirectConditionUI conditionPanel = null;
    private CashflowQueryParam condition = null;
    private TreeTAccount rootTAccount = null;
    private TreeTAccount curTAccount = null;
    private Map menu;
    private int curRow = -1;
    private int curCloumn = 0;
    public static final String ACTIONKEY_SAVE = "SUBMIT";
    public static final String ACTIONKEY_DEL = "UPLongame";
    public static final String ACTIONKEY_SQL = "SQL";
    public static final String ACTIONKEY_UPDATE = "UPDATE";
    private String txtExpandAccunt = this.getResource("ExpandAccount");
    private String txtExpandSubAccount = this.getResource("ExpandSubAccount");
    private Map initData = null;
    private boolean isExpOccured = false;
    TableSelectionListener myTableSelectionListener = new TableSelectionListener();

    public CashFlowDirectUI() throws Exception {
        RptClientUtil.checkFIUnit(false);
        this.jbInit();
    }

    private void jbInit() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = this.getConditionPanel();
        }
        this.btnAppDefCashItem.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemAppDefCashItem.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.ktbCashflow.checkParsed();
        this.addMyMenu();
        this.ktbCashflow.getSelectManager().setSelectMode(2);
        this.ktbCashflow.getStyleAttributes().setLocked(true);
        this.setCanCopyPaste(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curRow = 0;
        this.curCloumn = 0;
        this.selectChanged(this.curRow, this.curCloumn, this.ktbCashflow);
        this.initMyListener();
        this.menuItemContdition.setVisible(false);
        this.menuItemQuery.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.attachListeners();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    protected void attachListeners() {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f09 = KeyStroke.getKeyStroke(83, 2);
        imEntry.put(ctrl_shift_f09, ACTIONKEY_SAVE);
        KeyStroke ctrl_shift_f7 = KeyStroke.getKeyStroke(68, 2);
        imEntry.put(ctrl_shift_f7, ACTIONKEY_DEL);
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put(ACTIONKEY_SAVE, new CashShortcutListener(ACTIONKEY_SAVE));
        entryActionMap.put(ACTIONKEY_DEL, new CashShortcutListener(ACTIONKEY_DEL));
    }

    private void initTiTle() {
        this.setUITitle(this.getResource("CashFlowTAccountUI"));
        if (this.condition.isCashFilt()) {
            this.kdbTitle.setText(this.getResource("CashFlowTAccountUI") + "_" + this.getResource("CashType"));
        } else {
            this.kdbTitle.setText(this.getResource("CashFlowTAccountUI") + "_" + this.condition.getAccount().getNumber() + "_" + this.condition.getAccount().getName());
        }
        if (this.condition.isPeriod()) {
            this.kdTxtPeriod.setText(InitClientHelp.getPeriodTitle2(this.condition.getStartYear(), this.condition.getStartPeriod(), this.condition.getEndYear(), this.condition.getEndPeriod()));
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"period"));
        } else {
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"date"));
            this.kdTxtPeriod.setText(InitClientHelp.getDateTitle(this.condition.getStartDate(), this.condition.getEndDate()));
        }
        this.kdTxtCurrency.setText(this.condition.getCurrency().getName());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnShowVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.menuItemShowVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnJoinVoucher.setVisible(false);
        this.btnJoinVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.btnJoinVoucher.addAssistMenuItem((Action)((Object)this.actionJoinVoucherHasnot));
        this.btnJoinVoucher.addAssistMenuItem((Action)((Object)this.actionJoinVoucherHased));
        this.btnJoinVoucherHased.setVisible(false);
        this.btnJoinVoucherHasnot.setVisible(false);
        this.actionJoinVoucherHasnot.setEnabled(true);
        this.actionJoinVoucherHased.setEnabled(true);
        this.actionShowVoucher.setEnabled(true);
    }

    protected void initMyListener() {
        this.ktbCashflow.addKDTActiveCellListener((KDTActiveCellListener)this.myTableSelectionListener);
        this.ktbCashflow.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 3) {
                    int line = e.getRowIndex();
                    int col = e.getColIndex();
                    CashFlowDirectUI.this.ktbCashflow.getSelectManager().select(line, col);
                }
            }
        });
    }

    private void initTable() {
        int precision = this.condition.getCurrency().getPrecision();
        IColumn colCredit = this.ktbCashflow.getColumn(CREDIT_AMOUNT);
        IColumn colDebit = this.ktbCashflow.getColumn(DEBIT_AMOUNT);
        colDebit.getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
        colCredit.getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
        colDebit.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        colCredit.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (this.condition.isCashColl()) {
            TreeTAccount debitCashType = this.rootTAccount.searchChild("dc");
            TreeTAccount debitNoCashType = this.rootTAccount.searchChild("dnc");
            TreeTAccount creditCashType = this.rootTAccount.searchChild("cc");
            TreeTAccount creditNoCashType = this.rootTAccount.searchChild("cnc");
            this.ktbCashflow.getTreeColumn().setOrientation(0);
            this.ktbCashflow.getTreeColumn().setLevelWidth(13);
            IRow row = null;
            if (debitCashType.getCashflowRecords().size() != 0) {
                row = this.ktbCashflow.addRow();
                row.getCell(DEBIT_ACCOUNT).setValue((Object)debitCashType.getName());
                row.getCell(DEBIT_AMOUNT).setValue((Object)debitCashType.getAmount());
                row.setUserObject((Object)debitCashType);
                row.setTreeLevel(debitCashType.getLevel());
            }
            if (debitNoCashType.getCashflowRecords().size() != 0) {
                row = this.ktbCashflow.addRow();
                row.getCell(DEBIT_ACCOUNT).setValue((Object)debitNoCashType.getName());
                row.getCell(DEBIT_AMOUNT).setValue((Object)debitNoCashType.getAmount());
                row.setUserObject((Object)debitNoCashType);
                row.setTreeLevel(debitNoCashType.getLevel());
            }
            if (creditCashType.getCashflowRecords().size() != 0) {
                row = this.ktbCashflow.addRow();
                row.getCell(CREDIT_ACCOUNT).setValue((Object)creditCashType.getName());
                row.getCell(CREDIT_AMOUNT).setValue((Object)creditCashType.getAmount());
                row.setUserObject((Object)creditCashType);
                row.setTreeLevel(creditCashType.getLevel());
            }
            if (creditNoCashType.getCashflowRecords().size() != 0) {
                row = this.ktbCashflow.addRow();
                row.getCell(CREDIT_ACCOUNT).setValue((Object)creditNoCashType.getName());
                row.getCell(CREDIT_AMOUNT).setValue((Object)creditNoCashType.getAmount());
                row.setUserObject((Object)creditNoCashType);
                row.setTreeLevel(creditNoCashType.getLevel());
            }
            this.ktbCashflow.setRefresh(true);
            this.ktbCashflow.setFocusable(true);
            this.ktbCashflow.getSelectManager().select(0, 0);
        } else {
            HashMap params;
            IRow row;
            TreeTAccount debit = this.rootTAccount.searchChild("debit");
            TreeTAccount credit = this.rootTAccount.searchChild("credit");
            if (debit.getCashflowRecords().size() != 0) {
                row = this.ktbCashflow.addRow();
                row.getCell(DEBIT_ACCOUNT).setValue((Object)debit.getName());
                row.getCell(DEBIT_AMOUNT).setValue((Object)debit.getAmount());
                row.setUserObject((Object)debit);
                row.setTreeLevel(debit.getLevel());
                row.getStyleAttributes().setHided(true);
                params = new HashMap();
                params.put(INIT_DATA_ACCOUNT, this.initData.get(INIT_DATA_ACCOUNT));
                debit.recreateChildren(1, params);
                this.expand(debit, null);
            }
            if (credit.getCashflowRecords().size() != 0) {
                row = this.ktbCashflow.addRow();
                row.getCell(CREDIT_ACCOUNT).setValue((Object)credit.getName());
                row.getCell(CREDIT_AMOUNT).setValue((Object)credit.getAmount());
                row.setUserObject((Object)credit);
                row.setTreeLevel(credit.getLevel());
                row.getStyleAttributes().setHided(true);
                params = new HashMap();
                params.put(INIT_DATA_ACCOUNT, this.initData.get(INIT_DATA_ACCOUNT));
                credit.recreateChildren(1, params);
                this.expand(credit, null);
            }
        }
        this.ktbCashflow.getTreeColumn().setDepth(0);
        this.ktbCashflow.reLayoutAndPaint();
    }

    private void addMyMenu() throws Exception {
        if (this.menu == null) {
            this.menu = new HashMap();
        }
        this.enableExportExcel(this.ktbCashflow);
        KDPopupMenu kdmenu = new KDPopupMenu();
        this.addPopMenu(kdmenu, this.getResource("ExpandAccount"), 1);
        this.addPopMenu(kdmenu, this.getResource("ExpandAssistant"), 2);
        this.addPopMenu(kdmenu, this.getResource("ExpandCashflowItem"), 3);
        this.addPopMenu(kdmenu, EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"42_CashFlowDirectUI"), 4);
        this.addPopMenu(kdmenu, EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"43_CashFlowDirectUI"), 10);
        this.addPopMenu(kdmenu, this.getResource("BackItem"), 5);
        this.addPopMenu(kdmenu, this.getResource("AddCashflowItem") + "         Ctrl+S", 6);
        this.addPopMenu(kdmenu, this.getResource("CancelCashflowItem") + "         Ctrl+D", 7);
        kdmenu.add((Component)new KDSeparator());
        KDPopupMenu menu = this.getMenuManager(this.ktbCashflow).getMenu();
        int count = menu.getComponentCount();
        for (int i = 0; i < count; ++i) {
            kdmenu.add(menu.getComponent(0));
        }
        this.getMenuManager(this.ktbCashflow).setMenu(kdmenu);
    }

    private void addPopMenu(KDPopupMenu kdmenu, String label, int action) {
        JMenuItem item = new JMenuItem();
        item.setText(label);
        kdmenu.add(item);
        item.addActionListener(new CashItemActionListener(action));
        this.menu.put(String.valueOf(action), item);
    }

    private void selectChanged(int line, int col, KDTable table) {
        boolean allowCFReq;
        if (line < 0 || col < 0 || this.menu.isEmpty()) {
            return;
        }
        IRow row = this.ktbCashflow.getRow(line);
        if (row != null) {
            int type;
            this.curTAccount = (TreeTAccount)row.getUserObject();
            this.setMenuEnable(true);
            this.actionShowVoucher.setEnabled(true);
            if (this.curTAccount.isCash()) {
                ((JMenuItem)this.menu.get("2")).setEnabled(false);
                ((JMenuItem)this.menu.get("3")).setEnabled(false);
                ((JMenuItem)this.menu.get("6")).setEnabled(false);
                ((JMenuItem)this.menu.get("7")).setEnabled(false);
                ((JMenuItem)this.menu.get("4")).setEnabled(false);
                this.actionShowVoucher.setEnabled(false);
            }
            if ((type = this.curTAccount.getType()) == 3 || type == 5 || type == 4) {
                ((JMenuItem)this.menu.get("1")).setText(this.txtExpandSubAccount);
            } else {
                ((JMenuItem)this.menu.get("1")).setText(this.txtExpandAccunt);
            }
            if (type == 6 || type == 4 || type == 8 || type == 9) {
                ((JMenuItem)this.menu.get("3")).setEnabled(false);
            }
            if (type == 8) {
                ((JMenuItem)this.menu.get("2")).setEnabled(false);
            }
        }
        boolean bl = allowCFReq = "0".equals(this.initData.get("GL_0152")) && Boolean.TRUE == (Boolean)this.initData.get("GL_070");
        if (allowCFReq) {
            ((JMenuItem)this.menu.get("6")).setEnabled(false);
            ((JMenuItem)this.menu.get("7")).setEnabled(false);
        }
    }

    @Override
    public void actionJoinVoucher_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionJoinVoucherHased_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionJoinVoucherHasnot_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionContdition_actionPerformed(ActionEvent e) throws Exception {
        if (this.curTAccount == null) {
            return;
        }
        Map cashflowRecords = this.curTAccount.getUnAssignedCashflowRecords();
        if (cashflowRecords.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"44_CashFlowDirectUI"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        ArrayList<String> list = new ArrayList<String>();
        for (TAccountCashflowInfo info : cashflowRecords.values()) {
            list.add(info.getVoucherId());
        }
        uiContext.put((Object)"IDList", list);
        uiContext.put((Object)"change", (Object)list.toString());
        CashFlowListUI.showCashFlowList(this.condition, (Map)uiContext);
    }

    @Override
    public void actionShowVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (this.isExpOccured) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"45_CashFlowDirectUI"));
            return;
        }
        if (this.curTAccount == null) {
            return;
        }
        if (this.curTAccount.isCash()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"46_CashFlowDirectUI"));
            return;
        }
        Map cashflowRecords = this.curTAccount.getUnAssignedCashflowRecords();
        if (cashflowRecords.size() > 0) {
            HashMap<String, Object> saveParam = new HashMap<String, Object>();
            saveParam.put("CashflowRecords", cashflowRecords);
            saveParam.put("currencyInfo", this.condition.getCurrency());
            saveParam.put("IsSimpleMode", "0".equals(String.valueOf(this.initData.get("GL_0152"))));
            saveParam.put("CFItems", (Map)this.initData.get(INIT_DATA_CFITEMS));
            Map result = CashFlowDirectUtil.showVoucherSetCashflowUI((Object)this, saveParam);
            if (result.size() > 0) {
                try {
                    Iterator it = result.keySet().iterator();
                    String key = null;
                    TAccountCashflowInfo info = null;
                    while (it.hasNext()) {
                        key = (String)it.next();
                        info = (TAccountCashflowInfo)cashflowRecords.get(key);
                        info.setSourceType(1);
                        info.setId((String)result.get(key));
                        result.put(key, info);
                    }
                    this.rootTAccount.replaceCashflowRecords(result);
                }
                catch (Exception e1) {
                    this.isExpOccured = true;
                    throw e1;
                }
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"47_CashFlowDirectUI"));
            return;
        }
        if (this.curTAccount.getType() == 6 || this.curTAccount.getType() == 9) {
            this.curTAccount.getParent().recreateChildren(2, new HashMap());
            this.expand(this.curTAccount.getParent(), e);
        } else {
            this.expandCashflowItem(e);
        }
    }

    private void setMenuEnable(boolean enable) {
        Set set = this.menu.keySet();
        for (String key : set) {
            ((JMenuItem)this.menu.get(key)).setEnabled(enable);
        }
    }

    protected ICashFlowDirect getBizInterface() throws BOSException {
        return CashFlowDirectFactory.getRemoteInstance();
    }

    public CashFlowDirectConditionUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CashFlowDirectConditionUI();
        }
        Dimension dd = new Dimension(340, 280);
        this.conditionPanel.setSize(dd);
        return this.conditionPanel;
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    public CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new CashFlowDirectConditionUI();
    }

    public String getResource(String resKey) {
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)resKey);
        return res;
    }

    private void initData(Map data) {
        Map accounts = (Map)this.initData.get(INIT_DATA_ACCOUNT);
        Map cfItems = (Map)this.initData.get(INIT_DATA_CFITEMS);
        this.rootTAccount = new TreeTAccount();
        this.rootTAccount.setNumber("root");
        this.rootTAccount.setType(0);
        this.rootTAccount.setLevel(0);
        if (this.condition.isCashColl()) {
            String cashType = this.getResource("CashType");
            String noCashtype = this.getResource("NoCashType");
            TreeTAccount debitCashType = new TreeTAccount();
            debitCashType.setName(cashType);
            debitCashType.setNumber("dc");
            debitCashType.setLevel(1);
            debitCashType.setType(1);
            debitCashType.setCash(true);
            debitCashType.setDebit(true);
            TreeTAccount debitNoCashType = new TreeTAccount();
            debitNoCashType.setName(noCashtype);
            debitNoCashType.setNumber("dnc");
            debitNoCashType.setLevel(1);
            debitNoCashType.setType(1);
            debitNoCashType.setCash(false);
            debitNoCashType.setDebit(true);
            TreeTAccount creditCashType = new TreeTAccount();
            creditCashType.setName(cashType);
            creditCashType.setNumber("cc");
            creditCashType.setLevel(1);
            creditCashType.setType(2);
            creditCashType.setCash(true);
            creditCashType.setDebit(false);
            TreeTAccount creditNoCashType = new TreeTAccount();
            creditNoCashType.setName(noCashtype);
            creditNoCashType.setNumber("cnc");
            creditNoCashType.setLevel(1);
            creditNoCashType.setType(2);
            creditNoCashType.setCash(false);
            creditNoCashType.setDebit(false);
            this.rootTAccount.addChild(debitCashType);
            this.rootTAccount.addChild(debitNoCashType);
            this.rootTAccount.addChild(creditCashType);
            this.rootTAccount.addChild(creditNoCashType);
            List list = (List)data.get("data");
            Iterator it = list.iterator();
            TAccountCashflowInfo info = null;
            AccountViewInfo av = null;
            CashFlowItemInfo cfItem = null;
            while (it.hasNext()) {
                info = (TAccountCashflowInfo)it.next();
                av = (AccountViewInfo)accounts.get(info.getEntryAccountNumber());
                info.setEntryAccountId(av.getId().toString());
                info.setEntryAccountLongName(av.getLongName());
                info.setEntryAccountLongNumber(av.getLongNumber());
                info.setEntryAccountName(av.getName());
                av = (AccountViewInfo)accounts.get(info.getOpposingEntryAccountNumber());
                info.setOpposingEntryAccountId(av.getId().toString());
                info.setOpposingEntryAccountLongName(av.getLongName());
                info.setOpposingEntryAccountLongNumber(av.getLongNumber());
                info.setOpposingEntryAccountName(av.getName());
                if (!StringUtils.isEmpty((String)info.getCashflowItemId())) {
                    cfItem = (CashFlowItemInfo)cfItems.get(info.getCashflowItemId());
                    info.setCashflowItemLongNumber(cfItem.getLongNumber());
                    info.setCashflowItemName(cfItem.getName());
                    info.setCashflowItemNumber(cfItem.getNumber());
                }
                this.rootTAccount.addCashflowRecord(info);
                if (info.isEntryDebit()) {
                    if (info.isOpposingEntryAccountCash()) {
                        debitCashType.addCashflowRecord(info);
                        debitCashType.addAmount(info.getAmount());
                        continue;
                    }
                    debitNoCashType.addCashflowRecord(info);
                    debitNoCashType.addAmount(info.getAmount());
                    continue;
                }
                if (info.isOpposingEntryAccountCash()) {
                    creditCashType.addCashflowRecord(info);
                    creditCashType.addAmount(info.getAmount());
                    continue;
                }
                creditNoCashType.addCashflowRecord(info);
                creditNoCashType.addAmount(info.getAmount());
            }
        } else {
            TreeTAccount debitType = new TreeTAccount();
            debitType.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"48_CashFlowDirectUI"));
            debitType.setNumber("debit");
            debitType.setLevel(1);
            debitType.setType(1);
            debitType.setDebit(true);
            TreeTAccount creditType = new TreeTAccount();
            creditType.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"49_CashFlowDirectUI"));
            creditType.setNumber("credit");
            creditType.setLevel(1);
            creditType.setType(2);
            creditType.setDebit(false);
            this.rootTAccount.addChild(debitType);
            this.rootTAccount.addChild(creditType);
            List list = (List)data.get("data");
            Iterator it = list.iterator();
            TAccountCashflowInfo info = null;
            CashFlowItemInfo cfItem = null;
            while (it.hasNext()) {
                info = (TAccountCashflowInfo)it.next();
                AccountViewInfo av = null;
                av = (AccountViewInfo)accounts.get(info.getEntryAccountNumber());
                info.setEntryAccountId(av.getId().toString());
                info.setEntryAccountLongName(av.getLongName());
                info.setEntryAccountLongNumber(av.getLongNumber());
                info.setEntryAccountName(av.getName());
                av = (AccountViewInfo)accounts.get(info.getOpposingEntryAccountNumber());
                info.setOpposingEntryAccountId(av.getId().toString());
                info.setOpposingEntryAccountLongName(av.getLongName());
                info.setOpposingEntryAccountLongNumber(av.getLongNumber());
                info.setOpposingEntryAccountName(av.getName());
                if (!StringUtils.isEmpty((String)info.getCashflowItemId())) {
                    cfItem = (CashFlowItemInfo)cfItems.get(info.getCashflowItemId());
                    info.setCashflowItemLongNumber(cfItem.getLongNumber());
                    info.setCashflowItemName(cfItem.getName());
                    info.setCashflowItemNumber(cfItem.getNumber());
                }
                this.rootTAccount.addCashflowRecord(info);
                if (info.isEntryDebit()) {
                    debitType.addCashflowRecord(info);
                    debitType.addAmount(info.getAmount());
                    continue;
                }
                creditType.addCashflowRecord(info);
                creditType.addAmount(info.getAmount());
            }
        }
    }

    private void expandAssistant(ActionEvent e) throws Exception {
        if (this.curTAccount == null) {
            return;
        }
        UIContext ctx = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AsstSelectUI.class.getName(), (Map)ctx, this.dataObjects, OprtState.VIEW);
        uiWindow.show();
        AsstSelectUI ui = (AsstSelectUI)uiWindow.getUIObject();
        Object obj = ui.getData();
        if (obj == null) {
            return;
        }
        AsstActTypeInfo asst = (AsstActTypeInfo)obj;
        HashMap<String, AsstActTypeInfo> params = new HashMap<String, AsstActTypeInfo>();
        params.put("AsstActType", asst);
        if (this.curTAccount.getType() == 6 || this.curTAccount.getType() == 8) {
            this.curTAccount.recreateChildren(4, params);
        } else {
            this.curTAccount.recreateChildren(3, params);
        }
        this.expand(this.curTAccount, e);
    }

    private void expandAccount(ActionEvent e) throws Exception {
        if (this.curTAccount == null) {
            return;
        }
        HashMap params = new HashMap();
        params.put(INIT_DATA_ACCOUNT, this.initData.get(INIT_DATA_ACCOUNT));
        this.curTAccount.recreateChildren(1, params);
        if (this.curTAccount.getChildren().size() > 0) {
            this.expand(this.curTAccount, e);
        } else {
            int type = this.curTAccount.getType();
            if (type == 3 || type == 5 || type == 4) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"50_CashFlowDirectUI"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"51_CashFlowDirectUI"));
            }
        }
    }

    private void expand(TreeTAccount tAccount, ActionEvent e) {
        if (tAccount.getChildren().size() == 0) {
            return;
        }
        this.backItem(tAccount, e);
        int level = tAccount.getLevel() + 1;
        if (this.ktbCashflow.getTreeColumn().getDepth() < level) {
            this.ktbCashflow.getTreeColumn().setDepth(level);
        }
        ArrayList children = new ArrayList(tAccount.getChildren().values());
        ContentComparator contentComparator = new ContentComparator();
        if (children != null) {
            TreeTAccount info;
            Collections.sort(children, contentComparator);
            int size = children.size();
            for (int i = 0; i < size && ((info = (TreeTAccount)children.get(i)).getName() == null || info.getName().indexOf("_") == -1); ++i) {
                if (i != size - 1) continue;
                Collections.sort(children);
            }
        }
        Iterator iterator = children.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            IRow row = this.ktbCashflow.addRow(this.curRow + i + 1);
            TreeTAccount info = (TreeTAccount)iterator.next();
            row.setUserObject((Object)info);
            String name = info.getName();
            if (info.isDebit()) {
                row.getCell(DEBIT_ACCOUNT).setValue((Object)this.withBlank(level, name));
                row.getCell(DEBIT_AMOUNT).setValue((Object)info.getAmount());
            } else {
                row.getCell(CREDIT_ACCOUNT).setValue((Object)this.withBlank(level, name));
                row.getCell(CREDIT_AMOUNT).setValue((Object)info.getAmount());
            }
            row.setTreeLevel(info.getLevel());
            ++i;
        }
    }

    private String withBlank(int level, String name) {
        int Count = 4;
        StringBuffer buffer = new StringBuffer("");
        if (!this.condition.isCashColl()) {
            --level;
        }
        for (int i = 0; i < level * Count; ++i) {
            buffer.append(" ");
        }
        buffer.append(name);
        return buffer.toString();
    }

    private void expandCashflowItem(ActionEvent e) throws EASBizException, BOSException {
        if (this.curTAccount == null) {
            return;
        }
        this.curTAccount.recreateChildren(2, new HashMap());
        this.expand(this.curTAccount, e);
    }

    private void showVoucher(ActionEvent e) {
        if (this.curTAccount == null) {
            return;
        }
        if (this.curTAccount.getContainedVoucher().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NoVoucher"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"IDList", (Object)this.curTAccount.getContainedVoucher());
            uiContext.put((Object)"change", (Object)this.curTAccount.getContainedVoucher().toString());
            try {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherListUI", (Map)uiContext);
                uiWindow.show();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    private void backItem(TreeTAccount tAccount, ActionEvent e) {
        if (tAccount == null) {
            return;
        }
        int rowIndex = this.getRowIndex(tAccount);
        if (rowIndex == -1) {
            return;
        }
        this.curTAccount = tAccount;
        this.curRow = rowIndex;
        this.ktbCashflow.getSelectManager().select(this.curRow, this.curCloumn);
        int level = tAccount.getLevel();
        int count = this.curRow + 1;
        IRow row = this.ktbCashflow.getRow(count);
        if (row != null) {
            TreeTAccount info = (TreeTAccount)row.getUserObject();
            while (info.getLevel() > level) {
                this.ktbCashflow.removeRow(count);
                row = this.ktbCashflow.getRow(count);
                if (row == null) break;
                info = (TreeTAccount)row.getUserObject();
            }
        }
    }

    private int getRowIndex(TreeTAccount tAccount) {
        IRow row = null;
        int rowCount = this.ktbCashflow.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.ktbCashflow.getRow(i);
            if (row.getUserObject() != tAccount) continue;
            return row.getRowIndex();
        }
        return -1;
    }

    private void addCashflowItem(ActionEvent e) throws Exception {
        if (this.isExpOccured) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"52_CashFlowDirectUI"));
            return;
        }
        if (this.curTAccount == null) {
            return;
        }
        if (this.curTAccount.isCash()) {
            return;
        }
        int choise = MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("CashFlowItemSelect"));
        if (choise != 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(0), CompareType.EQUALS));
        evi.setFilter(filter);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"Filter", (Object)filter);
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI", (Map)uiContext);
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return;
        }
        F7CashFlowItemMainUI ui = (F7CashFlowItemMainUI)uiWindow.getUIObject();
        ui.loadFields();
        uiWindow.show();
        CashFlowItemInfo item = (CashFlowItemInfo)ui.getData();
        if (ui.isCanceled() || item == null) {
            return;
        }
        try {
            Iterator<Object> it;
            boolean notEditAfterAudit = (Boolean)this.initData.get("GL_014");
            HashMap<String, Object> saveParam = new HashMap<String, Object>();
            saveParam.put("CashFlowItemInfo", item);
            HashMap cashflowRecords = new HashMap();
            cashflowRecords.putAll(this.curTAccount.getCashflowRecords());
            TAccountCashflowInfo needRemoveInfo = null;
            Iterator itNeedRemove = cashflowRecords.values().iterator();
            while (itNeedRemove.hasNext()) {
                needRemoveInfo = (TAccountCashflowInfo)itNeedRemove.next();
                if (needRemoveInfo.getVoucherStatus() < 3 || !notEditAfterAudit) continue;
                itNeedRemove.remove();
            }
            saveParam.put("CashflowRecords", cashflowRecords);
            saveParam.put("currencyInfo", this.condition.getCurrency());
            Map result = null;
            Map cfItems = (Map)this.initData.get(INIT_DATA_CFITEMS);
            if (item.getAsstAccount() != null) {
                saveParam.put("CFItems", cfItems);
                saveParam.put("IsSimpleMode", "0".equals(String.valueOf(this.initData.get("GL_0152"))));
                result = CashFlowDirectUtil.showVoucherSetCashflowUI((Object)this, saveParam);
                if (result.size() <= 0) {
                    return;
                }
            } else {
                it = cashflowRecords.values().iterator();
                TAccountCashflowInfo info = null;
                while (it.hasNext()) {
                    info = (TAccountCashflowInfo)it.next();
                    info.setCashflowItemId(item.getId().toString());
                    info.setCashflowItemLongNumber(item.getLongNumber());
                    info.setCashflowItemName(item.getName());
                    info.setCashflowItemNumber(item.getNumber());
                    info.setDirection(item.getDirection());
                    info.setCfiAssistId(null);
                    info.setCfiAssistDisplayNameGroup(null);
                }
                CashFlowDirectUtil.handleBeforeSave(cashflowRecords);
                Map returnMap = this.getBizInterface().saveCashflowItem(saveParam);
                result = (Map)returnMap.get("result");
            }
            it = result.keySet().iterator();
            String key = null;
            TAccountCashflowInfo info = null;
            while (it.hasNext()) {
                key = (String)it.next();
                info = (TAccountCashflowInfo)cashflowRecords.get(key);
                info.setCashflowItemId(item.getId().toString());
                info.setCashflowItemLongNumber(item.getLongNumber());
                info.setCashflowItemName(item.getName());
                info.setCashflowItemNumber(item.getNumber());
                info.setDirection(item.getDirection());
                info.setSourceType(1);
                info.setId((String)result.get(key));
                result.put(key, info);
            }
            this.rootTAccount.replaceCashflowRecords(result);
        }
        catch (Exception e1) {
            this.isExpOccured = true;
            throw e1;
        }
        int type = this.curTAccount.getType();
        if (type == 6 || type == 9) {
            this.curTAccount.getParent().recreateChildren(2, new HashMap());
            this.expand(this.curTAccount.getParent(), e);
        } else if (type == 4 || type == 8) {
            TreeTAccount tAccount = this.getFirstNoCFISuperior(this.curTAccount);
            tAccount.recreateChildren(2, new HashMap());
            this.expand(tAccount, e);
        } else {
            this.expandCashflowItem(e);
        }
    }

    private void cancelCashflowItem(ActionEvent e) throws Exception {
        int type;
        if (this.isExpOccured) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"53_CashFlowDirectUI"));
            return;
        }
        if (this.curTAccount == null) {
            return;
        }
        if (this.curTAccount.isCash()) {
            return;
        }
        int choise = MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("CashFlowItemRemove"));
        if (choise != 0) {
            return;
        }
        boolean notEditAfterAudit = (Boolean)this.initData.get("GL_014");
        HashMap<String, Map> cancelMap = new HashMap<String, Map>();
        HashMap<String, TAccountCashflowInfo> voucherAssigned = new HashMap<String, TAccountCashflowInfo>();
        Map cashflowRecords = this.curTAccount.getAssignedCashflowRecords();
        TAccountCashflowInfo needRemoveInfo = null;
        Iterator itNeedRemove = cashflowRecords.values().iterator();
        while (itNeedRemove.hasNext()) {
            needRemoveInfo = (TAccountCashflowInfo)itNeedRemove.next();
            if (needRemoveInfo.getVoucherStatus() >= 3 && notEditAfterAudit) {
                itNeedRemove.remove();
                continue;
            }
            if (needRemoveInfo.getVoucherCashflowFlag() != 4) continue;
            voucherAssigned.put(needRemoveInfo.getVoucherTypeName() + "-" + needRemoveInfo.getVoucherNumber() + "-(" + needRemoveInfo.getVoucherBookedDate() + ")", needRemoveInfo);
            itNeedRemove.remove();
        }
        cancelMap.put("CashflowRecords", cashflowRecords);
        try {
            Map returnMap = this.getBizInterface().cacelCashflowItem(cancelMap);
            Map result = (Map)returnMap.get("result");
            Iterator it = result.keySet().iterator();
            String key = null;
            TAccountCashflowInfo info = null;
            while (it.hasNext()) {
                key = (String)it.next();
                info = (TAccountCashflowInfo)cashflowRecords.get(key);
                info.setCashflowItemId(null);
                info.setCashflowItemLongNumber(null);
                info.setCashflowItemName(null);
                info.setCashflowItemNumber(null);
                info.setDirection(null);
                info.setCfiAssistId(null);
                info.setCfiAssistDisplayNameGroup(null);
                info.setSourceType(2);
                info.setId((String)result.get(key));
                result.put(key, info);
            }
            this.rootTAccount.replaceCashflowRecords(result);
        }
        catch (Exception e1) {
            this.isExpOccured = true;
            throw e1;
        }
        if (voucherAssigned.size() > 0) {
            StringBuffer entryNumber = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"54_CashFlowDirectUI"));
            for (String msg : voucherAssigned.keySet()) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"55_CashFlowDirectUI"));
                sb.append(msg).append("\r\n");
                entryNumber.append(sb.toString());
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"56_CashFlowDirectUI"), (String)entryNumber.toString(), (int)4);
        }
        if ((type = this.curTAccount.getType()) == 6 || type == 9) {
            this.curTAccount.getParent().recreateChildren(2, new HashMap());
            this.expand(this.curTAccount.getParent(), e);
        } else if (type == 4 || type == 8) {
            TreeTAccount tAccount = this.getFirstNoCFISuperior(this.curTAccount);
            tAccount.recreateChildren(2, new HashMap());
            this.expand(tAccount, e);
        } else {
            this.expandCashflowItem(e);
        }
    }

    private TreeTAccount getFirstNoCFISuperior(TreeTAccount searchTAccount) {
        TreeTAccount tAccount = searchTAccount;
        int tType = tAccount.getType();
        while ((tType == 4 || tType == 8 || tType == 6 || tType == 9) && tAccount.getLevel() != 0) {
            tAccount = tAccount.getParent();
            tType = tAccount.getType();
        }
        return tAccount;
    }

    @Override
    public void actionAppDefCashItem_actionPerformed(ActionEvent e) throws Exception {
        if (this.isExpOccured) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"57_CashFlowDirectUI"));
            return;
        }
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appDefCashItem"));
        if (result == 2) {
            return;
        }
        boolean isCover = false;
        if (result == 0) {
            isCover = true;
        }
        HashMap<String, CashflowQueryParam> params = new HashMap<String, CashflowQueryParam>();
        params.put("queryParam", this.condition);
        try {
            this.getBizInterface().saveCashflowItem(params, isCover);
        }
        catch (Exception e1) {
            this.isExpOccured = true;
            throw e1;
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appMainCashSuccess"));
        this.actionRefresh_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return this.getBizInterface();
    }

    protected KDTable getTableForPrintSetting() {
        return this.ktbCashflow;
    }

    protected RptParams getParamsForInit() {
        RptParams pp = new RptParams();
        pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return pp;
    }

    protected void query() {
        this.condition = (CashflowQueryParam)this.params.getObject("CashflowQueryParam");
        this.initTiTle();
        try {
            boolean allowCFReq;
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("EndYear", new Integer(this.condition.getEndYear()));
            params.put("EndPeriod", new Integer(this.condition.getEndPeriod()));
            this.initData = this.getBizInterface().fetchInitData(params);
            Map data = this.getBizInterface().getTAccountMap(this.condition);
            this.initData(data);
            this.curRow = -1;
            this.ktbCashflow.removeRows();
            this.initTable();
            this.isExpOccured = false;
            boolean bl = allowCFReq = "0".equals(this.initData.get("GL_0152")) && Boolean.TRUE == (Boolean)this.initData.get("GL_070");
            if (allowCFReq) {
                this.btnAppDefCashItem.setEnabled(false);
                this.menuItemAppDefCashItem.setEnabled(false);
                this.btnShowVoucher.setEnabled(false);
                this.menuItemShowVoucher.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected Map preparePrintVariantMap() {
        Map map = super.preparePrintVariantMap();
        map.put("Currency", this.kdTxtCurrency.getText());
        map.put("Period", this.kdTxtPeriod.getText());
        return map;
    }

    protected String getDecimalFormat(int scale) {
        StringBuffer sbff = new StringBuffer();
        StringBuffer sbffN = new StringBuffer();
        if (scale == 0) {
            sbff.append("#,##0");
            sbffN.append("-#,##0");
        } else {
            sbff.append("#,##0.");
            sbffN.append("-#,##0.");
        }
        for (int i = 0; i < scale; ++i) {
            sbff.append("0");
            sbffN.append("0");
        }
        return sbff.append(";").append(sbffN).toString();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    public void prepareParam(Map saveParam) {
    }

    public class CashItemActionListener
    implements ActionListener {
        private int action;

        public CashItemActionListener(int action) {
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CashFlowDirectUI.this.setCursorOfWair();
                if (CashFlowDirectUI.this.curRow < 0 || CashFlowDirectUI.this.curTAccount == null) {
                    String info = CashFlowDirectUI.this.getResource("NotSelectLine");
                    MsgBox.showInfo((String)info);
                    return;
                }
                switch (this.action) {
                    case 1: {
                        CashFlowDirectUI.this.expandAccount(e);
                        return;
                    }
                    case 2: {
                        CashFlowDirectUI.this.expandAssistant(e);
                        return;
                    }
                    case 9: {
                        CashFlowDirectUI.this.expandAssistant(e);
                        return;
                    }
                    case 3: {
                        CashFlowDirectUI.this.expandCashflowItem(e);
                        return;
                    }
                    case 8: {
                        CashFlowDirectUI.this.expandCashflowItem(e);
                        return;
                    }
                    case 4: {
                        CashFlowDirectUI.this.actionContdition_actionPerformed(e);
                        return;
                    }
                    case 10: {
                        CashFlowDirectUI.this.showVoucher(e);
                        return;
                    }
                    case 5: {
                        CashFlowDirectUI.this.backItem(CashFlowDirectUI.this.curTAccount, e);
                        return;
                    }
                    case 6: {
                        Uuid mutexUuid = Uuid.create();
                        try {
                            String mutexActionName = "addCashflowItem";
                            MutexParameter mutexParam = new MutexParameter();
                            mutexParam.setRequestId(mutexUuid);
                            mutexParam.setMutexName(GL_MUTEX_LOCK);
                            mutexParam.setActionName(mutexActionName);
                            mutexParam.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
                            mutexParam.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
                            mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
                            mutexParam.setDcName(SysContext.getSysContext().getDcName());
                            IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
                            boolean requestMutex = mutexService.requestMutex(mutexParam);
                            if (requestMutex) {
                                CashFlowDirectUI.this.addCashflowItem(e);
                                return;
                            }
                            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"58_CashFlowDirectUI"));
                            CashFlowDirectUI.this.abort();
                            return;
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        finally {
                            IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
                            mutexService.releaseMutex(mutexUuid);
                        }
                    }
                    case 7: {
                        Uuid mutexId = Uuid.create();
                        try {
                            String mutexActionName = "cannelCashflowItem";
                            MutexParameter mutexParam = new MutexParameter();
                            mutexParam.setRequestId(mutexId);
                            mutexParam.setMutexName(GL_MUTEX_LOCK);
                            mutexParam.setActionName(mutexActionName);
                            mutexParam.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
                            mutexParam.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
                            mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
                            mutexParam.setDcName(SysContext.getSysContext().getDcName());
                            IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
                            boolean requestMutex = mutexService.requestMutex(mutexParam);
                            if (requestMutex) {
                                CashFlowDirectUI.this.cancelCashflowItem(e);
                                return;
                            }
                            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"58_CashFlowDirectUI"));
                            CashFlowDirectUI.this.abort();
                            return;
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        finally {
                            IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
                            mutexService.releaseMutex(mutexId);
                        }
                    }
                }
                return;
            }
            catch (Exception ex) {
                CashFlowDirectUI.this.handleException(ex);
                return;
            }
            finally {
                CashFlowDirectUI.this.setCursorOfDefault();
            }
        }
    }

    class TableSelectionListener
    implements KDTActiveCellListener {
        TableSelectionListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            KDTable table = (KDTable)e.getSource();
            int line = e.getRowIndex();
            int col = e.getColumnIndex();
            CashFlowDirectUI.this.curRow = line;
            CashFlowDirectUI.this.curCloumn = col;
            CashFlowDirectUI.this.selectChanged(line, col, table);
        }
    }

    class CashShortcutListener
    extends AbstractAction {
        private static final long serialVersionUID = 1828998690049805719L;
        String shortcut;

        CashShortcutListener(String sc) {
            this.shortcut = sc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (CashFlowDirectUI.ACTIONKEY_SAVE.equals(this.shortcut)) {
                    CashFlowDirectUI.this.addCashflowItem(evt);
                } else if (CashFlowDirectUI.ACTIONKEY_DEL.equals(this.shortcut)) {
                    CashFlowDirectUI.this.cancelCashflowItem(evt);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }
}

