/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashFlowFilterPara;
import com.kingdee.eas.fi.gl.CashFlowRecordFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowFilterPanel;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.sql.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CashFlowFilterPanel
extends AbstractCashFlowFilterPanel {
    private static final long serialVersionUID = -5074320293463739548L;
    private CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
    private CashFlowFilterParam param;
    private boolean foreignCurrencySU;
    private PeriodInfo curPeriod;
    private int localCurPre;
    private boolean isClear;
    private CashFlowFilterPara cashFlowFilterPara;
    public static final Object ALL_CURRENCY = new Object(){

        public String toString() {
            return EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"ALLCURRENCY");
        }
    };

    public CashFlowFilterPanel(CompanyOrgUnitInfo curCompany, CashFlowFilterPara para) throws Exception {
        this.setCurCompany(curCompany);
        this.cashFlowFilterPara = para;
        this.fetchInitFilterData();
        this.radByDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    CashFlowFilterPanel.this.radByPeriodOrDate_stateChanged(e);
                }
                catch (Exception exc) {
                    CashFlowFilterPanel.this.handUIException(exc);
                }
            }
        });
        this.dateFrom.setSupportedEmpty(false);
        this.dateTo.setSupportedEmpty(false);
        this.dateFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CashFlowFilterPanel.this.dateFrom_dataChanged(e);
                }
                catch (Exception exc) {
                    CashFlowFilterPanel.this.handUIException(exc);
                }
            }
        });
        this.dateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    CashFlowFilterPanel.this.dateTo_dataChanged(e);
                }
                catch (Exception exc) {
                    CashFlowFilterPanel.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    protected void spnYearTo_stateChanged(ChangeEvent e) throws Exception {
        if (this.curCompany.isIsBizUnit()) {
            int yearEnd = (Integer)this.spnYearTo.getValue();
            int numberEnd = (Integer)this.spnPeriodTo.getValue();
            RptClientUtil.periodChanged((IUIObject)this, this.curCompany, yearEnd, numberEnd, this.kDBizPromptBoxAccountFrom, this.kDBizPromptBoxAccountTo);
        }
    }

    protected void dateFrom_dataChanged(DataChangeEvent e) throws Exception {
        Date dt;
        Date df = this.dateFrom.getSqlDate();
        if (df.after(dt = this.dateTo.getSqlDate())) {
            this.dateTo.setValue((Object)df);
        }
    }

    protected void dateTo_dataChanged(DataChangeEvent e) throws Exception {
        Date df = this.dateFrom.getSqlDate();
        Date dt = this.dateTo.getSqlDate();
        if (dt.before(df)) {
            this.dateFrom.setValue((Object)dt);
        }
        if (e != null && e.getOldValue() instanceof java.util.Date && e.getNewValue() instanceof java.util.Date) {
            java.util.Date oldDate = (java.util.Date)e.getOldValue();
            java.util.Date newDate = (java.util.Date)e.getNewValue();
            if (oldDate.getYear() != newDate.getYear()) {
                int yearEnd = ((java.util.Date)this.dateFrom.getValue()).getYear() + 1900;
                int numberEnd = ((java.util.Date)this.dateTo.getValue()).getMonth() + 1;
                RptClientUtil.periodChanged((IUIObject)this, this.curCompany, yearEnd, numberEnd, this.kDBizPromptBoxAccountFrom, this.kDBizPromptBoxAccountTo);
            }
        }
    }

    @Override
    protected void radByPeriodOrDate_stateChanged(ChangeEvent e) throws Exception {
        if (this.radByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
            this.pnlByDate.setVisible(false);
        } else {
            this.pnlByPeriod.setVisible(false);
            this.pnlByDate.setVisible(true);
        }
    }

    @Override
    protected void kDBizPromptBoxAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.kDBizPromptBoxAccountFrom.getValue();
        Object accountTo = this.kDBizPromptBoxAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            this.kDBizPromptBoxAccountTo.setValue(accountFrom);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void syschronizeParam() {
        this.param = (CashFlowFilterParam)this.getParam();
    }

    public CashFlowFilterParam getParamOuter() {
        return this.param;
    }

    public FilterInfo getFilterInfo() {
        Object cur;
        Object accountTObj;
        this.syschronizeParam();
        String curComId = null;
        curComId = !this.curCompany.isIsBizUnit() ? this.cashFlowFilterPara.getSelectedCompanyId() : (this.cashFlowFilterPara != null ? this.cashFlowFilterPara.getSelectedCompanyId() : this.curCompany.get("id").toString());
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)curComId));
        StringBuffer maskString = new StringBuffer("#0 AND ");
        int index = 1;
        if (!this.param.periodOrDate) {
            java.util.Date dtFrom = (java.util.Date)this.dateFrom.getValue();
            java.util.Date dtTo = (java.util.Date)this.dateTo.getValue();
            fic.add(new FilterItemInfo("bookedDate", (Object)dtFrom, CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("bookedDate", (Object)dtTo, CompareType.LESS_EQUALS));
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++);
        } else {
            int yearFrom = (Integer)this.spnYearFrom.getValue();
            int periodFrom = (Integer)this.spnPeriodFrom.getValue();
            int yearTo = (Integer)this.spnYearTo.getValue();
            int periodTo = (Integer)this.spnPeriodTo.getValue();
            try {
                List periods = CashFlowRecordFacadeFactory.getRemoteInstance().getPeriodsByNumberRange(curComId, yearFrom * 100 + periodFrom, yearTo * 100 + periodTo);
                if (periods != null && periods.size() > 0) {
                    fic.add(new FilterItemInfo("period.id", new HashSet(periods), CompareType.INCLUDE));
                    maskString.append("#" + index++);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        Object accountFObj = this.kDBizPromptBoxAccountFrom.getValue();
        if (accountFObj instanceof AccountViewInfo) {
            String accFrom = ((AccountViewInfo)accountFObj).getNumber();
            fic.add(new FilterItemInfo("e.account.number", (Object)accFrom, CompareType.GREATER_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((accountTObj = this.kDBizPromptBoxAccountTo.getValue()) instanceof AccountViewInfo) {
            String accTo = ((AccountViewInfo)accountTObj).getNumber() + "z";
            fic.add(new FilterItemInfo("e.account.number", (Object)accTo, CompareType.LESS_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((cur = this.cbxCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            fic.add(new FilterItemInfo("e.currency.id", (Object)((CurrencyInfo)cur).getId().toString()));
            maskString.append(" AND #" + index++);
        }
        if (this.radHaveCash.isSelected()) {
            fic.add(new FilterItemInfo("hasCashAccount", (Object)"true"));
            maskString.append(" AND #" + index++);
        } else if (this.radHaveNotCash.isSelected()) {
            fic.add(new FilterItemInfo("hasCashAccount", (Object)"false"));
            maskString.append(" AND #" + index++);
        }
        if (this.cashFlowFilterPara != null && this.cashFlowFilterPara.getAccountTabel() != null) {
            fic.add(new FilterItemInfo("account.accountTableid.id", (Object)this.cashFlowFilterPara.getAccountTabel().getId().toString(), CompareType.EQUALS));
            maskString.append(" AND #" + index++);
        }
        fic.add(new FilterItemInfo("cashflowFlag", (Object)new Integer(0), CompareType.NOTEQUALS));
        maskString.append(" AND #" + index++);
        if (this.param.isIncludeUnPosted()) {
            fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(0), CompareType.NOTEQUALS));
            maskString.append(" AND #" + index++);
            fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            maskString.append(" AND #" + index++);
        } else {
            fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
            maskString.append(" AND #" + index++);
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public void loadData(EntityViewInfo view) {
        this.setUIElementValue();
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public boolean verify() {
        if (this.radByDate.isSelected()) {
            Date from = this.dateFrom.getSqlDate();
            Date to = this.dateTo.getSqlDate();
            if (to.before(from)) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("InputDateStart"));
                this.dateFrom.requestFocus();
                return false;
            }
        }
        return true;
    }

    public String getResource(String resKey) {
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)resKey);
        return res;
    }

    public Object getParam() {
        Object fromObject;
        if (this.param == null) {
            this.param = new CashFlowFilterParam();
        }
        if ((fromObject = this.kDBizPromptBoxAccountFrom.getValue()) instanceof AccountViewInfo) {
            this.param.accountFrom = (AccountViewInfo)fromObject;
        } else {
            this.param.accountFrom = null;
        }
        Object toObject = this.kDBizPromptBoxAccountTo.getValue();
        if (toObject instanceof AccountViewInfo) {
            this.param.accountTo = (AccountViewInfo)toObject;
        } else {
            this.param.accountTo = null;
        }
        if (this.cbxCurrency.getSelectedItem() != ALL_CURRENCY) {
            this.param.currency = (CurrencyInfo)this.cbxCurrency.getSelectedItem();
        } else {
            this.param.currency = null;
        }
        if (this.radHaveCash.isSelected()) {
            this.param.hasCashAccount = 0;
        } else if (this.radHaveNotCash.isSelected()) {
            this.param.hasCashAccount = 1;
        } else {
            this.param.hasCashAccount = 2;
        }
        if (this.radHaveItem.isSelected()) {
            this.param.cashflowItemAssigned = 0;
        } else if (this.radHaveNotItem.isSelected()) {
            this.param.cashflowItemAssigned = 1;
        } else {
            this.param.cashflowItemAssigned = 2;
        }
        if (this.radByVoucher.isSelected()) {
            this.param.setByDetail(0);
        } else if (this.radByEntry.isSelected()) {
            this.param.setByDetail(1);
        } else if (this.radByAssistRecord.isSelected()) {
            this.param.setByDetail(2);
        }
        if (this.radByPeriod.isSelected()) {
            this.param.setPeriodOrDate(true);
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            this.param.setStartYear(yearFrom);
            this.param.setStartPeriod(periodFrom);
            this.param.setEndYear(yearTo);
            this.param.setEndPeriod(periodTo);
        } else {
            this.param.setPeriodOrDate(false);
            this.param.setStartDate((java.util.Date)this.dateFrom.getValue());
            this.param.setEndDate((java.util.Date)this.dateTo.getValue());
        }
        if (this.kDCheckBoxAllVoucher.isSelected()) {
            this.param.setIncludeUnPosted(true);
        } else {
            this.param.setIncludeUnPosted(false);
        }
        return this.param;
    }

    public void setParam(Object p) {
        this.param = (CashFlowFilterParam)p;
        this.setUIElementValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fetchInitFilterData() throws Exception {
        String curComId = null;
        if (!this.curCompany.isIsBizUnit()) {
            if (this.cashFlowFilterPara == null) throw new GLException(GLException.COMMUSTBEENTITY);
            curComId = this.cashFlowFilterPara.getCompanyIds();
            curComId = curComId.replaceAll("'", "");
            String[] curComIds = curComId.split(",");
            curComId = curComIds[0];
        } else {
            curComId = this.getCurCompany().getId().toString();
        }
        Object[] initData = VoucherFacadeFactory.getRemoteInstance().fetchInitFilterData(curComId);
        this.curCompany = (CompanyOrgUnitInfo)initData[0];
        GlUtils.AccountPeriodInfo pi = (GlUtils.AccountPeriodInfo)initData[1];
        this.curPeriod = pi.curPeriod;
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.curCompany);
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false, (boolean)false);
        this.dateFrom.setValue((Object)this.curPeriod.getBeginDate());
        this.dateTo.setValue((Object)this.curPeriod.getEndDate());
        this.initAccountF7();
        this.foreignCurrencySU = (Boolean)initData[4];
        if (!this.foreignCurrencySU) {
            CurrencyInfo localCur = this.curCompany.getBaseCurrency();
            this.localCurPre = localCur.getPrecision();
            this.cbxCurrency.addItem(ALL_CURRENCY);
        }
        CurrencyCollection curCol = (CurrencyCollection)initData[2];
        this.cbxCurrency.addItems(curCol.toArray());
        this.radByVoucher.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CashFlowFilterPanel.this.radCashAll.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveCash.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveNotCash.setEnabled(true);
                    CashFlowFilterPanel.this.radItemAll.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveItem.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveNotItem.setEnabled(true);
                } else {
                    CashFlowFilterPanel.this.radCashAll.setSelected(true);
                    CashFlowFilterPanel.this.radCashAll.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveCash.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveNotCash.setEnabled(false);
                    CashFlowFilterPanel.this.radItemAll.setSelected(true);
                    CashFlowFilterPanel.this.radItemAll.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveItem.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveNotItem.setEnabled(false);
                }
            }
        });
        this.radByAssistRecord.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CashFlowFilterPanel.this.radCashAll.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveCash.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveNotCash.setEnabled(true);
                    CashFlowFilterPanel.this.radItemAll.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveItem.setEnabled(true);
                    CashFlowFilterPanel.this.radHaveNotItem.setEnabled(true);
                } else {
                    CashFlowFilterPanel.this.radCashAll.setSelected(true);
                    CashFlowFilterPanel.this.radCashAll.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveCash.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveNotCash.setEnabled(false);
                    CashFlowFilterPanel.this.radItemAll.setSelected(true);
                    CashFlowFilterPanel.this.radItemAll.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveItem.setEnabled(false);
                    CashFlowFilterPanel.this.radHaveNotItem.setEnabled(false);
                }
            }
        });
    }

    private void initAccountF7() throws Exception {
        this.kDBizPromptBoxAccountFrom.setEditable(true);
        this.kDBizPromptBoxAccountFrom.setEditFormat("$number$");
        this.kDBizPromptBoxAccountFrom.setDisplayFormat("$number$ - $name$");
        this.kDBizPromptBoxAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.kDBizPromptBoxAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.kDBizPromptBoxAccountFrom.setCommitParser((IParser)new AccountViewParser(this.kDBizPromptBoxAccountFrom));
        this.kDBizPromptBoxAccountTo.setEditable(true);
        this.kDBizPromptBoxAccountTo.setEditFormat("$number$");
        this.kDBizPromptBoxAccountTo.setDisplayFormat("$number$ - $name$");
        this.kDBizPromptBoxAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.kDBizPromptBoxAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.kDBizPromptBoxAccountTo.setCommitParser((IParser)new AccountViewParser(this.kDBizPromptBoxAccountTo));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        this.kDBizPromptBoxAccountFrom.setSelectorCollection(sic);
        this.kDBizPromptBoxAccountTo.setSelectorCollection(sic);
        this.setAccountF7Filter();
    }

    protected void setAccountF7Filter() throws Exception {
        AccountTableInfo accountTable = this.curCompany.getAccountTable();
        try {
            AccountRefContrastInfo ar = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(this.curCompany.getId().toString(), accountTable.getId().toString(), this.spnYearTo.getIntegerVlaue().intValue(), this.spnPeriodTo.getIntegerVlaue().intValue());
            if (ar != null) {
                accountTable = ar.getEnabledAcctTable();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        fic.add(new FilterItemInfo("isProfitCenter", (Object)new Integer(1), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("category", (Object)2, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, accountTable, filter, false);
        HashSet<Integer> budgets = new HashSet<Integer>();
        budgets.add(12);
        budgets.add(13);
        budgets.add(14);
        FilterInfo treeNodefilter = new FilterInfo();
        treeNodefilter.getFilterItems().add(new FilterItemInfo("property", budgets, CompareType.NOTINCLUDE));
        apb.setTreeNodefilter(treeNodefilter);
        this.kDBizPromptBoxAccountFrom.setSelector((KDPromptSelector)apb);
        this.kDBizPromptBoxAccountTo.setSelector((KDPromptSelector)apb);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        this.kDBizPromptBoxAccountFrom.setEntityViewInfo(ev);
        this.kDBizPromptBoxAccountTo.setEntityViewInfo(ev);
    }

    public boolean isForeignCurrencySU() {
        return this.foreignCurrencySU;
    }

    public int getLocalCurPre() {
        return this.localCurPre;
    }

    public void clear() {
        if (this.isClear()) {
            this.isClear = false;
            return;
        }
        super.clear();
        this.spnYearFrom.setValue((Object)new Integer(this.curPeriod.getPeriodYear()));
        this.spnYearTo.setValue((Object)new Integer(this.curPeriod.getPeriodYear()));
        this.spnPeriodFrom.setValue((Object)new Integer(this.curPeriod.getPeriodNumber()));
        this.spnPeriodTo.setValue((Object)new Integer(this.curPeriod.getPeriodNumber()));
        this.dateFrom.setValue((Object)this.curPeriod.getBeginDate());
        this.dateTo.setValue((Object)this.curPeriod.getEndDate());
        this.radByPeriod.setSelected(true);
        this.kDBizPromptBoxAccountFrom.setValue(null);
        this.kDBizPromptBoxAccountTo.setValue(null);
        this.cbxCurrency.setSelectedItem(ALL_CURRENCY);
        this.radCashAll.setSelected(true);
        this.radItemAll.setSelected(true);
        this.radByVoucher.setSelected(true);
        this.kDCheckBoxAllVoucher.setSelected(false);
    }

    public boolean isClear() {
        return this.isClear;
    }

    public void setClear(boolean isClear) {
        this.isClear = isClear;
    }

    private void setUIElementValue() {
        if (!this.param.periodOrDate) {
            this.radByDate.setSelected(true);
            java.util.Date dtFrom = this.param.getStartDate();
            java.util.Date dtTo = this.param.getEndDate();
            this.dateFrom.setValue((Object)dtFrom);
            this.dateTo.setValue((Object)dtTo);
        } else {
            this.radByPeriod.setSelected(true);
            this.spnYearFrom.setValue((Object)new Integer(this.param.getStartYear()));
            this.spnPeriodFrom.setValue((Object)new Integer(this.param.getStartPeriod()));
            this.spnYearTo.setValue((Object)new Integer(this.param.getEndYear()));
            this.spnPeriodTo.setValue((Object)new Integer(this.param.getEndPeriod()));
        }
        AccountViewInfo accountFrom = this.param.getAccountFrom();
        if (accountFrom != null) {
            this.kDBizPromptBoxAccountFrom.setValue((Object)accountFrom);
        } else {
            this.kDBizPromptBoxAccountFrom.setValue((Object)"");
        }
        AccountViewInfo accountTo = this.param.getAccountTo();
        if (accountTo != null) {
            this.kDBizPromptBoxAccountTo.setValue((Object)accountTo);
        } else {
            this.kDBizPromptBoxAccountTo.setValue((Object)"");
        }
        CurrencyInfo cur = this.param.getCurrency();
        if (cur != null) {
            GlUtils.setSelectedItem(this.cbxCurrency, (CoreBaseInfo)cur);
        } else {
            this.cbxCurrency.setSelectedItem(ALL_CURRENCY);
        }
        if (this.param.getHasCashAccount() == 0) {
            this.radHaveCash.setSelected(true);
        } else if (this.param.getHasCashAccount() == 1) {
            this.radHaveNotCash.setSelected(true);
        } else {
            this.radCashAll.setSelected(true);
        }
        if (this.param.getCashflowItemAssigned() == 0) {
            this.radHaveItem.setSelected(true);
        } else if (this.param.getCashflowItemAssigned() == 1) {
            this.radHaveNotItem.setSelected(true);
        } else {
            this.radItemAll.setSelected(true);
        }
        if (this.param.getByDetail() == 0) {
            this.radByVoucher.setSelected(true);
        } else if (this.param.getByDetail() == 1) {
            this.radByEntry.setSelected(true);
        } else if (this.param.getByDetail() == 2) {
            this.radByAssistRecord.setSelected(true);
        }
        if (this.param.isIncludeUnPosted()) {
            this.kDCheckBoxAllVoucher.setSelected(true);
        } else {
            this.kDCheckBoxAllVoucher.setSelected(false);
        }
    }

    public CompanyOrgUnitInfo getCurCompany() {
        return this.curCompany;
    }

    public void setCurCompany(CompanyOrgUnitInfo curCompany) {
        this.curCompany = curCompany;
    }

    public static class CashFlowFilterParam
    implements Serializable,
    IRptFilterObject {
        private static final long serialVersionUID = 7903599045159186927L;
        public static final int DETAIL_VOUCHER = 0;
        public static final int DETAIL_ENTRY = 1;
        public static final int DETAIL_RECORD = 2;
        public static final int INCLUDE_CASH_ACCOUNT = 0;
        public static final int EXCLUDE_CASH_ACCOUNT = 1;
        public static final int NOLIMIT_CASH_ACCOUNT = 2;
        public static final int ASSIGNED_CASHFLOWITEM = 0;
        public static final int UNASSIGNED_CASHFLOWITEM = 1;
        public static final int NOLIMIT_CASHFLOWITEM = 2;
        private int byDetail;
        private boolean includeUnPosted;
        private boolean periodOrDate = true;
        private int startYear;
        private int startPeriod;
        private int endYear;
        private int endPeriod;
        private java.util.Date startDate;
        private java.util.Date endDate;
        private AccountViewInfo accountFrom;
        private AccountViewInfo accountTo;
        private CurrencyInfo currency;
        private int hasCashAccount;
        private int cashflowItemAssigned;

        public int getByDetail() {
            return this.byDetail;
        }

        public void setByDetail(int bd) {
            this.byDetail = bd;
        }

        public boolean isIncludeUnPosted() {
            return this.includeUnPosted;
        }

        public void setIncludeUnPosted(boolean includeUnPosted) {
            this.includeUnPosted = includeUnPosted;
        }

        public boolean isPeriodOrDate() {
            return this.periodOrDate;
        }

        public void setPeriodOrDate(boolean periodOrDate) {
            this.periodOrDate = periodOrDate;
        }

        public int getStartYear() {
            return this.startYear;
        }

        public void setStartYear(int startYear) {
            this.startYear = startYear;
        }

        public int getStartPeriod() {
            return this.startPeriod;
        }

        public void setStartPeriod(int startPeriod) {
            this.startPeriod = startPeriod;
        }

        public int getEndYear() {
            return this.endYear;
        }

        public void setEndYear(int endYear) {
            this.endYear = endYear;
        }

        public int getEndPeriod() {
            return this.endPeriod;
        }

        public void setEndPeriod(int endPeriod) {
            this.endPeriod = endPeriod;
        }

        public java.util.Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(java.util.Date startDate) {
            this.startDate = startDate;
        }

        public java.util.Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(java.util.Date endDate) {
            this.endDate = endDate;
        }

        public AccountViewInfo getAccountFrom() {
            return this.accountFrom;
        }

        public void setAccountFrom(AccountViewInfo accountFrom) {
            this.accountFrom = accountFrom;
        }

        public AccountViewInfo getAccountTo() {
            return this.accountTo;
        }

        public void setAccountTo(AccountViewInfo accountTo) {
            this.accountTo = accountTo;
        }

        public CurrencyInfo getCurrency() {
            return this.currency;
        }

        public void setCurrency(CurrencyInfo currency) {
            this.currency = currency;
        }

        public int getHasCashAccount() {
            return this.hasCashAccount;
        }

        public void setHasCashAccount(int hasCashAccount) {
            this.hasCashAccount = hasCashAccount;
        }

        public int getCashflowItemAssigned() {
            return this.cashflowItemAssigned;
        }

        public void setCashflowItemAssigned(int cashflowItemAssigned) {
            this.cashflowItemAssigned = cashflowItemAssigned;
        }

        public IRptFilterObject toIRptFilerObject(RptFilterInfo rptFilterMap) {
            CashFlowFilterParam param = new CashFlowFilterParam();
            param.byDetail = rptFilterMap.getInt("byDetail");
            param.includeUnPosted = rptFilterMap.getBoolean("includeUnPosted");
            param.periodOrDate = rptFilterMap.getBoolean("periodOrDate");
            param.startYear = rptFilterMap.getInt("startYear");
            param.startPeriod = rptFilterMap.getInt("startPeriod");
            param.endYear = rptFilterMap.getInt("endYear");
            param.endPeriod = rptFilterMap.getInt("endPeriod");
            param.startDate = (java.util.Date)rptFilterMap.getObject("startDate");
            param.endDate = (java.util.Date)rptFilterMap.getObject("endDate");
            param.accountFrom = (AccountViewInfo)rptFilterMap.getObject("accountFrom");
            param.accountTo = (AccountViewInfo)rptFilterMap.getObject("accountTo");
            param.currency = (CurrencyInfo)rptFilterMap.getObject("currency");
            param.hasCashAccount = rptFilterMap.getInt("hasCashAccount");
            param.cashflowItemAssigned = rptFilterMap.getInt("cashflowItemAssigned");
            return param;
        }

        public RptFilterInfo toRptFilterInfo() {
            RptFilterInfo rptInfo = new RptFilterInfo();
            rptInfo.setRptFilterObjectClassName(this.getClass().getName());
            rptInfo.setInt("byDetail", this.byDetail);
            rptInfo.setBoolean("includeUnPosted", this.includeUnPosted);
            rptInfo.setBoolean("periodOrDate", this.periodOrDate);
            rptInfo.setInt("startYear", this.startYear);
            rptInfo.setInt("startPeriod", this.startPeriod);
            rptInfo.setInt("endYear", this.endYear);
            rptInfo.setInt("endPeriod", this.endPeriod);
            rptInfo.setObject("startDate", (Object)this.startDate);
            rptInfo.setObject("endDate", (Object)this.endDate);
            rptInfo.setObject("accountFrom", (Object)this.accountFrom);
            rptInfo.setObject("accountTo", (Object)this.accountTo);
            rptInfo.setObject("currency", (Object)this.currency);
            rptInfo.setInt("hasCashAccount", this.hasCashAccount);
            rptInfo.setInt("cashflowItemAssigned", this.cashflowItemAssigned);
            return rptInfo;
        }
    }
}

