/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowException;
import com.kingdee.eas.fi.gl.CashFlowFilterPara;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.RptCommonFactory;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowFilterUI;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.fi.gl.client.CompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceFacadeFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CashFlowFilterUI
extends AbstractCashFlowFilterUI {
    private static final long serialVersionUID = -8923166186188620L;
    private static final Logger logger = CoreUIObject.getLogger(CashFlowFilterUI.class);
    private CashFlowFilterPara cashFlowFilterPara = new CashFlowFilterPara();
    private Boolean foreign = Boolean.FALSE;
    private Boolean useReport = Boolean.TRUE;
    private CompanyOrgUnitInfo currCompany;
    private PeriodEntity pe;
    boolean companyFilterChanged = false;
    private TreeModel treeModelOfCompany;
    private TreeModel treeModelOfCompanyClone;
    private CurrencyInfo defaultSelected;
    private PeriodInfo currentPeriodInfo;
    private CompanyOrgUnitInfo[] companyInfos;
    CompanyTreeSelectUI ctsUI;
    JDialog dialog;

    public CashFlowFilterUI(Map initData) throws Exception {
        this.initUIData(initData);
        this.addListener();
        KeyStroke simpleKey = KeyStroke.getKeyStroke(83, 3);
        InputMap imEntry = this.getInputMap(2);
        imEntry.put(simpleKey, "showSimpleUI");
        ActionMap simpleEntryActionMap = this.getActionMap();
        simpleEntryActionMap.put("showSimpleUI", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CashFlowFilterUI.this.showSimpleUI(e);
            }
        });
    }

    protected void showSimpleUI(ActionEvent e) {
        try {
            String nRptUI = "com.kingdee.eas.fi.gl.rpt.client.GLNRptCashflowTableUI";
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(nRptUI, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            Util.getWindow((Component)((Object)this)).dispose();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
        this.initAccountTableComboBox();
        this.initPeriodTypeComboBox();
        this.initCurrencyComboBox();
        this.setDefaultData();
    }

    @Override
    protected void kDRadioButtonTerm_stateChanged(ChangeEvent e) throws Exception {
        this.kDPanelTerm.setVisible(true);
        this.kDPanelDate.setVisible(false);
    }

    @Override
    protected void kDRadioButtonDate_stateChanged(ChangeEvent e) throws Exception {
        this.kDPanelTerm.setVisible(false);
        this.kDPanelDate.setVisible(true);
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
        }
        catch (Exception e) {
            return;
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public boolean verify() {
        if (this.comboxPeriodType.getSelectedItem() == null) {
            this.comboxPeriodType.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_periodType_table_please"));
            return false;
        }
        if (this.kDRadioButtonDate.isSelected()) {
            java.sql.Date from = this.kDDatePickerFrom.getSqlDate();
            java.sql.Date to = this.kDDatePickerTo.getSqlDate();
            if (to.before(from)) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("InputDateStart"));
                this.kDDatePickerFrom.requestFocus();
                return false;
            }
            if (!this.verifySelectedDateRange(from, to)) {
                return false;
            }
        }
        if (this.getCompanys() == null) {
            this.prmtCompany.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_range"));
            return false;
        }
        if (this.currCompany.isIsBizUnit()) {
            int numberBegin;
            int yearBegin;
            int yearEnd = (Integer)this.kDSpinnerToYear.getValue();
            if (RptClientUtil.isBetweenAdjPeriod((Component)((Object)this), yearEnd, yearBegin = ((Integer)this.kDSpinnerFromYear.getValue()).intValue(), numberBegin = ((Integer)this.kDSpinnerFromMonth.getValue()).intValue())) {
                return false;
            }
        } else {
            if (this.comboxAccountTable.getSelectedItem() == null) {
                this.comboxAccountTable.requestFocus();
                MsgBox.showInfo((Component)this.comboxAccountTable, (String)GLResUtil.getRes("select_accountView_table_please"));
                return false;
            }
            if (this.judgeCompanyTreeIsSame(this.getCompanys(), this.getCompanysByCompanyTree((DefaultMutableTreeNode)this.cashFlowFilterPara.getCompanyTreeNode()))) {
                this.treeModelOfCompany = this.treeModelOfCompanyClone = new DefaultTreeModel((TreeNode)this.cashFlowFilterPara.getCompanyTreeNode());
            }
            try {
                CompanyTreeSelectUI ctui = ((CompanyTreePromptBox)this.prmtCompany.getSelector()).getCompanyUI();
                if (this.treeModelOfCompanyClone == null && !this.currCompany.isIsBizUnit() && ctui != null) {
                    this.treeModelOfCompanyClone = ctui.getBizUnitTreeModel();
                } else if ((this.treeModelOfCompanyClone == null || this.currCompany.isIsBizUnit()) && this.cashFlowFilterPara.getCompanyTreeNode() != null) {
                    this.treeModelOfCompanyClone = new DefaultTreeModel((TreeNode)this.cashFlowFilterPara.getCompanyTreeNode());
                }
                this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError();
            }
            catch (Exception e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
            try {
                if (!this.hasPhysicalCompany(this.treeModelOfCompany)) {
                    MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("cannot_query_without_entity_company"));
                    return false;
                }
                int numberEnd = 0;
                int yearEnd = 0;
                if (this.kDRadioButtonDate.isSelected()) {
                    yearEnd = this.pe.getUsedPeriod().getMaxYear();
                    numberEnd = this.pe.getUsedPeriod().getMaxPeriod(yearEnd);
                } else {
                    numberEnd = (Integer)this.kDSpinnerToMonth.getValue();
                    yearEnd = (Integer)this.kDSpinnerToYear.getValue();
                }
                RptClientUtil.companyBWPeriod(yearEnd, numberEnd, this.treeModelOfCompany);
            }
            catch (BOSException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                return false;
            }
            catch (Exception e) {
                try {
                    this.treeModelOfCompany = (TreeModel)ObjectUtils.createCopy((Object)this.treeModelOfCompanyClone);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                return false;
            }
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.setDefaultData();
    }

    private void addListener() {
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                try {
                    if (CashFlowFilterUI.this.isCompanyChanged(event)) {
                        if (!CashFlowFilterUI.this.currCompany.isIsBizUnit() && CashFlowFilterUI.this.prmtCompany.getSelector() != null) {
                            CompanyTreeSelectUI ctui = ((CompanyTreePromptBox)CashFlowFilterUI.this.prmtCompany.getSelector()).getCompanyUI();
                            if (!CashFlowFilterUI.this.currCompany.isIsBizUnit() && ctui != null) {
                                CashFlowFilterUI.this.treeModelOfCompanyClone = ctui.getData();
                            } else if (CashFlowFilterUI.this.cashFlowFilterPara.getCompanyTreeNode() != null) {
                                CashFlowFilterUI.this.treeModelOfCompanyClone = new DefaultTreeModel((TreeNode)CashFlowFilterUI.this.cashFlowFilterPara.getCompanyTreeNode());
                            }
                            if (CashFlowFilterUI.this.treeModelOfCompanyClone == null && ctui == null) {
                                ((CompanyTreePromptBox)CashFlowFilterUI.this.prmtCompany.getSelector()).show(true);
                                ctui = ((CompanyTreePromptBox)CashFlowFilterUI.this.prmtCompany.getSelector()).getCompanyUI();
                                CashFlowFilterUI.this.treeModelOfCompanyClone = ctui.getData();
                            }
                        }
                        CashFlowFilterUI.this.companyChanged(CashFlowFilterUI.this.treeModelOfCompanyClone);
                    }
                }
                catch (Exception e) {
                    CashFlowFilterUI.this.handUIException(e);
                }
            }
        });
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CashFlowFilterUI.this.fireFiltersChanged(e.getSource());
            }
        };
        this.comboxAccountTable.addActionListener(al);
        this.comboxPeriodType.addActionListener(al);
    }

    protected void companyChanged(Object object) {
        block13: {
            this.reInitCurrcencyCombox();
            this.setOtherComponent();
            if (this.isUnionQuery()) {
                if (null == object) {
                    return;
                }
                Object objectnew = null;
                try {
                    objectnew = ObjectUtils.createCopy((Object)object);
                }
                catch (CloneNotSupportedException cnse) {
                    throw new InternalError();
                }
                this.treeModelOfCompany = (TreeModel)object;
                this.treeModelOfCompanyClone = (TreeModel)objectnew;
                try {
                    int maxCompanyLevel;
                    PeriodTypeInfo peridType = (PeriodTypeInfo)this.comboxPeriodType.getSelectedItem();
                    Set companyIdSet = this.getCompanyIdSet();
                    boolean isPeriodEnable = peridType != null && !companyIdSet.isEmpty();
                    this.kDSpinnerFromYear.setEnabled(isPeriodEnable);
                    this.kDSpinnerFromMonth.setEnabled(isPeriodEnable);
                    this.kDSpinnerToYear.setEnabled(isPeriodEnable);
                    this.kDSpinnerToMonth.setEnabled(isPeriodEnable);
                    if (isPeriodEnable) {
                        try {
                            Map pdRang = GLRptAccountBalanceFacadeFactory.getRemoteInstance().getPeriodRange(companyIdSet, peridType.getId().toString());
                            PeriodEntity pe = new PeriodEntity(pdRang);
                            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.kDSpinnerFromYear, (KDSpinner)this.kDSpinnerFromMonth, (KDSpinner)this.kDSpinnerToYear, (KDSpinner)this.kDSpinnerToMonth, (boolean)false, (boolean)false);
                            this.cashFlowFilterPara.setPeriodRange(pe);
                        }
                        catch (Exception e) {
                            this.kDSpinnerFromYear.setEnabled(false);
                            this.kDSpinnerFromMonth.setEnabled(false);
                            this.kDSpinnerToYear.setEnabled(false);
                            this.kDSpinnerToMonth.setEnabled(false);
                            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                        }
                    }
                    if ((maxCompanyLevel = RptClientUtil.getMaxCompanyLevel(this.treeModelOfCompany)) > 0) {
                        this.spnCompanyLevel.setEnabled(true);
                        SpinnerNumberModel companyLevelModel = new SpinnerNumberModel(1, 1, ++maxCompanyLevel, 1);
                        this.spnCompanyLevel.setModel((SpinnerModel)companyLevelModel);
                        break block13;
                    }
                    this.spnCompanyLevel.setEnabled(false);
                }
                catch (Exception e) {
                    MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                    this.treeModelOfCompany = null;
                    this.treeModelOfCompanyClone = null;
                }
            } else {
                try {
                    CompanyOrgUnitInfo company = this.getCompanys()[0];
                    company.setAccountTable((AccountTableInfo)this.comboxAccountTable.getSelectedItem());
                    company.setAccountPeriodType((PeriodTypeInfo)this.comboxPeriodType.getSelectedItem());
                    this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)company);
                    SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.kDSpinnerFromYear, (KDSpinner)this.kDSpinnerFromMonth, (KDSpinner)this.kDSpinnerToYear, (KDSpinner)this.kDSpinnerToMonth, (boolean)false, (boolean)false);
                }
                catch (Exception e) {
                    MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
                }
            }
        }
    }

    private void setOtherComponent() {
        CompanyOrgUnitInfo[] companys = this.getCompanyInfos();
        if (companys == null) {
            if (this.cashFlowFilterPara.getCurrency() != null) {
                this.setSelectedItem(this.kDComboBoxCurrency, (DataBaseInfo)this.cashFlowFilterPara.getCurrency());
            } else if (this.defaultSelected != null) {
                this.setSelectedItem(this.kDComboBoxCurrency, (DataBaseInfo)this.defaultSelected);
            }
            if (this.cashFlowFilterPara.getAccountTabel() != null) {
                this.setSelectedItem(this.comboxAccountTable, (DataBaseInfo)this.cashFlowFilterPara.getAccountTabel());
            } else {
                this.comboxAccountTable.setSelectedIndex(0);
            }
            if (this.cashFlowFilterPara.getPeriodType() != null) {
                this.setSelectedItem(this.comboxPeriodType, (DataBaseInfo)this.cashFlowFilterPara.getPeriodType());
            } else {
                this.comboxPeriodType.setSelectedIndex(0);
            }
            return;
        }
        AccountTableInfo accountTable = companys[0].getAccountTable();
        if (accountTable == null) {
            this.comboxAccountTable.setSelectedIndex(0);
        } else {
            this.setSelectedItem(this.comboxAccountTable, (DataBaseInfo)accountTable);
        }
        PeriodTypeInfo periodTypeInfo = companys[0].getAccountPeriodType();
        if (periodTypeInfo == null) {
            this.comboxPeriodType.setSelectedIndex(0);
        } else {
            this.setSelectedItem(this.comboxPeriodType, (DataBaseInfo)periodTypeInfo);
        }
        CurrencyInfo currencyInfo = companys[0].getBaseCurrency();
        if (currencyInfo == null) {
            this.kDComboBoxCurrency.setSelectedIndex(0);
        } else {
            this.setSelectedItem(this.kDComboBoxCurrency, (DataBaseInfo)currencyInfo);
        }
    }

    private void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.prmtCompany.setValue((Object)companys);
    }

    public Object getParam() {
        this.syschronizeParam();
        return this.getCashFlowFilterPara();
    }

    private CurrencyCollection getAllCurrency() throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        return iCurrency.getCurrencyCollection(evi);
    }

    public void setParam(Object p) {
        this.cashFlowFilterPara = (CashFlowFilterPara)p;
        boolean isVirtual = GlUtils.isCompanyUnion(this.getCurrentCompany());
        if (isVirtual) {
            int maxCompanyLevel;
            this.treeModelOfCompany = new DefaultTreeModel((TreeNode)this.cashFlowFilterPara.getCompanyTreeNode());
            this.prmtCompany.setValue((Object)this.getCompanysByCompanyTree());
            if (this.cashFlowFilterPara.getExpandCompanyLevel() < 1) {
                this.cashFlowFilterPara.setExpandCompanyLevel(1);
            }
            if ((maxCompanyLevel = RptClientUtil.getMaxCompanyLevel(this.treeModelOfCompany)) > 0) {
                this.spnCompanyLevel.setEnabled(true);
                SpinnerNumberModel companyLevelModel = new SpinnerNumberModel(1, 1, ++maxCompanyLevel, 1);
                this.spnCompanyLevel.setModel((SpinnerModel)companyLevelModel);
            } else {
                this.spnCompanyLevel.setEnabled(false);
            }
        } else {
            try {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.cashFlowFilterPara.getCompanyIds()));
                this.prmtCompany.setValue((Object)company);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.cashFlowFilterPara.setExpandCompanyLevel(1);
        }
        this.setSelectedItem(this.comboxAccountTable, (DataBaseInfo)this.cashFlowFilterPara.getAccountTabel());
        this.setSelectedItem(this.comboxPeriodType, (DataBaseInfo)this.cashFlowFilterPara.getPeriodType());
        if (this.cashFlowFilterPara.isTermOrDate()) {
            this.kDRadioButtonTerm.setSelected(true);
            int fromNumber = this.cashFlowFilterPara.getYearFrom() * 100 + this.cashFlowFilterPara.getMonthFrom();
            int toNumber = this.cashFlowFilterPara.getYearTo() * 100 + this.cashFlowFilterPara.getMonthTo();
            PeriodEntity queryPeriod = null;
            queryPeriod = isVirtual ? this.cashFlowFilterPara.getPeriodRange() : this.pe.getQueryPeriod();
            int minYear = queryPeriod.getMinYear();
            int minYearPeriod = queryPeriod.getMinPeriod(minYear);
            int maxYear = queryPeriod.getMaxYear();
            int maxYearPeriod = queryPeriod.getMaxPeriod(maxYear);
            if (fromNumber > maxYear * 100 + maxYearPeriod) {
                this.cashFlowFilterPara.setYearFrom((short)maxYear);
                this.cashFlowFilterPara.setMonthFrom((short)maxYearPeriod);
            } else if (fromNumber < minYear * 100 + minYearPeriod) {
                this.cashFlowFilterPara.setYearFrom((short)minYear);
                this.cashFlowFilterPara.setMonthFrom((short)minYearPeriod);
            }
            if (toNumber > maxYear * 100 + maxYearPeriod) {
                this.cashFlowFilterPara.setYearTo((short)maxYear);
                this.cashFlowFilterPara.setMonthTo((short)maxYearPeriod);
            } else if (toNumber < minYear * 100 + minYearPeriod) {
                this.cashFlowFilterPara.setYearTo((short)minYear);
                this.cashFlowFilterPara.setMonthTo((short)minYearPeriod);
            }
            this.kDSpinnerFromYear.setValue((Object)new Integer(this.cashFlowFilterPara.getYearFrom()));
            this.kDSpinnerFromMonth.setValue((Object)new Integer(this.cashFlowFilterPara.getMonthFrom()));
            this.kDSpinnerToYear.setValue((Object)new Integer(this.cashFlowFilterPara.getYearTo()));
            this.kDSpinnerToMonth.setValue((Object)new Integer(this.cashFlowFilterPara.getMonthTo()));
        } else {
            this.kDRadioButtonDate.setSelected(true);
            this.kDDatePickerFrom.setValue((Object)this.cashFlowFilterPara.getDateFrom());
            this.kDDatePickerTo.setValue((Object)this.cashFlowFilterPara.getDateTo());
        }
        int itemCount = this.kDComboBoxCurrency.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.kDComboBoxCurrency.getItemAt(i);
            if (!currencyInfo.getId().toString().equalsIgnoreCase(this.cashFlowFilterPara.getCurrencyId())) continue;
            this.kDComboBoxCurrency.setSelectedIndex(i);
            break;
        }
        this.showAllCashFlowItem.setSelected(this.cashFlowFilterPara.isShowAllCashFlowItem());
        this.kDSpinnerLevel.setValue((Object)new Integer(this.cashFlowFilterPara.getLevel()));
        this.kDCheckBoxVoucher.setSelected(this.cashFlowFilterPara.isAllVoucher());
        this.kDCheckBoxExchangeItem.setSelected(this.cashFlowFilterPara.isDisplayExchangeSubsidiary());
        this.kDCheckBoxCashBalance.setSelected(this.cashFlowFilterPara.isDisplayCashBalanceForBeginAndEnd());
        this.kDCheckBoxAsst.setSelected(this.cashFlowFilterPara.isDisplayAsst());
        this.spnCompanyLevel.setValue((Object)new Integer(this.cashFlowFilterPara.getExpandCompanyLevel()));
    }

    public void syschronizeParam() {
        this.cashFlowFilterPara.setAccountTabel((AccountTableInfo)this.comboxAccountTable.getSelectedItem());
        this.cashFlowFilterPara.setPeriodType((PeriodTypeInfo)this.comboxPeriodType.getSelectedItem());
        if (!this.getCurrentCompany().isIsBizUnit()) {
            if (this.treeModelOfCompany != null) {
                this.cashFlowFilterPara.setCompanyIds(this.getCompanyIDStr(this.getCompanysByCompanyTree()));
                this.cashFlowFilterPara.setCompanyTreeNode(this.treeModelOfCompany.getRoot());
            } else {
                this.cashFlowFilterPara.setCompanyIds(this.getCompanyIDStr(this.getCompanys()));
                CompanyTreeSelectUI ctui = ((CompanyTreePromptBox)this.prmtCompany.getSelector()).getCompanyUI();
                if (ctui != null) {
                    this.cashFlowFilterPara.setCompanyTreeNode(ctui.getData().getRoot());
                } else {
                    this.cashFlowFilterPara.setCompanyTreeNode(this.treeModelOfCompany.getRoot());
                }
            }
        } else {
            this.cashFlowFilterPara.setCompanyIds(((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
        }
        this.cashFlowFilterPara.setTermOrDate(this.kDRadioButtonTerm.isSelected());
        if (this.kDRadioButtonTerm.isSelected()) {
            this.cashFlowFilterPara.setYearFrom(((Integer)this.kDSpinnerFromYear.getValue()).shortValue());
            this.cashFlowFilterPara.setMonthFrom(((Integer)this.kDSpinnerFromMonth.getValue()).shortValue());
            this.cashFlowFilterPara.setYearTo(((Integer)this.kDSpinnerToYear.getValue()).shortValue());
            this.cashFlowFilterPara.setMonthTo(((Integer)this.kDSpinnerToMonth.getValue()).shortValue());
        } else {
            this.cashFlowFilterPara.setDateFrom(this.kDDatePickerFrom.getTimestamp());
            this.cashFlowFilterPara.setDateTo(this.kDDatePickerTo.getTimestamp());
        }
        Object objectCurrency = this.kDComboBoxCurrency.getSelectedItem();
        if (objectCurrency instanceof CurrencyInfo) {
            CurrencyInfo currency = (CurrencyInfo)objectCurrency;
            this.cashFlowFilterPara.setCurrency(currency);
            this.cashFlowFilterPara.setCurrencyId(currency.getId().toString());
        }
        this.cashFlowFilterPara.setLevel(((Integer)this.kDSpinnerLevel.getValue()).shortValue());
        this.cashFlowFilterPara.setAllVoucher(this.kDCheckBoxVoucher.isSelected());
        this.cashFlowFilterPara.setDisplayExchangeSubsidiary(this.kDCheckBoxExchangeItem.isSelected());
        this.cashFlowFilterPara.setDisplayCashBalanceForBeginAndEnd(this.kDCheckBoxCashBalance.isSelected());
        this.cashFlowFilterPara.setDisplayAsst(this.kDCheckBoxAsst.isSelected());
        this.cashFlowFilterPara.setExpandCompanyLevel(this.spnCompanyLevel.getIntegerVlaue());
        this.cashFlowFilterPara.setShowAllCashFlowItem(this.showAllCashFlowItem.isSelected());
        if (this.currCompany.isIsBizUnit()) {
            this.cashFlowFilterPara.setSelectedCompanyId(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString());
        }
    }

    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void setDefaultData() {
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        if (company.isIsBizUnit()) {
            this.prmtCompany.setData((Object)company);
            Integer defaultYear = new Integer(this.currentPeriodInfo.getPeriodYear());
            Integer defaultNumber = new Integer(this.currentPeriodInfo.getPeriodNumber());
            this.setSelectedItem(this.comboxAccountTable, (DataBaseInfo)company.getAccountTable());
            this.setSelectedItem(this.comboxPeriodType, (DataBaseInfo)company.getAccountPeriodType());
            this.setSelectedItem(this.kDComboBoxCurrency, (DataBaseInfo)this.defaultSelected);
            this.kDSpinnerFromYear.setValue((Object)defaultYear);
            this.kDSpinnerFromMonth.setValue((Object)defaultNumber);
            this.kDSpinnerToYear.setValue((Object)defaultYear);
            this.kDSpinnerToMonth.setValue((Object)defaultNumber);
        } else {
            this.prmtCompany.setData(null);
            this.setSelectedItem(this.comboxAccountTable, (DataBaseInfo)company.getAccountTable());
            this.setSelectedItem(this.comboxPeriodType, (DataBaseInfo)company.getAccountPeriodType());
            this.setSelectedItem(this.kDComboBoxCurrency, (DataBaseInfo)this.defaultSelected);
            this.kDSpinnerFromYear.setEnabled(false);
            this.kDSpinnerFromMonth.setEnabled(false);
            this.kDSpinnerToYear.setEnabled(false);
            this.kDSpinnerToMonth.setEnabled(false);
        }
        this.kDCheckBoxVoucher.setSelected(false);
        this.kDCheckBoxAsst.setSelected(false);
        this.kDCheckBoxExchangeItem.setSelected(false);
        this.kDCheckBoxCashBalance.setSelected(true);
        this.showAllCashFlowItem.setSelected(false);
        this.kDSpinnerLevel.setValue(((SpinnerNumberModel)this.kDSpinnerLevel.getModel()).getMaximum());
        this.kDRadioButtonTerm.setSelected(true);
        this.spnCompanyLevel.setValue((Object)new Integer(1));
        this.spnCompanyLevel.setEnabled(false);
    }

    private void initUIData(Map initData) throws BOSException, EASBizException {
        try {
            this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCurrentCompany());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (GlUtils.isCompanyUnion(this.getCurrentCompany())) {
            PeriodInfo pi = (PeriodInfo)initData.get("CurrentPeriod");
            HashMap<String, Object> allMap = new HashMap<String, Object>();
            if (pi == null) {
                Date a = new Date();
                int year = a.getYear() + 1900;
                int[] periodRange = new int[]{a.getMonth() + 1, a.getMonth() + 1};
                HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
                map.put(new Integer(year), periodRange);
                allMap.put("usedPeriod", map);
                allMap.put("queryPeriod", map);
                allMap.put("currentPeriod", new int[]{year, a.getMonth() + 1});
            } else {
                int year = pi.getPeriodYear();
                int[] periodRange = new int[]{pi.getPeriodNumber(), pi.getPeriodNumber()};
                HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
                map.put(new Integer(year), periodRange);
                allMap.put("usedPeriod", map);
                allMap.put("queryPeriod", map);
                allMap.put("currentPeriod", new int[]{year, pi.getPeriodNumber()});
            }
            PeriodEntity pe = new PeriodEntity(allMap);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.kDSpinnerFromYear, (KDSpinner)this.kDSpinnerFromMonth, (KDSpinner)this.kDSpinnerToYear, (KDSpinner)this.kDSpinnerToMonth, (boolean)false, (boolean)false);
        } else {
            try {
                this.pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.getCurrentCompany());
                SpinnerUtil.managePeriodRange((PeriodEntity)this.pe, (KDSpinner)this.kDSpinnerFromYear, (KDSpinner)this.kDSpinnerFromMonth, (KDSpinner)this.kDSpinnerToYear, (KDSpinner)this.kDSpinnerToMonth, (boolean)false, (boolean)false);
            }
            catch (Exception e) {
                throw new ReportException(ReportException.PERIOD_ERROR, e);
            }
        }
        if (GlUtils.isCompanyUnion(this.getCurrentCompany())) {
            this.prmtCompany.setEnabled(true);
            this.comboxAccountTable.setEnabled(true);
            this.comboxPeriodType.setEnabled(true);
        } else {
            this.prmtCompany.setEnabled(true);
            this.comboxAccountTable.setEnabled(true);
            this.comboxPeriodType.setEnabled(false);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("destCompany.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        evi.setFilter(filterInfo);
        this.kDDatePickerTo.setSupportedEmpty(false);
        this.kDDatePickerFrom.setSupportedEmpty(false);
        this.foreign = (Boolean)initData.get("foreign");
        this.useReport = (Boolean)initData.get("useReport");
        CurrencyCollection currencyCollection = this.getAllCurrency();
        int index = -1;
        CurrencyInfo local = null;
        CurrencyInfo report = null;
        if (currencyCollection != null && currencyCollection.size() > 0) {
            Iterator iterator = currencyCollection.iterator();
            while (iterator.hasNext()) {
                ++index;
                CurrencyInfo currency = (CurrencyInfo)iterator.next();
                if (currency.isGeneralLocalCurrency()) {
                    local = currency;
                    continue;
                }
                if (currency.isGeneralReportCurrency()) {
                    report = currency;
                    continue;
                }
                this.kDComboBoxCurrency.addItem((Object)currency);
                if (!currency.getId().equals((Object)this.getCurrentCompany().getBaseCurrency().getId())) continue;
                this.defaultSelected = currency;
            }
            if (!this.foreign.booleanValue() && local != null) {
                this.kDComboBoxCurrency.addItem((Object)local);
            }
            if (!this.foreign.booleanValue() && this.useReport.booleanValue() && report != null) {
                this.kDComboBoxCurrency.addItem((Object)report);
            }
            if (this.defaultSelected == null) {
                this.defaultSelected = currencyCollection.get(0);
            }
        }
        CashFlowItemCollection col = null;
        try {
            col = CashFlowItemFactory.getRemoteInstance().getCashFlowItemCollection("select level order by level desc");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (col == null || col.size() == 0) {
            this.handUIException((Throwable)((Object)new CashFlowException(CashFlowException.CASHFLOWITEM_IS_EMPTY)));
        } else {
            SpinnerNumberModel levelModel = new SpinnerNumberModel(new Integer(col.get(0).getLevel()), new Integer(1), new Integer(col.get(0).getLevel()), new Integer(1));
            this.kDSpinnerLevel.setModel((SpinnerModel)levelModel);
        }
        this.spnCompanyLevel.setEnabled(false);
    }

    public CashFlowFilterPara getCashFlowFilterPara() {
        return this.cashFlowFilterPara;
    }

    public String getResource(String resKey) {
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)resKey);
        return res;
    }

    private void fireFiltersChanged(Object source) {
        if (this.getCurrentCompany() == null || !GlUtils.isCompanyUnion(this.getCurrentCompany())) {
            return;
        }
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.comboxPeriodType.getSelectedItem();
        this.kDSpinnerFromYear.setEnabled(periodType != null);
        this.kDSpinnerToYear.setEnabled(periodType != null);
        this.kDSpinnerFromMonth.setEnabled(periodType != null);
        this.kDSpinnerToMonth.setEnabled(periodType != null);
    }

    private CompanyOrgUnitInfo getCurrentCompany() {
        if (this.currCompany == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("reportCurrency.id"));
            sic.add(new SelectorItemInfo("reportCurrency.number"));
            sic.add(new SelectorItemInfo("reportCurrency.name"));
            sic.add(new SelectorItemInfo("reportCurrency.precision"));
            sic.add(new SelectorItemInfo("accountPeriodType.id"));
            sic.add(new SelectorItemInfo("accountPeriodType.number"));
            sic.add(new SelectorItemInfo("accountPeriodType.name"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            BOSUuid companyID = SysContext.getSysContext().getCurrentFIUnit().getId();
            try {
                this.currCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.currCompany;
    }

    public boolean hasPhysicalCompany(TreeModel model) throws BOSException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        if (node.getChildCount() <= 0) {
            return false;
        }
        StringBuffer result = new StringBuffer("(");
        Enumeration<TreeNode> enumer = node.depthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            node = (DefaultMutableTreeNode)enumer.nextElement();
            if (!node.isLeaf()) continue;
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            result.append("'").append(userObject.getCompanyId()).append("',");
        }
        result.replace(result.length() - 1, result.length(), ")");
        Boolean bb = (Boolean)RptCommonFactory.getRemoteInstance().invoke("hasPhysicalCompany", result.toString());
        return bb;
    }

    private boolean verifySelectedDateRange(Date from, Date to) {
        if (this.pe == null) {
            try {
                PeriodTypeInfo peridType = (PeriodTypeInfo)this.comboxPeriodType.getSelectedItem();
                Map pdRang = GLRptAccountBalanceFacadeFactory.getRemoteInstance().getPeriodRange(this.getCompanyIdSet(), peridType.getId().toString());
                this.pe = new PeriodEntity(pdRang);
            }
            catch (Exception peridType) {
                // empty catch block
            }
        }
        if (this.pe == null || this.pe.getUsedPeriod() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("unavailablePeriod"));
            return false;
        }
        int maxYear = this.pe.getUsedPeriod().getMaxYear();
        int maxPeriod = this.pe.getUsedPeriod().getMaxPeriod(maxYear);
        int minYear = this.pe.getUsedPeriod().getMinYear();
        int minPeriod = this.pe.getUsedPeriod().getMinPeriod(minYear);
        try {
            PeriodTypeInfo periodType = (PeriodTypeInfo)this.comboxPeriodType.getSelectedItem();
            PeriodInfo maxPeriodInfo = this.getPeriod(maxYear, maxPeriod, periodType.getId().toString());
            PeriodInfo minPeriodInfo = this.getPeriod(minYear, minPeriod, periodType.getId().toString());
            if (maxPeriodInfo == null || minPeriodInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("unavailablePeriod"));
                return false;
            }
            if (from.before(minPeriodInfo.getBeginDate())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("notLessThanStartPeriod"));
                this.kDDatePickerFrom.requestFocus();
                return false;
            }
            return true;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return false;
        }
    }

    private PeriodInfo getPeriod(int periodYear, int periodNumber, String periodTypeId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        PeriodInfo info = null;
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    private void initCompanyF7() {
        this.prmtCompany.setEnabledMultiSelection(this.isUnionQuery());
        this.prmtCompany.setEditable(true);
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(companyView);
        this.prmtCompany.setSelector(this.getCompanySelector());
        if (!this.currCompany.isIsBizUnit()) {
            this.prmtCompany.setHistoryRecordEnabled(false);
        }
    }

    protected KDPromptSelector getCompanySelector() {
        if (this.isUnionQuery()) {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            CompanyOrgUnitInfo root = this.isUnionQuery() ? company : null;
            return new CompanyTreePromptBox((CoreUIObject)this, root, this.prmtCompany, null, false);
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        return companySelector;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    private String getCompanyIdFilter() {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer companyIdStr = new StringBuffer();
        CompanyOrgUnitInfo root = null;
        if (this.isUnionQuery()) {
            root = SysContext.getSysContext().getCurrentFIUnit();
        }
        companyIdStr.append("select cp.fid ").append(GlUtils.getCompanyFilterSQL(userId, null, false, root, null, true, null, false));
        return companyIdStr.toString();
    }

    protected boolean isUnionQuery() {
        return !this.getCurrentCompany().isIsBizUnit();
    }

    protected void initAccountTableComboBox() throws Exception {
        AccountTableCollection accountTables = this.getAccountTableCollection();
        this.comboxAccountTable.setModel(new DefaultComboBoxModel(this.toVector((AbstractObjectCollection)accountTables)));
    }

    private Vector toVector(AbstractObjectCollection coll) {
        if (coll == null) {
            return null;
        }
        Vector v = new Vector();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    private AccountTableCollection getAccountTableCollection() throws ReportBizException, BOSException {
        CompanyOrgUnitInfo company = this.getCurrentCompany();
        if (!company.isIsBizUnit()) {
            return AccountTools.getAllAccountTableByCompany(null, (CompanyOrgUnitInfo)company);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
    }

    protected void initPeriodTypeComboBox() throws Exception {
        PeriodTypeCollection periodTyes = this.getPeriodTypeCollection();
        this.comboxPeriodType.setModel(new DefaultComboBoxModel(this.toVector((AbstractObjectCollection)periodTyes)));
    }

    private PeriodTypeCollection getPeriodTypeCollection() throws ReportBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection(view);
    }

    protected void initCurrencyComboBox() throws Exception {
        CurrencyCollection currencys = this.getAllCurrencyCollection();
        this.kDComboBoxCurrency.setModel(new DefaultComboBoxModel(this.toVector((AbstractObjectCollection)currencys)));
    }

    private CurrencyCollection getAllCurrencyCollection() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
        return currencyCollection;
    }

    protected void setSelectedItem(KDComboBox comboBox, DataBaseInfo dbInfo) {
        if (dbInfo == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            DataBaseInfo info;
            Object object = comboBox.getItemAt(i);
            if (!(object instanceof DataBaseInfo) || (info = (DataBaseInfo)object) == null || !dbInfo.getId().equals((Object)info.getId())) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    private String getCompanyIDStr(CompanyOrgUnitInfo[] companys) {
        StringBuffer companyIds = new StringBuffer();
        int size = companys.length;
        for (int i = 0; i < size; ++i) {
            companyIds.append("'").append(companys[i].getId().toString()).append("',");
        }
        return companyIds.substring(0, companyIds.length() - 1);
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.prmtCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (company instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])company;
        }
        if (company instanceof Object[]) {
            Object[] companyObjs = (Object[])company;
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    private AccountTableInfo getSameAccountTableInfo() {
        CompanyOrgUnitInfo[] companys = null;
        if (this.companyInfos != null) {
            companys = this.companyInfos;
        } else {
            this.companyInfos = companys = this.getCompanyInfos();
        }
        if (companys == null) {
            return null;
        }
        AccountTableInfo accountTable = companys[0].getAccountTable();
        if (accountTable == null) {
            return null;
        }
        for (int i = 1; i < companys.length; ++i) {
            if (companys[i].getAccountTable() == null) {
                return null;
            }
            if (companys[i].getAccountTable().getId().equals((Object)accountTable.getId())) continue;
            return null;
        }
        return accountTable;
    }

    private CurrencyInfo getSameBaseCurrencyInfo() {
        CompanyOrgUnitInfo[] companys = null;
        if (this.companyInfos != null) {
            companys = this.companyInfos;
        } else {
            this.companyInfos = companys = this.getCompanyInfos();
        }
        if (companys == null) {
            return null;
        }
        CurrencyInfo currencyInfo = companys[0].getBaseCurrency();
        if (currencyInfo == null) {
            return null;
        }
        for (int i = 1; i < companys.length; ++i) {
            if (companys[i].getAccountPeriodType() == null) {
                return null;
            }
            if (companys[i].getBaseCurrency().getId().equals((Object)currencyInfo.getId())) continue;
            return null;
        }
        return currencyInfo;
    }

    private PeriodTypeInfo getSamePeriodTypeInfo() {
        CompanyOrgUnitInfo[] companys = null;
        if (this.companyInfos != null) {
            companys = this.companyInfos;
        } else {
            this.companyInfos = companys = this.getCompanyInfos();
        }
        if (companys == null) {
            return null;
        }
        PeriodTypeInfo periodTypeInfo = companys[0].getAccountPeriodType();
        if (periodTypeInfo == null) {
            return null;
        }
        for (int i = 1; i < companys.length; ++i) {
            if (companys[i].getAccountPeriodType() == null) {
                return null;
            }
            if (companys[i].getAccountPeriodType().getId().equals((Object)periodTypeInfo.getId())) continue;
            return null;
        }
        return periodTypeInfo;
    }

    protected boolean isCompanyChanged(DataChangeEvent e) {
        Object newValue = this.handleChangedCompany(e.getNewValue());
        Object oldValue = this.handleChangedCompany(e.getOldValue());
        if (newValue == null) {
            return oldValue != null;
        }
        if (oldValue == null) {
            return true;
        }
        return !this.isCompanyEquals(newValue, oldValue);
    }

    private Object handleChangedCompany(Object obj) {
        if (obj instanceof Object[]) {
            int noNullCount = 0;
            for (Object company : (Object[])obj) {
                if (company == null) continue;
                ++noNullCount;
            }
            if (noNullCount == 0) {
                return null;
            }
            Object[] companies = new Object[noNullCount];
            int index = 0;
            for (Object company : (Object[])obj) {
                if (company == null) continue;
                companies[index++] = company;
            }
            return companies;
        }
        return obj;
    }

    protected boolean isCompanyEquals(Object newObject, Object oldObject) {
        if (newObject instanceof Object[] && oldObject instanceof Object[] && Arrays.toString((Object[])newObject).equalsIgnoreCase(Arrays.toString((Object[])oldObject))) {
            return true;
        }
        if (newObject instanceof CompanyOrgUnitInfo && oldObject instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)newObject).getId().equals((Object)((CompanyOrgUnitInfo)oldObject).getId());
        }
        return false;
    }

    private void setPeriodRange() {
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    private CompanyOrgUnitInfo[] getCompanyInfos() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys != null) {
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("reportCurrency.id"));
            sic.add(new SelectorItemInfo("reportCurrency.number"));
            sic.add(new SelectorItemInfo("reportCurrency.name"));
            sic.add(new SelectorItemInfo("reportCurrency.precision"));
            sic.add(new SelectorItemInfo("accountPeriodType.id"));
            sic.add(new SelectorItemInfo("accountPeriodType.number"));
            sic.add(new SelectorItemInfo("accountPeriodType.name"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            evi.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            StringBuffer ids = new StringBuffer();
            int len = companys.length;
            for (int i = 0; i < len; ++i) {
                ids.append("'").append(companys[i].getId().toString()).append("',");
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.substring(0, ids.length() - 1), CompareType.INNER));
            evi.setFilter(filter);
            try {
                Object[] objs = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi).toArray();
                if (objs != null) {
                    int len2 = objs.length;
                    for (int i = 0; i < len2; ++i) {
                        companys[i] = (CompanyOrgUnitInfo)objs[i];
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return companys;
    }

    private CompanyOrgUnitInfo[] getCompanysByCompanyTree() {
        CompanyOrgUnitInfo[] companys;
        DefaultMutableTreeNode companyTree = (DefaultMutableTreeNode)this.treeModelOfCompany.getRoot();
        if (companyTree == null) {
            companys = new CompanyOrgUnitInfo[]{this.getCurrentCompany()};
        } else {
            ArrayList<CompanyOrgUnitInfo> companyList = new ArrayList<CompanyOrgUnitInfo>();
            Enumeration<TreeNode> enums = companyTree.breadthFirstEnumeration();
            while (enums.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enums.nextElement();
                if (!node.isLeaf()) continue;
                companyList.add(RptClientUtil.toCompanyOrgUnitInfo((SimpleCompanyUserObject)node.getUserObject()));
            }
            CompanyOrgUnitInfo[] simpleCompanys = new CompanyOrgUnitInfo[companyList.size()];
            companys = companyList.toArray(simpleCompanys);
        }
        return companys;
    }

    private CompanyOrgUnitInfo[] getCompanysByCompanyTree(DefaultMutableTreeNode companyTree) {
        CompanyOrgUnitInfo[] companys;
        if (companyTree == null) {
            companys = new CompanyOrgUnitInfo[]{this.getCurrentCompany()};
        } else {
            ArrayList<CompanyOrgUnitInfo> companyList = new ArrayList<CompanyOrgUnitInfo>();
            Enumeration<TreeNode> enums = companyTree.breadthFirstEnumeration();
            while (enums.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enums.nextElement();
                if (!node.isLeaf()) continue;
                companyList.add(RptClientUtil.toCompanyOrgUnitInfo((SimpleCompanyUserObject)node.getUserObject()));
            }
            CompanyOrgUnitInfo[] simpleCompanys = new CompanyOrgUnitInfo[companyList.size()];
            companys = companyList.toArray(simpleCompanys);
        }
        return companys;
    }

    private boolean judgeCompanyTreeIsSame(CompanyOrgUnitInfo[] c1, CompanyOrgUnitInfo[] c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        int lengtn = c1.length;
        if (c2.length != lengtn) {
            return false;
        }
        Comparator<CompanyOrgUnitInfo> comparator = new Comparator<CompanyOrgUnitInfo>(){

            @Override
            public int compare(CompanyOrgUnitInfo o1, CompanyOrgUnitInfo o2) {
                return o1.getLongNumber().compareTo(o2.getLongNumber());
            }
        };
        Arrays.sort(c1, comparator);
        Arrays.sort(c2, comparator);
        for (int i = 0; i < lengtn; ++i) {
            if (c1[i].getId().equals((Object)c2[i].getId())) continue;
            return false;
        }
        return true;
    }

    private void reInitCurrcencyCombox() {
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("G001", null);
        String orgId = !this.currCompany.isIsBizUnit() ? this.currCompany.getId().toString() : ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
        items.put("GL_008", orgId);
        HashMap params = null;
        try {
            params = ParamControlFactory.getRemoteInstance().getParamHashMap(items);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Object useRptCurrency = params.get("G001");
        boolean isUseRptCurrency = useRptCurrency != null && Boolean.valueOf(useRptCurrency.toString()) != false;
        boolean isForeignCurrency = Boolean.valueOf(params.get("GL_008").toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        CurrencyCollection currencyCollection = null;
        try {
            currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        CurrencyInfo generalLocalCurrency = null;
        CurrencyInfo generalRptCurrency = null;
        Vector<CurrencyInfo> currencys = new Vector<CurrencyInfo>();
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currency = currencyCollection.get(i);
            if (currency != null && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) && !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                currencys.add(currencyCollection.get(i));
            }
            if (currency != null && currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                generalLocalCurrency = currency;
            }
            if (currency == null || !currency.getId().toString().trim().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
            generalRptCurrency = currency;
        }
        if (!isForeignCurrency) {
            if (generalLocalCurrency != null && generalLocalCurrency.getName() != null && !generalLocalCurrency.getName().trim().equals("")) {
                currencys.add(generalLocalCurrency);
            }
            if (isUseRptCurrency && generalRptCurrency != null && generalRptCurrency.getName() != null && !generalRptCurrency.getName().trim().equals("")) {
                currencys.add(generalRptCurrency);
            }
        }
        this.kDComboBoxCurrency.setModel(new DefaultComboBoxModel(currencys));
    }
}

