/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashFlowAttachedListFacadeFactory;
import com.kingdee.eas.fi.gl.CashFlowIndirectFactory;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashFlowIndirect;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowIndirectConditionUI;
import com.kingdee.eas.fi.gl.client.EasUIUtils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CashFlowIndirectConditionUI
extends AbstractCashFlowIndirectConditionUI {
    private static final long serialVersionUID = 4013639557412739058L;
    private static final Logger logger = CoreUIObject.getLogger(CashFlowIndirectConditionUI.class);
    private PeriodInfo currentPeriod = null;
    private CompanyOrgUnitInfo company = null;
    private CashflowQueryParam customCondition;
    private GlUtils.AccountPeriodInfo pi;

    public CashFlowIndirectConditionUI() throws Exception {
        this.jbInit();
        this.initTiTle();
        this.initUIContentLayout();
    }

    private void jbInit() throws Exception {
        this.kdpStartDate.setSupportedEmpty(false);
        this.kdpEndDate.setSupportedEmpty(false);
        this.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        if (this.company.getAccountTable() == null) {
            return;
        }
    }

    private void initTiTle() throws Exception {
        this.setUITitle(this.getResource("CashFlowIndirectUIName"));
    }

    public void onInit(RptParams initParams) throws Exception {
        String curComId = this.company.getId().toString();
        Object[] initData = VoucherFacadeFactory.getRemoteInstance().fetchInitFilterData(curComId);
        this.pi = (GlUtils.AccountPeriodInfo)initData[1];
        this.setCurrentPeriod(this.pi.curPeriod);
        PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.kspStartYear, (KDSpinner)this.kspStartPeriod, (KDSpinner)this.kspEndYear, (KDSpinner)this.kspEndPeriod, (boolean)false, (boolean)false);
        CurrencyCollection cc = (CurrencyCollection)initParams.getObject("getAllCurrency");
        for (int i = 0; i < cc.size(); ++i) {
            if (cc.get(i).isGeneralLocalCurrency() || cc.get(i).isGeneralReportCurrency()) continue;
            this.kcbCurrency.addItem((Object)cc.get(i));
        }
        RptParams param1 = RptClientUtil.loadSystemParams(this.company.getId().toString());
        boolean parmForeignCurrencySu = Boolean.valueOf(param1.getObject("GL_008").toString());
        boolean parmUseReportingCurrency = Boolean.valueOf(param1.getObject("G001").toString());
        if (!parmForeignCurrencySu) {
            for (int i = 0; i < cc.size(); ++i) {
                if (cc.get(i).isGeneralLocalCurrency()) {
                    this.kcbCurrency.addItem((Object)cc.get(i));
                    continue;
                }
                if (!cc.get(i).isGeneralReportCurrency() || !parmUseReportingCurrency) continue;
                this.kcbCurrency.addItem((Object)cc.get(i));
            }
        }
        EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.kcbCurrency, (ObjectBaseInfo)SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
    }

    public CashflowQueryParam getCondition() {
        if (this.customCondition == null) {
            this.customCondition = new CashflowQueryParam();
        }
        this.customCondition.setCompanyId(this.getCompany().getId().toString());
        boolean includeNotPosting = this.kcbIncludeNoPosted.isSelected();
        this.customCondition.setIndcludeNoPosted(includeNotPosting);
        boolean optionAmountZero = this.krbPeriod.isSelected();
        this.customCondition.setPeriod(optionAmountZero);
        if (optionAmountZero) {
            int yearBegin = (Integer)this.kspStartYear.getValue();
            this.customCondition.setStartYear(yearBegin);
            int yearEnd = (Integer)this.kspEndYear.getValue();
            this.customCondition.setEndYear(yearEnd);
            Integer periodBegin = (Integer)this.kspStartPeriod.getValue();
            this.customCondition.setStartPeriod(periodBegin);
            Integer periodEND = (Integer)this.kspEndPeriod.getValue();
            this.customCondition.setEndPeriod(periodEND);
            try {
                ICashFlowIndirect cf = CashFlowIndirectFactory.getRemoteInstance();
                HashMap<String, Object> initParam = new HashMap<String, Object>();
                initParam.put("PeriodTypeInfo", this.getCurrentPeriod());
                initParam.put("CashflowQueryParam", this.customCondition);
                Map period = cf.fetchInitData(initParam);
                this.customCondition.setStartDate((Date)period.get("BeginDate"));
                this.customCondition.setEndDate(new Date(((Timestamp)period.get("EndDate")).getTime()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            Date start = this.kdpStartDate.getSqlDate();
            Date end = this.kdpEndDate.getSqlDate();
            this.customCondition.setStartDate(start);
            this.customCondition.setEndDate(end);
            this.customCondition.setStartYear(1900 + start.getYear());
            this.customCondition.setStartPeriod(start.getMonth() + 1);
            this.customCondition.setEndYear(1900 + end.getYear());
            this.customCondition.setEndPeriod(end.getMonth() + 1);
        }
        this.customCondition.setCurrency((CurrencyInfo)this.kcbCurrency.getSelectedItem());
        return this.customCondition;
    }

    @Override
    protected void krbDate_itemStateChanged(ItemEvent e) throws Exception {
        this.kdpDate.setVisible(true);
        this.kdpPeriod.setVisible(false);
        this.kdpEndDate.setEnabled(true);
        this.kdpStartDate.setEnabled(true);
        this.kspEndPeriod.setEnabled(false);
        this.kspEndYear.setEnabled(false);
        this.kspStartPeriod.setEnabled(false);
        this.kspStartYear.setEnabled(false);
    }

    @Override
    protected void krbPeriod_itemStateChanged(ItemEvent e) throws Exception {
        this.kdpDate.setVisible(false);
        this.kdpPeriod.setVisible(true);
        this.kdpEndDate.setEnabled(false);
        this.kdpStartDate.setEnabled(false);
        this.kspEndPeriod.setEnabled(true);
        this.kspEndYear.setEnabled(true);
        this.kspStartPeriod.setEnabled(true);
        this.kspStartYear.setEnabled(true);
    }

    protected void krbAllCash_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void krbOneCash_actionPerformed(ActionEvent e) throws Exception {
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public PeriodInfo getCurrentPeriod() {
        return this.currentPeriod;
    }

    public void setCurrentPeriod(PeriodInfo currentPeriod) {
        this.currentPeriod = currentPeriod;
    }

    public String getResource(String resKey) {
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI", (String)resKey);
        return res;
    }

    public boolean verify() {
        if (this.krbDate.isSelected()) {
            Date from = this.kdpStartDate.getSqlDate();
            Date to = this.kdpEndDate.getSqlDate();
            if (to.before(from)) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("InputDateStart"));
                this.kdpStartDate.requestFocus();
                return false;
            }
        }
        CashflowQueryParam condition = this.getCondition();
        condition.setSelectCashFlowItem(false);
        try {
            int choise;
            boolean hasNoSelectVoucher = CashFlowAttachedListFacadeFactory.getRemoteInstance().existNoSelectCFItemVoucher(condition);
            if (hasNoSelectVoucher && (choise = MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("HasNoSelectCFItemVoucher"))) != 0) {
                return false;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return true;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rcm = new RptConditionManager();
        rcm.recordAllStatus((Container)((Object)this));
        rcm.setProperty("CashflowQueryParam", (Object)this.getCondition());
        return rcm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rcm = new RptConditionManager(params);
        this.customCondition = (CashflowQueryParam)rcm.getProperty("CashflowQueryParam");
        rcm.restoreAllStatus((Container)((Object)this));
    }

    public void clear() {
        this.krbPeriod.setSelected(true);
        try {
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.kspStartYear, (KDSpinner)this.kspStartPeriod, (KDSpinner)this.kspEndYear, (KDSpinner)this.kspEndPeriod, (boolean)false, (boolean)false);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        this.kcbIncludeNoPosted.setSelected(false);
        EasUIUtils.setComboBoxSelectByUUid((JComboBox)this.kcbCurrency, (ObjectBaseInfo)SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
    }
}

