/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowIndirectFactory;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashFlowIndirect;
import com.kingdee.eas.fi.gl.TAccountInfo;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowIndirectUI;
import com.kingdee.eas.fi.gl.client.CashFlowIndirectConditionUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CashFlowIndirectUI
extends AbstractCashFlowIndirectUI {
    private static final long serialVersionUID = -3820892495451226614L;
    private static final String ACCOUNT_NAME = "accountName";
    private static final String ACCOUNT_AMOUNT = "accountAmount";
    private CashFlowIndirectConditionUI conditionPanel = null;
    private CashflowQueryParam condition = null;
    private Map tAccountMap = null;
    private TAccountInfo accountInfo = null;
    private Map menu;
    private int curRow = -1;
    private int curCloumn = 0;
    private boolean initLevel = false;
    TableSelectionListener myTableSelectionListener = new TableSelectionListener();

    public CashFlowIndirectUI() throws Exception {
        this.jbInit();
        RptClientUtil.checkFIUnit(false);
    }

    private void jbInit() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = this.getConditionPanel();
        }
        this.ktbCashflow.checkParsed();
        this.addMyMenu();
        this.ktbCashflow.getSelectManager().setSelectMode(2);
        this.ktbCashflow.setEditable(false);
        this.setCanCopyPaste(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curRow = 0;
        this.curCloumn = 0;
        this.menuItemQuery.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuIsEnabledWhenSelectRowChanged(this.curRow, this.curCloumn, this.ktbCashflow);
        this.initMyListener();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    protected void query() {
        this.condition = (CashflowQueryParam)this.params.getObject("CashflowQueryParam");
        this.initTiTle();
        try {
            this.tAccountMap = this.getBizInterface().getTAccountMap(this.condition);
            this.splitCollect();
            this.curRow = -1;
            this.ktbCashflow.removeRows();
            this.initTable();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void initTiTle() {
        this.setUITitle(this.getResource("CashFlowIndirectUIName"));
        this.kdbTitle.setText(this.getResource("CashFlowIndirectUIName"));
        if (this.condition.isPeriod()) {
            this.kdTxtPeriod.setText(InitClientHelp.getPeriodTitle2(this.condition.getStartYear(), this.condition.getStartPeriod(), this.condition.getEndYear(), this.condition.getEndPeriod()));
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"period"));
        } else {
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"date"));
            this.kdTxtPeriod.setText(InitClientHelp.getDateTitle(this.condition.getStartDate(), this.condition.getEndDate()));
        }
        this.kdTxtCurrency.setText(this.condition.getCurrency().getName());
    }

    private void initTable() {
        int precision = this.condition.getCurrency().getPrecision();
        this.ktbCashflow.getColumn(ACCOUNT_NAME).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
        this.ktbCashflow.getColumn(ACCOUNT_AMOUNT).getStyleAttributes().setNumberFormat(this.getDecimalFormat(precision));
        TAccountInfo ownerType = (TAccountInfo)this.tAccountMap.get("ownerType");
        String allAccout = this.getResource("AllAccount");
        this.ktbCashflow.getTreeColumn().setOrientation(0);
        this.ktbCashflow.getTreeColumn().setLevelWidth(13);
        IRow row = null;
        if (ownerType.getEntrys().size() != 0) {
            row = this.ktbCashflow.addRow();
            row.getCell(ACCOUNT_NAME).setValue((Object)allAccout);
            row.getCell(ACCOUNT_AMOUNT).setValue((Object)ownerType.getAmount().setScale(precision, 4));
            row.setUserObject((Object)ownerType);
            row.setTreeLevel(ownerType.getLevel());
            this.ktbCashflow.setRefresh(true);
            this.ktbCashflow.setFocusable(true);
            this.ktbCashflow.getSelectManager().select(0, 0);
        }
        IColumn leCol = this.ktbCashflow.getColumn(ACCOUNT_AMOUNT);
        leCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.ktbCashflow.getTreeColumn().setDepth(0);
    }

    private void splitCollect() {
        String allAccout = this.getResource("AllAccount");
        TAccountInfo ownerType = null;
        TAccountInfo optiType = null;
        ownerType = (TAccountInfo)this.tAccountMap.get("ownerType");
        optiType = (TAccountInfo)this.tAccountMap.get("optiType");
        ownerType.setName(allAccout);
        optiType.setName(allAccout);
        ownerType.setNumber("0");
        optiType.setNumber("0");
    }

    protected void initMyListener() {
        this.ktbCashflow.addKDTActiveCellListener((KDTActiveCellListener)this.myTableSelectionListener);
        this.ktbCashflow.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 3) {
                    int line = e.getRowIndex();
                    int col = e.getColIndex();
                    CashFlowIndirectUI.this.ktbCashflow.getSelectManager().select(line, col);
                }
            }
        });
    }

    public CashFlowIndirectConditionUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CashFlowIndirectConditionUI();
        }
        Dimension dd = new Dimension(340, 280);
        this.conditionPanel.setSize(dd);
        return this.conditionPanel;
    }

    private void menuIsEnabledWhenSelectRowChanged(int line, int col, KDTable table) {
        if (line < 0 || col < 0 || this.menu.isEmpty()) {
            return;
        }
        IRow row = this.ktbCashflow.getRow(line);
        if (row != null) {
            this.accountInfo = (TAccountInfo)row.getUserObject();
            int status = this.accountInfo.getStatus();
            this.setMenuEnable(true);
            if (status == 88) {
                ((JMenuItem)this.menu.get("2")).setEnabled(false);
                ((JMenuItem)this.menu.get("6")).setEnabled(false);
                ((JMenuItem)this.menu.get("7")).setEnabled(false);
            }
            if (status == 9) {
                ((JMenuItem)this.menu.get("1")).setEnabled(false);
                ((JMenuItem)this.menu.get("2")).setEnabled(false);
            }
            if (status == 6 || status == 7) {
                ((JMenuItem)this.menu.get("3")).setEnabled(false);
                ((JMenuItem)this.menu.get("2")).setEnabled(false);
            }
            if (status == 7) {
                ((JMenuItem)this.menu.get("1")).setEnabled(false);
            }
            if (this.accountInfo.getLevel() == 1 && (status == 6 || status == 7)) {
                ((JMenuItem)this.menu.get("6")).setEnabled(false);
                ((JMenuItem)this.menu.get("7")).setEnabled(false);
            }
        }
    }

    public void actionJoinVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.ktbCashflow.getRowCount(); ++i) {
            IRow row = this.ktbCashflow.getRow(i);
            if (row == null) continue;
            TAccountInfo tAccount = (TAccountInfo)row.getUserObject();
            list.addAll(tAccount.getEntrys());
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"IDList", list);
        uiContext.put((Object)"change", (Object)list.toString());
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherListUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setMenuEnable(boolean enable) {
        Set set = this.menu.keySet();
        for (String key : set) {
            ((JMenuItem)this.menu.get(key)).setEnabled(enable);
        }
    }

    private ArrayList getInfoList(Map infoMap) {
        String fnumber = this.accountInfo.getNumber();
        if (this.accountInfo.getStatus() == 7 && fnumber.equals("_")) {
            fnumber = this.accountInfo.getParent();
        }
        ArrayList<TAccountInfo> infoList = new ArrayList<TAccountInfo>();
        TreeSet set = new TreeSet(infoMap.keySet());
        for (String key : set) {
            TAccountInfo info;
            Object obj = infoMap.get(key);
            if (!(obj instanceof TAccountInfo) || !fnumber.equals((info = (TAccountInfo)obj).getParent()) || info.getNumber().equals(this.accountInfo.getParent())) continue;
            info.setExpandByOptiAccount(false);
            infoList.add(info);
        }
        return infoList;
    }

    private ArrayList getOptiInfoList(Map infoMap) {
        ArrayList<TAccountInfo> infoList = new ArrayList<TAccountInfo>();
        TreeSet set = new TreeSet(infoMap.keySet());
        for (String key : set) {
            Object obj = infoMap.get(key);
            if (!(obj instanceof TAccountInfo)) continue;
            TAccountInfo info = (TAccountInfo)obj;
            infoList.add(info);
            info.setStatus(9);
        }
        return infoList;
    }

    private String withBlank(int level, String name) {
        int Count = 4;
        StringBuffer buffer = new StringBuffer("");
        if (!this.condition.isCashColl()) {
            --level;
        }
        for (int i = 0; i < level * Count; ++i) {
            buffer.append(" ");
        }
        buffer.append(name);
        return buffer.toString();
    }

    private void addMyMenu() throws Exception {
        if (this.menu == null) {
            this.menu = new HashMap();
        }
        this.enableExportExcel(this.ktbCashflow);
        KDPopupMenu kdmenu = new KDPopupMenu();
        this.addPopMenu(kdmenu, this.getResource("ExpandAccount"), 1);
        this.addPopMenu(kdmenu, this.getResource("ExpandOpposingAccount"), 2);
        this.addPopMenu(kdmenu, this.getResource("ExpandCashflowItem"), 3);
        this.addPopMenu(kdmenu, this.getResource("ShowVoucher"), 4);
        this.addPopMenu(kdmenu, this.getResource("BackItem"), 5);
        this.addPopMenu(kdmenu, this.getResource("AddCashflowItem"), 6);
        this.addPopMenu(kdmenu, this.getResource("CancelCashflowItem"), 7);
        kdmenu.add((Component)new KDSeparator());
        KDPopupMenu menu = this.getMenuManager(this.ktbCashflow).getMenu();
        int count = menu.getComponentCount();
        for (int i = 0; i < count; ++i) {
            kdmenu.add(menu.getComponent(0));
        }
        this.getMenuManager(this.ktbCashflow).setMenu(kdmenu);
    }

    private void addPopMenu(KDPopupMenu kdmenu, String label, int action) {
        JMenuItem item = new JMenuItem();
        item.setText(label);
        kdmenu.add(item);
        item.addActionListener(new CashItemActionListener(action));
        this.menu.put(String.valueOf(action), item);
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new CashFlowIndirectConditionUI();
    }

    private void expand(ArrayList infoList) {
        if (infoList != null && infoList.size() != 0) {
            int level = 1;
            if (this.accountInfo != null) {
                level = this.accountInfo.getLevel() + 1;
            }
            if (this.initLevel) {
                level = 1;
            }
            if (this.ktbCashflow.getTreeColumn().getDepth() < level) {
                this.ktbCashflow.getTreeColumn().setDepth(level);
            }
            int count = infoList.size();
            for (int i = 0; i < count; ++i) {
                IRow row = this.ktbCashflow.addRow(this.curRow + i + 1);
                TAccountInfo info = (TAccountInfo)infoList.get(i);
                row.setUserObject((Object)info);
                String name = info.getName();
                row.getCell(ACCOUNT_NAME).setValue((Object)this.withBlank(level, name));
                row.getCell(ACCOUNT_AMOUNT).setValue((Object)info.getAmount());
                row.setTreeLevel(info.getLevel());
            }
        }
    }

    private void expandAccount(ActionEvent e) throws Exception {
        this.backItem(e);
        int status = this.accountInfo.getStatus();
        this.accountInfo.setExpandByAccount(true);
        Map infoMap = null;
        if (status == 6) {
            infoMap = this.expandAcctBySupplementaryItem();
        } else {
            TAccountInfo tacct = (TAccountInfo)this.tAccountMap.get("ownerType");
            infoMap = tacct.getInfoList();
        }
        ArrayList infoList = this.getInfoList(infoMap);
        if (infoList.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NoSubAccount"));
        } else {
            this.sortInfoList(infoList);
            this.expand(infoList);
        }
    }

    private void expandOptiAccount(ActionEvent e) throws Exception {
        this.expandOptiOneAccount(e);
    }

    private void expandOptiOneAccount(ActionEvent e) throws Exception {
        IRow row = this.ktbCashflow.getRow(this.curRow);
        TAccountInfo tAccountInfo = (TAccountInfo)row.getUserObject();
        if (tAccountInfo.isExpandByOptiAccount()) {
            return;
        }
        this.backItem(e);
        String ownerAccountNumber = tAccountInfo.getNumber();
        Map infoMap = null;
        HashMap<String, TAccountInfo> infoMapOpti = new HashMap<String, TAccountInfo>();
        TAccountInfo tacct = (TAccountInfo)this.tAccountMap.get("optiType");
        if (!GlUtils.isEmpty(tAccountInfo.getSupplementary())) {
            this.condition.setSupplementary(tAccountInfo.getSupplementary());
            tacct = (TAccountInfo)this.getBizInterface().getTAccountMap(this.condition).get("optiType");
            this.condition.setSupplementary(null);
        }
        infoMap = tacct.getInfoList();
        Collection c = infoMap.values();
        for (TAccountInfo optiAccountInfo : c) {
            if (!optiAccountInfo.getOwnerAccountNumber().startsWith(ownerAccountNumber) && !ownerAccountNumber.startsWith(optiAccountInfo.getOwnerAccountNumber())) continue;
            optiAccountInfo.setLevel(tAccountInfo.getLevel() + 1);
            infoMapOpti.put(optiAccountInfo.getId() + optiAccountInfo.getOwnerAccountNumber(), optiAccountInfo);
        }
        if (infoMapOpti != null) {
            ArrayList infoList = this.getOptiInfoList(infoMapOpti);
            this.removeDuplicateWithOrder(infoList);
            if (infoList.isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NoOptiAccount"));
            } else {
                this.sortInfoList(infoList);
                this.expand(infoList);
                tAccountInfo.setExpandByOptiAccount(true);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NoOptiAccount"));
        }
    }

    private Map expandAcctBySupplementaryItem() throws Exception {
        Map cashflowItems = null;
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("method", "AcctBySupplementaryItem");
        queryMap.put("companyid", companyId);
        queryMap.put("accountInfo", this.accountInfo);
        queryMap.put("currencyid", this.condition.getCurrency().getId().toString());
        cashflowItems = this.getBizInterface().queryItem(queryMap);
        Map accountMap = (Map)cashflowItems.get("AcctBySupplementaryItem");
        this.accountInfo.setInfoList(accountMap);
        return accountMap;
    }

    private void expandSupplementaryItem(ActionEvent e) throws EASBizException, BOSException {
        this.backItem(e);
        int status = this.accountInfo.getStatus();
        if (status == 0) {
            return;
        }
        if (status == 6 || status == 7) {
            this.ktbCashflow.removeRow(this.curRow);
            this.menuIsEnabledWhenSelectRowChanged(this.curRow - 1, this.curCloumn, this.ktbCashflow);
        }
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        CompanyOrgUnitInfo curCompany = GlUtils.getCompanyById(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        String acctabid = curCompany.getAccountTable().getId().toString();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("method", "SupplementaryItem");
        queryMap.put("companyid", companyid);
        queryMap.put("acctableid", acctabid);
        queryMap.put("accountInfo", this.accountInfo);
        queryMap.put("currencyid", this.condition.getCurrency().getId().toString());
        Map supItems = this.getBizInterface().queryItem(queryMap);
        ArrayList<TAccountInfo> infoList = (ArrayList<TAccountInfo>)supItems.get("SupplementaryItem");
        ArrayList<String> voucherList = new ArrayList<String>();
        if (infoList == null || infoList.size() == 0) {
            infoList = new ArrayList<TAccountInfo>();
            TAccountInfo account = this.createCashflowAccount(this.accountInfo.getAmount());
            account.setEntrys(this.accountInfo.getEntrys());
            account.setCashitems(this.accountInfo.getCashitems());
            account.setParent(this.accountInfo.getNumber());
            infoList.add(account);
        } else {
            TAccountInfo root = (TAccountInfo)this.tAccountMap.get("ownerType");
            HashMap cashitems = new HashMap();
            if (root == this.accountInfo) {
                this.getCashflowItems(this.accountInfo, cashitems);
            } else {
                cashitems.putAll(this.accountInfo.getCashitems());
            }
            HashMap<String, ArrayList<Object>> supplementaryItems = new HashMap<String, ArrayList<Object>>();
            for (String key : cashitems.keySet()) {
                List list = (List)cashitems.get(key);
                supplementaryItems.put(key, new ArrayList(list));
            }
            BigDecimal amount = SysConstant.BIGZERO;
            boolean isNoHas = true;
            int count = infoList.size();
            for (int i = 0; i < count; ++i) {
                TAccountInfo info = (TAccountInfo)infoList.get(i);
                for (String entryID : info.getCashitems().keySet()) {
                    List list = (List)supplementaryItems.get(entryID);
                    if (list == null) {
                        boolean bFound = this.recursiveSearch(root, entryID);
                        if (bFound) continue;
                        supplementaryItems.put(entryID, (ArrayList<Object>)info.getCashitems().get(entryID));
                        continue;
                    }
                    int size = list.size();
                    for (int k = size - 1; k >= 0; --k) {
                        Object[] cashflows = (Object[])list.get(k);
                        Object isAssigned = cashflows[cashflows.length - 1];
                        if (isAssigned instanceof String) {
                            isAssigned = cashflows[cashflows.length - 2];
                        }
                        if (!Boolean.TRUE.equals(isAssigned)) continue;
                        list.remove(k);
                    }
                    if (list.size() != 0) continue;
                    supplementaryItems.remove(entryID);
                }
                amount = amount.add(info.getAmount());
                if (info.getStatus() != 7) continue;
                isNoHas = false;
            }
            if (isNoHas && amount.compareTo(this.accountInfo.getAmount()) != 0) {
                for (String entryID : supplementaryItems.keySet()) {
                    ObjectUuidPK pk = new ObjectUuidPK(entryID);
                    VoucherEntryInfo entry = (VoucherEntryInfo)VoucherEntryFactory.getRemoteInstance().getValue((IObjectPK)pk);
                    String voucherID = entry.getBill().getId().toString();
                    voucherList.add(voucherID);
                }
                amount = this.accountInfo.getAmount().subtract(amount);
                TAccountInfo account = this.createCashflowAccount(amount);
                account.setParent(this.accountInfo.getNumber());
                account.setCashitems(supplementaryItems);
                account.setEntrys(voucherList);
                infoList.add(account);
            }
        }
        this.expand(infoList);
    }

    private boolean recursiveSearch(TAccountInfo info, String selfEntryId) {
        if (info.getCashitems().containsKey(selfEntryId)) {
            return true;
        }
        for (TAccountInfo tAccountInfo : info.getInfoList().values()) {
            if (!this.recursiveSearch(tAccountInfo, selfEntryId)) continue;
            return true;
        }
        return false;
    }

    private void getCashflowItems(TAccountInfo info, Map cashflows) {
        cashflows.putAll(info.getCashitems());
        for (TAccountInfo tAccountInfo : info.getInfoList().values()) {
            this.getCashflowItems(tAccountInfo, cashflows);
        }
    }

    private List getCashflowItems(TAccountInfo info) {
        ArrayList<Map> result = new ArrayList<Map>();
        result.add(info.getCashitems());
        for (TAccountInfo tAccountInfo : info.getInfoList().values()) {
            List temp = this.getCashflowItems(tAccountInfo);
            result.addAll(temp);
        }
        return result;
    }

    private TAccountInfo createCashflowAccount(BigDecimal amount) {
        TAccountInfo account = new TAccountInfo(this.accountInfo.getLevel() + 1);
        account.setName(this.getResource("NotDealCashflow"));
        account.setCash(this.accountInfo.isCash());
        account.setDebit(this.accountInfo.isDebit());
        account.setNumber("_");
        account.setDirection(1);
        account.setAmount(amount);
        account.setStatus(7);
        return account;
    }

    private void showVoucher(ActionEvent e) {
        UIContext uiContext = new UIContext((Object)this);
        if (this.accountInfo.getEntrys().isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("NoVoucher"));
        } else {
            uiContext.put((Object)"IDList", (Object)this.accountInfo.getEntrys());
            uiContext.put((Object)"change", (Object)this.accountInfo.getEntrys().toString());
            try {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherListUI", (Map)uiContext);
                uiWindow.show();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    private void backItem(ActionEvent e) {
        int level = this.accountInfo.getLevel();
        this.accountInfo.setExpandByAccount(false);
        this.accountInfo.setExpandByOptiAccount(false);
        int count = this.curRow + 1;
        IRow row = this.ktbCashflow.getRow(count);
        if (row != null) {
            TAccountInfo info = (TAccountInfo)row.getUserObject();
            while (info.getLevel() > level) {
                this.ktbCashflow.removeRow(count);
                row = this.ktbCashflow.getRow(count);
                if (row == null) break;
                info = (TAccountInfo)row.getUserObject();
            }
        }
    }

    private void saveCashflowItem(ActionEvent e) throws Exception {
        int choise = MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("CashFlowItemSelect"));
        if (choise != 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isProfit", (Object)new Integer(1), CompareType.NOTEQUALS));
        evi.setFilter(filter);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiContext.put((Object)"Filter", (Object)filter);
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI", (Map)uiContext);
        }
        catch (Exception ex) {
            this.handUIException(ex);
            return;
        }
        F7CashFlowItemMainUI ui = (F7CashFlowItemMainUI)uiWindow.getUIObject();
        ui.loadFields();
        uiWindow.show();
        CashFlowItemInfo item = (CashFlowItemInfo)ui.getData();
        if (!ui.isCanceled() && item != null) {
            HashMap<String, Object> saveParam = new HashMap<String, Object>();
            saveParam.put("SupplementaryItemInfo", item);
            saveParam.put("accountInfo", this.accountInfo);
            saveParam.put("accountInfo.SupplementaryItems", this.getSupplementaryItems(e));
            this.getBizInterface().saveCashflowItem(saveParam);
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("CashflowSaveSuccess"));
            if (this.accountInfo.getStatus() == 7 || this.accountInfo.getStatus() == 6) {
                this.refresh(e);
            } else if (this.accountInfo.getStatus() == 88) {
                this.refresh(e);
                --this.curRow;
                this.refresh(e);
            } else {
                Map accountMap = this.accountInfo.getInfoList();
                if (accountMap.containsKey("SupplementaryItem")) {
                    accountMap.remove("SupplementaryItem");
                }
                if (this.accountInfo.getLevel() != 0) {
                    this.expandSupplementaryItem(e);
                }
            }
        }
    }

    @Override
    public void actionAppDefCashItem_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appDefCashItem"));
        if (result == 2) {
            return;
        }
        boolean isCover = false;
        if (result == 0) {
            isCover = true;
        }
        TAccountInfo root = (TAccountInfo)this.tAccountMap.get("ownerType");
        List cashItems = this.getCashflowItems(root);
        HashMap<String, List> saveParam = new HashMap<String, List>();
        saveParam.put("accountInfo.SupplementaryItems", cashItems);
        this.getBizInterface().saveCashflowItem(saveParam, isCover);
        if (this.accountInfo.getSupplementary() != null) {
            this.actionRefresh_actionPerformed(e);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appAddCashSuccess"));
    }

    private void cancelCashflowItem(ActionEvent e) throws Exception {
        int choise = MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("CashFlowItemRemove"));
        if (choise != 0) {
            return;
        }
        if (this.accountInfo.getStatus() == 7) {
            return;
        }
        HashMap<String, Object> cancelMap = new HashMap<String, Object>();
        cancelMap.put("accountInfo", this.accountInfo);
        cancelMap.put("accountInfo.SupplementaryItems", this.getSupplementaryItems(e));
        this.getBizInterface().cacelCashflowItem(cancelMap);
        if (this.accountInfo.getStatus() == 6) {
            this.refresh(e);
        }
        MsgBox.showInfo((Component)((Object)this), (String)this.getResource("CashflowRemoveSuccess"));
        Map accountMap = this.accountInfo.getInfoList();
        if (accountMap.containsKey("SupplementaryItem")) {
            accountMap.remove("SupplementaryItem");
        }
        this.backItem(e);
    }

    private void refresh(ActionEvent e) throws EASBizException, BOSException {
        IRow row = this.ktbCashflow.getRow(this.curRow);
        TAccountInfo tAccountInfo = (TAccountInfo)row.getUserObject();
        int oldRow = this.curRow;
        while (this.curRow >= 1 && !tAccountInfo.getNumber().equals(this.accountInfo.getParent())) {
            --this.curRow;
            row = this.ktbCashflow.getRow(this.curRow);
            tAccountInfo = (TAccountInfo)row.getUserObject();
        }
        this.accountInfo = tAccountInfo;
        Map accountMap = this.accountInfo.getInfoList();
        if (accountMap.containsKey("SupplementaryItem")) {
            accountMap.remove("SupplementaryItem");
        }
        this.expandSupplementaryItem(e);
        this.curRow = oldRow;
        this.menuIsEnabledWhenSelectRowChanged(oldRow, this.curCloumn, this.ktbCashflow);
    }

    private List getSupplementaryItems(ActionEvent e) throws Exception {
        ArrayList<Map> listSupplementaryItems = new ArrayList<Map>();
        if (this.accountInfo.getLevel() == 0 || this.accountInfo.getLevel() == 1 && this.accountInfo.getStatus() == 7) {
            if (this.accountInfo.getLevel() == 1 && this.accountInfo.getStatus() == 7 && this.curRow == 1) {
                TAccountInfo info1;
                IRow row1 = this.ktbCashflow.getRow(this.curRow - 1);
                this.accountInfo = info1 = (TAccountInfo)row1.getUserObject();
            }
            this.expandAccount(e);
            int count = this.curRow + 1;
            IRow row = this.ktbCashflow.getRow(count);
            if (row != null) {
                TAccountInfo info = (TAccountInfo)row.getUserObject();
                while (info.getLevel() == 1) {
                    listSupplementaryItems.add(info.getCashitems());
                    row = this.ktbCashflow.getRow(++count);
                    if (row == null) break;
                    info = (TAccountInfo)row.getUserObject();
                }
            }
            this.backItem(e);
        } else {
            listSupplementaryItems.add(this.accountInfo.getCashitems());
        }
        return listSupplementaryItems;
    }

    public String getResource(String resKey) {
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI", (String)resKey);
        return res;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return this.getBizInterface();
    }

    protected ICashFlowIndirect getBizInterface() throws BOSException {
        return CashFlowIndirectFactory.getRemoteInstance();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    protected RptParams getParamsForInit() {
        RptParams pp = new RptParams();
        pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return pp;
    }

    protected KDTable getTableForPrintSetting() {
        return this.ktbCashflow;
    }

    protected Map preparePrintVariantMap() {
        Map map = super.preparePrintVariantMap();
        map.put("Currency", this.kdTxtCurrency.getText());
        map.put("Period", this.kdTxtPeriod.getText());
        return map;
    }

    protected String getDecimalFormat(int scale) {
        StringBuffer sbff = new StringBuffer();
        StringBuffer sbffN = new StringBuffer();
        if (scale == 0) {
            sbff.append("#,##0");
            sbffN.append("-#,##0");
        } else {
            sbff.append("#,##0.");
            sbffN.append("-#,##0.");
        }
        for (int i = 0; i < scale; ++i) {
            sbff.append("0");
            sbffN.append("0");
        }
        return sbff.append(";").append(sbffN).toString();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    private void sortInfoList(ArrayList infoList) {
        Collections.sort(infoList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (!(arg0 instanceof TAccountInfo)) {
                    return -1;
                }
                if (!(arg1 instanceof TAccountInfo)) {
                    return 1;
                }
                TAccountInfo info1 = (TAccountInfo)arg0;
                TAccountInfo info2 = (TAccountInfo)arg1;
                if (StringUtils.isEmpty((String)info1.getNumber())) {
                    return -1;
                }
                if (StringUtils.isEmpty((String)info2.getNumber())) {
                    return 1;
                }
                return info1.getNumber().compareTo(info2.getNumber());
            }
        });
    }

    public void removeDuplicateWithOrder(ArrayList arlList) {
        HashMap<String, TAccountInfo> idMap = new HashMap<String, TAccountInfo>();
        for (Object element : arlList) {
            if (!(element instanceof TAccountInfo)) continue;
            TAccountInfo info = (TAccountInfo)element;
            if (!idMap.containsKey(info.getId())) {
                TAccountInfo newInfo = new TAccountInfo();
                newInfo.setId(info.getId());
                newInfo.setName(info.getName());
                newInfo.setNumber(info.getNumber());
                newInfo.setOwnerAccountNumber(this.accountInfo.getNumber());
                newInfo.setAmount(info.getAmount());
                newInfo.setCashitems(info.getCashitems());
                newInfo.setEntrys(info.getEntrys());
                newInfo.setCashFlowRecords(info.getCashFlowRecords());
                newInfo.setAssist(info.isAssist());
                newInfo.setAssistID(info.getAssistID());
                newInfo.setCash(info.isCash());
                newInfo.setDebit(info.isDebit());
                newInfo.setDirection(info.getDirection());
                newInfo.setExpandByAccount(info.isExpandByAccount());
                newInfo.setExpandByOptiAccount(info.isExpandByOptiAccount());
                newInfo.setInfoList(info.getInfoList());
                newInfo.setLevel(info.getLevel());
                newInfo.setParent(info.getParent());
                newInfo.setStatus(info.getStatus());
                idMap.put(info.getId(), newInfo);
                continue;
            }
            TAccountInfo totalinfo = (TAccountInfo)idMap.get(info.getId());
            if (totalinfo.getCashitems() != null && info.getCashitems() != null) {
                totalinfo.getCashitems().putAll(info.getCashitems());
            } else if (totalinfo.getCashitems() == null && info.getCashitems() != null) {
                totalinfo.setCashitems(info.getCashitems());
            }
            if (totalinfo.getInfoList() != null && info.getInfoList() != null) {
                totalinfo.getInfoList().putAll(info.getInfoList());
            } else if (totalinfo.getInfoList() == null && info.getInfoList() != null) {
                totalinfo.setInfoList(info.getInfoList());
            }
            if (totalinfo.getEntrys() != null && info.getEntrys() != null) {
                totalinfo.getEntrys().addAll(info.getEntrys());
            } else if (totalinfo.getEntrys() == null && info.getEntrys() != null) {
                totalinfo.setEntrys(info.getEntrys());
            }
            if (totalinfo.getCashFlowRecords() != null && info.getCashFlowRecords() != null) {
                totalinfo.getCashFlowRecords().addAll(info.getCashFlowRecords());
            } else if (totalinfo.getCashFlowRecords() == null && info.getCashFlowRecords() != null) {
                totalinfo.setCashFlowRecords(info.getCashFlowRecords());
            }
            if (totalinfo.getAssistID() != null && info.getAssistID() != null) {
                totalinfo.getAssistID().addAll(info.getAssistID());
            } else if (totalinfo.getAssistID() == null && info.getAssistID() != null) {
                totalinfo.setAssistID(info.getAssistID());
            }
            totalinfo.setAmount(totalinfo.getAmount().add(info.getAmount()));
        }
        arlList.clear();
        arlList.addAll(idMap.values());
    }

    public class CashItemActionListener
    implements ActionListener {
        private int action;

        public CashItemActionListener(int action) {
            this.action = action;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CashFlowIndirectUI.this.setCursorOfWair();
                if (CashFlowIndirectUI.this.curRow < 0) {
                    String info = CashFlowIndirectUI.this.getResource("NotSelectLine");
                    MsgBox.showInfo((String)info);
                    return;
                }
                switch (this.action) {
                    case 1: {
                        CashFlowIndirectUI.this.expandAccount(e);
                        return;
                    }
                    case 2: {
                        CashFlowIndirectUI.this.expandOptiAccount(e);
                        return;
                    }
                    case 3: {
                        CashFlowIndirectUI.this.expandSupplementaryItem(e);
                        return;
                    }
                    case 4: {
                        CashFlowIndirectUI.this.showVoucher(e);
                        return;
                    }
                    case 5: {
                        CashFlowIndirectUI.this.backItem(e);
                        return;
                    }
                    case 6: {
                        CashFlowIndirectUI.this.saveCashflowItem(e);
                        return;
                    }
                    case 7: {
                        CashFlowIndirectUI.this.cancelCashflowItem(e);
                        return;
                    }
                }
                return;
            }
            catch (Exception ex) {
                CashFlowIndirectUI.this.handleException(ex);
                return;
            }
            finally {
                CashFlowIndirectUI.this.setCursorOfDefault();
            }
        }
    }

    class TableSelectionListener
    implements KDTActiveCellListener {
        TableSelectionListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            KDTable table = (KDTable)e.getSource();
            int line = e.getRowIndex();
            int col = e.getColumnIndex();
            CashFlowIndirectUI.this.curRow = line;
            CashFlowIndirectUI.this.curCloumn = col;
            CashFlowIndirectUI.this.menuIsEnabledWhenSelectRowChanged(line, col, table);
        }
    }
}

