/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemViewFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowDirectUtil;
import com.kingdee.eas.fi.gl.CashFlowTAccountFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowQueryParam;
import com.kingdee.eas.fi.gl.CashflowTAccountInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashFlowTAccountFacade;
import com.kingdee.eas.fi.gl.client.AbstractCashFlowTAccountUI;
import com.kingdee.eas.fi.gl.client.CashFlowDirectConditionUI;
import com.kingdee.eas.fi.gl.client.CashFlowListUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class CashFlowTAccountUI
extends AbstractCashFlowTAccountUI {
    private static final long serialVersionUID = 9088760387756290651L;
    private static final Logger logger = CoreUIObject.getLogger(CashFlowTAccountUI.class);
    private static final String expandAccunt = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"ExpandAccount");
    private static final String expandSubAccount = EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"ExpandSubAccount");
    private CashflowQueryParam condition = null;
    private static final String DEBIT_ACCOUNT = "debitAccount";
    private static final String DEBIT_AMOUNT = "debitAmount";
    private static final String CREDIT_ACCOUNT = "creditAccount";
    private static final String CREDIT_AMOUNT = "creditAmount";
    public static final String ACTIONKEY_SAVE = "SUBMIT";
    public static final String ACTIONKEY_DEL = "UPLongame";
    private JMenuItem expandAccountItem = new JMenuItem();
    private JMenuItem expandAsstGrp = new JMenuItem();
    private JMenuItem expandOppAsstGrp = new JMenuItem();
    private JMenuItem expandCFItemItem = new JMenuItem();
    private JMenuItem showNotCFVoucherItem = new JMenuItem();
    private JMenuItem showVoucherItem = new JMenuItem();
    private JMenuItem selectCFItem = new JMenuItem();
    private JMenuItem cancelCFItem = new JMenuItem();
    private JMenuItem closeExpandItem = new JMenuItem();
    private PeriodInfo curPeriod = null;
    private boolean isModifyCashFlow = false;

    public CashFlowTAccountUI() throws Exception {
        RptClientUtil.checkFIUnit(false);
        this.jbInit();
        Object object = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_014_1");
        this.isModifyCashFlow = Boolean.valueOf(object.toString());
        this.curPeriod = GlUtils.getCurrentPeriod(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    private void jbInit() throws Exception {
        this.setUITitle(this.getResource("CashFlowTAccountUI"));
        this.ktbCashflow.checkParsed();
        this.ktbCashflow.setEditable(false);
        this.ktbCashflow.getSelectManager().setSelectMode(2);
        this.setCanCopyPaste(false);
        this.addMyMenu();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAppDefCashItem.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemAppDefCashItem.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnAssignCFI.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.menuItemAssignCFI.setIcon(EASResource.getIcon((String)"imgTbtn_credence"));
        this.btnJoinVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.btnJoinVoucher.setVisible(false);
        this.btnJoinVoucherHased.setVisible(false);
        this.btnJoinVoucherHasnot.setVisible(false);
        this.actionShowVoucher.setEnabled(true);
    }

    protected void initListener() {
        super.initListener();
        this.ktbCashflow.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                CashFlowTAccountUI.this.setPopMenuStatus();
                CashFlowTAccountUI.this.changePopMenuTitle();
            }
        });
    }

    private void setPopMenuStatus() {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return;
        }
        this.actionExpandAsstGrp.setEnabled(!info.isCash() && info.getHg() == null && (info.getCfItem() == null || info.getCfItem() != null && info.getCfItem().getAsstAccount() != null));
        this.actionExpandOppAsstGrp.setEnabled(!info.isCash() && info.getOppHg() == null);
        this.actionExpandCFItem.setEnabled(!info.isCash() && info.getCfItem() == null);
        this.actionExpandAccount.setEnabled(info.getAccount() == null || !info.getAccount().isIsLeaf());
        this.actionShowNotCFVoucher.setEnabled(!info.isCash());
        PeriodInfo sourceperiodInfo = new PeriodInfo();
        sourceperiodInfo.setPeriodYear(this.condition.getStartYear());
        sourceperiodInfo.setPeriodNumber(this.condition.getStartPeriod());
        if (this.isModifyCashFlow) {
            if (!PeriodUtils.PeriodCompare((PeriodInfo)sourceperiodInfo, (PeriodInfo)this.curPeriod)) {
                this.actionSelectCFItem.setEnabled(false);
                this.actionCancelCFItem.setEnabled(false);
            } else {
                this.actionSelectCFItem.setEnabled(!info.isCash());
                this.actionCancelCFItem.setEnabled(!info.isCash());
            }
        } else {
            this.actionSelectCFItem.setEnabled(!info.isCash());
            this.actionCancelCFItem.setEnabled(!info.isCash());
        }
    }

    private void changePopMenuTitle() {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return;
        }
        if (info.getAccount() != null) {
            this.expandAccountItem.setText(expandSubAccount);
        } else {
            this.expandAccountItem.setText(expandAccunt);
        }
    }

    private void addMyMenu() throws Exception {
        this.enableExportExcel(this.ktbCashflow);
        this.bindMenuItemAction();
        this.initActionStatus();
        KDPopupMenu kdmenu = new KDPopupMenu();
        kdmenu.add(this.expandAccountItem);
        kdmenu.add(this.expandOppAsstGrp);
        kdmenu.add(this.expandAsstGrp);
        kdmenu.add(this.expandCFItemItem);
        kdmenu.add(this.closeExpandItem);
        kdmenu.add(this.showNotCFVoucherItem);
        kdmenu.add(this.showVoucherItem);
        kdmenu.add(this.selectCFItem);
        kdmenu.add(this.cancelCFItem);
        kdmenu.add((Component)new KDSeparator());
        KDPopupMenu menu = this.getMenuManager(this.ktbCashflow).getMenu();
        int count = menu.getComponentCount();
        for (int i = 0; i < count; ++i) {
            kdmenu.add(menu.getComponent(0));
        }
        this.getMenuManager(this.ktbCashflow).setMenu(kdmenu);
    }

    private void initActionStatus() throws EASBizException, BOSException {
        boolean isAllowCFReq = this.isAllowCFReq();
        this.actionSelectCFItem.setEnabled(!isAllowCFReq);
        this.actionCancelCFItem.setEnabled(!isAllowCFReq);
    }

    private boolean isAllowCFReq() throws EASBizException, BOSException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("GL_0152");
        keys.add("GL_070");
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        Map params = GlUtils.getParamsByKeys(null, companyId, keys);
        return "0".equals(params.get("GL_0152")) && "true".equals(params.get("GL_070"));
    }

    private void bindMenuItemAction() {
        this.expandAccountItem.setAction((Action)((Object)this.actionExpandAccount));
        this.expandAsstGrp.setAction((Action)((Object)this.actionExpandAsstGrp));
        this.expandOppAsstGrp.setAction((Action)((Object)this.actionExpandOppAsstGrp));
        this.expandCFItemItem.setAction((Action)((Object)this.actionExpandCFItem));
        this.showNotCFVoucherItem.setAction((Action)((Object)this.actionShowNotCFVoucher));
        this.showVoucherItem.setAction((Action)((Object)this.actionShowVoucher));
        this.selectCFItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSelectCFItem), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.cancelCFItem.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCancelCFItem), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.closeExpandItem.setAction((Action)((Object)this.actionCloseExpand));
    }

    protected void query() {
        this.initQueryParam();
        this.initTiTle();
        List[] data = null;
        try {
            this.initTable();
            ICashFlowTAccountFacade iTAccount = this.getBizInterface();
            iTAccount.splitTAccountVoucher(this.condition);
            data = iTAccount.queryCashflowTAccountInfo(this.condition);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.fillTableData(-1, null, false, (List)data[0]);
        this.fillTableData(this.ktbCashflow.getRowCount() - 1, null, false, data[1]);
        this.fillTableData(this.ktbCashflow.getRowCount() - 1, null, true, data[2]);
        this.fillTableData(this.ktbCashflow.getRowCount() - 1, null, true, data[3]);
        PeriodInfo sourceperiodInfo = new PeriodInfo();
        sourceperiodInfo.setPeriodYear(this.condition.getStartYear());
        sourceperiodInfo.setPeriodNumber(this.condition.getStartPeriod());
        if (this.isModifyCashFlow) {
            if (!PeriodUtils.PeriodCompare((PeriodInfo)sourceperiodInfo, (PeriodInfo)this.curPeriod)) {
                this.setCtrlEnabled(false);
            } else {
                this.setCtrlEnabled(true);
            }
        }
        this.setTableConfig();
    }

    protected void setTableConfig() {
        this.tHelper.setCanMoveColumn(true);
    }

    private void setCtrlEnabled(boolean flag) {
        this.menuItemAssignCFI.setEnabled(flag);
        this.actionAssignCashFlowItem.setEnabled(flag);
        this.menuItemShowVoucher.setEnabled(flag);
        this.actionShowVoucher.setEnabled(flag);
        this.menuItemAppDefCashItem.setEnabled(flag);
        this.actionAppDefCashItem.setEnabled(flag);
        this.btnAssignCFI.setEnabled(flag);
        this.actionAssignCashFlowItem.setEnabled(flag);
        this.btnAppDefCashItem.setEnabled(flag);
        this.actionAppDefCashItem.setEnabled(flag);
        this.selectCFItem.setEnabled(flag);
        this.actionSelectCFItem.setEnabled(flag);
        this.cancelCFItem.setEnabled(flag);
        this.actionCancelCFItem.setEnabled(flag);
    }

    public void onShow() throws Exception {
        super.onShow();
        int a = 8;
    }

    private void initQueryParam() {
        this.condition = (CashflowQueryParam)this.params.getObject("CashflowQueryParam");
    }

    private void initTiTle() {
        if (this.condition.isCashFilt()) {
            this.kdbTitle.setText(this.getResource("CashFlowTAccountUI") + "_" + this.getResource("CashType"));
        } else {
            this.kdbTitle.setText(this.getResource("CashFlowTAccountUI") + "_" + this.condition.getAccount().getNumber() + "_" + this.condition.getAccount().getName());
        }
        if (this.condition.isPeriod()) {
            this.kdTxtPeriod.setText(InitClientHelp.getPeriodTitle(this.condition.getStartYear(), this.condition.getStartPeriod(), this.condition.getEndYear(), this.condition.getEndPeriod()));
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"period"));
        } else {
            this.kdLabelPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashFlowFilter", (String)"date"));
            this.kdTxtPeriod.setText(InitClientHelp.getDateTitle(this.condition.getStartDate(), this.condition.getEndDate()));
        }
        this.kdTxtCurrency.setText(this.condition.getCurrency().getName());
    }

    private void initTable() throws EASBizException, BOSException {
        this.ktbCashflow.removeRows();
        int pre = 2;
        if (this.condition.getCurrency() != null) {
            CurrencyInfo cy = this.condition.getCurrency();
            if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(cy.getId().toString())) {
                BOSUuid currencyID = SysContext.getSysContext().getCurrentFIUnit().getReportCurrency().getId();
                pre = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID)).getPrecision();
            } else if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cy.getId().toString())) {
                BOSUuid currencyID = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId();
                pre = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID)).getPrecision();
            } else {
                pre = cy.getPrecision();
            }
        }
        this.ktbCashflow.getColumn(DEBIT_AMOUNT).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(pre));
        this.ktbCashflow.getColumn(DEBIT_AMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.ktbCashflow.getColumn(CREDIT_AMOUNT).getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(pre));
        this.ktbCashflow.getColumn(CREDIT_AMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.ktbCashflow.getTreeColumn().setOrientation(0);
        this.ktbCashflow.getTreeColumn().setLevelWidth(13);
        this.ktbCashflow.getTreeColumn().setDepth(0);
    }

    private void expand(int rowIndex, int type) throws EASBizException, BOSException {
        CashflowTAccountInfo parent = this.getSelectedCFTAccountInfo(rowIndex);
        if (parent == null) {
            return;
        }
        parent.setExtended(true);
        List infoList = this.getBizInterface().expand(type, this.condition, parent);
        this.fillTableData(rowIndex, parent, parent.isCredit(), infoList);
    }

    private void backItem(int rowIndex) {
        CashflowTAccountInfo parent = this.getSelectedCFTAccountInfo(rowIndex);
        if (parent == null || !parent.isExtended()) {
            return;
        }
        parent.setExtended(false);
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(++rowIndex);
        while (info != null && info.getLevel() > parent.getLevel()) {
            this.ktbCashflow.removeRow(rowIndex);
            info = this.getSelectedCFTAccountInfo(rowIndex);
            if (info != null) continue;
            break;
        }
    }

    private F7CashFlowItemMainUI showCashflowItemSelectUI() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(0), CompareType.EQUALS));
        FilterInfo filter4Tree = new FilterInfo();
        filter4Tree.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        filter4Tree.getFilterItems().add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
        filter4Tree.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(0), CompareType.EQUALS));
        FilterInfo viewFilter = null;
        String ctrlUnitId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        try {
            viewFilter = CashFlowItemViewFactory.getRemoteInstance().getCashFlowItemViewFilter(ctrlUnitId);
            if (viewFilter != null) {
                filter.mergeFilter(viewFilter, "and");
                filter4Tree.mergeFilter(viewFilter, "and");
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        uiContext.put((Object)"Filter", (Object)filter);
        uiContext.put((Object)"filter4Tree", (Object)filter4Tree);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI", (Map)uiContext);
        F7CashFlowItemMainUI ui = (F7CashFlowItemMainUI)uiWindow.getUIObject();
        ui.loadFields();
        uiWindow.show();
        return ui;
    }

    private int getParentRowIndex(int rowIndex) {
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return -1;
        }
        for (int i = rowIndex - 1; i >= 0; --i) {
            CashflowTAccountInfo parent = this.getSelectedCFTAccountInfo(i);
            if (parent == null || parent.getLevel() >= info.getLevel()) continue;
            return i;
        }
        return -1;
    }

    private CashflowTAccountInfo getSelectedCFTAccountInfo(int rowIndex) {
        ICell debitCell = this.ktbCashflow.getCell(rowIndex, DEBIT_ACCOUNT);
        ICell creditCell = this.ktbCashflow.getCell(rowIndex, CREDIT_ACCOUNT);
        if (debitCell != null && debitCell.getValue() != null) {
            return (CashflowTAccountInfo)debitCell.getValue();
        }
        if (creditCell != null && creditCell.getValue() != null) {
            return (CashflowTAccountInfo)creditCell.getValue();
        }
        return null;
    }

    private void fillTableData(int rowIndex, CashflowTAccountInfo parent, boolean isCredit, List data) {
        if (data == null) {
            return;
        }
        this.setTableDepth(parent);
        int currRowIndex = rowIndex;
        Iterator it = data.iterator();
        while (it.hasNext()) {
            ++currRowIndex;
            CashflowTAccountInfo info = (CashflowTAccountInfo)it.next();
            if (parent != null) {
                info.setLevel(parent.getLevel() + 1);
            }
            IRow row = this.ktbCashflow.addRow(currRowIndex);
            row.setTreeLevel(info.getLevel());
            row.getCell(isCredit ? CREDIT_ACCOUNT : DEBIT_ACCOUNT).setValue((Object)info);
            row.getCell(isCredit ? CREDIT_AMOUNT : DEBIT_AMOUNT).setValue((Object)info.getAmount());
        }
    }

    private void setTableDepth(CashflowTAccountInfo parent) {
        int depth = 0;
        if (parent != null) {
            depth = parent.getLevel() + 1;
        }
        this.ktbCashflow.getTreeColumn().setDepth(depth);
    }

    @Override
    public void actionExpandAccount_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo parent = this.getSelectedCFTAccountInfo(rowIndex);
        if (parent == null) {
            return;
        }
        AccountViewInfo account = parent.getAccount();
        if (account != null && account.isIsLeaf()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI", (String)"NoSubAccount"));
            SysUtil.abort();
        }
        this.backItem(rowIndex);
        this.expand(rowIndex, 1);
    }

    @Override
    public void actionExpandAsstGrp_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
        this.expand(rowIndex, 2);
    }

    @Override
    public void actionExpandOppAsstGrp_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
        this.expand(rowIndex, 3);
    }

    @Override
    public void actionExpandCFItem_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
        this.expand(rowIndex, 4);
    }

    @Override
    public void actionSelectCFItem_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return;
        }
        if (info.getAccount() != null && (info.getAccount().isIsBank() || info.getAccount().isIsCash() || info.getAccount().isIsCashEquivalent())) {
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("ClearSupplementaryItem")) != 0) {
            return;
        }
        F7CashFlowItemMainUI ui = this.showCashflowItemSelectUI();
        if (ui.isCanceled()) {
            return;
        }
        CashFlowItemInfo cfItem = (CashFlowItemInfo)ui.getData();
        if (cfItem == null) {
            return;
        }
        ICashFlowTAccountFacade iFacade = this.getBizInterface();
        boolean isRefresh = true;
        if (cfItem.getAsstAccount() != null) {
            HashMap<String, Object> saveParam = new HashMap<String, Object>();
            saveParam.put("CashFlowItemInfo", cfItem);
            saveParam.put("currencyInfo", this.condition.getCurrency());
            Map cashflowRecords = this.getBizInterface().getTAccountCashflowInfos(this.condition, info, true);
            saveParam.put("CashflowRecords", cashflowRecords);
            Map result = CashFlowDirectUtil.showVoucherSetCashflowUI((Object)this, saveParam);
            if (result.size() == 0) {
                isRefresh = false;
            }
        } else {
            try {
                Map processResult = iFacade.applyCashflowItem(this.condition, info, cfItem);
                Integer coverFailureCount = processResult.get("coverFailureCount") == null ? 0 : (Integer)processResult.get("coverFailureCount");
                String coverFailureDetail = processResult.get("coverFailureDetail") == null ? "" : (String)processResult.get("coverFailureDetail");
                String msgHeader = this.getResource("set_cashflowitem_success");
                StringBuilder detail = new StringBuilder();
                if (coverFailureCount > 0) {
                    detail.append("uncover_cashflowrecord_count").append("\r\n");
                    detail.append(coverFailureDetail);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)msgHeader, (String)MessageFormat.format(detail.toString(), coverFailureCount), (int)1);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)msgHeader);
                }
            }
            catch (BOSException exception) {
                isRefresh = false;
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.CASHFLOW_ASSIGN_FAILED"), (String)exception.getCause().getMessage(), (int)2);
                SysUtil.abort();
            }
        }
        if (isRefresh) {
            this.refreshCashflow(info, rowIndex);
            this.setStatusBarMessageText(this.getResource("CashflowSaveSuccess"));
        }
    }

    @Override
    public void actionCancelCFItem_actionPerformed(ActionEvent e) throws Exception {
        String cancelCFRFailureDetail;
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return;
        }
        if (info.getAccount() != null && (info.getAccount().isIsBank() || info.getAccount().isIsCash() || info.getAccount().isIsCashEquivalent())) {
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("CashFlowItemRemove")) != 0) {
            return;
        }
        Map processResult = this.getBizInterface().removeCashflowItem(this.condition, info);
        this.refreshCashflow(info, rowIndex);
        this.setStatusBarMessageText(this.getResource("CashflowRemoveSuccess"));
        String msgHeader = this.getResource("cancel_cashflowItem_success");
        StringBuilder detail = new StringBuilder(this.getResource("cancel_cfreq_success"));
        int cancelCFRSuccCount = processResult.get("cancelCFRSuccCount") == null ? 0 : (Integer)processResult.get("cancelCFRSuccCount");
        int cancelCFRFailureCount = processResult.get("cancelCFRFailureCount") == null ? 0 : (Integer)processResult.get("cancelCFRFailureCount");
        String string = cancelCFRFailureDetail = processResult.get("cancelCFRFailureDetail") == null ? "" : (String)processResult.get("cancelCFRFailureDetail");
        if (cancelCFRFailureCount > 0) {
            detail.append(this.getResource("unprocess_cashflowrecord_count")).append(" \r\n");
            detail.append(cancelCFRFailureDetail);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msgHeader, (String)MessageFormat.format(detail.toString(), cancelCFRSuccCount, cancelCFRFailureCount), (int)1);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msgHeader, (String)MessageFormat.format(detail.toString(), cancelCFRSuccCount), (int)1);
        }
    }

    @Override
    public void actionCloseExpand_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        this.backItem(rowIndex);
    }

    @Override
    public void actionShowNotCFVoucher_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return;
        }
        Set voucherIdSet = this.getBizInterface().getUnAssignedCFIVoucherIds(this.condition, info);
        if (voucherIdSet.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"44_CashFlowDirectUI"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        ArrayList list = new ArrayList();
        list.addAll(voucherIdSet);
        uiContext.put((Object)"IDList", list);
        uiContext.put((Object)"change", (Object)list.toString());
        CashFlowListUI.showCashFlowList(this.condition, (Map)uiContext);
    }

    @Override
    public void actionShowVoucher_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return;
        }
        Map result = this.getBizInterface().getVoucherIdsTemp(this.condition, info);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isCashFlowT", (Object)true);
        uiContext.put((Object)"originalVoucherTable", result.get("originalVoucherTable"));
        uiContext.put((Object)"oVTableCounts", result.get("oVTableCounts"));
        uiContext.put((Object)"maxReturnRowCount", (Object)Integer.MAX_VALUE);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherListUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionAssignCashFlowItem_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.ktbCashflow.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        CashflowTAccountInfo info = this.getSelectedCFTAccountInfo(rowIndex);
        if (info == null) {
            return;
        }
        Map cashflowRecords = this.getBizInterface().getTAccountCashflowInfos(this.condition, info, false);
        if (cashflowRecords.size() > 0) {
            HashMap<String, Object> saveParam = new HashMap<String, Object>();
            saveParam.put("CashflowRecords", cashflowRecords);
            saveParam.put("currencyInfo", this.condition.getCurrency());
            saveParam.put("action", "assignCashFlowItem");
            Map result = CashFlowDirectUtil.showVoucherSetCashflowUI((Object)this, saveParam);
            if (result.size() > 0) {
                this.refreshCashflow(info, rowIndex);
                this.setStatusBarMessageText(this.getResource("CashflowSaveSuccess"));
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"47_CashFlowDirectUI"));
            return;
        }
    }

    @Override
    public void actionAppDefCashItem_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appDefCashItem"));
        if (result == 2) {
            return;
        }
        boolean isCover = false;
        if (result == 0) {
            isCover = true;
        }
        try {
            Map processResult = this.getBizInterface().applyDefaultCashflowItem(this.condition, isCover);
            int sendSuccCount = processResult.get("sendSuccCount") == null ? 0 : (Integer)processResult.get("sendSuccCount");
            boolean enableSendCFR = processResult.get("enableSendCFR") == null ? true : (Boolean)processResult.get("enableSendCFR");
            String msgHeader = this.getResource("defalutApply_success");
            StringBuilder detail = new StringBuilder(this.getResource("cfreq_send_successed"));
            if (enableSendCFR) {
                if (isCover) {
                    int coverFailureCount = processResult.get("coverFailureCount") == null ? 0 : (Integer)processResult.get("coverFailureCount");
                    detail.append(this.getResource("uncovered_cashflow_count")).append("\r\n");
                    detail.append(processResult.get("coverFailureDetail") == null ? "" : (String)processResult.get("coverFailureDetail"));
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)msgHeader, (String)MessageFormat.format(detail.toString(), sendSuccCount, coverFailureCount), (int)1);
                } else {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)msgHeader, (String)MessageFormat.format(detail.toString(), sendSuccCount), (int)1);
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)msgHeader);
            }
        }
        catch (BOSException exception) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.CASHFLOW_APPLY_FAILED"), (String)exception.getCause().getMessage(), (int)2);
            SysUtil.abort();
        }
        this.actionRefresh_actionPerformed(null);
        this.setStatusBarMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.appMainCashSuccess"));
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected RptParams getParamsForInit() {
        RptParams pp = new RptParams();
        pp.setObject("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return pp;
    }

    private void refreshCashflow(CashflowTAccountInfo info, int rowIndex) throws EASBizException, BOSException {
        int expandRowIndex = rowIndex;
        if (info.getType() == 4) {
            expandRowIndex = this.getParentRowIndex(rowIndex);
        }
        this.backItem(expandRowIndex);
        this.expand(expandRowIndex, 4);
    }

    private void setStatusBarMessageText(String msg) {
        this.setMessageText(msg);
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    public CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new CashFlowDirectConditionUI();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return CashFlowTAccountFacadeFactory.getRemoteInstance();
    }

    public String getResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)resKey);
    }

    protected ICashFlowTAccountFacade getBizInterface() throws BOSException {
        return CashFlowTAccountFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.ktbCashflow;
    }

    protected Map preparePrintVariantMap() {
        Map map = super.preparePrintVariantMap();
        map.put("Currency", this.kdTxtCurrency.getText());
        map.put("Period", this.kdLabelPeriod.getBoundLabelText() + ":" + this.kdTxtPeriod.getText());
        return map;
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    protected void queryWithWrap() {
        super.queryWithWrap();
    }
}

