/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.util.CashflowF7Util;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashflowAdjustFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowAdjustFacade;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractCashflowAdjustEditUI;
import com.kingdee.eas.fi.gl.client.CashflowEditUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CashflowAdjustEditUI
extends AbstractCashflowAdjustEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CashflowAdjustEditUI.class);
    protected boolean foreignCurrencySU;
    protected boolean useReportingCurrency;
    protected CurrencyInfo localCurrency;
    protected CurrencyInfo reportingCurrency;
    protected VoucherInfo.ExchangeRateWithValue localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
    protected int amountRoundMode;
    protected KDTDefaultCellEditor numberEditor;
    protected CashflowEditUI parentUI;
    protected CashflowFlag cfFlag;
    protected VoucherInfo vch;
    private String vchID;
    protected Vector accountVec;
    static final String CF_ENTRY = "entry";
    static final String CF_DC = "dc";
    static final String CF_CURRENCY = "currency";
    static final String CF_AMNT = "amount";
    static final String CF_LA = "localAmount";
    static final String CF_RA = "reportingAmount";
    static final String CF_ITEM = "item";
    static final String CF_ITEM_AMNT = "itemAmount";
    static final String CF_ITEM_LOCAL_AMNT = "itemLocalAmount";
    static final String CF_ITEM_REPORT_AMNT = "itemReportAmount";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.CashflowEditResource";
    public static final String VOUCHER = "VOUCHER";
    public boolean isOK = false;
    boolean isView;

    public void onLoad() throws Exception {
        this.btn_autoSplit.setVisible(false);
        super.onLoad();
        this.btnAddLine.setText(null);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.fetchInitData();
        if (this.isView) {
            this.btnAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
        }
        this.initTableStyle();
        VoucherEntryCollection col = this.getVoucher(this.vchID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        CompanyOrgUnitInfo company = GlUtils.getCompanyById(null, companyID);
        this.localCurrency = company.getBaseCurrency();
        this.reportingCurrency = company.getReportCurrency();
        this.loadCfEntry(col);
        KDComboBox combo = new KDComboBox(this.accountVec);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CfVoucherEntryWrapper vEntry;
                int rowindex = CashflowAdjustEditUI.this.kdtEntries.getSelectManager().getActiveRowIndex();
                int colindex = CashflowAdjustEditUI.this.kdtEntries.getSelectManager().getActiveColumnIndex();
                if (rowindex != -1 && colindex == 0 && (vEntry = (CfVoucherEntryWrapper)e.getItem()) != null) {
                    CashflowAdjustEditUI.this.kdtEntries.getCell(rowindex, colindex + 1).setValue((Object)vEntry.getEntry().getEntryDC());
                    CashflowAdjustEditUI.this.kdtEntries.getCell(rowindex, colindex + 2).setValue((Object)vEntry.getEntry().getCurrency());
                    CashflowAdjustEditUI.this.kdtEntries.getRow(rowindex).setUserObject((Object)vEntry.getEntry());
                }
            }
        });
        KDTDefaultCellEditor comboBoxEditor = new KDTDefaultCellEditor((JComboBox)combo);
        IColumn entryCol = this.kdtEntries.getColumn(CF_ENTRY);
        entryCol.setEditor((ICellEditor)comboBoxEditor);
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent evt) {
                int rowIndex = evt.getRowIndex();
                int colIndex = evt.getColIndex();
                String colKey = CashflowAdjustEditUI.this.kdtEntries.getColumnKey(colIndex);
                KDFormattedTextField numberField = (KDFormattedTextField)CashflowAdjustEditUI.this.numberEditor.getComponent();
                if (CashflowAdjustEditUI.CF_ITEM_AMNT.equals(colKey)) {
                    VoucherEntryInfo entry = (VoucherEntryInfo)CashflowAdjustEditUI.this.kdtEntries.getRow(rowIndex).getUserObject();
                    if (entry != null) {
                        CurrencyInfo currency = entry.getCurrency();
                        int prec = currency.getPrecision();
                        numberField.setPrecision(prec);
                    }
                } else if (CashflowAdjustEditUI.CF_ITEM_LOCAL_AMNT.equals(colKey)) {
                    numberField.setPrecision(CashflowAdjustEditUI.this.localCurrency.getPrecision());
                } else if (CashflowAdjustEditUI.CF_ITEM_REPORT_AMNT.equals(colKey) && CashflowAdjustEditUI.this.useReportingCurrency) {
                    numberField.setPrecision(CashflowAdjustEditUI.this.reportingCurrency.getPrecision());
                }
            }

            public void editStopped(KDTEditEvent e) {
                VoucherEntryInfo entry;
                int row = e.getRowIndex();
                int col = e.getColIndex();
                String fieldName = CashflowAdjustEditUI.this.kdtEntries.getColumn(col).getKey();
                if (CashflowAdjustEditUI.CF_ITEM_AMNT.equals(fieldName) && (entry = (VoucherEntryInfo)CashflowAdjustEditUI.this.kdtEntries.getRow(row).getUserObject()) != null) {
                    CurrencyInfo currency = entry.getCurrency();
                    Object[] exes = GlUtils.getExchangeRate(null, SysContext.getSysContext().getCurrentFIUnit(), currency.getId().toString(), null);
                    VoucherInfo.ExchangeRateWithValue lex = null;
                    VoucherInfo.ExchangeRateWithValue rex = null;
                    if (exes != null) {
                        lex = (VoucherInfo.ExchangeRateWithValue)exes[0];
                        rex = (VoucherInfo.ExchangeRateWithValue)exes[1];
                    }
                    if (lex != null) {
                        CashflowAdjustEditUI.this.kdtEntries.getCell(row, col + 1).setValue((Object)((BigDecimal)e.getValue()).multiply(lex.getValue()).setScale(CashflowAdjustEditUI.this.localCurrency.getPrecision(), 4));
                    } else {
                        CashflowAdjustEditUI.this.kdtEntries.getCell(row, col + 1).setValue(e.getValue());
                    }
                    if (CashflowAdjustEditUI.this.useReportingCurrency) {
                        if (rex != null) {
                            CashflowAdjustEditUI.this.kdtEntries.getCell(row, col + 2).setValue((Object)((BigDecimal)e.getValue()).multiply(rex.getValue()).setScale(CashflowAdjustEditUI.this.reportingCurrency.getPrecision(), 4));
                        } else {
                            CashflowAdjustEditUI.this.kdtEntries.getCell(row, col + 2).setValue(e.getValue());
                        }
                    }
                }
            }
        });
    }

    protected void loadCfEntry(VoucherEntryCollection col) {
        this.accountVec = new Vector();
        for (int i = 0; i < col.size(); ++i) {
            CashflowRecordInfo cash;
            int j;
            VoucherEntryInfo entry = col.get(i);
            CurrencyInfo cur = entry.getCurrency();
            CfVoucherEntryWrapper cfEntry = new CfVoucherEntryWrapper(entry);
            this.accountVec.add(cfEntry);
            CashflowRecordCollection cashCol = entry.getCashflowRecords();
            boolean hasAdjust = false;
            if (cashCol != null && cashCol.size() != 0) {
                for (j = 0; j < cashCol.size(); ++j) {
                    cash = cashCol.get(j);
                    if (!ItemFlag.ADJUST.equals((Object)cash.getItemFlag())) continue;
                    hasAdjust = true;
                    break;
                }
            }
            if (hasAdjust) {
                for (j = 0; j < cashCol.size(); ++j) {
                    cash = cashCol.get(j);
                    if (!ItemFlag.ADJUST.equals((Object)cash.getItemFlag())) continue;
                    IRow row = this.kdtEntries.addRow();
                    row.setUserObject((Object)entry);
                    row.getCell(CF_ENTRY).setValue((Object)cfEntry);
                    row.getCell(CF_DC).setValue((Object)entry.getEntryDC());
                    row.getCell(CF_CURRENCY).setValue((Object)cur);
                    row.getCell(CF_AMNT).setValue((Object)GlUtils.setScale(entry.getOriginalAmount(), cur.getPrecision()));
                    row.getCell(CF_LA).setValue((Object)GlUtils.setScale(entry.getLocalAmount(), this.localCurrency.getPrecision()));
                    BigDecimal supCoeffient = new BigDecimal(String.valueOf(cash.getSupplementaryCoefficient()));
                    if (this.useReportingCurrency) {
                        row.getCell(CF_RA).setValue((Object)GlUtils.setScale(entry.getReportingAmount(), this.reportingCurrency.getPrecision()));
                        row.getCell(CF_ITEM_REPORT_AMNT).setValue((Object)GlUtils.setScale(cash.getReportingAmount().multiply(supCoeffient), this.reportingCurrency.getPrecision()));
                    } else if (row.getCell(CF_RA) != null) {
                        row.getCell(CF_RA).getStyleAttributes().setHided(true);
                    }
                    row.getCell(CF_ITEM).setValue((Object)cash.getSupplementaryItem());
                    row.getCell(CF_ITEM_AMNT).setValue((Object)GlUtils.setScale(cash.getOriginalAmount().multiply(supCoeffient), cur.getPrecision()));
                    row.getCell(CF_ITEM_LOCAL_AMNT).setValue((Object)GlUtils.setScale(cash.getLocalAmount().multiply(supCoeffient), this.localCurrency.getPrecision()));
                    this.setRowStyleAbbributes(cur, row);
                }
                continue;
            }
            IRow row = this.kdtEntries.addRow();
            BigDecimal amount = GlUtils.setScale(entry.getOriginalAmount(), cur.getPrecision());
            BigDecimal localAmount = GlUtils.setScale(entry.getLocalAmount(), this.localCurrency.getPrecision());
            boolean isDebit = entry.getEntryDC().equals((Object)EntryDC.DEBIT);
            row.setUserObject((Object)entry);
            row.getCell(CF_ENTRY).setValue((Object)cfEntry);
            row.getCell(CF_DC).setValue((Object)entry.getEntryDC());
            row.getCell(CF_CURRENCY).setValue((Object)cur);
            row.getCell(CF_AMNT).setValue((Object)amount);
            row.getCell(CF_LA).setValue((Object)localAmount);
            boolean isEdit = Boolean.FALSE.equals(this.getUIContext().get("ISVIEW"));
            row.getCell(CF_ITEM_AMNT).setValue(isEdit ? (isDebit ? amount.negate() : amount) : null);
            row.getCell(CF_ITEM_LOCAL_AMNT).setValue(isEdit ? (isDebit ? localAmount.negate() : localAmount) : null);
            if (this.useReportingCurrency) {
                BigDecimal reportAmount = GlUtils.setScale(entry.getReportingAmount(), this.reportingCurrency.getPrecision());
                row.getCell(CF_RA).setValue((Object)reportAmount);
                row.getCell(CF_ITEM_REPORT_AMNT).setValue(isEdit ? (isDebit ? reportAmount.negate() : reportAmount) : null);
            } else if (row.getCell(CF_RA) != null) {
                row.getCell(CF_RA).getStyleAttributes().setHided(true);
            }
            this.setRowStyleAbbributes(cur, row);
        }
    }

    private void setRowStyleAbbributes(CurrencyInfo cur, IRow row) {
        row.getCell(CF_AMNT).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(cur.getPrecision()));
        row.getCell(CF_ITEM_AMNT).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(cur.getPrecision()));
        row.getCell(CF_LA).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.localCurrency.getPrecision()));
        row.getCell(CF_ITEM_LOCAL_AMNT).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.localCurrency.getPrecision()));
        if (this.useReportingCurrency && row.getCell(CF_RA) != null) {
            row.getCell(CF_RA).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.reportingCurrency.getPrecision()));
        }
        if (this.useReportingCurrency && row.getCell(CF_ITEM_REPORT_AMNT) != null) {
            row.getCell(CF_ITEM_REPORT_AMNT).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.reportingCurrency.getPrecision()));
        }
    }

    private VoucherEntryCollection getVoucher(String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("bill", (Object)id));
        fic.add(new FilterItemInfo("account.isCash", (Object)Boolean.FALSE));
        fic.add(new FilterItemInfo("account.isBank", (Object)Boolean.FALSE));
        fic.add(new FilterItemInfo("account.isCashEquivalent", (Object)Boolean.FALSE));
        fic.add(new FilterItemInfo("account.PLType", (Object)new Integer("0")));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("cashflowRecords.*"));
        sic.add(new SelectorItemInfo("cashflowRecords.supplementaryItem.*"));
        sic.add(new SelectorItemInfo("bill.entryCount"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("seq"));
        VoucherEntryCollection vchCol = VoucherEntryFactory.getRemoteInstance().getVoucherEntryCollection(view);
        if (vchCol.size() > 0 && vchCol.get(0).getBill().getEntryCount() != vchCol.size()) {
            EntityViewInfo cfView = new EntityViewInfo();
            SelectorItemCollection cfSic = cfView.getSelector();
            cfSic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
            FilterInfo cfFilter = new FilterInfo();
            cfView.setFilter(cfFilter);
            FilterItemCollection cfFic = cfFilter.getFilterItems();
            cfFic.add(new FilterItemInfo("voucher.id", (Object)id));
            cfFic.add(new FilterItemInfo("itemFlag", (Object)new Integer(1), CompareType.EQUALS));
            cfFic.add(new FilterItemInfo("itemFlag", (Object)new Integer(2), CompareType.EQUALS));
            cfFic.add(new FilterItemInfo("itemFlag", (Object)new Integer(3), CompareType.EQUALS));
            cfFic.add(new FilterItemInfo("opposingAccountEntry.account.PLType", (Object)new Integer(0), CompareType.EQUALS));
            cfFilter.setMaskString("#0 and (#1 or #2 or #3) and #4");
            CashflowRecordCollection cfCol = CashflowRecordFactory.getRemoteInstance().getCashflowRecordCollection(cfView);
            if (cfCol != null && cfCol.size() > 0) {
                int entrySize = vchCol.size();
                int cfSize = cfCol.size();
                block0: for (int i = 0; i < cfSize; ++i) {
                    CashflowRecordInfo cfRecord = cfCol.get(i);
                    for (int j = 0; j < entrySize; ++j) {
                        VoucherEntryInfo entry = vchCol.get(j);
                        if (!entry.getId().equals((Object)cfRecord.getOpposingAccountEntry().getId())) continue;
                        if (cfRecord.getEntry().getEntryDC().equals((Object)cfRecord.getOpposingAccountEntry().getEntryDC())) {
                            entry.setOriginalAmount(GlUtils.add(entry.getOriginalAmount(), cfRecord.getOriginalAmount()));
                            entry.setLocalAmount(GlUtils.add(entry.getLocalAmount(), cfRecord.getLocalAmount()));
                            entry.setReportingAmount(GlUtils.add(entry.getReportingAmount(), cfRecord.getReportingAmount()));
                            continue block0;
                        }
                        entry.setOriginalAmount(GlUtils.substract(entry.getOriginalAmount(), cfRecord.getOriginalAmount()));
                        entry.setLocalAmount(GlUtils.substract(entry.getLocalAmount(), cfRecord.getLocalAmount()));
                        entry.setReportingAmount(GlUtils.substract(entry.getReportingAmount(), cfRecord.getReportingAmount()));
                        continue block0;
                    }
                }
            }
        }
        Iterator it = vchCol.iterator();
        while (it.hasNext()) {
            VoucherEntryInfo entry = (VoucherEntryInfo)it.next();
            if (entry.getLocalAmount() != null && GlUtils.zero.compareTo(entry.getLocalAmount()) != 0) continue;
            it.remove();
        }
        return vchCol;
    }

    protected void fetchInitData() throws GLException {
        Map ctx = this.getUIContext();
        this.useReportingCurrency = (Boolean)ctx.get("USERREPORT");
        this.vchID = (String)ctx.get(VOUCHER);
        this.isView = (Boolean)ctx.get("ISVIEW");
    }

    protected void initTableStyle() {
        this.kdtEntries.checkParsed();
        this.kdtEntries.getStyleAttributes().setLocked(this.isView);
        this.kdtEntries.getSelectManager().setSelectMode(1);
        this.kdtEntries.getStyleAttributes().setWrapText(true);
        IColumn dcCol = this.kdtEntries.getColumn(CF_DC);
        IColumn curCol = this.kdtEntries.getColumn(CF_CURRENCY);
        IColumn amntCol = this.kdtEntries.getColumn(CF_AMNT);
        IColumn laCol = this.kdtEntries.getColumn(CF_LA);
        IColumn raCol = this.kdtEntries.getColumn(CF_RA);
        IColumn itemCol = this.kdtEntries.getColumn(CF_ITEM);
        IColumn itemAmntCol = this.kdtEntries.getColumn(CF_ITEM_AMNT);
        IColumn itemAmntLocalCol = this.kdtEntries.getColumn(CF_ITEM_LOCAL_AMNT);
        IColumn itemAmntReportCol = this.kdtEntries.getColumn(CF_ITEM_REPORT_AMNT);
        dcCol.getStyleAttributes().setLocked(true);
        curCol.getStyleAttributes().setLocked(true);
        amntCol.getStyleAttributes().setLocked(true);
        laCol.getStyleAttributes().setLocked(true);
        raCol.getStyleAttributes().setLocked(true);
        amntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        laCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        raCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        itemAmntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        itemAmntLocalCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        itemAmntReportCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (this.foreignCurrencySU) {
            String amount = EASResource.getString((String)RESOURCE_PATH, (String)CF_AMNT);
            amntCol.getStyleAttributes().setHided(true);
            raCol.getStyleAttributes().setHided(true);
            IRow header = this.kdtEntries.getHeadRow(0);
            header.getCell(CF_LA).setValue((Object)amount);
        } else if (!this.useReportingCurrency) {
            raCol.getStyleAttributes().setHided(true);
            itemAmntReportCol.getStyleAttributes().setHided(true);
        }
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setDataVerifierType(-1);
        formattedTextField.setSupportedEmpty(true);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.numberEditor.setClickCountToStart(1);
        itemAmntCol.setEditor((ICellEditor)this.numberEditor);
        itemAmntLocalCol.setEditor((ICellEditor)this.numberEditor);
        itemAmntReportCol.setEditor((ICellEditor)this.numberEditor);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        KDBizPromptBox bizSiPromptBox = new KDBizPromptBox();
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("type", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
        CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizSiPromptBox, (FilterInfo)filter, (CoreUIObject)this);
        itemCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizSiPromptBox));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isView) {
            this.destroyWindow();
            return;
        }
        ICashflowAdjustFacade adjustFacade = CashflowAdjustFacadeFactory.getRemoteInstance();
        CashflowRecordCollection col = new CashflowRecordCollection();
        BigDecimal sum = GlUtils.zero;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            BigDecimal report;
            BigDecimal local;
            BigDecimal amount;
            VoucherEntryInfo entry;
            IRow row = this.kdtEntries.getRow(i);
            CashflowRecordInfo record = new CashflowRecordInfo();
            CashFlowItemInfo item = (CashFlowItemInfo)row.getCell(CF_ITEM).getValue();
            if (item != null) {
                entry = (VoucherEntryInfo)row.getUserObject();
                if (entry == null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"212_CashflowAdjustEditUI"));
                    return;
                }
                amount = (BigDecimal)row.getCell(CF_ITEM_AMNT).getValue();
                local = (BigDecimal)row.getCell(CF_ITEM_LOCAL_AMNT).getValue();
                report = (BigDecimal)row.getCell(CF_ITEM_REPORT_AMNT).getValue();
                if (amount == null) {
                    amount = GlUtils.zero;
                }
                if (local == null) {
                    local = amount;
                }
                if (report == null) {
                    report = amount;
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"210_CashflowAdjustEditUI"));
                return;
            }
            sum = sum.add(local);
            record.setOriginalAmount(amount);
            record.setLocalAmount(local);
            record.setReportingAmount(report);
            record.setSupplementaryCoefficient(1);
            record.setSupplementaryItem(item);
            record.setVoucher(entry.getBill());
            record.setEntry(entry);
            record.setAccount(entry.getAccount());
            record.setCurrency(entry.getCurrency());
            record.setEntryDC(entry.getEntryDC());
            record.setOpposingAccountEntry(entry);
            record.setOppAccount(entry.getAccount());
            record.setOppEntryDC(entry.getEntryDC());
            record.setItemFlag(ItemFlag.ADJUST);
            col.add(record);
        }
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("vchid", this.vchID);
        if (sum.signum() == 0) {
            adjustFacade.saveAdjustCashflowRecords((IObjectCollection)col, mapParam);
            this.isOK = true;
            this.destroyWindow();
        } else {
            MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"211_CashflowAdjustEditUI"));
        }
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancelAction_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionAutoSplit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.addRow();
        super.actionAddLine_actionPerformed(e);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.addRow(this.kdtEntries.getSelectManager().getActiveRowIndex());
        super.actionInsertLine_actionPerformed(e);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.removeRow(this.kdtEntries.getSelectManager().getActiveRowIndex());
        super.actionRemoveLine_actionPerformed(e);
    }

    static class CfVoucherEntryWrapper {
        private VoucherEntryInfo entry;

        public CfVoucherEntryWrapper(VoucherEntryInfo ent) {
            this.entry = ent;
        }

        public VoucherEntryInfo getEntry() {
            return this.entry;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            if (this.entry != null) {
                AccountViewInfo acc = this.entry.getAccount();
                sb.append(acc.getNumber());
                sb.append(" ");
                sb.append(acc.getName());
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CfVoucherEntryWrapper)) {
                return false;
            }
            CfVoucherEntryWrapper entryWrapper = (CfVoucherEntryWrapper)obj;
            return this.entry == entryWrapper.getEntry();
        }
    }
}

