/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractCashflowEditDiposeUI;
import com.kingdee.eas.fi.gl.client.CashflowEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CashflowEditDiposeUI
extends AbstractCashflowEditDiposeUI {
    private static final Logger logger = CoreUIObject.getLogger(CashflowEditDiposeUI.class);
    protected boolean foreignCurrencySU;
    protected boolean useReportingCurrency;
    protected CurrencyInfo localCurrency;
    protected CurrencyInfo reportingCurrency;
    protected VoucherInfo.ExchangeRateWithValue localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
    protected int amountRoundMode;
    protected KDTDefaultCellEditor numberEditor;
    protected KDTDefaultCellEditor laNumberEditor;
    protected KDTDefaultCellEditor raNumberEditor;
    private boolean isSettleByLocal;
    protected boolean collectSameAccount = false;
    private int curCfEntryIndex;
    protected CashflowEditUI parentUI;
    protected CashflowFlag cfFlag;
    protected VoucherInfo vch;
    private boolean isSupDipose;
    BigDecimal dataBaseCredit = null;
    BigDecimal dataBaseDebit = null;
    CashflowRecordCollection oldCfCol = null;
    private boolean isAllCommon = true;
    CfEntryEditAdapter cfEntryEditLs = new CfEntryEditAdapter();
    CfEntrySwitchListener cfEntrySwitchLs = new CfEntrySwitchListener();
    private CashflowRecordCollection cfCol;
    private int returnValue = 1;
    private boolean hasChange = false;

    @Override
    public void storeFields() {
        super.storeFields();
        IRow row = this.kdtEntries.getRow(this.curCfEntryIndex);
        CfEntryData ed = (CfEntryData)row.getUserObject();
        this.storeCfEntry(ed, row);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.setReturnValue(1);
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasChange) {
            this.destroyWindow();
            return;
        }
        this.beforeStoreFields(e);
        this.storeFields();
        if (this.checkDataObject()) {
            this.setResult(this.buildResult());
            this.setReturnValue(0);
            this.destroyWindow();
        }
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        CashflowRecordCollection result = new CashflowRecordCollection();
        this.setResult(result);
        this.setReturnValue(0);
        this.destroyWindow();
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        this.setReturnValue(1);
        this.destroyWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.fetchInitData();
        this.initTableStyle();
        this.loadFields();
        this.setReturnValue(1);
        this.btnCancel.setEnabled(true);
        this.btnClear.setEnabled(true);
    }

    @Override
    public void loadFields() {
        this.detachListeners();
        Map uiContext = this.getUIContext();
        Vector oeCol = (Vector)uiContext.get("CfEntryData");
        CashflowRecordCollection cfCol = (CashflowRecordCollection)uiContext.get("CashflowRecordCollection");
        if (cfCol != null) {
            this.oldCfCol = (CashflowRecordCollection)cfCol.clone();
        }
        ArrayList<CfEntryData> listCfEntryData = new ArrayList<CfEntryData>();
        if (cfCol != null && cfCol.size() > 0) {
            for (CashflowRecordInfo rec : cfCol) {
                VoucherEntryInfo entry = this.getEntry(rec);
                rec.setEntry(entry);
                CfEntryData cfed = new CfEntryData(entry, rec.getOriginalAmount(), rec.getLocalAmount(), rec.getReportingAmount());
                listCfEntryData.add(cfed);
            }
            if (this.collectSameAccount) {
                for (VoucherEntryInfo ed : oeCol) {
                    Iterator itr = cfCol.iterator();
                    boolean hasLoad = false;
                    while (itr.hasNext()) {
                        CashflowRecordInfo rec = (CashflowRecordInfo)itr.next();
                        VoucherEntryInfo entry = rec.getEntry();
                        if (entry.getSeq() != ed.getSeq()) continue;
                        hasLoad = true;
                    }
                    if (hasLoad) continue;
                    CfEntryData cfed = new CfEntryData(ed);
                    listCfEntryData.add(cfed);
                }
            }
        } else {
            for (VoucherEntryInfo ed : oeCol) {
                CfEntryData cfed = new CfEntryData(ed);
                listCfEntryData.add(cfed);
            }
        }
        Object[] obj = listCfEntryData.toArray();
        int size = obj.length;
        listCfEntryData = new ArrayList();
        if (size > 0) {
            int i;
            for (i = 0; i < size; ++i) {
                CfEntryData cfed = (CfEntryData)obj[i];
                int seqPre = cfed.getEntry().getSeq();
                for (int j = i + 1; j < size; ++j) {
                    CfEntryData cfednew = (CfEntryData)obj[j];
                    int seqnew = cfednew.getEntry().getSeq();
                    if (seqPre <= seqnew) continue;
                    CfEntryData temp = cfed;
                    obj[i] = cfednew;
                    cfed = cfednew;
                    seqPre = cfed.getEntry().getSeq();
                    obj[j] = temp;
                }
            }
            for (i = 0; i < size; ++i) {
                CfEntryData info = (CfEntryData)obj[i];
                listCfEntryData.add(info);
            }
        }
        int count = listCfEntryData.size();
        for (int i = 0; i < count; ++i) {
            CfEntryData cfed = (CfEntryData)listCfEntryData.get(i);
            if (this.isAllCommon && !cfed.getEntry().getCurrency().getId().equals((Object)this.localCurrency.getId())) {
                this.isAllCommon = false;
            }
            IRow row = this.kdtEntries.addRow();
            this.loadCfEntry(cfed, row);
        }
        if (this.isAllCommon) {
            this.kdtEntries.getColumn("amount").getStyleAttributes().setLocked(true);
        }
        this.attachListeners();
    }

    protected VoucherEntryInfo getEntry(CashflowRecordInfo rec) {
        VoucherEntryInfo entry = null;
        int count = this.vch.getEntries().size();
        for (int i = 0; i < count && (entry = this.vch.getEntries().get(i)).getSeq() != rec.getEntry().getSeq(); ++i) {
        }
        return entry;
    }

    protected void detachListeners() {
        this.kdtEntries.removeKDTActiveCellListener((KDTActiveCellListener)this.cfEntrySwitchLs);
        this.kdtEntries.removeKDTEditListener((KDTEditListener)this.cfEntryEditLs);
    }

    protected void attachListeners() {
        this.kdtEntries.addKDTActiveCellListener((KDTActiveCellListener)this.cfEntrySwitchLs);
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.cfEntryEditLs);
    }

    protected void afterSelectCfEntry(CfEntryData ed) {
    }

    protected void loadCfEntry(CfEntryData ed, IRow row) {
        VoucherEntryInfo entry = ed.getEntry();
        CurrencyInfo cur = entry.getCurrency();
        row.getCell("entry").setValue((Object)new CashflowEditUI.CfVoucherEntryWrapper(entry, null));
        row.getCell("dc").setValue((Object)entry.getEntryDC());
        row.getCell("currency").setValue((Object)cur);
        StringBuffer prec = new StringBuffer();
        for (int i = 0; i < cur.getPrecision(); ++i) {
            prec.append("0");
        }
        StringBuffer laPrec = new StringBuffer();
        for (int i = 0; i < this.localCurrency.getPrecision(); ++i) {
            laPrec.append("0");
        }
        row.getCell("amount").getStyleAttributes().setNumberFormat("%r{#,##0." + prec.toString() + "}f");
        row.getCell("amount").setValue((Object)GlUtils.setScale(ed.getAmount(), cur.getPrecision()));
        row.getCell("localAmount").setValue((Object)GlUtils.setScale(ed.getLocalAmount(), this.localCurrency.getPrecision()));
        row.getCell("localAmount").getStyleAttributes().setNumberFormat("%r{#,##0." + laPrec.toString() + "}f");
        if (this.useReportingCurrency) {
            StringBuffer rpPrec = new StringBuffer();
            for (int i = 0; i < this.localCurrency.getPrecision(); ++i) {
                rpPrec.append("0");
                row.getCell("reportingAmount").getStyleAttributes().setNumberFormat("%r{#,##0." + rpPrec.toString() + "}f");
            }
            row.getCell("reportingAmount").setValue((Object)GlUtils.setScale(ed.getReportingAmount(), this.reportingCurrency.getPrecision()));
        } else if (row.getCell("reportingAmount") != null) {
            row.getCell("reportingAmount").getStyleAttributes().setHided(true);
        }
        row.setUserObject((Object)ed);
    }

    protected void initTableStyle() {
        this.kdtEntries.checkParsed();
        this.kdtEntries.getStyleAttributes().setLocked(false);
        this.kdtEntries.getSelectManager().setSelectMode(1);
        this.kdtEntries.getStyleAttributes().setWrapText(true);
        IColumn entryCol = this.kdtEntries.getColumn("entry");
        IColumn curCol = this.kdtEntries.getColumn("currency");
        IColumn amntCol = this.kdtEntries.getColumn("amount");
        IColumn laCol = this.kdtEntries.getColumn("localAmount");
        IColumn raCol = this.kdtEntries.getColumn("reportingAmount");
        entryCol.getStyleAttributes().setLocked(true);
        curCol.getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("dc").getStyleAttributes().setLocked(true);
        amntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        laCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        raCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (this.foreignCurrencySU) {
            String amount = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"amount");
            amntCol.getStyleAttributes().setHided(true);
            raCol.getStyleAttributes().setHided(true);
            IRow header = this.kdtEntries.getHeadRow(0);
            header.getCell("localAmount").setValue((Object)amount);
        } else if (!this.useReportingCurrency) {
            raCol.getStyleAttributes().setHided(true);
        }
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setDataVerifierType(-1);
        formattedTextField.setSupportedEmpty(true);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.numberEditor.setClickCountToStart(1);
        this.laNumberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.laNumberEditor.setClickCountToStart(1);
        this.raNumberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.raNumberEditor.setClickCountToStart(1);
        amntCol.setEditor((ICellEditor)this.numberEditor);
        laCol.setEditor((ICellEditor)this.numberEditor);
        raCol.setEditor((ICellEditor)this.numberEditor);
    }

    protected CurrencyInfo getOriginalCurrency(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.kdtEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getCurrency();
    }

    protected VoucherInfo.ExchangeRateWithValue getLocalExDefinition(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.kdtEntries.getRow(rowIndex).getUserObject();
        VoucherInfo.ExchangeRateWithValue ex = (VoucherInfo.ExchangeRateWithValue)this.parentUI.getExchangeRate().get(this.localCurrency.getId().toString());
        String srcCurrencyId = ed.getEntry().getCurrency().getId().toString();
        if (ex == null) {
            this.parentUI.getExLocal(srcCurrencyId);
        }
        ex = (VoucherInfo.ExchangeRateWithValue)this.parentUI.getExchangeRate().get(srcCurrencyId + this.localCurrency.getId().toString());
        return ex;
    }

    protected VoucherInfo.ExchangeRateWithValue getReportingExDefinition(int rowIndex) {
        if (this.reportingCurrency == null) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        CfEntryData ed = (CfEntryData)this.kdtEntries.getRow(rowIndex).getUserObject();
        VoucherInfo.ExchangeRateWithValue ex = (VoucherInfo.ExchangeRateWithValue)this.parentUI.getExchangeRate().get(this.reportingCurrency.getId().toString());
        String srcCurrencyId = ed.getEntry().getCurrency().getId().toString();
        if (ex == null) {
            this.parentUI.getExRpt(srcCurrencyId);
        }
        ex = (VoucherInfo.ExchangeRateWithValue)this.parentUI.getExchangeRate().get(srcCurrencyId + this.reportingCurrency.getId().toString());
        return ex;
    }

    protected BigDecimal getLocalExValue(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.kdtEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getLocalExchangeRate();
    }

    protected BigDecimal getReportingExValue(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.kdtEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getReportingExchangeRate();
    }

    protected void fetchInitData() throws GLException {
        Map ctx = this.getUIContext();
        this.isSettleByLocal = (Boolean)ctx.get("ISSETTLEBYLOCAL");
        this.foreignCurrencySU = (Boolean)ctx.get("FOREIGNCURRENCYSU");
        this.useReportingCurrency = (Boolean)ctx.get("USEREPORTINGCURRENCY");
        this.localCurrency = (CurrencyInfo)ctx.get("LOCALCURRENCY");
        this.reportingCurrency = (CurrencyInfo)ctx.get("REPORTINGCURRENCY");
        this.amountRoundMode = (Integer)ctx.get("AMOUNT_ROUND_MODE");
        this.parentUI = (CashflowEditUI)((Object)ctx.get("PARENTUI"));
        this.vch = (VoucherInfo)ctx.get("VOUCHER");
        this.isSupDipose = (Boolean)ctx.get("isSelectTabSup");
        this.dataBaseDebit = (BigDecimal)ctx.get("BaseDebit");
        this.dataBaseCredit = (BigDecimal)ctx.get("BaseCredit");
        this.localToRpt = (VoucherInfo.ExchangeRateWithValue)ctx.get("LOCALTORPT");
        Boolean collectSame = (Boolean)ctx.get("SAMECOLLECT");
        if (collectSame != null) {
            this.collectSameAccount = collectSame;
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        KDTEditManager em = this.kdtEntries.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
            if (em.isEditing()) {
                SysUtil.abort();
            }
        }
    }

    protected boolean checkDataObject() {
        int rowCount = this.kdtEntries.getRowCount();
        BigDecimal sumAmount = GlUtils.zero;
        for (int i = 0; i < rowCount; ++i) {
            IRow cfEntryRow = this.kdtEntries.getRow(i);
            CfEntryData oe = (CfEntryData)cfEntryRow.getUserObject();
            BigDecimal amoumt = (BigDecimal)cfEntryRow.getCell("localAmount").getValue();
            if (amoumt == null) continue;
            EntryDC curdc = oe.getEntry().getEntryDC();
            BigDecimal dc = new BigDecimal(1 - curdc.getValue() * 2);
            sumAmount = sumAmount.add(dc.multiply(amoumt));
        }
        boolean isBalance = true;
        if (sumAmount.doubleValue() != 0.0) {
            isBalance = false;
        }
        if (!isBalance) {
            String beOutBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"NotEqualsCD");
            MsgBox.showWarning((Component)((Object)this), (String)beOutBalance);
            return false;
        }
        return true;
    }

    protected CashflowRecordCollection buildResult() {
        CashflowRecordCollection result = new CashflowRecordCollection();
        int rowCount = this.kdtEntries.getRowCount();
        int seq = 1;
        HashMap<String, VoucherEntryInfo> map = new HashMap<String, VoucherEntryInfo>();
        for (int i = 0; i < rowCount; ++i) {
            CfEntryData oe = (CfEntryData)this.kdtEntries.getRow(i).getUserObject();
            VoucherEntryInfo entry = oe.getEntry();
            String key = String.valueOf(entry.getSeq());
            if (map.containsKey(key)) {
                if (GlUtils.zero.compareTo(oe.getAmount()) == 0 && GlUtils.zero.compareTo(oe.getAmount()) == 0 && GlUtils.zero.compareTo(oe.getReportingAmount()) == 0) {
                    continue;
                }
            } else {
                map.put(key, entry);
            }
            CashflowRecordInfo rec = new CashflowRecordInfo();
            if (entry == null) continue;
            result.add(rec);
            rec.setSeq(seq++);
            rec.setVoucher(this.vch);
            rec.setEntry(entry);
            rec.setAccount(entry.getAccount());
            rec.setCurrency(entry.getCurrency());
            rec.setEntryDC(entry.getEntryDC());
            rec.setOpposingAccountEntry(entry);
            rec.setOppAccount(entry.getAccount());
            rec.setOppEntryDC(entry.getEntryDC());
            rec.setItemFlag(ItemFlag.DISPOSE);
            rec.setIsSupItem(this.isSupDipose);
            if (!this.isSupDipose) {
                rec.setPrimaryCoefficient(1);
            } else {
                rec.setSupplementaryCoefficient(1);
            }
            if (this.foreignCurrencySU) {
                rec.setOriginalAmount(oe.getLocalAmount());
            } else {
                rec.setOriginalAmount(oe.getAmount());
            }
            rec.setLocalAmount(oe.getLocalAmount());
            rec.setReportingAmount(oe.getReportingAmount());
        }
        return result;
    }

    protected void storeCfEntry(CfEntryData ed, IRow row) {
        ICell amntCell = row.getCell("amount");
        ICell raCell = row.getCell("reportingAmount");
        BigDecimal amnt = (BigDecimal)amntCell.getValue();
        BigDecimal la = (BigDecimal)row.getCell("localAmount").getValue();
        BigDecimal ra = (BigDecimal)raCell.getValue();
        if (amnt == null) {
            amnt = GlUtils.zero;
        }
        if (la == null) {
            la = GlUtils.zero;
        }
        if (ra == null) {
            ra = GlUtils.zero;
        }
        if (amnt != null) {
            ed.setAmount(amnt);
            ed.setLocalAmount(la);
            if (this.useReportingCurrency) {
                ed.setReportingAmount(ra);
            } else {
                ed.setReportingAmount(la);
            }
        }
    }

    private BigDecimal getOldDipAmount(VoucherEntryInfo entry) {
        if (this.oldCfCol == null) {
            return GlUtils.zero;
        }
        BigDecimal locamoumt = GlUtils.zero;
        for (CashflowRecordInfo r : this.oldCfCol) {
            VoucherEntryInfo rawEntry = r.getEntry();
            if (entry.getSeq() != rawEntry.getSeq()) continue;
            locamoumt = r.getLocalAmount();
            break;
        }
        return locamoumt;
    }

    private void checkOutAmount(IRow curRow) {
        CfEntryData cfed;
        BigDecimal entryAmount;
        ICell amntCell = curRow.getCell("localAmount");
        BigDecimal amnt = (BigDecimal)amntCell.getValue();
        if (amnt != null && (entryAmount = (cfed = (CfEntryData)curRow.getUserObject()).getEntry().getLocalAmount()).abs().compareTo(amnt) >= 0) {
            int rowCount = this.kdtEntries.getRowCount();
            CfEntryData oe = (CfEntryData)curRow.getUserObject();
            BigDecimal hzAmount = null;
            EntryDC curdc = oe.getEntry().getEntryDC();
            hzAmount = curdc.equals((Object)EntryDC.CREDIT) ? this.dataBaseCredit : this.dataBaseDebit;
            BigDecimal hzcfAmount = GlUtils.zero;
            for (int i = 0; i < rowCount; ++i) {
                IRow cfEntryRow = this.kdtEntries.getRow(i);
                CfEntryData oecf = (CfEntryData)cfEntryRow.getUserObject();
                BigDecimal amoumt = (BigDecimal)cfEntryRow.getCell("localAmount").getValue();
                if (amoumt == null || !oecf.getEntry().getEntryDC().equals((Object)curdc)) continue;
                hzcfAmount = hzcfAmount.add(amoumt);
            }
            if (hzAmount != null && hzAmount.compareTo(hzcfAmount) < 0) {
                String beOutBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"BeOutMaxBalance");
                MsgBox.showWarning((Component)((Object)this), (String)beOutBalance);
                CfEntryData cfednew = new CfEntryData(cfed.getEntry());
                this.loadCfEntry(cfednew, curRow);
            }
        }
    }

    public void setResult(CashflowRecordCollection cf) {
        this.cfCol = cf;
    }

    public CashflowRecordCollection getResult() {
        if (this.cfCol == null) {
            this.cfCol = new CashflowRecordCollection();
        }
        return this.cfCol;
    }

    public void setReturnValue(int rv) {
        this.returnValue = rv;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public CashflowRecordCollection getOldCfCol() {
        return this.oldCfCol;
    }

    public void setOldCfCol(CashflowRecordCollection oldCfCol) {
        this.oldCfCol = oldCfCol;
    }

    static class CfEntryData {
        private VoucherEntryInfo entry;
        private BigDecimal amount;
        private BigDecimal localAmount;
        private BigDecimal reportingAmount;
        private boolean amntEverChanged = false;
        private boolean ramntEverChanged = false;

        public CfEntryData(VoucherEntryInfo ent) {
            this(ent, GlUtils.zero, GlUtils.zero, GlUtils.zero);
        }

        public CfEntryData(VoucherEntryInfo ent, BigDecimal amnt, BigDecimal la, BigDecimal ra) {
            this.entry = ent;
            this.amount = amnt;
            this.localAmount = la;
            this.reportingAmount = ra;
        }

        public void setAmount(BigDecimal amnt) {
            this.amount = amnt;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setLocalAmount(BigDecimal la) {
            this.localAmount = la;
        }

        public BigDecimal getLocalAmount() {
            return this.localAmount;
        }

        public void setReportingAmount(BigDecimal ra) {
            this.reportingAmount = ra;
        }

        public BigDecimal getReportingAmount() {
            return this.reportingAmount;
        }

        public void setAmntEverChanged(boolean changed) {
            this.amntEverChanged = changed;
        }

        public boolean getAmntEverChanged() {
            return this.amntEverChanged;
        }

        public void setRamntEverChanged(boolean changed) {
            this.ramntEverChanged = changed;
        }

        public boolean getRamntEverChanged() {
            return this.ramntEverChanged;
        }

        public VoucherEntryInfo getEntry() {
            return this.entry;
        }

        public void setEntry(VoucherEntryInfo entry) {
            this.entry = entry;
        }
    }

    class CfEntrySwitchListener
    implements KDTActiveCellListener {
        CfEntrySwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent evt) {
            int line;
            int preLine = CashflowEditDiposeUI.this.curCfEntryIndex;
            if (preLine != (line = evt.getRowIndex())) {
                int rowCount = CashflowEditDiposeUI.this.kdtEntries.getRowCount();
                if (preLine >= rowCount) {
                    preLine = -1;
                }
                if (line >= rowCount) {
                    line = -1;
                }
                if (preLine >= 0) {
                    KDTEditManager em = CashflowEditDiposeUI.this.kdtEntries.getEditManager();
                    if (em.isEditing()) {
                        em.stopEditing();
                    }
                    IRow row = CashflowEditDiposeUI.this.kdtEntries.getRow(preLine);
                    CfEntryData ed = (CfEntryData)row.getUserObject();
                    CashflowEditDiposeUI.this.storeCfEntry(ed, row);
                }
                CashflowEditDiposeUI.this.curCfEntryIndex = line;
                if (line >= 0) {
                    IRow row = CashflowEditDiposeUI.this.kdtEntries.getRow(line);
                    CfEntryData ed = (CfEntryData)row.getUserObject();
                    CashflowEditDiposeUI.this.afterSelectCfEntry(ed);
                } else {
                    CashflowEditDiposeUI.this.afterSelectCfEntry(null);
                }
            }
        }
    }

    class CfEntryEditAdapter
    extends KDTEditAdapter {
        CfEntryEditAdapter() {
        }

        public void editStarting(KDTEditEvent evt) {
            super.editStarting(evt);
            KDTable table = (KDTable)evt.getSource();
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            String colKey = table.getColumnKey(colIndex);
            ICellEditor editor = table.getEditManager().getEditor();
            if (editor == CashflowEditDiposeUI.this.numberEditor) {
                KDFormattedTextField numberField = (KDFormattedTextField)CashflowEditDiposeUI.this.numberEditor.getComponent();
                if ("amount".equals(colKey)) {
                    int prec = CashflowEditDiposeUI.this.getOriginalCurrency(CashflowEditDiposeUI.this.curCfEntryIndex).getPrecision();
                    numberField.setPrecision(prec);
                } else if ("localAmount".equals(colKey)) {
                    numberField.setPrecision(CashflowEditDiposeUI.this.localCurrency.getPrecision());
                } else if ("reportingAmount".equals(colKey)) {
                    numberField.setPrecision(CashflowEditDiposeUI.this.reportingCurrency.getPrecision());
                }
            }
        }

        public void editStopped(KDTEditEvent evt) {
            super.editStopped(evt);
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getValue();
            if (!GlUtils.isEqual(newValue, oldValue)) {
                CashflowEditDiposeUI.this.hasChange = true;
                KDTable table = (KDTable)evt.getSource();
                int row = evt.getRowIndex();
                int col = evt.getColIndex();
                String colKey = table.getColumnKey(col);
                IRow curRow = table.getRow(row);
                if ("amount".equals(colKey)) {
                    if (newValue == null) {
                        curRow.getCell("amount").setValue((Object)GlUtils.zero);
                        curRow.getCell("localAmount").setValue((Object)GlUtils.zero);
                        curRow.getCell("reportingAmount").setValue((Object)GlUtils.zero);
                    } else {
                        VoucherInfo.ExchangeRateWithValue lexObj = CashflowEditDiposeUI.this.getLocalExDefinition(CashflowEditDiposeUI.this.curCfEntryIndex);
                        VoucherInfo.ExchangeRateWithValue rexObj = CashflowEditDiposeUI.this.getReportingExDefinition(CashflowEditDiposeUI.this.curCfEntryIndex);
                        BigDecimal lex = CashflowEditDiposeUI.this.getLocalExValue(CashflowEditDiposeUI.this.curCfEntryIndex);
                        BigDecimal la = null;
                        BigDecimal ra = null;
                        BigDecimal amnt = (BigDecimal)newValue;
                        la = lexObj != null ? (ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)lexObj.getConvertMode()) ? amnt.multiply(lex).setScale(CashflowEditDiposeUI.this.localCurrency.getPrecision(), CashflowEditDiposeUI.this.amountRoundMode) : amnt.divide(lex, CashflowEditDiposeUI.this.localCurrency.getPrecision(), CashflowEditDiposeUI.this.amountRoundMode)) : amnt;
                        if (!CashflowEditDiposeUI.this.isSettleByLocal) {
                            BigDecimal rex = CashflowEditDiposeUI.this.getReportingExValue(CashflowEditDiposeUI.this.curCfEntryIndex);
                            ra = CashflowEditDiposeUI.this.useReportingCurrency && rexObj != null && rex != null ? (ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rexObj.getConvertMode()) ? amnt.multiply(rex).setScale(CashflowEditDiposeUI.this.reportingCurrency.getPrecision(), CashflowEditDiposeUI.this.amountRoundMode) : amnt.divide(rex, CashflowEditDiposeUI.this.reportingCurrency.getPrecision(), CashflowEditDiposeUI.this.amountRoundMode)) : la;
                        } else {
                            ra = CashflowEditDiposeUI.this.useReportingCurrency ? la.multiply(CashflowEditDiposeUI.this.localToRpt.getValue()).setScale(CashflowEditDiposeUI.this.reportingCurrency.getPrecision(), CashflowEditDiposeUI.this.amountRoundMode) : la;
                        }
                        if (curRow.getUserObject() != null && ((CfEntryData)curRow.getUserObject()).getEntry() != null && ((CfEntryData)curRow.getUserObject()).getEntry().getOriginalAmount().compareTo(amnt) == 0) {
                            la = ((CfEntryData)curRow.getUserObject()).getEntry().getLocalAmount();
                            ra = ((CfEntryData)curRow.getUserObject()).getEntry().getReportingAmount();
                        }
                        curRow.getCell("localAmount").setValue((Object)la);
                        curRow.getCell("reportingAmount").setValue((Object)ra);
                    }
                } else if (!"reportingAmount".equals(colKey) && "localAmount".equals(colKey)) {
                    CurrencyInfo cur = CashflowEditDiposeUI.this.getOriginalCurrency(CashflowEditDiposeUI.this.curCfEntryIndex);
                    ICell amntCell = curRow.getCell("amount");
                    if (GlUtils.isEqual(cur, CashflowEditDiposeUI.this.localCurrency)) {
                        amntCell.setValue(newValue);
                    }
                    if (CashflowEditDiposeUI.this.isAllCommon) {
                        amntCell.setValue(newValue);
                    }
                    ICell raCell = curRow.getCell("reportingAmount");
                    if (!CashflowEditDiposeUI.this.isSettleByLocal) {
                        if (GlUtils.isEqual(cur, CashflowEditDiposeUI.this.reportingCurrency)) {
                            raCell.setValue(newValue);
                        }
                    } else {
                        raCell.setValue(newValue);
                    }
                }
                if (!CashflowEditDiposeUI.this.collectSameAccount) {
                    CashflowEditDiposeUI.this.checkOutAmount(curRow);
                }
            }
        }
    }
}

