/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityInfo;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashflowSplitClient {
    private static final Logger logger = Logger.getLogger(CashflowSplitClient.class);

    public static void splitByTMethod(VoucherInfo vch, boolean isSimpleMode, int autoSetCashflow) throws Exception {
        CashFlowUtils.splitByTMethod(vch, isSimpleMode, autoSetCashflow);
    }

    private static boolean isNeedAssignSupItem(VoucherInfo vch, VoucherEntryInfo entry, CashFlowItemInfo pi) {
        if (entry == null || pi == null) {
            return false;
        }
        boolean isPnL = CashflowSplitClient.isPLAccount(vch, entry.getAccount());
        boolean isAct = CashflowSplitClient.isCFItemDealActivity(vch, pi);
        return isPnL && !isAct || !isPnL && isAct;
    }

    private static boolean isCFItemDealActivity(VoucherInfo vch, CashFlowItemInfo item) {
        if (item == null || !item.isIsDealActivity()) {
            return false;
        }
        CashFlowKeepActivityCollection actCol = vch.getCashFlowKeepActivityCollection();
        if (actCol == null) {
            return true;
        }
        int size = actCol.size();
        for (int i = 0; i < size; ++i) {
            CashFlowKeepActivityInfo actitem = actCol.get(i);
            if (actitem.getConCashFlowItem() == null || !item.getId().toString().equals(actitem.getConCashFlowItem().getId().toString())) continue;
            return false;
        }
        return true;
    }

    private static boolean isPLAccount(VoucherInfo vch, AccountViewInfo account) {
        if (account == null || account.getPLType() == AccountPLType.NONE) {
            return false;
        }
        CashFlowAccountDiffCollection actCol = vch.getCashFlowAccountDiffCollection();
        if (actCol == null) {
            return true;
        }
        int size = actCol.size();
        for (int i = 0; i < size; ++i) {
            CashFlowAccountDiffInfo actitem = actCol.get(i);
            if (actitem.getDiffAccount() == null || !account.getNumber().equals(actitem.getDiffAccount().getNumber())) continue;
            return false;
        }
        return true;
    }

    public static CashflowParams getParam4AutoSetCF(String companyId) throws Exception {
        CashflowParams params = new CashflowParams();
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)companyId));
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_078", comPK);
        IParamControl pc = ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Object autoSetCashFlow = hmAllParam.get("GL_078");
        if (autoSetCashFlow != null) {
            params.setAutoSetCashFlow(Boolean.valueOf(autoSetCashFlow.toString()));
        } else {
            params.setAutoSetCashFlow(false);
        }
        return params;
    }

    public static void autoSetActTypeValue(Map dynamicDatabaseInfo, CashflowRecordInfo info, String hgId, VoucherInfo.DynamicColumnInfo[] acctActTypeCols, AsstAccountInfo cfiTypeGroup, VoucherInfo.DynamicColumnInfo[] cfiActTypeCols, boolean isSimpleMode) {
        if (StringUtils.isEmpty((String)hgId) || acctActTypeCols == null || acctActTypeCols.length == 0 || cfiActTypeCols == null || cfiActTypeCols.length == 0) {
            return;
        }
        AssistantHGInfo assGrp = null;
        try {
            assGrp = GlUtils.dynamicLoadAssistangHG(null, dynamicDatabaseInfo, hgId, acctActTypeCols);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (assGrp == null) {
            return;
        }
        boolean isAllNull = true;
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(cfiTypeGroup);
        for (int i = 0; i < cfiActTypeCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = cfiActTypeCols[i];
            String key = colInfo.getMappingPropName();
            Object value = assGrp.get(key);
            if ("companyOrg".equals(key)) {
                SupplierInfo supplier;
                Object objSupplier;
                CustomerInfo customer;
                Object objCustomer;
                if (value == null && (objCustomer = assGrp.get("customer")) instanceof CustomerInfo && (customer = (CustomerInfo)objCustomer).getInternalCompany() != null) {
                    value = customer.getInternalCompany();
                }
                if (value == null && (objSupplier = assGrp.get("provider")) instanceof SupplierInfo && (supplier = (SupplierInfo)objSupplier).getInternalCompany() != null) {
                    value = supplier.getInternalCompany();
                }
                if (value != null) {
                    info.setType(CashflowTypeEnum.IN);
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            } else if ("customer".equals(key)) {
                if (value instanceof CustomerInfo) {
                    CustomerInfo customer = (CustomerInfo)value;
                    if (customer.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            } else if ("provider".equals(colInfo.getMappingPropName())) {
                if (value instanceof SupplierInfo) {
                    SupplierInfo supplier = (SupplierInfo)value;
                    if (supplier.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            } else if (!CashflowTypeEnum.IN.equals((Object)info.getType())) {
                info.setType(CashflowTypeEnum.OUT);
            }
            group.put(key, value);
            if (value == null) continue;
            isAllNull = false;
        }
        if (isAllNull) {
            info.setAssGrp(null);
        } else if (!CashflowTypeEnum.IN.equals((Object)info.getType()) && isSimpleMode) {
            info.setAssGrp(null);
        } else {
            try {
                group = VoucherFacadeFactory.getRemoteInstance().confirmAssGrp(group, cfiTypeGroup.getId().toString(), cfiActTypeCols);
                if (group != null) {
                    info.setAssGrp(group);
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            }
            catch (Exception e) {
                info.setType(CashflowTypeEnum.OUT);
                logger.error((Object)"CashflowSplitClient invoke autoSetActTypeValue error", (Throwable)e);
            }
        }
    }

    private static Object[] getCachedColumnInfo(Map hmDynamicColumnInfo, String typeGroupId) {
        if (typeGroupId == null) {
            return null;
        }
        Object[] colInfo = (Object[])hmDynamicColumnInfo.get(typeGroupId);
        try {
            if (colInfo == null) {
                colInfo = VoucherFacadeFactory.getRemoteInstance().fetchAssColumnInfo(null, typeGroupId, null);
                hmDynamicColumnInfo.put(typeGroupId, colInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"CashflowSplitClient invoke getCachedColumnInfo error");
        }
        return colInfo;
    }

    static class CashflowParams {
        private int isMustCashFlowItem = 2;
        private boolean isMustCFAttchment = false;
        private int isCashFlowByAsstAccount = 0;
        private boolean isAutoSetCashFlow = false;

        CashflowParams() {
        }

        public int getIsMustCashFlowItem() {
            return this.isMustCashFlowItem;
        }

        public void setIsMustCashFlowItem(int isMustCashFlowItem) {
            this.isMustCashFlowItem = isMustCashFlowItem;
        }

        public boolean isMustCFAttchment() {
            return this.isMustCFAttchment;
        }

        public void setMustCFAttchment(boolean isMustCFAttchment) {
            this.isMustCFAttchment = isMustCFAttchment;
        }

        public int getIsCashFlowByAsstAccount() {
            return this.isCashFlowByAsstAccount;
        }

        public void setIsCashFlowByAsstAccount(int isCashFlowByAsstAccount) {
            this.isCashFlowByAsstAccount = isCashFlowByAsstAccount;
        }

        public boolean isAutoSetCashFlow() {
            return this.isAutoSetCashFlow;
        }

        public void setAutoSetCashFlow(boolean isAutoSetCashFlow) {
            this.isAutoSetCashFlow = isAutoSetCashFlow;
        }
    }
}

