/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.eas.fi.gl.client.CheckBoxNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends KDTree
implements TreeExpansionListener,
MouseListener {
    public CheckBoxTree() {
        this.setCellRenderer(new CheckBoxTreeCellRenderer());
        this.addMouseListener(this);
        this.addTreeExpansionListener(this);
    }

    private CheckBoxTree(Object[] arg0) {
        super(arg0);
    }

    private CheckBoxTree(Vector arg0) {
        super(arg0);
    }

    public CheckBoxTree(TreeModel model) {
        super(model);
        this.setCellRenderer(new CheckBoxTreeCellRenderer());
        this.addMouseListener(this);
        this.addTreeExpansionListener(this);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent arg0) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int y;
        int x;
        int row;
        TreePath path;
        int count = evt.getClickCount();
        if (count == 1 && (path = this.getPathForRow(row = this.getRowForLocation(x = evt.getX(), y = evt.getY()))) != null) {
            CheckBoxNode node = (CheckBoxNode)path.getLastPathComponent();
            boolean isSelected = !node.isSelected();
            node.setSelected(isSelected);
            ((DefaultTreeModel)this.getModel()).nodeChanged((TreeNode)((Object)node));
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    class CheckBoxTreeCellRenderer
    extends KDPanel
    implements TreeCellRenderer {
        KDCheckBox check = new KDCheckBox();
        BorderLayout borderLayout = new BorderLayout();
        Color selectedColor = UIManager.getColor("Tree.selectionBackground");
        Color noSelectedColor = UIManager.getColor("Tree.textBackground");

        CheckBoxTreeCellRenderer() {
            this.setLayout(this.borderLayout);
            this.add((Component)this.check, "Center");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String strValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            this.check.setSelected(((CheckBoxNode)value).isSelected());
            this.check.setText(strValue);
            if (selected) {
                this.setBackground(this.selectedColor);
            } else {
                this.setBackground(this.noSelectedColor);
            }
            return this;
        }
    }
}

