/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLClosePeriodFacadeFactory;
import com.kingdee.eas.fi.gl.IGLClosePeriodFacade;
import com.kingdee.eas.fi.gl.client.AbstractClosePeriodAsynBatchUI;
import com.kingdee.eas.fi.gl.client.GLLicenseUtils;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ClosePeriodAsynBatchUI
extends AbstractClosePeriodAsynBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(ClosePeriodAsynBatchUI.class);
    private static final String RESOURCE_NAME = "com.kingdee.eas.fi.gl.GLClosePeriodResource";
    private static final String IMAGE_PATH = "/com/kingdee/eas/fi/gl/client/images/";
    private static final Color bgColor = new Color(240, 240, 240);
    private static final Color successColor = new Color(0, 130, 0);
    private static Icon doingIcon = ClosePeriodAsynBatchUI.getIcon("operation_doing.gif");
    private static Icon successIcon = ClosePeriodAsynBatchUI.getIcon("operation_success.png");
    private static Icon errorIcon = ClosePeriodAsynBatchUI.getIcon("operation_error.png");
    private String companyFilter = null;
    private String periodFilter = null;
    private String orderField = null;
    private boolean stop = false;

    public void onLoad() throws Exception {
        GLLicenseUtils.requestLicenseOrReleaseLicense(this.getUIContext(), true, this);
        this.getUIContext().put("checkLicense", "true");
        super.onLoad();
        this.menuItemFresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.initMyIcon();
        this.initTableStyle();
        this.actionRefresh_actionPerformed(null);
        this.initTableListener();
    }

    private void initTableListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    KDTSelectBlock selectBlock = ClosePeriodAsynBatchUI.this.tblMain.getSelectManager().get();
                    if (selectBlock != null) {
                        int endRow;
                        int beginRow = selectBlock.getBeginRow();
                        if (beginRow == (endRow = selectBlock.getEndRow()) && ClosePeriodAsynBatchUI.this.tblMain.getSelectManager().getActiveColumnIndex() == 0) {
                            IRow row = ClosePeriodAsynBatchUI.this.tblMain.getRow(beginRow);
                            ClosePeriodAsynBatchUI.this.setSelectCellValue(row);
                            return;
                        }
                        for (int i = beginRow; i <= endRow && i < ClosePeriodAsynBatchUI.this.tblMain.getRowCount(); ++i) {
                            IRow row = ClosePeriodAsynBatchUI.this.tblMain.getRow(i);
                            ClosePeriodAsynBatchUI.this.setSelectCellValue(row);
                        }
                    }
                }
                catch (Exception exc) {
                    ClosePeriodAsynBatchUI.this.handleException(exc);
                }
            }
        });
    }

    private void setSelectCellValue(IRow row) {
        if (row == null || row.getCell("select") == null || row.getCell("select").getValue() == null) {
            return;
        }
        boolean isSelected = (Boolean)row.getCell("select").getValue();
        row.getCell("select").setValue((Object)new Boolean(!isSelected));
    }

    private IGLClosePeriodFacade getFacade() throws Exception {
        return GLClosePeriodFacadeFactory.getRemoteInstance();
    }

    private void initMyIcon() {
        this.tblMain.checkParsed();
        InitClientHelp.setTableKeyBoardManager(this.tblMain);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnCloseCheck.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.btnClosePeriod.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.btnUnClosePeriod.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.btnCloseYear.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.btnUnCloseYear.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.menuItemSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemClearall.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.menuItemFresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
    }

    public void loadData() throws Exception {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Map data = ClosePeriodAsynBatchUI.this.getFacade().getData(ClosePeriodAsynBatchUI.this.getInitParams());
                    List companys = (List)data.get("rows");
                    String currentCompanyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                    for (int i = 0; i < companys.size(); ++i) {
                        Map company = (Map)companys.get(i);
                        IRow row = ClosePeriodAsynBatchUI.this.tblMain.addRow();
                        if (i % 2 != 0) {
                            row.getStyleAttributes().setBackground(bgColor);
                            company.put("bgColor", bgColor);
                        }
                        row.setUserObject((Object)company);
                        row.getCell("select").setValue((Object)currentCompanyId.equals(company.get("orgId")));
                        row.getCell("orgId").setValue(company.get("orgId"));
                        row.getCell("orgNumber").setValue(company.get("orgNumber"));
                        row.getCell("orgName").setValue(company.get("orgName"));
                        row.getCell("periodName").setValue(company.get("periodName"));
                        row.getCell("icon").setRenderer((IBasicRender)new IconRender());
                        row.getStyleAttributes().setLocked(true);
                        row.getCell("select").getStyleAttributes().setLocked(false);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
                finally {
                    ClosePeriodAsynBatchUI.this.setActionStatus(true);
                }
            }
        }).start();
    }

    private Map<String, Object> getInitParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("module", "FSSC_GL");
        params.put("company", this.companyFilter);
        params.put("period", this.periodFilter);
        params.put("order", this.orderField);
        params.put("isFromGUI", true);
        return params;
    }

    private void setActionStatus(boolean enable) {
        this.actionRefresh.setEnabled(enable);
        this.actionQuery.setEnabled(enable);
        this.actionClearAll.setEnabled(enable);
        this.actionSelectAll.setEnabled(enable);
        this.actionCloseCheck.setEnabled(enable);
        this.actionClosePeriod.setEnabled(enable);
        this.actionUnClosePeriod.setEnabled(enable);
        this.actionCloseYear.setEnabled(enable);
        this.actionUnCloseYear.setEnabled(enable);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.setActionStatus(false);
        this.loadData();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showFilterUI();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelectAll(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelectAll(false);
    }

    private void doSelectAll(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Map company = (Map)row.getUserObject();
            if (company == null) continue;
            row.getCell("select").setValue((Object)select);
        }
    }

    private Map<String, Object> getOrgRow(String orgId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Map company = (Map)row.getUserObject();
            if (company == null || !orgId.equals(company.get("orgId"))) continue;
            map.put("row", row);
            map.put("rowIndex", i);
            break;
        }
        return map;
    }

    @Override
    public void actionCloseCheck_actionPerformed(ActionEvent e) throws Exception {
        this.actionProcess_ActionPerformed("closeCheck", e);
    }

    @Override
    public void actionClosePeriod_actionPerformed(ActionEvent e) throws Exception {
        int r = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE_NAME, (String)"ACTION_CONFIRM", (Object[])new Object[]{this.getActionText("closePeriod")}));
        if (r == 0) {
            this.actionProcess_ActionPerformed("closePeriod", e);
        }
    }

    @Override
    public void actionUnClosePeriod_actionPerformed(ActionEvent e) throws Exception {
        int r = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE_NAME, (String)"ACTION_CONFIRM", (Object[])new Object[]{this.getActionText("unClosePeriod")}));
        if (r == 0) {
            this.actionProcess_ActionPerformed("unClosePeriod", e);
        }
    }

    @Override
    public void actionCloseYear_actionPerformed(ActionEvent e) throws Exception {
        int r = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE_NAME, (String)"ACTION_CONFIRM", (Object[])new Object[]{this.getActionText("closeYear")}));
        if (r == 0) {
            this.actionProcess_ActionPerformed("closeYear", e);
        }
    }

    @Override
    public void actionUnCloseYear_actionPerformed(ActionEvent e) throws Exception {
        int r = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE_NAME, (String)"ACTION_CONFIRM", (Object[])new Object[]{this.getActionText("unCloseYear")}));
        if (r == 0) {
            this.actionProcess_ActionPerformed("unCloseYear", e);
        }
    }

    private void actionProcess_ActionPerformed(final String action, ActionEvent e) throws Exception {
        IRow row;
        int i;
        final LinkedList paramss = new LinkedList();
        HashSet<String> selectedOrgIds = new HashSet<String>();
        int rowCount = this.tblMain.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            boolean isSelected;
            row = this.tblMain.getRow(i);
            Map company = (Map)row.getUserObject();
            if (company == null || !(isSelected = ((Boolean)row.getCell("select").getValue()).booleanValue())) continue;
            selectedOrgIds.add((String)company.get("orgId"));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", action);
            params.put("orgId", (String)company.get("orgId"));
            params.put("periodId", (String)company.get("periodId"));
            paramss.add(params);
        }
        for (i = rowCount - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            String orgId = (String)row.getCell("orgId").getValue();
            if (!selectedOrgIds.contains(orgId)) continue;
            Map company = (Map)row.getUserObject();
            if (company != null) {
                row.getCell("periodName").getStyleAttributes().setFontColor(Color.BLACK);
                row.getCell("icon").setValue((Object)"");
                row.getCell("msg").setValue((Object)"");
                continue;
            }
            this.tblMain.removeRow(i);
        }
        if (paramss.size() == 0) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ClosePeriodAsynBatchUI.this.setActionStatus(false);
                ClosePeriodAsynBatchUI.this.tblMain.getColumn("select").getStyleAttributes().setLocked(true);
                for (Map params : paramss) {
                    ClosePeriodAsynBatchUI.this.doProcess(action, params);
                    if (!ClosePeriodAsynBatchUI.this.stop) continue;
                    break;
                }
                ClosePeriodAsynBatchUI.this.setActionStatus(true);
                ClosePeriodAsynBatchUI.this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
            }
        }).start();
    }

    private void doProcess(String action, Map<String, Object> params) {
        String orgId = (String)params.get("orgId");
        IRow orgRow = null;
        try {
            Map<String, Object> map = this.getOrgRow(orgId);
            orgRow = (IRow)map.get("row");
            if (orgRow == null) {
                return;
            }
            orgRow.getCell("icon").setValue((Object)"doing");
            Map result = new HashMap();
            if ("closeCheck".equals(action)) {
                result = this.getFacade().closeCheck(params);
            } else if ("closePeriod".equals(action)) {
                result = this.getFacade().closePeriod(params);
            } else if ("unClosePeriod".equals(action)) {
                result = this.getFacade().unClosePeriod(params);
            } else if ("closeYear".equals(action)) {
                result = this.getFacade().closeYear(params);
            } else if ("unCloseYear".equals(action)) {
                result = this.getFacade().unCloseYear(params);
            } else {
                orgRow.getCell("icon").setValue((Object)"");
            }
            Integer rowIndex = (Integer)map.get("rowIndex");
            String status = (String)result.get("status");
            String msg = this.getActionText(action);
            if ("success".equals(status)) {
                orgRow.getCell("icon").setValue((Object)"success");
                Map company = (Map)orgRow.getUserObject();
                String oldPeriodName = (String)company.get("periodName");
                if (result.get("periodId") != null) {
                    company.put("periodId", result.get("periodId"));
                }
                if (result.get("periodName") != null) {
                    company.put("periodName", result.get("periodName"));
                    orgRow.getCell("periodName").setValue(result.get("periodName"));
                    orgRow.getCell("periodName").getStyleAttributes().setFontColor(successColor);
                    msg = msg + ": " + oldPeriodName + " -> " + result.get("periodName");
                }
                orgRow.getCell("icon").setValue((Object)"success");
                orgRow.getCell("msg").setValue((Object)msg);
            } else {
                orgRow.getCell("icon").setValue((Object)"error");
                orgRow.getCell("msg").setValue((Object)msg);
                List errors = (List)result.get("errors");
                if (errors != null && errors.size() > 0) {
                    Map company = (Map)orgRow.getUserObject();
                    Color color = (Color)company.get("bgColor");
                    int diff = 0;
                    for (Map error : errors) {
                        IRow msgRow = this.tblMain.addRow(rowIndex + ++diff);
                        if (color != null) {
                            msgRow.getStyleAttributes().setBackground(color);
                        }
                        msgRow.getStyleAttributes().setLocked(true);
                        msgRow.getCell("orgId").setValue((Object)orgId);
                        msgRow.getCell("msg").setValue(error.get("orgName"));
                    }
                }
            }
        }
        catch (Exception e) {
            orgRow.getCell("icon").setValue((Object)"error");
            logger.error((Object)"", (Throwable)e);
        }
    }

    private String getActionText(String action) {
        String result = "";
        if ("closeCheck".equals(action)) {
            result = EASResource.getString((String)RESOURCE_NAME, (String)"CLOSE_CHECK");
        } else if ("closePeriod".equals(action)) {
            result = EASResource.getString((String)RESOURCE_NAME, (String)"CLOSE");
        } else if ("unClosePeriod".equals(action)) {
            result = EASResource.getString((String)RESOURCE_NAME, (String)"UNCLOSE");
        } else if ("closeYear".equals(action)) {
            result = EASResource.getString((String)RESOURCE_NAME, (String)"CLOSE_YEAR");
        } else if ("unCloseYear".equals(action)) {
            result = EASResource.getString((String)RESOURCE_NAME, (String)"UNCLOSE_YEAR");
        }
        return result;
    }

    private static ImageIcon getIcon(String filename) {
        try {
            Image image = null;
            String fullname = IMAGE_PATH + filename;
            URL url = ClosePeriodAsynBatchUI.class.getResource(fullname);
            if (url != null) {
                BufferedImage bi = ImageIO.read(url);
                ImageProducer producer = bi.getSource();
                image = Toolkit.getDefaultToolkit().createImage(producer);
                if (image != null) {
                    return new ImageIcon(image);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    public void query(Map<String, Object> params) {
        try {
            this.companyFilter = (String)params.get("companyFilter");
            this.periodFilter = (String)params.get("periodFilter");
            this.orderField = (String)params.get("orderField");
            this.actionRefresh_actionPerformed(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showFilterUI() {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"companyFilter", (Object)this.companyFilter);
        uiContext.put((Object)"periodFilter", (Object)this.periodFilter);
        uiContext.put((Object)"orderField", (Object)this.orderField);
        uiContext.put((Object)"listener", (Object)new ClosePeriodAsynBatchFilter(){

            @Override
            public void apply(Map<String, Object> params) {
                ClosePeriodAsynBatchUI.this.query(params);
            }
        });
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.ClosePeriodAsynBatchFilterUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return new MetaDataPK("com.kingdee.eas.fi.gl.client", "ClosePeriodBatchUI");
    }

    protected void initTableStyle() {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f5 = KeyStroke.getKeyStroke(116, 3);
        imEntry.put(ctrl_shift_f5, "showAnalysisBalanceUI");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("showAnalysisBalanceUI", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ClosePeriodAsynBatchUI.this.showAnalysisBalanceUI(e);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    public void showAnalysisBalanceUI(ActionEvent e) {
        this.getUIWindow().close();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.BalanceAnalysisUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    static interface ClosePeriodAsynBatchFilter {
        public void apply(Map<String, Object> var1);
    }

    static class IconRender
    extends KDLabel
    implements IBasicRender {
        private static final long serialVersionUID = 1L;

        public IconRender() {
            this.setHorizontalAlignment(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if ("success".equals(object)) {
                this.setIcon(successIcon);
                this.setText("");
            } else if ("error".equals(object)) {
                this.setIcon(errorIcon);
                this.setText("");
            } else if ("doing".equals(object)) {
                this.setIcon(doingIcon);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText("");
            }
            Rectangle rect = clip.getBounds();
            this.setBounds(rect);
            Graphics cg = graphics.create(rect.x, rect.y, rect.width, rect.height);
            try {
                this.paint(cg);
            }
            finally {
                cg.dispose();
            }
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }
}

