/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgBudgetViewInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.stepadd.StepAddParamInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeCollection;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractCompanyTreeSelectUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CompanyTreeSelectUI
extends AbstractCompanyTreeSelectUI {
    private static final long serialVersionUID = -4031913127266965320L;
    private static final String ENABLE_FLAG = "ENABLE_FLAG";
    private static Color disableColor = new Color(77, 77, 77);
    private static final String BOOKS_COMPANY = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.GlResource", (String)"bookCompany");
    private static final String MAIN_ORG_COMPANY = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.GlResource", (String)"mainOrgCompany");
    private CompanyOrgUnitInfo root = null;
    private JDialog dialog = null;
    private String accountTableID;
    private String periodTypeID;
    IMetaDataPK uiPK = null;
    IMetaDataPK actionPK = null;
    private boolean force = false;
    private TreeModel selectedCompany;
    private boolean isCanceled = false;
    private String permissionItem;
    private boolean isAllAccountScheme = false;
    private DefaultMutableTreeNode initRootNode;
    private Set selectCompanySet = new HashSet();
    private String filterSql = null;
    private boolean isClose = false;

    public CompanyTreeSelectUI() throws Exception {
        this(null);
    }

    public CompanyTreeSelectUI(CompanyOrgUnitInfo root) throws Exception {
        this.root = root;
        this.initUIContentLayout();
        this.kDTreeView1.setShowButton(false);
        this.kDTreeView2.setShowButton(false);
        this.btnAdd.setText(null);
        this.btnDelete.setText(null);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.buildQuickQueryCombox();
        this.initListener();
    }

    public void initListener() {
        super.initListener();
        this.treeOrigin.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    CompanyTreeSelectUI.this.addNode();
                }
            }
        });
        this.treeSelected.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    CompanyTreeSelectUI.this.delete(CompanyTreeSelectUI.this.treeSelected);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CompanyTreeSelectUI.this.isClose) {
                    CompanyTreeSelectUI.this.confirm();
                    CompanyTreeSelectUI.this.conditionText.setText("");
                }
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.chkContainSealUp);
        this.chkContainSealUp.setBounds(new Rectangle(334, 40, 105, 19));
        this.add((Component)this.chkContainSealUp, new KDLayout.Constraints(424, 40, 105, 19, 0));
        this.chkContainSealUp.setEnabled(true);
        this.chkContainSealUp.setSelected(true);
    }

    public void setRoot(CompanyOrgUnitInfo root) {
        this.root = root;
    }

    public void setPmissionItem(String permissionItem) {
        this.permissionItem = permissionItem;
    }

    public void setAllAccountScheme(boolean isAllAccountScheme) {
        this.isAllAccountScheme = isAllAccountScheme;
    }

    public void setBooksModel() throws Exception {
        EventListener[] lister = this.kcbBooks.getListeners(ActionListener.class);
        if (lister != null) {
            for (int i = 0; i < lister.length; ++i) {
                this.kcbBooks.removeActionListener((ActionListener)lister[i]);
            }
        }
        this.kcbBooks.removeAllItems();
        if (BooksUtil.canCreateBook(null)) {
            if (this.isAllAccountScheme) {
                CompanyOrgUnitInfo currCompany = SysContext.getSysContext().getCurrentFIUnit();
                this.setAllAccountScheme(currCompany);
            } else {
                EntityViewInfo view = new EntityViewInfo();
                SorterItemInfo sorter = new SorterItemInfo("number");
                view.getSorter().add(sorter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("isMaster"));
                view.getSelector().addObjectCollection((IObjectCollection)sic);
                FilterInfo filter = new FilterInfo();
                StringBuffer maskString = new StringBuffer();
                filter.getFilterItems().add(new FilterItemInfo("isLock", (Object)new Integer(1)));
                int index = 0;
                maskString.append("(#").append(index++);
                if (this.accountTableID != null) {
                    filter.getFilterItems().add(new FilterItemInfo("accountTable.id", (Object)this.accountTableID));
                    maskString.append(" and #").append(index++);
                }
                if (this.periodTypeID != null) {
                    filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.periodTypeID));
                    maskString.append(" and #").append(index++);
                }
                filter.getFilterItems().add(new FilterItemInfo("isMaster", (Object)new Integer(1)));
                maskString.append(") or #").append(index++);
                filter.setMaskString(maskString.toString());
                view.setFilter(filter);
                AcountSchemeCollection col = AcountSchemeFactory.getRemoteInstance().getAcountSchemeCollection(view);
                this.kcbBooks.addItems(col.toArray());
                GlUtils.setSelectedItem(this.kcbBooks, (CoreBaseInfo)BooksUtil.getCurrentBook(null));
            }
        } else {
            this.kcbBooks.addItem((Object)BooksUtil.getCurrentBook(null));
            this.kcbBooks.setEnabled(false);
        }
        if (lister != null) {
            for (int i = 0; i < lister.length; ++i) {
                this.kcbBooks.addActionListener((ActionListener)lister[i]);
            }
        }
    }

    private void setAllAccountScheme(CompanyOrgUnitInfo currCompany) throws BOSException, EASBizException {
        AcountSchemeInfo scheme = null;
        if (currCompany.isIsAssistantOrg()) {
            scheme = new AcountSchemeInfo();
            scheme.setName(BOOKS_COMPANY);
            scheme.setIsMaster(false);
        } else {
            scheme = new AcountSchemeInfo();
            scheme.setName(MAIN_ORG_COMPANY);
            scheme.setIsMaster(true);
        }
        this.kcbBooks.addItems(new Object[]{scheme});
        this.kcbBooks.setEnabled(false);
    }

    public void setSelectedCompanys(CompanyOrgUnitInfo[] companys) {
        this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"")));
        if (companys == null) {
            return;
        }
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < companys.length; ++i) {
            companyIdSet.add(companys[i].getId().toString());
        }
        this.selectCompanySet.addAll(companyIdSet);
        this.buildSelectCompany(companyIdSet);
        if (this.treeSelected.getModel() != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot();
            this.treeSelected.expandAllNodes(true, (TreeNode)root);
            this.treeSelected.setSelectionRow(0);
        }
    }

    private void buildSelectCompany(Set companyIdSet) {
        this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"")));
        DefaultMutableTreeNode node = this.initRootNode;
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> children = node.depthFirstEnumeration();
        while (children.hasMoreElements()) {
            OrgStructureInfo orgInfo;
            node = (DefaultMutableTreeNode)children.nextElement();
            if (!node.isLeaf() || !companyIdSet.contains((orgInfo = (OrgStructureInfo)node.getUserObject()).getUnit().getId().toString())) continue;
            this.add(new TreePath(node.getPath()));
        }
    }

    public void setSelectedModel(TreeModel selected) throws Exception {
        if (selected != null) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)selected.getRoot();
            DefaultKingdeeTreeNode aa = this.makeKingdeeTreeNode(root);
            DefaultKingdeeTreeNode root2 = new DefaultKingdeeTreeNode((Object)"");
            root2.add((MutableTreeNode)aa);
            KingdeeTreeModel km = new KingdeeTreeModel((TreeNode)root2);
            this.treeSelected.setModel((TreeModel)km);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.expandAllNodes(true, (TreeNode)root2);
            this.treeSelected.updateUI();
            this.addCompanyIdOfNode(aa);
        } else {
            this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"")));
            this.selectCompanySet.clear();
        }
    }

    private DefaultKingdeeTreeNode makeKingdeeTreeNode(DefaultMutableTreeNode node) {
        DefaultKingdeeTreeNode dd = new DefaultKingdeeTreeNode(node.getUserObject());
        for (int i = 0; i < node.getChildCount(); ++i) {
            dd.add((MutableTreeNode)this.makeKingdeeTreeNode((DefaultMutableTreeNode)node.getChildAt(i)));
        }
        return dd;
    }

    public void setAccountScheme(CompanyOrgUnitInfo companyObj) throws Exception {
        String companyId = companyObj.getId().toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isAssistantOrg"));
        selector.add(new SelectorItemInfo("accountScheme.id"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        if (company.isIsAssistantOrg() && company.getAccountScheme() != null) {
            if (this.isAllAccountScheme) {
                this.setAllAccountScheme(companyObj);
            } else {
                GlUtils.setSelectedItem(this.kcbBooks, (CoreBaseInfo)company.getAccountScheme());
            }
        }
    }

    private DefaultKingdeeTreeNode searchRoot(DefaultKingdeeTreeNode root, String rootCompanyId) {
        OrgStructureInfo osi = (OrgStructureInfo)root.getUserObject();
        if (osi == null) {
            return root;
        }
        FullOrgUnitInfo userObject = osi.getUnit();
        String curId = userObject.getId().toString();
        if (curId.equals(rootCompanyId)) {
            return root;
        }
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode find = this.searchRoot((DefaultKingdeeTreeNode)root.getChildAt(i), rootCompanyId);
            if (find == null) continue;
            return find;
        }
        return null;
    }

    private void filterTreeNode(DefaultKingdeeTreeNode root, Map orgUnitIDs) {
        if (root != null) {
            OrgUnitInfo unitInfo = this.getUserObject(root);
            if (unitInfo != null) {
                if (orgUnitIDs != null) {
                    Boolean b = (Boolean)orgUnitIDs.get(unitInfo.getId().toString());
                    this.setUserObjectEnable(root, b != null);
                } else {
                    this.setUserObjectEnable(root, true);
                }
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.filterTreeNode(node, orgUnitIDs);
            }
        }
    }

    private void setUserObjectEnable(DefaultKingdeeTreeNode node, boolean enable) {
        OrgStructureInfo info;
        if (!enable) {
            this.disableTreeNode(node);
            return;
        }
        if (node.getUserObject() instanceof OrgStructureInfo) {
            info = (OrgStructureInfo)node.getUserObject();
            info.getUnit().put(ENABLE_FLAG, (Object)Boolean.TRUE);
        }
        if (node.getUserObject() instanceof FullOrgUnitInfo) {
            info = (FullOrgUnitInfo)node.getUserObject();
            info.put(ENABLE_FLAG, (Object)Boolean.TRUE);
        }
    }

    private void disableTreeNode(DefaultKingdeeTreeNode treeNode) {
        treeNode.setTextColor(disableColor);
        treeNode.setCheckBoxEnabled(false);
        treeNode.setCheckBoxVisible(false);
    }

    private void clipTreeNode(DefaultKingdeeTreeNode root) {
        DefaultKingdeeTreeNode node = null;
        if (root != null && root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.clipTreeNode(node);
                if (node.getChildCount() != 0 || this.isUserObjectEnable(node)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    private boolean isUserObjectEnable(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
            Boolean flag = (Boolean)info.getUnit().get(ENABLE_FLAG);
            return flag != null;
        }
        if (node.getUserObject() instanceof FullOrgUnitInfo) {
            FullOrgUnitInfo info = (FullOrgUnitInfo)node.getUserObject();
            Boolean flag = (Boolean)info.get(ENABLE_FLAG);
            return flag != null;
        }
        return false;
    }

    private void checkNodeValid(DefaultKingdeeTreeNode root) {
        if (root != null) {
            OrgStructureInfo structInfo = (OrgStructureInfo)root.getUserObject();
            if (!structInfo.isIsValid()) {
                root.setTextColor(Color.lightGray);
                root.setCheckBoxEnabled(false);
                root.setCheckBoxVisible(false);
            }
            if (structInfo.getUnit() != null && structInfo.getUnit().getMainOrg() != null) {
                String name = structInfo.getUnit().getMainOrg().getName();
                root.setText(name);
                structInfo.getUnit().setName(name);
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                this.checkNodeValid(node);
            }
        }
    }

    private OrgUnitInfo getUserObject(DefaultKingdeeTreeNode node) {
        if (node.getUserObject() instanceof OrgStructureInfo) {
            OrgStructureInfo info = (OrgStructureInfo)node.getUserObject();
            return info.getUnit();
        }
        if (node.getUserObject() instanceof OrgBudgetViewInfo) {
            OrgBudgetViewInfo info = (OrgBudgetViewInfo)node.getUserObject();
            return info.getOrgUnitInfo();
        }
        if (node.getUserObject() instanceof OrgUnitInfo) {
            return (OrgUnitInfo)node.getUserObject();
        }
        return null;
    }

    public void buildCompanyTree(IMetaDataPK uipk, IMetaDataPK actionpk, boolean force) throws Exception {
        this.buildCompanyTree(uipk, actionpk, force, true);
        if (this.treeOrigin != null && this.treeOrigin.getModel() != null && this.treeOrigin.getModel().getRoot() != null) {
            this.initRootNode = (DefaultMutableTreeNode)ObjectUtils.createCopy((Object)this.treeOrigin.getModel().getRoot());
        }
    }

    public void buildCompanyTree(IMetaDataPK uipk, IMetaDataPK actionpk, boolean force, boolean refresh) throws Exception {
        KingdeeTreeModel treeModel;
        if (this.uiPK == null) {
            this.setUiPK(uipk);
        }
        if (this.actionPK == null) {
            this.setActionPK(actionpk);
        }
        this.force = force;
        TreeModel tm = this.root != null && !this.root.isIsBizUnit() ? this.getUnionUnitTreeModel() : this.getBizUnitTreeModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tm.getRoot();
        if (this.root != null) {
            root = this.searchRoot(root, this.root.getId().toString());
        }
        if (root == null || root.isLeaf()) {
            this.treeOrigin.setModel(null);
            if (refresh) {
                this.treeSelected.setModel(null);
            }
            this.btnOK.setEnabled(false);
            return;
        }
        if (root.getUserObject() == null) {
            this.btnAdd.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnOK.setEnabled(false);
            this.treeOrigin.setModel(null);
            if (refresh) {
                this.treeSelected.setModel(null);
            }
            return;
        }
        this.btnOK.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnCancel.setEnabled(true);
        if (refresh) {
            this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"")));
        }
        DefaultTreeModel dtm = new DefaultTreeModel((TreeNode)root);
        this.treeOrigin.setModel((TreeModel)dtm);
        root = (DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot();
        root.setParent(null);
        this.treeOrigin.expandAllNodes(true, (TreeNode)root);
        this.treeOrigin.setShowsRootHandles(true);
        if (refresh && (treeModel = (KingdeeTreeModel)this.treeSelected.getModel()).getRoot() != null) {
            DefaultKingdeeTreeNode root2 = new DefaultKingdeeTreeNode((Object)"");
            treeModel.setRoot((TreeNode)root2);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.setShowsRootHandles(true);
        }
    }

    private TreeModel getUnionUnitTreeModel() throws EASBizException, BOSException, GLException, Exception {
        String filter = this.filterSql;
        boolean isPerm = false;
        if (this.root == null) {
            isPerm = true;
        } else {
            GlParam glParam = GlParam.getGlParams(null, (String)"GL_053", (String)this.root.getId().toString());
            isPerm = glParam.getBoolean("GL_053");
        }
        Map ret = null;
        if (isPerm) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgViewPK = new ObjectUuidPK(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000024F2827FD"));
            ret = iPermission.getAuthorizedOrgs((IObjectPK)userPK, OrgType.Company, (IObjectPK)orgViewPK, this.uiPK, this.actionPK);
        }
        AcountSchemeInfo acountScheme = (AcountSchemeInfo)this.kcbBooks.getSelectedItem();
        String sql = this.getQuickSearchFilter();
        if (filter != null && !"".equals(filter) && sql != null && !"".equals(sql)) {
            filter = filter + " and ";
            filter = filter + sql;
        } else if (filter == null && sql != null) {
            filter = sql;
        }
        boolean flag = this.chkContainSealUp.isSelected();
        if (!flag) {
            filter = filter == null ? " and unit.isOUSealUp = 0 " : filter + " and unit.isOUSealUp = 0 ";
        }
        OrgStructureCollection orgStructCol = GLGeneralFacadeFactory.getRemoteInstance().getOrgStructureCollection(false, this.permissionItem, this.root, acountScheme, this.periodTypeID, filter);
        return this.buildCompanyTree(orgStructCol, ret);
    }

    public TreeModel getBizUnitTreeModel() throws Exception {
        String filter = this.filterSql;
        if (filter != null && this.getQuickSearchFilter() != null) {
            filter = filter + " and ";
            filter = filter + this.getQuickSearchFilter();
        } else if (filter == null && this.getQuickSearchFilter() != null) {
            filter = this.getQuickSearchFilter();
        }
        boolean flag = this.chkContainSealUp.isSelected();
        if (!flag) {
            filter = filter == null ? " and unit.isOUSealUp = 0 " : filter + " and unit.isOUSealUp = 0 ";
        }
        AcountSchemeInfo acountScheme = (AcountSchemeInfo)this.kcbBooks.getSelectedItem();
        OrgStructureCollection orgStructCol = GLGeneralFacadeFactory.getRemoteInstance().getOrgStructureCollection(true, this.permissionItem, null, acountScheme, this.periodTypeID, filter);
        return this.buildCompanyTree(orgStructCol, null);
    }

    private DefaultTreeModel buildCompanyTree(OrgStructureCollection orgStructCol, Map ret) throws BOSException {
        DefaultKingdeeTreeNode r = NewOrgViewHelper.buildTreeByRowSet2((String)(this.root == null ? null : this.root.getId().toString()), (OrgStructureCollection)orgStructCol, (StepAddParamInfo)StepAddParamInfo.rootAllInstance);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)r);
        if (r != null && r.getUserObject() != null) {
            this.filterTreeNode(r, ret);
            this.clipTreeNode(r);
            this.checkNodeValid(r);
        }
        return treeModel;
    }

    private void add(TreePath tp) {
        DefaultKingdeeTreeNode rightRoot;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        DefaultKingdeeTreeNode findNode = this.findNode(selectedNode, rightRoot = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot());
        if (findNode != null) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)findNode.getParent();
            findNode.removeFromParent();
            ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)parent);
        }
        DefaultKingdeeTreeNode toNode = null;
        for (int j = 0; j < tp.getPathCount(); ++j) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getPathComponent(j);
            DefaultKingdeeTreeNode temp = null;
            temp = this.findNode(node, (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot());
            if (temp == null) {
                this.addTo(toNode, tp, j);
                break;
            }
            toNode = temp;
        }
    }

    private void addTo(DefaultKingdeeTreeNode toNode, TreePath tp, int from) {
        DefaultKingdeeTreeNode root = null;
        while (from < tp.getPathCount()) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)tp.getPathComponent(from);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            if (from == tp.getPathCount() - 1) {
                this.cloneTree(child, oriChild);
            }
            if (toNode == null) {
                root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
                ((KingdeeTreeModel)this.treeSelected.getModel()).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)root, 0);
            } else {
                DefaultKingdeeTreeNode sibling = oriChild;
                DefaultKingdeeTreeNode found = null;
                found = this.findNode(sibling, toNode);
                if (toNode.getIndex((TreeNode)child) < 0) {
                    if (found != null) {
                        toNode.insert((MutableTreeNode)child, toNode.getIndex((TreeNode)found));
                    } else {
                        toNode.add((MutableTreeNode)child);
                    }
                    ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)toNode);
                }
            }
            toNode = child;
            ++from;
        }
    }

    private void cloneTree(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode oriRoot) {
        for (int i = 0; i < oriRoot.getChildCount(); ++i) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)oriRoot.getChildAt(i);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            root.add((MutableTreeNode)child);
            this.cloneTree(child, oriChild);
        }
    }

    DefaultKingdeeTreeNode findNode(DefaultKingdeeTreeNode source, DefaultKingdeeTreeNode dest) {
        if (dest == null) {
            return null;
        }
        OrgStructureInfo osi = (OrgStructureInfo)source.getUserObject();
        if (osi == null) {
            return null;
        }
        String sid = osi.getUnit().getId().toString();
        Object obj = dest.getUserObject();
        if (obj instanceof OrgStructureInfo ? sid.equals(((OrgStructureInfo)obj).getUnit().getId().toString()) : obj instanceof SimpleCompanyUserObject && sid.equals(((SimpleCompanyUserObject)obj).getCompanyId())) {
            return dest;
        }
        for (int i = 0; i < dest.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)dest.getChildAt(i);
            if ((child = this.findNode(source, child)) == null) continue;
            return child;
        }
        return null;
    }

    private void delete(KDTree tree) {
        TreePath[] tps = tree.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            while (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                tp = tp.getParentPath();
                node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            }
            if (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            if (node.getParent() instanceof DefaultKingdeeTreeNode) {
                ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
                this.deleteCompanyIdOfNode(node);
                continue;
            }
            KDTreeNode parent = (KDTreeNode)node.getParent();
            if (parent == null) continue;
            ((DefaultTreeModel)tree.getModel()).removeNodeFromParent((MutableTreeNode)node);
            this.deleteCompanyIdOfNode(node);
        }
    }

    public void makeSimpleTree(DefaultMutableTreeNode bigNode, DefaultMutableTreeNode simpleNode, int beginLevel) {
        SimpleCompanyUserObject newUserObject = null;
        Object obj = bigNode.getUserObject();
        if (obj instanceof SimpleCompanyUserObject) {
            newUserObject = (SimpleCompanyUserObject)((SimpleCompanyUserObject)obj).clone();
        } else {
            FullOrgUnitInfo userObject = ((OrgStructureInfo)obj).getUnit();
            newUserObject = new SimpleCompanyUserObject();
            String companyId = userObject.getId().toString();
            String longNumber = userObject.getLongNumber();
            String number = userObject.getNumber();
            String name = userObject.getName();
            boolean isLeaf = bigNode.isLeaf();
            int level = bigNode.getLevel() - beginLevel;
            if (userObject.isIsCU()) {
                newUserObject.setCuId(companyId);
            } else if (userObject.getCU() != null) {
                newUserObject.setCuId(userObject.getCU().getId().toString());
            }
            newUserObject.setCompanyId(companyId);
            newUserObject.setLongNumber(longNumber);
            newUserObject.setName(name);
            newUserObject.setNumber(number);
            newUserObject.setLeaf(isLeaf);
            newUserObject.setLevel(level);
        }
        simpleNode.setUserObject(newUserObject);
        Enumeration<TreeNode> enums = bigNode.children();
        while (enums.hasMoreElements()) {
            bigNode = (DefaultMutableTreeNode)enums.nextElement();
            DefaultMutableTreeNode simpleNode2 = new DefaultMutableTreeNode();
            simpleNode.add(simpleNode2);
            this.makeSimpleTree(bigNode, simpleNode2, beginLevel);
        }
    }

    private void confirm() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
        if (root.getChildCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)GLResUtil.getRes("select_company_please"));
            return;
        }
        DefaultMutableTreeNode simpleRoot = new DefaultMutableTreeNode();
        DefaultMutableTreeNode bigNode = (DefaultMutableTreeNode)root.getChildAt(0);
        this.makeSimpleTree(bigNode, simpleRoot, bigNode.getLevel());
        this.selectedCompany = new DefaultTreeModel(simpleRoot, false);
        this.isCanceled = false;
        if (this.dialog == null) {
            this.disposeUIWindow();
        } else {
            this.firePropertyChange("companyChanged", null, this.selectedCompany);
            this.dialog.setVisible(false);
        }
    }

    public TreeModel getData() {
        return this.selectedCompany;
    }

    public boolean isCanceled() {
        return this.isCanceled || this.selectedCompany == null;
    }

    private void cancel() {
        this.selectCompanySet.clear();
        this.isCanceled = true;
        if (this.dialog == null) {
            this.disposeUIWindow();
        } else {
            this.dialog.setVisible(false);
        }
    }

    @Override
    public void addAction_actionPerformed(ActionEvent e) throws Exception {
        this.addNode();
    }

    private void add() {
        TreePath[] tps = this.treeOrigin.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            this.add(tps[i]);
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot();
        this.treeSelected.expandAllNodes(true, (TreeNode)root);
    }

    private void addNode() {
        TreePath[] tps = this.treeOrigin.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tps[i].getLastPathComponent();
            this.addCompanyIdOfNode(node);
        }
        this.buildSelectCompany(this.selectCompanySet);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot();
        this.treeSelected.expandAllNodes(true, (TreeNode)root);
    }

    private void addCompanyIdOfNode(DefaultKingdeeTreeNode node) {
        block3: {
            block1: {
                Object obj;
                block2: {
                    if (!node.isLeaf()) break block1;
                    obj = node.getUserObject();
                    if (!(obj instanceof OrgStructureInfo)) break block2;
                    this.selectCompanySet.add(((OrgStructureInfo)obj).getUnit().getId().toString());
                    break block3;
                }
                if (!(obj instanceof SimpleCompanyUserObject)) break block3;
                this.selectCompanySet.add(((SimpleCompanyUserObject)obj).getCompanyId().toString());
                break block3;
            }
            int childCount = this.treeOrigin.getModel().getChildCount(node);
            for (int i = 0; i < childCount; ++i) {
                this.addCompanyIdOfNode((DefaultKingdeeTreeNode)this.treeOrigin.getModel().getChild(node, i));
            }
        }
    }

    private void deleteCompanyIdOfNode(DefaultKingdeeTreeNode node) {
        block3: {
            block1: {
                Object obj;
                block2: {
                    if (!node.isLeaf()) break block1;
                    obj = node.getUserObject();
                    if (!(obj instanceof OrgStructureInfo)) break block2;
                    this.selectCompanySet.remove(((OrgStructureInfo)obj).getUnit().getId().toString());
                    break block3;
                }
                if (!(obj instanceof SimpleCompanyUserObject)) break block3;
                this.selectCompanySet.remove(((SimpleCompanyUserObject)obj).getCompanyId().toString());
                break block3;
            }
            int childCount = this.treeSelected.getModel().getChildCount(node);
            for (int i = 0; i < childCount; ++i) {
                this.deleteCompanyIdOfNode((DefaultKingdeeTreeNode)this.treeSelected.getModel().getChild(node, i));
            }
        }
    }

    @Override
    public void cancelAction_actionPerformed(ActionEvent e) throws Exception {
        this.cancel();
        this.conditionText.setText("");
    }

    @Override
    public void deleteAction_actionPerformed(ActionEvent e) throws Exception {
        this.delete(this.treeSelected);
    }

    @Override
    protected void kcbBooks_actionPerformed(ActionEvent e) throws Exception {
        this.treeSelected.setSelectionRow(0);
        this.delete(this.treeSelected);
        this.treeOrigin.setSelectionRow(0);
        this.delete(this.treeOrigin);
        this.buildCompanyTree(this.uiPK, this.actionPK, this.force);
    }

    @Override
    public void oKAction_actionPerformed(ActionEvent e) throws Exception {
        this.confirm();
        this.conditionText.setText("");
    }

    @Override
    public void containSealUpAction_actionPerformed(ActionEvent e) throws Exception {
        this.buildCompanyTree(this.uiPK, this.actionPK, this.force, false);
        if (this.treeOrigin != null && this.treeOrigin.getModel() != null && this.treeOrigin.getModel().getRoot() != null) {
            this.initRootNode = (DefaultMutableTreeNode)ObjectUtils.createCopy((Object)this.treeOrigin.getModel().getRoot());
        }
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public void setAccountTableID(String accountTableID) {
        this.accountTableID = accountTableID;
    }

    public void setPeriodTypeID(String periodTypeID) {
        this.periodTypeID = periodTypeID;
    }

    public String getPeriodTypeID() {
        return this.periodTypeID;
    }

    public void setActionPK(IMetaDataPK actionPK) {
        this.actionPK = actionPK;
    }

    public void setUiPK(IMetaDataPK uiPK) {
        this.uiPK = uiPK;
    }

    protected void buildQuickQueryCombox() {
        this.checkBlured.setSelected(true);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.NUMBERANDNAME);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.NUMBER);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.NAME);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.TERRITORY);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.CITY);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.PROVINCE);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.AREA);
        this.conditionSelect.addItem((Object)ImportCompayFieldsEnum.COUNTRY);
        this.conditionSelect.setSelectedIndex(0);
        this.conditionText.setMaxLength(60);
        this.conditionText.setFocusTraversalKeysEnabled(false);
        this.conditionText.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    if (e.getKeyCode() == 10) {
                        CompanyTreeSelectUI.this.searchAction_actionPerformed(null);
                    }
                }
                catch (BOSException e1) {
                    CompanyTreeSelectUI.this.handUIException(e1);
                }
                catch (Exception e2) {
                    CompanyTreeSelectUI.this.handUIException(e2);
                }
            }
        });
        this.searchBtn.setEnabled(true);
    }

    private String getQuickSearchFilter() {
        String value;
        String string = value = StringUtils.isEmpty((String)this.conditionText.getText()) ? null : this.conditionText.getText().trim();
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        ImportCompayFieldsEnum field = (ImportCompayFieldsEnum)this.conditionSelect.getSelectedItem();
        boolean isBlured = this.checkBlured.isSelected();
        FilterInfo filter = new FilterInfo();
        Locale l = SysContext.getSysContext().getLocale();
        StringBuilder sql_country = new StringBuilder();
        sql_country.append("select oa.fid from t_org_admin oa inner join t_bd_address ba  on oa.FAddressID = ba.fid").append(" inner join t_bd_country bc on ba.fcountryid = bc.fid ");
        StringBuilder sql_province = new StringBuilder();
        sql_province.append("select oa.fid from t_org_admin oa inner join t_bd_address ba  on oa.FAddressID = ba.fid").append(" inner join t_bd_province bc on ba.fprovinceid = bc.fid ");
        StringBuilder sql_city = new StringBuilder();
        sql_city.append("select oa.fid from t_org_admin oa inner join t_bd_address ba  on oa.FAddressID = ba.fid").append(" inner join t_bd_city bc on ba.fcityidid = bc.fid ");
        StringBuilder sql_territory = new StringBuilder();
        sql_territory.append("select oa.fid from t_org_admin oa inner join t_bd_address ba  on oa.FAddressID = ba.fid").append(" inner join t_bd_region bc on ba.fdistrictidid = bc.fid ");
        StringBuilder sql_area = new StringBuilder();
        sql_area.append("select oa.fid from  t_org_admin oa inner join t_bd_area bc on oa.FAreaID = bc.fid");
        boolean isCapitalSensitiveQuery = this.isCapitalSensitiveQuery();
        StringBuilder sb = new StringBuilder();
        if (isBlured) {
            if (isCapitalSensitiveQuery) {
                if (field.equals((Object)ImportCompayFieldsEnum.NAME)) {
                    sb.append(this.prefix()).append("fname_").append(l.toString()).append(" like '%").append(value).append("%'");
                } else if (field.equals((Object)ImportCompayFieldsEnum.NUMBER)) {
                    sb.append(this.prefix()).append("fnumber like '%").append(value).append("%'");
                } else if (field.equals((Object)ImportCompayFieldsEnum.NUMBERANDNAME)) {
                    sb.append("(").append(this.prefix()).append("fnumber like '%").append(value).append("%'");
                    sb.append(" or ").append(this.prefix()).append("fname_").append(l.toString()).append(" like '%").append(value).append("%')");
                }
            } else if (field.equals((Object)ImportCompayFieldsEnum.NAME)) {
                sb.append("upper(").append(this.prefix()).append("fname_").append(l.toString()).append(") like '%").append(value.toUpperCase()).append("%'");
            } else if (field.equals((Object)ImportCompayFieldsEnum.NUMBER)) {
                sb.append("upper(").append(this.prefix()).append("fnumber) like '%").append(value.toUpperCase()).append("%'");
            } else if (field.equals((Object)ImportCompayFieldsEnum.NUMBERANDNAME)) {
                sb.append("(upper(").append(this.prefix()).append("fnumber) like '%").append(value.toUpperCase()).append("%'");
                sb.append(" or ").append("upper(").append(this.prefix()).append("fname_").append(l.toString()).append(") like '%").append(value.toUpperCase()).append("%')");
            }
            if (field.equals((Object)ImportCompayFieldsEnum.TERRITORY)) {
                sql_territory.append(" where bc.fname_").append(l.toString()).append(" like '%").append(value).append("%'");
                sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_territory).append(" )");
            } else if (field.equals((Object)ImportCompayFieldsEnum.CITY)) {
                sql_city.append(" where bc.fname_").append(l.toString()).append(" like '%").append(value).append("%'");
                sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_city).append(" )");
            } else if (field.equals((Object)ImportCompayFieldsEnum.PROVINCE)) {
                sql_province.append(" where bc.fname_").append(l.toString()).append(" like '%").append(value).append("%'");
                sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_province).append(" )");
            } else if (field.equals((Object)ImportCompayFieldsEnum.COUNTRY)) {
                sql_country.append(" where bc.fname_").append(l.toString()).append(" like '%").append(value).append("%'");
                sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_country).append(" )");
            } else if (field.equals((Object)ImportCompayFieldsEnum.AREA)) {
                sql_area.append(" where bc.fname_").append(l.toString()).append(" like '%").append(value).append("%'");
                sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_area).append(" )");
            }
        } else if (field.equals((Object)ImportCompayFieldsEnum.NAME)) {
            sb.append(this.prefix()).append("fname_").append(l.toString()).append(" = '").append(value).append("'");
        } else if (field.equals((Object)ImportCompayFieldsEnum.NUMBER)) {
            sb.append(this.prefix()).append("fnumber = '").append(value).append("'");
        } else if (field.equals((Object)ImportCompayFieldsEnum.NUMBERANDNAME)) {
            sb.append("(").append(this.prefix()).append("fnumber = '").append(value).append("'");
            sb.append(" or ").append(this.prefix()).append("fname_").append(l.toString()).append(" = '").append(value).append("')");
        } else if (field.equals((Object)ImportCompayFieldsEnum.TERRITORY)) {
            sql_territory.append(" where bc.fname_").append(l.toString()).append(" ='").append(value).append("'");
            sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_territory).append(" )");
        } else if (field.equals((Object)ImportCompayFieldsEnum.CITY)) {
            sql_city.append(" where bc.fname_").append(l.toString()).append(" ='").append(value).append("'");
            sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_city).append(" )");
        } else if (field.equals((Object)ImportCompayFieldsEnum.PROVINCE)) {
            sql_province.append(" where bc.fname_").append(l.toString()).append(" ='").append(value).append("'");
            sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_province).append(" )");
        } else if (field.equals((Object)ImportCompayFieldsEnum.COUNTRY)) {
            sql_country.append(" where bc.fname_").append(l.toString()).append(" ='").append(value).append("'");
            sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_country).append(" )");
        } else if (field.equals((Object)ImportCompayFieldsEnum.AREA)) {
            sql_area.append(" where bc.fname_").append(l.toString()).append(" ='").append(value).append("'");
            sb.append(this.prefix()).append("fid in ( ").append((CharSequence)sql_area).append(" )");
        }
        return sb.toString();
    }

    @Override
    public void searchAction_actionPerformed(ActionEvent e) throws Exception {
        this.buildCompanyTree(this.uiPK, this.actionPK, this.force, false);
    }

    private String prefix() {
        return "cp.";
    }

    public boolean isCapitalSensitiveQuery() {
        boolean isCapitalSensitiveQuery = false;
        String capitalSensitiveQuery = ParamHelper.getCapitalSensitiveQuery();
        if ("true".equalsIgnoreCase(capitalSensitiveQuery)) {
            isCapitalSensitiveQuery = true;
        }
        return isCapitalSensitiveQuery;
    }

    protected void disposeUIWindow() {
        this.conditionText.setText("");
        this.selectCompanySet.clear();
        super.disposeUIWindow();
    }

    public void setFilterSql(String filterSql) {
        this.filterSql = filterSql;
    }

    public void clearSelectCompanySet() {
        if (this.selectCompanySet != null) {
            this.selectCompanySet.clear();
        }
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void setClose(boolean isClose) {
        this.isClose = isClose;
    }
}

