/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.fi.gl.client.ComponentInitializeListener;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class ComponentUtil {
    private ComponentUtil() {
    }

    public static void attachInitializeListener(Component c, ComponentInitializeListener cil) {
        c.addComponentListener(new ComponentExListenerImpl(cil));
    }

    private static class ComponentExListenerImpl
    implements ComponentListener {
        private boolean hasInitialized = false;
        private ComponentInitializeListener cil;

        ComponentExListenerImpl(ComponentInitializeListener cil) {
            this.cil = cil;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (!this.hasInitialized) {
                this.hasInitialized = true;
                this.cil.componentAfterInitShown(e);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

