/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.client.AbstractCorrelationResultUI;
import com.kingdee.eas.fi.gl.client.CFRequisitionCorrelationUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CorrelationResultUI
extends AbstractCorrelationResultUI {
    public static final String CFREQ_RES = "com.kingdee.eas.fi.gl.CFRequisitionResource";
    private static final String CONFIRM_CANCEL_CORRELATION = "ConfirmCancelCorrelation";
    private static final Logger logger = CoreUIObject.getLogger(CorrelationResultUI.class);
    private Map params = new HashMap();
    protected boolean isCancelled = true;

    public CorrelationResultUI() throws Exception {
        this.tblCorrelationReq.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    ICFRequisition cfReq = CorrelationResultUI.this.getBizInterface();
                    IRowSet rs = cfReq.queryCorrelationCFRequisition(CorrelationResultUI.this.params);
                    e.setRowSet(rs);
                }
                catch (BOSException e1) {
                    CorrelationResultUI.this.handUIExceptionAndAbort((Exception)((Object)e1));
                }
                catch (EASBizException e2) {
                    CorrelationResultUI.this.handUIExceptionAndAbort((Exception)((Object)e2));
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.isCancelled = MsgBox.showConfirm2((String)this.getResource(CONFIRM_CANCEL_CORRELATION, null)) != 0;
        this.uiWindow.close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.isCancelled = true;
        this.uiWindow.close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map ctx = this.getUIContext();
        Object initData = ctx.get("InitDataObject");
        if (initData != null && initData instanceof Map) {
            this.params.clear();
            this.params.putAll((Map)initData);
        }
        this.tblCorrelationReq.getDataRequestManager().setDataRequestMode(0);
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.initListener();
        this.tblCorrelationReq.checkParsed();
        String[] mergeCols = new String[]{"fcorrelationNum"};
        this.tblCorrelationReq.getGroupManager().setGroup(true);
        int size = mergeCols.length;
        for (int i = 0; i < size; ++i) {
            this.tblCorrelationReq.getColumn(mergeCols[i]).setGroup(true);
            this.tblCorrelationReq.getColumn(mergeCols[i]).setMergeable(true);
        }
        this.tblCorrelationReq.getGroupManager().group();
    }

    public ICFRequisition getBizInterface() throws BOSException {
        return CFRequisitionFactory.getRemoteInstance();
    }

    public void initListener() {
        this.tblCorrelationReq.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRow = e.getFirstRow();
                int lastRow = e.getLastRow();
                for (int i = firstRow; i <= lastRow; ++i) {
                    IRow row = CorrelationResultUI.this.tblCorrelationReq.getRow(i);
                    Object value = row.getCell("fprimaryItemDirection").getValue();
                    String transValue = CFRequisitionCorrelationUI.translateCashlowDirection(String.valueOf(value));
                    row.getCell("fprimaryItemDirectionName").setValue((Object)transValue);
                    Object curpreObj = row.getCell("fprecision").getValue();
                    int curPrecision = curpreObj == null ? 0 : Integer.parseInt(String.valueOf(curpreObj));
                    row.getCell("foriginalAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(curPrecision));
                }
            }
        });
    }

    private String getResource(String key, Object[] params) {
        String message = ResourceBase.getString((String)CFREQ_RES, (String)key, (Locale)SysContext.getSysContext().getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }
}

