/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAssistCustomizedProperty;
import com.kingdee.eas.fi.gl.client.AbstractCustomPropListUI;
import com.kingdee.eas.fi.gl.client.AssistCustomizedTypeListUI;
import com.kingdee.eas.fi.gl.client.AsstInitParam;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class CustomPropListUI
extends AbstractCustomPropListUI {
    private final String COLUMN_ACCOUNTNUMBER = "Number";
    private final String COLUMN_ACCOUNTNAME = "Name";
    private final String COLUMN_PROPNAME = "Name";
    private final String COLUMN_PROPTYPE = "Type";
    private final String COLUMN_PROPDEBITMUSTINPUT = "MustdebitInput";
    private final String COLUMN_PROPCREDITMUSTINPUT = "MustCreditInput";
    private final String COLUMN_PROPDELETEDSTATUS = "deletedStatus";
    private final String PROP_KEY = "Props";
    private int numberofCancelPro = -1;
    private CompanyOrgUnitInfo company = null;
    private List accounts = new ArrayList();
    private List tempAccounts = new ArrayList();
    private AccountTableCollection tabCol = null;
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.basedata.assistant.client.AssistantDavidResource";
    AsstInitParam editParam;

    public void onLoad() throws Exception {
        this.company = InitClientHelp.getCurrentCompany();
        super.onLoad();
        this.initMyIcon();
        this.myInitElement();
        this.myInitData();
        this.myInitListener();
        if (this.tblHeader.getRowCount() > 0) {
            this.tblHeader.requestFocus();
            this.tblHeader.getSelectManager().select(0, -1);
            this.accountSelectChanged(null);
        }
        this.editParam = AsstInitParam.getInstance();
        boolean isShowLongName = this.editParam.isShowLongName();
        if (isShowLongName) {
            this.kDCheckBox1.setSelected(true);
            this.reloadAccounts();
        }
    }

    private void initMyIcon() {
        InitClientHelp.setIcon((JButton)this.btnModify, "imgTbtn_edit");
        InitClientHelp.setIcon(this.miModify, "imgTbtn_edit");
        InitClientHelp.setIcon((JButton)this.btnAdd, "imgTbtn_new");
        InitClientHelp.setIcon(this.miAdd, "imgTbtn_new");
        InitClientHelp.setIcon((JButton)this.btnDelete, "imgTbtn_delete");
        InitClientHelp.setIcon(this.miDelete, "imgTbtn_delete");
        Icon forbidBG = EASResource.getIcon((String)"imgTbtn_forbid");
        this.btnUnApprove.setIcon(forbidBG);
        this.miUnApprove.setIcon(forbidBG);
        Icon unForbidBG = EASResource.getIcon((String)"imgTbtn_staruse");
        this.btnApprove.setIcon(unForbidBG);
        this.miApprove.setIcon(unForbidBG);
        this.setButtonDefaultStyl(this.btnModify);
        this.setButtonDefaultStyl(this.btnAdd);
        this.setButtonDefaultStyl(this.btnDelete);
        this.btntype.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.menuItemType.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.setButtonDefaultStyl(this.btntype);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.actionType.setVisible(false);
    }

    private void myInitListener() {
        this.tblHeader.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getRowIndex() != -1 && e.getClickCount() == 2) {
                    try {
                        CustomPropListUI.this.modify();
                    }
                    catch (Exception t) {
                        CustomPropListUI.this.handUIException(t);
                    }
                }
            }
        });
        this.tblDetail.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    CustomPropListUI.this.tblDetail_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    CustomPropListUI.this.handUIException(exc);
                }
            }
        });
    }

    private void myInitElement() throws Exception {
        this.tblHeader.checkParsed();
        this.tblDetail.checkParsed();
        this.tblHeader.getStyleAttributes().setLocked(true);
        this.tblDetail.getStyleAttributes().setLocked(true);
        this.tblHeader.getSelectManager().setSelectMode(2);
        this.tblDetail.getSelectManager().setSelectMode(10);
    }

    private void myInitData() throws Exception {
        this.tabCol = AccountTools.getAccountTableCollection();
        this.cbAccountTable.addItems(this.tabCol.toArray());
        if (this.company.getAccountTable() != null) {
            ComboBoxModel model = this.cbAccountTable.getModel();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                Object element = model.getElementAt(i);
                if (!(element instanceof AccountTableInfo) || !((AccountTableInfo)element).getId().toString().equals(this.company.getAccountTable().getId().toString())) continue;
                this.cbAccountTable.setSelectedIndex(i);
                break;
            }
        }
    }

    private void loadAccountTable() throws Exception {
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        AccountTableInfo info = (AccountTableInfo)this.cbAccountTable.getSelectedItem();
        if (info == null) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append(" select id, account.id,account.number,account.name, account.longName");
        oql.append(" where  account.companyID.id = '");
        oql.append(companyid);
        oql.append("' and account.accountTableId.id = '");
        oql.append(info.getId().toString());
        oql.append("'");
        oql.append("  order by account.number");
        EntityViewInfo view = new EntityViewInfo(oql.toString());
        AssistCustomizedPropertyCollection col = this.getPropCtrl().getAssistCustomizedPropertyCollection(view);
        HashMap<String, AccountViewInfo> accountMap = new HashMap<String, AccountViewInfo>();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            AssistCustomizedPropertyInfo prop = (AssistCustomizedPropertyInfo)iter.next();
            AccountViewInfo account = prop.getAccount();
            accountMap.put(account.getId().toString(), account);
        }
        this.accounts = new ArrayList();
        this.accounts.addAll(accountMap.values());
        GlUtils.sortCollection(this.accounts, "number");
        this.loadAccounts(this.accounts);
    }

    private void loadAccounts(Collection accounts) {
        this.tblHeader.removeRows();
        for (AccountViewInfo account : accounts) {
            IRow row = this.tblHeader.addRow();
            row.setUserObject((Object)account);
            this.tempAccounts.add(account);
            row.getCell("Number").setValue((Object)account.getNumber());
            String accountName = null;
            accountName = this.kDCheckBox1.isSelected() ? account.getLongName(this.getLocale()) : account.getName(this.getLocale());
            row.getCell("Name").setValue((Object)accountName);
        }
    }

    private void loadProps(AccountViewInfo account) throws Exception {
        AssistCustomizedPropertyCollection col = null;
        this.queryProps(account);
        this.numberofCancelPro = 0;
        col = (AssistCustomizedPropertyCollection)((Object)account.get("Props"));
        this.tblDetail.removeRows();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            AssistCustomizedPropertyInfo info = (AssistCustomizedPropertyInfo)iter.next();
            IRow row = this.tblDetail.addRow();
            row.setUserObject((Object)info);
            row.getCell("Name").setValue((Object)info.getCustomizedType().getName());
            row.getCell("Type").setValue((Object)info.getCustomizedType().getDataType().getAlias());
            row.getCell("MustdebitInput").setValue((Object)new Boolean(info.isIsDebitNecessary()));
            row.getCell("MustCreditInput").setValue((Object)new Boolean(info.isIsCreditNecessary()));
            if (info.getDeletedStatus() == DeletedStatusEnum.DELETED) {
                row.getCell("deletedStatus").setValue((Object)Boolean.TRUE);
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                ++this.numberofCancelPro;
                continue;
            }
            row.getCell("deletedStatus").setValue((Object)Boolean.FALSE);
        }
        this.tblDetail.requestFocus();
        this.tblDetail.getSelectManager().select(0, -1);
    }

    private void queryProps(AccountViewInfo account) throws Exception {
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        String oql = "select id,seq,isNecessary,isCreditNecessary,isDebitNecessary,deletedStatus,customizedType.id,customizedType.name,customizedType.dataType  where account.companyID.id='" + companyid + "' and account.id='" + account.getId().toString() + "' order by seq";
        EntityViewInfo view = new EntityViewInfo(oql);
        AssistCustomizedPropertyCollection col = this.getPropCtrl().getAssistCustomizedPropertyCollection(view);
        account.put("Props", (Object)col);
    }

    @Override
    protected void headerSelectChanged(KDTSelectEvent e) throws Exception {
        this.accountSelectChanged(e);
    }

    private void accountSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.tblHeader.getRowCount() > 0 && this.tblHeader.getSelectManager().size() > 0) {
            int top = this.tblHeader.getSelectManager().get().getTop();
            AccountViewInfo account = (AccountViewInfo)this.tblHeader.getRow(top).getUserObject();
            this.loadProps(account);
        }
    }

    @Override
    public void addAction_actionPerformed(ActionEvent e) throws Exception {
        this.add();
    }

    private void add() throws Exception {
        if (this.company.getAccountTable() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.InitResource.currentCompanyHasNoAccountTable"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        AccountTableInfo info = (AccountTableInfo)this.cbAccountTable.getSelectedItem();
        if (info == null) {
            return;
        }
        if (!info.getId().toString().equals(this.company.getAccountTable().getId().toString())) {
            AccountTableInfo tble = this.company.getAccountTable();
            int count = this.tabCol.size();
            for (int i = 0; i < count; ++i) {
                if (!this.tabCol.get(i).getId().toString().equals(this.company.getAccountTable().getId().toString())) continue;
                tble = this.tabCol.get(i);
                break;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("disabledAcctTable.id", (Object)info.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("refType", (Object)new Integer(1)));
            if (AccountRefContrastFactory.getRemoteInstance().exists(filter)) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.client.InitResource.Msg_NotAccountTable"));
                sb.append(tble.getName());
                MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
                return;
            }
        }
        uiContext.put((Object)"AccountTable", (Object)info);
        uiContext.put((Object)"company", (Object)this.company);
        uiContext.put((Object)"tempAccounts", (Object)this.tempAccounts);
        uiContext.put((Object)"isLongName", (Object)(this.kDCheckBox1.isSelected() ? "1" : "0"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (!"confirm".equals(uiWindow.getUIObject().getUIContext().get("return_type"))) {
            return;
        }
        IRow row = null;
        Map accountList = (Map)uiWindow.getUIObject().getUIContext().get("account");
        if (accountList != null) {
            Set keyset = accountList.keySet();
            for (String key : keyset) {
                AccountViewInfo account = (AccountViewInfo)accountList.get(key);
                row = this.tblHeader.getRowCount() < 1 ? this.tblHeader.addRow() : (this.tblHeader.getSelectManager().size() > 0 ? this.tblHeader.addRow(this.tblHeader.getSelectManager().get().getTop() + 1) : this.tblHeader.addRow(this.tblHeader.getRowCount()));
                row.setUserObject((Object)account);
                row.getCell("Number").setValue((Object)account.getNumber());
                row.getCell("Name").setValue((Object)(this.kDCheckBox1.isSelected() ? account.getLongName() : account.getName()));
                this.tempAccounts.add(account);
                this.accounts.add(account);
            }
        }
        if (row != null) {
            this.tblHeader.getSelectManager().select(row.getRowIndex(), -1);
        }
        uiWindow.close();
    }

    private String getEditUIName() {
        return "com.kingdee.eas.fi.gl.client.CustomPropEditUI";
    }

    @Override
    public void deleteAction_actionPerformed(ActionEvent e) throws Exception {
        this.delete();
        CacheServiceFactory.getInstance().discardType(new BOSObjectType("C49E6E58"));
        CacheServiceFactory.getInstance().discardType(new BOSObjectType("9DA99826"));
    }

    private void delete() throws Exception {
        this.checkSelected();
        if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete"))) {
            int top = this.tblHeader.getSelectManager().get().getTop();
            AccountViewInfo account = (AccountViewInfo)this.tblHeader.getRow(top).getUserObject();
            this.accounts.remove(account);
            this.tempAccounts.remove(account);
            account = (AccountViewInfo)account.clone();
            account.remove("Props");
            this.getPropCtrl().deleteByAccount(account);
            this.tblHeader.removeRow(top);
            this.tblDetail.removeRows();
            this.accountSelectChanged(null);
        }
    }

    @Override
    public void modifyAction_actionPerformed(ActionEvent e) throws Exception {
        this.modify();
    }

    private void modify() throws Exception {
        this.checkSelected();
        AccountTableInfo info = (AccountTableInfo)this.cbAccountTable.getSelectedItem();
        if (info == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"company", (Object)this.company);
        uiContext.put((Object)"AccountTable", (Object)info);
        IRow row = this.tblHeader.getRow(this.tblHeader.getSelectManager().get().getTop());
        AccountViewInfo account = (AccountViewInfo)row.getUserObject();
        uiContext.put((Object)"account", (Object)account);
        uiContext.put((Object)"isLongName", (Object)(this.kDCheckBox1.isSelected() ? "1" : "0"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        if (!"confirm".equals(uiWindow.getUIObject().getUIContext().get("return_type"))) {
            return;
        }
        Map accountList = (Map)uiWindow.getUIObject().getUIContext().get("account");
        if (accountList != null) {
            Set keyset = accountList.keySet();
            for (String key : keyset) {
                account = (AccountViewInfo)accountList.get(key);
                row.setUserObject((Object)account);
                row.getCell("Number").setValue((Object)account.getNumber());
                String accountName = null;
                accountName = this.kDCheckBox1.isSelected() ? account.getLongName(this.getLocale()) : account.getName(this.getLocale());
                row.getCell("Name").setValue((Object)accountName);
                this.loadProps(account);
            }
        }
        uiWindow.close();
    }

    private IAssistCustomizedProperty getPropCtrl() throws Exception {
        return AssistCustomizedPropertyFactory.getRemoteInstance();
    }

    @Override
    protected void cbAccountTable_itemStateChanged(ItemEvent e) throws Exception {
        this.tblDetail.removeRows();
        this.loadAccountTable();
        if (this.tblHeader.getRowCount() > 0) {
            this.tblHeader.getSelectManager().select(0, -1);
        }
    }

    private void tblDetail_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock sb = this.tblDetail.getSelectManager().get();
        if (sb != null) {
            int top = sb.getTop();
            IRow row = this.tblDetail.getRow(top);
            AssistCustomizedPropertyInfo info = (AssistCustomizedPropertyInfo)row.getUserObject();
            if (info.getDeletedStatus() == DeletedStatusEnum.DELETED) {
                this.btnApprove.setEnabled(true);
                this.btnUnApprove.setEnabled(false);
                this.miApprove.setEnabled(true);
                this.miUnApprove.setEnabled(false);
            } else {
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(true);
                this.miApprove.setEnabled(false);
                this.miUnApprove.setEnabled(true);
            }
        }
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK logPK = LogUtil.beginLog(null, (String)"actionApprove_actionPerformed", (BOSObjectType)new BOSObjectType("F3F9C04F"), null, (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"362_CustomPropListUI"), (String)"gl_assistcustomizedproperty_unApprove");
        this.changeApprove(DeletedStatusEnum.DELETED);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FILE_NAME, (String)"disableSuccessed"));
        CacheServiceFactory.getInstance().discardType(new BOSObjectType("C49E6E58"));
        CacheServiceFactory.getInstance().discardType(new BOSObjectType("9DA99826"));
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IObjectPK logPK = LogUtil.beginLog(null, (String)"actionApprove_actionPerformed", (BOSObjectType)new BOSObjectType("F3F9C04F"), null, (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"363_CustomPropListUI"), (String)"gl_assistcustomizedproperty_approve");
        this.changeApprove(DeletedStatusEnum.NORMAL);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FILE_NAME, (String)"enableSuccessed"));
        CacheServiceFactory.getInstance().discardType(new BOSObjectType("C49E6E58"));
        CacheServiceFactory.getInstance().discardType(new BOSObjectType("9DA99826"));
    }

    private void changeApprove(DeletedStatusEnum isApprove) throws Exception {
        if (this.tblHeader.getRowCount() < 1 || this.tblHeader.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        int top = this.tblHeader.getSelectManager().get().getTop();
        AccountViewInfo account = (AccountViewInfo)this.tblHeader.getRow(top).getUserObject();
        if (this.numberofCancelPro == this.tblDetail.getRowCount() && isApprove == DeletedStatusEnum.NORMAL) {
            this.getPropCtrl().dealAssistRecordAndAccount(account.getId().toString(), true);
        }
        KDTSelectManager sm = this.tblDetail.getSelectManager();
        if (this.tblDetail.getSelectManager().getActiveRowIndex() < 0) {
            int bottom = this.tblDetail.getRowCount();
            for (int j = 0; j < bottom; ++j) {
                IRow row = this.tblDetail.getRow(j);
                AssistCustomizedPropertyInfo customizedPropert = (AssistCustomizedPropertyInfo)row.getUserObject();
                if (customizedPropert.getDeletedStatus() == isApprove) continue;
                IAssistCustomizedProperty info = this.getPropCtrl();
                info.doApprove(customizedPropert.getId().toString(), isApprove);
            }
        } else {
            KDTSelectBlock block;
            int i;
            boolean tableSelected = false;
            for (i = 0; i < sm.size(); ++i) {
                block = sm.get(i);
                if (8 != block.getMode()) continue;
                tableSelected = true;
                break;
            }
            if (tableSelected) {
                int bottom = this.tblDetail.getRowCount();
                for (int j = 0; j < bottom; ++j) {
                    IRow row = this.tblDetail.getRow(j);
                    AssistCustomizedPropertyInfo customizedPropert = (AssistCustomizedPropertyInfo)row.getUserObject();
                    if (customizedPropert.getDeletedStatus() == isApprove) continue;
                    IAssistCustomizedProperty info = this.getPropCtrl();
                    info.doApprove(customizedPropert.getId().toString(), isApprove);
                }
            } else {
                for (i = 0; i < sm.size(); ++i) {
                    block = sm.get(i);
                    int bottom = block.getBottom();
                    for (int j = block.getTop(); j <= bottom; ++j) {
                        IRow row = this.tblDetail.getRow(j);
                        AssistCustomizedPropertyInfo customizedPropert = (AssistCustomizedPropertyInfo)row.getUserObject();
                        if (customizedPropert.getDeletedStatus() == isApprove) continue;
                        IAssistCustomizedProperty info = this.getPropCtrl();
                        info.doApprove(customizedPropert.getId().toString(), isApprove);
                    }
                }
            }
        }
        this.loadProps(account);
        if (this.numberofCancelPro == this.tblDetail.getRowCount() && isApprove == DeletedStatusEnum.DELETED) {
            this.getPropCtrl().dealAssistRecordAndAccount(account.getId().toString(), false);
        }
    }

    @Override
    public void actionShowLongName_actionPerformed(ActionEvent e) throws Exception {
        int top = this.tblHeader.getSelectManager().getActiveRowIndex();
        int left = this.tblHeader.getSelectManager().getActiveColumnIndex();
        this.reloadAccounts();
        this.tblHeader.getSelectManager().set(top, left);
    }

    @Override
    public void actionType_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssistCustomizedTypeListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void reloadAccounts() {
        int rowCount = this.tblHeader.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblHeader.getRow(i);
            AccountViewInfo account = (AccountViewInfo)row.getUserObject();
            String accountName = null;
            accountName = this.kDCheckBox1.isSelected() ? account.getLongName() : account.getName(this.getLocale());
            row.getCell("Name").setValue((Object)accountName);
        }
    }

    public boolean destroyWindow() {
        this.editParam.setShowLongName(this.kDCheckBox1.isSelected());
        try {
            this.editParam.sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.destroyWindow();
    }

    public void checkSelected() {
        if (this.tblHeader.getRowCount() == 0 || this.tblHeader.getSelectManager().get() == null || this.tblHeader.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

