/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.GLAsstBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceCollection;
import com.kingdee.eas.fi.gl.GLBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceKey;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Iterator;

public class DeficitBalanceValidator {
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.VoucherEditResource";
    private CoreUI ui;
    private int cashAlert = 0;
    @Deprecated
    private boolean acAlert = false;
    private int acAlert_new = 2;
    VoucherInfo oldVoucher;
    VoucherInfo voucher;
    private int actionType = 0;

    @Deprecated
    public DeficitBalanceValidator(CoreUI ui, VoucherInfo oldVoucher, VoucherInfo voucher, int cashAlert, boolean acAlert, int actionType) {
        this.ui = ui;
        this.cashAlert = cashAlert;
        this.acAlert = acAlert;
        this.oldVoucher = oldVoucher;
        this.voucher = voucher;
        this.actionType = actionType;
    }

    public DeficitBalanceValidator(CoreUI ui, VoucherInfo oldVoucher, VoucherInfo voucher, int cashAlert, int acAlert_new, int actionType) {
        this.ui = ui;
        this.cashAlert = cashAlert;
        this.acAlert_new = acAlert_new;
        this.oldVoucher = oldVoucher;
        this.voucher = voucher;
        this.actionType = actionType;
    }

    public boolean validate() throws Exception {
        if (this.cashAlert == 2 && this.acAlert_new == 2) {
            return true;
        }
        for (VoucherEntryInfo entry : this.oldVoucher.getEntries()) {
            if (entry.getAccount() == null) continue;
            entry.getAccount().setCAA(entry.getCAA());
        }
        for (VoucherEntryInfo entry : this.voucher.getEntries()) {
            if (entry.getAccount() == null) continue;
            entry.getAccount().setCAA(entry.getCAA());
        }
        int action = this.actionType == 0 || this.actionType == 2 ? 0 : 1;
        VoucherStatusEnum temp = this.oldVoucher.getBizStatus();
        if (action == 0 && (temp == VoucherStatusEnum.AUDITTED || temp == VoucherStatusEnum.POSTED)) {
            this.oldVoucher.setBizStatus(VoucherStatusEnum.SUBMITTED);
        }
        GLBalanceCollection deficitBalColl = AccountBalanceFactory.getRemoteInstance().getDeficitBalance(this.oldVoucher, this.voucher, action);
        this.oldVoucher.setBizStatus(temp);
        if (deficitBalColl == null || deficitBalColl.size() == 0) {
            return true;
        }
        boolean hasCashAccount = false;
        boolean hasAcAccount = false;
        StringBuffer msg = new StringBuffer();
        GLBalanceInfo balInfo = null;
        Iterator it = deficitBalColl.iterator();
        String deficitMsg = null;
        while (it.hasNext()) {
            balInfo = (GLBalanceInfo)it.next();
            if (!hasCashAccount && (balInfo.getKey().getAccount().isIsCash() || balInfo.getKey().getAccount().isIsBank() || balInfo.getKey().getAccount().isIsCashEquivalent())) {
                hasCashAccount = true;
            } else if (!hasAcAccount && balInfo.getKey().getAccount().isAC()) {
                hasAcAccount = true;
            }
            deficitMsg = this.getDeficitMsg(balInfo);
            if (balInfo.compareToZero() >= 0 && (deficitMsg == null || deficitMsg.length() == 0)) continue;
            msg.append(deficitMsg);
        }
        if (msg.length() == 0) {
            return true;
        }
        if (hasCashAccount && this.cashAlert == 0 || hasAcAccount && this.acAlert_new == 0) {
            MsgBox.showDetailAndOK((Component)this.ui, (String)this.getStr("DEFICIT_FORBIDDEN"), (String)msg.toString(), (int)0);
            return false;
        }
        if (hasCashAccount && this.cashAlert == 1 || hasAcAccount && this.acAlert_new == 1) {
            int result = MsgBox.showConfirm3((Component)this.ui, (String)this.getStr("ACCOUNT_DEFICIT"), (String)msg.toString());
            if (result != 0) {
                return false;
            }
            if (this.actionType == 0) {
                this.voucher.put("isDeficitValidated", (Object)true);
            }
        }
        return true;
    }

    private String getDeficitMsg(GLBalanceInfo balInfo) throws Exception {
        GLBalanceKey key = balInfo.getKey();
        StringBuffer msg = new StringBuffer();
        if (balInfo.compareToZero() < 0) {
            msg.append(MessageFormat.format(this.getStr("SubmitNegroAccount"), key.getAccount().getNumber(), key.getCurrency().getName())).append("\r\n");
        }
        if (key.getAccount().getCAA() != null && balInfo.getAsstBalColl() != null && balInfo.getAsstBalColl().size() > 0) {
            Iterator asstIt = balInfo.getAsstBalColl().iterator();
            while (asstIt.hasNext()) {
                GLAsstBalanceInfo asstBalInfo = (GLAsstBalanceInfo)asstIt.next();
                if (asstBalInfo.compareToZero() >= 0) continue;
                AssistantHGInfo hg = asstBalInfo.getKey().getHg();
                String hgName = hg.getLongNameGroup();
                if (hgName == null) {
                    hgName = this.getLongName(hg.getId().toString());
                }
                msg.append(MessageFormat.format(this.getStr("SubmitNegroAsst"), key.getAccount().getNumber(), key.getCurrency().getName(), hgName)).append("\r\n");
            }
        }
        return msg.toString();
    }

    private String getLongName(String hgId) throws Exception {
        if (hgId == null || hgId.trim().length() == 0) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longNameGroup"));
        AssistantHGInfo info = AssistantHGFactory.getRemoteInstance().getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hgId), sic);
        return info.getLongNameGroup();
    }

    public String getStr(String n) {
        return EASResource.getString((String)RESOURCE_PATH, (String)n);
    }
}

