/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.DiffItemRecordFactory;
import com.kingdee.eas.fi.gl.client.AbstractDiffItemRecordAutoUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class DiffItemRecordAutoUI
extends AbstractDiffItemRecordAutoUI {
    private static final Logger logger = CoreUIObject.getLogger(DiffItemRecordAutoUI.class);
    private boolean stop = false;
    private List<String> ids = null;
    private List<String> numbers = null;
    public static final String RES = "com.kingdee.eas.fi.gl.DiffItemRecordAutoUIResource";

    public void onLoad() throws Exception {
        super.onLoad();
        Map ctx = this.getUIContext();
        this.ids = (List)ctx.get("ids");
        this.numbers = (List)ctx.get("numbers");
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.rbUnspecified);
        group.add((AbstractButton)this.rbAll);
        group.add((AbstractButton)this.rbRespecified);
        this.rbUnspecified.setSelected(true);
        this.txtConsole.setEditable(false);
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
    }

    private void enableComponent(boolean enable) {
        this.rbUnspecified.setEnabled(enable);
        this.rbAll.setEnabled(enable);
        this.rbRespecified.setEnabled(enable);
        this.actionCancel.setEnabled(false);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnOk.getClientProperty((Object)"close") != null) {
            this.destroyWindow();
            return;
        }
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionConfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        final HashMap<String, Integer> params = new HashMap<String, Integer>();
        if (this.rbUnspecified.isSelected()) {
            params.put("range", 1);
        } else if (this.rbAll.isSelected()) {
            params.put("range", 2);
        } else if (this.rbRespecified.isSelected()) {
            params.put("range", 3);
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DiffItemRecordAutoUI.this.btnOk.putClientProperty((Object)"canStop", (Object)true);
                    DiffItemRecordAutoUI.this.btnOk.setText(DiffItemRecordAutoUI.this.getResource("stop"));
                    DiffItemRecordAutoUI.this.enableComponent(false);
                    for (int i = 0; i < DiffItemRecordAutoUI.this.ids.size(); ++i) {
                        String id = (String)DiffItemRecordAutoUI.this.ids.get(i);
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(id);
                        try {
                            Map map = DiffItemRecordFactory.getRemoteInstance().autoAssign(list, params);
                            String info = (String)map.get(id);
                            if (info != null) {
                                if (info.startsWith("e")) {
                                    DiffItemRecordAutoUI.this.showInfo(DiffItemRecordAutoUI.this.getResource("voucher") + "[" + (String)DiffItemRecordAutoUI.this.numbers.get(i) + "]\uff1a" + info.substring(1) + "\n", Color.RED);
                                } else {
                                    DiffItemRecordAutoUI.this.showInfo(DiffItemRecordAutoUI.this.getResource("voucher") + "[" + (String)DiffItemRecordAutoUI.this.numbers.get(i) + "]\uff1a" + info + "\n", Color.BLACK);
                                }
                            } else {
                                DiffItemRecordAutoUI.this.showInfo(DiffItemRecordAutoUI.this.getResource("voucher") + "[" + (String)DiffItemRecordAutoUI.this.numbers.get(i) + "]\uff1a" + DiffItemRecordAutoUI.this.getResource("no_process") + "\n", Color.BLACK);
                            }
                        }
                        catch (Exception e) {
                            DiffItemRecordAutoUI.this.showInfo(DiffItemRecordAutoUI.this.getResource("voucher") + "[" + (String)DiffItemRecordAutoUI.this.numbers.get(i) + "]\uff1a" + DiffItemRecordAutoUI.this.getResource("exception_happened") + "\uff1a" + e.getMessage() + "\n", Color.RED);
                            logger.error((Object)"", (Throwable)e);
                        }
                        if (!DiffItemRecordAutoUI.this.stop) continue;
                        if (i < DiffItemRecordAutoUI.this.ids.size() - 1) {
                            DiffItemRecordAutoUI.this.showInfo(DiffItemRecordAutoUI.this.getResource("stop") + "\n", Color.RED);
                        }
                        break;
                    }
                }
                finally {
                    DiffItemRecordAutoUI.this.btnOk.putClientProperty((Object)"close", (Object)true);
                    DiffItemRecordAutoUI.this.actionConfirm.setEnabled(true);
                    DiffItemRecordAutoUI.this.btnOk.setEnabled(true);
                    DiffItemRecordAutoUI.this.btnOk.setText(DiffItemRecordAutoUI.this.getResource("close"));
                }
            }
        }).start();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    private void showInfo(final String info, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = DiffItemRecordAutoUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), info, attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                DiffItemRecordAutoUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    public static Object showMe(Object owner, List<String> ids, List<String> numbers) {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"ids", ids);
        uiContext.put((Object)"numbers", numbers);
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.DiffItemRecordAutoUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getResource(String resName) {
        return EASResource.getString((String)RES, (String)resName);
    }
}

