/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.DiffEntryWrapper;
import com.kingdee.eas.fi.gl.DiffItemCollection;
import com.kingdee.eas.fi.gl.DiffItemDC;
import com.kingdee.eas.fi.gl.DiffItemFactory;
import com.kingdee.eas.fi.gl.DiffItemFlag;
import com.kingdee.eas.fi.gl.DiffItemInfo;
import com.kingdee.eas.fi.gl.DiffItemRecordCollection;
import com.kingdee.eas.fi.gl.DiffItemRecordFactory;
import com.kingdee.eas.fi.gl.DiffItemRecordInfo;
import com.kingdee.eas.fi.gl.DiffItemUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractDiffItemRecordEditUI;
import com.kingdee.eas.fi.gl.client.DiffItemF7Selector;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DiffItemRecordEditUI
extends AbstractDiffItemRecordEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DiffItemRecordEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.DiffItemResource";
    private TblDiffRowSwitchListener tblDiffRowSwitchListener = new TblDiffRowSwitchListener();
    private TblDiffEditAdapter tblDiffEditAdapter = new TblDiffEditAdapter();
    private TblCheckEditAdapter tblCheckEditAdapter = new TblCheckEditAdapter();
    private TblCheckKeyListener tblCheckKeyListener = new TblCheckKeyListener();
    private KDTDefaultCellEditor diEditor101;
    private KDTDefaultCellEditor diEditor102;
    private KDTDefaultCellEditor diEditor103;
    private KDTDefaultCellEditor diEditor104;
    private Set<String> num101 = new HashSet<String>();
    private Set<String> num102 = new HashSet<String>();
    private Set<String> num103 = new HashSet<String>();
    private Set<String> num104 = new HashSet<String>();
    private Map<String, Object> cache = new HashMap<String, Object>();
    private int curTblDiffRowIndex = -1;
    protected VoucherInfo voucher;
    protected CompanyOrgUnitInfo company;
    protected CurrencyInfo localCurrency;
    protected DiffItemRecordCollection diRecords;
    protected Map<String, Object> analysis;
    protected Map<VoucherEntryInfo, DiffEntryWrapper> wrappers;
    protected Vector<DiffEntryWrapper> diffWrappers;
    protected Vector<DiffEntryWrapper> checkWrappers;
    private List<RowData> rowDatas = new ArrayList<RowData>();
    protected Object returnValue = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.initTable();
        this.loadData();
        this.attachListeners();
        if (this.tblDiff.getRowCount() > 0) {
            this.tblDiff.getSelectManager().select(0, 0);
        }
    }

    protected void initData() throws Exception {
        DiffEntryWrapper wrapper;
        Map ctx = this.getUIContext();
        this.voucher = (VoucherInfo)ctx.get("voucher");
        this.company = GlUtils.getCompanyById(null, this.voucher.getCompany().getId().toString());
        this.localCurrency = this.company.getBaseCurrency();
        this.diRecords = (DiffItemRecordCollection)((Object)ctx.get("diRecords"));
        if (this.diRecords == null) {
            this.diRecords = new DiffItemRecordCollection();
        }
        this.analysis = (Map)ctx.get("analysis");
        List diffEntries = (List)this.analysis.get("diffEntries");
        List checkEntries = (List)this.analysis.get("checkEntries");
        BigDecimal inDiffAmt = (BigDecimal)this.analysis.get("inDiffAmt");
        BigDecimal exDiffAmt = (BigDecimal)this.analysis.get("exDiffAmt");
        this.wrappers = new HashMap<VoucherEntryInfo, DiffEntryWrapper>();
        this.diffWrappers = new Vector();
        this.checkWrappers = new Vector();
        for (VoucherEntryInfo entry : diffEntries) {
            wrapper = new DiffEntryWrapper(entry);
            this.wrappers.put(entry, wrapper);
            if (wrapper.isIncome()) {
                if (inDiffAmt.compareTo(GlUtils.zero) == 0) continue;
                this.diffWrappers.add(wrapper);
                continue;
            }
            if (exDiffAmt.compareTo(GlUtils.zero) == 0) continue;
            this.diffWrappers.add(wrapper);
        }
        for (VoucherEntryInfo entry : checkEntries) {
            wrapper = new DiffEntryWrapper(entry);
            this.wrappers.put(entry, wrapper);
            this.checkWrappers.add(wrapper);
        }
        this.num101.add("10101");
        this.num101.add("10102");
        this.num101.add("2");
        this.num102.add("10201");
        this.num102.add("10202");
        this.num102.add("10203");
        this.num102.add("10204");
        this.num102.add("2");
        this.num103.add("10301");
        this.num103.add("10302");
        this.num103.add("2");
        this.num104.add("10401");
        this.num104.add("10402");
        this.num104.add("10403");
        this.num104.add("10404");
        this.num104.add("2");
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDSplitPane1.setBorder(BorderFactory.createLineBorder(new Color(145, 148, 140), 1));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiffItemRecordEditUI.this.kDSplitPane1.setDividerLocation(0.5);
            }
        });
        this.btnDiffAutoAssign.setText(null);
        this.btnDiffAutoAssign.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnAddLine.setText(null);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDiffClear.setText(null);
        this.btnDiffClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnAddCheckLine.setText(null);
        this.btnAddCheckLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertCheckLine.setText(null);
        this.btnInsertCheckLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveCheckLine.setText(null);
        this.btnRemoveCheckLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnCheckClear.setText(null);
        this.btnCheckClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.pnDiffTool.remove((Component)this.lbDiffAccount);
        this.pnDiffTool.remove((Component)this.btnDiffAutoAssign);
        this.pnDiffTool.remove((Component)this.btnAddLine);
        this.pnDiffTool.remove((Component)this.btnInsertLine);
        this.pnDiffTool.remove((Component)this.btnRemoveLine);
        this.pnDiffTool.remove((Component)this.btnDiffClear);
        this.pnDiffTool.setLayout((LayoutManager)new BoxLayout((Container)this.pnDiffTool, 0));
        this.pnDiffTool.add(Box.createHorizontalStrut(2));
        this.pnDiffTool.add((Component)this.lbDiffAccount);
        this.pnDiffTool.add(Box.createHorizontalGlue());
        this.pnDiffTool.add((Component)this.btnDiffAutoAssign);
        this.pnDiffTool.add(Box.createHorizontalStrut(2));
        this.pnDiffTool.add((Component)this.btnAddLine);
        this.pnDiffTool.add(Box.createHorizontalStrut(2));
        this.pnDiffTool.add((Component)this.btnInsertLine);
        this.pnDiffTool.add(Box.createHorizontalStrut(2));
        this.pnDiffTool.add((Component)this.btnRemoveLine);
        this.pnDiffTool.add(Box.createHorizontalStrut(2));
        this.pnDiffTool.add((Component)this.btnDiffClear);
        this.pnDiffTool.add(Box.createHorizontalStrut(2));
        this.pnCheckTool.remove((Component)this.lbCheckAccount);
        this.pnCheckTool.remove((Component)this.btnAddCheckLine);
        this.pnCheckTool.remove((Component)this.btnInsertCheckLine);
        this.pnCheckTool.remove((Component)this.btnRemoveCheckLine);
        this.pnCheckTool.remove((Component)this.btnCheckClear);
        this.pnCheckTool.setLayout((LayoutManager)new BoxLayout((Container)this.pnCheckTool, 0));
        this.pnCheckTool.add(Box.createHorizontalStrut(2));
        this.pnCheckTool.add((Component)this.lbCheckAccount);
        this.pnCheckTool.add(Box.createHorizontalGlue());
        this.pnCheckTool.add((Component)this.btnAddCheckLine);
        this.pnCheckTool.add(Box.createHorizontalStrut(2));
        this.pnCheckTool.add((Component)this.btnInsertCheckLine);
        this.pnCheckTool.add(Box.createHorizontalStrut(2));
        this.pnCheckTool.add((Component)this.btnRemoveCheckLine);
        this.pnCheckTool.add(Box.createHorizontalStrut(2));
        this.pnCheckTool.add((Component)this.btnCheckClear);
        this.pnCheckTool.add(Box.createHorizontalStrut(2));
    }

    protected void initTable() {
        this.tblDiff.checkParsed();
        this.tblCheck.checkParsed();
        this.tblDiff.getSelectManager().setSelectMode(1);
        this.tblDiff.getColumn("currency").getStyleAttributes().setLocked(true);
        this.tblDiff.getColumn("entryDC").getStyleAttributes().setLocked(true);
        this.tblDiff.getColumn("amount").getStyleAttributes().setLocked(true);
        this.tblDiff.getColumn("localAmount").getStyleAttributes().setLocked(true);
        this.tblDiff.getColumn("assignedLocalAmount").getStyleAttributes().setLocked(true);
        this.tblDiff.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblDiff.getColumn("localAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblDiff.getColumn("assignedLocalAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        ActionMap diffActionMap = this.tblDiff.getActionMap();
        diffActionMap.put("FocusChangeCol", null);
        diffActionMap.put("FocusChangeRow", null);
        diffActionMap.put("FocusChangeColReverse", null);
        diffActionMap.put("FocusChangeRowReverse", null);
        this.tblCheck.getSelectManager().setSelectMode(1);
        this.tblCheck.getColumn("diffItemDC").getStyleAttributes().setLocked(true);
        this.tblCheck.getColumn("amount").getStyleAttributes().setLocked(true);
        this.tblCheck.getColumn("localAmount").getStyleAttributes().setLocked(true);
        this.tblCheck.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCheck.getColumn("localAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCheck.getColumn("assignedLocalAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblCheck.getColumn("assignedLocalAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(this.localCurrency.getPrecision()));
        ActionMap checkActionMap = this.tblDiff.getActionMap();
        checkActionMap.put("FocusChangeCol", null);
        checkActionMap.put("FocusChangeRow", null);
        checkActionMap.put("FocusChangeColReverse", null);
        checkActionMap.put("FocusChangeRowReverse", null);
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setDataVerifierType(-1);
        formattedTextField.setSupportedEmpty(true);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        formattedTextField.setPrecision(this.localCurrency.getPrecision());
        KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        numberEditor.setClickCountToStart(1);
        this.tblCheck.getColumn("assignedLocalAmount").setEditor((ICellEditor)numberEditor);
    }

    protected void attachListeners() {
        this.tblDiff.addKDTActiveCellListener((KDTActiveCellListener)this.tblDiffRowSwitchListener);
        this.tblDiff.addKDTEditListener((KDTEditListener)this.tblDiffEditAdapter);
        this.tblCheck.addKDTEditListener((KDTEditListener)this.tblCheckEditAdapter);
        Component comp = this.tblCheck.getColumn("assignedLocalAmount").getEditor().getFocusComponent();
        comp.addKeyListener(this.tblCheckKeyListener);
    }

    protected void detachListeners() {
        this.tblDiff.removeKDTActiveCellListener((KDTActiveCellListener)this.tblDiffRowSwitchListener);
        this.tblDiff.removeKDTEditListener((KDTEditListener)this.tblDiffEditAdapter);
        this.tblCheck.removeKDTEditListener((KDTEditListener)this.tblCheckEditAdapter);
        Component comp = this.tblCheck.getColumn("assignedLocalAmount").getEditor().getFocusComponent();
        comp.removeKeyListener(this.tblCheckKeyListener);
    }

    protected void loadData() {
        BigDecimal inDiffAmt = (BigDecimal)this.analysis.get("inDiffAmt");
        BigDecimal exDiffAmt = (BigDecimal)this.analysis.get("exDiffAmt");
        this.txtIncomeDiff.setText(GlUtils.setScale(inDiffAmt, this.localCurrency.getPrecision()).toString());
        this.txtExpenseDiff.setText(GlUtils.setScale(exDiffAmt, this.localCurrency.getPrecision()).toString());
        this.txtTotalDiff.setText(GlUtils.setScale(inDiffAmt.add(exDiffAmt), this.localCurrency.getPrecision()).toString());
        KDTDefaultCellEditor diffEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox(this.diffWrappers));
        this.tblDiff.getColumn("account").setEditor((ICellEditor)diffEditor);
        KDTDefaultCellEditor comboBoxEditor = new KDTDefaultCellEditor((JComboBox)new KDComboBox(this.checkWrappers));
        this.tblCheck.getColumn("account").setEditor((ICellEditor)comboBoxEditor);
        this.diEditor101 = this.createDiEditor(this.num101);
        this.diEditor102 = this.createDiEditor(this.num102);
        this.diEditor103 = this.createDiEditor(this.num103);
        this.diEditor104 = this.createDiEditor(this.num104);
        ObjectValueRender simpleObjectRender = new ObjectValueRender();
        simpleObjectRender.setFormat((IDataFormat)new BizDataFormat("$number$ - $name$"));
        this.tblCheck.getColumn("diffItem").setRenderer((IBasicRender)simpleObjectRender);
        if (this.diRecords.size() > 0) {
            HashMap<VoucherEntryInfo, RowData> rdMap = new HashMap<VoucherEntryInfo, RowData>();
            Iterator it = this.diRecords.iterator();
            while (it.hasNext()) {
                DiffItemRecordInfo record = (DiffItemRecordInfo)it.next();
                RowData rowData = (RowData)rdMap.get(record.getDiffEntry());
                if (rowData == null) {
                    rowData = new RowData();
                    rowData.wrapper = this.wrappers.get(record.getDiffEntry());
                    this.rowDatas.add(rowData);
                    rdMap.put(record.getDiffEntry(), rowData);
                }
                rowData.records.add((DiffItemRecordInfo)record.clone());
            }
        }
        for (RowData rowData : this.rowDatas) {
            IRow row = this.tblDiff.addRow();
            this.loadDiffData(row, rowData);
        }
        this.refreshAssignedLocalAmount();
    }

    private DiffItemInfo getDiffItem(String number) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        view.setSelector(this.getDiSelector());
        try {
            DiffItemCollection coll = DiffItemFactory.getRemoteInstance().getDiffItemCollection(view);
            if (coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private SelectorItemCollection getDiSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("dc"));
        return sic;
    }

    public KDTDefaultCellEditor createDiEditor(Set<String> nums) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("number", nums, CompareType.INCLUDE));
        KDBizPromptBox bizPiPromptBox = new KDBizPromptBox();
        bizPiPromptBox.setEditable(true);
        bizPiPromptBox.setDisplayFormat("$number$;$name$");
        bizPiPromptBox.setEditFormat("$number$;$name$");
        bizPiPromptBox.setCommitFormat("$number$;$name$");
        bizPiPromptBox.setQueryInfo("com.kingdee.eas.fi.gl.app.F7DiffItemQuery");
        SelectorItemCollection sic = this.getDiSelector();
        bizPiPromptBox.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        bizPiPromptBox.setEntityViewInfo(view);
        DiffItemF7Selector selector = new DiffItemF7Selector((IUIObject)this, filter);
        bizPiPromptBox.setSelector((KDPromptSelector)selector);
        return new KDTDefaultCellEditor((IKDEditor)bizPiPromptBox);
    }

    private void refreshAssignedLocalAmount() {
        BigDecimal inDiffAssigned = GlUtils.zero;
        BigDecimal exDiffAssigned = GlUtils.zero;
        for (RowData rowData : this.rowDatas) {
            if (rowData.wrapper == null) continue;
            if (rowData.wrapper.isIncome()) {
                inDiffAssigned = inDiffAssigned.add(rowData.getAssignedLocalAmount());
                continue;
            }
            if (!rowData.wrapper.isExpense()) continue;
            exDiffAssigned = exDiffAssigned.add(rowData.getAssignedLocalAmount());
        }
        this.txtIncomeDiffAssigned.setText(GlUtils.setScale(inDiffAssigned, this.localCurrency.getPrecision()).toString());
        this.txtExpenseDiffAssigned.setText(GlUtils.setScale(exDiffAssigned, this.localCurrency.getPrecision()).toString());
        this.txtTotalDiffAssigned.setText(GlUtils.setScale(inDiffAssigned.add(exDiffAssigned), this.localCurrency.getPrecision()).toString());
        BigDecimal inDiffAmt = (BigDecimal)this.analysis.get("inDiffAmt");
        BigDecimal exDiffAmt = (BigDecimal)this.analysis.get("exDiffAmt");
        this.txtIncomeDiffUnassigned.setText(GlUtils.setScale(inDiffAmt.subtract(inDiffAssigned), this.localCurrency.getPrecision()).toString());
        this.txtExpenseDiffUnassigned.setText(GlUtils.setScale(exDiffAmt.subtract(exDiffAssigned), this.localCurrency.getPrecision()).toString());
        BigDecimal totalDiffUnassigned = inDiffAmt.subtract(inDiffAssigned).add(exDiffAmt).subtract(exDiffAssigned);
        this.txtTotalDiffUnassigned.setText(GlUtils.setScale(totalDiffUnassigned, this.localCurrency.getPrecision()).toString());
    }

    private void refreshAssignedLocalAmount(int rowIndex) {
        this.tblDiff.getRow(rowIndex).getCell("assignedLocalAmount").setValue((Object)this.rowDatas.get(rowIndex).getAssignedLocalAmount());
        this.refreshAssignedLocalAmount();
    }

    private void resetDiffItemEditor(RowData rowData) {
        this.tblCheck.removeRows();
        IColumn colDiffItem = this.tblCheck.getColumn("diffItem");
        if (rowData.wrapper != null) {
            colDiffItem.getStyleAttributes().setLocked(false);
            if (rowData.wrapper.isFinanceIncome()) {
                colDiffItem.setEditor((ICellEditor)this.diEditor101);
            } else if (rowData.wrapper.isBudgetExpense()) {
                colDiffItem.setEditor((ICellEditor)this.diEditor102);
            } else if (rowData.wrapper.isBudgetIncome()) {
                colDiffItem.setEditor((ICellEditor)this.diEditor103);
            } else if (rowData.wrapper.isFinanceExpense()) {
                colDiffItem.setEditor((ICellEditor)this.diEditor104);
            } else {
                colDiffItem.getStyleAttributes().setLocked(true);
            }
        } else {
            colDiffItem.getStyleAttributes().setLocked(true);
        }
    }

    private int getSelectedRowIndex(KDTable table) {
        KDTSelectManager sm = table.getSelectManager();
        if (sm != null && sm.get() != null) {
            return sm.get().getTop();
        }
        return -1;
    }

    protected void stopEditing(KDTable table) {
        KDTEditManager em = table.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
        }
    }

    @Override
    public void actionDiffAutoAssign_actionPerformed(ActionEvent e) throws Exception {
        if (this.rowDatas.size() == 0) {
            Object error;
            HashMap<String, Object> errors;
            String voucherId = this.voucher.getId() != null ? this.voucher.getId().toString() : "newvoucherid";
            DiffItemRecordCollection records = DiffItemUtils.assign(null, voucherId, this.voucher, this.analysis, this.cache, errors = new HashMap<String, Object>(), true);
            if (records != null && records.size() > 0) {
                HashMap<VoucherEntryInfo, RowData> rdMap = new HashMap<VoucherEntryInfo, RowData>();
                Iterator<RowData> it = records.iterator();
                while (it.hasNext()) {
                    DiffItemRecordInfo record = (DiffItemRecordInfo)it.next();
                    RowData rowData = (RowData)rdMap.get(record.getDiffEntry());
                    if (rowData == null) {
                        rowData = new RowData();
                        rowData.wrapper = this.wrappers.get(record.getDiffEntry());
                        this.rowDatas.add(rowData);
                        rdMap.put(record.getDiffEntry(), rowData);
                    }
                    rowData.records.add((DiffItemRecordInfo)record.clone());
                }
                for (RowData rowData : this.rowDatas) {
                    IRow row = this.tblDiff.addRow();
                    this.loadDiffData(row, rowData);
                }
            }
            this.refreshAssignedLocalAmount();
            if (this.rowDatas.size() > 0) {
                this.tblDiff.getSelectManager().select(0, 0);
            }
            if ((error = errors.get(voucherId)) != null) {
                String msg = error.toString();
                if (msg.startsWith("e")) {
                    msg = msg.substring(1);
                }
                MsgBox.showInfo((String)msg);
            }
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        RowData data = new RowData();
        this.rowDatas.add(data);
        IRow row = this.tblDiff.addRow();
        this.loadDiffData(row, data);
        this.tblDiff.getSelectManager().select(this.tblDiff.getRowCount() - 1, 0);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblDiff.getRowCount() == 0) {
            this.actionAddLine_actionPerformed(e);
            return;
        }
        int rowIndex = this.getSelectedRowIndex(this.tblDiff);
        if (rowIndex >= 0 && rowIndex < this.tblDiff.getRowCount()) {
            RowData data = new RowData();
            this.rowDatas.add(rowIndex, data);
            IRow row = this.tblDiff.addRow(rowIndex);
            this.loadDiffData(row, data);
            this.tblDiff.getSelectManager().removeAll(false);
            this.curTblDiffRowIndex = -1;
            this.tblDiff.getSelectManager().select(rowIndex, 0);
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.getSelectedRowIndex(this.tblDiff);
        if (rowIndex >= 0 && rowIndex < this.tblDiff.getRowCount()) {
            this.rowDatas.remove(rowIndex);
            this.tblDiff.removeRow(rowIndex);
            this.tblCheck.removeRows();
            this.tblDiff.getSelectManager().removeAll(false);
            this.curTblDiffRowIndex = -1;
            if (rowIndex < this.tblDiff.getRowCount()) {
                this.tblDiff.getSelectManager().select(rowIndex, 0);
            } else if (rowIndex - 1 >= 0) {
                this.tblDiff.getSelectManager().select(rowIndex - 1, 0);
            }
            this.refreshAssignedLocalAmount();
        }
    }

    private void loadDiffData(IRow row, RowData data) {
        VoucherEntryInfo entry;
        row.setUserObject((Object)data);
        VoucherEntryInfo voucherEntryInfo = entry = data.wrapper != null ? data.wrapper.entry : null;
        if (entry != null) {
            row.getCell("account").setValue((Object)this.wrappers.get(entry));
            CurrencyInfo currency = entry.getCurrency();
            if (currency == null) {
                currency = this.localCurrency;
            }
            row.getCell("currency").setValue((Object)currency);
            row.getCell("entryDC").setValue((Object)entry.getEntryDC());
            row.getCell("amount").setValue((Object)GlUtils.setScale(entry.getOriginalAmount(), currency.getPrecision()));
            row.getCell("localAmount").setValue((Object)GlUtils.setScale(entry.getLocalAmount(), this.localCurrency.getPrecision()));
        }
        row.getCell("assignedLocalAmount").setValue((Object)GlUtils.setScale(data.getAssignedLocalAmount(), this.localCurrency.getPrecision()));
    }

    public void actionCheckAutoAssign_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAddCheckLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.curTblDiffRowIndex < 0 || this.curTblDiffRowIndex >= this.tblDiff.getRowCount()) {
            return;
        }
        RowData rowData = (RowData)this.tblDiff.getRow(this.curTblDiffRowIndex).getUserObject();
        DiffItemRecordInfo record = new DiffItemRecordInfo();
        record.setAssignedLocalAmount(new BigDecimal("0.00"));
        rowData.records.add(record);
        IRow row = this.tblCheck.addRow();
        this.loadCheckData(row, record);
    }

    @Override
    public void actionInsertCheckLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.curTblDiffRowIndex < 0 || this.curTblDiffRowIndex >= this.tblDiff.getRowCount()) {
            return;
        }
        RowData rowData = (RowData)this.tblDiff.getRow(this.curTblDiffRowIndex).getUserObject();
        int rowIndex = this.getSelectedRowIndex(this.tblCheck);
        if (rowIndex >= 0 && rowIndex < this.tblCheck.getRowCount()) {
            DiffItemRecordInfo record = new DiffItemRecordInfo();
            record.setAssignedLocalAmount(new BigDecimal("0.00"));
            rowData.records.add(rowIndex, record);
            IRow row = this.tblCheck.addRow(rowIndex);
            this.loadCheckData(row, record);
        }
    }

    @Override
    public void actionRemoveCheckLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.curTblDiffRowIndex < 0 || this.curTblDiffRowIndex >= this.tblDiff.getRowCount()) {
            return;
        }
        RowData rowData = (RowData)this.tblDiff.getRow(this.curTblDiffRowIndex).getUserObject();
        int rowIndex = this.getSelectedRowIndex(this.tblCheck);
        if (rowIndex >= 0 && rowIndex < this.tblCheck.getRowCount()) {
            rowData.records.remove(rowIndex);
            this.tblCheck.removeRow(rowIndex);
            this.refreshAssignedLocalAmount(this.curTblDiffRowIndex);
        }
    }

    private boolean adjustCheckData(RowData rowData) {
        int count = 0;
        for (DiffItemRecordInfo record : rowData.records) {
            if (rowData.wrapper == null) {
                if (record.getCheckEntry() != null) {
                    record.setCheckEntry(null);
                    ++count;
                }
                if (record.getDiffItem() == null) continue;
                record.setDiffItem(null);
                ++count;
                continue;
            }
            if (record.getCheckEntry() != null) {
                if (rowData.wrapper.isFinance()) {
                    if (record.getCheckEntry().getEntryDC().equals((Object)rowData.wrapper.entry.getEntryDC())) {
                        record.setCheckEntry(null);
                        ++count;
                    }
                } else if (rowData.wrapper.isbudget() && !record.getCheckEntry().getEntryDC().equals((Object)rowData.wrapper.entry.getEntryDC())) {
                    record.setCheckEntry(null);
                    ++count;
                }
            }
            if (record.getDiffItem() == null) continue;
            if (rowData.wrapper.isFinanceIncome()) {
                if (this.num101.contains(record.getDiffItem().getNumber())) continue;
                record.setDiffItem(null);
                ++count;
                continue;
            }
            if (rowData.wrapper.isBudgetExpense()) {
                if (this.num102.contains(record.getDiffItem().getNumber())) continue;
                record.setDiffItem(null);
                ++count;
                continue;
            }
            if (rowData.wrapper.isBudgetIncome()) {
                if (this.num103.contains(record.getDiffItem().getNumber())) continue;
                record.setDiffItem(null);
                ++count;
                continue;
            }
            if (!rowData.wrapper.isFinanceExpense() || this.num104.contains(record.getDiffItem().getNumber())) continue;
            record.setDiffItem(null);
            ++count;
        }
        return count > 0;
    }

    private void loadCheckData(RowData rowData) {
        for (DiffItemRecordInfo record : rowData.records) {
            IRow row = this.tblCheck.addRow();
            this.loadCheckData(row, record);
        }
        if (this.tblCheck.getRowCount() > 0) {
            this.tblCheck.getSelectManager().select(0, 0);
        }
    }

    private void loadCheckData(IRow row, DiffItemRecordInfo record) {
        row.setUserObject((Object)record);
        VoucherEntryInfo entry = record.getCheckEntry();
        if (entry != null) {
            row.getCell("account").setValue((Object)this.wrappers.get(entry));
            CurrencyInfo currency = entry.getCurrency();
            if (currency == null) {
                currency = this.localCurrency;
            }
            row.getCell("amount").setValue((Object)GlUtils.setScale(entry.getOriginalAmount(), currency.getPrecision()));
            row.getCell("localAmount").setValue((Object)GlUtils.setScale(entry.getLocalAmount(), this.localCurrency.getPrecision()));
        }
        row.getCell("diffItem").setValue((Object)record.getDiffItem());
        DiffItemDC dc = null;
        if (record.getDiffItem() != null) {
            dc = record.getDiffItem().getDc();
        }
        row.getCell("diffItemDC").setValue((Object)dc);
        row.getCell("assignedLocalAmount").setValue((Object)record.getAssignedLocalAmount());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionDiffClear_actionPerformed(ActionEvent e) throws Exception {
        this.tblDiff.removeRows();
        this.tblCheck.removeRows();
        this.rowDatas.clear();
        this.curTblDiffRowIndex = -1;
        this.refreshAssignedLocalAmount();
    }

    @Override
    public void actionCheckClear_actionPerformed(ActionEvent e) throws Exception {
        if (this.curTblDiffRowIndex < 0 || this.curTblDiffRowIndex >= this.tblDiff.getRowCount()) {
            return;
        }
        RowData rowData = (RowData)this.tblDiff.getRow(this.curTblDiffRowIndex).getUserObject();
        rowData.records.clear();
        this.tblCheck.removeRows();
        this.refreshAssignedLocalAmount(this.curTblDiffRowIndex);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        Map ctx = this.getUIContext();
        boolean needReturn = ctx.get("needReturn") != null;
        DiffItemRecordCollection records = new DiffItemRecordCollection();
        VoucherInfo v = this.voucher;
        if (!needReturn) {
            v = new VoucherInfo();
            v.setId(this.voucher.getId());
            v.setBizStatus(this.voucher.getBizStatus());
            v.setLastUpdateTime(this.voucher.getLastUpdateTime());
        }
        BigDecimal inDiffAmt = (BigDecimal)this.analysis.get("inDiffAmt");
        BigDecimal exDiffAmt = (BigDecimal)this.analysis.get("exDiffAmt");
        BigDecimal inDiffAssigned = GlUtils.zero;
        BigDecimal exDiffAssigned = GlUtils.zero;
        int diffSeq = 1;
        for (RowData rowData : this.rowDatas) {
            if (rowData.wrapper == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"DiffAccount_Select"));
                this.tblDiff.getEditManager().editCellAt(diffSeq - 1, 0);
                return;
            }
            int checkSeq = 1;
            for (DiffItemRecordInfo record : rowData.records) {
                record.setVoucher(v);
                record.setDiffEntry(rowData.wrapper.entry);
                record.setDiffSeq(diffSeq);
                if (record.getCheckEntry() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"CheckAccount_Select"));
                    this.tblDiff.getSelectManager().select(diffSeq - 1, 0);
                    this.tblCheck.getEditManager().editCellAt(checkSeq - 1, 0);
                    return;
                }
                record.setCheckSeq(checkSeq);
                if (record.getDiffItem() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"DiffItem_Select"));
                    this.tblDiff.getSelectManager().select(diffSeq - 1, 0);
                    this.tblCheck.getEditManager().editCellAt(checkSeq - 1, 1);
                    return;
                }
                BigDecimal assigned = record.getAssignedLocalAmount();
                if (assigned == null || assigned.compareTo(GlUtils.zero) == 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"DiffAmount_Input"));
                    this.tblDiff.getSelectManager().select(diffSeq - 1, 0);
                    this.tblCheck.getEditManager().editCellAt(checkSeq - 1, 5);
                    return;
                }
                if (rowData.wrapper.isIncome()) {
                    inDiffAssigned = record.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE) ? inDiffAssigned.add(assigned) : inDiffAssigned.subtract(assigned);
                } else if (rowData.wrapper.isExpense()) {
                    exDiffAssigned = record.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE) ? exDiffAssigned.add(assigned) : exDiffAssigned.subtract(assigned);
                }
                if (rowData.wrapper.isFinanceIncome()) {
                    if (!record.getDiffItem().getNumber().equals("2") && !record.getDiffItem().getNumber().startsWith("101")) {
                        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ItemCategory_Select", (Object[])new Object[]{"101", "2"}));
                        this.tblDiff.getSelectManager().select(diffSeq - 1, 0);
                        this.tblCheck.getEditManager().editCellAt(checkSeq - 1, 1);
                        return;
                    }
                } else if (rowData.wrapper.isBudgetExpense()) {
                    if (!record.getDiffItem().getNumber().equals("2") && !record.getDiffItem().getNumber().startsWith("102")) {
                        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ItemCategory_Select", (Object[])new Object[]{"102", "2"}));
                        this.tblDiff.getSelectManager().select(diffSeq - 1, 0);
                        this.tblCheck.getEditManager().editCellAt(checkSeq - 1, 1);
                        return;
                    }
                } else if (rowData.wrapper.isBudgetIncome()) {
                    if (!record.getDiffItem().getNumber().equals("2") && !record.getDiffItem().getNumber().startsWith("103")) {
                        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ItemCategory_Select", (Object[])new Object[]{"103", "2"}));
                        this.tblDiff.getSelectManager().select(diffSeq - 1, 0);
                        this.tblCheck.getEditManager().editCellAt(checkSeq - 1, 1);
                        return;
                    }
                } else if (rowData.wrapper.isFinanceExpense() && !record.getDiffItem().getNumber().equals("2") && !record.getDiffItem().getNumber().startsWith("104")) {
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ItemCategory_Select", (Object[])new Object[]{"104", "2"}));
                    this.tblDiff.getSelectManager().select(diffSeq - 1, 0);
                    this.tblCheck.getEditManager().editCellAt(checkSeq - 1, 1);
                    return;
                }
                records.add(record);
                ++checkSeq;
            }
            ++diffSeq;
        }
        if (inDiffAssigned.compareTo(inDiffAmt) != 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"InDiffUnassigned_NotZero"));
            return;
        }
        if (exDiffAssigned.compareTo(exDiffAmt) != 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ExDiffUnassigned_NotZero"));
            return;
        }
        if (needReturn) {
            this.returnValue = records;
        } else {
            Map map = DiffItemRecordFactory.getRemoteInstance().saveRecords((IObjectCollection)records);
            if (map.containsKey(this.voucher.getId().toString())) {
                this.voucher.setLastUpdateTime((Timestamp)map.get(this.voucher.getId().toString()));
            }
        }
        this.disposeUIWindow();
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isModify()) {
            int r = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"DataChanged_Save"));
            if (r == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiffItemRecordEditUI.this.btnConfirm.doClick();
                    }
                });
                return false;
            }
            return r == 1;
        }
        return super.checkBeforeWindowClosing();
    }

    private boolean isModify() {
        int count = 0;
        ArrayList<DiffItemRecordInfo> records = new ArrayList<DiffItemRecordInfo>();
        for (RowData rowData : this.rowDatas) {
            if (rowData.wrapper == null) {
                return true;
            }
            count += rowData.records.size();
            for (DiffItemRecordInfo record : rowData.records) {
                if (record.getCheckEntry() == null || record.getDiffItem() == null || record.getAssignedLocalAmount() == null) {
                    return true;
                }
                record.setDiffEntry(rowData.wrapper.entry);
                records.add(record);
            }
        }
        if (count != this.diRecords.size()) {
            return true;
        }
        for (int i = 0; i < records.size(); ++i) {
            DiffItemRecordInfo r1 = this.diRecords.get(i);
            DiffItemRecordInfo r2 = (DiffItemRecordInfo)records.get(i);
            if (r2.getDiffEntry() == r1.getDiffEntry() && r2.getCheckEntry() == r1.getCheckEntry() && r2.getDiffItem().getId().equals((Object)r1.getDiffItem().getId()) && r2.getAssignedLocalAmount().compareTo(r1.getAssignedLocalAmount()) == 0) continue;
            return true;
        }
        return false;
    }

    public static void showMe(Object owner, String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = DiffItemUtils.getVoucherSelector();
        VoucherInfo voucher = (VoucherInfo)VoucherFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(id), sic);
        DiffItemRecordEditUI.showMe(owner, voucher);
    }

    public static void showMe(Object owner, VoucherInfo voucher) throws EASBizException, BOSException {
        boolean noNeed = SourceType.PROFIT_AND_LOSS.equals((Object)voucher.getSourceType());
        Map<String, Object> analysis = null;
        if (!noNeed) {
            analysis = DiffItemUtils.analysis(voucher);
            List diffEntries = (List)analysis.get("diffEntries");
            BigDecimal inDiffAmt = (BigDecimal)analysis.get("inDiffAmt");
            BigDecimal exDiffAmt = (BigDecimal)analysis.get("exDiffAmt");
            if (diffEntries.size() == 0 || inDiffAmt.compareTo(GlUtils.zero) == 0 && exDiffAmt.compareTo(GlUtils.zero) == 0) {
                noNeed = true;
            }
        }
        if (noNeed) {
            if (DiffItemFlag.NONEED.equals((Object)voucher.getDiffItemFlag())) {
                MsgBox.showWarning((Component)((Component)owner), (String)EASResource.getString((String)RESOURCE, (String)"DiffItem_NoNeed"));
            } else {
                ArrayList<VoucherInfo> vouchers = new ArrayList<VoucherInfo>();
                vouchers.add(voucher);
                int r = MsgBox.showConfirm2((Component)((Component)owner), (String)EASResource.getString((String)RESOURCE, (String)"DiffItem_NoNeedAndFlag"));
                if (r == 0) {
                    DiffItemRecordFactory.getRemoteInstance().updateFlag(vouchers, DiffItemFlag.NONEED);
                }
            }
            return;
        }
        DiffItemRecordCollection diRecords = DiffItemUtils.getDiffItemRecords(null, voucher.getId().toString());
        if (diRecords.size() > 0) {
            diRecords = DiffItemUtils.transfer(diRecords, analysis);
        }
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"voucher", (Object)voucher);
        uiContext.put((Object)"analysis", analysis);
        uiContext.put((Object)"diRecords", (Object)diRecords);
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.DiffItemRecordEditUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Object showMe(Object owner, VoucherInfo voucher, Map<String, Object> analysis, DiffItemRecordCollection diRecords) {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"voucher", (Object)voucher);
        uiContext.put((Object)"analysis", analysis);
        uiContext.put((Object)"diRecords", (Object)diRecords);
        uiContext.put((Object)"needReturn", (Object)"true");
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.DiffItemRecordEditUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            DiffItemRecordEditUI ui = (DiffItemRecordEditUI)uiWindow.getUIObject();
            return ui.getReturnValue();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    class TblCheckKeyListener
    extends KeyAdapter {
        TblCheckKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '=' || e.getKeyChar() == '\uff1d') {
                KDTEditManager em = DiffItemRecordEditUI.this.tblCheck.getEditManager();
                if (!em.isEditing()) {
                    return;
                }
                em.stopEditing();
                int rowIndex = DiffItemRecordEditUI.this.getSelectedRowIndex(DiffItemRecordEditUI.this.tblCheck);
                if (rowIndex < 0 || rowIndex >= DiffItemRecordEditUI.this.tblCheck.getRowCount() || DiffItemRecordEditUI.this.curTblDiffRowIndex < 0 || DiffItemRecordEditUI.this.curTblDiffRowIndex >= DiffItemRecordEditUI.this.rowDatas.size()) {
                    return;
                }
                RowData rowData = (RowData)DiffItemRecordEditUI.this.rowDatas.get(DiffItemRecordEditUI.this.curTblDiffRowIndex);
                DiffItemRecordInfo record = rowData.records.get(rowIndex);
                record.setAssignedLocalAmount(GlUtils.zero);
                BigDecimal totalAmount = GlUtils.zero;
                for (RowData rd : DiffItemRecordEditUI.this.rowDatas) {
                    if ((!rd.wrapper.isIncome() || !rowData.wrapper.isIncome()) && (!rd.wrapper.isExpense() || !rowData.wrapper.isExpense())) continue;
                    totalAmount = totalAmount.add(rd.getAssignedLocalAmount());
                }
                BigDecimal assignedLocalAmount = rowData.wrapper.isIncome() ? ((BigDecimal)DiffItemRecordEditUI.this.analysis.get("inDiffAmt")).subtract(totalAmount) : ((BigDecimal)DiffItemRecordEditUI.this.analysis.get("exDiffAmt")).subtract(totalAmount);
                DiffItemInfo diffItem = record.getDiffItem();
                if (diffItem != null && diffItem.getDc().equals((Object)DiffItemDC.NEGATIVE)) {
                    assignedLocalAmount = GlUtils.zero.subtract(assignedLocalAmount);
                }
                DiffItemRecordEditUI.this.tblCheck.getRow(rowIndex).getCell("assignedLocalAmount").setValue((Object)assignedLocalAmount);
                record.setAssignedLocalAmount(assignedLocalAmount);
                DiffItemRecordEditUI.this.refreshAssignedLocalAmount(DiffItemRecordEditUI.this.curTblDiffRowIndex);
            }
        }
    }

    class TblCheckEditAdapter
    extends KDTEditAdapter {
        TblCheckEditAdapter() {
        }

        public void editStopped(KDTEditEvent evt) {
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            if (rowIndex < 0 || rowIndex >= DiffItemRecordEditUI.this.tblCheck.getRowCount()) {
                return;
            }
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getValue();
            if (newValue == oldValue) {
                return;
            }
            IRow row = DiffItemRecordEditUI.this.tblCheck.getRow(rowIndex);
            DiffItemRecordInfo record = (DiffItemRecordInfo)row.getUserObject();
            String colKey = DiffItemRecordEditUI.this.tblCheck.getColumnKey(colIndex);
            if ("account".equals(colKey)) {
                if (newValue != null) {
                    VoucherEntryInfo entry = ((DiffEntryWrapper)newValue).entry;
                    CurrencyInfo currency = entry.getCurrency();
                    if (currency == null) {
                        currency = DiffItemRecordEditUI.this.localCurrency;
                    }
                    row.getCell("amount").setValue((Object)GlUtils.setScale(entry.getOriginalAmount(), currency.getPrecision()));
                    row.getCell("localAmount").setValue((Object)GlUtils.setScale(entry.getLocalAmount(), DiffItemRecordEditUI.this.localCurrency.getPrecision()));
                    record.setCheckEntry(entry);
                } else {
                    row.getCell("amount").setValue((Object)"");
                    row.getCell("localAmount").setValue((Object)"");
                    record.setCheckEntry(null);
                }
            } else if ("diffItem".equals(colKey)) {
                if (newValue != null) {
                    DiffItemInfo item = (DiffItemInfo)newValue;
                    record.setDiffItem(item);
                    row.getCell("diffItemDC").setValue((Object)item.getDc());
                    BigDecimal assignedLocalAmount = (BigDecimal)row.getCell("assignedLocalAmount").getValue();
                    if (assignedLocalAmount != null) {
                        if (oldValue != null) {
                            DiffItemInfo oldItem = (DiffItemInfo)oldValue;
                            if (oldItem.getDc().equals((Object)DiffItemDC.NEGATIVE)) {
                                assignedLocalAmount = GlUtils.zero.subtract(assignedLocalAmount);
                            }
                            if (item.getDc().equals((Object)DiffItemDC.NEGATIVE)) {
                                assignedLocalAmount = GlUtils.zero.subtract(assignedLocalAmount);
                            }
                            row.getCell("assignedLocalAmount").setValue((Object)assignedLocalAmount);
                            record.setAssignedLocalAmount(assignedLocalAmount);
                        } else if (item.getDc().equals((Object)DiffItemDC.NEGATIVE)) {
                            assignedLocalAmount = GlUtils.zero.subtract(assignedLocalAmount);
                            row.getCell("assignedLocalAmount").setValue((Object)assignedLocalAmount);
                            record.setAssignedLocalAmount(assignedLocalAmount);
                        }
                    }
                } else {
                    record.setDiffItem(null);
                    row.getCell("diffItemDC").setValue(null);
                    BigDecimal assignedLocalAmount = (BigDecimal)row.getCell("assignedLocalAmount").getValue();
                    if (assignedLocalAmount != null && oldValue != null) {
                        DiffItemInfo oldItem = (DiffItemInfo)oldValue;
                        if (oldItem.getDc().equals((Object)DiffItemDC.NEGATIVE)) {
                            assignedLocalAmount = GlUtils.zero.subtract(assignedLocalAmount);
                        }
                        row.getCell("assignedLocalAmount").setValue((Object)assignedLocalAmount);
                        record.setAssignedLocalAmount(assignedLocalAmount);
                    }
                }
                DiffItemRecordEditUI.this.refreshAssignedLocalAmount(DiffItemRecordEditUI.this.curTblDiffRowIndex);
            } else if ("assignedLocalAmount".equals(colKey)) {
                BigDecimal assignedLocalAmount = (BigDecimal)newValue;
                if (assignedLocalAmount == null) {
                    assignedLocalAmount = new BigDecimal("0.00");
                }
                record.setAssignedLocalAmount(assignedLocalAmount);
                DiffItemRecordEditUI.this.refreshAssignedLocalAmount(DiffItemRecordEditUI.this.curTblDiffRowIndex);
            }
        }
    }

    class TblDiffEditAdapter
    extends KDTEditAdapter {
        TblDiffEditAdapter() {
        }

        public void editStopped(KDTEditEvent evt) {
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            if (rowIndex < 0 || rowIndex >= DiffItemRecordEditUI.this.tblDiff.getRowCount()) {
                return;
            }
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getValue();
            if (newValue == oldValue) {
                return;
            }
            IRow row = DiffItemRecordEditUI.this.tblDiff.getRow(rowIndex);
            RowData rowData = (RowData)row.getUserObject();
            String colKey = DiffItemRecordEditUI.this.tblDiff.getColumnKey(colIndex);
            if ("account".equals(colKey)) {
                DiffEntryWrapper wrapper = null;
                if (newValue != null) {
                    wrapper = (DiffEntryWrapper)newValue;
                    VoucherEntryInfo entry = wrapper.entry;
                    CurrencyInfo currency = entry.getCurrency();
                    if (currency == null) {
                        currency = DiffItemRecordEditUI.this.localCurrency;
                    }
                    row.getCell("currency").setValue((Object)currency);
                    row.getCell("entryDC").setValue((Object)entry.getEntryDC());
                    row.getCell("amount").setValue((Object)GlUtils.setScale(entry.getOriginalAmount(), currency.getPrecision()));
                    row.getCell("localAmount").setValue((Object)GlUtils.setScale(entry.getLocalAmount(), DiffItemRecordEditUI.this.localCurrency.getPrecision()));
                    rowData.wrapper = wrapper;
                } else {
                    row.getCell("currency").setValue((Object)"");
                    row.getCell("entryDC").setValue((Object)"");
                    row.getCell("amount").setValue((Object)"");
                    row.getCell("localAmount").setValue((Object)"");
                    rowData.wrapper = null;
                }
                DiffItemRecordEditUI.this.resetDiffItemEditor(rowData);
                if (DiffItemRecordEditUI.this.adjustCheckData(rowData)) {
                    DiffItemRecordEditUI.this.tblCheck.removeRows();
                    DiffItemRecordEditUI.this.loadCheckData(rowData);
                }
                DiffItemRecordEditUI.this.refreshAssignedLocalAmount();
            }
        }
    }

    class TblDiffRowSwitchListener
    implements KDTActiveCellListener {
        TblDiffRowSwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            int rowIndex = e.getRowIndex();
            if (rowIndex == DiffItemRecordEditUI.this.curTblDiffRowIndex) {
                return;
            }
            DiffItemRecordEditUI.this.curTblDiffRowIndex = rowIndex;
            if (DiffItemRecordEditUI.this.curTblDiffRowIndex < 0 || DiffItemRecordEditUI.this.curTblDiffRowIndex >= DiffItemRecordEditUI.this.tblDiff.getRowCount()) {
                return;
            }
            DiffItemRecordEditUI.this.tblCheck.removeRows();
            RowData rowData = (RowData)DiffItemRecordEditUI.this.rowDatas.get(DiffItemRecordEditUI.this.curTblDiffRowIndex);
            DiffItemRecordEditUI.this.resetDiffItemEditor(rowData);
            DiffItemRecordEditUI.this.loadCheckData(rowData);
        }
    }

    class RowData {
        DiffEntryWrapper wrapper;
        List<DiffItemRecordInfo> records = new ArrayList<DiffItemRecordInfo>();

        RowData() {
        }

        public BigDecimal getAssignedLocalAmount() {
            BigDecimal assignedLocalAmount = new BigDecimal("0.00");
            for (DiffItemRecordInfo record : this.records) {
                if (record.getDiffItem() == null) continue;
                if (record.getDiffItem().getDc().equals((Object)DiffItemDC.POSITIVE)) {
                    assignedLocalAmount = assignedLocalAmount.add(record.getAssignedLocalAmount());
                    continue;
                }
                if (!record.getDiffItem().getDc().equals((Object)DiffItemDC.NEGATIVE)) continue;
                assignedLocalAmount = assignedLocalAmount.subtract(record.getAssignedLocalAmount());
            }
            return assignedLocalAmount;
        }
    }
}

