/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.DiffItemFactory;
import com.kingdee.eas.fi.gl.DiffItemInfo;
import com.kingdee.eas.fi.gl.DiffItemMappingFactory;
import com.kingdee.eas.fi.gl.client.AbstractDiffItemTreeListUI;
import com.kingdee.eas.fi.gl.client.DiffItemMappingEditUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class DiffItemTreeListUI
extends AbstractDiffItemTreeListUI {
    private static final Logger logger = CoreUIObject.getLogger(DiffItemTreeListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fi.gl.DiffItemResource";

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public DiffItemTreeListUI() throws Exception {
        RptClientUtil.checkFIUnit(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeMain.expandOnLevel(4);
        this.actionView.setVisible(false);
        this.actionView.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionImportData.setVisible(true);
        this.actionExportData.setVisible(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getSelectedTreeNode().isLeaf()) {
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        Object o = this.getSelectedTreeNode().getUserObject();
        if (o instanceof DiffItemInfo) {
            DiffItemInfo diffItem = (DiffItemInfo)o;
            uiContext.put((Object)"diffItem", (Object)diffItem);
        } else {
            SysUtil.abort();
        }
    }

    protected String getEditUIName() {
        return DiffItemMappingEditUI.class.getName();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            HashSet<String> ids = new HashSet<String>();
            for (int rowIndex : selectRows) {
                Object id;
                IRow row = this.tblMain.getRow2(rowIndex);
                if (row == null || (id = row.getCell("id").getValue()) == null) continue;
                ids.add(id.toString());
            }
            if (ids.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                DiffItemMappingFactory.getRemoteInstance().delete(filter);
                this.tblMain.removeRows();
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected String getRootName() {
        return EASResource.getString((String)RESOURCE, (String)"DiffItem");
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return DiffItemFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected void buildTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null || this.mainQuery == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        filterInfo.getFilterItems().add(new FilterItemInfo("checkAccount.companyID.id", (Object)company.getId().toString()));
        if (company.getAccountTable() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("checkAccount.accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        }
        if (treeNode.getUserObject() instanceof DiffItemInfo) {
            DiffItemInfo diffItemInfo = (DiffItemInfo)treeNode.getUserObject();
            try {
                diffItemInfo = DiffItemFactory.getRemoteInstance().getDiffItemInfo((IObjectPK)new ObjectUuidPK(diffItemInfo.getId()));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            if (diffItemInfo.isIsLeaf()) {
                FilterItemInfo filterItemInfo = new FilterItemInfo(this.getQueryFieldName(), (Object)diffItemInfo.getId().toString(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else {
                HashSet<String> numbers = new HashSet<String>();
                if ("101".equals(diffItemInfo.getNumber())) {
                    numbers.add("10101");
                    numbers.add("10102");
                } else if ("102".equals(diffItemInfo.getNumber())) {
                    numbers.add("10201");
                    numbers.add("10202");
                    numbers.add("10203");
                    numbers.add("10204");
                } else if ("103".equals(diffItemInfo.getNumber())) {
                    numbers.add("10301");
                    numbers.add("10302");
                } else if ("104".equals(diffItemInfo.getNumber())) {
                    numbers.add("10401");
                    numbers.add("10402");
                    numbers.add("10403");
                    numbers.add("10404");
                } else {
                    numbers.add("10101");
                    numbers.add("10102");
                    numbers.add("10201");
                    numbers.add("10202");
                    numbers.add("10203");
                    numbers.add("10204");
                    numbers.add("10301");
                    numbers.add("10302");
                    numbers.add("10401");
                    numbers.add("10402");
                    numbers.add("10403");
                    numbers.add("10404");
                }
                FilterItemInfo filterItemInfo = new FilterItemInfo("diffItem.number", numbers, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        }
        this.mainQuery.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("diffType"));
        sorter.add(new SorterItemInfo("diffAccount.number"));
        sorter.add(new SorterItemInfo("checkAccount.number"));
        this.mainQuery.setSorter(sorter);
    }

    protected String getQueryFieldName() {
        return "diffItem.id";
    }

    protected String getAccountQueryFieldName() {
        return "accountTypeID.property";
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (!this.getSelectedTreeNode().isLeaf()) {
            return;
        }
        this.tblMain.removeRows();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "diffItemMapping";
        param.alias = EASResource.getString((String)RESOURCE, (String)"DiffItemMapping");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "diffItemMapping";
        param.alias = EASResource.getString((String)RESOURCE, (String)"DiffItemMapping");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected String[] getLocateNames() {
        ArrayList<String> locateNames = new ArrayList<String>();
        locateNames.add("diffAccount.number");
        locateNames.add("diffAccount.longName");
        locateNames.add("checkAccount.number");
        locateNames.add("checkAccount.longName");
        locateNames.add("diffItem.number");
        return locateNames.toArray(new String[0]);
    }
}

