/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemViewFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.util.CashflowF7Util;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashflowRecord;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.TemplateVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractFullInfoEditUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FullInfoEditUI
extends AbstractFullInfoEditUI {
    private static final long serialVersionUID = -366862077131318532L;
    private static final Logger logger = CoreUIObject.getLogger(FullInfoEditUI.class);
    protected VoucherEditUI parentUI;
    protected CashflowFlag cfFlag;
    protected int returnValue = 1;
    protected CashflowRecordCollection cfCol;
    protected boolean mustInputBothItem;
    protected VoucherInfo vch;
    protected boolean foreignCurrencySU;
    protected boolean useReportingCurrency;
    protected CurrencyInfo localCurrency;
    protected CurrencyInfo reportingCurrency;
    protected boolean isSettleByLocal = true;
    protected VoucherInfo.ExchangeRateWithValue localToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
    protected int amountRoundMode;
    protected int illegalCfEntryIndex = -1;
    protected int illegalCfOppEntryIndex = -1;
    protected int curCfEntryIndex = -1;
    protected int curCfOppEntryIndex = -1;
    protected KDTDefaultCellEditor numberEditor;
    protected VoucherEntryInfo oppEntry;
    protected boolean isFullInfoEdited = false;
    protected Map fullInfoEditedMap = new HashMap();
    protected CashFlowItemInfo fullInfoItem = null;
    protected boolean isInList = false;
    protected PeriodInfo curPeriod = null;
    private boolean isModifyCashFlow = false;
    private boolean isClear = false;
    protected String lexTableId;
    protected String rexTableId;
    protected HashMap exchangeRate = new HashMap();
    CfOppEntryEditAdapter cfOppEntryEditLs = new CfOppEntryEditAdapter();
    CfEntrySwitchListener cfEntrySwitchLs = new CfEntrySwitchListener();
    CfOppEntrySwitchListener cfOppEntrySwitchLs = new CfOppEntrySwitchListener();
    CfExitListener cfExitLs = new CfExitListener(this.tblOppEntries, 0, false);
    CfFocusListener cfFocusForwardLs = new CfFocusListener(this.tblOppEntries, 0, false);
    CfFocusListener cfFocusBackwardLs = new CfFocusListener(this.tblOppEntries, 0, true);
    protected CashFlowShortcutListener tabTableEntryOppLsUP = new CashFlowShortcutListener(this.tblOppEntries, "TABTABLEUP");
    protected CashFlowShortcutListener tabTableEntryLsDOWN = new CashFlowShortcutListener(this.tblEntries, "TABTABLEDOWN");
    protected CashFlowShortcutListener tabTableEntryLsUP = new CashFlowShortcutListener(this.tblEntries, "TABTABLEUP");
    protected CashFlowShortcutListener tabTableEntryOppLsDOWN = new CashFlowShortcutListener(this.tblOppEntries, "TABTABLEDOWN");
    protected CashFlowShortcutListener tableEntryOppLsUP = new CashFlowShortcutListener(this.tblOppEntries, "TABLEUP");
    protected CashFlowShortcutListener tableEntryLsDOWN = new CashFlowShortcutListener(this.tblEntries, "TABLEDOWN");
    protected CashFlowShortcutListener tableEntryLsUP = new CashFlowShortcutListener(this.tblEntries, "TABLEUP");
    protected CashFlowShortcutListener tableEntryOppLsDOWN = new CashFlowShortcutListener(this.tblOppEntries, "TABLEDOWN");
    protected CashFlowShortcutListener tableOPPEntryAutoBalance = new CashFlowShortcutListener(this.tblOppEntries, "ACTIONKEY_AUTOBALANCE");
    KDFormattedTextField amountFormattedTextField;
    ICellEditor laAmountEditor;
    ICellEditor raAmountEditor;
    protected KeyListener laSpaceKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '=' || e.getKeyChar() == '\uff1d') {
                FullInfoEditUI.this.autoBalance(FullInfoEditUI.this.tblOppEntries);
                KDTEditManager em = FullInfoEditUI.this.tblOppEntries.getEditManager();
                if (em.isEditing()) {
                    em.stopEditing();
                }
            }
        }
    };

    protected void autoBalance(KDTable table) {
        IRow row = table.getRow(this.curCfOppEntryIndex);
        if (row == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"9_FullInfoEditUI"));
            return;
        }
        IRow cfEntryRow = this.tblEntries.getRow(this.curCfEntryIndex);
        CfOppEntryData oe = new CfOppEntryData((VoucherEntryInfo)cfEntryRow.getCell("entry").getUserObject());
        BigDecimal[] amnt = this.computeAmnt(cfEntryRow, oe, this.curCfOppEntryIndex);
        Object value = row.getCell("o.supplementaryItem").getValue();
        if (value instanceof Object[]) {
            value = ((Object[])value)[0];
        }
        oe.setFullInfoItem((CashFlowItemInfo)value);
        oe.setAmount(amnt[0]);
        oe.setLocalAmount(amnt[1]);
        oe.setReportingAmount(amnt[2]);
        this.loadCfOppEntry(oe, row);
    }

    public FullInfoEditUI() throws Exception {
        this.btnRecalc.setText(null);
        this.btnRecalc.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnAddLine.setText(null);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        Dimension size = new Dimension(650, 460);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.amountFormattedTextField = InitClientHelp.enhanceScaleFormattedTextField(new KDFormattedTextField(1), 0);
        this.amountFormattedTextField.setSupportedEmpty(false);
        this.amountFormattedTextField.setHorizontalAlignment(4);
        this.laAmountEditor = new KDTDefaultCellEditor((JTextField)this.amountFormattedTextField);
        this.raAmountEditor = new KDTDefaultCellEditor((JTextField)this.amountFormattedTextField);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnRecalc);
        this.remove((Component)this.btnAddLine);
        this.remove((Component)this.btnInsertLine);
        this.remove((Component)this.btnRemoveLine);
        this.kDContainer1.addButton((JButton)this.btnRecalc);
        this.kDContainer1.addButton((JButton)this.btnAddLine);
        this.kDContainer1.addButton((JButton)this.btnInsertLine);
        this.kDContainer1.addButton((JButton)this.btnRemoveLine);
        this.actionRemoveLine.setEnabled(true);
        this.actionInsertLine.setEnabled(true);
        this.actionRecalc.setEnabled(true);
        this.actionClear.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        IRow cfEntryRow = this.tblEntries.getRow(this.curCfEntryIndex);
        CfEntryData ed = (CfEntryData)cfEntryRow.getUserObject();
        this.storeCfEntry(ed, cfEntryRow);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.beforeStoreFields(e);
        CfOppEntryData oe = this.createNewOppEntry(this.tblEntries.getRow(this.curCfEntryIndex));
        IRow row = this.tblOppEntries.addRow();
        this.loadCfOppEntry(oe, row);
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(this.tblOppEntries.getRowCount() - 1, -1);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        CfOppEntryData oe = this.createNewOppEntry(this.tblEntries.getRow(this.curCfEntryIndex));
        IRow row = null;
        int top = this.curCfOppEntryIndex;
        if (top >= 0) {
            row = this.tblOppEntries.addRow(top);
        } else {
            top = this.tblOppEntries.getRowCount();
            row = this.tblOppEntries.addRow();
        }
        this.loadCfOppEntry(oe, row);
        if (this.curCfOppEntryIndex >= 0) {
            ++this.curCfOppEntryIndex;
        }
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(top, -1);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        int top = this.curCfOppEntryIndex;
        IRow curRow = this.tblOppEntries.getRow(top);
        if (curRow == null) {
            return;
        }
        CfOppEntryData oe = (CfOppEntryData)curRow.getUserObject();
        this.storeCfOppEntry(oe, curRow);
        this.tblOppEntries.removeRow(top);
        if (this.curCfOppEntryIndex >= 0) {
            this.curCfOppEntryIndex = -1;
        }
        KDTSelectManager sm = this.tblOppEntries.getSelectManager();
        int rowCount = this.tblOppEntries.getRowCount();
        if (rowCount == 0) {
            sm.removeAll(false);
            this.actionAddLine_actionPerformed(null);
        } else if (top < rowCount) {
            sm.removeAll(false);
            sm.select(top, -1);
        } else {
            sm.removeAll();
            this.afterSelectCfOppEntry(null);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.beforeStoreFields(e);
        this.storeFields();
        if (this.checkDataObject()) {
            this.setResult(this.buildResult());
            this.setReturnValue(0);
            if (this.isInList) {
                this.vch.setCashflowRecords((AbstractObjectCollection)this.getResult());
                this.vch.setCashflowFlag(CashflowFlag.FINISHED);
                this.saveCashflow();
            }
            this.destroyWindow();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setResult(null);
        this.setReturnValue(1);
        this.destroyWindow();
    }

    @Override
    public void actionRecalc_actionPerformed(ActionEvent e) throws Exception {
        this.autoBalance(this.tblOppEntries);
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        int confirm = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"clearCashflow"));
        if (confirm != 0) {
            return;
        }
        this.cfCol = null;
        this.setReturnValue(0);
        if (this.isInList) {
            ICashflowRecord item = CashflowRecordFactory.getRemoteInstance();
            item.clear(this.vch.getId().toString());
        }
        if (this.cfCol != null) {
            this.cfCol.clear();
        }
        this.vch.setCashflowRecords(null);
        this.tblEntries.removeRows();
        this.tblOppEntries.removeRows();
        this.loadFields();
        this.setClear(true);
        confirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"clearSuc"));
        if (confirm == 0) {
            this.destroyWindow();
        }
    }

    public void onLoad() throws Exception {
        this.fetchInitData();
        this.checkVoucher();
        this.initTableStyle();
        super.onLoad();
        this.loadFields();
        int size = this.tblEntries.getRowCount();
        IRow row = null;
        boolean isAllHidden = true;
        for (int i = 0; i < size; ++i) {
            row = this.tblEntries.getRow(i);
            if (row == null || row.getStyleAttributes().isHided()) continue;
            isAllHidden = false;
            break;
        }
        if (isAllHidden) {
            this.btnAddLine.setEnabled(false);
            this.btnRecalc.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnClear.setEnabled(false);
            this.btnConfirm.setEnabled(false);
            this.tblOppEntries.setEnabled(false);
        }
        if (this.isModifyCashFlow && !PeriodUtils.PeriodCompare((PeriodInfo)this.vch.getPeriod(), (PeriodInfo)this.curPeriod)) {
            this.btnClear.setEnabled(false);
            this.actionConfirm.setEnabled(false);
            this.btnConfirm.setEnabled(false);
            this.actionClear.setEnabled(false);
        }
        this.tHelper.init();
    }

    protected void fetchInitData() throws Exception {
        Map ctx = this.getUIContext();
        Object obj = ctx.get("VOUCHER");
        if (obj instanceof VoucherInfo) {
            this.vch = (VoucherInfo)ctx.get("VOUCHER");
        } else if (obj instanceof TemplateVoucherInfo) {
            this.vch = ((TemplateVoucherInfo)obj).transfer();
        }
        CompanyOrgUnitInfo company = this.getVchCompany();
        this.cfFlag = (CashflowFlag)ctx.get("CASHFLOWFLAG");
        String[] paramNumbers = new String[]{"GL_008", "G001"};
        GlParam glParam = GlParam.getGlParams(null, (String[])paramNumbers, (String)company.getId().toString());
        this.foreignCurrencySU = glParam.getBoolean("GL_008");
        this.useReportingCurrency = glParam.getBoolean("G001");
        this.curPeriod = GlUtils.getCurrentPeriod(null, company.getId().toString());
        Object object = GlUtils.getParamByKey(null, company.getId().toString(), "GL_014_1");
        this.isModifyCashFlow = Boolean.valueOf(object.toString());
        this.localCurrency = company.getBaseCurrency();
        this.reportingCurrency = company.getReportCurrency();
        if (this.reportingCurrency == null) {
            this.reportingCurrency = this.localCurrency;
        }
        this.amountRoundMode = (Integer)ctx.get("AMOUNT_ROUND_MODE");
        this.vch.setCashflowFlag(this.cfFlag);
        Boolean repeatCashflow = (Boolean)ctx.get("REPEATE_CASHFLOW");
        if (repeatCashflow != null) {
            this.isInList = repeatCashflow;
        } else {
            this.parentUI = (VoucherEditUI)((Object)ctx.get("PARENTUI"));
        }
        if (company.getBaseExchangeTable() != null) {
            this.lexTableId = company.getBaseExchangeTable().getId().toString();
        }
        this.rexTableId = this.useReportingCurrency && company.getReportExchangeTable() != null ? company.getReportExchangeTable().getId().toString() : this.lexTableId;
        if (this.useReportingCurrency) {
            if (company.getReportConvertMode() != null) {
                boolean bl = this.isSettleByLocal = 3 == company.getReportConvertMode().getValue();
            }
            if (this.isSettleByLocal) {
                if (this.rexTableId == null) {
                    throw new GLException(GLException.NOREPORTINGEXTABLE);
                }
                if (this.reportingCurrency == null) {
                    throw new GLException(GLException.NOREPORTINGCUR);
                }
                this.localToRpt = (VoucherInfo.ExchangeRateWithValue)ctx.get("LOCALTORPT");
                if (this.localToRpt == null) {
                    PeriodInfo period = (PeriodInfo)ctx.get("CURPERIOD");
                    Date bookdate = (Date)ctx.get("BOOKDATA");
                    this.localToRpt = GlUtils.getLocalToReportingExchangeRate(this.reportingCurrency, this.rexTableId, this.localCurrency, this.lexTableId, bookdate, period, this.foreignCurrencySU, null);
                    if (this.localToRpt == null) {
                        throw new GLException(GLException.NOLOCALTORPT);
                    }
                }
            }
        } else {
            this.reportingCurrency = this.localCurrency;
        }
    }

    protected void initTableStyle() {
        this.tblEntries.checkParsed();
        this.tblOppEntries.checkParsed();
        this.tblEntries.getStyleAttributes().setLocked(true);
        this.tblEntries.getSelectManager().setSelectMode(2);
        this.tblOppEntries.getSelectManager().setSelectMode(1);
        this.tblOppEntries.getStyleAttributes().setWrapText(true);
        this.tblOppEntries.setRowsAutoResizeMode(5);
        IColumn curCol = this.tblEntries.getColumn("currency");
        IColumn amntCol = this.tblEntries.getColumn("amount");
        IColumn laCol = this.tblEntries.getColumn("localAmount");
        IColumn raCol = this.tblEntries.getColumn("reportingAmount");
        IColumn oppPiCol = this.tblOppEntries.getColumn("o.supplementaryItem");
        IColumn oppAmntCol = this.tblOppEntries.getColumn("o.amount");
        IColumn oppLaCol = this.tblOppEntries.getColumn("o.localAmount");
        IColumn oppRaCol = this.tblOppEntries.getColumn("o.reportingAmount");
        amntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        laCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        raCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        laCol.setEditor(this.laAmountEditor);
        raCol.setEditor(this.raAmountEditor);
        oppAmntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppLaCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppRaCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        oppLaCol.setEditor(this.laAmountEditor);
        oppRaCol.setEditor(this.raAmountEditor);
        InitClientHelp.setAmountGroupUse(this.tblEntries, this.laAmountEditor, this.localCurrency.getPrecision());
        InitClientHelp.setAmountGroupUse(this.tblEntries, this.raAmountEditor, this.reportingCurrency.getPrecision());
        InitClientHelp.setAmountGroupUse(this.tblOppEntries, this.laAmountEditor, this.localCurrency.getPrecision());
        InitClientHelp.setAmountGroupUse(this.tblOppEntries, this.raAmountEditor, this.reportingCurrency.getPrecision());
        if (this.foreignCurrencySU) {
            String amount = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"amount");
            amntCol.getStyleAttributes().setHided(true);
            raCol.setWidth(-1);
            raCol.getStyleAttributes().setHided(true);
            IRow header = this.tblEntries.getHeadRow(0);
            header.getCell("localAmount").setValue((Object)amount);
            oppAmntCol.getStyleAttributes().setHided(true);
            oppRaCol.setWidth(-1);
            oppRaCol.getStyleAttributes().setHided(true);
            IRow oppHeader = this.tblOppEntries.getHeadRow(0);
            oppHeader.getCell("o.localAmount").setValue((Object)amount);
        } else if (!this.useReportingCurrency) {
            raCol.setWidth(-1);
            raCol.getStyleAttributes().setHided(true);
            oppRaCol.setWidth(-1);
            oppRaCol.getStyleAttributes().setHided(true);
        }
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setDataVerifierType(-1);
        formattedTextField.setSupportedEmpty(true);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.numberEditor.setClickCountToStart(1);
        oppAmntCol.setEditor((ICellEditor)this.numberEditor);
        oppLaCol.setEditor((ICellEditor)this.numberEditor);
        oppRaCol.setEditor((ICellEditor)this.numberEditor);
        KDBizPromptBox bizPiPromptBox = new KDBizPromptBox();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("type", (Object)new Integer(2)));
        String cuid = this.getVchCompany().getCU().getId().toString();
        CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizPiPromptBox, (FilterInfo)filter, (CoreUIObject)this, (String)cuid);
        oppPiCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPiPromptBox));
        ObjectValueRender normalObjectRender = new ObjectValueRender();
        normalObjectRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        curCol.setRenderer((IBasicRender)normalObjectRender);
        oppPiCol.setRenderer((IBasicRender)normalObjectRender);
        KeyStroke ctrl_f7 = KeyStroke.getKeyStroke(118, 2);
        KeyStroke ctrl_down = KeyStroke.getKeyStroke(40, 2);
        KeyStroke ctrl_up = KeyStroke.getKeyStroke(38, 2);
        KeyStroke shift_down = KeyStroke.getKeyStroke(40, 1);
        KeyStroke shift_up = KeyStroke.getKeyStroke(38, 1);
        Component comp = this.tblOppEntries.getColumn("o.localAmount").getEditor().getComponent();
        comp.addKeyListener(this.laSpaceKey);
    }

    public void onShow() throws Exception {
        this.tblOppEntries.getEditManager().editCellAt(0, 0);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        KDTEditManager em = this.tblOppEntries.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
            if (em.isEditing()) {
                SysUtil.abort();
            }
        }
    }

    protected CfOppEntryData createNewOppEntry(IRow cfEntryRow) {
        CfOppEntryData oe = new CfOppEntryData(((CfEntryData)cfEntryRow.getUserObject()).getEntry());
        BigDecimal[] amnt = this.computeAmnt(cfEntryRow, oe, -1);
        oe.setAmount(amnt[0]);
        oe.setLocalAmount(amnt[1]);
        oe.setReportingAmount(amnt[2]);
        return oe;
    }

    private BigDecimal[] computeAmnt(IRow cfEntryRow, CfOppEntryData oe, int curCfOppEntryIndex) {
        BigDecimal newLa;
        BigDecimal zero;
        int rowCount = this.tblOppEntries.getRowCount();
        BigDecimal amntTotal = zero = new BigDecimal("0");
        BigDecimal laTotal = zero;
        BigDecimal raTotal = zero;
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal la;
            if (curCfOppEntryIndex == i) continue;
            IRow row = this.tblOppEntries.getRow(i);
            BigDecimal amnt = (BigDecimal)row.getCell("o.amount").getValue();
            if (amnt == null) {
                amnt = zero;
            }
            if ((la = (BigDecimal)row.getCell("o.localAmount").getValue()) == null) {
                la = zero;
            }
            amntTotal = amntTotal.add(amnt);
            laTotal = laTotal.add(la);
            if (!this.useReportingCurrency) continue;
            BigDecimal ra = (BigDecimal)row.getCell("o.reportingAmount").getValue();
            if (ra == null) {
                ra = zero;
            }
            raTotal = raTotal.add(ra);
        }
        BigDecimal newAmnt = ((BigDecimal)cfEntryRow.getCell("amount").getValue()).subtract(amntTotal);
        BigDecimal newRa = newLa = ((BigDecimal)cfEntryRow.getCell("localAmount").getValue()).subtract(laTotal);
        if (this.useReportingCurrency) {
            newRa = ((BigDecimal)cfEntryRow.getCell("reportingAmount").getValue()).subtract(raTotal);
        }
        return new BigDecimal[]{newAmnt, newLa, newRa};
    }

    protected void loadCfOppEntry(CfOppEntryData oe, IRow row) {
        row.getCell("o.supplementaryItem").setValue((Object)oe.getFullInfoItem());
        CurrencyInfo cur = this.getOriginalCurrency(this.curCfEntryIndex);
        BigDecimal coefficient = GlUtils.one;
        StringBuffer prec = new StringBuffer();
        for (int i = 0; i < cur.getPrecision(); ++i) {
            prec.append("0");
        }
        row.getCell("o.amount").getStyleAttributes().setNumberFormat("%r{#,##0." + prec.toString() + "}f");
        row.getCell("o.amount").setValue((Object)GlUtils.setScale(oe.getAmount().multiply(coefficient), cur.getPrecision()));
        row.getCell("o.localAmount").setValue((Object)GlUtils.setScale(oe.getLocalAmount().multiply(coefficient), this.localCurrency.getPrecision()));
        if (this.useReportingCurrency) {
            row.getCell("o.reportingAmount").setValue((Object)GlUtils.setScale(oe.getReportingAmount().multiply(coefficient), this.reportingCurrency.getPrecision()));
        } else if (row.getCell("o.reportingAmount") != null) {
            row.getCell("o.reportingAmount").getStyleAttributes().setHided(true);
        }
        row.setUserObject((Object)oe);
    }

    protected CurrencyInfo getOriginalCurrency(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.tblEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getCurrency();
    }

    protected void attachListeners() {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.tblOppEntries.addKDTEditListener((KDTEditListener)this.cfOppEntryEditLs);
            ActionMap oppEntryActionMap = this.tblOppEntries.getActionMap();
            oppEntryActionMap.put("FocusChangeCol", (Action)((Object)this.cfFocusForwardLs));
            oppEntryActionMap.put("FocusChangeRow", (Action)((Object)this.cfFocusForwardLs));
            oppEntryActionMap.put("FocusChangeColReverse", (Action)((Object)this.cfFocusBackwardLs));
            oppEntryActionMap.put("FocusChangeRowReverse", (Action)((Object)this.cfFocusBackwardLs));
            oppEntryActionMap.put("SWITCHTABLE", (Action)((Object)this.cfExitLs));
            oppEntryActionMap.put("ACTIONKEY_AUTOBALANCE", this.tableOPPEntryAutoBalance);
            oppEntryActionMap.put("TABTABLEUP", this.tabTableEntryOppLsUP);
            oppEntryActionMap.put("TABTABLEDOWN", this.tabTableEntryOppLsDOWN);
            oppEntryActionMap.put("TABLEUP", this.tableEntryOppLsUP);
            oppEntryActionMap.put("TABLEDOWN", this.tableEntryOppLsDOWN);
            ActionMap entryActionMap = this.tblEntries.getActionMap();
            entryActionMap.put("TABTABLEUP", this.tabTableEntryLsUP);
            entryActionMap.put("TABTABLEDOWN", this.tabTableEntryLsDOWN);
            entryActionMap.put("TABLEUP", this.tableEntryLsUP);
            entryActionMap.put("TABLEDOWN", this.tableEntryLsDOWN);
        }
        this.tblOppEntries.addKDTActiveCellListener((KDTActiveCellListener)this.cfOppEntrySwitchLs);
        this.tblEntries.addKDTActiveCellListener((KDTActiveCellListener)this.cfEntrySwitchLs);
    }

    protected void detachListeners() {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.tblOppEntries.removeKDTEditListener((KDTEditListener)this.cfOppEntryEditLs);
            ActionMap entryActionMap = this.tblOppEntries.getActionMap();
            entryActionMap.put("FocusChangeCol", null);
            entryActionMap.put("FocusChangeRow", null);
            entryActionMap.put("FocusChangeColReverse", null);
            entryActionMap.put("FocusChangeRowReverse", null);
            entryActionMap.put("SWITCHTABLE", null);
            ActionMap oppEntryActionMap = this.tblOppEntries.getActionMap();
            oppEntryActionMap.put("ACTIONKEY_AUTOBALANCE", null);
        }
        this.tblOppEntries.removeKDTActiveCellListener((KDTActiveCellListener)this.cfOppEntrySwitchLs);
        this.tblEntries.removeKDTActiveCellListener((KDTActiveCellListener)this.cfEntrySwitchLs);
    }

    @Override
    public void loadFields() {
        BOSUuid entryId;
        this.detachListeners();
        super.loadFields();
        this.curCfEntryIndex = -1;
        this.illegalCfEntryIndex = -1;
        this.tblOppEntries.removeRows();
        Vector<CfEntryData> vecCfEntryData = new Vector<CfEntryData>();
        HashMap<Object, CfEntryData> hmEntryIdToDataObject = new HashMap<Object, CfEntryData>();
        VoucherEntryCollection entries = this.vch.getEntries();
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            VoucherEntryInfo entry = entries.get(i);
            AccountViewInfo acc = entry.getAccount();
            if (acc.isBudget()) continue;
            CfEntryData dataObject = new CfEntryData(entry);
            vecCfEntryData.add(dataObject);
            entryId = entry.getId();
            if (entryId != null) {
                hmEntryIdToDataObject.put(entryId.toString(), dataObject);
                continue;
            }
            hmEntryIdToDataObject.put(entry.get("seq"), dataObject);
        }
        CashflowRecordCollection cfs = (CashflowRecordCollection)this.vch.getCashflowRecords();
        if (cfs != null && cfs.size() > 0) {
            this.isFullInfoEdited = true;
            for (CashflowRecordInfo r : cfs) {
                VoucherEntryInfo rawEntry = r.getEntry();
                entryId = rawEntry.getId();
                CfEntryData ed = null;
                ed = entryId != null ? (CfEntryData)hmEntryIdToDataObject.get(entryId.toString()) : (CfEntryData)hmEntryIdToDataObject.get(rawEntry.get("seq"));
                VoucherEntryInfo rawOppEntry = r.getOpposingAccountEntry();
                BOSUuid oppEntryId = rawOppEntry.getId();
                VoucherEntryInfo oppEntry = null;
                oppEntry = oppEntryId != null ? ((CfEntryData)hmEntryIdToDataObject.get(oppEntryId.toString())).getEntry() : ((CfEntryData)hmEntryIdToDataObject.get(rawOppEntry.get("seq"))).getEntry();
                CfOppEntryData oe = new CfOppEntryData(oppEntry, r.getFullInfoItem(), r.getOriginalAmount(), r.getLocalAmount(), r.getReportingAmount());
                ed.getOppEntries().add(oe);
            }
        }
        for (CfEntryData ed : vecCfEntryData) {
            IRow row = this.tblEntries.addRow();
            this.loadCfEntry(ed, row);
        }
        this.attachListeners();
        KDTSelectManager sm = this.tblEntries.getSelectManager();
        sm.removeAll(false);
        sm.select(0, -1);
    }

    protected void loadCfEntry(CfEntryData ed, IRow row) {
        String[] paramList = new String[]{"GL_012"};
        boolean isLongName = false;
        try {
            GlParam glParam = GlParam.getGlParams(null, (String[])paramList, (String)this.getVchCompany().getId().toString());
            isLongName = glParam.getBoolean("GL_012");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        VoucherEntryInfo entry = ed.getEntry();
        CurrencyInfo cur = entry.getCurrency();
        row.getCell("entry").setUserObject((Object)entry);
        row.getCell("entry").setValue((Object)(entry.getAccount().getNumber() + " " + (isLongName ? entry.getAccount().getLongName() : entry.getAccount().getName())));
        row.getCell("currency").setValue((Object)cur);
        BigDecimal coefficient = GlUtils.one;
        StringBuffer prec = new StringBuffer();
        for (int i = 0; i < cur.getPrecision(); ++i) {
            prec.append("0");
        }
        row.getCell("amount").getStyleAttributes().setNumberFormat("%r{#,##0." + prec.toString() + "}f");
        row.getCell("amount").setValue((Object)GlUtils.setScale(entry.getOriginalAmount(), cur.getPrecision()));
        row.getCell("localAmount").setValue((Object)GlUtils.setScale(entry.getLocalAmount(), this.localCurrency.getPrecision()));
        if (this.useReportingCurrency) {
            row.getCell("reportingAmount").setValue((Object)GlUtils.setScale(entry.getReportingAmount(), this.reportingCurrency.getPrecision()));
        } else if (row.getCell("reportingAmount") != null) {
            row.getCell("reportingAmount").getStyleAttributes().setHided(true);
        }
        row.setUserObject((Object)ed);
    }

    protected VoucherInfo.ExchangeRateWithValue getLocalExDefinition(int rowIndex) {
        CurrencyInfo cur = this.getOriginalCurrency(rowIndex);
        String curid = cur.getId().toString();
        VoucherInfo.ExchangeRateWithValue ex = null;
        ex = !this.isInList ? this.parentUI.getCachedLocalExchangeRate(cur.getId().toString()) : (curid.equals(this.localCurrency.getId().toString()) ? VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE : this.getEx(this.localCurrency.getId().toString()));
        return ex;
    }

    protected VoucherInfo.ExchangeRateWithValue getReportingExDefinition(int rowIndex) {
        CurrencyInfo cur = this.getOriginalCurrency(rowIndex);
        VoucherInfo.ExchangeRateWithValue ex = null;
        String curid = cur.getId().toString();
        if (!this.isInList) {
            ex = this.parentUI.getCachedReportingExchangeRate(cur.getId().toString());
        } else if (this.reportingCurrency != null && this.reportingCurrency.getId() != null) {
            ex = curid.equals(this.reportingCurrency.getId().toString()) ? VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE : this.getEx(this.reportingCurrency.getId().toString());
        }
        return ex;
    }

    protected VoucherInfo.ExchangeRateWithValue getEx(String orgCurId) {
        VoucherInfo.ExchangeRateWithValue ex = (VoucherInfo.ExchangeRateWithValue)this.exchangeRate.get(orgCurId);
        String localCurid = this.localCurrency.getId().toString();
        String reprotCurid = this.reportingCurrency.getId().toString();
        if (this.lexTableId == null) {
            this.exchangeRate.put(localCurid, VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE);
        }
        if (this.rexTableId == null) {
            this.exchangeRate.put(reprotCurid, VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE);
        }
        if (ex == null) {
            try {
                Object[] info = new Object[8];
                info[0] = this.lexTableId;
                info[1] = this.rexTableId;
                info[2] = orgCurId;
                info[3] = localCurid;
                info[4] = reprotCurid;
                info[5] = this.vch.getBookedDate();
                info[6] = this.vch.getPeriod().getBeginDate();
                Object[] exes = VoucherFacadeFactory.getRemoteInstance().fetchExchangeRate(info);
                this.exchangeRate.put(localCurid, (VoucherInfo.ExchangeRateWithValue)exes[0]);
                this.exchangeRate.put(reprotCurid, exes[1]);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        ex = (VoucherInfo.ExchangeRateWithValue)this.exchangeRate.get(orgCurId);
        return ex;
    }

    protected BigDecimal getLocalExValue(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.tblEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getLocalExchangeRate();
    }

    protected BigDecimal getReportingExValue(int rowIndex) {
        CfEntryData ed = (CfEntryData)this.tblEntries.getRow(rowIndex).getUserObject();
        return ed.getEntry().getReportingExchangeRate();
    }

    protected void construtsEntries(CashFlowItemInfo item, String columnName, VoucherEntryInfo oppEntry) {
        int rowCount = this.tblEntries.getRowCount();
        int index = this.tblEntries.getSelectManager().get().getTop();
        IRow rowCur = this.tblEntries.getRow(index);
        CfEntryData entrydata = (CfEntryData)rowCur.getUserObject();
        VoucherEntryInfo entryInfo = entrydata.getEntry();
        EntryDC entryDC = entryInfo.getEntryDC();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblEntries.getRow(i);
            CfEntryData ed = (CfEntryData)row.getUserObject();
            VoucherEntryInfo entry = ed.getEntry();
            EntryDC dc = entry.getEntryDC();
            CfOppEntryData oe = null;
            if (entryDC.getValue() != dc.getValue() || !columnName.equals("o.supplementaryItem") || ed.getOppEntries().size() <= 0 || (oe = (CfOppEntryData)ed.getOppEntries().get(0)).getFullInfoItem() == null) continue;
            oe.setFullInfoItem(item);
        }
    }

    protected boolean checkDataObject() {
        int rowCount = this.tblEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            CfEntryData ed = (CfEntryData)this.tblEntries.getRow(i).getUserObject();
            String prop = this.getCfEntryIllegalProp(ed);
            if (prop == null) continue;
            this.illegalCfEntryIndex = -1;
            this.curCfEntryIndex = -1;
            KDTSelectManager sm = this.tblEntries.getSelectManager();
            sm.removeAll(false);
            sm.select(i, -1);
            if (prop.startsWith("o.")) {
                int rowIndex = this.illegalCfOppEntryIndex;
                this.illegalCfOppEntryIndex = -1;
                this.curCfOppEntryIndex = -1;
                this.goBackToCell(this.tblOppEntries, rowIndex, prop);
            }
            return false;
        }
        return true;
    }

    protected String getCfEntryIllegalProp(CfEntryData ed) {
        BigDecimal zero;
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return null;
        }
        Vector oppEntries = ed.getOppEntries();
        BigDecimal amntTotal = zero = new BigDecimal("0");
        BigDecimal laTotal = zero;
        BigDecimal raTotal = zero;
        Iterator itr = oppEntries.iterator();
        int count = 0;
        boolean hasFuullItem = false;
        while (itr.hasNext()) {
            CfOppEntryData oe = (CfOppEntryData)itr.next();
            CashFlowItemInfo pi = oe.getFullInfoItem();
            if (pi == null) continue;
            hasFuullItem = true;
            String prop = this.getCfOppEntryIllegalProp(oe);
            if (prop != null) {
                this.illegalCfOppEntryIndex = count;
                return prop;
            }
            amntTotal = amntTotal.add(oe.getAmount().abs());
            laTotal = laTotal.add(oe.getLocalAmount().abs());
            if (oe.getReportingAmount() != null) {
                raTotal = raTotal.add(oe.getReportingAmount().abs());
            }
            ++count;
        }
        if (!hasFuullItem) {
            return null;
        }
        VoucherEntryInfo entry = ed.getEntry();
        if (entry.getOriginalAmount().abs().compareTo(amntTotal) != 0) {
            String amountNotBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"amountNotBalance");
            MsgBox.showWarning((Component)((Object)this), (String)amountNotBalance);
            if (!this.foreignCurrencySU) {
                return "amount";
            }
            return "localAmount";
        }
        if (entry.getLocalAmount().abs().compareTo(laTotal) != 0) {
            String localNotBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"localNotBalance");
            MsgBox.showWarning((Component)((Object)this), (String)localNotBalance);
            return "localAmount";
        }
        if (!this.foreignCurrencySU && this.useReportingCurrency && entry.getReportingAmount().abs().compareTo(raTotal) != 0) {
            String reportingNotBalance = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"reportingNotBalance");
            MsgBox.showWarning((Component)((Object)this), (String)reportingNotBalance);
            return "reportingAmount";
        }
        return null;
    }

    protected String getCfOppEntryIllegalProp(CfOppEntryData oe) {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return null;
        }
        CashFlowItemInfo pi = oe.getFullInfoItem();
        if (pi == null) {
            return null;
        }
        if (oe.getAmount() == null) {
            String missingAmount = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingAmount");
            MsgBox.showWarning((Component)((Object)this), (String)missingAmount);
            if (!this.foreignCurrencySU) {
                return "o.amount";
            }
            return "o.localAmount";
        }
        if (oe.getLocalAmount() == null) {
            String missingLocal = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingLocal");
            MsgBox.showWarning((Component)((Object)this), (String)missingLocal);
            return "o.localAmount";
        }
        if (!this.foreignCurrencySU && this.useReportingCurrency && oe.getReportingAmount() == null) {
            String missingReporting = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingReporting");
            MsgBox.showWarning((Component)((Object)this), (String)missingReporting);
            return "o.reportingAmount";
        }
        return null;
    }

    protected void goBackToCell(KDTable table, int rowIndex, String colKey) {
        table.getSelectManager().removeAll(false);
        table.getEditManager().editCellAt(rowIndex, table.getColumnIndex(colKey));
    }

    protected CashflowRecordCollection buildResult() {
        CashflowRecordCollection result = new CashflowRecordCollection();
        int rowCount = this.tblEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            CfEntryData ed = (CfEntryData)this.tblEntries.getRow(i).getUserObject();
            VoucherEntryInfo entry = ed.getEntry();
            Vector oppEntries = ed.getOppEntries();
            Iterator itr = oppEntries.iterator();
            int seq = 1;
            while (itr.hasNext()) {
                CfOppEntryData oe = (CfOppEntryData)itr.next();
                CashflowRecordInfo rec = new CashflowRecordInfo();
                CashFlowItemInfo si = oe.getFullInfoItem();
                if (si == null) continue;
                result.add(rec);
                rec.setSeq(seq++);
                rec.setVoucher(this.vch);
                rec.setEntry(entry);
                rec.setAccount(entry.getAccount());
                rec.setCurrency(entry.getCurrency());
                rec.setEntryDC(entry.getEntryDC());
                rec.setOpposingAccountEntry(oe.getOppEntry());
                rec.setOppAccount(oe.getOppEntry().getAccount());
                rec.setOppEntryDC(oe.getOppEntry().getEntryDC());
                rec.setItemFlag(ItemFlag.FULLINFO);
                rec.setIsSupItem(false);
                rec.setFullInfoItem(si);
                rec.setOriginalAmount(oe.getAmount());
                rec.setLocalAmount(oe.getLocalAmount());
                rec.setReportingAmount(oe.getReportingAmount());
            }
        }
        return result;
    }

    public void setResult(CashflowRecordCollection cf) {
        this.cfCol = cf;
    }

    public CashflowRecordCollection getResult() {
        return this.cfCol;
    }

    public void setReturnValue(int rv) {
        this.returnValue = rv;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    private void saveCashflow() throws Exception {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("vchid", this.vch.getId().toString());
        mapParam.put("vch", (String)this.vch);
        this.vch.setCashflowRecords((AbstractObjectCollection)this.cfCol);
        ICashflowRecord item = CashflowRecordFactory.getRemoteInstance();
        item.saveCashflowCols((IObjectCollection)this.cfCol, mapParam);
    }

    protected void afterSelectCfEntry(CfEntryData ed) {
        this.tblOppEntries.removeRows();
        this.curCfOppEntryIndex = -1;
        this.illegalCfOppEntryIndex = -1;
        if (ed != null) {
            IRow row;
            for (CfOppEntryData oe : ed.getOppEntries()) {
                row = this.tblOppEntries.addRow();
                this.loadCfOppEntry(oe, row);
            }
            if (this.tblOppEntries.getRowCount() == 0) {
                IRow cfRow = this.tblEntries.getRow(this.curCfEntryIndex);
                row = this.tblOppEntries.addRow();
                this.loadCfOppEntry(this.createNewOppEntry(cfRow), row);
            }
        } else {
            return;
        }
    }

    protected void afterSelectCfOppEntry(CfOppEntryData oe) {
        if (this.tblOppEntries.getRowCount() > 1) {
            this.actionRemoveLine.setEnabled(true);
        } else {
            this.actionRemoveLine.setEnabled(false);
        }
    }

    protected void storeCfEntry(CfEntryData ed, IRow row) {
        if (this.curCfOppEntryIndex >= 0) {
            IRow cfOppEntryRow = this.tblOppEntries.getRow(this.curCfOppEntryIndex);
            CfOppEntryData oe = (CfOppEntryData)cfOppEntryRow.getUserObject();
            this.storeCfOppEntry(oe, cfOppEntryRow);
        }
        Vector oeCol = ed.getOppEntries();
        oeCol.clear();
        int rowCount = this.tblOppEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow cfOppEntryRow = this.tblOppEntries.getRow(i);
            CfOppEntryData oe = (CfOppEntryData)cfOppEntryRow.getUserObject();
            oeCol.add(oe);
        }
        ed.setOppEntries(oeCol);
    }

    protected void storeCfOppEntry(CfOppEntryData oe, IRow row) {
        Object value = row.getCell("o.supplementaryItem").getValue();
        if (value instanceof Object[]) {
            value = ((Object[])value)[0];
        }
        oe.setFullInfoItem((CashFlowItemInfo)value);
        ICell amntCell = row.getCell("o.amount");
        ICell raCell = row.getCell("o.reportingAmount");
        BigDecimal amnt = (BigDecimal)amntCell.getValue();
        BigDecimal la = (BigDecimal)row.getCell("o.localAmount").getValue();
        BigDecimal ra = (BigDecimal)raCell.getValue();
        BigDecimal coefficient = GlUtils.one;
        if (amnt != null) {
            oe.setAmount(amnt.multiply(coefficient));
            oe.setLocalAmount(la.multiply(coefficient));
            if (this.useReportingCurrency) {
                oe.setReportingAmount(ra.multiply(coefficient));
            } else {
                oe.setReportingAmount(la.multiply(coefficient));
            }
        }
    }

    protected boolean isCellEditable(IRow cfOppEntryRow, String colKey) {
        Object value = cfOppEntryRow.getCell("o.supplementaryItem").getValue();
        return true;
    }

    public boolean isClear() {
        return this.isClear;
    }

    public void setClear(boolean isClear) {
        this.isClear = isClear;
    }

    private void checkVoucher() throws Exception {
        VoucherEntryCollection entries = this.vch.getEntries();
        VoucherEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            AccountViewInfo acc = entry.getAccount();
            if (acc != null) continue;
            throw new VoucherException(VoucherException.ACCOUNT_CANNOT_NULL, new Object[]{new Integer(i + 1)});
        }
    }

    private CompanyOrgUnitInfo getVchCompany() {
        return this.vch.getCompany();
    }

    static class CfOppEntryData {
        private VoucherEntryInfo oppEntry;
        private CashFlowItemInfo fullInfoItem;
        private BigDecimal amount;
        private BigDecimal localAmount;
        private BigDecimal reportingAmount;
        private boolean amntEverChanged = false;
        private boolean ramntEverChanged = false;

        public CfOppEntryData(VoucherEntryInfo ent) {
            this(ent, null, null, null, null);
        }

        public CfOppEntryData(VoucherEntryInfo ent, CashFlowItemInfo pi, BigDecimal amnt, BigDecimal la, BigDecimal ra) {
            this.oppEntry = ent;
            this.fullInfoItem = pi;
            this.amount = amnt;
            this.localAmount = la;
            this.reportingAmount = ra;
        }

        public void setOppEntrys(VoucherEntryInfo ent) {
            this.oppEntry = ent;
        }

        public VoucherEntryInfo getOppEntry() {
            return this.oppEntry;
        }

        public CashFlowItemInfo getFullInfoItem() {
            return this.fullInfoItem;
        }

        public void setFullInfoItem(CashFlowItemInfo fullInfoItem) {
            this.fullInfoItem = fullInfoItem;
        }

        public void setAmount(BigDecimal amnt) {
            this.amount = amnt;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setLocalAmount(BigDecimal la) {
            this.localAmount = la;
        }

        public BigDecimal getLocalAmount() {
            return this.localAmount;
        }

        public void setReportingAmount(BigDecimal ra) {
            this.reportingAmount = ra;
        }

        public BigDecimal getReportingAmount() {
            return this.reportingAmount;
        }

        public void setAmntEverChanged(boolean changed) {
            this.amntEverChanged = changed;
        }

        public boolean getAmntEverChanged() {
            return this.amntEverChanged;
        }

        public void setRamntEverChanged(boolean changed) {
            this.ramntEverChanged = changed;
        }

        public boolean getRamntEverChanged() {
            return this.ramntEverChanged;
        }
    }

    static class CfEntryData {
        private VoucherEntryInfo entry;
        private Vector oppEntries;

        public CfEntryData(VoucherEntryInfo ent) {
            this.entry = ent;
            this.oppEntries = new Vector();
        }

        public CfEntryData(VoucherEntryInfo ent, Vector oe) {
            this.entry = ent;
            this.oppEntries = oe;
        }

        public void setEntry(VoucherEntryInfo ent) {
            this.entry = ent;
        }

        public VoucherEntryInfo getEntry() {
            return this.entry;
        }

        public void setOppEntries(Vector oe) {
            this.oppEntries = oe;
        }

        public Vector getOppEntries() {
            return this.oppEntries;
        }
    }

    class CfOppEntrySwitchListener
    implements KDTActiveCellListener {
        CfOppEntrySwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent evt) {
            if (FullInfoEditUI.this.illegalCfOppEntryIndex >= 0) {
                FullInfoEditUI.this.illegalCfOppEntryIndex = -1;
                return;
            }
            int preLine = FullInfoEditUI.this.curCfOppEntryIndex;
            int line = evt.getRowIndex();
            if (preLine != line) {
                CfOppEntryData oe;
                IRow row;
                int rowCount = FullInfoEditUI.this.tblOppEntries.getRowCount();
                if (preLine >= rowCount) {
                    preLine = -1;
                }
                if (line >= rowCount) {
                    line = -1;
                }
                if (preLine >= 0) {
                    row = FullInfoEditUI.this.tblOppEntries.getRow(preLine);
                    oe = (CfOppEntryData)row.getUserObject();
                    FullInfoEditUI.this.storeCfOppEntry(oe, row);
                }
                FullInfoEditUI.this.curCfOppEntryIndex = line;
                if (line >= 0) {
                    row = FullInfoEditUI.this.tblOppEntries.getRow(line);
                    oe = (CfOppEntryData)row.getUserObject();
                    FullInfoEditUI.this.afterSelectCfOppEntry(oe);
                } else {
                    FullInfoEditUI.this.afterSelectCfOppEntry(null);
                }
            }
        }
    }

    class CfEntrySwitchListener
    implements KDTActiveCellListener {
        CfEntrySwitchListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent evt) {
            if (FullInfoEditUI.this.illegalCfEntryIndex >= 0) {
                FullInfoEditUI.this.illegalCfEntryIndex = -1;
                return;
            }
            int preLine = FullInfoEditUI.this.curCfEntryIndex;
            int line = evt.getRowIndex();
            if (preLine != line) {
                int rowCount = FullInfoEditUI.this.tblEntries.getRowCount();
                if (preLine >= rowCount) {
                    preLine = -1;
                }
                if (line >= rowCount) {
                    line = -1;
                }
                if (preLine >= 0) {
                    KDTEditManager em = FullInfoEditUI.this.tblOppEntries.getEditManager();
                    if (em.isEditing()) {
                        em.stopEditing();
                    }
                    IRow row = FullInfoEditUI.this.tblEntries.getRow(preLine);
                    CfEntryData ed = (CfEntryData)row.getUserObject();
                    FullInfoEditUI.this.storeCfEntry(ed, row);
                }
                FullInfoEditUI.this.curCfEntryIndex = line;
                if (line >= 0) {
                    IRow row = FullInfoEditUI.this.tblEntries.getRow(line);
                    CfEntryData ed = (CfEntryData)row.getUserObject();
                    FullInfoEditUI.this.oppEntry = ed.getEntry();
                    FullInfoEditUI.this.afterSelectCfEntry(ed);
                } else {
                    FullInfoEditUI.this.afterSelectCfEntry(null);
                }
            }
        }
    }

    class CfOppEntryEditAdapter
    extends KDTEditAdapter {
        private Object oldValue;

        CfOppEntryEditAdapter() {
        }

        public void editStarting(KDTEditEvent evt) {
            String colKey;
            if (evt.getRowIndex() != FullInfoEditUI.this.curCfOppEntryIndex) {
                evt.setCancel(true);
                return;
            }
            IRow curRow = FullInfoEditUI.this.tblOppEntries.getRow(evt.getRowIndex());
            if (!FullInfoEditUI.this.isCellEditable(curRow, colKey = FullInfoEditUI.this.tblOppEntries.getColumnKey(evt.getColIndex()))) {
                evt.setCancel(true);
                return;
            }
            super.editStarting(evt);
            KDTable table = (KDTable)evt.getSource();
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            this.oldValue = table.getRow(rowIndex).getCell(colIndex).getValue();
            String colKey2 = table.getColumnKey(colIndex);
            ICellEditor editor = table.getEditManager().getEditor();
            Component component = editor.getComponent();
            if (editor == FullInfoEditUI.this.numberEditor) {
                KDFormattedTextField numberField = (KDFormattedTextField)FullInfoEditUI.this.numberEditor.getComponent();
                if ("o.amount".equals(colKey2)) {
                    int prec = FullInfoEditUI.this.getOriginalCurrency(FullInfoEditUI.this.curCfEntryIndex).getPrecision();
                    numberField.setPrecision(prec);
                } else if ("o.localAmount".equals(colKey2)) {
                    numberField.setPrecision(FullInfoEditUI.this.localCurrency.getPrecision());
                } else if ("o.reportingAmount".equals(colKey2)) {
                    numberField.setPrecision(FullInfoEditUI.this.reportingCurrency.getPrecision());
                }
            } else if (component instanceof KDBizPromptBox) {
                KDBizPromptBox bizPromptBox = (KDBizPromptBox)component;
                if ("o.supplementaryItem".equals(colKey2)) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    FilterItemCollection fic = filter.getFilterItems();
                    fic.add(new FilterItemInfo("type", (Object)new Integer(2)));
                    fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
                    fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    filter.setMaskString("#0 AND #1 AND #2 ");
                    bizPromptBox.setEntityViewInfo(view);
                    String cuid = FullInfoEditUI.this.getVchCompany().getCU().getId().toString();
                    CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizPromptBox, (FilterInfo)filter, (CoreUIObject)FullInfoEditUI.this, (String)cuid);
                    FilterInfo filter4Tree = new FilterInfo();
                    FilterItemCollection ficTree = filter4Tree.getFilterItems();
                    ficTree.add(new FilterItemInfo("type", (Object)new Integer(2)));
                    ficTree.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
                    FilterInfo viewFilter = null;
                    String ctrlUnitId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
                    try {
                        viewFilter = CashFlowItemViewFactory.getRemoteInstance().getCashFlowItemViewFilter(ctrlUnitId);
                        if (viewFilter != null) {
                            filter4Tree.mergeFilter(viewFilter, "and");
                        }
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    FullInfoEditUI.this.getUIContext().put("filter4Tree", filter4Tree);
                }
            }
        }

        public void editStopped(KDTEditEvent evt) {
            Object newValue;
            super.editStopped(evt);
            Object oldValue = evt.getOldValue();
            if (oldValue instanceof Object[]) {
                oldValue = ((Object[])oldValue)[0];
            }
            if ((newValue = evt.getValue()) instanceof Object[]) {
                newValue = ((Object[])newValue)[0];
            }
            if (!GlUtils.isEqual(newValue, oldValue)) {
                KDTable table = (KDTable)evt.getSource();
                int row = evt.getRowIndex();
                int col = evt.getColIndex();
                String colKey = table.getColumnKey(col);
                IRow curRow = table.getRow(row);
                CfOppEntryData oe = (CfOppEntryData)curRow.getUserObject();
                if (!FullInfoEditUI.this.isFullInfoEdited) {
                    if (oe.getOppEntry().getAccount() == null) {
                        return;
                    }
                    String acctid = oe.getOppEntry().getAccount().getId().toString();
                    if ("o.supplementaryItem".equals(colKey)) {
                        FullInfoEditUI.this.fullInfoItem = (CashFlowItemInfo)newValue;
                        FullInfoEditUI.this.construtsEntries(FullInfoEditUI.this.fullInfoItem, colKey, oe.getOppEntry());
                        FullInfoEditUI.this.isFullInfoEdited = true;
                        FullInfoEditUI.this.fullInfoEditedMap.put(acctid, FullInfoEditUI.this.fullInfoItem.getId().toString());
                    }
                }
                if ("o.amount".equals(colKey)) {
                    oe.setAmntEverChanged(true);
                    if (newValue == null) {
                        curRow.getCell("o.localAmount").setValue(null);
                        curRow.getCell("o.reportingAmount").setValue(null);
                    } else {
                        VoucherInfo.ExchangeRateWithValue lexObj = FullInfoEditUI.this.getLocalExDefinition(FullInfoEditUI.this.curCfEntryIndex);
                        VoucherInfo.ExchangeRateWithValue rexObj = FullInfoEditUI.this.getReportingExDefinition(FullInfoEditUI.this.curCfEntryIndex);
                        BigDecimal lex = FullInfoEditUI.this.getLocalExValue(FullInfoEditUI.this.curCfEntryIndex);
                        BigDecimal la = null;
                        BigDecimal ra = null;
                        BigDecimal amnt = (BigDecimal)newValue;
                        la = lexObj != null ? (ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)lexObj.getConvertMode()) ? amnt.multiply(lex).setScale(FullInfoEditUI.this.localCurrency.getPrecision(), FullInfoEditUI.this.amountRoundMode) : amnt.divide(lex, FullInfoEditUI.this.localCurrency.getPrecision(), FullInfoEditUI.this.amountRoundMode)) : amnt;
                        if (!FullInfoEditUI.this.isSettleByLocal) {
                            BigDecimal rex = FullInfoEditUI.this.getReportingExValue(FullInfoEditUI.this.curCfEntryIndex);
                            ra = rexObj != null && rex != null ? (ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rexObj.getConvertMode()) ? amnt.multiply(rex).setScale(FullInfoEditUI.this.reportingCurrency.getPrecision(), FullInfoEditUI.this.amountRoundMode) : amnt.divide(rex, FullInfoEditUI.this.reportingCurrency.getPrecision(), FullInfoEditUI.this.amountRoundMode)) : la;
                        } else {
                            ra = FullInfoEditUI.this.useReportingCurrency ? la.multiply(FullInfoEditUI.this.localToRpt.getValue()).setScale(FullInfoEditUI.this.reportingCurrency.getPrecision(), FullInfoEditUI.this.amountRoundMode) : la;
                        }
                        curRow.getCell("o.localAmount").setValue((Object)la);
                        curRow.getCell("o.reportingAmount").setValue((Object)ra);
                    }
                } else if ("o.reportingAmount".equals(colKey)) {
                    oe.setRamntEverChanged(true);
                } else if ("o.localAmount".equals(colKey)) {
                    CurrencyInfo cur = FullInfoEditUI.this.getOriginalCurrency(FullInfoEditUI.this.curCfEntryIndex);
                    ICell amntCell = curRow.getCell("o.amount");
                    if ((amntCell.getValue() == null || !oe.getAmntEverChanged()) && GlUtils.isEqual(cur, FullInfoEditUI.this.localCurrency)) {
                        amntCell.setValue(newValue);
                    }
                    ICell raCell = curRow.getCell("o.reportingAmount");
                    if (!FullInfoEditUI.this.isSettleByLocal) {
                        if ((raCell.getValue() == null || !oe.getRamntEverChanged()) && GlUtils.isEqual(cur, FullInfoEditUI.this.reportingCurrency)) {
                            raCell.setValue(newValue);
                        }
                    } else {
                        raCell.setValue(newValue);
                    }
                }
            }
        }
    }

    class CfFocusListener
    extends KDTFocusChangeAction {
        CfFocusListener(KDTable table, short dirCode, boolean isReverse) {
            super(table, dirCode, isReverse);
        }

        public void actionPerformed(ActionEvent evt) {
            KDTEditManager em = this.table.getEditManager();
            int result = em.stopEditing();
            if (0 != result) {
                return;
            }
            KDTSelectManager sm = this.table.getSelectManager();
            int rowIndex = sm.getActiveRowIndex();
            int colIndex = sm.getActiveColumnIndex();
            int rowCount = this.table.getRowCount();
            int colCount = this.table.getColumnCount();
            if (rowIndex < 0) {
                return;
            }
            if (this.reverse) {
                IRow row = this.table.getRow(rowIndex);
                for (int i = colIndex - 1; i >= 0; --i) {
                    String colKey = this.table.getColumnKey(i);
                    StyleAttributes sa = row.getCell(i).getStyleAttributes();
                    if (sa.isHided() || sa.isLocked() || !FullInfoEditUI.this.isCellEditable(row, colKey)) continue;
                    sm.removeAll(false);
                    em.editCellAt(rowIndex, i);
                    return;
                }
                sm.removeAll(false);
                em.editCellAt(rowIndex, colIndex);
            } else {
                int nextRowIndex = rowIndex;
                do {
                    sm.removeAll(false);
                    sm.select(nextRowIndex, 0);
                    if (FullInfoEditUI.this.curCfOppEntryIndex != nextRowIndex) {
                        return;
                    }
                    IRow row = this.table.getRow(nextRowIndex);
                    for (int i = colIndex + 1; i < colCount; ++i) {
                        String colKey = this.table.getColumnKey(i);
                        StyleAttributes sa = row.getCell(i).getStyleAttributes();
                        if (sa.isHided() || sa.isLocked() || !FullInfoEditUI.this.isCellEditable(row, colKey)) continue;
                        sm.removeAll(false);
                        em.editCellAt(nextRowIndex, i);
                        return;
                    }
                    String state = FullInfoEditUI.this.getOprtState();
                    if (nextRowIndex == rowCount - 1 && !OprtState.VIEW.equals(state)) {
                        try {
                            FullInfoEditUI.this.actionAddLine_actionPerformed(null);
                            if (FullInfoEditUI.this.curCfOppEntryIndex != rowCount) {
                                return;
                            }
                            ++rowCount;
                        }
                        catch (Exception ex) {
                            FullInfoEditUI.this.handUIException(ex);
                            return;
                        }
                    }
                    colIndex = -1;
                } while (++nextRowIndex < rowCount);
                if (nextRowIndex == rowCount) {
                    sm.removeAll(false);
                    em.editCellAt(rowIndex, colIndex);
                }
            }
        }
    }

    class CfExitListener
    extends KDTFocusChangeAction {
        CfExitListener(KDTable table, short dirCode, boolean isReverse) {
            super(table, dirCode, isReverse);
        }

        public void actionPerformed(ActionEvent evt) {
            KDTEditManager em = FullInfoEditUI.this.tblOppEntries.getEditManager();
            int result = em.stopEditing();
            if (0 != result) {
                return;
            }
            int entryCount = FullInfoEditUI.this.tblEntries.getRowCount();
            if (FullInfoEditUI.this.curCfEntryIndex < entryCount - 1) {
                KDTSelectManager smEntries = FullInfoEditUI.this.tblEntries.getSelectManager();
                smEntries.removeAll(false);
                smEntries.select(FullInfoEditUI.this.curCfEntryIndex + 1, 0);
                int rowCount = FullInfoEditUI.this.tblOppEntries.getRowCount();
                int colCount = FullInfoEditUI.this.tblOppEntries.getColumnCount();
                KDTSelectManager sm = FullInfoEditUI.this.tblOppEntries.getSelectManager();
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < colCount; ++j) {
                        IRow row = FullInfoEditUI.this.tblOppEntries.getRow(i);
                        String colKey = FullInfoEditUI.this.tblOppEntries.getColumnKey(j);
                        StyleAttributes sa = row.getCell(j).getStyleAttributes();
                        if (sa.isHided() || sa.isLocked() || !FullInfoEditUI.this.isCellEditable(row, colKey)) continue;
                        sm.removeAll(false);
                        em.editCellAt(i, j);
                        return;
                    }
                }
            }
        }
    }

    class CashFlowShortcutListener
    extends AbstractAction {
        KDTable table;
        String shortcut;

        CashFlowShortcutListener(KDTable tbl, String sc) {
            this.table = tbl;
            this.shortcut = sc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            KDTEditManager em = FullInfoEditUI.this.tblOppEntries.getEditManager();
            KDTSelectManager sm = FullInfoEditUI.this.tblEntries.getSelectManager();
            if (em.isEditing()) {
                em.stopEditing();
            }
            if ("TABTABLEUP".equals(this.shortcut)) {
                sm.set(FullInfoEditUI.this.curCfEntryIndex - 1, -1);
                em.editCellAt(0, 1);
            } else if ("TABTABLEDOWN".equals(this.shortcut)) {
                if (this.table != FullInfoEditUI.this.tblEntries) {
                    sm.set(FullInfoEditUI.this.curCfEntryIndex + 1, -1);
                }
                em.editCellAt(0, 1);
            } else if ("TABLEUP".equals(this.shortcut)) {
                if (this.table == FullInfoEditUI.this.tblEntries) {
                    sm.set(FullInfoEditUI.this.curCfEntryIndex - 1, -1);
                    em.editCellAt(0, 1);
                }
            } else if ("TABLEDOWN".equals(this.shortcut)) {
                if (this.table == FullInfoEditUI.this.tblEntries) {
                    sm.set(FullInfoEditUI.this.curCfEntryIndex + 1, -1);
                    em.editCellAt(0, 1);
                }
            } else if ("ACTIONKEY_AUTOBALANCE".equals(this.shortcut)) {
                FullInfoEditUI.this.autoBalance(FullInfoEditUI.this.tblOppEntries);
            }
        }
    }
}

