/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.GLConfig;
import com.kingdee.eas.fi.gl.GLParamFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractGLConfigUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GLConfigUI
extends AbstractGLConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(GLConfigUI.class);
    private boolean isServerConfig = false;
    private List configs;

    public void onLoad() throws Exception {
        String dir;
        super.onLoad();
        this.kDTable.checkParsed();
        this.kDTable.getSelectManager().setSelectMode(1);
        this.kDTable.getColumn("name").getStyleAttributes().setLocked(true);
        this.kDTable.getColumn("def").getStyleAttributes().setLocked(true);
        this.kDTable.getColumn("desc").getStyleAttributes().setLocked(true);
        String title = (String)this.getUIContext().get("name");
        if ("GLServerConfig".equals(this.getUIContext().get("ID"))) {
            this.isServerConfig = true;
            dir = (String)GLParamFacadeFactory.getRemoteInstance().getSysProps().get("EAS_INSTANCE_CONFIG_PATH");
            this.configs = GLParamFacadeFactory.getRemoteInstance().getGLConfigs();
        } else {
            dir = System.getProperty("easclient.root");
            this.configs = GLConfig.getConfigs(null);
        }
        if (dir != null) {
            title = title + " - " + dir;
        }
        this.setUITitle(title);
        this.showConfigs(this.configs);
        if (this.configs.size() > 0) {
            this.kDTable.getSelectManager().select(0, 0);
        }
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        List<GLConfig> configs = this.buildConfigs();
        if (configs.size() > 0) {
            if (this.isServerConfig) {
                GLParamFacadeFactory.getRemoteInstance().saveGLConfigs(configs);
            } else {
                GLConfig.saveConfigs(null, configs);
            }
        }
        this.destroyWindow();
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void showConfigs(List configs) {
        this.kDTable.checkParsed();
        for (Object object : configs) {
            GLConfig config = (GLConfig)object;
            IRow row = this.kDTable.addRow();
            row.getCell("name").setValue((Object)config.name);
            row.getCell("value").setValue((Object)config.value);
            row.getCell("def").setValue((Object)config.def);
            row.getCell("desc").setValue((Object)config.desc);
        }
    }

    private List<GLConfig> buildConfigs() {
        ArrayList<GLConfig> configs = new ArrayList<GLConfig>();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            Object object = row.getCell("name").getValue();
            if (object == null || object.toString().trim().length() <= 0) continue;
            String name = object.toString().trim();
            String value = "";
            object = row.getCell("value").getValue();
            if (object != null) {
                value = object.toString().trim();
            }
            GLConfig config = new GLConfig();
            config.name = name;
            config.value = value;
            configs.add(config);
        }
        return configs;
    }

    @Override
    public void actionDefault_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndexs = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        if (rowIndexs.length > 0) {
            this.kDTable.getCell(rowIndexs[0], "value").setValue(this.kDTable.getCell(rowIndexs[0], "def").getValue());
        }
    }

    @Override
    public void actionDefaultAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            row.getCell("value").setValue(row.getCell("def").getValue());
        }
    }
}

