/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.client.AbstractGLDebugParamUI;
import com.kingdee.eas.fi.gl.client.GLDebugParam;
import com.kingdee.eas.fi.gl.client.GLDebugParamListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLDebugParamUI
extends AbstractGLDebugParamUI {
    private static final Logger logger = CoreUIObject.getLogger(GLDebugParamUI.class);
    private GLDebugParamListener listener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        if (uiContext.get("DebugParam") != null) {
            List params = (List)uiContext.get("DebugParam");
            this.showParams(params);
        }
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        Map uiContext = this.getUIContext();
        if (uiContext.get("DebugParamListener") != null) {
            List<GLDebugParam> params = this.buildParams();
            GLDebugParamListener listener = (GLDebugParamListener)uiContext.get("DebugParamListener");
            listener.apply(params);
        }
        this.destroyWindow();
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void showParams(List<GLDebugParam> params) {
        this.kDTable.checkParsed();
        for (GLDebugParam param : params) {
            IRow row = this.kDTable.addRow();
            row.getCell("name").setValue((Object)param.name);
            row.getCell("value").setValue((Object)param.value);
            row.getCell("desc").setValue((Object)param.desc);
        }
    }

    private List<GLDebugParam> buildParams() {
        ArrayList<GLDebugParam> params = new ArrayList<GLDebugParam>();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            Object object = row.getCell("name").getValue();
            if (object == null || object.toString().trim().length() <= 0) continue;
            String name = object.toString().trim();
            String value = "";
            object = row.getCell("value").getValue();
            if (object != null) {
                value = object.toString().trim();
            }
            String desc = "";
            object = row.getCell("desc").getValue();
            if (object != null) {
                desc = object.toString();
            }
            GLDebugParam param = new GLDebugParam(name, value, desc);
            params.add(param);
        }
        return params;
    }
}

