/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.SystemEnum;
import java.util.HashSet;

public class GLEditUIUtil {
    public static CompanyOrgUnitInfo getFirstCompany(String permissionItem) throws EASBizException, BOSException {
        return GLEditUIUtil.getFirstCompany(permissionItem, null);
    }

    public static CompanyOrgUnitInfo getFirstCompany(String permissionItem, FilterInfo filter) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company.isIsBizUnit()) {
            UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            if (startPeriod != null && company.getAccountTable() != null) {
                boolean hasFunction = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(company.getId()), permissionItem);
                if (!hasFunction) {
                    return GLEditUIUtil.findCompanyOrgUnitInfo(permissionItem, filter);
                }
                if (filter != null) {
                    CompanyOrgUnitCollection coll;
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filterN = new FilterInfo();
                    view.setFilter(filterN);
                    view.setSelector(GlUtils.getCompanySic());
                    filterN.getFilterItems().add(new FilterItemInfo("id", (Object)company.getId().toString()));
                    if (filter != null) {
                        filterN.mergeFilter(filter, "AND");
                    }
                    if ((coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view)) == null || coll.size() == 0) {
                        return GLEditUIUtil.findCompanyOrgUnitInfo(permissionItem, filter);
                    }
                }
                return company;
            }
            return GLEditUIUtil.findCompanyOrgUnitInfo(permissionItem, filter);
        }
        return GLEditUIUtil.findCompanyOrgUnitInfo(permissionItem, filter);
    }

    private static CompanyOrgUnitInfo findCompanyOrgUnitInfo(String permissionItem, FilterInfo filter) throws EASBizException, BOSException {
        CompanyOrgUnitCollection coll = GLEditUIUtil.getAuthorizedOrg(permissionItem, filter);
        if (coll == null) {
            return null;
        }
        CompanyOrgUnitInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)info);
            if (startPeriod == null) continue;
            return info;
        }
        return info;
    }

    private static CompanyOrgUnitCollection getAuthorizedOrg(String permissionItem, FilterInfo filter) throws BOSException, EASBizException {
        UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
        HashSet<String> idSet = new HashSet<String>();
        IPermission permission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(curUser.getId()), OrgType.Company, null, permissionItem);
        for (int i = 0; i < mainOrgs.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)mainOrgs.getObject(i);
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterN = new FilterInfo();
        view.setFilter(filterN);
        view.setSelector(GlUtils.getCompanySic());
        SorterItemCollection sorter = view.getSorter();
        sorter.add(new SorterItemInfo("longNumber"));
        filterN.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
        filterN.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0), CompareType.EQUALS));
        filterN.getFilterItems().add(new FilterItemInfo("isAssistantOrg", (Object)new Integer(0), CompareType.EQUALS));
        filterN.getFilterItems().add(new FilterItemInfo("accountTable.id", null, CompareType.NOTEQUALS));
        filterN.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        if (filter != null) {
            filterN.mergeFilter(filter, "AND");
        }
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
    }

    public static VoucherTypeInfo getDefaultVoucherTypeInfo(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        VoucherTypeCollection vtCol = VoucherTypeFactory.getRemoteInstance().getVoucherTypes(company.getCU().getId().toString());
        VoucherTypeInfo vtDefault = null;
        for (VoucherTypeInfo vt : vtCol) {
            if (!vt.isPretermit()) continue;
            vtDefault = vt;
            break;
        }
        if (!vtCol.isEmpty() && vtDefault == null) {
            vtDefault = vtCol.get(0);
        }
        return vtDefault;
    }

    public static VoucherTypeInfo getDefaultVoucherTypeInfo(CompanyOrgUnitInfo company, Context mainOrgContext) throws EASBizException, BOSException {
        IVoucherType vtCtrl = null;
        vtCtrl = mainOrgContext != null ? VoucherTypeFactory.getRemoteInstanceWithObjectContext((Context)mainOrgContext) : VoucherTypeFactory.getRemoteInstance();
        VoucherTypeCollection vtCol = vtCtrl.getVoucherTypes(company.getCU().getId().toString());
        VoucherTypeInfo vtDefault = null;
        for (VoucherTypeInfo vt : vtCol) {
            if (!vt.isPretermit()) continue;
            vtDefault = vt;
            break;
        }
        if (!vtCol.isEmpty() && vtDefault == null) {
            vtDefault = vtCol.get(0);
        }
        return vtDefault;
    }
}

