/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AccountBalanceInitData;
import com.kingdee.eas.fi.gl.AssistInitFacadeFactory;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.GLInitFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLInitFacade;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractGLInitUI;
import com.kingdee.eas.fi.gl.client.InitClientHelp;
import com.kingdee.eas.fi.gl.common.RowNode;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.util.SaveTimer;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GLInitUI
extends AbstractGLInitUI {
    private static final long serialVersionUID = -7414341946024923071L;
    private static final Logger logger = CoreUIObject.getLogger(GLInitUI.class);
    private static final String COLUMN_YEARDEBITFOR = "YearDebitFor";
    private static final String COLUMN_YEARDEBITLOCAL = "YearDebitLocal";
    private static final String COLUMN_YEARDEBITREPORT = "YearDebitReport";
    private static final String COLUMN_YEARCREDITFOR = "YearCreditFor";
    private static final String COLUMN_YEARCREDITLOCAL = "YearCreditLocal";
    private static final String COLUMN_YEARCREDITREPORT = "YearCreditReport";
    private static final String COLUMN_MONTHBEGINFOR = "MonthBeginFor";
    private static final String COLUMN_MONTHBEGINLOCAL = "MonthBeginLocal";
    private static final String COLUMN_MONTHBEGINREPORT = "MonthBeginReport";
    private static final String COLUMN_YEARPNLFOR = "YearPnLFor";
    private static final String COLUMN_YEARPNLLOCAL = "YearPnLLocal";
    private static final String COLUMN_YEARPNLREPORT = "YearPnLReport";
    private static final String COLUMN_YEARDEBITQTY = "YearDebitQty";
    private static final String COLUMN_YEARCREDITQTY = "YearCreditQty";
    private static final String COLUMN_MONTHBEGINQTY = "MonthBeginQty";
    private static final String COLUMN_ACCOUNTNUMBER = "AccountNumber";
    private static final String COLUMN_ACCOUNTNAME = "AccountName";
    private static final String COLUMN_ACCOUNTDC = "DC";
    private static final String COLUMN_MEASUREUNIT = "MeasureUnit";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.InitResource";
    public static final String INITRESOURCE_PATH = "com.kingdee.eas.fi.gl.InitResource";
    private CompanyOrgUnitInfo curCompany;
    private boolean isEditable = true;
    public static boolean isInitClosed;
    private PeriodInfo startPeriod;
    private PeriodInfo currentPeriod;
    private PeriodInfo firstPeriod;
    private CurrencyCollection allCurrency;
    private CurrencyInfo localCur;
    private CurrencyInfo reportCur;
    private CurrencyInfo generalLocalCurrency;
    private CurrencyInfo generalReportCurrency;
    private HashMap hmLocalExchangeRate = new HashMap();
    private HashMap hmReportingExchangeRate = new HashMap();
    private boolean isForeignCurrency;
    private int qtyScale;
    private ICellEditor amountEditor;
    private ICellEditor localAmountEditor;
    private ICellEditor reportAmountEditor;
    private ICellEditor qtyEditor;
    private KDFormattedTextField qtyFormattedTextField;
    private KDFormattedTextField amountFormattedTextField;
    private KDFormattedTextField localAmountFormattedTextField;
    private KDFormattedTextField reportAmountFormattedTextField;
    private CurrencyInfo curCur;
    private boolean isSettleByLocal = true;
    private VoucherInfo.ExchangeRateWithValue rexLocalToRpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
    protected AccountTableInfo accouttable;
    private AccountTableCollection allAccouttable;
    private boolean isDiv2Local;
    private boolean isDiv2Report;
    private BigDecimal curExRate2Local;
    private BigDecimal curExRate2Report;
    private boolean isLocal;
    private boolean isReport;
    private boolean isFirstPeriod;
    private boolean isUsingReport;
    private boolean isAccoutInitFromAsst;
    private int amountScale;
    private int localAmountScale;
    private int reportAmountScale;
    private boolean dirty = false;
    int roundMode = 4;
    BigDecimal zero = new BigDecimal("0.00");
    private boolean initialized = false;
    private ArrayList accountLevelArray = new ArrayList();
    private HashMap rowNodeMap = new HashMap();
    private boolean isMasterBook = true;
    HashMap otherCtx = new HashMap();
    private AccountBalanceInitData[] tableDatas;
    private Map<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
    private boolean isQtyByAcct = false;
    private ItemListener myItemListener = this.createItemListener();
    private boolean reenter = false;
    private Object oldItem = null;
    Runnable laterThread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                GLInitUI.this.rowNodeMap.clear();
                GLInitUI.this.accountLevelArray.clear();
                CurrencyInfo currency = (CurrencyInfo)GLInitUI.this.cbCurrency.getSelectedItem();
                GLInitUI.this.curCur = currency;
                if (GLInitUI.this.isForeignCurrency) {
                    GLInitUI.this.isLocal = false;
                    GLInitUI.this.isReport = false;
                    GLInitUI.this.amountScale = GLInitUI.this.curCur.getPrecision();
                    GLInitUI.this.curExRate2Local = InitClientHelp.zero;
                    GLInitUI.this.curExRate2Report = InitClientHelp.zero;
                } else if (currency.isGeneralLocalCurrency()) {
                    GLInitUI.this.isLocal = false;
                    GLInitUI.this.isReport = false;
                    GLInitUI.this.amountScale = GLInitUI.this.localCur.getPrecision();
                    GLInitUI.this.tfExRate.setText("");
                    GLInitUI.this.tryBalanceAction.setEnabled(true);
                } else if (currency.isGeneralReportCurrency()) {
                    GLInitUI.this.isLocal = false;
                    GLInitUI.this.isReport = false;
                    GLInitUI.this.amountScale = GLInitUI.this.reportCur.getPrecision();
                    GLInitUI.this.tfExRate.setText("");
                    GLInitUI.this.tryBalanceAction.setEnabled(true);
                } else if (!currency.isGeneralLocalCurrency() && !currency.isGeneralReportCurrency()) {
                    VoucherInfo.ExchangeRateWithValue lex = GLInitUI.this.getCachedLocalExchangeRate(currency.getId().toString());
                    VoucherInfo.ExchangeRateWithValue rex = null;
                    if (lex == null) {
                        GLInitUI.this.cbCurrency.removeItemListener(GLInitUI.this.myItemListener);
                        GLInitUI.this.cbCurrency.setSelectedItem(GLInitUI.this.oldItem);
                        GLInitUI.this.curCur = (CurrencyInfo)GLInitUI.this.oldItem;
                        GLInitUI.this.cbCurrency.addItemListener(GLInitUI.this.myItemListener);
                        GLInitUI.this.setFreeState();
                        return;
                    }
                    if (GLInitUI.this.isUsingReport) {
                        GLInitUI.this.isSettleByLocal = 3 == GLInitUI.this.curCompany.getReportConvertMode().getValue();
                        rex = GLInitUI.this.isSettleByLocal ? GLInitUI.this.rexLocalToRpt : GLInitUI.this.getCachedReportingExchangeRate(currency.getId().toString());
                        if (rex == null) {
                            GLInitUI.this.cbCurrency.removeItemListener(GLInitUI.this.myItemListener);
                            GLInitUI.this.cbCurrency.setSelectedItem(GLInitUI.this.oldItem);
                            GLInitUI.this.curCur = (CurrencyInfo)GLInitUI.this.oldItem;
                            GLInitUI.this.cbCurrency.addItemListener(GLInitUI.this.myItemListener);
                            GLInitUI.this.setFreeState();
                            return;
                        }
                    }
                    GLInitUI.this.amountScale = GLInitUI.this.curCur.getPrecision();
                    GLInitUI.this.tfExRate.setText(GlUtils.setScale(lex.getValue(), lex.getPresion()).toString());
                    GLInitUI.this.lblExRate.setVisible(true);
                    GLInitUI.this.isLocal = currency.getId().equals((Object)GLInitUI.this.localCur.getId());
                    GLInitUI.this.curExRate2Local = lex.getValue();
                    GLInitUI.this.isDiv2Local = lex.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE);
                    if (GLInitUI.this.isUsingReport) {
                        GLInitUI.this.curExRate2Report = rex.getValue();
                        GLInitUI.this.isDiv2Report = rex.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE);
                        GLInitUI.this.isReport = currency.getId().equals((Object)GLInitUI.this.reportCur.getId());
                    }
                    GLInitUI.this.tryBalanceAction.setEnabled(false);
                }
                if (GLInitUI.this.isLocal) {
                    GLInitUI.this.lblCurLocal.setVisible(true);
                } else {
                    GLInitUI.this.lblCurLocal.setVisible(false);
                }
                if (GLInitUI.this.isLocal || currency.isGeneralLocalCurrency() || currency.isGeneralReportCurrency()) {
                    GLInitUI.this.lblExRate.setVisible(false);
                }
                InitClientHelp.setFormattedTextFieldScale(GLInitUI.this.amountFormattedTextField, GLInitUI.this.amountScale);
                InitClientHelp.setAmountGroupUse(GLInitUI.this.tblMain, GLInitUI.this.amountEditor, GLInitUI.this.amountScale);
                GLInitUI.this.otherCtx.put("AMOUNTSCALE", new Integer(GLInitUI.this.amountScale));
                if (currency.isGeneralLocalCurrency() || currency.isGeneralReportCurrency()) {
                    GLInitUI.this.tblMain.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
                } else {
                    GLInitUI.this.tblMain.getStyleAttributes().setBackground(Color.WHITE);
                }
                GLInitUI.this.loadData();
                GLInitUI.this.initialized = true;
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                GLInitUI.this.handUIException(e);
                GLInitUI.this.setFreeState();
            }
            finally {
                GLInitUI.this.cbCurrency.dispatchEvent((AWTEvent)new FocusEvent((Component)GLInitUI.this.cbCurrency, 1004, true));
                GLInitUI.this.cbCurrency.requestFocusInWindow();
            }
        }
    };
    TableSelectionListener myTableSelectionListener = new TableSelectionListener();
    private ExtVarProvider evp = new ExtVarProvider(){

        public Variant requestVarData(String varName) {
            return GLInitUI.this.preparePrintVariant(varName);
        }
    };
    private int saveTimeLen = 0;
    private SaveTimer timer;

    private void makeRowTree() {
        int i;
        int level;
        this.rowNodeMap.clear();
        int rowCount = this.tblMain.getRowCount();
        for (int i2 = 0; i2 < rowCount; ++i2) {
            IRow row = this.tblMain.getRow(i2);
            if (row == null) continue;
            AccountBalanceInitData data = (AccountBalanceInitData)row.getUserObject();
            level = data.getAccountLevel();
            RowNode node = new RowNode(row, null, level);
            this.rowNodeMap.put(data.getAccountId(), node);
            int size = this.accountLevelArray.size();
            for (int j = 0; j < level + 1 - size; ++j) {
                this.accountLevelArray.add(new ArrayList());
            }
            ArrayList al = (ArrayList)this.accountLevelArray.get(level);
            al.add(node);
        }
        this.tblMain.getTreeColumn().setOrientation(0);
        int levelDepth = this.accountLevelArray.size();
        this.tblMain.getTreeColumn().setDepth(levelDepth);
        for (i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            AccountBalanceInitData data = (AccountBalanceInitData)row.getUserObject();
            level = data.getAccountLevel();
            row.setTreeLevel(level);
        }
        for (i = levelDepth - 1; i > 0; --i) {
            ArrayList al = (ArrayList)this.accountLevelArray.get(i);
            ArrayList al2 = (ArrayList)this.accountLevelArray.get(i - 1);
            for (int j = 0; j < al.size(); ++j) {
                RowNode node = (RowNode)al.get(j);
                IRow row = node.getRow();
                AccountBalanceInitData data = (AccountBalanceInitData)row.getUserObject();
                String longNumber = data.getAccountLongNumber();
                int index = longNumber.lastIndexOf("!");
                if (index < 0) continue;
                String parentLongNumber = longNumber.substring(0, index);
                for (int k = 0; k < al2.size(); ++k) {
                    RowNode node2 = (RowNode)al2.get(k);
                    AccountBalanceInitData data2 = (AccountBalanceInitData)node2.getRow().getUserObject();
                    String longNumber2 = data2.getAccountLongNumber();
                    if (!longNumber2.equals(parentLongNumber)) continue;
                    node.setParent(node2);
                }
            }
        }
    }

    protected void prepareMutexParameter(ActionEvent e, MutexParameter param) {
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
    }

    public void onLoad() throws Exception {
        if (!BooksUtil.isMasterBook(null)) {
            this.isMasterBook = false;
            this.setStatusForBook();
        }
        if (!this.isMasterBook) {
            this.isEditable = this.isCanEditInitDate();
            this.btnSave.setEnabled(this.isEditable);
        }
        if (!this.isEditable) {
            this.setStatusForBook();
        }
        NewOrgUnitFacadeFactory.getRemoteInstance().checkIsOUSealUp(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), OrgType.getEnum((String)OrgType.Company.getName()).getValue());
        super.onLoad();
        this.isQtyByAcct = GlUtils.getQtyAsstParam(null);
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        this.initMyIcon();
        this.initMyData();
        this.initMyElement();
        this.initMyListener();
        Iterator iter = this.allCurrency.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(this.localCur)) continue;
            this.cbCurrency.setSelectedItem((Object)this.localCur);
            break;
        }
        this.currencyChanged();
        this.initTempSave();
        this.tHelper.setCanSetHideColumn(false);
        this.tHelper.setCanSetFrozeColumn(false);
        this.tblMain.setRefresh(true);
        this.tblMain.getViewManager().setFreezeView(-1, 3);
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
    }

    private void initMyIcon() {
        InitClientHelp.setIcon((JButton)this.btnCancelInit, "imgTbtn_finitialize");
        InitClientHelp.setIcon(this.miCancelInit, "imgTbtn_finitialize");
        InitClientHelp.setIcon((JButton)this.btnCloseInit, "imgTbtn_closeinitialize");
        InitClientHelp.setIcon(this.miCloseInit, "imgTbtn_closeinitialize");
        InitClientHelp.setIcon((JButton)this.btnPrint, "imgTbtn_print");
        this.setButtonDefaultStyl(this.btnPrint);
        InitClientHelp.setIcon((JButton)this.btnPrintPreview, "imgTbtn_preview");
        this.setButtonDefaultStyl(this.btnPrintPreview);
        InitClientHelp.setIcon((JButton)this.btnSave, "imgTbtn_save");
        InitClientHelp.setIcon(this.miSave, "imgTbtn_save");
        this.setButtonDefaultStyl(this.btnSave);
        InitClientHelp.setIcon((JButton)this.btnTryBalance, "imgTbtn_trialbalance");
        InitClientHelp.setIcon(this.miTryBalance, "imgTbtn_trialbalance");
        this.miPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.miPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.menuItemHelp.setIcon(EASResource.getIcon((String)"imgTbtn_help"));
        this.actionImportData.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwarddepreciat"));
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke("ctrl P"));
        this.miPrintPreview.setAccelerator(KeyStroke.getKeyStroke("ctrl shift P"));
        this.Import.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.Export.setAccelerator(KeyStroke.getKeyStroke("ctrl shift E"));
        this.Export.setEnabled(true);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private ArrayList getInitData(HashMap otherCtx) throws Exception {
        ArrayList initData = this.getFacade().getInitData(otherCtx);
        return initData;
    }

    protected void initMyData() throws Exception {
        this.curCompany = InitClientHelp.getCurrentCompany();
        this.accouttable = this.curCompany.getAccountTable();
        AccountTableInfo accouttable1 = (AccountTableInfo)this.cbAccountTable.getSelectedItem();
        if (accouttable1 != null) {
            this.accouttable = accouttable1;
            if (this.accouttable == null) {
                throw new GLException(GLException.NO_ACCOUNTTABLE);
            }
            this.otherCtx.put("ACCOUNTTABLEID", this.accouttable.getId().toString());
        }
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.otherCtx.put("COMPANY", this.curCompany);
        this.otherCtx.put("CUID", cuid);
        if (this.accouttable == null) {
            throw new GLException(GLException.NO_ACCOUNTTABLE);
        }
        this.otherCtx.put("ACCOUNTTABLEID", this.accouttable.getId().toString());
        ArrayList datas = this.getInitData(this.otherCtx);
        this.isSettleByLocal = 3 == this.curCompany.getReportConvertMode().getValue();
        this.dealInitData(datas);
    }

    private void dealInitData(ArrayList datas) throws Exception {
        int index = 0;
        isInitClosed = (Boolean)datas.get(index++);
        this.qtyScale = (Integer)datas.get(index++);
        this.otherCtx.put("QTYSCALE", new Integer(this.qtyScale));
        Boolean b = (Boolean)datas.get(index++);
        this.isForeignCurrency = b;
        this.otherCtx.put("ISFOREIGN", b);
        b = (Boolean)datas.get(index++);
        this.isUsingReport = b;
        this.otherCtx.put("ISUSEREPORT", b);
        this.startPeriod = (PeriodInfo)datas.get(index++);
        this.currentPeriod = (PeriodInfo)datas.get(index++);
        this.firstPeriod = (PeriodInfo)datas.get(index++);
        this.otherCtx.put("STARTPERIOD", this.startPeriod);
        this.otherCtx.put("CURRENTPERIOD", this.currentPeriod);
        this.otherCtx.put("FIRSTPERIOD", this.firstPeriod);
        this.allCurrency = (CurrencyCollection)datas.get(index++);
        this.allAccouttable = (AccountTableCollection)datas.get(index++);
        this.isAccoutInitFromAsst = (Boolean)datas.get(index++);
        this.isFirstPeriod = this.startPeriod.getId().toString().equals(this.firstPeriod.getId().toString());
        this.reportCur = this.curCompany.getReportCurrency();
        this.localCur = this.curCompany.getBaseCurrency();
        if (this.isUsingReport && this.isSettleByLocal) {
            if (this.reportCur == null) {
                throw new GLException(GLException.NOREPORTINGCUR);
            }
            if (!this.isForeignCurrency && this.reportCur.getId().toString().equals(this.localCur.getId().toString())) {
                return;
            }
            String rebTable = null;
            if (this.curCompany.getBaseExchangeTable() != null) {
                rebTable = this.curCompany.getBaseExchangeTable().getId().toString();
            }
            if (this.curCompany.getReportExchangeTable() == null) {
                throw new GLException(GLException.NOREPORTINGEXTABLE);
            }
            this.rexLocalToRpt = GlUtils.getLocalToReportingExchangeRate(this.reportCur, this.curCompany.getReportExchangeTable().getId().toString(), this.localCur, rebTable, this.startPeriod.getBeginDate(), this.startPeriod, this.isForeignCurrency, null);
            if (this.rexLocalToRpt == null) {
                throw new GLException(GLException.NOLOCALTORPT);
            }
        }
    }

    private void initMyElement() {
        this.tfPeriod.setText(InitClientHelp.getPeriodTitle(this.startPeriod));
        int size = this.allCurrency.size();
        for (int i = 0; i < size; ++i) {
            CurrencyInfo cur = this.allCurrency.get(i);
            if (cur.isGeneralLocalCurrency()) {
                this.generalLocalCurrency = cur;
                continue;
            }
            if (cur.isGeneralReportCurrency()) {
                this.generalReportCurrency = cur;
                continue;
            }
            this.cbCurrency.addItem((Object)cur);
            if (cur.getId().toString().equals(this.curCompany.getBaseCurrency().getId().toString())) {
                this.localCur = cur;
                this.localAmountScale = cur.getPrecision();
            }
            if (!this.isUsingReport || !cur.getId().toString().equals(this.curCompany.getReportCurrency().getId().toString())) continue;
            this.reportCur = cur;
            this.reportAmountScale = cur.getPrecision();
        }
        this.cbAccountTable.addItems(this.allAccouttable.toArray());
        GlUtils.setSelectedItem(this.cbAccountTable, (CoreBaseInfo)this.accouttable);
        if (!this.isForeignCurrency) {
            if (this.generalLocalCurrency != null) {
                this.cbCurrency.addItem((Object)this.generalLocalCurrency);
            }
            if (this.isUsingReport && this.generalReportCurrency != null) {
                this.cbCurrency.addItem((Object)this.generalReportCurrency);
            }
        }
        this.cbCurrency.setSelectedItem((Object)this.localCur);
        if (isInitClosed) {
            this.btnSave.setEnabled(false);
            this.btnCloseInit.setEnabled(false);
            this.btnCancelInit.setEnabled(true);
            this.miCancelInit.setEnabled(true);
            this.miCloseInit.setEnabled(false);
            this.miSave.setEnabled(false);
            this.importAsstBalance.setEnabled(false);
            this.imImportAccunt.setEnabled(false);
            this.actionImportData.setEnabled(false);
        } else {
            this.btnCancelInit.setEnabled(false);
            this.miCancelInit.setEnabled(false);
            this.miCloseInit.setEnabled(true);
            this.miSave.setEnabled(true);
            this.importAsstBalance.setEnabled(true);
            this.imImportAccunt.setEnabled(true);
            this.actionImportData.setEnabled(true);
        }
        if (!this.isEditable) {
            this.setStatusForBook();
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.enableExportExcel(this.tblMain);
        this.amountFormattedTextField = InitClientHelp.enhanceScaleFormattedTextField(new KDFormattedTextField(1), 0);
        this.amountFormattedTextField.setSupportedEmpty(true);
        this.amountFormattedTextField.setHorizontalAlignment(4);
        this.amountEditor = new KDTDefaultCellEditor((JTextField)this.amountFormattedTextField);
        ((KDTDefaultCellEditor)this.amountEditor).setClickCountToStart(1);
        this.tblMain.getColumn(COLUMN_YEARDEBITFOR).setEditor(this.amountEditor);
        this.tblMain.getColumn(COLUMN_YEARCREDITFOR).setEditor(this.amountEditor);
        this.tblMain.getColumn(COLUMN_MONTHBEGINFOR).setEditor(this.amountEditor);
        this.tblMain.getColumn(COLUMN_YEARPNLFOR).setEditor(this.amountEditor);
        this.tblMain.getColumn(COLUMN_ACCOUNTNAME).setWidth(280);
        if (this.localCur != null) {
            this.localAmountFormattedTextField = InitClientHelp.enhanceScaleFormattedTextField(new KDFormattedTextField(1), 0);
            this.localAmountFormattedTextField.setSupportedEmpty(true);
            this.localAmountFormattedTextField.setHorizontalAlignment(4);
            this.localAmountEditor = new KDTDefaultCellEditor((JTextField)this.localAmountFormattedTextField);
            ((KDTDefaultCellEditor)this.localAmountEditor).setClickCountToStart(1);
            this.tblMain.getColumn(COLUMN_YEARDEBITLOCAL).setEditor(this.localAmountEditor);
            this.tblMain.getColumn(COLUMN_YEARCREDITLOCAL).setEditor(this.localAmountEditor);
            this.tblMain.getColumn(COLUMN_MONTHBEGINLOCAL).setEditor(this.localAmountEditor);
            this.tblMain.getColumn(COLUMN_YEARPNLLOCAL).setEditor(this.localAmountEditor);
        }
        if (this.reportCur != null) {
            this.reportAmountFormattedTextField = InitClientHelp.enhanceScaleFormattedTextField(new KDFormattedTextField(1), 0);
            this.reportAmountFormattedTextField.setSupportedEmpty(true);
            this.reportAmountFormattedTextField.setHorizontalAlignment(4);
            this.reportAmountEditor = new KDTDefaultCellEditor((JTextField)this.reportAmountFormattedTextField);
            ((KDTDefaultCellEditor)this.reportAmountEditor).setClickCountToStart(1);
            this.tblMain.getColumn(COLUMN_YEARDEBITREPORT).setEditor(this.reportAmountEditor);
            this.tblMain.getColumn(COLUMN_YEARCREDITREPORT).setEditor(this.reportAmountEditor);
            this.tblMain.getColumn(COLUMN_MONTHBEGINREPORT).setEditor(this.reportAmountEditor);
            this.tblMain.getColumn(COLUMN_YEARPNLREPORT).setEditor(this.reportAmountEditor);
        }
        InitClientHelp.setFormattedTextFieldScale(this.localAmountFormattedTextField, this.localAmountScale);
        InitClientHelp.setAmountGroupUse(this.tblMain, this.localAmountEditor, this.localAmountScale);
        InitClientHelp.setFormattedTextFieldScale(this.reportAmountFormattedTextField, this.reportAmountScale);
        InitClientHelp.setAmountGroupUse(this.tblMain, this.reportAmountEditor, this.reportAmountScale);
        this.qtyFormattedTextField = InitClientHelp.enhanceScaleFormattedTextField(new KDFormattedTextField(1), 1);
        this.qtyFormattedTextField.setSupportedEmpty(true);
        this.qtyFormattedTextField.setHorizontalAlignment(4);
        this.qtyEditor = new KDTDefaultCellEditor((JTextField)this.qtyFormattedTextField);
        ((KDTDefaultCellEditor)this.qtyEditor).setClickCountToStart(1);
        InitClientHelp.setFormattedTextFieldScale(this.qtyFormattedTextField, this.qtyScale);
        this.tblMain.getColumn(COLUMN_YEARDEBITQTY).setEditor(this.qtyEditor);
        this.tblMain.getColumn(COLUMN_YEARCREDITQTY).setEditor(this.qtyEditor);
        this.tblMain.getColumn(COLUMN_MONTHBEGINQTY).setEditor(this.qtyEditor);
        InitClientHelp.setAmountGroupUse(this.tblMain, this.qtyEditor, this.qtyScale);
        if (this.isForeignCurrency) {
            this.tfExRate.setVisible(false);
            this.lblExRate.setVisible(false);
            this.lblCurLocal.setVisible(false);
            this.GLInit.remove((Component)this.lblPeriod);
            this.GLInit.add((Component)this.lblPeriod, (Object)new KDLayout.Constraints(286, 0, 230, 19, 385));
        }
    }

    protected void initMyListener() {
        this.cbCurrency.addItemListener(this.myItemListener);
        this.cbAccountTable.addItemListener(this.myItemListener);
        this.tblMain.addKDTActiveCellListener((KDTActiveCellListener)this.myTableSelectionListener);
        EditAdapterImpl myEditAdapter = new EditAdapterImpl();
        this.tblMain.addKDTEditListener((KDTEditListener)myEditAdapter);
        InitClientHelp.setTableKeyBoardManager(this.tblMain);
        ActionMap actionMap = this.tblMain.getActionMap();
        actionMap.put("Delete", new DeleteAction());
    }

    private ItemListener createItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() == GLInitUI.this.cbCurrency) {
                    GLInitUI.this.currencyChanged(e);
                } else if (e.getSource() == GLInitUI.this.cbAccountTable) {
                    GLInitUI.this.accountTableChaged(e);
                }
            }
        };
    }

    private void selectChanged(int pre, int cur) {
        IRow curRow = this.tblMain.getRow(cur);
        if (pre > -1) {
            IRow preRow = this.tblMain.getRow(pre);
            this.storeRowData(preRow);
        }
        boolean isqty = false;
        boolean ispl = true;
        if (cur > -1) {
            AsstAccountInfo caa;
            AccountBalanceInitData userObject = (AccountBalanceInitData)curRow.getUserObject();
            if (userObject == null) {
                return;
            }
            boolean bl = isqty = userObject.getAccountIsQty() == 1;
            if (this.isQtyByAcct && isqty && (caa = this.getCAA(userObject.getAccountId())) != null) {
                isqty = caa.isIsQty();
            }
            ispl = userObject.isAccountIsPLType();
            this.showAllColumn();
            this.updateColumnProtectForAccount(isqty, ispl);
            if (this.isAccoutInitFromAsst && userObject.getAccount() != null) {
                for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                    curRow.getCell(i).getStyleAttributes().setLocked(true);
                    curRow.getCell(i).getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ASS);
                }
            }
            if (userObject.getAccountIsLeaf() != 1 || userObject.isAccountIsFreese() || isInitClosed) {
                curRow.getStyleAttributes().setLocked(true);
                curRow.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
                for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                    curRow.getCell(i).getStyleAttributes().setLocked(true);
                }
            }
        }
        this.updateColumnProtectGlobal();
    }

    private AsstAccountInfo getCAA(String accountId) {
        if (this.caas.containsKey(accountId)) {
            return this.caas.get(accountId);
        }
        AsstAccountInfo caa = null;
        try {
            caa = GLAsstAccountUtils.getCAA(null, accountId, this.startPeriod.getId().toString(), null);
            this.caas.put(accountId, caa);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return caa;
    }

    private void accountTableChaged(ItemEvent e) {
        AccountTableInfo accouttable1;
        this.accouttable = accouttable1 = (AccountTableInfo)this.cbAccountTable.getSelectedItem();
        this.otherCtx.put("ACCOUNTTABLEID", this.accouttable.getId().toString());
        this.currencyChanged();
        if (!this.accouttable.getId().toString().equals(this.curCompany.getAccountTable().getId().toString())) {
            this.closeInitAction.setEnabled(false);
            this.btnCloseInit.setEnabled(false);
            this.cancelInitAction.setEnabled(false);
            this.btnCancelInit.setEnabled(false);
            this.tblMain.setEditable(false);
        } else if (isInitClosed) {
            this.closeInitAction.setEnabled(false);
            this.cancelInitAction.setEnabled(true);
        } else {
            this.closeInitAction.setEnabled(true);
            this.cancelInitAction.setEnabled(false);
            this.tblMain.setEditable(true);
        }
    }

    private void currencyChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            this.oldItem = e.getItem();
            return;
        }
        if (this.curCur.isGeneralLocalCurrency() || this.curCur.isGeneralReportCurrency()) {
            this.currencyChanged();
            return;
        }
        if (!this.reenter && this.tblMain.getSelectManager().size() > 0) {
            int index = this.tblMain.getSelectManager().get().getTop();
            this.storeRowData(this.tblMain.getRow(index));
        }
        if (this.dirty) {
            if (this.reenter) {
                this.reenter = false;
                return;
            }
            int choice = InitClientHelp.showModifyConfirm((Component)((Object)this));
            if (MsgBox.isYes((int)choice)) {
                if (!this.save()) {
                    this.reenter = true;
                    ((KDComboBox)e.getSource()).setSelectedItem(this.oldItem);
                    return;
                }
            } else if (MsgBox.isCancel((int)choice)) {
                this.reenter = true;
                this.cbCurrency.setSelectedItem(this.oldItem);
                return;
            }
        }
        this.currencyChanged();
    }

    private void setBusyState() {
        this.cbCurrency.setEnabled(false);
        this.tblMain.setEnabled(false);
        this.setCursorOfWair();
    }

    private void setFreeState() {
        this.cbCurrency.setEnabled(true);
        this.tblMain.setEnabled(true);
        this.setCursorOfDefault();
    }

    private void currencyChanged() {
        this.setBusyState();
        this.laterThread.run();
        this.setFreeState();
        if (this.curCur.isGeneralLocalCurrency() || this.curCur.isGeneralReportCurrency() || isInitClosed) {
            this.importAsstBalance.setEnabled(false);
        } else {
            this.importAsstBalance.setEnabled(true);
        }
    }

    private BigDecimal getScaleBigDecimal(BigDecimal obj, int type) {
        if (obj != null) {
            switch (type) {
                case 0: {
                    obj = obj.setScale(this.amountScale, 4);
                    break;
                }
                case 1: {
                    obj = obj.setScale(this.localAmountScale, 4);
                    break;
                }
                case 2: {
                    obj = obj.setScale(this.reportAmountScale, 4);
                }
            }
        }
        return obj;
    }

    private BigDecimal getScaleBigDecimal(Object obj, int type) {
        BigDecimal ret = InitClientHelp.toBigDecimal(obj);
        return this.getScaleBigDecimal(ret, type);
    }

    private BigDecimal getQtyScaleBigDecimal(BigDecimal obj) {
        if (obj != null) {
            obj = obj.setScale(this.qtyScale, 4);
            obj = new BigDecimal(InitClientHelp.getBigDecimalTrim0(obj));
        }
        return obj;
    }

    private BigDecimal getQtyScaleBigDecimal(Object obj) {
        BigDecimal ret = InitClientHelp.toBigDecimal(obj);
        return this.getQtyScaleBigDecimal(ret);
    }

    private BigDecimal getScaleBigDecimalNvl(Object obj, int type) {
        BigDecimal ret = this.getScaleBigDecimal(obj, type);
        return InitClientHelp.nvl(ret, InitClientHelp.zero);
    }

    private BigDecimal getQtyScaleBigDecimalNvl(Object obj) {
        BigDecimal ret = this.getQtyScaleBigDecimal(obj);
        return InitClientHelp.nvl(ret, InitClientHelp.zero);
    }

    private void storeRowData(IRow row) {
        if (row == null) {
            return;
        }
        AccountBalanceInitData userObject = (AccountBalanceInitData)row.getUserObject();
        if (userObject == null || userObject.getStatus() == 0 || userObject.getStatus() == 2) {
            return;
        }
        BigDecimal mbf = this.getScaleBigDecimalNvl(row.getCell(COLUMN_MONTHBEGINFOR).getValue(), 0);
        BigDecimal ydf = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARDEBITFOR).getValue(), 0);
        BigDecimal ycf = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARCREDITFOR).getValue(), 0);
        BigDecimal yplf = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARPNLFOR).getValue(), 0);
        BigDecimal mbl = this.getScaleBigDecimalNvl(row.getCell(COLUMN_MONTHBEGINLOCAL).getValue(), 1);
        BigDecimal ydl = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARDEBITLOCAL).getValue(), 1);
        BigDecimal ycl = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARCREDITLOCAL).getValue(), 1);
        BigDecimal ypll = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARPNLLOCAL).getValue(), 1);
        BigDecimal mbr = this.getScaleBigDecimalNvl(row.getCell(COLUMN_MONTHBEGINREPORT).getValue(), 2);
        BigDecimal ydr = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARDEBITREPORT).getValue(), 2);
        BigDecimal ycr = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARCREDITREPORT).getValue(), 2);
        BigDecimal yplr = this.getScaleBigDecimalNvl(row.getCell(COLUMN_YEARPNLREPORT).getValue(), 2);
        BigDecimal mbq = this.getQtyScaleBigDecimalNvl(row.getCell(COLUMN_MONTHBEGINQTY).getValue());
        BigDecimal ydq = this.getQtyScaleBigDecimalNvl(row.getCell(COLUMN_YEARDEBITQTY).getValue());
        BigDecimal ycq = this.getQtyScaleBigDecimalNvl(row.getCell(COLUMN_YEARCREDITQTY).getValue());
        userObject.setBeginBalanceFor(mbf);
        userObject.setYearDebitFor(ydf);
        userObject.setYearCreditFor(ycf);
        userObject.setYearPnLFor(yplf);
        userObject.setBeginBalanceLocal(mbl);
        userObject.setYearDebitLocal(ydl);
        userObject.setYearCreditLocal(ycl);
        userObject.setYearPnLLocal(ypll);
        userObject.setBeginBalanceReport(mbr);
        userObject.setYearDebitReport(ydr);
        userObject.setYearCreditReport(ycr);
        userObject.setYearPnLReport(yplr);
        userObject.setBeginQty(mbq);
        userObject.setYearDebitQty(ydq);
        userObject.setYearCreditQty(ycq);
        this.dirty = true;
    }

    private void lockAllColumn() {
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    private void updateColumnProtectGlobal() {
        if (!this.isUsingReport) {
            this.tblMain.getColumn(COLUMN_YEARCREDITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_MONTHBEGINREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLREPORT).getStyleAttributes().setHided(true);
        }
        if (this.isFirstPeriod) {
            this.tblMain.getColumn(COLUMN_YEARCREDITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITQTY).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITQTY).getStyleAttributes().setHided(true);
        }
        if (this.isForeignCurrency) {
            this.tblMain.getColumn(COLUMN_YEARCREDITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_MONTHBEGINREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_MONTHBEGINLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLLOCAL).getStyleAttributes().setHided(true);
        }
        if (isInitClosed) {
            this.lockAllColumn();
            this.tblMain.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        }
    }

    private void updateColumnProtectForCurrency() {
        boolean isReportCurrencySettlement = ReportCurrencyConvertMode.Base.equals((Object)this.curCompany.getReportConvertMode());
        if (this.isLocal && !isReportCurrencySettlement) {
            this.tblMain.getColumn(COLUMN_MONTHBEGINLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_MONTHBEGINLOCAL).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITLOCAL).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITLOCAL).getStyleAttributes().setLocked(true);
            this.tblMain.getColumn(COLUMN_YEARPNLLOCAL).getStyleAttributes().setLocked(true);
        }
        if (this.isReport && !this.isLocal && !isReportCurrencySettlement) {
            this.tblMain.getColumn(COLUMN_MONTHBEGINREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLREPORT).getStyleAttributes().setHided(true);
        } else if (this.curCur.isGeneralLocalCurrency()) {
            this.tblMain.getColumn(COLUMN_MONTHBEGINFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_MONTHBEGINREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITREPORT).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLREPORT).getStyleAttributes().setHided(true);
            this.lockAllColumn();
        } else if (this.curCur.isGeneralReportCurrency()) {
            this.tblMain.getColumn(COLUMN_MONTHBEGINLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_MONTHBEGINFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLFOR).getStyleAttributes().setHided(true);
            this.lockAllColumn();
        }
        this.updateColumnProtectGlobal();
    }

    private void updateColumnProtectForAccount(boolean isqty, boolean ispl) {
        if (!isqty) {
            this.tblMain.getColumn(COLUMN_MONTHBEGINQTY).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARDEBITQTY).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARCREDITQTY).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_MEASUREUNIT).getStyleAttributes().setHided(true);
        }
        if (!ispl) {
            this.tblMain.getColumn(COLUMN_YEARPNLFOR).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLLOCAL).getStyleAttributes().setHided(true);
            this.tblMain.getColumn(COLUMN_YEARPNLREPORT).getStyleAttributes().setHided(true);
        }
        this.updateColumnProtectForCurrency();
    }

    private void showAllColumn() {
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setHided(false);
            if (!this.isEditable) continue;
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(false);
        }
        this.tblMain.getColumn(COLUMN_ACCOUNTNUMBER).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COLUMN_ACCOUNTNAME).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COLUMN_ACCOUNTDC).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COLUMN_MEASUREUNIT).getStyleAttributes().setLocked(true);
    }

    private IGLInitFacade getFacade() throws Exception {
        return GLInitFacadeFactory.getRemoteInstance();
    }

    public void loadData() throws Exception {
        if (this.curCur == null) {
            return;
        }
        this.dirty = false;
        new Thread(){

            @Override
            public void run() {
                try {
                    AccountBalanceInitData[] datas = GLInitUI.this.curCur.isGeneralLocalCurrency() ? GLInitUI.this.getGeneralLocalData() : (GLInitUI.this.curCur.isGeneralReportCurrency() ? GLInitUI.this.getGeneralReportData() : GLInitUI.this.getAccountBalanceData());
                    GLInitUI.this.refreshDatas(datas, false, 1, false);
                }
                catch (Exception e) {
                    GLInitUI.this.handUIException(e);
                    GLInitUI.this.setFreeState();
                }
            }
        }.run();
    }

    public void refreshRow(IRow row, AccountBalanceInitData data) {
        row.setUserObject((Object)data);
        row.getCell(COLUMN_ACCOUNTDC).setValue((Object)(data.getAccountDC() == 1 ? InitClientHelp.getTitleDebit() : InitClientHelp.getTitleCredit()));
        row.getCell(COLUMN_ACCOUNTNAME).setValue((Object)data.getAccountName());
        row.getCell(COLUMN_ACCOUNTNUMBER).setValue((Object)data.getAccountNumber());
        row.getCell(COLUMN_MEASUREUNIT).setValue((Object)data.getAccountMeasureUnitName());
        if (data.getStatus() == 2 || data.getStatus() == 1) {
            row.getCell(COLUMN_MONTHBEGINFOR).setValue((Object)this.getScaleBigDecimal(data.getBeginBalanceFor(), 0));
            row.getCell(COLUMN_YEARCREDITFOR).setValue((Object)this.getScaleBigDecimal(data.getYearCreditFor(), 0));
            row.getCell(COLUMN_YEARDEBITFOR).setValue((Object)this.getScaleBigDecimal(data.getYearDebitFor(), 0));
            row.getCell(COLUMN_YEARPNLFOR).setValue((Object)this.getScaleBigDecimal(data.getYearPnLFor(), 0));
            row.getCell(COLUMN_MONTHBEGINLOCAL).setValue((Object)this.getScaleBigDecimal(data.getBeginBalanceLocal(), 1));
            row.getCell(COLUMN_YEARCREDITLOCAL).setValue((Object)this.getScaleBigDecimal(data.getYearCreditLocal(), 1));
            row.getCell(COLUMN_YEARDEBITLOCAL).setValue((Object)this.getScaleBigDecimal(data.getYearDebitLocal(), 1));
            row.getCell(COLUMN_YEARPNLLOCAL).setValue((Object)this.getScaleBigDecimal(data.getYearPnLLocal(), 1));
            row.getCell(COLUMN_MONTHBEGINREPORT).setValue((Object)this.getScaleBigDecimal(data.getBeginBalanceReport(), 2));
            row.getCell(COLUMN_YEARCREDITREPORT).setValue((Object)this.getScaleBigDecimal(data.getYearCreditReport(), 2));
            row.getCell(COLUMN_YEARDEBITREPORT).setValue((Object)this.getScaleBigDecimal(data.getYearDebitReport(), 2));
            row.getCell(COLUMN_YEARPNLREPORT).setValue((Object)this.getScaleBigDecimal(data.getYearPnLReport(), 2));
            if (data.getAccountIsQty() == 1) {
                row.getCell(COLUMN_MONTHBEGINQTY).setValue((Object)this.getQtyScaleBigDecimal(data.getBeginQty()));
                row.getCell(COLUMN_YEARCREDITQTY).setValue((Object)this.getQtyScaleBigDecimal(data.getYearCreditQty()));
                row.getCell(COLUMN_YEARDEBITQTY).setValue((Object)this.getQtyScaleBigDecimal(data.getYearDebitQty()));
            }
        }
        if (this.isAccoutInitFromAsst && data.getAccount() != null) {
            row.getStyleAttributes().setLocked(true);
            row.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ASS);
        }
        if (data.getAccountIsLeaf() != 1 || data.isAccountIsFreese()) {
            row.getStyleAttributes().setLocked(true);
            row.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
        }
    }

    private void subtractParentRecursively(Map<String, Integer> accountId2indexMap, AccountBalanceInitData userObject, AccountBalanceInitData data) {
        String currentId = userObject.getAccountParentId();
        AccountBalanceInitData currentUserObject = null;
        while (!StringUtils.isEmpty((String)currentId) && accountId2indexMap.get(currentId) != null) {
            IRow currentRow = this.tblMain.getRow(accountId2indexMap.get(currentId).intValue());
            currentUserObject = (AccountBalanceInitData)currentRow.getUserObject();
            currentUserObject.setStatus(1);
            this.subtract(currentUserObject, data);
            this.refreshRow(currentRow, currentUserObject);
            currentId = currentUserObject.getAccountParentId();
        }
    }

    private void addRecursively(Map<String, Integer> accountId2indexMap, AccountBalanceInitData userObject, AccountBalanceInitData data) {
        String currentId = userObject.getAccountId();
        AccountBalanceInitData currentUserObject = null;
        while (!StringUtils.isEmpty((String)currentId) && accountId2indexMap.get(currentId) != null) {
            IRow currentRow = this.tblMain.getRow(accountId2indexMap.get(currentId).intValue());
            currentUserObject = (AccountBalanceInitData)currentRow.getUserObject();
            currentUserObject.setStatus(1);
            this.add(currentUserObject, data);
            this.refreshRow(currentRow, currentUserObject);
            currentId = currentUserObject.getAccountParentId();
        }
    }

    public AccountBalanceInitData subtract(AccountBalanceInitData userObject, AccountBalanceInitData data) {
        return this.updateBalanceRow(userObject, data, false);
    }

    public AccountBalanceInitData add(AccountBalanceInitData userObject, AccountBalanceInitData data) {
        return this.updateBalanceRow(userObject, data, true);
    }

    public AccountBalanceInitData add(AccountBalanceInitData userObject, AccountBalanceInitData data, int selectVal) {
        boolean isSameDC;
        BigDecimal increment = userObject.getBeginBalanceFor();
        BigDecimal increment2 = userObject.getYearCreditFor();
        BigDecimal increment3 = userObject.getYearDebitFor();
        BigDecimal increment4 = userObject.getYearCreditQty();
        BigDecimal increment5 = userObject.getYearDebitQty();
        BigDecimal increment6 = userObject.getBeginQty();
        BigDecimal increment7 = userObject.getBeginBalanceLocal();
        BigDecimal increment8 = userObject.getBeginBalanceReport();
        BigDecimal increment10 = userObject.getYearPnLFor();
        BigDecimal increment11 = userObject.getYearCreditLocal();
        BigDecimal increment12 = userObject.getYearDebitLocal();
        BigDecimal increment13 = userObject.getYearPnLLocal();
        BigDecimal increment14 = userObject.getYearCreditReport();
        BigDecimal increment15 = userObject.getYearDebitReport();
        BigDecimal increment16 = userObject.getYearPnLReport();
        if (selectVal == 1) {
            if (data.getBeginBalanceFor() != null && !data.getBeginBalanceFor().equals(this.zero)) {
                increment = this.zero;
                increment7 = this.zero;
                increment8 = this.zero;
            }
            if (data.getYearCreditFor() != null && !data.getYearCreditFor().equals(this.zero)) {
                increment2 = this.zero;
                increment3 = this.zero;
                increment11 = this.zero;
                increment12 = this.zero;
                increment14 = this.zero;
                increment15 = this.zero;
            }
            if (data.getYearPnLFor() != null && !data.getYearPnLFor().equals(this.zero)) {
                increment10 = this.zero;
                increment13 = this.zero;
                increment16 = this.zero;
            }
        }
        boolean bl = isSameDC = userObject.getAccountDC() == data.getAccountDC();
        if (isSameDC) {
            userObject.setBeginBalanceFor(this.add(increment, data.getBeginBalanceFor()));
            userObject.setYearCreditFor(this.add(increment2, data.getYearCreditFor()));
            userObject.setYearDebitFor(this.add(increment3, data.getYearDebitFor()));
            if (userObject.getAccountIsQty() == 1) {
                if (data.getBeginQty() != null && !data.getBeginQty().equals(this.zero)) {
                    increment4 = this.zero;
                }
                if (data.getYearCreditQty() != null && !data.getYearCreditQty().equals(this.zero)) {
                    increment5 = this.zero;
                    increment6 = this.zero;
                }
                userObject.setYearCreditQty(this.add(increment4, data.getYearCreditQty()));
                userObject.setYearDebitQty(this.add(increment5, data.getYearDebitQty()));
                userObject.setBeginQty(this.add(increment6, data.getBeginQty()));
            }
            userObject.setBeginBalanceLocal(this.add(increment7, data.getBeginBalanceLocal()));
            userObject.setBeginBalanceReport(this.add(increment8, data.getBeginBalanceReport()));
            userObject.setYearPnLFor(this.add(increment10, data.getYearPnLFor()));
            userObject.setYearCreditLocal(this.add(increment11, data.getYearCreditLocal()));
            userObject.setYearDebitLocal(this.add(increment12, data.getYearDebitLocal()));
            userObject.setYearPnLLocal(this.add(increment13, data.getYearPnLLocal()));
            userObject.setYearCreditReport(this.add(increment14, data.getYearCreditReport()));
            userObject.setYearDebitReport(this.add(increment15, data.getYearDebitReport()));
            userObject.setYearPnLReport(this.add(increment16, data.getYearPnLReport()));
        } else {
            userObject.setBeginBalanceFor(this.add(increment, data.getBeginBalanceFor().negate()));
            userObject.setYearCreditFor(this.add(increment2, data.getYearCreditFor().negate()));
            userObject.setYearDebitFor(this.add(increment3, data.getYearDebitFor().negate()));
            if (userObject.getAccountIsQty() == 1) {
                if (data.getBeginQty() != null && !data.getBeginQty().equals(this.zero)) {
                    increment4 = this.zero;
                }
                if (data.getYearCreditQty() != null && !data.getYearCreditQty().equals(this.zero)) {
                    increment5 = this.zero;
                    increment6 = this.zero;
                }
                userObject.setYearCreditQty(this.add(increment4, data.getYearCreditQty().negate()));
                userObject.setYearDebitQty(this.add(increment5, data.getYearDebitQty().negate()));
                userObject.setBeginQty(this.add(increment6, data.getBeginQty().negate()));
            }
            userObject.setBeginBalanceLocal(this.add(increment7, data.getBeginBalanceLocal().negate()));
            userObject.setBeginBalanceReport(this.add(increment8, data.getBeginBalanceReport().negate()));
            userObject.setYearPnLFor(this.add(increment10, data.getYearPnLFor().negate()));
            userObject.setYearCreditLocal(this.add(increment11, data.getYearCreditLocal().negate()));
            userObject.setYearDebitLocal(this.add(increment12, data.getYearDebitLocal().negate()));
            userObject.setYearPnLLocal(this.add(increment13, data.getYearPnLLocal().negate()));
            userObject.setYearCreditReport(this.add(increment14, data.getYearCreditReport().negate()));
            userObject.setYearDebitReport(this.add(increment15, data.getYearDebitReport().negate()));
            userObject.setYearPnLReport(this.add(increment16, data.getYearPnLReport().negate()));
        }
        return userObject;
    }

    public AccountBalanceInitData updateBalanceRow(AccountBalanceInitData userObject, AccountBalanceInitData data, boolean isAdd) {
        boolean isSameDC = userObject.getAccountDC() == data.getAccountDC();
        boolean needAdd = isSameDC == isAdd;
        userObject.setBeginBalanceFor(this.addOrSubtract(userObject.getBeginBalanceFor(), data.getBeginBalanceFor(), needAdd));
        userObject.setBeginBalanceLocal(this.addOrSubtract(userObject.getBeginBalanceLocal(), data.getBeginBalanceLocal(), needAdd));
        userObject.setBeginBalanceReport(this.addOrSubtract(userObject.getBeginBalanceReport(), data.getBeginBalanceReport(), needAdd));
        userObject.setEndBalanceFor(this.addOrSubtract(userObject.getEndBalanceFor(), data.getEndBalanceFor(), needAdd));
        userObject.setEndBalanceLocal(this.addOrSubtract(userObject.getEndBalanceLocal(), data.getEndBalanceLocal(), needAdd));
        userObject.setEndBalanceReport(this.addOrSubtract(userObject.getEndBalanceReport(), data.getEndBalanceReport(), needAdd));
        userObject.setYearCreditFor(this.addOrSubtract(userObject.getYearCreditFor(), data.getYearCreditFor(), isAdd));
        userObject.setYearCreditLocal(this.addOrSubtract(userObject.getYearCreditLocal(), data.getYearCreditLocal(), isAdd));
        userObject.setYearCreditReport(this.addOrSubtract(userObject.getYearCreditReport(), data.getYearCreditReport(), isAdd));
        userObject.setYearDebitFor(this.addOrSubtract(userObject.getYearDebitFor(), data.getYearDebitFor(), isAdd));
        userObject.setYearDebitLocal(this.addOrSubtract(userObject.getYearDebitLocal(), data.getYearDebitLocal(), isAdd));
        userObject.setYearDebitReport(this.addOrSubtract(userObject.getYearDebitReport(), data.getYearDebitReport(), isAdd));
        userObject.setCreditFor(this.addOrSubtract(userObject.getCreditFor(), data.getCreditFor(), isAdd));
        userObject.setCreditLocal(this.addOrSubtract(userObject.getCreditLocal(), data.getCreditLocal(), isAdd));
        userObject.setCreditReport(this.addOrSubtract(userObject.getCreditReport(), data.getCreditReport(), isAdd));
        userObject.setDebitFor(this.addOrSubtract(userObject.getDebitFor(), data.getDebitFor(), isAdd));
        userObject.setDebitLocal(this.addOrSubtract(userObject.getDebitLocal(), data.getDebitLocal(), isAdd));
        userObject.setDebitReport(this.addOrSubtract(userObject.getDebitReport(), data.getDebitReport(), isAdd));
        userObject.setYearPnLFor(this.addOrSubtract(userObject.getYearPnLFor(), data.getYearPnLFor(), needAdd));
        userObject.setYearPnLLocal(this.addOrSubtract(userObject.getYearPnLLocal(), data.getYearPnLLocal(), needAdd));
        userObject.setYearPnLReport(this.addOrSubtract(userObject.getYearPnLReport(), data.getYearPnLReport(), needAdd));
        userObject.setMonthPnLFor(this.addOrSubtract(userObject.getMonthPnLFor(), data.getMonthPnLFor(), needAdd));
        userObject.setMonthPnLLocal(this.addOrSubtract(userObject.getMonthPnLLocal(), data.getMonthPnLLocal(), needAdd));
        userObject.setMonthPnLReport(this.addOrSubtract(userObject.getMonthPnLReport(), data.getMonthPnLReport(), needAdd));
        if (userObject.getAccountIsQty() == 1) {
            userObject.setBeginQty(this.addOrSubtract(userObject.getBeginQty(), data.getBeginQty(), needAdd));
            userObject.setEndQty(this.addOrSubtract(userObject.getEndQty(), data.getEndQty(), needAdd));
            userObject.setCreditQty(this.addOrSubtract(userObject.getCreditQty(), data.getCreditQty(), isAdd));
            userObject.setDebitQty(this.addOrSubtract(userObject.getDebitQty(), data.getDebitQty(), isAdd));
            userObject.setYearCreditQty(this.addOrSubtract(userObject.getYearCreditQty(), data.getYearCreditQty(), isAdd));
            userObject.setYearDebitQty(this.addOrSubtract(userObject.getYearDebitQty(), data.getYearDebitQty(), isAdd));
        } else {
            userObject.setBeginQty(this.zero);
            userObject.setEndQty(this.zero);
            userObject.setCreditQty(this.zero);
            userObject.setDebitQty(this.zero);
            userObject.setYearCreditQty(this.zero);
            userObject.setYearDebitQty(this.zero);
        }
        return userObject;
    }

    public AccountBalanceInitData clearBalanceRow(AccountBalanceInitData userObject) {
        userObject.setBeginBalanceFor(this.zero);
        userObject.setBeginBalanceLocal(this.zero);
        userObject.setBeginBalanceReport(this.zero);
        userObject.setEndBalanceFor(this.zero);
        userObject.setEndBalanceLocal(this.zero);
        userObject.setEndBalanceReport(this.zero);
        userObject.setYearCreditFor(this.zero);
        userObject.setYearCreditLocal(this.zero);
        userObject.setYearCreditReport(this.zero);
        userObject.setYearCreditQty(this.zero);
        userObject.setYearDebitFor(this.zero);
        userObject.setYearDebitLocal(this.zero);
        userObject.setYearDebitReport(this.zero);
        userObject.setYearDebitQty(this.zero);
        userObject.setCreditFor(this.zero);
        userObject.setCreditLocal(this.zero);
        userObject.setCreditReport(this.zero);
        userObject.setCreditQty(this.zero);
        userObject.setDebitFor(this.zero);
        userObject.setDebitLocal(this.zero);
        userObject.setDebitReport(this.zero);
        userObject.setDebitQty(this.zero);
        userObject.setYearPnLFor(this.zero);
        userObject.setYearPnLLocal(this.zero);
        userObject.setYearPnLReport(this.zero);
        userObject.setMonthPnLFor(this.zero);
        userObject.setMonthPnLLocal(this.zero);
        userObject.setMonthPnLReport(this.zero);
        userObject.setBeginQty(this.zero);
        userObject.setEndQty(this.zero);
        userObject.setCreditQty(this.zero);
        userObject.setDebitQty(this.zero);
        userObject.setYearCreditQty(this.zero);
        userObject.setYearDebitQty(this.zero);
        return userObject;
    }

    public boolean hasBalance(AccountBalanceInitData userObject) {
        return userObject.getBeginBalanceFor() != null && userObject.getBeginBalanceFor().signum() != 0 || userObject.getBeginBalanceLocal() != null && userObject.getBeginBalanceLocal().signum() != 0 || userObject.getBeginBalanceReport() != null && userObject.getBeginBalanceReport().signum() != 0 || userObject.getBeginQty() != null && userObject.getBeginQty().signum() != 0 || userObject.getEndBalanceFor() != null && userObject.getEndBalanceFor().signum() != 0 || userObject.getEndBalanceLocal() != null && userObject.getEndBalanceLocal().signum() != 0 || userObject.getEndBalanceReport() != null && userObject.getEndBalanceReport().signum() != 0 || userObject.getEndQty() != null && userObject.getEndQty().signum() != 0 || userObject.getCreditFor() != null && userObject.getCreditFor().signum() != 0 || userObject.getCreditLocal() != null && userObject.getCreditLocal().signum() != 0 || userObject.getCreditReport() != null && userObject.getCreditReport().signum() != 0 || userObject.getCreditQty() != null && userObject.getCreditQty().signum() != 0 || userObject.getDebitFor() != null && userObject.getDebitFor().signum() != 0 || userObject.getDebitLocal() != null && userObject.getDebitLocal().signum() != 0 || userObject.getDebitReport() != null && userObject.getDebitReport().signum() != 0 || userObject.getDebitQty() != null && userObject.getDebitQty().signum() != 0 || userObject.getYearCreditFor() != null && userObject.getYearCreditFor().signum() != 0 || userObject.getYearCreditLocal() != null && userObject.getYearCreditLocal().signum() != 0 || userObject.getYearCreditReport() != null && userObject.getYearCreditReport().signum() != 0 || userObject.getYearCreditQty() != null && userObject.getYearCreditQty().signum() != 0 || userObject.getYearDebitFor() != null && userObject.getYearDebitFor().signum() != 0 || userObject.getYearDebitLocal() != null && userObject.getYearDebitLocal().signum() != 0 || userObject.getYearDebitReport() != null && userObject.getYearDebitReport().signum() != 0 || userObject.getYearDebitQty() != null && userObject.getYearDebitQty().signum() != 0 || userObject.getYearPnLFor() != null && userObject.getYearPnLFor().signum() != 0 || userObject.getYearPnLLocal() != null && userObject.getYearPnLLocal().signum() != 0 || userObject.getYearPnLReport() != null && userObject.getYearPnLReport().signum() != 0 || userObject.getMonthPnLFor() != null && userObject.getMonthPnLFor().signum() != 0 || userObject.getMonthPnLLocal() != null && userObject.getMonthPnLLocal().signum() != 0 || userObject.getMonthPnLReport() != null && userObject.getMonthPnLReport().signum() != 0;
    }

    public BigDecimal add(BigDecimal increment, BigDecimal increment1) {
        if (increment == null) {
            if (increment1 != null) {
                return increment1;
            }
            return GlUtils.zero;
        }
        if (increment1 == null) {
            return increment;
        }
        return increment1.add(increment);
    }

    private BigDecimal addOrSubtract(BigDecimal numberA, BigDecimal numberB, boolean isAdd) {
        return isAdd ? this.add(numberA, numberB) : this.subtract(numberA, numberB);
    }

    public BigDecimal subtract(BigDecimal numberA, BigDecimal numberB) {
        if (numberA == null || numberA.signum() == 0) {
            if (numberB == null || numberB.signum() == 0) {
                return GlUtils.zero;
            }
            return numberB.negate();
        }
        if (numberB == null || numberB.signum() == 0) {
            return numberA;
        }
        return numberA.subtract(numberB);
    }

    public void refreshDatas(final AccountBalanceInitData[] datas, final boolean isDirty, final int selectVal, final boolean isimported) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int count = GLInitUI.this.tblMain.getRowCount();
                if (isimported) {
                    AccountBalanceInitData userObject;
                    IRow row;
                    int i;
                    block0: for (int i2 = 0; i2 < GLInitUI.this.tableDatas.length; ++i2) {
                        for (int j = 0; j < datas.length; ++j) {
                            if (!GLInitUI.this.tableDatas[i2].getAccountId().equals(datas[j].getAccountId())) continue;
                            ((GLInitUI)GLInitUI.this).tableDatas[i2] = datas[j];
                            continue block0;
                        }
                    }
                    HashMap<String, AccountBalanceInitData> accountMap = new HashMap<String, AccountBalanceInitData>();
                    HashMap<String, Integer> accountIDMap = new HashMap<String, Integer>();
                    for (i = 0; i < datas.length; ++i) {
                        AccountBalanceInitData data = datas[i];
                        String accountNumber = data.getAccountNumber();
                        accountMap.put(accountNumber, data);
                    }
                    for (i = 0; i < count; ++i) {
                        row = GLInitUI.this.tblMain.getRow(i);
                        if (row == null) continue;
                        userObject = (AccountBalanceInitData)row.getUserObject();
                        accountIDMap.put(userObject.getAccountId(), i);
                    }
                    for (i = 0; i < count; ++i) {
                        AccountBalanceInitData old;
                        row = GLInitUI.this.tblMain.getRow(i);
                        if (row == null) continue;
                        userObject = (AccountBalanceInitData)row.getUserObject();
                        String accountNumber = userObject.getAccountNumber();
                        if (accountMap.containsKey(accountNumber)) {
                            AccountBalanceInitData data = (AccountBalanceInitData)accountMap.get(accountNumber);
                            if (selectVal == 1) {
                                if (!GLInitUI.this.hasBalance(userObject)) {
                                    GLInitUI.this.addRecursively(accountIDMap, userObject, data);
                                }
                            } else if (userObject.getAccountIsLeaf() == 1) {
                                AccountBalanceInitData old2 = (AccountBalanceInitData)userObject.clone();
                                userObject.setStatus(1);
                                GLInitUI.this.refreshRow(row, GLInitUI.this.clearBalanceRow(userObject));
                                if (GLInitUI.this.hasBalance(old2)) {
                                    GLInitUI.this.subtractParentRecursively(accountIDMap, userObject, old2);
                                }
                                GLInitUI.this.addRecursively(accountIDMap, userObject, data);
                            }
                        } else if (selectVal == 0 && userObject.getAccount() != null && userObject.getAccountIsLeaf() == 1 && userObject.getAccount().getCAA() != null && GLInitUI.this.hasBalance(old = (AccountBalanceInitData)userObject.clone())) {
                            userObject.setStatus(1);
                            GLInitUI.this.refreshRow(row, GLInitUI.this.clearBalanceRow(userObject));
                            GLInitUI.this.subtractParentRecursively(accountIDMap, userObject, old);
                        }
                        row.setUserObject((Object)userObject);
                    }
                } else {
                    GLInitUI.this.tblMain.removeRows();
                    GLInitUI.access$3502(GLInitUI.this, new AccountBalanceInitData[datas.length]);
                    for (int i = 0; i < datas.length; ++i) {
                        AccountBalanceInitData data;
                        ((GLInitUI)GLInitUI.this).tableDatas[i] = data = datas[i];
                        data.setCurrencyId(((CurrencyInfo)GLInitUI.this.cbCurrency.getSelectedItem()).getId().toString());
                        IRow row = GLInitUI.this.tblMain.addRow();
                        GLInitUI.this.refreshRow(row, data);
                        row.setUserObject((Object)data);
                    }
                    GLInitUI.this.makeRowTree();
                }
                if (datas.length > 0) {
                    GLInitUI.this.tblMain.getSelectManager().select(0, -1);
                }
                GLInitUI.this.dirty = isDirty;
                GLInitUI.this.tblMain.repaint();
                GLInitUI.this.setFreeState();
                GLInitUI.this.setNonLeafColor();
            }
        });
    }

    private void setNonLeafColor() {
        if (isInitClosed || this.curCur == null || this.curCur.isGeneralLocalCurrency() || this.curCur.isGeneralReportCurrency()) {
            return;
        }
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            AccountBalanceInitData data = (AccountBalanceInitData)row.getUserObject();
            if (this.isAccoutInitFromAsst && data.getAccount() != null) {
                row.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ASS);
                row.getStyleAttributes().setLocked(true);
            }
            if (data.getAccountIsLeaf() == 1 && !data.isAccountIsFreese()) continue;
            row.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
            row.getStyleAttributes().setLocked(true);
        }
    }

    private AccountBalanceInitData[] getAccountBalanceData() throws Exception {
        return this.changeArray(this.getFacade().getAccountBalanceData(this.curCur.getId().toString(), this.otherCtx));
    }

    private AccountBalanceInitData[] getGeneralLocalData() throws Exception {
        return this.changeArray(this.getFacade().getGeneralLocal(this.otherCtx));
    }

    private AccountBalanceInitData[] getGeneralReportData() throws Exception {
        return this.changeArray(this.getFacade().getGeneralReport(this.otherCtx));
    }

    private AccountBalanceInitData[] changeArray(Object[] i) {
        AccountBalanceInitData[] accdata = new AccountBalanceInitData[i.length];
        System.arraycopy(i, 0, accdata, 0, i.length);
        return accdata;
    }

    private void updateAncestorRows(IRow row, String[] keys, Object[] incrementValues, boolean dc, int type) {
        RowNode node;
        AccountBalanceInitData data = (AccountBalanceInitData)row.getUserObject();
        Object incrementVaule = incrementValues[0];
        Object incrementVauleLocal = incrementValues[1];
        Object incrementVauleReport = incrementValues[2];
        String key = keys[0];
        String keyLocal = keys[1];
        String keyReport = keys[2];
        if (incrementVaule == null) {
            return;
        }
        RowNode parent = node = (RowNode)this.rowNodeMap.get(data.getAccountId());
        while (parent != null && (parent = parent.getParent()) != null) {
            BigDecimal v1;
            boolean isYearDC;
            IRow row2 = parent.getRow();
            AccountBalanceInitData userObject = (AccountBalanceInitData)row2.getUserObject();
            if (userObject.getStatus() == 2) {
                userObject.setStatus(3);
            }
            if (userObject.getStatus() == 0) {
                userObject.setStatus(1);
            }
            boolean dc2 = userObject.getAccountDC() == 1;
            boolean isQty = false;
            if (key.equals(COLUMN_MONTHBEGINQTY) || key.equals(COLUMN_YEARCREDITQTY) || key.equals(COLUMN_YEARDEBITQTY)) {
                if (userObject.getAccountIsQty() != 1) {
                    return;
                }
                isQty = true;
            }
            boolean bl = isYearDC = key.equals(COLUMN_YEARCREDITFOR) || key.equals(COLUMN_YEARDEBITFOR) || key.equals(COLUMN_YEARCREDITLOCAL) || key.equals(COLUMN_YEARDEBITLOCAL) || key.equals(COLUMN_YEARCREDITREPORT) || key.equals(COLUMN_YEARDEBITREPORT) || key.equals(COLUMN_YEARCREDITQTY) || key.equals(COLUMN_YEARDEBITQTY);
            if (isQty) {
                v1 = this.getQtyScaleBigDecimalNvl(row2.getCell(key).getValue());
                if (isYearDC) {
                    row2.getCell(key).setValue((Object)this.getQtyScaleBigDecimalNvl(v1.add((BigDecimal)incrementVaule)));
                } else if (dc2 == dc) {
                    row2.getCell(key).setValue((Object)this.getQtyScaleBigDecimalNvl(v1.add((BigDecimal)incrementVaule)));
                } else {
                    row2.getCell(key).setValue((Object)this.getQtyScaleBigDecimalNvl(v1.subtract((BigDecimal)incrementVaule)));
                }
            } else if (incrementVaule instanceof BigDecimal) {
                v1 = this.getScaleBigDecimalNvl(row2.getCell(key).getValue(), type);
                if (isYearDC) {
                    row2.getCell(key).setValue((Object)this.getScaleBigDecimalNvl(v1.add((BigDecimal)incrementVaule), type));
                } else if (dc2 == dc) {
                    row2.getCell(key).setValue((Object)this.getScaleBigDecimalNvl(v1.add((BigDecimal)incrementVaule), type));
                } else {
                    row2.getCell(key).setValue((Object)this.getScaleBigDecimalNvl(v1.subtract((BigDecimal)incrementVaule), type));
                }
                if (keyLocal != null && incrementVauleLocal != null) {
                    v1 = this.getScaleBigDecimalNvl(row2.getCell(keyLocal).getValue(), 1);
                    if (isYearDC) {
                        row2.getCell(keyLocal).setValue((Object)this.getScaleBigDecimalNvl(v1.add((BigDecimal)incrementVauleLocal), 1));
                    } else if (dc2 == dc) {
                        row2.getCell(keyLocal).setValue((Object)this.getScaleBigDecimalNvl(v1.add((BigDecimal)incrementVauleLocal), 1));
                    } else {
                        row2.getCell(keyLocal).setValue((Object)this.getScaleBigDecimalNvl(v1.subtract((BigDecimal)incrementVauleLocal), 1));
                    }
                }
                if (keyLocal != null && incrementVauleReport != null) {
                    v1 = this.getScaleBigDecimalNvl(row2.getCell(keyReport).getValue(), 2);
                    if (isYearDC) {
                        row2.getCell(keyReport).setValue((Object)this.getScaleBigDecimalNvl(v1.add((BigDecimal)incrementVauleReport), 2));
                    } else if (dc2 == dc) {
                        row2.getCell(keyReport).setValue((Object)this.getScaleBigDecimalNvl(v1.add((BigDecimal)incrementVauleReport), 2));
                    } else {
                        row2.getCell(keyReport).setValue((Object)this.getScaleBigDecimalNvl(v1.subtract((BigDecimal)incrementVauleReport), 2));
                    }
                }
            }
            this.storeRowData(row2);
        }
    }

    public void storeData() {
        if (this.tblMain.getSelectManager().size() > 0) {
            int index = this.tblMain.getSelectManager().get().getTop();
            this.storeRowData(this.tblMain.getRow(index));
        }
        if (!this.dirty) {
            return;
        }
        if (this.tableDatas == null) {
            return;
        }
        for (int i = 0; i < this.tableDatas.length; ++i) {
            BigDecimal temp;
            AccountBalanceInitData data = this.tableDatas[i];
            if (data.getStatus() != 1 && data.getStatus() != 3) continue;
            if (data.getStatus() == 1) {
                data.setCurrencyId(this.curCur.getId().toString());
            }
            if ((temp = data.getYearCreditFor()) == null) {
                data.setYearCreditFor(this.zero);
                data.setYearCreditLocal(this.zero);
                data.setYearCreditReport(this.zero);
            }
            if ((temp = data.getYearDebitFor()) == null) {
                data.setYearDebitFor(this.zero);
                data.setYearDebitLocal(this.zero);
                data.setYearDebitReport(this.zero);
            }
            if ((temp = data.getBeginBalanceFor()) == null) {
                data.setBeginBalanceFor(this.zero);
                data.setBeginBalanceLocal(this.zero);
                data.setBeginBalanceReport(this.zero);
            }
            if ((temp = data.getYearPnLFor()) == null) {
                data.setYearPnLFor(this.zero);
                data.setYearPnLLocal(this.zero);
                data.setYearPnLReport(this.zero);
            }
            if (data.getAccountIsQty() == 1) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("measureUnitID.coefficient"));
                try {
                    AccountViewInfo acct = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(data.getAccountId().toString()), selector);
                    if (acct.getMeasureUnitID() != null) {
                        BigDecimal coef = acct.getMeasureUnitID().getCoefficient();
                        data.setBeginQty(data.getBeginQty() == null ? null : data.getBeginQty().multiply(coef));
                        data.setYearDebitQty(data.getYearDebitQty() == null ? null : data.getYearDebitQty().multiply(coef));
                        data.setYearCreditQty(data.getYearCreditQty() == null ? null : data.getYearCreditQty().multiply(coef));
                    }
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            data.setEndBalanceFor(data.getBeginBalanceFor());
            data.setEndBalanceLocal(data.getBeginBalanceLocal());
            data.setEndBalanceReport(data.getBeginBalanceReport());
            data.setEndQty(data.getBeginQty());
        }
    }

    private boolean save() {
        boolean isSaveSuccess = this.saveRecord();
        if (isSaveSuccess) {
            this.updateStatus();
            this.dirty = false;
            this.showSuccessMesseage();
        }
        return isSaveSuccess;
    }

    private boolean saveRecord() {
        try {
            isInitClosed = this.getFacade().isClosedInit(this.otherCtx);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (isInitClosed) {
            this.setButtonStatusForInitClosed();
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"117_GLInitUI"));
            SysUtil.abort();
        }
        if (!this.dirty || this.curCur.isGeneralLocalCurrency() || this.curCur.isGeneralReportCurrency()) {
            return true;
        }
        this.storeData();
        ArrayList<AccountBalanceInitData> al = new ArrayList<AccountBalanceInitData>((int)((double)this.tableDatas.length * 0.8));
        for (int i = 0; i < this.tableDatas.length; ++i) {
            if (this.tableDatas[i].getStatus() == 0 || this.tableDatas[i].getStatus() == 2 || this.tableDatas[i].getAccountIsLeaf() != 1) continue;
            if (this.isForeignCurrency) {
                this.tableDatas[i].setBeginBalanceLocal(this.zero);
                this.tableDatas[i].setBeginBalanceReport(this.zero);
                this.tableDatas[i].setYearDebitLocal(this.zero);
                this.tableDatas[i].setYearDebitReport(this.zero);
                this.tableDatas[i].setYearCreditLocal(this.zero);
                this.tableDatas[i].setYearCreditReport(this.zero);
                this.tableDatas[i].setYearPnLLocal(this.zero);
                this.tableDatas[i].setYearPnLReport(this.zero);
                this.tableDatas[i].setEndBalanceLocal(this.zero);
                this.tableDatas[i].setEndBalanceReport(this.zero);
            }
            al.add(this.tableDatas[i]);
        }
        try {
            Object[] params = al.toArray(new AccountBalanceInitData[al.size()]);
            this.getFacade().saveAccountBalance(params, this.otherCtx);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        try {
            this.loadData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return true;
    }

    private void setButtonStatusForInitClosed() {
        this.btnCloseInit.setEnabled(false);
        this.btnCancelInit.setEnabled(true);
        this.btnSave.setEnabled(false);
        this.miCancelInit.setEnabled(true);
        this.miCloseInit.setEnabled(false);
        this.miSave.setEnabled(false);
        this.importAsstBalance.setEnabled(false);
        this.imImportAccunt.setEnabled(false);
    }

    private void updateStatus() {
        for (int i = 0; i < this.tableDatas.length; ++i) {
            if (this.tableDatas[i].getStatus() == 1 || this.tableDatas[i].getStatus() == 3) {
                if (this.tableDatas[i].getBeginBalanceFor() != null && this.tableDatas[i].getBeginBalanceFor().doubleValue() != 0.0 || this.tableDatas[i].getYearDebitFor() != null && this.tableDatas[i].getYearDebitFor().doubleValue() != 0.0 || this.tableDatas[i].getYearCreditFor() != null && this.tableDatas[i].getYearCreditFor().doubleValue() != 0.0 || this.tableDatas[i].getDebitFor() != null && this.tableDatas[i].getDebitFor().doubleValue() != 0.0 || this.tableDatas[i].getCreditFor() != null && this.tableDatas[i].getCreditFor().doubleValue() != 0.0 || this.tableDatas[i].getEndBalanceFor() != null && this.tableDatas[i].getEndBalanceFor().doubleValue() != 0.0 || this.tableDatas[i].getBeginBalanceLocal() != null && this.tableDatas[i].getBeginBalanceLocal().doubleValue() != 0.0 || this.tableDatas[i].getYearDebitLocal() != null && this.tableDatas[i].getYearDebitLocal().doubleValue() != 0.0 || this.tableDatas[i].getYearCreditLocal() != null && this.tableDatas[i].getYearCreditLocal().doubleValue() != 0.0 || this.tableDatas[i].getDebitLocal() != null && this.tableDatas[i].getDebitLocal().doubleValue() != 0.0 || this.tableDatas[i].getCreditLocal() != null && this.tableDatas[i].getCreditLocal().doubleValue() != 0.0 || this.tableDatas[i].getEndBalanceLocal() != null && this.tableDatas[i].getEndBalanceLocal().doubleValue() != 0.0 || this.tableDatas[i].getBeginBalanceReport() != null && this.tableDatas[i].getBeginBalanceReport().doubleValue() != 0.0 || this.tableDatas[i].getYearDebitReport() != null && this.tableDatas[i].getYearDebitReport().doubleValue() != 0.0 || this.tableDatas[i].getYearCreditReport() != null && this.tableDatas[i].getYearCreditReport().doubleValue() != 0.0 || this.tableDatas[i].getDebitReport() != null && this.tableDatas[i].getDebitReport().doubleValue() != 0.0 || this.tableDatas[i].getCreditReport() != null && this.tableDatas[i].getCreditReport().doubleValue() != 0.0 || this.tableDatas[i].getEndBalanceReport() != null && this.tableDatas[i].getEndBalanceReport().doubleValue() != 0.0 || this.tableDatas[i].getBeginQty() != null && this.tableDatas[i].getBeginQty().doubleValue() != 0.0 || this.tableDatas[i].getYearDebitQty() != null && this.tableDatas[i].getYearDebitQty().doubleValue() != 0.0 || this.tableDatas[i].getYearCreditQty() != null && this.tableDatas[i].getYearCreditQty().doubleValue() != 0.0 || this.tableDatas[i].getDebitQty() != null && this.tableDatas[i].getDebitQty().doubleValue() != 0.0 || this.tableDatas[i].getCreditQty() != null && this.tableDatas[i].getCreditQty().doubleValue() != 0.0 || this.tableDatas[i].getEndQty() != null && this.tableDatas[i].getEndQty().doubleValue() != 0.0 || this.tableDatas[i].getYearPnLFor() != null && this.tableDatas[i].getYearPnLFor().doubleValue() != 0.0 || this.tableDatas[i].getMonthPnLFor() != null && this.tableDatas[i].getMonthPnLFor().doubleValue() != 0.0 || this.tableDatas[i].getYearPnLLocal() != null && this.tableDatas[i].getYearPnLLocal().doubleValue() != 0.0 || this.tableDatas[i].getMonthPnLLocal() != null && this.tableDatas[i].getMonthPnLLocal().doubleValue() != 0.0 || this.tableDatas[i].getYearPnLReport() != null && this.tableDatas[i].getYearPnLReport().doubleValue() != 0.0 || this.tableDatas[i].getMonthPnLReport() != null && this.tableDatas[i].getMonthPnLReport().doubleValue() != 0.0) continue;
                this.tableDatas[i].setStatus(0);
                continue;
            }
            this.tableDatas[i].setStatus(2);
        }
    }

    private void showSuccessMesseage() {
        String succeed = EASResource.getString((String)RESOURCE_PATH, (String)"savesucceed");
        this.setMessageText(succeed);
        this.showMessage();
    }

    private void closeInit() {
        if (!this.showShouldSave()) {
            return;
        }
        try {
            this.initMyData();
            if (this.isForeignCurrency) {
                String[] currencyIds = new String[this.allCurrency.size()];
                for (int i = 0; i < this.allCurrency.size(); ++i) {
                    currencyIds[i] = this.allCurrency.get(i).getId().toString();
                }
                this.otherCtx.put("ALLCURRENCYID", currencyIds);
            }
            if (!(isInitClosed = this.getFacade().isClosedInit(this.otherCtx))) {
                this.getFacade().closeInit(this.otherCtx);
                isInitClosed = true;
                this.btnCloseInit.setEnabled(false);
                this.btnCancelInit.setEnabled(true);
                this.btnSave.setEnabled(false);
                this.miCancelInit.setEnabled(true);
                this.miCloseInit.setEnabled(false);
                this.miSave.setEnabled(false);
                this.importAsstBalance.setEnabled(false);
                this.imImportAccunt.setEnabled(false);
                String succeed = EASResource.getString((String)RESOURCE_PATH, (String)"operatesucceed");
                this.setMessageText(succeed);
                this.showMessage();
                this.loadData();
                this.tblMain.getStyleAttributes().setBackground(InitClientHelp.COLOR_UNEDITABLE_ENTIRE);
            } else {
                this.btnCloseInit.setEnabled(false);
                this.btnCancelInit.setEnabled(true);
                this.btnSave.setEnabled(false);
                this.miCancelInit.setEnabled(true);
                this.miCloseInit.setEnabled(false);
                this.miSave.setEnabled(false);
                this.importAsstBalance.setEnabled(false);
                this.imImportAccunt.setEnabled(false);
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"117_GLInitUI"));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private boolean showShouldSave() {
        this.storeLastRow();
        if (this.dirty) {
            int choice = InitClientHelp.showModifyConfirm((Component)((Object)this));
            if (MsgBox.isYes((int)choice)) {
                return this.save();
            }
            if (MsgBox.isCancel((int)choice)) {
                return false;
            }
        }
        return true;
    }

    private void storeLastRow() {
        if (this.tblMain.getSelectManager().size() > 0) {
            int index = this.tblMain.getSelectManager().get().getTop();
            this.storeRowData(this.tblMain.getRow(index));
        }
    }

    private void cancelInit() throws EASBizException, BOSException {
        PeriodInfo startPeriod;
        boolean isCashFlowInitClosed = GLFlagFactory.getRemoteInstance().getCashflowInitClosed(this.curCompany.getId().toString());
        if (isCashFlowInitClosed && (startPeriod = GlUtils.getStartPeriod(null, this.curCompany.getId().toString())).getPeriodNumber() != 1) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"cashflowInitIsClosed");
            MsgBox.showError((Component)((Object)this), (String)msg);
            return;
        }
        SystemStatusCtrolCollection col = InitClientHelp.checkIsAlia(this.currentPeriod, this.curCompany);
        if (col != null && col.size() > 0) {
            Iterator it = col.iterator();
            StringBuffer relSb = new StringBuffer();
            while (it.hasNext()) {
                SystemStatusCtrolInfo info = (SystemStatusCtrolInfo)it.next();
                relSb.append(info.getSystemStatus().getName().getAlias());
                relSb.append(",");
            }
            if (relSb.length() > 0) {
                relSb.deleteCharAt(relSb.length() - 1);
                String msg = EASResource.getString((String)INITRESOURCE_PATH, (String)"closeRelatedGenealSystem");
                int result = MsgBox.showConfirm2((String)StringUtils.replace((String)msg, (String)"{1}", (String)relSb.toString()));
                if (!MsgBox.isYes((int)result)) {
                    return;
                }
            }
        }
        if (!this.showShouldSave()) {
            return;
        }
        try {
            this.initMyData();
            this.getFacade().cancelInit(this.otherCtx);
            isInitClosed = false;
            this.btnCloseInit.setEnabled(true);
            this.btnCancelInit.setEnabled(false);
            this.btnSave.setEnabled(true);
            this.miCancelInit.setEnabled(false);
            this.miCloseInit.setEnabled(true);
            this.miSave.setEnabled(true);
            this.importAsstBalance.setEnabled(!this.curCur.isGeneralLocalCurrency() && !this.curCur.isGeneralReportCurrency());
            this.imImportAccunt.setEnabled(true);
            this.Import.setEnabled(true);
            if (!this.isEditable) {
                this.setStatusForBook();
            }
            String succeed = EASResource.getString((String)RESOURCE_PATH, (String)"operatesucceed");
            this.setMessageText(succeed);
            this.showMessage();
            if (!this.curCur.isGeneralLocalCurrency() && !this.curCur.isGeneralReportCurrency()) {
                this.tblMain.getStyleAttributes().setBackground(Color.WHITE);
                this.setNonLeafColor();
            }
            if (col != null) {
                InitClientHelp.updateAliaCollection(col);
            }
            this.tblMain.getSelectManager().select(0, -1);
            this.setTableInit();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setStatusForBook() {
        this.btnSave.setEnabled(false);
        this.miSave.setEnabled(false);
        this.miImportAssist.setEnabled(false);
        this.imImportAccunt.setEnabled(false);
        this.actionImportData.setEnabled(false);
        this.Import.setEnabled(false);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    private void tryBalance() {
        if (!isInitClosed && this.tblMain.getSelectManager().size() > 0) {
            int index = this.tblMain.getSelectManager().get().getTop();
            this.storeRowData(this.tblMain.getRow(index));
        }
        if (this.dirty) {
            int choice = InitClientHelp.showModifyConfirm((Component)((Object)this));
            if (MsgBox.isYes((int)choice)) {
                this.save();
            } else if (MsgBox.isCancel((int)choice)) {
                return;
            }
        }
        String curid = null;
        if (!(this.isForeignCurrency || this.curCur.isGeneralLocalCurrency() || this.curCur.isGeneralReportCurrency())) {
            return;
        }
        curid = this.curCur.getId().toString();
        try {
            HashMap results = this.getFacade().tryBalance(curid, this.otherCtx);
            results.put("currentPeriod", this.currentPeriod);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"amountScale", (Object)new Integer(this.amountScale));
            uiContext.put((Object)"data", (Object)results);
            uiContext.put((Object)"currencyid", (Object)curid);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.TryBalanceUI", (Map)uiContext, null, null);
            uiWindow.show();
        }
        catch (Exception bose) {
            this.handUIException(bose);
        }
    }

    public VoucherInfo.ExchangeRateWithValue getCachedLocalExchangeRate(String orgCurId) {
        String localCurrencyId = this.localCur.get("id").toString();
        if (orgCurId.equals(localCurrencyId)) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        if ("none".equals(this.hmLocalExchangeRate.get(orgCurId))) {
            String noLocalEx = EASResource.getString((String)RESOURCE_PATH, (String)"noLocalEx");
            MsgBox.showWarning((Component)((Object)this), (String)noLocalEx);
            if (!this.initialized) {
                SysUtil.abort();
            }
            return null;
        }
        VoucherInfo.ExchangeRateWithValue ex = (VoucherInfo.ExchangeRateWithValue)this.hmLocalExchangeRate.get(orgCurId);
        if (ex == null) {
            try {
                Object[] info = new Object[8];
                if (this.curCompany.getBaseExchangeTable() == null) {
                    throw new GLException(GLException.NOLOCALEXTABLE);
                }
                info[0] = this.curCompany.getBaseExchangeTable().getId().toString();
                info[2] = orgCurId;
                info[3] = this.localCur.getId().toString();
                if (this.isUsingReport) {
                    info[4] = this.reportCur.getId().toString();
                }
                info[6] = this.startPeriod.getBeginDate();
                info[5] = this.startPeriod.getBeginDate();
                Object[] exes = AssistInitFacadeFactory.getRemoteInstance().fetchExchangeRate(info);
                ex = (VoucherInfo.ExchangeRateWithValue)exes[0];
                this.hmLocalExchangeRate.put(orgCurId, ex);
                if (this.isUsingReport) {
                    this.hmReportingExchangeRate.put(orgCurId, exes[1]);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.hmLocalExchangeRate.put(orgCurId, "none");
                if (!this.initialized) {
                    SysUtil.abort();
                }
                return null;
            }
        }
        if (ex == null) {
            String noLocalEx = EASResource.getString((String)RESOURCE_PATH, (String)"noLocalEx");
            MsgBox.showWarning((Component)((Object)this), (String)noLocalEx);
            this.hmLocalExchangeRate.put(orgCurId, "none");
            if (!this.initialized) {
                SysUtil.abort();
            }
            return null;
        }
        return ex;
    }

    public VoucherInfo.ExchangeRateWithValue getCachedReportingExchangeRate(String orgCurId) {
        String reportingCurrencyId = this.reportCur.get("id").toString();
        if (orgCurId.equals(reportingCurrencyId)) {
            return VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
        }
        if ("none".equals(this.hmReportingExchangeRate.get(orgCurId))) {
            String noLocalEx = EASResource.getString((String)RESOURCE_PATH, (String)"noReportingEx");
            MsgBox.showWarning((Component)((Object)this), (String)noLocalEx);
            if (!this.initialized) {
                SysUtil.abort();
            }
            return null;
        }
        VoucherInfo.ExchangeRateWithValue ex = (VoucherInfo.ExchangeRateWithValue)this.hmReportingExchangeRate.get(orgCurId);
        if (ex == null) {
            try {
                Object[] info = new Object[8];
                if (this.curCompany.getReportExchangeTable() == null) {
                    throw new GLException(GLException.NOREPORTINGEXTABLE);
                }
                info[1] = this.curCompany.getReportExchangeTable().getId().toString();
                info[2] = orgCurId;
                info[3] = this.localCur.getId().toString();
                info[4] = this.reportCur.getId().toString();
                info[6] = this.startPeriod.getBeginDate();
                info[5] = this.startPeriod.getBeginDate();
                Object[] exes = AssistInitFacadeFactory.getRemoteInstance().fetchExchangeRate(info);
                ex = (VoucherInfo.ExchangeRateWithValue)exes[1];
                this.hmReportingExchangeRate.put(orgCurId, exes[0]);
            }
            catch (Exception e) {
                this.handUIException(e);
                this.hmReportingExchangeRate.put(orgCurId, "none");
                if (!this.initialized) {
                    SysUtil.abort();
                }
                return null;
            }
        }
        if (ex == null) {
            String noLocalEx = EASResource.getString((String)RESOURCE_PATH, (String)"noReportingEx");
            MsgBox.showWarning((Component)((Object)this), (String)noLocalEx);
            this.hmReportingExchangeRate.put(orgCurId, "none");
            if (!this.initialized) {
                SysUtil.abort();
            }
            return null;
        }
        return ex;
    }

    public boolean checkBeforeWindowClosing() {
        if (this.tblMain.getSelectManager().size() > 0) {
            int index = this.tblMain.getSelectManager().get().getTop();
            this.storeRowData(this.tblMain.getRow(index));
        }
        if (this.dirty) {
            int choice = InitClientHelp.showModifyConfirmBeforeExit((Component)((Object)this));
            if (MsgBox.isCancel((int)choice)) {
                return false;
            }
            if (MsgBox.isYes((int)choice)) {
                return this.save();
            }
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    public void printAction_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
        if (this.tblMain.getRowCount() < 1) {
            return;
        }
        super.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void printPreviewAction_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
        if (this.tblMain.getRowCount() < 1) {
            return;
        }
        super.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void saveAction_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
        this.save();
    }

    @Override
    public void tryBalanceAction_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
        this.tryBalance();
    }

    @Override
    public void closeInitAction_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
        this.closeInit();
        if (isInitClosed) {
            this.Import.setEnabled(false);
        } else {
            this.Import.setEnabled(true);
        }
    }

    @Override
    public void cancelInitAction_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.getEditManager().stopEditing();
        this.cancelInit();
    }

    @Override
    public void importAsstBalance_actionPerformed(ActionEvent e) throws Exception {
        if (this.dirty) {
            int choice = InitClientHelp.showModifyConfirm((Component)((Object)this));
            if (MsgBox.isYes((int)choice)) {
                this.save();
            } else if (!MsgBox.isNo((int)choice)) {
                this.setFreeState();
                return;
            }
        }
        this.importAsstBalance();
    }

    @Override
    public void importAccuntBalance_actionPerformed(ActionEvent e) throws Exception {
        this.importAccuntBalance();
    }

    public void importAsstBalance() throws EASBizException, BOSException, Exception {
        int selectVal = 0;
        if (this.tblMain.getRowCount() != 0) {
            String msg = EASResource.getString((String)INITRESOURCE_PATH, (String)"isCoverAccount");
            selectVal = MsgBox.showConfirm3((Component)((Object)this), (String)msg);
        }
        if (selectVal == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.cbCurrency.getSelectedItem();
        this.otherCtx.put("LOCALCURRENCYID", currency.getId().toString());
        String type = "0";
        if (currency.isGeneralLocalCurrency()) {
            type = "1";
        } else if (this.curCur.isGeneralReportCurrency()) {
            type = "2";
        }
        this.otherCtx.put("LOCALCURRENCY", type);
        ArrayList initData = this.getFacade().getInitDataByAssist(this.otherCtx);
        if (initData != null) {
            int i;
            int count = initData.size();
            ArrayList list = new ArrayList();
            for (i = 0; i < count; ++i) {
                if (((AccountBalanceInitData)initData.get(i)).getAccountIsLeaf() != 1) continue;
                list.add(initData.get(i));
            }
            if (selectVal == 1) {
                ArrayList<AccountBalanceInitData> removeData = new ArrayList<AccountBalanceInitData>();
                block1: for (int i2 = 0; i2 < list.size(); ++i2) {
                    AccountBalanceInitData data = (AccountBalanceInitData)list.get(i2);
                    for (int j = 0; j < this.tableDatas.length; ++j) {
                        if (this.tableDatas[j] == null || data == null || !this.tableDatas[j].getAccountId().equals(data.getAccountId()) || !(this.tableDatas[j].getBeginBalanceFor() != null && this.tableDatas[j].getBeginBalanceFor().compareTo(this.zero) != 0 || this.tableDatas[j].getYearPnLFor() != null && this.tableDatas[j].getYearPnLFor().compareTo(this.zero) != 0 || this.tableDatas[j].getYearCreditFor() != null && this.tableDatas[j].getYearCreditFor().compareTo(this.zero) != 0) && (this.tableDatas[j].getYearDebitFor() == null || this.tableDatas[j].getYearDebitFor().compareTo(this.zero) == 0)) continue;
                        removeData.add(data);
                        continue block1;
                    }
                }
                list.removeAll(removeData);
            }
            this.dirty = list.size() > 0;
            for (i = 0; i < this.tableDatas.length && !this.dirty; ++i) {
                AccountBalanceInitData data = this.tableDatas[i];
                if (data.getAccount() == null || data.getAccount().getCAA() == null || !this.hasBalance(data)) continue;
                this.dirty = true;
            }
            AccountBalanceInitData[] datas = list.toArray(new AccountBalanceInitData[list.size()]);
            this.refreshDatas(datas, this.dirty, selectVal, true);
        }
    }

    public void importAccuntBalance() throws EASBizException, BOSException, Exception {
        String msg;
        int selectVal;
        if (this.tblMain.getRowCount() != 0 && (selectVal = MsgBox.showConfirm2((Component)((Object)this), (String)(msg = EASResource.getString((String)INITRESOURCE_PATH, (String)"isCoverAccount")))) == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.cbCurrency.getSelectedItem();
        this.otherCtx.put("LOCALCURRENCYID", currency.getId().toString());
        String type = "0";
        if (currency.isGeneralLocalCurrency()) {
            type = "1";
        } else if (this.curCur.isGeneralReportCurrency()) {
            type = "2";
        }
        this.otherCtx.put("LOCALCURRENCY", type);
        ArrayList initData = this.getFacade().getInitDataByCussent(this.otherCtx);
        if (initData != null) {
            int count = initData.size();
            AccountBalanceInitData[] datas = initData.toArray(new AccountBalanceInitData[count]);
            this.refreshDatas(datas, true, 1, false);
        }
    }

    protected String getPrintPageTitle() {
        return EASResource.getString((String)this.getResourceNameForPrint(), (String)"GLInit_Title");
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontSize(9);
        StringBuffer sbAccountPeriod = new StringBuffer();
        sbAccountPeriod.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Currency_Label"));
        sbAccountPeriod.append("&[Currency]&|");
        sbAccountPeriod.append(this.lblPeriod.getBoundLabelText()).append(":").append("&[Period]&|");
        sbAccountPeriod.append(EASResource.getString((String)this.getResourceNameForPrint(), (String)"Company_Label"));
        sbAccountPeriod.append("&[Company]&|");
        header.addRow(sbAccountPeriod.toString(), sa);
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        return this.evp;
    }

    protected Variant preparePrintVariant(String varName) {
        Variant v = new Variant();
        if (varName.equals("Currency")) {
            v.setObject((Object)this.curCur.getName());
        } else if (varName.equals("Period")) {
            v.setObject((Object)this.tfPeriod.getText());
        } else if (varName.equals("Company")) {
            v.setObject((Object)this.curCompany.getName());
        }
        return v;
    }

    protected boolean isAllowLoadPrintSetting() {
        return false;
    }

    protected String getResourceNameForPrint() {
        return "com.kingdee.eas.fi.gl.ReportPrintTitle";
    }

    protected final void initTempSave() throws Exception {
        String saveTime = null;
        if (this.isCanSave()) {
            saveTime = ParamManager.getParamValue(null, null, (String)"SaveTimer");
            if (saveTime != null) {
                this.saveTimeLen = Integer.parseInt(saveTime);
            }
            if (this.saveTimeLen > 0) {
                ActionEvent evt = new ActionEvent(this.btnSave, 0, "Save");
                ItemAction actSave = this.getActionFromActionEvent(evt);
                this.timer = new SaveTimer(this.saveTimeLen, actSave, evt);
                this.timer.start();
            }
        }
    }

    private boolean isCanSave() {
        return !isInitClosed;
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected boolean isCanCopyPaste() {
        return false;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    public boolean destroyWindow() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        return super.destroyWindow();
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getImportAccountParam(), 0);
        this.initMyData();
        this.currencyChanged();
        this.initTempSave();
    }

    @Override
    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getExportAccountParam(), 1);
    }

    protected ArrayList getExportAccountParam() {
        String solutionName;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.datataskMode = 1;
        param.solutionName = solutionName = "eas.fi.gl.accountBalance";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AccountInit");
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportAccountParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.fi.gl.accountBalance";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AccountInit");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public Object getTablePreferenceSchemaKey() {
        if (this.curCur != null && (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.curCur.getId().toString()) || CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.curCur.getId().toString()))) {
            return this.curCur.getId().toString();
        }
        return null;
    }

    private void setTableInit() {
        UserCustomConfigItemData itemData = this.tHelper.getDefaultUserData(this.tblMain);
        if (itemData == null) {
            return;
        }
        UserPreferenceData tempData = this.tHelper.getUserDataFromUI();
        Map columnMap = itemData.getColumnData();
        String uiClassName = this.getMetaDataPK().getFullName();
        String tableName = uiClassName + "." + this.tblMain.getName();
        UserCustomConfigItemData tempItemData = (UserCustomConfigItemData)tempData.getTables().get(tableName);
        Map tempColumnMap = tempItemData.getColumnData();
        int j = this.tblMain.getColumnCount();
        for (int i = 0; i < j; ++i) {
            IColumn col = this.tblMain.getColumn(i);
            String key = col.getKey();
            ColumnItemData tempColumnData = (ColumnItemData)tempColumnMap.get(key);
            ColumnItemData columnData = (ColumnItemData)columnMap.get(key);
            if (columnData == null || tempColumnData == null) continue;
            columnData.setHidden(tempColumnData.isHidden());
            columnData.setLocked(tempColumnData.isLocked());
        }
        this.tblMain.getViewManager().setFreezeView(-1, 3);
    }

    private boolean isCanEditInitDate() throws EASBizException, BOSException {
        HashMap<String, ObjectUuidPK> hmNumAndOrgId = new HashMap<String, ObjectUuidPK>();
        hmNumAndOrgId.put("GL017", new ObjectUuidPK(BOSUuid.read((String)InitClientHelp.getCurrentCompany().getId().toString())));
        HashMap hmAllParam = ParamControlFactory.getRemoteInstance().getParamHashMap(hmNumAndOrgId);
        Boolean isCanEditInitDate = Boolean.valueOf((String)hmAllParam.get("GL017"));
        return isCanEditInitDate != null && isCanEditInitDate.equals(Boolean.TRUE);
    }

    static /* synthetic */ AccountBalanceInitData[] access$3502(GLInitUI x0, AccountBalanceInitData[] x1) {
        x0.tableDatas = x1;
        return x1;
    }

    class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -2245976874537158170L;

        DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (isInitClosed) {
                return;
            }
            if (GLInitUI.this.curCur.isGeneralLocalCurrency() || GLInitUI.this.curCur.isGeneralReportCurrency()) {
                return;
            }
            int rowIndex = GLInitUI.this.tblMain.getSelectManager().get().getTop();
            IRow row = GLInitUI.this.tblMain.getRow(rowIndex);
            AccountBalanceInitData useObject = (AccountBalanceInitData)row.getUserObject();
            if (useObject.getAccountIsLeaf() == 0 || useObject.getStatus() == 0) {
                return;
            }
            boolean hasParent = false;
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            RowNode node = (RowNode)GLInitUI.this.rowNodeMap.get(useObject.getAccountId());
            if (node != null && node.getParent() != null) {
                hasParent = true;
            }
            int count = GLInitUI.this.tblMain.getColumnCount();
            for (int i = 0; i < count; ++i) {
                String key = GLInitUI.this.tblMain.getColumns().getColumnKey(i);
                if (key.equals(GLInitUI.COLUMN_ACCOUNTDC) || key.equals(GLInitUI.COLUMN_ACCOUNTNAME) || key.equals(GLInitUI.COLUMN_ACCOUNTNUMBER) || key.equals(GLInitUI.COLUMN_MEASUREUNIT)) continue;
                ICell cell = row.getCell(i);
                BigDecimal value = InitClientHelp.toBigDecimal(cell.getValue());
                if (value != null) {
                    value = value.multiply(InitClientHelp.negone);
                }
                map.put(key, value);
                cell.setValue(null);
            }
            if (useObject.getStatus() == 1) {
                useObject.setStatus(0);
            } else if (useObject.getStatus() == 2) {
                useObject.setStatus(3);
            }
            if (hasParent) {
                boolean dc = useObject.getAccountDC() == 1;
                String[] keys = new String[]{GLInitUI.COLUMN_MONTHBEGINFOR, GLInitUI.COLUMN_MONTHBEGINLOCAL, GLInitUI.COLUMN_MONTHBEGINREPORT};
                Object[] increments = new Object[]{map.get(GLInitUI.COLUMN_MONTHBEGINFOR), map.get(GLInitUI.COLUMN_MONTHBEGINLOCAL), map.get(GLInitUI.COLUMN_MONTHBEGINREPORT)};
                if (map.get(GLInitUI.COLUMN_MONTHBEGINFOR) != null) {
                    GLInitUI.this.updateAncestorRows(row, keys, increments, dc, 0);
                }
                keys = new String[]{GLInitUI.COLUMN_YEARCREDITFOR, GLInitUI.COLUMN_YEARCREDITLOCAL, GLInitUI.COLUMN_YEARCREDITREPORT};
                increments = new Object[]{map.get(GLInitUI.COLUMN_YEARCREDITFOR), map.get(GLInitUI.COLUMN_YEARCREDITLOCAL), map.get(GLInitUI.COLUMN_YEARCREDITREPORT)};
                if (map.get(GLInitUI.COLUMN_YEARCREDITFOR) != null) {
                    GLInitUI.this.updateAncestorRows(row, keys, increments, dc, 0);
                }
                keys = new String[]{GLInitUI.COLUMN_YEARDEBITFOR, GLInitUI.COLUMN_YEARDEBITLOCAL, GLInitUI.COLUMN_YEARDEBITREPORT};
                increments = new Object[]{map.get(GLInitUI.COLUMN_YEARDEBITFOR), map.get(GLInitUI.COLUMN_YEARDEBITLOCAL), map.get(GLInitUI.COLUMN_YEARDEBITREPORT)};
                if (map.get(GLInitUI.COLUMN_YEARDEBITFOR) != null) {
                    GLInitUI.this.updateAncestorRows(row, keys, increments, dc, 0);
                }
                keys = new String[]{GLInitUI.COLUMN_YEARPNLFOR, GLInitUI.COLUMN_YEARPNLLOCAL, GLInitUI.COLUMN_YEARPNLREPORT};
                increments = new Object[]{map.get(GLInitUI.COLUMN_YEARPNLFOR), map.get(GLInitUI.COLUMN_YEARPNLLOCAL), map.get(GLInitUI.COLUMN_YEARPNLREPORT)};
                if (map.get(GLInitUI.COLUMN_YEARPNLFOR) != null) {
                    GLInitUI.this.updateAncestorRows(row, keys, increments, dc, 0);
                }
                keys = new String[]{GLInitUI.COLUMN_YEARCREDITQTY, null, null};
                increments = new Object[]{map.get(GLInitUI.COLUMN_YEARCREDITQTY), null, null};
                if (map.get(GLInitUI.COLUMN_YEARCREDITQTY) != null) {
                    GLInitUI.this.updateAncestorRows(row, keys, increments, dc, 0);
                }
                keys = new String[]{GLInitUI.COLUMN_YEARDEBITQTY, null, null};
                increments = new Object[]{map.get(GLInitUI.COLUMN_YEARDEBITQTY), null, null};
                if (map.get(GLInitUI.COLUMN_YEARDEBITQTY) != null) {
                    GLInitUI.this.updateAncestorRows(row, keys, increments, dc, 0);
                }
                keys = new String[]{GLInitUI.COLUMN_MONTHBEGINQTY, null, null};
                increments = new Object[]{map.get(GLInitUI.COLUMN_MONTHBEGINQTY), null, null};
                if (map.get(GLInitUI.COLUMN_MONTHBEGINQTY) != null) {
                    GLInitUI.this.updateAncestorRows(row, keys, increments, dc, 0);
                }
            }
        }
    }

    class TableSelectionListener
    implements KDTActiveCellListener {
        TableSelectionListener() {
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            int line;
            KDTable table = (KDTable)e.getSource();
            int preLine = e.getPrevRowIndex();
            if (preLine != (line = e.getRowIndex())) {
                if (preLine >= table.getRowCount()) {
                    preLine = -1;
                }
                if (line >= table.getRowCount()) {
                    line = -1;
                }
                GLInitUI.this.selectChanged(preLine, line);
                GLInitUI.this.setTableInit();
            }
        }
    }

    class EditAdapterImpl
    extends KDTEditAdapter {
        private Object oldValue;

        EditAdapterImpl() {
        }

        public void editStarted(KDTEditEvent e) {
            KDTable table = (KDTable)e.getSource();
            this.oldValue = table.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue();
        }

        public void editStopped(KDTEditEvent e) {
            BigDecimal increment = null;
            BigDecimal incrementLocal = null;
            BigDecimal incrementReport = null;
            KDTable table = (KDTable)e.getSource();
            int ci = e.getColIndex();
            int ri = e.getRowIndex();
            String keyLocal = null;
            String keyReport = null;
            Object newValue = table.getRow(e.getRowIndex()).getCell(e.getColIndex()).getValue();
            if (newValue == null && this.oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(this.oldValue)) {
                return;
            }
            IRow row = table.getRow(ri);
            AccountBalanceInitData userObject = (AccountBalanceInitData)row.getUserObject();
            if (userObject.getStatus() == 2) {
                userObject.setStatus(3);
            }
            if (userObject.getStatus() == 0) {
                userObject.setStatus(1);
            }
            boolean isQty = false;
            if (table.getColumnKey(ci).equals(GLInitUI.COLUMN_MONTHBEGINQTY) || table.getColumnKey(ci).equals(GLInitUI.COLUMN_YEARCREDITQTY) || table.getColumnKey(ci).equals(GLInitUI.COLUMN_YEARDEBITQTY)) {
                isQty = true;
            }
            int type = 0;
            if (!isQty) {
                if (table.getColumnIndex(GLInitUI.COLUMN_MONTHBEGINFOR) == ci) {
                    keyLocal = GLInitUI.COLUMN_MONTHBEGINLOCAL;
                    keyReport = GLInitUI.COLUMN_MONTHBEGINREPORT;
                } else if (table.getColumnIndex(GLInitUI.COLUMN_YEARDEBITFOR) == ci) {
                    keyLocal = GLInitUI.COLUMN_YEARDEBITLOCAL;
                    keyReport = GLInitUI.COLUMN_YEARDEBITREPORT;
                } else if (table.getColumnIndex(GLInitUI.COLUMN_YEARCREDITFOR) == ci) {
                    keyLocal = GLInitUI.COLUMN_YEARCREDITLOCAL;
                    keyReport = GLInitUI.COLUMN_YEARCREDITREPORT;
                } else if (table.getColumnIndex(GLInitUI.COLUMN_YEARPNLFOR) == ci) {
                    keyLocal = GLInitUI.COLUMN_YEARPNLLOCAL;
                    keyReport = GLInitUI.COLUMN_YEARPNLREPORT;
                } else if (table.getColumnIndex(GLInitUI.COLUMN_MONTHBEGINLOCAL) == ci || table.getColumnIndex(GLInitUI.COLUMN_YEARDEBITLOCAL) == ci || table.getColumnIndex(GLInitUI.COLUMN_YEARCREDITLOCAL) == ci || table.getColumnIndex(GLInitUI.COLUMN_YEARPNLLOCAL) == ci) {
                    type = 1;
                } else if (table.getColumnIndex(GLInitUI.COLUMN_MONTHBEGINREPORT) == ci || table.getColumnIndex(GLInitUI.COLUMN_YEARDEBITREPORT) == ci || table.getColumnIndex(GLInitUI.COLUMN_YEARCREDITREPORT) == ci || table.getColumnIndex(GLInitUI.COLUMN_YEARPNLREPORT) == ci) {
                    type = 2;
                }
                increment = GLInitUI.this.getScaleBigDecimalNvl(newValue, type).subtract(GLInitUI.this.getScaleBigDecimalNvl(this.oldValue, type));
                if (type == 0) {
                    BigDecimal value = GLInitUI.this.getScaleBigDecimalNvl(newValue, 0);
                    BigDecimal valueLocal = GLInitUI.this.isDiv2Local ? value.divide(GLInitUI.this.curExRate2Local, GLInitUI.this.localAmountScale, GLInitUI.this.roundMode) : value.multiply(GLInitUI.this.curExRate2Local);
                    BigDecimal valueReport = null;
                    if (GLInitUI.this.isUsingReport) {
                        if (GLInitUI.this.isSettleByLocal) {
                            value = valueLocal;
                        }
                        valueReport = GLInitUI.this.isDiv2Report ? value.divide(GLInitUI.this.curExRate2Report, GLInitUI.this.reportAmountScale, GLInitUI.this.roundMode) : value.multiply(GLInitUI.this.curExRate2Report);
                    }
                    incrementLocal = GLInitUI.this.getScaleBigDecimalNvl(row.getCell(keyLocal).getValue(), 1);
                    incrementReport = GLInitUI.this.getScaleBigDecimalNvl(row.getCell(keyReport).getValue(), 2);
                    row.getCell(keyLocal).setValue((Object)GLInitUI.this.getScaleBigDecimal(valueLocal, 1));
                    row.getCell(keyReport).setValue((Object)GLInitUI.this.getScaleBigDecimal(valueReport, 2));
                    incrementLocal = GLInitUI.this.getScaleBigDecimalNvl(valueLocal, 1).subtract(incrementLocal);
                    incrementReport = GLInitUI.this.getScaleBigDecimalNvl(valueReport, 2).subtract(incrementReport);
                }
            } else {
                increment = GLInitUI.this.getQtyScaleBigDecimalNvl(newValue).subtract(GLInitUI.this.getQtyScaleBigDecimalNvl(this.oldValue));
            }
            boolean dc = userObject.getAccountDC() == 1;
            GLInitUI.this.updateAncestorRows(row, new String[]{table.getColumnKey(ci), keyLocal, keyReport}, new Object[]{increment, incrementLocal, incrementReport}, dc, type);
            GLInitUI.this.dirty = true;
        }
    }
}

