/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLTaskLogger;
import com.kingdee.eas.fi.gl.GLTaskProcessor;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractGLTaskMonitor;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class GLTaskMonitor
extends AbstractGLTaskMonitor
implements GLTaskLogger,
Runnable {
    private static final Logger logger = CoreUIObject.getLogger(GLTaskMonitor.class);
    private static final DateFormat df = new SimpleDateFormat("yyyyMMdd-HH:mm:ss SSS");
    private static final String GL_RESOURCE = "com.kingdee.eas.fi.gl.GLResource";
    private GLTaskProcessor processor = null;
    private Thread worker = null;
    private boolean finished = false;
    private boolean cancel = false;
    private Throwable throwable = null;
    private Object result = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.spConsole.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        this.txtConsole.setEditable(false);
        Map uiContext = this.getUIContext();
        this.processor = (GLTaskProcessor)uiContext.get("processor");
        this.processor.setTaskLogger(this);
        if (uiContext.get("isAdjust") != null && ((Boolean)uiContext.get("isAdjust")).booleanValue()) {
            this.setPreferredSize(new Dimension((Integer)uiContext.get("width"), (Integer)uiContext.get("height")));
        }
        if (uiContext.get("isNeedBtnCancel") != null && ((Boolean)uiContext.get("isNeedBtnCancel")).booleanValue()) {
            this.btnCancel.setVisible(false);
        }
        this.worker = new Thread(this);
        this.worker.start();
    }

    @Override
    public void run() {
        try {
            this.showInfo(EASResource.getString((String)GL_RESOURCE, (String)"start"));
            this.result = this.processor.process();
            this.showInfo(EASResource.getString((String)GL_RESOURCE, (String)"end"));
        }
        catch (Throwable t) {
            this.throwable = t;
            this.showError(null, t);
        }
        finally {
            this.finished = true;
        }
        this.btnCancel.setVisible(true);
        this.btnCancel.setText(this.btnClose.getText());
        if (this.throwable == null && this.processor.isAutoClose()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GLTaskMonitor.this.destroyWindow();
                }
            });
        }
    }

    protected boolean checkBeforeWindowClosing() {
        return this.finished || this.cancel;
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        if (!this.finished) {
            this.processor.setCancel(true);
            this.cancel = true;
        }
        this.destroyWindow();
    }

    public static Object show(Object owner, GLTaskProcessor processor) throws Exception {
        return GLTaskMonitor.show(owner, processor, null);
    }

    public static Object show(Object owner, GLTaskProcessor processor, Map param) throws Exception {
        if (processor == null) {
            return null;
        }
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"processor", (Object)processor);
        if (param != null) {
            uiContext.putAll(param);
        }
        uiContext.put((Object)"canResize", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.GLTaskMonitor", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        GLTaskMonitor monitor = (GLTaskMonitor)uiWindow.getUIObject();
        if (monitor.cancel) {
            return null;
        }
        return monitor.result;
    }

    @Override
    public void showInfo(String message) {
        this.showInfo(message, Color.BLACK);
    }

    @Override
    public void showWarn(String message) {
        this.showInfo(message, Color.BLACK);
    }

    @Override
    public void showError(String message, Throwable t) {
        this.showInfo(message, Color.RED);
        this.showInfo(GlUtils.printStackTrace(t), Color.RED);
    }

    private void showInfo(final String message, final Color color) {
        if (message == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = GLTaskMonitor.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), df.format(new Date()) + " " + message + "\n", attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                GLTaskMonitor.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }
}

