/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlRptTableSetFactory;
import com.kingdee.eas.fi.gl.GlRptTableSetInfo;
import com.kingdee.eas.fi.gl.client.AbstractGlRptTableSetUI;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class GlRptTableSetUI
extends AbstractGlRptTableSetUI {
    private static final long serialVersionUID = 4470757491652761481L;
    protected static final String[] columnNames = new String[]{"account", "asstact", "balance_period_begin", "dir_debit", "dir_credit", "debit_year_sum", "debit_period_sum", "balance_period_end", "direction"};
    protected static final int[] DEFAULT_SET = new int[]{120, 150, 100, 100, 100, 100, 100, 100, 30};
    public static final int SAVE = 1;
    public static final int CANCEL = 0;
    public static final int DELETE = 2;
    private int action = 0;

    public GlRptTableSetUI() throws Exception {
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.tblMain.checkParsed();
        KDFormattedTextField IntField = new KDFormattedTextField(0);
        IntField.setNegatived(false);
        IntField.setMaximumValue((Comparable)new Integer(1000));
        IntField.setHorizontalAlignment(4);
        this.tblMain.getColumn("width").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)IntField));
        this.tblMain.getColumn("hide").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tblMain.getColumn("hide").setRenderer((IBasicRender)new CellCheckBoxRenderer());
        try {
            UserInfo currUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("user.id", (Object)currUserInfo.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("tableID", (Object)this.getUIContext().get("tableID").toString()));
            view.setFilter(fi);
            CoreBaseCollection tableSetDataColl = this.getBizInterface().getCollection(view);
            if (tableSetDataColl.size() == 0) {
                tableSetDataColl = this.createNewTableSet();
            }
            for (int i = 0; i < columnNames.length; ++i) {
                int width = DEFAULT_SET[i];
                boolean hide = false;
                for (int j = 0; j < tableSetDataColl.size(); ++j) {
                    GlRptTableSetInfo setInfo = (GlRptTableSetInfo)tableSetDataColl.get(j);
                    if (!setInfo.getFieldName().equalsIgnoreCase(columnNames[i])) continue;
                    width = setInfo.getColWidth();
                    hide = setInfo.isIsHide();
                    break;
                }
                IRow row = this.tblMain.addRow();
                row.getCell("name").setValue((Object)(i == 0 ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"84_AccountAgeUI") : (i == 1 ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"116_GlRptTableSetUI") : GLResUtil.getRes(columnNames[i]))));
                row.getCell("width").setValue((Object)new Integer(width));
                row.getCell("hide").setValue((Object)hide);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private CoreBaseCollection createNewTableSet() {
        CoreBaseCollection tableSetDataColl = new CoreBaseCollection();
        for (int i = 0; i < columnNames.length; ++i) {
            GlRptTableSetInfo setInfo = new GlRptTableSetInfo();
            setInfo.setFieldName(columnNames[i]);
            setInfo.setTableID(this.getUIContext().get("tableID").toString());
            setInfo.setColWidth(DEFAULT_SET[i]);
            setInfo.setIsHide(false);
            tableSetDataColl.add((CoreBaseInfo)setInfo);
        }
        return tableSetDataColl;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GlRptTableSetFactory.getRemoteInstance();
    }

    @Override
    public void actionStore_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("width").setValue((Object)new Integer(DEFAULT_SET[i]));
            this.tblMain.getRow(i).getCell("hide").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            GlRptTableSetInfo info = new GlRptTableSetInfo();
            info.setUser(SysContext.getSysContext().getCurrentUserInfo());
            info.setTableID(this.getUIContext().get("tableID").toString());
            info.setFieldName(columnNames[i]);
            info.setColWidth((Integer)this.tblMain.getCell(i, "width").getValue());
            info.setIsHide((Boolean)this.tblMain.getCell(i, "hide").getValue());
            coll.add((CoreBaseInfo)info);
        }
        UserInfo currUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("user.id", (Object)currUserInfo.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("tableID", (Object)this.getUIContext().get("tableID").toString()));
        this.getBizInterface().delete(fi);
        this.getBizInterface().addnew(coll);
        this.action = 1;
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.action = 0;
        this.actionExitCurrent_actionPerformed(e);
    }

    protected JButton getDefaultButton() {
        return this.btnOK;
    }

    public int getAction() {
        return this.action;
    }
}

