/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.HGRepairQueryCondition;
import com.kingdee.eas.fi.gl.HGRepairToolFacadeFactory;
import com.kingdee.eas.fi.gl.HGRepairUtils;
import com.kingdee.eas.fi.gl.RepairData;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractHGRepairToolUI;
import com.kingdee.eas.fi.gl.client.RepairlUI;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.client.AbstractHidedMenuItem;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class HGRepairToolUI
extends AbstractHGRepairToolUI {
    private static final Logger logger = CoreUIObject.getLogger(HGRepairToolUI.class);
    protected CompanyOrgUnitInfo currentCompany;

    public void onLoad() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        super.onLoad();
        this.kDTable1.checkParsed();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)this.currentCompany.getId().toString()));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", null));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
        filter.setMaskString("#0 AND #1 AND #2 AND ( #3 or  #4)  AND #5 ");
        AccountPromptBox promptBox = new AccountPromptBox((IUIObject)this, companyInfo, filter, false, true);
        this.prmtAccount.setSelector((KDPromptSelector)promptBox);
        this.query.setEnabled(true);
        this.repair.setEnabled(true);
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"222_HGRepairToolUI"));
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtAccount.setEditFormat("$number$");
        this.prmtAccount.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.currentCompany.getAccountPeriodType().getId().toString()));
        evi.setFilter(f);
        this.prmtPeriod.setEntityViewInfo(evi);
        this.prmtPeriod.setEditFormat("$number$");
        this.prmtPeriod.setCommitFormat("$number$");
        this.prmtAccount.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    HGRepairToolUI.this.prmtAccount_willShow(e);
                }
                catch (Exception exc) {
                    HGRepairToolUI.this.handUIException(exc);
                }
            }
        });
        this.prmtAccount.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    HGRepairToolUI.this.prmtAccount_willCommit(e);
                }
                catch (Exception exc) {
                    HGRepairToolUI.this.handUIException(exc);
                }
            }
        });
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift Q"){

            public void action_actionPerformed() {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("comfid", HGRepairUtils.getId(HGRepairToolUI.this.prmtCompany));
                hm.put("avid", HGRepairUtils.getId(HGRepairToolUI.this.prmtAccount));
                hm.put("pfid", HGRepairUtils.getId(HGRepairToolUI.this.prmtPeriod));
                try {
                    PeriodInfo value = (PeriodInfo)HGRepairToolUI.this.prmtPeriod.getValue();
                    if (value != null) {
                        hm.put("pnumber", value.getNumber());
                    }
                    HGRepairToolFacadeFactory.getRemoteInstance().delete(hm);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        });
    }

    private void prmtAccount_willShow(SelectorEvent e) {
    }

    private void prmtAccount_willCommit(CommitEvent e) {
        KDPromptSelector opseelect = F7SelectorFactory.getAccountF7((IUIObject)this, (String)this.currentCompany.getId().toString());
        this.prmtAccount.setSelector(opseelect);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        HGRepairQueryCondition hqc = this.getHGRepairQueryCondition();
        IRowSet rs = HGRepairToolFacadeFactory.getRemoteInstance().query(hqc);
        this.fillTable(rs);
    }

    @Override
    public void actionRepair_actionPerformed(ActionEvent e) throws Exception {
        int rowNumber = KDTableUtil.getSelectedRow((KDTable)this.kDTable1);
        IRow row = this.kDTable1.getRow(rowNumber);
        if (row == null) {
            return;
        }
        String column13 = (String)row.getCell("column13").getValue();
        UIContext uiContextVoucher = new UIContext((Object)this);
        uiContextVoucher.put((Object)"ID", (Object)column13.trim());
        uiContextVoucher.put((Object)"company", (Object)((CompanyOrgUnitInfo)this.getUIContext().get("company")));
        uiContextVoucher.put((Object)"NOTLICHA", (Object)"NOTLICHA");
        IUIWindow uiWindowVoucher = HGRepairToolUI.getUI((CoreUIObject)this, VoucherInfo.getEditUIName(), (Map)uiContextVoucher);
        uiWindowVoucher.show();
        String voucherNumber = (String)row.getCell("voucherNumber").getValue();
        String companyName = (String)row.getCell("companyName").getValue();
        String companyNumber = (String)row.getCell("companyNumber").getValue();
        String accountViewNumber = (String)row.getCell("accountViewNumber").getValue();
        String accountViewName = (String)row.getCell("accountViewName").getValue();
        String period = (String)row.getCell("period").getValue();
        String varid = (String)row.getCell("varid").getValue();
        String hgid = (String)row.getCell("hgid").getValue();
        String column9 = (String)row.getCell("column9").getValue();
        String column10 = (String)row.getCell("column10").getValue();
        String column11 = (String)row.getCell("column11").getValue();
        String column12 = (String)row.getCell("column12").getValue();
        String column14 = (String)row.getCell("column14").getValue();
        String column15 = (String)row.getCell("column15").getValue();
        String column16 = (String)row.getCell("column16").getValue();
        RepairData repairData = new RepairData(voucherNumber, companyName, companyNumber, accountViewNumber, accountViewName, period, varid, hgid, column9, column10, column11, column12, column13, column14, column15, column16);
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"param", (Object)repairData);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RepairlUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public static IUIWindow getUI(CoreUIObject parentUI, String className, Map newContext) throws Exception {
        HGRepairToolUI.fetchCompany(newContext);
        String mode = null;
        mode = parentUI.getUIWindow() instanceof UINewFrame ? "com.kingdee.eas.base.uiframe.client.UINewFrameFactory" : "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        return UIFactory.createUIFactory((String)mode).create(className, newContext, null, "FINDVIEW");
    }

    protected static void fetchCompany(Map uiContext) throws BOSException, EASBizException {
        String companyId = (String)uiContext.get("companyId");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)uiContext.get("company");
        if (companyId == null) {
            if (company == null) {
                company = SysContext.getSysContext().getCurrentFIUnit();
                company = HGRepairToolUI.getCompanyById(company.getId().toString());
            }
            companyId = company.getId().toString();
        } else if (company == null || !company.getId().toString().equals(companyId)) {
            company = HGRepairToolUI.getCompanyById(companyId);
        }
        String accountTableId = (String)uiContext.get("accountTableId");
        String accountPeriodTypeId = (String)uiContext.get("accountPeriodTypeId");
        if (accountTableId != null) {
            company.getAccountTable().setId(BOSUuid.read((String)accountTableId));
        }
        if (accountPeriodTypeId != null) {
            company.getAccountPeriodType().setId(BOSUuid.read((String)accountPeriodTypeId));
        }
        uiContext.put("companyId", companyId);
        uiContext.put("company", company);
    }

    private static CompanyOrgUnitInfo getCompanyById(String companyId) throws BOSException, EASBizException {
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        return companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
    }

    private void fillTable(IRowSet rs) throws SQLException {
        this.kDTable1.removeRows();
        while (rs.next()) {
            IRow row = this.kDTable1.addRow();
            row.getCell("companyNumber").setValue((Object)rs.getString("companyNumber"));
            row.getCell("companyName").setValue((Object)rs.getString("companyName"));
            row.getCell("accountViewNumber").setValue((Object)rs.getString("accountViewNumber"));
            row.getCell("accountViewName").setValue((Object)rs.getString("accountViewName"));
            row.getCell("period").setValue((Object)rs.getString("period"));
            row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
            row.getCell("varid").setValue((Object)rs.getString("varid"));
            row.getCell("hgid").setValue((Object)rs.getString("hgid"));
            row.getCell("column9").setValue((Object)rs.getString("varid"));
            row.getCell("column10").setValue((Object)rs.getString("hgasstaccountid"));
            row.getCell("column11").setValue((Object)rs.getString("avid"));
            row.getCell("column12").setValue((Object)rs.getString("currencyID"));
            row.getCell("column13").setValue((Object)rs.getString("vid"));
            StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"223_HGRepairToolUI"));
            sb.append(rs.getString("fseq"));
            row.getCell("column14").setValue((Object)sb.toString());
            StringBuffer sb1 = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"224_HGRepairToolUI"));
            sb1.append(rs.getShort("fassSeq"));
            row.getCell("column15").setValue((Object)sb1.toString());
            row.getCell("column16").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"225_HGRepairToolUI"));
        }
    }

    private HGRepairQueryCondition getHGRepairQueryCondition() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"226_HGRepairToolUI"));
            SysUtil.abort();
        }
        HGRepairQueryCondition hqc = new HGRepairQueryCondition();
        hqc.setCompangIds(HGRepairUtils.getF7Ids(this.prmtCompany));
        if (this.prmtAccount.getValue() != null) {
            hqc.setAccountViewIDs(HGRepairUtils.getF7Ids(this.prmtAccount));
        }
        if (this.prmtPeriod.getValue() != null) {
            hqc.setPeriodId(HGRepairUtils.getId(this.prmtPeriod));
        }
        hqc.setVoucherNumber(this.tfVoucherNumer.getText());
        return hqc;
    }
}

