/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.fi.gl.client.AbstractInitAccountSelectUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

public class InitAccountSelectUI
extends AbstractInitAccountSelectUI {
    private final String COLUMN_SELECTED = "selected";
    private final String COLUMN_ACCOUNTNUMBER = "accountNumber";
    private final String COLUMN_ACCOUNTNAME = "accountName";
    AccountViewCollection accounts = null;
    KDTDefaultCellEditor cbEditor = null;
    ActionListener myActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(InitAccountSelectUI.this.btnOK)) {
                InitAccountSelectUI.this.confirm();
            } else {
                InitAccountSelectUI.this.cancel();
            }
        }
    };
    JDialog dialog = null;

    public InitAccountSelectUI(JDialog dialog) throws Exception {
        this.initUIContentLayout();
        this.setDialog(dialog);
        this.init();
    }

    public void init() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("accountName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("accountNumber").getStyleAttributes().setLocked(true);
        KDCheckBox cb = new KDCheckBox();
        this.cbEditor = new KDTDefaultCellEditor((JCheckBox)cb);
        this.tblMain.getColumn("selected").setEditor((ICellEditor)this.cbEditor);
        this.btnOK.addActionListener(this.myActionListener);
        this.btnCancel.addActionListener(this.myActionListener);
        this.kdSelectAll.setEnabled(true);
        this.kdClearAll.setEnabled(true);
    }

    public void setType(String type) {
        if ("close".equals(type)) {
            this.lblPromptClose.setVisible(true);
            this.lblPromptCancel.setVisible(false);
        } else {
            this.lblPromptClose.setVisible(false);
            this.lblPromptCancel.setVisible(true);
        }
    }

    public void setAccounts(AccountViewCollection col) {
        this.accounts = col;
        this.loadData();
    }

    private void setDialog(JDialog dialog) {
        this.dialog = dialog;
        this.setPreferredSize(new Dimension(556, 359));
        dialog.setSize(560, 420);
    }

    private void loadData() {
        this.tblMain.removeRows();
        for (int i = 0; i < this.accounts.size(); ++i) {
            IRow row = this.tblMain.addRow();
            row.getCell("selected").setValue((Object)Boolean.TRUE);
            row.getCell("accountNumber").setValue((Object)this.accounts.get(i).getNumber());
            row.getCell("accountName").setValue((Object)this.accounts.get(i).getName());
        }
    }

    private void confirm() {
        int count = this.accounts.size();
        AccountViewCollection result = new AccountViewCollection();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell("selected").getValue().equals(Boolean.TRUE)) continue;
            result.add(this.accounts.get(i));
        }
        this.firePropertyChange("account", null, result);
        this.accounts = null;
        this.dialog.dispose();
    }

    private void cancel() {
        this.accounts = null;
        this.dialog.dispose();
    }

    @Override
    public void selectAllAction_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    public void clearAllAction_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell("selected").setValue((Object)select);
        }
    }
}

