/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.DlgShowListener;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.util.client.MsgBoxStatisticsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;

public class InitClientHelp {
    public static final Color COLOR_UNEDITABLE_ENTIRE = new Color(0xD9D9D2);
    public static final Color COLOR_UNEDITABLE_TEMP = new Color(0xE8E8E3);
    public static final Color COLOR_UNEDITABLE_ASS = new Color(16119270);
    public static final Color COLOR_SELECTED = new Color(2515368);
    public static final Color COLOR_SUM_DAY = new Color(16119270);
    public static final Color COLOR_TOTAL_DAY = new Color(15769054);
    public static final Color COLOR_TOTAL_PERIOD = new Color(15262923);
    public static final Color COLOR_TOTAL_YEAR = new Color(15327928);
    public static final int LINETYPE_INIT = -6;
    public static final int LINETYPE_BEGINBALANCE = -3;
    public static final int LINETYPE_VOUCHER = 0;
    public static final int LINETYPE_MONTHTOTAL = 3;
    public static final int LINETYPE_YEARTOTAL = 6;
    public static final int LINETYPE_TOTAL = 9;
    public static final String STORE_KEY = "store_status";
    public static final String STORE_UNSTORED = "unstored";
    public static final String STORE_STORED = "stored";
    public static final BigDecimal zero = BigDecimal.valueOf(0L);
    public static final BigDecimal one = BigDecimal.valueOf(1L);
    public static final BigDecimal negone = BigDecimal.valueOf(-1L);
    private static final String INITRESOURCE = "com.kingdee.eas.fi.gl.client.InitResource";

    public static void setIcon(KDMenuItem item, String name) {
        Icon icon = EASResource.getIcon((String)name);
        item.setIcon(icon);
    }

    public static void setIcon(JButton btn, String name) {
        Icon icon = EASResource.getIcon((String)name);
        btn.setIcon(icon);
    }

    public static void setAmountGroupUse(KDTable table, ICellEditor editor, int scale) {
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            IColumn col = table.getColumn(i);
            if (col.getEditor() == null || !col.getEditor().equals(editor)) continue;
            col.getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(scale));
        }
    }

    public static void setAmountGroupUseWithTrim(KDTable table, ICellEditor editor, int scale) {
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            IColumn col = table.getColumn(i);
            if (col.getEditor() == null || !col.getEditor().equals(editor)) continue;
            col.getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(scale));
        }
    }

    public static void setAmountGroupUse(IColumn column, CurrencyInfo currency, CompanyOrgUnitInfo company) {
        if (column == null) {
            return;
        }
        int precision = currency.isGeneralLocalCurrency() ? company.getBaseCurrency().getPrecision() : (currency.isGeneralReportCurrency() ? company.getReportCurrency().getPrecision() : currency.getPrecision());
        column.getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(precision));
    }

    public static KDFormattedTextField enhanceScaleFormattedTextField(KDFormattedTextField ftf) {
        EnhanceScaleFormattedTextField myFTF = new EnhanceScaleFormattedTextField();
        myFTF.setDataType(ftf.getDataType());
        myFTF.setScaleType(0);
        return myFTF;
    }

    public static KDFormattedTextField enhanceScaleFormattedTextField(KDFormattedTextField ftf, int scaleType) {
        EnhanceScaleFormattedTextField myFTF = new EnhanceScaleFormattedTextField();
        myFTF.setDataType(ftf.getDataType());
        myFTF.setScaleType(scaleType);
        return myFTF;
    }

    public static void setFormattedTextFieldScale(KDFormattedTextField ftf, int scale) {
        if (ftf instanceof EnhanceScaleFormattedTextField) {
            ((EnhanceScaleFormattedTextField)ftf).setScale(scale);
        }
    }

    public static void setFormattedTextFieldRoundingMode(KDFormattedTextField ftf, int mode) {
        if (ftf instanceof EnhanceScaleFormattedTextField) {
            ((EnhanceScaleFormattedTextField)ftf).setRoundingMode(mode);
        }
    }

    public static String nvl(String s1, String s2) {
        return s1 == null ? s2 : s1;
    }

    public static BigDecimal nvl(BigDecimal b1, BigDecimal b2) {
        return b1 == null ? b2 : b1;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        BigDecimal ret = null;
        if (obj == null) {
            return null;
        }
        if (obj.equals("")) {
            ret = new BigDecimal("0");
        } else if (obj instanceof BigDecimal) {
            ret = (BigDecimal)obj;
        } else if (obj instanceof String) {
            ret = new BigDecimal((String)obj);
        }
        return ret;
    }

    public static String getBigDecimalTrim0(BigDecimal bd) {
        if (bd == null) {
            return "";
        }
        String temp = bd.toString();
        int dot = temp.indexOf(".");
        if (dot == -1) {
            return temp;
        }
        int pos = -1;
        for (int i = temp.length() - 1; i > dot; --i) {
            if (temp.charAt(i) == '0') continue;
            pos = i + 1;
            break;
        }
        if (pos != -1) {
            return temp.substring(0, pos);
        }
        return temp.substring(0, dot);
    }

    public static String getPeriodTitle(int year, int period) {
        String ret = null;
        MessageFormat mf = new MessageFormat(EASResource.getString((String)INITRESOURCE, (String)"periodformat"));
        ret = mf.format(new String[]{Integer.toString(year), Integer.toString(period)});
        return ret;
    }

    public static String getPeriodToTitle(int yearFrom, int periodFrom, int yearTo, int periodTo) {
        String ret = null;
        MessageFormat mf = new MessageFormat(EASResource.getString((String)INITRESOURCE, (String)"periodtoformat"));
        ret = mf.format(new String[]{Integer.toString(yearFrom), Integer.toString(periodFrom), Integer.toString(yearTo), Integer.toString(periodTo)});
        return ret;
    }

    public static String getPeriodToTitle(int yearFrom, int periodFrom, int periodTo) {
        String ret = null;
        MessageFormat mf = new MessageFormat(EASResource.getString((String)INITRESOURCE, (String)"periodtoshortformat"));
        ret = mf.format(new String[]{Integer.toString(yearFrom), Integer.toString(periodFrom), Integer.toString(periodTo)});
        return ret;
    }

    public static String getPeriodTitle2(int yearFrom, int periodFrom, int yearTo, int periodTo) {
        String ret = null;
        if (yearFrom == yearTo && periodFrom == periodTo && yearFrom == -1) {
            return "";
        }
        ret = yearFrom == yearTo && periodFrom == periodTo ? InitClientHelp.getPeriodTitle(yearFrom, periodFrom) : (yearFrom == yearTo ? InitClientHelp.getPeriodToTitle(yearFrom, periodFrom, yearTo, periodTo) : (yearTo < 0 && periodTo < 0 ? InitClientHelp.getPeriodTitle(yearFrom, periodFrom) : InitClientHelp.getPeriodToTitle(yearFrom, periodFrom, yearTo, periodTo)));
        return ret;
    }

    public static String getPeriodTitle(int yearFrom, int periodFrom, int yearTo, int periodTo) {
        String ret = null;
        if (yearFrom == yearTo && periodFrom == periodTo && yearFrom == -1) {
            return "";
        }
        ret = yearFrom == yearTo && periodFrom == periodTo ? InitClientHelp.getPeriodTitle(yearFrom, periodFrom) : (yearFrom == yearTo ? InitClientHelp.getPeriodToTitle(yearFrom, periodFrom, periodTo) : (yearTo < 0 && periodTo < 0 ? InitClientHelp.getPeriodTitle(yearFrom, periodFrom) : InitClientHelp.getPeriodToTitle(yearFrom, periodFrom, yearTo, periodTo)));
        return ret;
    }

    public static String getPeriodTitle(PeriodInfo period) {
        return InitClientHelp.getPeriodTitle(period.getPeriodYear(), period.getPeriodNumber());
    }

    public static String getPeriodTitle(PeriodInfo from, PeriodInfo to) {
        return InitClientHelp.getPeriodTitle(from.getPeriodYear(), from.getPeriodNumber(), to.getPeriodYear(), to.getPeriodNumber());
    }

    public static String getDateTitle(Date date) {
        String ret = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        ret = "" + cal.get(1) + EASResource.getString((String)INITRESOURCE, (String)"Year") + (cal.get(2) + 1) + EASResource.getString((String)INITRESOURCE, (String)"Month") + cal.get(5) + EASResource.getString((String)INITRESOURCE, (String)"Day");
        return ret;
    }

    public static String getDateTitle(Date from, Date to) {
        if (to == null || from.compareTo(to) == 0) {
            return InitClientHelp.getDateTitle(from);
        }
        return InitClientHelp.getDateTitle(from) + EASResource.getString((String)INITRESOURCE, (String)"Seperator") + InitClientHelp.getDateTitle(to);
    }

    public static String getTitleDebit() {
        return EASResource.getString((String)INITRESOURCE, (String)"debit");
    }

    public static String getTitleCredit() {
        return EASResource.getString((String)INITRESOURCE, (String)"credit");
    }

    public static String getTitlePing() {
        return EASResource.getString((String)INITRESOURCE, (String)"ping");
    }

    public static void setTableKeyBoardManager(final KDTable table) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KDTEditManager em = table.getEditManager();
                int result = em.stopEditing();
                if (0 != result) {
                    return;
                }
                KDTSelectManager sm = table.getSelectManager();
                int rowIndex = sm.getActiveRowIndex();
                int colIndex = sm.getActiveColumnIndex();
                int rowCount = table.getRowCount();
                int colCount = table.getColumnCount();
                for (int nextRowIndex = rowIndex; nextRowIndex < rowCount; ++nextRowIndex) {
                    IRow row = table.getRow(nextRowIndex);
                    if (row == null) {
                        return;
                    }
                    for (int i = colIndex + 1; i < colCount; ++i) {
                        StyleAttributes sa = row.getCell(i).getStyleAttributes();
                        if (sa.isHided() || sa.isLocked()) continue;
                        em.editCellAt(nextRowIndex, i);
                        return;
                    }
                    colIndex = -1;
                }
            }
        };
        ActionMap actionMap = table.getActionMap();
        actionMap.put("FocusChangeRow", action);
        actionMap.put("FocusChangeCol", action);
        actionMap.put("Delete", null);
        actionMap.put("Copy", null);
        actionMap.put("Paste", null);
        actionMap.put("Cut", null);
        actionMap.put("BeginEdit", null);
    }

    public static CompanyOrgUnitInfo getCurrentCompany() throws BOSException, EASBizException {
        return InitClientHelp.getCurrentCompany(true);
    }

    public static CompanyOrgUnitInfo getCurrentCompany(boolean mustBizUnit) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        if (SysContext.getSysContext().getCurrentFIUnit() == null) {
            throw new OrgException(OrgException.NOT_NULL_ORGUNIT);
        }
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        SelectorItemCollection sic = GlUtils.getCompanySic();
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)), sic);
            if (company == null) {
                throw new GLException(GLException.NOCOMPANY);
            }
        }
        catch (Exception e) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (mustBizUnit && GlUtils.isCompanyUnion(company)) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return company;
    }

    public static String getCuID() {
        return SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    public static String getCompanyID() {
        return SysContext.getSysContext().getCurrentFIUnit().getId().toString();
    }

    public static int showModifyConfirm(Component owner) {
        String RESOURCE_PATH = INITRESOURCE;
        String confirmModify = EASResource.getString((String)RESOURCE_PATH, (String)"confirmModify");
        return MsgBox.showConfirm3((Component)owner, (String)confirmModify);
    }

    public static int showDeleteConfirm(Component owner) {
        String RESOURCE_PATH = INITRESOURCE;
        String confirmDelete = EASResource.getString((String)RESOURCE_PATH, (String)"confirmDelete");
        return MsgBox.showConfirm2((Component)owner, (String)confirmDelete);
    }

    public static int showModifyConfirmBeforeExit(Component owner) {
        return MsgBox.showConfirm3((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
    }

    public static Date convertToSimpleDate(Date date) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = f.parse(f.format(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static byte[] dumpObject(Object object) throws Exception {
        byte[] ret = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        ret = baos.toByteArray();
        return ret;
    }

    public static Frame getFrameAncestor(Component c) {
        for (Component p = c; p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    public static void centerWindow(Window window) {
        CtrlSwingUtilities.centerWindow((Window)window);
    }

    public static SystemStatusCtrolCollection checkIsAlia(PeriodInfo period, CompanyOrgUnitInfo curCompany) throws EASBizException, BOSException {
        Integer iYear = new Integer(period.getPeriodYear());
        Integer iMonth = new Integer(period.getPeriodNumber());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)curCompany.getId().toString()));
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue()), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("isStart", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isRelatedAccount", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("relatedPeriod.periodYear", (Object)iYear));
        fic.add(new FilterItemInfo("relatedPeriod.periodNumber", (Object)iMonth));
        filter.setMaskString("#0 and #1 and #2 and #3  and #4 and #5");
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getRemoteInstance();
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        return col;
    }

    public static void updateAlia(SystemStatusCtrolInfo info) throws EASBizException, BOSException {
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getRemoteInstance();
        info.setIsRelatedAccount(false);
        info.setRelatedPeriod(null);
        ctrl.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    public static void updateAliaCollection(SystemStatusCtrolCollection infoCollection) throws EASBizException, BOSException {
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getRemoteInstance();
        if (infoCollection != null && infoCollection.size() > 0) {
            for (SystemStatusCtrolInfo info : infoCollection) {
                info.setIsRelatedAccount(false);
                info.setRelatedPeriod(null);
                ctrl.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
        }
    }

    public static AccountTableCollection getAccountTableCollection() throws BOSException {
        ArrayList<String> tableIdList = new ArrayList<String>();
        IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
        EntityViewInfo eviForCtrl = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        eviForCtrl.setFilter(filter);
        eviForCtrl.getSelector().add("accountTableID.*");
        Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(eviForCtrl);
        if (acctCtrlCols != null) {
            int count = acctCtrlCols.size();
            for (int i = 0; i < count; ++i) {
                Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        IAccountTable iAccountTable = AccountTableFactory.getRemoteInstance();
        AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
        AccountTableCollection tableInfosNew = new AccountTableCollection();
        for (AccountTableInfo tableInfo : tableInfos) {
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            tableInfosNew.add(tableInfo);
        }
        return tableInfosNew;
    }

    public static int showOptionConfirm(Component comp, String msg, String[] options) {
        MsgBoxStatisticsUtil.send((Component)comp, (String)msg, (int)5);
        AdvMsgBox msgBox = new AdvMsgBox((Frame)ComponentUtil.getOwnerWindow((Component)comp), EASResource.getString((String)"promotInfoBox"), msg, null, options, 3, 1);
        DlgShowListener listener = new DlgShowListener((Component)msgBox);
        msgBox.addWindowListener((WindowListener)listener);
        msgBox.show();
        return msgBox.getResult();
    }

    public static CompanyOrgUnitInfo getCompany(String companyid, boolean mustBizUnit) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        SelectorItemCollection sic = GlUtils.getCompanySic();
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyid)), sic);
            if (company == null) {
                throw new GLException(GLException.NOCOMPANY);
            }
        }
        catch (Exception e) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (mustBizUnit && GlUtils.isCompanyUnion(company)) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return company;
    }

    public static class ScaleHelp {
        int scale;

        public void setScale(int scale) {
            this.scale = scale;
        }

        public BigDecimal getScaleBigDecimal(BigDecimal obj) {
            if (obj != null) {
                obj = obj.setScale(this.scale, 4);
            }
            return obj;
        }

        public BigDecimal getScaleBigDecimal(Object obj) {
            BigDecimal ret = InitClientHelp.toBigDecimal(obj);
            return this.getScaleBigDecimal(ret);
        }

        public BigDecimal getScaleBigDecimalTrim0(BigDecimal obj) {
            if (obj != null) {
                obj = obj.setScale(this.scale, 4);
                obj = new BigDecimal(InitClientHelp.getBigDecimalTrim0(obj));
            }
            return obj;
        }

        public BigDecimal getScaleBigDecimalTrim0(Object obj) {
            BigDecimal ret = InitClientHelp.toBigDecimal(obj);
            return this.getScaleBigDecimalTrim0(ret);
        }

        public BigDecimal getScaleBigDecimalNvl(Object obj) {
            BigDecimal ret = this.getScaleBigDecimal(obj);
            return InitClientHelp.nvl(ret, zero);
        }

        public BigDecimal getScaleBigDecimalTrim0Nvl(Object obj) {
            BigDecimal ret = this.getScaleBigDecimalTrim0(obj);
            return InitClientHelp.nvl(ret, zero);
        }
    }

    private static class EnhanceScaleFormattedTextField
    extends KDFormattedTextField {
        private int scale = -1;
        private int roundingMode = 4;
        private int scaleType = 0;

        private EnhanceScaleFormattedTextField() {
        }

        public int getScale() {
            return this.scale;
        }

        public void setScale(int i) {
            this.scale = i;
            this.setPrecision(this.scale);
        }

        public void setValue(Object value) {
            if (this.scale != -1 && BigDecimal.class.isInstance(value)) {
                BigDecimal bd = ((BigDecimal)value).setScale(this.scale, this.getRoundingMode());
                if (this.scaleType == 1) {
                    value = new BigDecimal(InitClientHelp.getBigDecimalTrim0(bd));
                }
            }
            super.setValue(value);
        }

        public Object getValue() {
            Object obj = super.getValue();
            if (obj instanceof Number) {
                BigDecimal bd = new BigDecimal(obj.toString()).setScale(this.scale, this.getRoundingMode());
                if (this.scaleType == 1) {
                    bd = new BigDecimal(InitClientHelp.getBigDecimalTrim0(bd));
                }
                return bd;
            }
            return obj;
        }

        public int getRoundingMode() {
            return this.roundingMode;
        }

        public void setRoundingMode(int i) {
            this.roundingMode = i;
        }

        public int getScaleType() {
            return this.scaleType;
        }

        public void setScaleType(int i) {
            this.scaleType = i;
            if (i == 0) {
                this.setGroupingUsed(true);
            }
        }
    }

    public static final class IconHelp {
        public static final String ADDNEW = "imgTbtn_new";
        public static final String DELETE = "imgTbtn_delete";
        public static final String VIEW = "imgTbtn_view";
        public static final String EDIT = "imgTbtn_edit";
        public static final String REFRESH = "imgTbtn_refresh";
        public static final String FILTER = "imgTbtn_filter";
        public static final String SAVE = "imgTbtn_save";
        public static final String ADDLINE = "imgTbtn_addline";
        public static final String DELETELINE = "imgTbtn_deleteline";
        public static final String PRINT = "imgTbtn_print";
        public static final String PREVIEW = "imgTbtn_preview";
        public static final String CLOSEINIT = "imgTbtn_closeinitialize";
        public static final String CLOSEALLINIT = "imgTbtn_allfinishinitialize";
        public static final String CANCELINIT = "imgTbtn_finitialize";
        public static final String CANCELALLINIT = "imgTbtn_allfinitialize";
        public static final String TRYBALANCE = "imgTbtn_trialbalance";
        public static final String VOUCHER = "imgTbtn_credence";
    }
}

