/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IMCLdgScheme;
import com.kingdee.eas.fi.gl.MCLdgSchemeAcctCollection;
import com.kingdee.eas.fi.gl.MCLdgSchemeAcctInfo;
import com.kingdee.eas.fi.gl.MCLdgSchemeCollection;
import com.kingdee.eas.fi.gl.MCLdgSchemeCyCollection;
import com.kingdee.eas.fi.gl.MCLdgSchemeCyInfo;
import com.kingdee.eas.fi.gl.MCLdgSchemeFactory;
import com.kingdee.eas.fi.gl.MCLdgSchemeInfo;
import com.kingdee.eas.fi.gl.client.AbstractMCLdgSchemaDesignUI;
import com.kingdee.eas.fi.gl.client.MCLdgSchemaSavePromptUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MCLdgSchemaDesignUI
extends AbstractMCLdgSchemaDesignUI {
    private HashMap hmCurIdToRow;
    private boolean dirtySchema;
    private MCLdgSchemeInfo curSchema;
    private CompanyOrgUnitInfo curCompany;
    private boolean fcsu;
    public static final String COL_CUR_SEL = "colSelected";
    public static final String COL_CUR_NUM = "colNumber";
    public static final String COL_CUR_NAME = "colName";
    public static final String COL_ACCT_DC = "colDC";
    public static final String COL_ACCT_NUM = "colNumber";
    public static final String COL_ACCT_NAME = "colName";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.MCLdgSchemaDesignResource";
    protected ChangeListener accountChangeLs = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent evt) {
            AccountViewInfo acct = (AccountViewInfo)MCLdgSchemaDesignUI.this.bpxAccount.getValue();
            if (!GlUtils.isEqual(acct, MCLdgSchemaDesignUI.this.curSchema.getAccount())) {
                if (acct != null) {
                    MCLdgSchemaDesignUI.this.curSchema.setAccount(acct);
                    MCLdgSchemaDesignUI.this.curSchema.setNumber(acct.getNumber());
                    MCLdgSchemaDesignUI.this.curSchema.setName(acct.getLongName());
                }
                MCLdgSchemaDesignUI.this.curSchema.setLevel(-1);
                MCLdgSchemaDesignUI.this.curSchema.getCurrencyCols().clear();
                MCLdgSchemaDesignUI.this.curSchema.getAccountCols().clear();
                MCLdgSchemaDesignUI.this.loadSchema(MCLdgSchemaDesignUI.this.curSchema);
                MCLdgSchemaDesignUI.this.dirtySchema = true;
            }
        }
    };
    protected DocumentListener simpleDocLs = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            MCLdgSchemaDesignUI.this.dirtySchema = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MCLdgSchemaDesignUI.this.dirtySchema = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MCLdgSchemaDesignUI.this.dirtySchema = true;
        }
    };
    protected ChangeListener simpleChangeLs = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent evt) {
            MCLdgSchemaDesignUI.this.dirtySchema = true;
        }
    };
    protected ChangeListener configByLevelLs = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            MCLdgSchemaDesignUI.this.dirtySchema = true;
            if (MCLdgSchemaDesignUI.this.chkConfigByLevel.isSelected()) {
                MCLdgSchemaDesignUI.this.spnLevel.setEnabled(true);
            } else {
                MCLdgSchemaDesignUI.this.spnLevel.setEnabled(false);
            }
        }
    };
    protected KDTEditAdapter tableLs = new KDTEditAdapter(){
        private Object oldValue;

        public void editStarting(KDTEditEvent evt) {
            KDTable table = (KDTable)evt.getSource();
            IRow row = table.getRow(evt.getRowIndex());
            ICell cell = row.getCell(evt.getColIndex());
            this.oldValue = cell.getValue();
            IColumn col = table.getColumn(evt.getColIndex());
            String colKey = col.getKey();
            if (table == MCLdgSchemaDesignUI.this.tblAccount && "colNumber".equals(colKey)) {
                KDBizPromptBox bpx = (KDBizPromptBox)col.getEditor().getComponent();
                AccountViewInfo acct = (AccountViewInfo)MCLdgSchemaDesignUI.this.bpxAccount.getValue();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("company.id", (Object)MCLdgSchemaDesignUI.this.curCompany.getId().toString()));
                fic.add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
                fic.add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
                fic.add(new FilterItemInfo("longNumber", (Object)(acct.getLongNumber() + "!%"), CompareType.LIKE));
                StringBuffer sb = new StringBuffer();
                int n = MCLdgSchemaDesignUI.this.tblAccount.getRowCount();
                for (int i = 0; i < n; ++i) {
                    AccountViewInfo acc = (AccountViewInfo)MCLdgSchemaDesignUI.this.tblAccount.getRow(i).getCell("colNumber").getValue();
                    if (acc == null) continue;
                    sb.append(acc.getId() + ",");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                    fic.add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.NOTINCLUDE));
                    filter.setMaskString("(#0 AND #1 AND #2 AND #3 AND #4)");
                } else {
                    filter.setMaskString("(#0 AND #1 AND #2 AND #3)");
                }
                bpx.setEntityViewInfo(view);
            } else if (table == MCLdgSchemaDesignUI.this.tblCurrency && "colName".equals(colKey) && !Boolean.TRUE.equals(row.getCell(MCLdgSchemaDesignUI.COL_CUR_SEL).getValue())) {
                evt.setCancel(true);
                return;
            }
        }

        public void editStopped(KDTEditEvent evt) {
            KDTable table = (KDTable)evt.getSource();
            IRow row = table.getRow(evt.getRowIndex());
            ICell cell = row.getCell(evt.getColIndex());
            Object newValue = evt.getValue();
            if (!GlUtils.isEqual(newValue, this.oldValue)) {
                if (table == MCLdgSchemaDesignUI.this.tblAccount && "colNumber".equals(MCLdgSchemaDesignUI.this.tblAccount.getColumnKey(evt.getColIndex()))) {
                    AccountViewInfo acct = (AccountViewInfo)newValue;
                    String acctName = null;
                    BalanceDirectionEnum dc = null;
                    if (acct != null) {
                        acctName = acct.getName();
                        dc = acct.getDC();
                    }
                    row.getCell(MCLdgSchemaDesignUI.COL_ACCT_DC).setValue(dc);
                    row.getCell("colName").setValue((Object)acctName);
                }
                MCLdgSchemaDesignUI.this.dirtySchema = true;
            }
        }

        public void editValueChanged(KDTEditEvent evt) {
            KDTable table = (KDTable)evt.getSource();
            if (MCLdgSchemaDesignUI.this.fcsu && table == MCLdgSchemaDesignUI.this.tblCurrency && MCLdgSchemaDesignUI.COL_CUR_SEL.equals(MCLdgSchemaDesignUI.this.tblCurrency.getColumnKey(evt.getColIndex()))) {
                int rowIndex = evt.getRowIndex();
                int n = MCLdgSchemaDesignUI.this.tblCurrency.getRowCount();
                for (int i = 0; i < n; ++i) {
                    if (rowIndex == i) continue;
                    MCLdgSchemaDesignUI.this.tblCurrency.getRow(i).getCell(MCLdgSchemaDesignUI.COL_CUR_SEL).setValue((Object)Boolean.FALSE);
                }
            }
        }
    };
    protected KDTActiveCellListener acctSelectLs = new KDTActiveCellListener(){

        public void activeCellChanged(KDTActiveCellEvent evt) {
            int rowIndex = evt.getRowIndex();
            if (rowIndex >= 0 && rowIndex < MCLdgSchemaDesignUI.this.tblAccount.getRowCount()) {
                MCLdgSchemaDesignUI.this.btnInsertLine.setEnabled(true);
                MCLdgSchemaDesignUI.this.btnRemoveLine.setEnabled(true);
            } else {
                MCLdgSchemaDesignUI.this.btnInsertLine.setEnabled(false);
                MCLdgSchemaDesignUI.this.btnRemoveLine.setEnabled(false);
            }
        }
    };

    public MCLdgSchemaDesignUI() throws Exception {
        this.jbInit();
        this.setPreferredSize(new Dimension(780, 540));
    }

    public void onLoad() throws Exception {
        this.fetchInitData();
        super.onLoad();
        this.loadSchema(this.createNewSchema());
    }

    protected void fetchInitData() throws Exception {
        SysContext ctx = SysContext.getSysContext();
        String curComId = (String)ctx.getProperty((Object)"CurCompanyId");
        this.curCompany = new CompanyOrgUnitInfo();
        this.curCompany.setId(BOSUuid.read((String)curComId));
        Object[] param = new Object[]{curComId};
        IMCLdgScheme schemaCtrl = MCLdgSchemeFactory.getRemoteInstance();
        Object[] initData = schemaCtrl.fetchInitData(param);
        this.fcsu = (Boolean)initData[0];
        MCLdgSchemeCollection schemas = (MCLdgSchemeCollection)((Object)initData[1]);
        CurrencyCollection curs = (CurrencyCollection)initData[2];
        this.initHeaderStyle();
        this.initTableStyle();
        this.fillSchemaTree(schemas);
        this.fillCurrencyTable(curs);
    }

    private void fillSchemaTree(MCLdgSchemeCollection schemas) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        Iterator itrSchema = schemas.iterator();
        while (itrSchema.hasNext()) {
            MCLdgSchemeInfo schema = (MCLdgSchemeInfo)itrSchema.next();
            DefaultKingdeeTreeNode schemaNode = new DefaultKingdeeTreeNode((Object)new SchemaWrapper(schema));
            root.add((MutableTreeNode)schemaNode);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        KDTree tree = new KDTree((TreeModel)model);
        tree.setRootVisible(false);
        this.treeSchema.setTree(tree);
        tree.setShowCheckBox(false);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MCLdgSchemeInfo newSchema;
                if (!MCLdgSchemaDesignUI.this.canLeaveCurSchema()) {
                    return;
                }
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    MCLdgSchemaDesignUI.this.actionRemoveSchema.setEnabled(true);
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    Object obj = node.getUserObject();
                    if (obj instanceof SchemaWrapper) {
                        try {
                            newSchema = ((SchemaWrapper)obj).getSchema();
                            IMCLdgScheme schemaCtrl = MCLdgSchemeFactory.getRemoteInstance();
                            newSchema = (MCLdgSchemeInfo)schemaCtrl.getValue((IObjectPK)new ObjectUuidPK(newSchema.getId()), MCLdgSchemeInfo.getDefaultSelector());
                            node.setUserObject((Object)newSchema);
                        }
                        catch (Exception ex) {
                            String msg = EASResource.getString((String)MCLdgSchemaDesignUI.RESOURCE_PATH, (String)"CANNOT_FETCH_SCHEMA");
                            MsgBox.showWarning((Component)((Object)MCLdgSchemaDesignUI.this), (String)msg);
                            return;
                        }
                    } else {
                        newSchema = (MCLdgSchemeInfo)obj;
                    }
                } else {
                    MCLdgSchemaDesignUI.this.actionRemoveSchema.setEnabled(false);
                    newSchema = MCLdgSchemaDesignUI.this.createNewSchema();
                }
                MCLdgSchemaDesignUI.this.loadSchema(newSchema);
            }
        });
    }

    private void fillCurrencyTable(CurrencyCollection curs) {
        this.hmCurIdToRow = new HashMap();
        for (CurrencyInfo cur : curs) {
            IRow row = this.tblCurrency.addRow();
            this.hmCurIdToRow.put(cur.getId(), row);
            row.getCell(COL_CUR_SEL).setValue((Object)Boolean.FALSE);
            row.getCell("colNumber").setValue((Object)cur);
            row.getCell("colName").setValue((Object)cur.getName());
        }
    }

    protected void initHeaderStyle() {
        this.bpxAccount.setEditable(true);
        this.bpxAccount.setEditFormat("$number$");
        this.bpxAccount.setDisplayFormat("$longName$");
        this.bpxAccount.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        fic.add(new FilterItemInfo("CAA.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
        filter.setMaskString("#0 AND #1 and ((#2 and #3) or #4)");
        this.bpxAccount.setEntityViewInfo(view);
        SelectorItemCollection sicAcct = new SelectorItemCollection();
        sicAcct.add(new SelectorItemInfo("number"));
        sicAcct.add(new SelectorItemInfo("longName"));
        sicAcct.add(new SelectorItemInfo("longNumber"));
        sicAcct.add(new SelectorItemInfo("level"));
        sicAcct.add(new SelectorItemInfo("currencyID.id"));
        this.bpxAccount.setSelectorCollection(sicAcct);
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, this.curCompany, filter, false, false);
        this.bpxAccount.setSelector((KDPromptSelector)apb);
        this.spnLevel.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.btnAutoConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountViewInfo acct = (AccountViewInfo)MCLdgSchemaDesignUI.this.bpxAccount.getValue();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("longNumber", (Object)(acct.getLongNumber() + "!%"), CompareType.LIKE));
                if (MCLdgSchemaDesignUI.this.chkConfigByLevel.isSelected()) {
                    fic.add(new FilterItemInfo("level", (Object)((Integer)MCLdgSchemaDesignUI.this.spnLevel.getValue())));
                } else {
                    fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                }
                filter.setMaskString("(#0 AND #1)");
                SorterItemCollection sorters = view.getSorter();
                sorters.add(new SorterItemInfo("number"));
                SelectorItemCollection sicAcct = view.getSelector();
                sicAcct.add(new SelectorItemInfo("number"));
                sicAcct.add(new SelectorItemInfo("name"));
                sicAcct.add(new SelectorItemInfo("dc"));
                AccountViewCollection acctCol = null;
                try {
                    IAccountView acctCtrl = AccountViewFactory.getRemoteInstance();
                    acctCol = acctCtrl.getAccountViewCollection(view);
                }
                catch (Exception ex) {
                    String msg = EASResource.getString((String)MCLdgSchemaDesignUI.RESOURCE_PATH, (String)"CANNOT_FETCH_DETAILACCT");
                    MsgBox.showWarning((Component)((Object)MCLdgSchemaDesignUI.this), (String)msg);
                    return;
                }
                if (acctCol.size() == 0) {
                    String msg = EASResource.getString((String)MCLdgSchemaDesignUI.RESOURCE_PATH, (String)"NODETAILACCT");
                    MsgBox.showWarning((Component)((Object)MCLdgSchemaDesignUI.this), (String)msg);
                    return;
                }
                MCLdgSchemaDesignUI.this.tblAccount.removeRows();
                for (AccountViewInfo detailAcct : acctCol) {
                    IRow row = MCLdgSchemaDesignUI.this.tblAccount.addRow();
                    row.getCell(MCLdgSchemaDesignUI.COL_ACCT_DC).setValue((Object)detailAcct.getDC());
                    row.getCell("colNumber").setValue((Object)detailAcct);
                    row.getCell("colName").setValue((Object)detailAcct.getName());
                }
            }
        });
    }

    protected void initTableStyle() {
        this.tblCurrency.checkParsed();
        this.tblAccount.checkParsed();
        this.tblCurrency.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblAccount.getIndexColumn().getStyleAttributes().setHided(true);
        KDCheckBox chkSelected = new KDCheckBox();
        KDTDefaultCellEditor boolEditor = new KDTDefaultCellEditor((JCheckBox)chkSelected);
        this.tblCurrency.getColumn(COL_CUR_SEL).setEditor((ICellEditor)boolEditor);
        KDBizPromptBox bpxAcct = new KDBizPromptBox();
        bpxAcct.setEditable(true);
        bpxAcct.setFocusTraversalKeysEnabled(false);
        bpxAcct.setEditFormat("$number$");
        bpxAcct.setDisplayFormat("name");
        bpxAcct.setCommitFormat("$number$");
        bpxAcct.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherAccountQuery");
        SelectorItemCollection sicAcct = new SelectorItemCollection();
        sicAcct.add(new SelectorItemInfo("number"));
        sicAcct.add(new SelectorItemInfo("name"));
        sicAcct.add(new SelectorItemInfo("dc"));
        bpxAcct.setSelectorCollection(sicAcct);
        this.tblAccount.getColumn("colNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bpxAcct));
        KDTextField txtName = new KDTextField();
        KDTDefaultCellEditor txtEditor = new KDTDefaultCellEditor((JTextField)txtName);
        txtEditor.setClickCountToStart(1);
        this.tblCurrency.getColumn("colName").setEditor((ICellEditor)txtEditor);
        this.tblAccount.getColumn("colName").setEditor((ICellEditor)txtEditor);
        Object[] debitOrCredit = new Object[]{BalanceDirectionEnum.DEBIT, BalanceDirectionEnum.CREDIT};
        KDComboBox cbxDC = new KDComboBox(debitOrCredit);
        this.tblAccount.getColumn(COL_ACCT_DC).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxDC));
        ObjectValueRender objNumRender = new ObjectValueRender();
        objNumRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.tblCurrency.getColumn("colNumber").setRenderer((IBasicRender)objNumRender);
        this.tblAccount.getColumn("colNumber").setRenderer((IBasicRender)objNumRender);
    }

    private MCLdgSchemeInfo createNewSchema() {
        MCLdgSchemeInfo schema = new MCLdgSchemeInfo();
        schema.setCompany(this.curCompany);
        schema.setLevel(0);
        return schema;
    }

    private void attachListeners() {
        this.bpxAccount.addChangeListener(this.accountChangeLs);
        this.txtSchemaNumber.getDocument().addDocumentListener(this.simpleDocLs);
        this.txtSchemaName.getDocument().addDocumentListener(this.simpleDocLs);
        this.chkConfigByLevel.addChangeListener(this.configByLevelLs);
        this.spnLevel.addChangeListener(this.simpleChangeLs);
        this.tblCurrency.addKDTEditListener((KDTEditListener)this.tableLs);
        this.tblAccount.addKDTEditListener((KDTEditListener)this.tableLs);
        this.tblAccount.addKDTActiveCellListener(this.acctSelectLs);
    }

    private void detachListeners() {
        this.bpxAccount.removeChangeListener(this.accountChangeLs);
        this.txtSchemaNumber.getDocument().removeDocumentListener(this.simpleDocLs);
        this.txtSchemaName.getDocument().removeDocumentListener(this.simpleDocLs);
        this.chkConfigByLevel.removeChangeListener(this.configByLevelLs);
        this.spnLevel.removeChangeListener(this.simpleChangeLs);
        this.tblCurrency.removeKDTEditListener((KDTEditListener)this.tableLs);
        this.tblAccount.removeKDTEditListener((KDTEditListener)this.tableLs);
        this.tblAccount.removeKDTActiveCellListener(this.acctSelectLs);
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.dirtySchema = true;
        this.ensureTableEditorsClosed(this.tblAccount);
        this.tblAccount.addRow();
    }

    @Override
    protected void btnInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.dirtySchema = true;
        this.ensureTableEditorsClosed(this.tblAccount);
        int rowIndex = this.tblAccount.getSelectManager().getActiveRowIndex();
        this.tblAccount.addRow(rowIndex);
    }

    @Override
    protected void btnRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.dirtySchema = true;
        this.ensureTableEditorsClosed(this.tblAccount);
        KDTSelectManager sm = this.tblAccount.getSelectManager();
        int rowIndex = sm.getActiveRowIndex();
        int colIndex = sm.getActiveColumnIndex();
        this.tblAccount.removeRow(rowIndex);
        if (rowIndex >= 0 && rowIndex < this.tblAccount.getRowCount()) {
            sm.select(rowIndex, colIndex);
        } else {
            sm.removeAll();
        }
    }

    @Override
    public void actionNewSchema_actionPerformed(ActionEvent e) throws Exception {
        this.treeSchema.getTree().clearSelection();
    }

    @Override
    public void actionRemoveSchema_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"PROMPTDELETE"));
        if (result != 0) {
            return;
        }
        try {
            this.ensureEditorsClosed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IMCLdgScheme schemaCtrl = MCLdgSchemeFactory.getRemoteInstance();
        schemaCtrl.delete((IObjectPK)new ObjectUuidPK(this.curSchema.getId()));
        KDTree tree = this.treeSchema.getTree();
        DefaultKingdeeTreeNode nodeToDelete = (DefaultKingdeeTreeNode)tree.getSelectionPath().getLastPathComponent();
        tree.clearSelection();
        tree.removeNodeFromParent((MutableTreeNode)nodeToDelete);
    }

    @Override
    public void actionSaveSchema_actionPerformed(ActionEvent e) throws Exception {
        this.ensureEditorsClosed();
        this.storeCurSchema();
        this.checkCurSchema();
        this.saveSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSchema() throws Exception {
        boolean isNew = this.curSchema.getId() == null;
        try {
            IMCLdgScheme schemaCtrl = MCLdgSchemeFactory.getRemoteInstance();
            IObjectPK pk = schemaCtrl.submit((CoreBaseInfo)this.curSchema);
            this.curSchema.setId(BOSUuid.read((String)pk.toString()));
            KDTree tree = this.treeSchema.getTree();
            if (isNew) {
                DefaultKingdeeTreeNode node;
                Object obj;
                MCLdgSchemeInfo schema;
                TreeModel treeModel = tree.getModel();
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
                Enumeration enums = root.children();
                int index = 0;
                while (enums.hasMoreElements() && (schema = (obj = (node = (DefaultKingdeeTreeNode)enums.nextElement()).getUserObject()) instanceof SchemaWrapper ? ((SchemaWrapper)obj).getSchema() : (MCLdgSchemeInfo)obj).getNumber().compareTo(this.curSchema.getNumber()) <= 0) {
                    ++index;
                }
                DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)this.curSchema);
                tree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)root, index);
                this.dirtySchema = false;
                tree.setSelectionNode(newNode);
            } else {
                TreePath path = tree.getSelectionPath();
                DefaultKingdeeTreeNode nodeToUpdate = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                nodeToUpdate.setUserObject((Object)this.curSchema);
                this.treeSchema.getTree().getModel().valueForPathChanged(path, this.curSchema);
            }
        }
        finally {
            this.loadSchema(this.curSchema);
        }
    }

    @Override
    public void actionSaveSchemaAs_actionPerformed(ActionEvent e) throws Exception {
        this.ensureEditorsClosed();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.MCLdgSchemaSavePromptUI", (Map)uiContext, null, null);
        uiWindow.show();
        MCLdgSchemaSavePromptUI promptUI = (MCLdgSchemaSavePromptUI)uiWindow.getUIObject();
        if (promptUI.result == 1) {
            MCLdgSchemeInfo oldSchema = this.curSchema;
            try {
                this.curSchema = (MCLdgSchemeInfo)oldSchema.clone();
                this.storeCurSchema();
                this.curSchema.setId(null);
                this.curSchema.setNumber(promptUI.getSchemaNumber());
                this.curSchema.setName(promptUI.getSchemaName());
                Iterator itrCur = this.curSchema.getCurrencyCols().iterator();
                while (itrCur.hasNext()) {
                    MCLdgSchemeCyInfo curInfo = (MCLdgSchemeCyInfo)itrCur.next();
                    curInfo.setId(null);
                }
                Iterator itrAcct = this.curSchema.getAccountCols().iterator();
                while (itrAcct.hasNext()) {
                    MCLdgSchemeAcctInfo acctInfo = (MCLdgSchemeAcctInfo)itrAcct.next();
                    acctInfo.setId(null);
                }
                this.checkCurSchema();
                this.saveSchema();
            }
            catch (Exception ex) {
                this.curSchema = oldSchema;
                throw ex;
            }
        }
    }

    private boolean canLeaveCurSchema() {
        try {
            this.ensureEditorsClosed();
        }
        catch (Exception ex) {
            return false;
        }
        if (this.dirtySchema) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"PROMPTSAVE"));
            if (result == 0) {
                ActionEvent saveEvt = new ActionEvent(this.btnSaveSchema, 1001, this.btnSaveSchema.getActionCommand());
                try {
                    this.actionSaveSchema_actionPerformed(saveEvt);
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                    return false;
                }
                return true;
            }
            return result == 1;
        }
        return true;
    }

    private void loadSchema(MCLdgSchemeInfo schema) {
        IRow row;
        this.detachListeners();
        AccountViewInfo acct = schema.getAccount();
        this.bpxAccount.setValue((Object)acct);
        this.txtSchemaNumber.setText(schema.getNumber());
        this.txtSchemaName.setText(schema.getName());
        CurrencyInfo curAcct = null;
        if (acct == null) {
            this.txtSchemaNumber.setEnabled(false);
            this.txtSchemaName.setEnabled(false);
            this.chkConfigByLevel.setEnabled(false);
            this.btnAutoConfig.setEnabled(false);
            this.tblCurrency.getStyleAttributes().setLocked(true);
            this.tblAccount.getStyleAttributes().setLocked(true);
            this.btnAddLine.setEnabled(false);
        } else {
            this.txtSchemaNumber.setEnabled(true);
            this.txtSchemaName.setEnabled(true);
            this.chkConfigByLevel.setEnabled(true);
            this.btnAutoConfig.setEnabled(true);
            this.tblCurrency.getStyleAttributes().setLocked(false);
            this.tblAccount.getStyleAttributes().setLocked(false);
            this.btnAddLine.setEnabled(true);
            curAcct = acct.getCurrencyID();
            if (curAcct != null) {
                this.tblCurrency.getColumn(COL_CUR_SEL).getStyleAttributes().setLocked(true);
            } else {
                this.tblCurrency.getColumn(COL_CUR_SEL).getStyleAttributes().setLocked(false);
            }
            this.tblCurrency.getColumn("colNumber").getStyleAttributes().setLocked(true);
        }
        if (schema.getLevel() > 0) {
            this.chkConfigByLevel.setSelected(true);
            this.spnLevel.setEnabled(true);
            this.spnLevel.setValue((Object)new Integer(schema.getLevel()));
        } else {
            this.chkConfigByLevel.setSelected(false);
            this.spnLevel.setEnabled(false);
            this.spnLevel.setValue((Object)new Integer(1));
        }
        int n = this.tblCurrency.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblCurrency.getRow(i);
            row.getCell(COL_CUR_SEL).setValue((Object)Boolean.FALSE);
            CurrencyInfo cur = (CurrencyInfo)row.getCell("colNumber").getValue();
            row.getCell("colName").setValue((Object)cur.getName());
        }
        if (curAcct == null) {
            Iterator itrCur = schema.getCurrencyCols().iterator();
            while (itrCur.hasNext()) {
                MCLdgSchemeCyInfo curInfo = (MCLdgSchemeCyInfo)itrCur.next();
                row = (IRow)this.hmCurIdToRow.get(curInfo.getCurrency().getId());
                row.getCell(COL_CUR_SEL).setValue((Object)Boolean.TRUE);
                row.getCell("colName").setValue((Object)curInfo.getCurrencyColName());
            }
        } else {
            BOSUuid curId = curAcct.getId();
            int n2 = this.tblCurrency.getRowCount();
            for (int i = 0; i < n2; ++i) {
                IRow row2 = this.tblCurrency.getRow(i);
                if (((CurrencyInfo)row2.getCell("colNumber").getValue()).getId().equals((Object)curId)) {
                    row2.getCell(COL_CUR_SEL).setValue((Object)Boolean.TRUE);
                    continue;
                }
                row2.getCell(COL_CUR_SEL).setValue((Object)Boolean.FALSE);
            }
            Iterator itrCur = schema.getCurrencyCols().iterator();
            while (itrCur.hasNext()) {
                MCLdgSchemeCyInfo curInfo = (MCLdgSchemeCyInfo)itrCur.next();
                BOSUuid cid = curInfo.getCurrency().getId();
                if (!cid.equals((Object)curId)) continue;
                IRow row3 = (IRow)this.hmCurIdToRow.get(cid);
                row3.getCell("colName").setValue((Object)curInfo.getCurrencyColName());
                break;
            }
        }
        this.tblAccount.removeRows();
        Iterator itrAcct = schema.getAccountCols().iterator();
        while (itrAcct.hasNext()) {
            MCLdgSchemeAcctInfo acctInfo = (MCLdgSchemeAcctInfo)itrAcct.next();
            IRow row4 = this.tblAccount.addRow();
            row4.getCell(COL_ACCT_DC).setValue((Object)acctInfo.getDc());
            row4.getCell("colNumber").setValue((Object)acctInfo.getAccount());
            row4.getCell("colName").setValue((Object)acctInfo.getAccountColName());
        }
        this.tblAccount.getSelectManager().removeAll(false);
        this.btnInsertLine.setEnabled(false);
        this.btnRemoveLine.setEnabled(false);
        this.curSchema = schema;
        this.dirtySchema = false;
        this.attachListeners();
    }

    private void checkCurSchema() throws Exception {
        if (this.curSchema.getAccount() == null) {
            this.breakOut("MISSINGACCT");
            this.bpxAccount.requestFocusInWindow();
        }
        if (this.curSchema.getNumber().trim().length() == 0) {
            this.breakOut("MISSINGNUM");
            this.txtSchemaNumber.requestFocusInWindow();
        }
        if (this.curSchema.getCurrencyCols().size() == 0) {
            this.breakOut("MISSINGCURCOL");
        }
        Iterator itrCur = this.curSchema.getCurrencyCols().iterator();
        int index = 0;
        while (itrCur.hasNext()) {
            MCLdgSchemeCyInfo curInfo = (MCLdgSchemeCyInfo)itrCur.next();
            String curName = curInfo.getCurrencyColName();
            if (curName == null || curName.trim().length() == 0) {
                this.breakOut("MISSINGCURNAME", new Object[]{curInfo.getCurrency().getNumber()});
                this.tblCurrency.getEditManager().editCellAt(index, this.tblCurrency.getColumnIndex("colName"));
            }
            ++index;
        }
        if (this.curSchema.getAccountCols().size() == 0) {
            this.breakOut("MISSINGDETAILACCTCOL");
        }
        Iterator itrAcct = this.curSchema.getAccountCols().iterator();
        index = 0;
        while (itrAcct.hasNext()) {
            String acctName;
            MCLdgSchemeAcctInfo acctInfo = (MCLdgSchemeAcctInfo)itrAcct.next();
            if (acctInfo.getAccount() == null) {
                this.breakOut("MISSINGDETAILACCT", new Object[]{new Integer(index + 1)});
                this.tblAccount.getEditManager().editCellAt(index, this.tblAccount.getColumnIndex("colNumber"));
            }
            if (acctInfo.getDc() == null) {
                this.breakOut("MISSINGDETAILACCTDC", new Object[]{new Integer(index + 1)});
                this.tblAccount.getEditManager().editCellAt(index, this.tblAccount.getColumnIndex(COL_ACCT_DC));
            }
            if ((acctName = acctInfo.getAccountColName()) == null || acctName.trim().length() == 0) {
                this.breakOut("MISSINGDETAILACCTNAME", new Object[]{new Integer(index + 1)});
                this.tblAccount.getEditManager().editCellAt(index, this.tblAccount.getColumnIndex("colName"));
            }
            ++index;
        }
    }

    private void breakOut(String msgId) throws Exception {
        this.breakOut(msgId, null);
    }

    private void breakOut(String msgId, Object[] param) throws Exception {
        String msg = EASResource.getString((String)RESOURCE_PATH, (String)msgId);
        if (param != null) {
            msg = MessageFormat.format(msg, param);
        }
        MsgBox.showWarning((Component)((Object)this), (String)msg);
        SysUtil.abort();
    }

    private void storeCurSchema() {
        AccountViewInfo acct = (AccountViewInfo)this.bpxAccount.getValue();
        this.curSchema.setAccount(acct);
        this.curSchema.setNumber(this.txtSchemaNumber.getText().trim());
        this.curSchema.setName(this.txtSchemaName.getText());
        if (this.chkConfigByLevel.isSelected()) {
            this.curSchema.setLevel((Integer)this.spnLevel.getValue());
        } else {
            this.curSchema.setLevel(0);
        }
        MCLdgSchemeCyCollection curCol = this.curSchema.getCurrencyCols();
        curCol.clear();
        int count = 1;
        int n = this.tblCurrency.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblCurrency.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(COL_CUR_SEL).getValue())) continue;
            MCLdgSchemeCyInfo curInfo = new MCLdgSchemeCyInfo();
            curCol.add(curInfo);
            curInfo.setSeq(count++);
            curInfo.setCurrency((CurrencyInfo)row.getCell("colNumber").getValue());
            curInfo.setCurrencyColName((String)row.getCell("colName").getValue());
        }
        MCLdgSchemeAcctCollection acctCol = this.curSchema.getAccountCols();
        acctCol.clear();
        count = 1;
        int n2 = this.tblAccount.getRowCount();
        for (int i = 0; i < n2; ++i) {
            IRow row = this.tblAccount.getRow(i);
            AccountViewInfo acctItem = (AccountViewInfo)row.getCell("colNumber").getValue();
            if (acctItem == null) continue;
            MCLdgSchemeAcctInfo acctInfo = new MCLdgSchemeAcctInfo();
            acctCol.add(acctInfo);
            acctInfo.setSeq(count++);
            acctInfo.setDc((BalanceDirectionEnum)row.getCell(COL_ACCT_DC).getValue());
            acctInfo.setAccount(acctItem);
            acctInfo.setAccountColName((String)row.getCell("colName").getValue());
        }
    }

    private void ensureEditorsClosed() throws Exception {
        this.ensureTableEditorsClosed(this.tblCurrency);
        this.ensureTableEditorsClosed(this.tblAccount);
        KeyboardFocusManager fm = FocusManager.getCurrentKeyboardFocusManager();
        fm.clearGlobalFocusOwner();
    }

    private void ensureTableEditorsClosed(KDTable table) throws Exception {
        KDTEditManager em = table.getEditManager();
        if (em.isEditing()) {
            em.stopEditing();
            if (em.isEditing()) {
                SysUtil.abort();
            }
        }
    }

    private void jbInit() {
        this.btnAddLine.setText(null);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnNewSchema.setText(null);
        this.btnNewSchema.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnRemoveSchema.setText(null);
        this.btnRemoveSchema.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSaveSchema.setText(null);
        this.btnSaveSchema.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSaveSchemaAs.setText(null);
        this.btnSaveSchemaAs.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.remove((Component)this.btnAddLine);
        this.remove((Component)this.btnInsertLine);
        this.remove((Component)this.btnRemoveLine);
        this.ctnAccount.addButton((JButton)this.btnAddLine);
        this.ctnAccount.addButton((JButton)this.btnInsertLine);
        this.ctnAccount.addButton((JButton)this.btnRemoveLine);
        this.remove((Component)this.btnNewSchema);
        this.remove((Component)this.btnRemoveSchema);
        this.remove((Component)this.btnSaveSchema);
        this.remove((Component)this.btnSaveSchemaAs);
        KDTreeView.ControlPanel pnl = this.treeSchema.getControlPane();
        pnl.add((Component)this.btnNewSchema);
        pnl.add((Component)this.btnRemoveSchema);
        pnl.add((Component)this.btnSaveSchema);
        pnl.add((Component)this.btnSaveSchemaAs);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnNotUse.setVisible(false);
    }

    private static class SchemaWrapper {
        private MCLdgSchemeInfo schema;

        public SchemaWrapper(MCLdgSchemeInfo schema) {
            this.schema = schema;
        }

        public String toString() {
            return this.schema.toString();
        }

        public MCLdgSchemeInfo getSchema() {
            return this.schema;
        }
    }
}

