/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.ParamEx;
import com.kingdee.eas.fi.gl.client.AbstractParamExUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ParamExUI
extends AbstractParamExUI {
    private static final Logger logger = CoreUIObject.getLogger(ParamExUI.class);
    private List<ParamEx> paramExs = null;
    private List<ParamEx> result = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable.checkParsed();
        this.kDTable.getSelectManager().setSelectMode(1);
        this.kDTable.getColumn("name").getStyleAttributes().setLocked(true);
        this.kDTable.getColumn("def").getStyleAttributes().setLocked(true);
        this.kDTable.getColumn("desc").getStyleAttributes().setLocked(true);
        this.btnDelExParam.setEnabled(true);
        this.btnResetExParam.setEnabled(true);
        Map uiContext = this.getUIContext();
        this.paramExs = (List)uiContext.get("paramExs");
        if (this.paramExs == null) {
            this.paramExs = new ArrayList<ParamEx>();
        }
        this.showParamExs(this.paramExs);
        if (this.paramExs.size() > 0) {
            this.kDTable.getSelectManager().select(0, 0);
        }
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        List<ParamEx> paramExs = this.buildParamExs();
        if (paramExs.size() > 0) {
            this.result = paramExs;
        }
        this.destroyWindow();
    }

    public List<ParamEx> getParamExs() {
        return this.result;
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void showParamExs(List<ParamEx> paramExs) {
        this.kDTable.removeRows();
        this.kDTable.checkParsed();
        for (ParamEx paramEx : paramExs) {
            IRow row = this.kDTable.addRow();
            row.getCell("name").setValue((Object)paramEx.name);
            row.getCell("value").setValue((Object)paramEx.value);
            row.getCell("def").setValue((Object)paramEx.def);
            row.getCell("desc").setValue((Object)paramEx.desc);
        }
    }

    private List<ParamEx> buildParamExs() {
        ArrayList<ParamEx> paramExs = new ArrayList<ParamEx>();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            Object object = row.getCell("name").getValue();
            if (object == null || object.toString().trim().length() <= 0) continue;
            String name = object.toString().trim();
            String value = "";
            object = row.getCell("value").getValue();
            if (object != null) {
                value = object.toString().trim();
            }
            String def = (String)row.getCell("def").getValue();
            String desc = (String)row.getCell("desc").getValue();
            ParamEx paramEx = new ParamEx();
            paramEx.name = name;
            paramEx.value = value;
            paramEx.def = def;
            paramEx.desc = desc;
            paramExs.add(paramEx);
        }
        return paramExs;
    }

    @Override
    public void actionDefault_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        if (rowIndexes.length > 0) {
            this.kDTable.getCell(rowIndexes[0], "value").setValue(this.kDTable.getCell(rowIndexes[0], "def").getValue());
        }
    }

    @Override
    public void actionDefaultAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            row.getCell("value").setValue(row.getCell("def").getValue());
        }
    }

    @Override
    public void actionAddExParam_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kDTable.addRow();
        int cols = this.kDTable.getColumns().size();
        for (int i = 0; i < cols; ++i) {
            row.getCell(i).getStyleAttributes().setLocked(false);
        }
    }

    @Override
    public void actionDelExParam_actionPerformed(ActionEvent e) throws Exception {
        int[] rowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        if (rowIndexes.length > 0 && MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"DEL_EX_PARAM")))) {
            for (int rowIndex : rowIndexes) {
                this.kDTable.removeRow(rowIndex);
            }
        }
    }

    @Override
    public void actionResetExParam_actionPerformed(ActionEvent e) throws Exception {
        Map uiContext = this.getUIContext();
        List defaultParamExs = (List)uiContext.get("defaultParamExs");
        if (defaultParamExs == null || defaultParamExs.size() == 0) {
            return;
        }
        this.showParamExs(defaultParamExs);
    }

    public static List<ParamEx> showMe(Object owner, List<ParamEx> paramExs, List<ParamEx> defaultParamExs) {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"paramExs", paramExs);
        uiContext.put((Object)"defaultParamExs", defaultParamExs);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.ParamExUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            ParamExUI ui = (ParamExUI)uiWindow.getUIObject();
            return ui.getParamExs();
        }
        catch (UIException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

