/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class PeriodSequenceCache {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private PeriodCollection periodCache = new PeriodCollection();
    private CompanyOrgUnitInfo currentFiUnit = SysContext.getSysContext().getCurrentFIUnit();
    private LinkedList periodList = new LinkedList();
    private PeriodInfo firstPeriod;
    private PeriodInfo lastPeriod;
    private Map periodMap = new HashMap();

    PeriodSequenceCache(String firstDate, String lastDate) throws EASBizException, BOSException, ParseException {
        this.periodRangeCounts(firstDate, lastDate);
    }

    public PeriodSequenceCache() {
    }

    public void clear() {
        this.periodCache.clear();
        this.periodList.clear();
        this.firstPeriod = null;
        this.lastPeriod = null;
        this.periodMap.clear();
    }

    public int periodRangeCounts(String firstDate, String lastDate) throws EASBizException, BOSException, ParseException {
        Date lDate;
        Date fDate = SIMPLE_DATE_FORMAT.parse(firstDate);
        if (fDate.after(lDate = SIMPLE_DATE_FORMAT.parse(lastDate))) {
            throw new BOSException("firstDate must be less or equal lastDate");
        }
        this.firstPeriod = this.getPeriodForDate(fDate);
        this.lastPeriod = this.getPeriodForDate(lDate);
        int i = 0;
        if (this.firstPeriod.getNumber() != this.lastPeriod.getNumber()) {
            while (this.firstPeriod.getNumber() != this.lastPeriod.getNumber()) {
                this.firstPeriod = this.getNextPeriod(this.firstPeriod);
                ++i;
            }
        }
        return i;
    }

    public PeriodInfo getPeriodForDate(Date date) throws EASBizException, BOSException {
        int j = this.periodCache.size();
        for (int i = 0; i < j; ++i) {
            PeriodInfo tempInfo = this.periodCache.get(i);
            if (tempInfo == null || date.compareTo(tempInfo.getBeginDate()) < 0 || date.compareTo(tempInfo.getEndDate()) > 0) continue;
            return tempInfo;
        }
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)this.currentFiUnit);
        this.periodCache.add(periodInfo);
        this.periodMap.put(periodInfo.getId().toString(), periodInfo);
        return periodInfo;
    }

    public PeriodInfo getPeriodForDate(String date) throws EASBizException, BOSException, ParseException {
        return this.getPeriodForDate(SIMPLE_DATE_FORMAT.parse(date));
    }

    public PeriodInfo getNextPeriod(PeriodInfo info) throws EASBizException, BOSException {
        int index = this.periodList.indexOf(info);
        if (index > -1 && index < this.periodList.size() - 1) {
            return (PeriodInfo)this.periodList.get(index + 1);
        }
        PeriodInfo nextInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)info);
        this.periodCache.add(nextInfo);
        this.periodMap.put(nextInfo.getId().toString(), nextInfo);
        if (index == -1) {
            this.periodList.addLast(info);
        }
        this.periodList.addLast(nextInfo);
        return nextInfo;
    }

    public PeriodInfo getPeriodForID(String periodID) throws EASBizException, BOSException {
        if (this.periodMap.containsKey(periodID)) {
            return (PeriodInfo)this.periodMap.get(periodID);
        }
        PeriodInfo info = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodID));
        this.periodMap.put(info.getId().toString(), info);
        return info;
    }

    public PeriodInfo getFirstPeriod() {
        return this.firstPeriod;
    }

    public PeriodInfo getLastPeriod() {
        return this.lastPeriod;
    }
}

